/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.simulators.iden;

import com.google.common.base.Preconditions;
import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.opensha.commons.util.FaultUtils;
import org.opensha.sha.earthquake.FocalMechanism;
import org.opensha.sha.simulators.SimulatorElement;
import org.opensha.sha.simulators.SimulatorEvent;
import org.opensha.sha.simulators.iden.AbstractRuptureIdentifier;

public class FocalMechIden
extends AbstractRuptureIdentifier {
    private Collection<Range<Double>> rakeRanges;
    private boolean rakeMatchAverage = false;
    private Collection<Range<Double>> dipRanges;
    private boolean dipMatchAverage = false;
    private Collection<Range<Double>> strikeRanges;
    private boolean strikeMatchAverage = false;
    private HashSet<SimulatorElement> failElems = new HashSet();

    private FocalMechIden() {
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public boolean isMatch(SimulatorEvent event) {
        double avgStrike;
        double avgDip;
        double avgRake;
        ArrayList<SimulatorElement> elems = event.getAllElements();
        ArrayList<Double> moments = null;
        ArrayList<Double> rakes = null;
        ArrayList<Double> dips = null;
        ArrayList<Double> strikes = null;
        if (this.dipRanges != null && this.dipMatchAverage) {
            moments = new ArrayList<Double>();
            dips = new ArrayList<Double>();
        }
        if (this.rakeRanges != null && this.rakeMatchAverage) {
            if (moments == null) {
                moments = new ArrayList();
            }
            rakes = new ArrayList<Double>();
        }
        if (this.strikeRanges != null && this.strikeMatchAverage) {
            if (moments == null) {
                moments = new ArrayList();
            }
            strikes = new ArrayList<Double>();
        }
        double[] slips = null;
        if (moments != null) {
            slips = event.getAllElementSlips();
        }
        for (int i = 0; i < elems.size(); ++i) {
            SimulatorElement elem = elems.get(i);
            if (this.failElems.contains(elem)) {
                return false;
            }
            FocalMechanism mech = elem.getFocalMechanism();
            if (moments != null) {
                moments.add(slips[i] * elem.getArea());
            }
            if (strikes != null) {
                strikes.add(mech.getStrike());
            } else if (!FocalMechIden.matches(mech.getStrike(), this.strikeRanges)) {
                this.failElems.add(elem);
                return false;
            }
            if (dips != null) {
                dips.add(mech.getDip());
            } else if (!FocalMechIden.matches(mech.getDip(), this.dipRanges)) {
                this.failElems.add(elem);
                return false;
            }
            if (rakes != null) {
                rakes.add(mech.getRake());
                continue;
            }
            if (FocalMechIden.matches(mech.getRake(), this.rakeRanges)) continue;
            this.failElems.add(elem);
            return false;
        }
        if (rakes != null && !FocalMechIden.matches(avgRake = FaultUtils.getInRakeRange(FaultUtils.getScaledAngleAverage(moments, rakes)), this.rakeRanges)) {
            return false;
        }
        if (dips != null && !FocalMechIden.matches(avgDip = FaultUtils.getScaledAngleAverage(moments, dips), this.dipRanges)) {
            return false;
        }
        return strikes == null || FocalMechIden.matches(avgStrike = FaultUtils.getScaledAngleAverage(moments, strikes), this.strikeRanges);
    }

    private static boolean matches(double value, Collection<Range<Double>> ranges) {
        if (ranges == null) {
            return true;
        }
        for (Range<Double> range : ranges) {
            if (!range.contains((Comparable)Double.valueOf(value))) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getName() {
        return "Focal Mechanism Identifier";
    }

    public static class Builder {
        private FocalMechIden iden = new FocalMechIden();

        private Builder() {
        }

        public Builder forRake(double rake) {
            return this.forRake(rake, rake);
        }

        public Builder forRake(double minRake, double maxRake) {
            return this.forRake((Range<Double>)Range.closed((Comparable)Double.valueOf(minRake), (Comparable)Double.valueOf(maxRake)));
        }

        public Builder forRake(Range<Double> range) {
            if (this.iden.rakeRanges == null) {
                this.iden.rakeRanges = new ArrayList<Range<Double>>();
            }
            this.iden.rakeRanges.add(range);
            return this;
        }

        public Builder strikeSlip(double tolerance) {
            if (tolerance == 0.0) {
                return this.forRake(0.0).forRake(180.0).forRake(-180.0);
            }
            Preconditions.checkState((tolerance > 0.0 ? 1 : 0) != 0);
            return this.forRake(-180.0, -180.0 + tolerance).forRake(-tolerance, tolerance).forRake(180.0 - tolerance, 180.0);
        }

        public Builder averageRake() {
            this.iden.rakeMatchAverage = true;
            return this;
        }

        public Builder forDip(double dip) {
            return this.forDip(dip, dip);
        }

        public Builder forDip(double minDip, double maxDip) {
            return this.forDip((Range<Double>)Range.closed((Comparable)Double.valueOf(minDip), (Comparable)Double.valueOf(maxDip)));
        }

        public Builder forDip(Range<Double> range) {
            if (this.iden.dipRanges == null) {
                this.iden.dipRanges = new ArrayList<Range<Double>>();
            }
            this.iden.dipRanges.add(range);
            return this;
        }

        public Builder averageDip() {
            this.iden.dipMatchAverage = true;
            return this;
        }

        public Builder forStrike(double dip) {
            return this.forStrike(dip, dip);
        }

        public Builder forStrike(double minDip, double maxDip) {
            return this.forStrike((Range<Double>)Range.closed((Comparable)Double.valueOf(minDip), (Comparable)Double.valueOf(maxDip)));
        }

        public Builder forStrike(Range<Double> range) {
            if (this.iden.strikeRanges == null) {
                this.iden.strikeRanges = new ArrayList<Range<Double>>();
            }
            this.iden.strikeRanges.add(range);
            return this;
        }

        public Builder averageStrike() {
            this.iden.strikeMatchAverage = true;
            return this;
        }

        public FocalMechIden build() {
            Preconditions.checkState((this.iden.dipRanges != null || this.iden.rakeRanges != null || this.iden.strikeRanges != null ? 1 : 0) != 0, (Object)"No criteria provided!");
            return this.iden;
        }
    }
}

