/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.simulators.iden;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.commons.util.IDPairing;
import org.opensha.sha.simulators.SimulatorElement;
import org.opensha.sha.simulators.SimulatorEvent;
import org.opensha.sha.simulators.iden.AbstractRuptureIdentifier;

public class LinearRuptureIden
extends AbstractRuptureIdentifier {
    private double maxDeviation;
    private Map<IDPairing, Double> horzDistanceCache;
    private boolean fractional;
    public static boolean D = false;
    private static final boolean CARTESIAN = true;

    public LinearRuptureIden(double maxDeviation) {
        this(maxDeviation, false);
    }

    public LinearRuptureIden(double maxDeviation, boolean fractional) {
        this(maxDeviation, fractional, new HashMap<IDPairing, Double>());
    }

    public LinearRuptureIden(double maxDeviation, boolean fractional, Map<IDPairing, Double> horzDistanceCache) {
        this.maxDeviation = maxDeviation;
        this.fractional = fractional;
        this.horzDistanceCache = horzDistanceCache;
    }

    @Override
    public boolean isMatch(SimulatorEvent event) {
        ArrayList<SimulatorElement> elems = event.getAllElements();
        if (elems.size() < 3) {
            return true;
        }
        boolean debug = D;
        if (debug) {
            System.out.println("Debugging event " + event.getID() + " with " + elems.size() + " elems");
        }
        SimulatorElement furthest1 = null;
        SimulatorElement furthest2 = null;
        double maxDist = 0.0;
        HashSet<SimulatorElement> skipElems = new HashSet<SimulatorElement>();
        for (int i = 0; i < elems.size(); ++i) {
            SimulatorElement elem1 = elems.get(i);
            if (skipElems.contains(elem1)) continue;
            for (int j = i + 1; j < elems.size(); ++j) {
                SimulatorElement elem2 = elems.get(j);
                if (skipElems.contains(elem2)) continue;
                IDPairing pair = elem1.getID() > elem2.getID() ? new IDPairing(elem2.getID(), elem1.getID()) : new IDPairing(elem1.getID(), elem2.getID());
                Double dist = this.horzDistanceCache.get(pair);
                if (dist == null) {
                    Location l1 = elems.get(i).getCenterLocation();
                    Location l2 = elems.get(j).getCenterLocation();
                    double dLat = l1.getLatitude() - l2.getLatitude();
                    double dLon = l1.getLongitude() - l2.getLongitude();
                    dist = Math.sqrt(dLat * dLat + dLon * dLon);
                    this.horzDistanceCache.put(pair, dist);
                }
                if (dist.floatValue() == 0.0f) {
                    skipElems.add(elem2);
                }
                if (!(dist > maxDist)) continue;
                furthest1 = elems.get(i);
                furthest2 = elems.get(j);
                maxDist = dist;
            }
        }
        maxDist = LocationUtils.horzDistanceFast(furthest1.getCenterLocation(), furthest2.getCenterLocation());
        if (debug) {
            System.out.println("\tMax dist: " + maxDist);
        }
        if (debug) {
            System.out.println("\tElem 1 loc: " + String.valueOf(furthest1.getCenterLocation()));
        }
        if (debug) {
            System.out.println("\tElem 2 loc: " + String.valueOf(furthest2.getCenterLocation()));
        }
        Location loc1 = furthest1.getCenterLocation();
        loc1 = new Location(loc1.getLatitude(), loc1.getLongitude());
        Location loc2 = furthest2.getCenterLocation();
        loc2 = new Location(loc2.getLatitude(), loc2.getLongitude());
        double maxDeviation = this.fractional ? maxDist * this.maxDeviation : this.maxDeviation;
        for (SimulatorElement elem : elems) {
            if (elem == furthest1 || elem == furthest2 || skipElems.contains(elem)) continue;
            Location elemLoc = elem.getCenterLocation();
            elemLoc = new Location(elemLoc.getLatitude(), elemLoc.getLongitude());
            double dist = Math.abs(LocationUtils.distanceToLineFast(loc1, loc2, elemLoc));
            Preconditions.checkState((boolean)Double.isFinite(dist), (String)"Bad dist: %s\n\tLoc1: %s\n\tLoc2: %s\n\tTest Loc: %s", (Object)dist, (Object)loc1, (Object)loc2, (Object)elemLoc);
            if (debug) {
                System.out.println("\t\tElem at " + String.valueOf(elem.getCenterLocation()) + ": " + dist);
            }
            if (!(dist > maxDeviation)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getName() {
        return "Linear Rupture Identifier";
    }
}

