/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.simulators.iden;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.opensha.sha.simulators.SimulatorEvent;
import org.opensha.sha.simulators.iden.RuptureIdentifier;

public class QuietPeriodIdenMatcher
implements RuptureIdentifier {
    private RuptureIdentifier matchIden;
    private double allowedAftershockYears;
    private double quietYears;
    private RuptureIdentifier[] quietMatchIdens;

    public QuietPeriodIdenMatcher(RuptureIdentifier matchIden, double allowedAftershockYears, double quietYears, List<RuptureIdentifier> quietMatchIdens) {
        this(matchIden, allowedAftershockYears, quietYears, quietMatchIdens.toArray(new RuptureIdentifier[0]));
    }

    public QuietPeriodIdenMatcher(RuptureIdentifier matchIden, double allowedAftershockYears, double quietYears, RuptureIdentifier ... quietMatchIdens) {
        this.matchIden = matchIden;
        this.allowedAftershockYears = allowedAftershockYears;
        this.quietYears = quietYears;
        this.quietMatchIdens = quietMatchIdens;
    }

    @Override
    public boolean isMatch(SimulatorEvent event) {
        throw new IllegalStateException("Can't call this on QuietPeriod iden as we don't have the event list");
    }

    @Override
    public <E extends SimulatorEvent> List<E> getMatches(List<E> events) {
        ArrayList matches = Lists.newArrayList(this.matchIden.getMatches(events));
        int origNum = matches.size();
        HashSet<Integer> nonQuiets = new HashSet<Integer>();
        for (RuptureIdentifier quietIden : this.quietMatchIdens) {
            List<E> quietMatches = quietIden.getMatches(events);
            int targetStartIndex = 0;
            block1: for (int i = 0; i < matches.size(); ++i) {
                SimulatorEvent match = (SimulatorEvent)matches.get(i);
                double matchTime = match.getTimeInYears();
                double targetWindowStart = matchTime + this.allowedAftershockYears;
                double targetWindowEnd = matchTime + this.quietYears;
                for (int j = targetStartIndex; j < quietMatches.size(); ++j) {
                    double targetTime = ((SimulatorEvent)quietMatches.get(j)).getTimeInYears();
                    if (targetTime == matchTime) continue;
                    if (targetTime <= targetWindowStart) {
                        targetStartIndex = j;
                        continue;
                    }
                    if (!(targetTime <= targetWindowEnd)) continue block1;
                    nonQuiets.add(i);
                    continue block1;
                }
            }
        }
        ArrayList nonQuietsList = Lists.newArrayList(nonQuiets);
        Collections.sort(nonQuietsList);
        Collections.reverse(nonQuietsList);
        Iterator iterator = nonQuietsList.iterator();
        while (iterator.hasNext()) {
            int ind = (Integer)iterator.next();
            matches.remove(ind);
        }
        System.out.println("Quiet Matcher: " + matches.size() + "/" + origNum + " match with quiet period of " + this.quietYears + " years");
        Collections.sort(matches);
        return matches;
    }

    public double getQuietYears() {
        return this.quietYears;
    }

    public static void main(String[] args) throws IOException {
    }

    @Override
    public String getName() {
        return "Quiet Perdiod: " + this.quietYears + " years, iden=" + this.matchIden.getName();
    }

    @Override
    public boolean furtherMatchesPossible() {
        return true;
    }
}

