/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.simulators.srf;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.util.DataUtils;
import org.opensha.sha.simulators.RSQSimEvent;
import org.opensha.sha.simulators.srf.RSQSimState;
import org.opensha.sha.simulators.srf.RSQSimStateTime;

public class RSQSimEventSlipTimeFunc {
    private Map<Integer, List<RSQSimStateTime>> patchTransitions;
    private Map<Integer, DiscretizedFunc> slipFuncs = new HashMap<Integer, DiscretizedFunc>();
    private Map<Integer, DiscretizedFunc> relSlipFuncs = new HashMap<Integer, DiscretizedFunc>();
    private double minTime;
    private double maxTime;
    private double minVel;
    private double maxVel;
    private RSQSimEventSlipTimeFunc relative = null;

    public RSQSimEventSlipTimeFunc(Map<Integer, List<RSQSimStateTime>> patchTransitions) {
        HashMap<Integer, DiscretizedFunc> slipFuncs = new HashMap<Integer, DiscretizedFunc>();
        HashMap<Integer, DiscretizedFunc> relSlipFuncs = new HashMap<Integer, DiscretizedFunc>();
        double minTime = Double.POSITIVE_INFINITY;
        double maxTime = Double.NEGATIVE_INFINITY;
        double minVel = Double.POSITIVE_INFINITY;
        double maxVel = Double.NEGATIVE_INFINITY;
        float origMinRelTime = Float.POSITIVE_INFINITY;
        for (Integer patchID : patchTransitions.keySet()) {
            for (RSQSimStateTime trans : patchTransitions.get(patchID)) {
                origMinRelTime = Float.min(origMinRelTime, trans.relativeTime);
            }
        }
        Preconditions.checkState((boolean)Float.isFinite(origMinRelTime));
        for (int patchID : patchTransitions.keySet()) {
            List<RSQSimStateTime> patchTrans = patchTransitions.get(patchID);
            if (patchTrans.isEmpty()) continue;
            ArbitrarilyDiscretizedFunc slipFunc = new ArbitrarilyDiscretizedFunc();
            ArbitrarilyDiscretizedFunc relSlipFunc = new ArbitrarilyDiscretizedFunc();
            double curSlip = 0.0;
            for (RSQSimStateTime trans : patchTrans) {
                if (trans.state != RSQSimState.EARTHQUAKE_SLIP) continue;
                slipFunc.set(trans.absoluteTime, curSlip);
                float relativeTime = trans.relativeTime;
                if (origMinRelTime > 0.0f) {
                    relativeTime -= origMinRelTime;
                }
                Preconditions.checkState((boolean)Double.isFinite(relativeTime));
                relSlipFunc.set(relativeTime, curSlip);
                double slipVel = trans.velocity;
                minVel = Math.min(minVel, slipVel);
                maxVel = Math.max(maxVel, slipVel);
                Preconditions.checkState((boolean)trans.hasDuration(), (Object)"EQ slip and we don't have a duration!");
                double slip = slipVel * trans.getDuration();
                slipFunc.set(trans.absoluteTime + trans.getDuration(), curSlip += slip);
                relSlipFunc.set((double)relativeTime + trans.getDuration(), curSlip);
            }
            slipFuncs.put(patchID, slipFunc);
            relSlipFuncs.put(patchID, relSlipFunc);
            minTime = Math.min(minTime, slipFunc.getMinX());
            maxTime = Math.max(maxTime, slipFunc.getMaxX());
        }
        this.init(patchTransitions, slipFuncs, relSlipFuncs, minTime, maxTime, minVel, maxVel);
    }

    private RSQSimEventSlipTimeFunc(Map<Integer, List<RSQSimStateTime>> patchTransitions, Map<Integer, DiscretizedFunc> slipFuncs, Map<Integer, DiscretizedFunc> relSlipFuncs, double minTime, double maxTime, double minVel, double maxVel) {
        this.init(patchTransitions, slipFuncs, relSlipFuncs, minTime, maxTime, minVel, maxVel);
    }

    private void init(Map<Integer, List<RSQSimStateTime>> patchTransitions, Map<Integer, DiscretizedFunc> slipFuncs, Map<Integer, DiscretizedFunc> relSlipFuncs, double minTime, double maxTime, double minVel, double maxVel) {
        this.patchTransitions = patchTransitions;
        this.slipFuncs = slipFuncs;
        this.relSlipFuncs = relSlipFuncs;
        this.minTime = minTime;
        this.maxTime = maxTime;
        this.minVel = minVel;
        this.maxVel = maxVel;
    }

    public Set<Integer> getPatchIDs() {
        return this.patchTransitions.keySet();
    }

    public RSQSimStateTime getStateTime(int patchID, double time) {
        if (this.patchTransitions.containsKey(patchID)) {
            for (RSQSimStateTime trans : this.patchTransitions.get(patchID)) {
                if (!(time >= trans.absoluteTime) || !trans.hasDuration() || !(time < trans.absoluteTime + trans.getDuration())) continue;
                return trans;
            }
        }
        return null;
    }

    public RSQSimState getState(int patchID, double time) {
        RSQSimStateTime stateTime = this.getStateTime(patchID, time);
        if (stateTime != null) {
            return stateTime.state;
        }
        return null;
    }

    public List<RSQSimStateTime> getTransitions(int patchID) {
        return this.patchTransitions.get(patchID);
    }

    public DiscretizedFunc getSlipFunc(int patchID) {
        return this.slipFuncs.get(patchID);
    }

    public double getMaxSlipVel() {
        return this.maxVel;
    }

    public double getMinSlipVel() {
        return this.minVel;
    }

    public double getVelocity(RSQSimStateTime stateTime) {
        if (stateTime.state == RSQSimState.EARTHQUAKE_SLIP) {
            return stateTime.velocity;
        }
        return 0.0;
    }

    public double getVelocity(int patchID, double time) {
        if (!this.patchTransitions.containsKey(patchID)) {
            return Double.NaN;
        }
        RSQSimStateTime stateTime = this.getStateTime(patchID, time);
        if (stateTime == null) {
            return 0.0;
        }
        return this.getVelocity(stateTime);
    }

    public double getTimeOfFirstSlip(int patchID) {
        for (RSQSimStateTime trans : this.patchTransitions.get(patchID)) {
            if (trans.state != RSQSimState.EARTHQUAKE_SLIP) continue;
            return trans.absoluteTime;
        }
        return Double.NaN;
    }

    public double getTimeOfLastSlip(int patchID) {
        List<RSQSimStateTime> patchTrans = this.patchTransitions.get(patchID);
        int i = patchTrans.size();
        while (--i >= 0) {
            RSQSimStateTime trans = patchTrans.get(i);
            if (trans.state != RSQSimState.EARTHQUAKE_SLIP) continue;
            return trans.absoluteTime + trans.getDuration();
        }
        return Double.NaN;
    }

    public double getCumulativeEventSlip(int patchID, double time) {
        DiscretizedFunc slipFunc = this.slipFuncs.get(patchID);
        if (slipFunc == null) {
            return Double.NaN;
        }
        if (time < slipFunc.getMinX()) {
            return 0.0;
        }
        if (time > slipFunc.getMaxX()) {
            return slipFunc.getY(slipFunc.size() - 1);
        }
        return slipFunc.getInterpolatedY(time);
    }

    public double getMaxCumulativeSlip() {
        double max = 0.0;
        for (DiscretizedFunc func : this.slipFuncs.values()) {
            max = Math.max(max, func.getMaxY());
        }
        return max;
    }

    DataUtils.MinMaxAveTracker validateTotalSlip(RSQSimEvent event, double pDiffThreshold) {
        int[] patchIDs = event.getAllElementIDs();
        double[] slips = event.getAllElementSlips();
        DataUtils.MinMaxAveTracker pDiffTrack = new DataUtils.MinMaxAveTracker();
        for (int i = 0; i < patchIDs.length; ++i) {
            int patchID = patchIDs[i];
            double expectedSlip = slips[i];
            double calcSlip = this.getCumulativeEventSlip(patchID, Double.POSITIVE_INFINITY);
            if (expectedSlip == 0.0) {
                Preconditions.checkState((calcSlip == 0.0 || Double.isNaN(calcSlip) ? 1 : 0) != 0, (String)"Expected zero slip, calculated %s", (Object)calcSlip);
                continue;
            }
            if (expectedSlip < 1.0E-4) continue;
            double pDiff = DataUtils.getPercentDiff(calcSlip, expectedSlip);
            pDiffTrack.addValue(pDiff);
            Preconditions.checkState((pDiff <= pDiffThreshold ? 1 : 0) != 0, (String)"Calculated slip is off for patch %s.\n\tExpected: %s\n\tCalculated: %s\n\tDiff: %s\n\tpDiff: %s", (Object[])new Object[]{patchID, expectedSlip, calcSlip, Math.abs(calcSlip - expectedSlip), pDiff});
        }
        return pDiffTrack;
    }

    public double getStartTime() {
        return this.minTime;
    }

    public double getEndTime() {
        return this.maxTime;
    }

    public synchronized RSQSimEventSlipTimeFunc asRelativeTimeFunc() {
        if (this.minTime == 0.0) {
            return this;
        }
        if (this.relative == null) {
            float origMinRelTime = Float.POSITIVE_INFINITY;
            for (Integer n : this.patchTransitions.keySet()) {
                for (RSQSimStateTime trans : this.patchTransitions.get(n)) {
                    origMinRelTime = Float.min(origMinRelTime, trans.relativeTime);
                }
            }
            Preconditions.checkState((boolean)Float.isFinite(origMinRelTime));
            HashMap<Integer, List<RSQSimStateTime>> relPatchTransitions = new HashMap<Integer, List<RSQSimStateTime>>();
            for (Integer patchID : this.patchTransitions.keySet()) {
                ArrayList<RSQSimStateTime> relTrans = new ArrayList<RSQSimStateTime>();
                for (RSQSimStateTime trans : this.patchTransitions.get(patchID)) {
                    float relativeTime = trans.relativeTime;
                    if (origMinRelTime > 0.0f) {
                        relativeTime -= origMinRelTime;
                    }
                    RSQSimStateTime rTrans = new RSQSimStateTime(relativeTime, relativeTime, trans.eventID, patchID, trans.state, trans.velocity);
                    if (trans.hasDuration()) {
                        rTrans.setDuration(trans.getDuration());
                    }
                    relTrans.add(rTrans);
                }
                relPatchTransitions.put(patchID, relTrans);
            }
            double d = 0.0;
            for (DiscretizedFunc relSlipFunc : this.relSlipFuncs.values()) {
                d = Math.max(d, relSlipFunc.getMaxX());
            }
            this.relative = new RSQSimEventSlipTimeFunc(relPatchTransitions, this.relSlipFuncs, this.relSlipFuncs, 0.0, d, this.minVel, this.maxVel);
        }
        return this.relative;
    }

    public RSQSimEventSlipTimeFunc getTimeScaledFunc(double timeScalar, boolean scaleVelocities) {
        HashMap<Integer, List<RSQSimStateTime>> scaledPatchTransitions = new HashMap<Integer, List<RSQSimStateTime>>();
        for (Integer patchID : this.patchTransitions.keySet()) {
            List<RSQSimStateTime> patchTransList = this.patchTransitions.get(patchID);
            double patchRelStart = patchTransList.get((int)0).absoluteTime;
            double newPatchRelStart = patchRelStart / timeScalar;
            double offsetForNoScale = patchRelStart - newPatchRelStart;
            ArrayList<RSQSimStateTime> scaledTrans = new ArrayList<RSQSimStateTime>();
            for (RSQSimStateTime trans : patchTransList) {
                double newStart;
                double newRelStart;
                double relStart = trans.relativeTime;
                double duration = trans.hasDuration() ? trans.getDuration() : Double.NaN;
                double slipVel = trans.velocity;
                if (scaleVelocities) {
                    newRelStart = relStart / timeScalar;
                    newStart = this.minTime + newRelStart;
                    duration /= timeScalar;
                    slipVel *= timeScalar;
                } else {
                    newStart = trans.absoluteTime - offsetForNoScale;
                    newRelStart = (double)trans.relativeTime - offsetForNoScale;
                }
                RSQSimStateTime newTrans = new RSQSimStateTime(newStart, (float)newRelStart, trans.eventID, patchID, trans.state, (float)slipVel);
                if (trans.hasDuration()) {
                    newTrans.setDuration(duration);
                }
                scaledTrans.add(newTrans);
            }
            scaledPatchTransitions.put(patchID, scaledTrans);
        }
        return new RSQSimEventSlipTimeFunc(scaledPatchTransitions);
    }
}

