/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.simulators.srf;

import com.google.common.base.Preconditions;
import org.opensha.sha.simulators.srf.RSQSimState;

public class RSQSimStateTime
implements Comparable<RSQSimStateTime> {
    public final double absoluteTime;
    public final float relativeTime;
    public final int eventID;
    public final int patchID;
    public final RSQSimState state;
    public final float velocity;
    private double duration = Double.NaN;

    public RSQSimStateTime(double absoluteTime, float relativeTime, int eventID, int patchID, RSQSimState state, float velocity) {
        this.absoluteTime = absoluteTime;
        this.relativeTime = relativeTime;
        this.eventID = eventID;
        this.patchID = patchID;
        this.state = state;
        this.velocity = velocity;
    }

    public boolean hasDuration() {
        return Double.isFinite(this.duration);
    }

    void setDuration(double duration) {
        Preconditions.checkState((duration >= 0.0 ? 1 : 0) != 0, (String)"bad duration: %s", (Object)duration);
        this.duration = duration;
    }

    void setNextTransition(RSQSimStateTime next) {
        Preconditions.checkState((this.patchID == next.patchID ? 1 : 0) != 0, (String)"patch mismatch: %s != %s", (int)this.patchID, (int)next.patchID);
        Preconditions.checkState((next.absoluteTime >= this.absoluteTime ? 1 : 0) != 0, (String)"next transition is before? %s > %s", (Object)this.absoluteTime, (Object)next.absoluteTime);
        if (this.eventID >= 0 && next.eventID == this.eventID && Double.isFinite(this.relativeTime) && Double.isFinite(next.relativeTime)) {
            this.setDuration(next.relativeTime - this.relativeTime);
        } else {
            this.setDuration(next.absoluteTime - this.absoluteTime);
        }
    }

    public double getDuration() {
        Preconditions.checkState((boolean)Double.isFinite(this.duration), (Object)"duration has not been set for this transition");
        return this.duration;
    }

    public String toString() {
        double endTime = this.absoluteTime + this.duration;
        float relEndTime = (float)((double)this.relativeTime + this.duration);
        String str = "[" + this.absoluteTime + " => " + endTime + " (rel: " + this.relativeTime + " => " + relEndTime + ");";
        str = str + " patch=" + this.patchID + "; event=" + this.eventID + "; " + this.state.name();
        if (this.state == RSQSimState.EARTHQUAKE_SLIP) {
            str = str + "; vel=" + this.velocity;
        }
        return str + "]";
    }

    @Override
    public int compareTo(RSQSimStateTime o) {
        int cmp = Double.compare(this.absoluteTime, o.absoluteTime);
        if (cmp == 0) {
            if (o.eventID != this.eventID) {
                return Integer.compare(this.eventID, o.eventID);
            }
            return Float.compare(this.relativeTime, o.relativeTime);
        }
        return cmp;
    }
}

