/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.simulators.srf;

import com.google.common.base.Preconditions;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import org.opensha.commons.geo.Location;
import org.opensha.sha.earthquake.FocalMechanism;

public class SRF_PointData {
    private Location loc;
    private FocalMechanism focal;
    private double area;
    private double tInit;
    private double dt;
    private double[] slipVels1;
    private double[] slipVels2;
    private double[] slipVels3;
    private double[] cumSlips1;
    private double[] cumSlips2;
    private double[] cumSlips3;
    private double totSlip1;
    private double totSlip2;
    private double totSlip3;
    private double endTime;
    private static final String split_regex = "\\s+";
    private static final String sep = "\t";
    private static final DecimalFormat decimalDF = new DecimalFormat("0.######");
    private static final DecimalFormat expDF = new DecimalFormat("0.00000E00");

    public SRF_PointData(Location loc, FocalMechanism focal, double area, double tInit, double dt, double totSlip1, double[] slipVels1) {
        this(loc, focal, area, tInit, dt, totSlip1, slipVels1, 0.0, new double[0], 0.0, new double[0]);
    }

    public SRF_PointData(Location loc, FocalMechanism focal, double area, double tInit, double dt, double totSlip1, double[] slipVels1, double totSlip2, double[] slipVels2, double totSlip3, double[] slipVels3) {
        this.loc = loc;
        this.focal = focal;
        this.area = area;
        this.tInit = tInit;
        this.dt = dt;
        this.endTime = tInit;
        this.totSlip1 = totSlip1;
        this.slipVels1 = slipVels1;
        this.cumSlips1 = this.buildSlips(slipVels1);
        this.totSlip2 = totSlip2;
        this.slipVels2 = slipVels2;
        this.cumSlips2 = this.buildSlips(slipVels2);
        this.totSlip3 = totSlip3;
        this.slipVels3 = slipVels3;
        this.cumSlips3 = this.buildSlips(slipVels3);
    }

    private double[] buildSlips(double[] slipVels) {
        double[] slips = new double[slipVels.length + 1];
        slips[0] = 0.0;
        for (int i = 1; i < slips.length; ++i) {
            double vel = slipVels[i - 1];
            slips[i] = slips[i - 1] + vel * this.dt;
            double t = this.tInit + (double)i * this.dt;
            this.endTime = Math.max(this.endTime, t);
        }
        return slips;
    }

    public Location getLocation() {
        return this.loc;
    }

    public double getStartTime() {
        return this.tInit;
    }

    public double getEndTime() {
        return this.endTime;
    }

    public double getDuration() {
        return this.getEndTime() - this.getStartTime();
    }

    public double[] getCumulativeSlips1() {
        return this.cumSlips1;
    }

    public double[] getCumulativeSlips2() {
        return this.cumSlips2;
    }

    public double[] getCumulativeSlips3() {
        return this.cumSlips3;
    }

    public double[] getTotalCumulativeSlips() {
        double[] cumSlips = new double[this.cumSlips1.length];
        for (int i = 0; i < cumSlips.length; ++i) {
            double sum = 0.0;
            if (this.cumSlips1 != null && this.cumSlips1.length > i) {
                sum += this.cumSlips1[i] * this.cumSlips1[i];
            }
            if (this.cumSlips2 != null && this.cumSlips2.length > i) {
                sum += this.cumSlips2[i] * this.cumSlips2[i];
            }
            if (this.cumSlips3 != null && this.cumSlips3.length > i) {
                sum += this.cumSlips3[i] * this.cumSlips3[i];
            }
            cumSlips[i] = Math.sqrt(sum);
        }
        return cumSlips;
    }

    public double getTotalSlip() {
        return Math.sqrt(this.totSlip1 * this.totSlip1 + this.totSlip2 * this.totSlip2 + this.totSlip3 * this.totSlip3);
    }

    public double[] getVelocities1() {
        return this.slipVels1;
    }

    public double[] getVelocities2() {
        return this.slipVels2;
    }

    public double[] getVelocities3() {
        return this.slipVels3;
    }

    public double[] getTotalVelocities() {
        double[] cumSlips = this.getTotalCumulativeSlips();
        double[] cumVels = new double[this.slipVels1.length];
        for (int i = 0; i < cumVels.length; ++i) {
            double slip = cumSlips[i + 1] - cumSlips[i];
            cumVels[i] = slip / this.dt;
        }
        return cumVels;
    }

    public double getTime(int index) {
        return this.tInit + this.dt * (double)index;
    }

    public FocalMechanism getFocalMech() {
        return this.focal;
    }

    public double getArea() {
        return this.area;
    }

    public SRF_PointData translated(Location newLocation) {
        return this.translated(newLocation, this.focal);
    }

    public SRF_PointData translated(Location newLocation, FocalMechanism focal) {
        return new SRF_PointData(newLocation, focal, this.area, this.tInit, this.dt, this.totSlip1, this.slipVels1, this.totSlip2, this.slipVels2, this.totSlip3, this.slipVels3);
    }

    private static SRF_PointData fromPointLine(String line, Deque<String> lines, double version) {
        int i;
        String[] split = (line = line.trim()).split(split_regex);
        Preconditions.checkState((split.length >= 8 ? 1 : 0) != 0, (Object)"Bad file line. Should have at least 8 space separated fields");
        int index = 0;
        double lon = Double.parseDouble(split[index++]);
        double lat = Double.parseDouble(split[index++]);
        double dep = Double.parseDouble(split[index++]);
        Location loc = new Location(lat, lon, dep);
        double strike = Double.parseDouble(split[index++]);
        double dip = Double.parseDouble(split[index++]);
        double area = Double.parseDouble(split[index++]);
        area *= 1.0E-4;
        double tInit = Double.parseDouble(split[index++]);
        double dt = Double.parseDouble(split[index++]);
        if (version > 1.0) {
            index += 2;
        }
        if (index == split.length) {
            Preconditions.checkState((!lines.isEmpty() ? 1 : 0) != 0);
            index = 0;
            split = lines.pop().trim().split(split_regex);
            Preconditions.checkState((split.length >= 7 ? 1 : 0) != 0, (Object)"Bad file line. Should have at least 7 space separated fields");
        }
        double rake = Double.parseDouble(split[index++]);
        double totSlip1 = Double.parseDouble(split[index++]) * 0.01;
        int nt1 = Integer.parseInt(split[index++]);
        double totSlip2 = Double.parseDouble(split[index++]) * 0.01;
        int nt2 = Integer.parseInt(split[index++]);
        double totSlip3 = Double.parseDouble(split[index++]) * 0.01;
        int nt3 = Integer.parseInt(split[index++]);
        ArrayList<Double> rawSlips = new ArrayList<Double>();
        int numSlips = nt1 + nt2 + nt3;
        while (rawSlips.size() < numSlips) {
            if (index == split.length) {
                index = 0;
                split = lines.pop().trim().split(split_regex);
                Preconditions.checkState((split.length > 0 ? 1 : 0) != 0, (Object)"Bad file line.");
            }
            rawSlips.add(Double.parseDouble(split[index++]) * 0.01);
        }
        double[] slipVels1 = new double[nt1];
        double[] slipVels2 = new double[nt2];
        double[] slipVels3 = new double[nt3];
        for (i = 0; i < nt1; ++i) {
            slipVels1[i] = (Double)rawSlips.remove(0);
        }
        for (i = 0; i < nt2; ++i) {
            slipVels2[i] = (Double)rawSlips.remove(0);
        }
        for (i = 0; i < nt3; ++i) {
            slipVels3[i] = (Double)rawSlips.remove(0);
        }
        Preconditions.checkState((index == split.length ? 1 : 0) != 0, (String)"Unxpected number values. Expected %s, encountered %s", (int)index, (int)split.length);
        FocalMechanism focal = new FocalMechanism(strike, dip, rake);
        return new SRF_PointData(loc, focal, area, tInit, dt, totSlip1, slipVels1, totSlip2, slipVels2, totSlip3, slipVels3);
    }

    public static List<SRF_PointData> readSRF(File srfFile) throws IOException {
        int numPoints = -1;
        ArrayList<SRF_PointData> points = new ArrayList<SRF_PointData>();
        double version = -1.0;
        ArrayDeque<String> lines = new ArrayDeque<String>(Files.readLines((File)srfFile, (Charset)Charset.defaultCharset()));
        while (!lines.isEmpty()) {
            String line = (String)lines.pop();
            if ((line = line.trim()).isEmpty()) continue;
            if (version < 0.0) {
                version = Double.parseDouble(line);
                Preconditions.checkState((version > 0.0 ? 1 : 0) != 0);
                continue;
            }
            if (line.startsWith("POINTS")) {
                Preconditions.checkState((numPoints < 0 ? 1 : 0) != 0, (Object)"Duplicate POINTS line");
                numPoints = Integer.parseInt(line.split(" ")[1]);
                Preconditions.checkState((numPoints > 0 ? 1 : 0) != 0, (String)"Bad num points: %s", (int)numPoints);
                continue;
            }
            if (numPoints <= 0) continue;
            points.add(SRF_PointData.fromPointLine(line, lines, version));
        }
        Preconditions.checkState((numPoints == points.size() ? 1 : 0) != 0, (String)"Expected %s points, encountered %s", (int)numPoints, (int)points.size());
        return points;
    }

    public static void writeSRF(File srfFile, List<SRF_PointData> points, double version) throws IOException {
        FileWriter fw = new FileWriter(srfFile);
        SRF_PointData.writeSRF(fw, points, version);
        fw.close();
    }

    public static void writeSRF(Writer fw, List<SRF_PointData> points, double version) throws IOException {
        Preconditions.checkState((version >= 1.0 && version <= 2.0 ? 1 : 0) != 0, (Object)"Can only write SRF version 1.0 and 2.0");
        fw.write((float)version + "\n");
        fw.write("POINTS " + points.size() + "\n");
        for (SRF_PointData point : points) {
            StringBuilder str = new StringBuilder();
            str.append(decimalDF.format(point.loc.getLongitude())).append(sep);
            str.append(decimalDF.format(point.loc.getLatitude())).append(sep);
            str.append(expDF.format(point.loc.getDepth())).append(sep);
            str.append(decimalDF.format(point.focal.getStrike())).append(sep);
            str.append(decimalDF.format(point.focal.getDip())).append(sep);
            str.append(expDF.format(point.area * 10000.0)).append(sep);
            str.append(decimalDF.format(point.tInit)).append(sep);
            str.append(expDF.format(point.dt)).append(sep);
            if (version > 1.0) {
                str.append("-1").append(sep);
                str.append("-1").append(sep);
            }
            str.append("\n");
            str.append(decimalDF.format(point.focal.getRake())).append(sep);
            str.append(decimalDF.format(point.totSlip1 * 100.0)).append(sep);
            str.append(point.slipVels1.length).append(sep);
            str.append(decimalDF.format(point.totSlip2 * 100.0)).append(sep);
            str.append(point.slipVels2.length).append(sep);
            str.append(decimalDF.format(point.totSlip3 * 100.0)).append(sep);
            str.append(point.slipVels3.length);
            double[] allSlips = new double[point.slipVels1.length + point.slipVels2.length + point.slipVels3.length];
            if (point.slipVels1.length > 0) {
                System.arraycopy(point.slipVels1, 0, allSlips, 0, point.slipVels1.length);
            }
            if (point.slipVels2.length > 0) {
                System.arraycopy(point.slipVels2, 0, allSlips, point.slipVels1.length, point.slipVels2.length);
            }
            if (point.slipVels3.length > 0) {
                System.arraycopy(point.slipVels3, 0, allSlips, point.slipVels1.length + point.slipVels2.length, point.slipVels3.length);
            }
            for (int i = 0; i < allSlips.length; ++i) {
                if (i % 6 == 0) {
                    str.append("\n");
                }
                str.append(sep).append(expDF.format(allSlips[i] * 100.0));
            }
            str.append("\n");
            fw.write(str.toString());
        }
        fw.flush();
    }

    public static void main(String[] args) throws IOException {
        File srfFile = new File("/home/kevin/Simulators/srfs/UCERF3.D3.1.1km.tri.2.adjSigma3.380-480kyrs.event11650379.srf");
        SRF_PointData.readSRF(srfFile);
    }
}

