/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.simulators.srf;

import com.google.common.base.Stopwatch;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.opensha.sha.simulators.RSQSimEvent;
import org.opensha.sha.simulators.SimulatorElement;
import org.opensha.sha.simulators.parsers.RSQSimFileReader;
import org.opensha.sha.simulators.srf.RSQSimStateTime;
import org.opensha.sha.simulators.srf.RSQSimStateTransitionFileReader;

class TransSpeedTest {
    TransSpeedTest() {
    }

    public static void main(String[] args) throws IOException {
        File dir = new File("/home/kevin/Simulators/catalogs/bruce/rundir4950");
        File geomFile = new File(dir, "zfault_Deepen.in");
        File transFile = new File(dir, "transV..out");
        List<SimulatorElement> elements = RSQSimFileReader.readGeometryFile(geomFile, 11, 'N');
        System.out.println("Reading events...");
        List<RSQSimEvent> events = RSQSimFileReader.readEventsFile(dir, elements);
        System.out.println("Read " + events.size() + " events");
        RSQSimStateTransitionFileReader transReader = new RSQSimStateTransitionFileReader(transFile, elements);
        transReader.setQuiet(true);
        if (transReader.getVersion() == RSQSimStateTransitionFileReader.TransVersion.ORIGINAL) {
            HashMap<Integer, Double> velMap = new HashMap<Integer, Double>();
            for (SimulatorElement elem : elements) {
                velMap.put(elem.getID(), 1.0);
            }
            transReader.setPatchFixedVelocities(velMap);
        }
        Stopwatch iterateWatch = Stopwatch.createStarted();
        long numTrans = 0L;
        System.out.println("Iterating...");
        for (RSQSimStateTime trans : transReader.getTransitions(0.0, Double.POSITIVE_INFINITY)) {
            ++numTrans;
        }
        iterateWatch.stop();
        double iterateSecs = (double)iterateWatch.elapsed(TimeUnit.MILLISECONDS) / 1000.0;
        System.out.println("Iterated through " + numTrans + " transitions in " + iterateSecs + " seconds");
        double transPerSec = (double)numTrans / iterateSecs;
        System.out.println("\trate: " + (float)transPerSec + " trans/sec");
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        System.out.println("Event-iterating");
        Stopwatch eventWatch = Stopwatch.createStarted();
        long numEventTrans = 0L;
        for (int i = 0; i < events.size(); ++i) {
            RSQSimEvent event = events.get(i);
            ArrayList<RSQSimStateTime> transList = new ArrayList<RSQSimStateTime>();
            transReader.getTransitions(event, transList);
            numEventTrans += (long)transList.size();
            if (i % 10000 != 0) continue;
            double eventSecs = (double)eventWatch.elapsed(TimeUnit.MILLISECONDS) / 1000.0;
            System.out.println("Event " + i + " at " + eventSecs);
        }
        eventWatch.stop();
        double eventSecs = (double)eventWatch.elapsed(TimeUnit.MILLISECONDS) / 1000.0;
        System.out.println("Loaded transitions for " + events.size() + " events (" + numEventTrans + " transitions) in " + eventSecs + " seconds");
        double eventsPerSec = (double)events.size() / eventSecs;
        System.out.println("\trate: " + (float)eventsPerSec + " events/sec");
        double eventsTransPerSec = (double)numEventTrans / eventSecs;
        System.out.println("\trate: " + (float)eventsTransPerSec + " eventTrans/sec");
    }
}

