/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.simulators.stiffness;

import com.google.common.io.Files;
import com.google.common.io.LittleEndianDataInputStream;
import java.awt.Color;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.commons.math3.ml.distance.EuclideanDistance;
import org.jfree.data.Range;
import org.opensha.commons.data.function.DefaultXY_DataSet;
import org.opensha.commons.gui.plot.HeadlessGraphPanel;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.gui.plot.PlotSpec;
import org.opensha.commons.gui.plot.PlotSymbol;
import org.opensha.commons.util.DataUtils;
import org.opensha.sha.earthquake.FocalMechanism;
import org.opensha.sha.simulators.stiffness.StiffnessCalc;

public class StiffnessVerify {
    public static void main(String[] args) throws IOException {
        File refDir = new File("/home/kevin/Simulators/catalogs/stiffness");
        File fltFile = new File(refDir, "ALLCAL2_Geometry.flt");
        File sigFile = new File(refDir, "Ksigma.stiffness.out");
        File tauFile = new File(refDir, "Ktau.stiffness.out");
        double lambda = 30000.0;
        double mu = 30000.0;
        ArrayList<StiffnessCalc.Patch> patches = new ArrayList<StiffnessCalc.Patch>();
        for (String line : Files.readLines((File)fltFile, (Charset)Charset.defaultCharset())) {
            if ((line = line.trim()).startsWith("#") || line.isEmpty()) continue;
            StringTokenizer tok = new StringTokenizer(line);
            double x = Double.parseDouble(tok.nextToken());
            double y = Double.parseDouble(tok.nextToken());
            double z = Double.parseDouble(tok.nextToken());
            double l = Double.parseDouble(tok.nextToken());
            double w = Double.parseDouble(tok.nextToken());
            double strike = Double.parseDouble(tok.nextToken());
            double dip = Double.parseDouble(tok.nextToken());
            double rake = Double.parseDouble(tok.nextToken());
            FocalMechanism focalMechanism = new FocalMechanism(strike, dip, rake);
            double[] center = new double[]{x, y, z};
            patches.add(new StiffnessCalc.Patch(center, l, w, focalMechanism));
        }
        System.out.println("Loaded " + patches.size() + " patches");
        LittleEndianDataInputStream sigIn = new LittleEndianDataInputStream((InputStream)new BufferedInputStream(new FileInputStream(sigFile)));
        LittleEndianDataInputStream tauIn = new LittleEndianDataInputStream((InputStream)new BufferedInputStream(new FileInputStream(tauFile)));
        double closeDist = 10000.0;
        DefaultXY_DataSet closeTauScatter = new DefaultXY_DataSet();
        DefaultXY_DataSet closeSigmaScatter = new DefaultXY_DataSet();
        DiffTrack sigDiffTrack = new DiffTrack("Sigma", new Range(1.0E-8, 10.0));
        DiffTrack tauDiffTrack = new DiffTrack("Tau", new Range(1.0E-6, 100.0));
        long count = 0L;
        int numSingular = 0;
        EuclideanDistance distCalc = new EuclideanDistance();
        for (int i = 0; i < patches.size(); ++i) {
            StiffnessCalc.Patch receiver = (StiffnessCalc.Patch)patches.get(i);
            for (int j = 0; j < patches.size(); ++j) {
                StiffnessCalc.Patch source = (StiffnessCalc.Patch)patches.get(j);
                ++count;
                double[] stiffness = StiffnessCalc.calcStiffness(lambda, mu, source, receiver);
                double rsSig = sigIn.readDouble();
                double rsTau = tauIn.readDouble();
                if (stiffness == null) {
                    ++numSingular;
                    continue;
                }
                sigDiffTrack.add(stiffness[0], rsSig);
                tauDiffTrack.add(stiffness[1], rsTau);
                double dist = distCalc.compute(receiver.center, source.center);
                if (!(dist <= closeDist)) continue;
                closeSigmaScatter.set(Math.abs(rsSig), Math.abs(stiffness[0]));
                closeTauScatter.set(Math.abs(rsTau), Math.abs(stiffness[1]));
            }
            if (i % 100 != 0) continue;
            System.out.println("Done with patch " + i + " (" + count + " calculations, " + closeSigmaScatter.size() + " close)");
            sigDiffTrack.print();
            tauDiffTrack.print();
        }
        System.out.println("Done with all (" + count + " calculations, " + numSingular + " singular)");
        sigDiffTrack.print();
        tauDiffTrack.print();
        sigIn.close();
        tauIn.close();
        System.out.println("Plotting sigma...");
        StiffnessVerify.plotCloseScatter(refDir, "sigma_close_scatter", true, closeDist, closeSigmaScatter);
        System.out.println("Plotting tau...");
        StiffnessVerify.plotCloseScatter(refDir, "tau_close_scatter", false, closeDist, closeTauScatter);
        System.out.println("DONE");
    }

    private static boolean signDiff(double val1, double val2) {
        return val1 > 0.0 && val2 < 0.0 || val1 < 0.0 && val2 > 0.0;
    }

    private static void plotCloseScatter(File outputDir, String prefix, boolean sigma, double dist, DefaultXY_DataSet xy) throws IOException {
        Range range = new Range(1.0E-16, 1000.0);
        ArrayList<DefaultXY_DataSet> funcs = new ArrayList<DefaultXY_DataSet>();
        ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
        funcs.add(xy);
        chars.add(new PlotCurveCharacterstics(PlotSymbol.CROSS, 2.0f, Color.BLACK));
        DefaultXY_DataSet line = new DefaultXY_DataSet();
        line.set(range.getLowerBound(), range.getLowerBound());
        line.set(range.getUpperBound(), range.getUpperBound());
        funcs.add(line);
        chars.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 2.0f, Color.GRAY));
        String value = sigma ? "\u0394Sigma (MPa)" : "\u0394Tau (MPa)";
        PlotSpec spec = new PlotSpec(funcs, chars, value + " Comparison, R<" + (int)dist + "m", "|RSQSim " + value + "|", "|OpenSHA " + value + "|");
        HeadlessGraphPanel gp = new HeadlessGraphPanel();
        gp.setBackgroundColor(Color.WHITE);
        gp.setTickLabelFontSize(18);
        gp.setAxisLabelFontSize(20);
        gp.setPlotLabelFontSize(21);
        File pngFile = new File(outputDir, prefix + ".png");
        gp.drawGraphPanel(spec, true, true, range, range);
        gp.getChartPanel().setSize(800, 700);
        gp.saveAsPNG(pngFile.getAbsolutePath());
    }

    private static class DiffTrack {
        DataUtils.MinMaxAveTracker allDiffs = new DataUtils.MinMaxAveTracker();
        DataUtils.MinMaxAveTracker allPDiffs = new DataUtils.MinMaxAveTracker();
        Range normalRange;
        DataUtils.MinMaxAveTracker normalDiffs = new DataUtils.MinMaxAveTracker();
        DataUtils.MinMaxAveTracker normalPDiffs = new DataUtils.MinMaxAveTracker();
        int allSignErrors;
        int normalSignErrors;
        double maxSignError = 0.0;
        private String name;

        public DiffTrack(String name, Range normalRange) {
            this.name = name;
            this.normalRange = normalRange;
        }

        public void add(double test, double target) {
            boolean normal = this.normalRange.contains(Math.abs(test)) || this.normalRange.contains(Math.abs(target));
            double diff = Math.abs(test - target);
            double pDiff = DataUtils.getPercentDiff(test, target);
            this.allDiffs.addValue(diff);
            this.allPDiffs.addValue(pDiff);
            if (normal) {
                this.normalDiffs.addValue(diff);
                this.normalPDiffs.addValue(pDiff);
            }
            if (StiffnessVerify.signDiff(test, target)) {
                ++this.allSignErrors;
                if (normal) {
                    ++this.normalSignErrors;
                }
                this.maxSignError = Math.max(this.maxSignError, Math.max(Math.abs(test), Math.abs(target)));
            }
        }

        public void print() {
            System.out.println("\t" + this.name + ", all values:");
            System.out.println("\t\tdiffs:\t" + String.valueOf(this.allDiffs));
            System.out.println("\t\tpDiffs:\t" + String.valueOf(this.allPDiffs));
            System.out.println("\t\tsign errors:\t" + this.allSignErrors + "\tmax=" + this.maxSignError);
            System.out.println("\t" + this.name + ", normal values:");
            System.out.println("\t\tdiffs:\t" + String.valueOf(this.normalDiffs));
            System.out.println("\t\tpDiffs:\t" + String.valueOf(this.normalPDiffs));
            System.out.println("\t\tsign errors:\t" + this.normalSignErrors);
        }
    }
}

