/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.simulators.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.geo.Location;
import org.opensha.commons.util.FileUtils;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.UCERF2;

public class UCERF2_DataForComparisonFetcher {
    private static final String SEG_RATE_FILE_NAME = "/data/erf/ucerf2/Appendix_C_Table7_091807.xls";
    private static final String PARSONS_PDF_DATA_DIR = "org/opensha/sha/earthquake/rupForecastImpl/WGCEP_UCERF_2_Final/data/ParsonsMRI_PDFs";
    ArrayList<String> parsonsSiteNames;
    ArrayList<String> parsonsPDF_FileNamesPois;
    ArrayList<String> parsonsPDF_FileNamesBPT;
    ArrayList<Location> parsonsSiteLocs;
    ArrayList<Double> parsonsBestPoisEventRates;
    ArrayList<Double> parsonsEventPoisRateSigmas;
    ArrayList<Double> parsonsEventPoisRateLower95s;
    ArrayList<Double> parsonsEventPoisRateUpper95s;
    ArrayList<EvenlyDiscretizedFunc> parsonsPoisPDF_Funcs;
    ArrayList<EvenlyDiscretizedFunc> parsonsBPT0pt01_PDF_Funcs;
    ArrayList<EvenlyDiscretizedFunc> parsonsBPT0pt10_PDF_Funcs;
    ArrayList<EvenlyDiscretizedFunc> parsonsBPT0pt20_PDF_Funcs;
    ArrayList<EvenlyDiscretizedFunc> parsonsBPT0pt30_PDF_Funcs;
    ArrayList<EvenlyDiscretizedFunc> parsonsBPT0pt40_PDF_Funcs;
    ArrayList<EvenlyDiscretizedFunc> parsonsBPT0pt50_PDF_Funcs;
    ArrayList<EvenlyDiscretizedFunc> parsonsBPT0pt60_PDF_Funcs;
    ArrayList<EvenlyDiscretizedFunc> parsonsBPT0pt70_PDF_Funcs;
    ArrayList<EvenlyDiscretizedFunc> parsonsBPT0pt80_PDF_Funcs;
    ArrayList<EvenlyDiscretizedFunc> parsonsBPT0pt90_PDF_Funcs;
    ArrayList<EvenlyDiscretizedFunc> parsonsBPT0pt99_PDF_Funcs;

    public UCERF2_DataForComparisonFetcher() {
        this.readParsonsXLS_File();
        this.readParsonsPDF_Data();
    }

    public static DiscretizedFunc getHalf_UCERF2_ObsIncrMFDs(boolean includeAftershocks) {
        UCERF2 ucerf2 = new UCERF2();
        ArrayList<ArbitrarilyDiscretizedFunc> funcs = new ArrayList<ArbitrarilyDiscretizedFunc>();
        funcs.addAll(UCERF2.getObsIncrMFD(includeAftershocks));
        for (DiscretizedFunc discretizedFunc : funcs) {
            for (int i = 0; i < discretizedFunc.size(); ++i) {
                discretizedFunc.set(i, discretizedFunc.getY(i) * 0.5);
            }
            discretizedFunc.setInfo("  ");
        }
        ((DiscretizedFunc)funcs.get(0)).setName("UCERF2 Observed Incremental MFD Divided by Two (best estimate)");
        return (DiscretizedFunc)funcs.get(0);
    }

    public static ArrayList<DiscretizedFunc> getHalf_UCERF2_ObsCumMFDs(boolean includeAftershocks) {
        ArrayList<DiscretizedFunc> funcs = new ArrayList<DiscretizedFunc>();
        funcs.addAll(UCERF2.getObsCumMFD(includeAftershocks));
        for (DiscretizedFunc func : funcs) {
            for (int i = 0; i < func.size(); ++i) {
                func.set(i, func.getY(i) * 0.5);
            }
            func.setInfo("  ");
        }
        ((DiscretizedFunc)funcs.get(0)).setName("UCERF2 Observed Cumulative MFD Divided by Two (best estimate)");
        ((DiscretizedFunc)funcs.get(1)).setName("UCERF2 Observed Cumulative MFD Divided by Two (lower 95% confidence)");
        ((DiscretizedFunc)funcs.get(2)).setName("UCERF2 Observed Cumulative MFD Divided by Two (upper 95% confidence)");
        return funcs;
    }

    private void readParsonsXLS_File() {
        try {
            POIFSFileSystem fs = new POIFSFileSystem(this.getClass().getClassLoader().getResourceAsStream(SEG_RATE_FILE_NAME));
            HSSFWorkbook wb = new HSSFWorkbook(fs);
            HSSFSheet sheet = wb.getSheetAt(0);
            int lastRowIndex = sheet.getLastRowNum();
            this.parsonsSiteNames = new ArrayList();
            this.parsonsSiteLocs = new ArrayList();
            this.parsonsBestPoisEventRates = new ArrayList();
            this.parsonsEventPoisRateSigmas = new ArrayList();
            this.parsonsEventPoisRateLower95s = new ArrayList();
            this.parsonsEventPoisRateUpper95s = new ArrayList();
            for (int r = 1; r <= lastRowIndex; ++r) {
                HSSFCell cell;
                HSSFRow row = sheet.getRow(r);
                if (row == null || (cell = row.getCell(1)) == null || cell.getCellType() == 1) continue;
                this.parsonsSiteNames.add(row.getCell(0).getStringCellValue().trim());
                double lat = cell.getNumericCellValue();
                double lon = row.getCell(2).getNumericCellValue();
                this.parsonsSiteLocs.add(new Location(lat, lon));
                this.parsonsBestPoisEventRates.add(row.getCell(3).getNumericCellValue());
                this.parsonsEventPoisRateSigmas.add(row.getCell(4).getNumericCellValue());
                this.parsonsEventPoisRateLower95s.add(row.getCell(7).getNumericCellValue());
                this.parsonsEventPoisRateUpper95s.add(row.getCell(8).getNumericCellValue());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ArrayList<String> getParsonsSiteNames() {
        return this.parsonsSiteNames;
    }

    public ArrayList<Location> getParsonsSiteLocs() {
        return this.parsonsSiteLocs;
    }

    public ArrayList<Double> getParsonsBestPoisEventRatess() {
        return this.parsonsBestPoisEventRates;
    }

    public ArrayList<Double> getParsonsEventPoisRateSigmas() {
        return this.parsonsEventPoisRateSigmas;
    }

    public ArrayList<Double> getParsonsEventPoisRateLower95s() {
        return this.parsonsEventPoisRateLower95s;
    }

    public ArrayList<Double> getParsonsEventPoisRateUpper95s() {
        return this.parsonsEventPoisRateUpper95s;
    }

    private void setParsonsPDF_FileNames() {
        this.parsonsPDF_FileNamesPois = new ArrayList();
        this.parsonsPDF_FileNamesBPT = new ArrayList();
        this.parsonsPDF_FileNamesPois.add("poisson/tally1.cal_n.txt");
        this.parsonsPDF_FileNamesPois.add("poisson/tally1.els_glen_pois.txt");
        this.parsonsPDF_FileNamesPois.add("poisson/tally1.els_jul_pois.txt");
        this.parsonsPDF_FileNamesPois.add("poisson/tally1.els_tem_pois.txt");
        this.parsonsPDF_FileNamesPois.add("poisson/tally1.els_whit_pois.txt");
        this.parsonsPDF_FileNamesPois.add("poisson/tally1.gar_c_pois.txt");
        this.parsonsPDF_FileNamesPois.add("poisson/tally1.gar_w_pois.txt");
        this.parsonsPDF_FileNamesPois.add("poisson/tally1.hayn_pois.txt");
        this.parsonsPDF_FileNamesPois.add(null);
        this.parsonsPDF_FileNamesPois.add(null);
        this.parsonsPDF_FileNamesPois.add("poisson/tally1.ssas_pois.txt");
        this.parsonsPDF_FileNamesPois.add("poisson/tally1.ft_ross.txt");
        this.parsonsPDF_FileNamesPois.add("poisson/tally1.san_greg_pois.txt");
        this.parsonsPDF_FileNamesPois.add(null);
        this.parsonsPDF_FileNamesPois.add("poisson/tally1.sjc_sup_pois.txt");
        this.parsonsPDF_FileNamesPois.add("poisson/tally_burro_p_new.txt");
        this.parsonsPDF_FileNamesPois.add(null);
        this.parsonsPDF_FileNamesPois.add("poisson/tally1.new_carrizo.txt");
        this.parsonsPDF_FileNamesPois.add("poisson/tallly1.indio_pois.txt");
        this.parsonsPDF_FileNamesPois.add(null);
        this.parsonsPDF_FileNamesPois.add("poisson/tallly1.pitman_pois.txt");
        this.parsonsPDF_FileNamesPois.add("poisson/tallly1.plunge_pois.txt");
        this.parsonsPDF_FileNamesPois.add("poisson/tallly1.thous_palms_pois.txt");
        this.parsonsPDF_FileNamesPois.add(null);
        this.parsonsPDF_FileNamesBPT.add("bpt/tally_cal_n.txt");
        this.parsonsPDF_FileNamesBPT.add("bpt/tally_els_glen.txt");
        this.parsonsPDF_FileNamesBPT.add("bpt/tally_els_jul.txt");
        this.parsonsPDF_FileNamesBPT.add("bpt/tally_els_tem.txt");
        this.parsonsPDF_FileNamesBPT.add("bpt/tally_els_whit.txt");
        this.parsonsPDF_FileNamesBPT.add("bpt/tally_gar_c.txt");
        this.parsonsPDF_FileNamesBPT.add("bpt/tally_gar_w.txt");
        this.parsonsPDF_FileNamesBPT.add("bpt/tally_hayn.txt");
        this.parsonsPDF_FileNamesBPT.add(null);
        this.parsonsPDF_FileNamesBPT.add(null);
        this.parsonsPDF_FileNamesBPT.add("bpt/tally_ssas.txt");
        this.parsonsPDF_FileNamesBPT.add("bpt/tally_ft_ross.txt");
        this.parsonsPDF_FileNamesBPT.add("bpt/tally_san_greg.txt");
        this.parsonsPDF_FileNamesBPT.add(null);
        this.parsonsPDF_FileNamesBPT.add("bpt/tally_sjc_sup.txt");
        this.parsonsPDF_FileNamesBPT.add("bpt/tally_burro.txt");
        this.parsonsPDF_FileNamesBPT.add(null);
        this.parsonsPDF_FileNamesBPT.add("bpt/tally_carrizo.txt");
        this.parsonsPDF_FileNamesBPT.add("bpt/tally_indio.txt");
        this.parsonsPDF_FileNamesBPT.add(null);
        this.parsonsPDF_FileNamesBPT.add("bpt/tally_pitman.txt");
        this.parsonsPDF_FileNamesBPT.add("bpt/tally_plunge.txt");
        this.parsonsPDF_FileNamesBPT.add("bpt/tally_thous_palms.txt");
        this.parsonsPDF_FileNamesBPT.add(null);
    }

    private void readParsonsPDF_Data() {
        this.setParsonsPDF_FileNames();
        this.parsonsPoisPDF_Funcs = new ArrayList();
        for (int f = 0; f < this.parsonsPDF_FileNamesPois.size(); ++f) {
            String fileName = this.parsonsPDF_FileNamesPois.get(f);
            if (fileName != null) {
                try {
                    String filePath = "org/opensha/sha/earthquake/rupForecastImpl/WGCEP_UCERF_2_Final/data/ParsonsMRI_PDFs/" + fileName;
                    ArrayList<String> fileLines = FileUtils.loadJarFile(filePath);
                    ArrayList<Double> mriList = new ArrayList<Double>();
                    ArrayList<Double> numHitsList = new ArrayList<Double>();
                    double totalNumHits = 0.0;
                    for (String line : fileLines) {
                        StringTokenizer st = new StringTokenizer(line);
                        mriList.add(Double.parseDouble(st.nextToken()));
                        double numHits = Integer.parseInt(st.nextToken());
                        if (numHits == 0.0) {
                            System.out.println("fileName HAD A ZERO!!!");
                        }
                        numHitsList.add(numHits);
                        totalNumHits += numHits;
                    }
                    int num = (int)Math.round(((Double)mriList.get(mriList.size() - 1) - (Double)mriList.get(0)) / 10.0) + 1;
                    EvenlyDiscretizedFunc func = new EvenlyDiscretizedFunc((double)((Double)mriList.get(0)), (Double)mriList.get(mriList.size() - 1), num);
                    func.setTolerance(1.0);
                    for (int i = 0; i < mriList.size(); ++i) {
                        func.set((Double)mriList.get(i), (Double)numHitsList.get(i) / totalNumHits);
                    }
                    func.setName(this.parsonsSiteNames.get(f));
                    func.setInfo("From file: " + fileName);
                    this.parsonsPoisPDF_Funcs.add(func);
                    ArrayList<EvenlyDiscretizedFunc> testList = new ArrayList<EvenlyDiscretizedFunc>();
                    testList.add(func);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                continue;
            }
            this.parsonsPoisPDF_Funcs.add(null);
        }
        this.parsonsBPT0pt01_PDF_Funcs = new ArrayList();
        this.parsonsBPT0pt10_PDF_Funcs = new ArrayList();
        this.parsonsBPT0pt20_PDF_Funcs = new ArrayList();
        this.parsonsBPT0pt30_PDF_Funcs = new ArrayList();
        this.parsonsBPT0pt40_PDF_Funcs = new ArrayList();
        this.parsonsBPT0pt50_PDF_Funcs = new ArrayList();
        this.parsonsBPT0pt60_PDF_Funcs = new ArrayList();
        this.parsonsBPT0pt70_PDF_Funcs = new ArrayList();
        this.parsonsBPT0pt80_PDF_Funcs = new ArrayList();
        this.parsonsBPT0pt90_PDF_Funcs = new ArrayList();
        this.parsonsBPT0pt99_PDF_Funcs = new ArrayList();
        ArrayList<Double> mriList = null;
        ArrayList<Double> numHitsList = null;
        for (int f = 0; f < this.parsonsPDF_FileNamesBPT.size(); ++f) {
            String fileName = this.parsonsPDF_FileNamesBPT.get(f);
            if (fileName != null) {
                try {
                    String filePath = "org/opensha/sha/earthquake/rupForecastImpl/WGCEP_UCERF_2_Final/data/ParsonsMRI_PDFs/" + fileName;
                    ArrayList<String> fileLines = FileUtils.loadJarFile(filePath);
                    double lastCOV = -1.0;
                    ArrayList<Double> covList = new ArrayList<Double>();
                    ArrayList<ArrayList<Double>> mriListList = new ArrayList<ArrayList<Double>>();
                    ArrayList<ArrayList<Double>> numHitsListList = new ArrayList<ArrayList<Double>>();
                    for (String line : fileLines) {
                        StringTokenizer st = new StringTokenizer(line);
                        double cov = Double.parseDouble(st.nextToken());
                        double mri = Double.parseDouble(st.nextToken());
                        double numHits = Integer.parseInt(st.nextToken());
                        if (cov != lastCOV) {
                            covList.add(cov);
                            mriList = new ArrayList<Double>();
                            numHitsList = new ArrayList<Double>();
                            mriListList.add(mriList);
                            numHitsListList.add(numHitsList);
                        }
                        mriList.add(mri);
                        numHitsList.add(numHits);
                        lastCOV = cov;
                    }
                    for (int i = 0; i < covList.size(); ++i) {
                        mriList = (ArrayList<Double>)mriListList.get(i);
                        numHitsList = (ArrayList<Double>)numHitsListList.get(i);
                        double totalNumHits = 0.0;
                        for (Double numHits : numHitsList) {
                            totalNumHits += numHits.doubleValue();
                        }
                        int num = (int)Math.round(((Double)mriList.get(mriList.size() - 1) - (Double)mriList.get(0)) / 10.0) + 1;
                        EvenlyDiscretizedFunc func = new EvenlyDiscretizedFunc((double)((Double)mriList.get(0)), (Double)mriList.get(mriList.size() - 1), num);
                        func.setTolerance(1.0);
                        for (int j = 0; j < mriList.size(); ++j) {
                            func.set((Double)mriList.get(j), (Double)numHitsList.get(j) / totalNumHits);
                        }
                        double cov = (Double)covList.get(i);
                        func.setName(this.parsonsSiteNames.get(f) + " PDF for BPT Model with COV=" + cov);
                        func.setInfo("From file: " + fileName);
                        if (cov == 0.01) {
                            this.parsonsBPT0pt01_PDF_Funcs.add(func);
                            continue;
                        }
                        if (cov == 0.1) {
                            this.parsonsBPT0pt10_PDF_Funcs.add(func);
                            continue;
                        }
                        if (cov == 0.2) {
                            this.parsonsBPT0pt20_PDF_Funcs.add(func);
                            continue;
                        }
                        if (cov == 0.3) {
                            this.parsonsBPT0pt30_PDF_Funcs.add(func);
                            continue;
                        }
                        if (cov == 0.4) {
                            this.parsonsBPT0pt40_PDF_Funcs.add(func);
                            continue;
                        }
                        if (cov == 0.5) {
                            this.parsonsBPT0pt50_PDF_Funcs.add(func);
                            continue;
                        }
                        if (cov == 0.6) {
                            this.parsonsBPT0pt60_PDF_Funcs.add(func);
                            continue;
                        }
                        if (cov == 0.7) {
                            this.parsonsBPT0pt70_PDF_Funcs.add(func);
                            continue;
                        }
                        if (cov == 0.8) {
                            this.parsonsBPT0pt80_PDF_Funcs.add(func);
                            continue;
                        }
                        if (cov == 0.9) {
                            this.parsonsBPT0pt90_PDF_Funcs.add(func);
                            continue;
                        }
                        if (cov == 0.99) {
                            this.parsonsBPT0pt99_PDF_Funcs.add(func);
                            continue;
                        }
                        throw new RuntimeException("COV of " + cov + " not recognized");
                    }
                    if (!covList.contains(0.01)) {
                        this.parsonsBPT0pt01_PDF_Funcs.add(null);
                    }
                    if (!covList.contains(0.1)) {
                        this.parsonsBPT0pt10_PDF_Funcs.add(null);
                    }
                    if (!covList.contains(0.2)) {
                        this.parsonsBPT0pt20_PDF_Funcs.add(null);
                    }
                    if (!covList.contains(0.3)) {
                        this.parsonsBPT0pt30_PDF_Funcs.add(null);
                    }
                    if (!covList.contains(0.4)) {
                        this.parsonsBPT0pt40_PDF_Funcs.add(null);
                    }
                    if (!covList.contains(0.5)) {
                        this.parsonsBPT0pt50_PDF_Funcs.add(null);
                    }
                    if (!covList.contains(0.6)) {
                        this.parsonsBPT0pt60_PDF_Funcs.add(null);
                    }
                    if (!covList.contains(0.7)) {
                        this.parsonsBPT0pt70_PDF_Funcs.add(null);
                    }
                    if (!covList.contains(0.8)) {
                        this.parsonsBPT0pt80_PDF_Funcs.add(null);
                    }
                    if (!covList.contains(0.9)) {
                        this.parsonsBPT0pt90_PDF_Funcs.add(null);
                    }
                    if (covList.contains(0.99)) continue;
                    this.parsonsBPT0pt99_PDF_Funcs.add(null);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                continue;
            }
            this.parsonsBPT0pt01_PDF_Funcs.add(null);
            this.parsonsBPT0pt10_PDF_Funcs.add(null);
            this.parsonsBPT0pt20_PDF_Funcs.add(null);
            this.parsonsBPT0pt30_PDF_Funcs.add(null);
            this.parsonsBPT0pt40_PDF_Funcs.add(null);
            this.parsonsBPT0pt50_PDF_Funcs.add(null);
            this.parsonsBPT0pt60_PDF_Funcs.add(null);
            this.parsonsBPT0pt70_PDF_Funcs.add(null);
            this.parsonsBPT0pt80_PDF_Funcs.add(null);
            this.parsonsBPT0pt90_PDF_Funcs.add(null);
            this.parsonsBPT0pt99_PDF_Funcs.add(null);
        }
        int index = -1;
        for (String siteName : this.parsonsSiteNames) {
            ArrayList<EvenlyDiscretizedFunc> testfuncs = new ArrayList<EvenlyDiscretizedFunc>();
            if (this.parsonsPoisPDF_Funcs.get(++index) != null) {
                testfuncs.add(this.parsonsPoisPDF_Funcs.get(index));
            }
            if (this.parsonsBPT0pt01_PDF_Funcs.get(index) != null) {
                testfuncs.add(this.parsonsBPT0pt01_PDF_Funcs.get(index));
            }
            if (this.parsonsBPT0pt10_PDF_Funcs.get(index) != null) {
                testfuncs.add(this.parsonsBPT0pt10_PDF_Funcs.get(index));
            }
            if (this.parsonsBPT0pt20_PDF_Funcs.get(index) != null) {
                testfuncs.add(this.parsonsBPT0pt20_PDF_Funcs.get(index));
            }
            if (this.parsonsBPT0pt30_PDF_Funcs.get(index) != null) {
                testfuncs.add(this.parsonsBPT0pt30_PDF_Funcs.get(index));
            }
            if (this.parsonsBPT0pt40_PDF_Funcs.get(index) != null) {
                testfuncs.add(this.parsonsBPT0pt40_PDF_Funcs.get(index));
            }
            if (this.parsonsBPT0pt50_PDF_Funcs.get(index) != null) {
                testfuncs.add(this.parsonsBPT0pt50_PDF_Funcs.get(index));
            }
            if (this.parsonsBPT0pt60_PDF_Funcs.get(index) != null) {
                testfuncs.add(this.parsonsBPT0pt60_PDF_Funcs.get(index));
            }
            if (this.parsonsBPT0pt70_PDF_Funcs.get(index) != null) {
                testfuncs.add(this.parsonsBPT0pt70_PDF_Funcs.get(index));
            }
            if (this.parsonsBPT0pt80_PDF_Funcs.get(index) != null) {
                testfuncs.add(this.parsonsBPT0pt80_PDF_Funcs.get(index));
            }
            if (this.parsonsBPT0pt90_PDF_Funcs.get(index) != null) {
                testfuncs.add(this.parsonsBPT0pt90_PDF_Funcs.get(index));
            }
            if (this.parsonsBPT0pt99_PDF_Funcs.get(index) != null) {
                testfuncs.add(this.parsonsBPT0pt99_PDF_Funcs.get(index));
            }
            if (testfuncs.size() <= 0) continue;
        }
    }

    public EvenlyDiscretizedFunc getParsons95PercentPoisFunction(int ithSite) {
        double firstBin = 10L * Math.round(0.1 / this.parsonsEventPoisRateUpper95s.get(ithSite));
        double lastBin = 10L * Math.round(0.1 / this.parsonsEventPoisRateLower95s.get(ithSite));
        double bestBin = 10L * Math.round(0.1 / this.parsonsBestPoisEventRates.get(ithSite));
        int numBin = (int)Math.round((lastBin - firstBin) / 10.0) + 1;
        EvenlyDiscretizedFunc func = new EvenlyDiscretizedFunc(firstBin, lastBin, numBin);
        func.set(firstBin, 0.05);
        func.set(lastBin, 0.05);
        func.set(bestBin, 0.2);
        func.setName("PaleoSeismic Estimate of MRI (and 95% conf bounds) for " + this.getParsonsSiteName(ithSite));
        func.setInfo("(from Appendix C of the UCERF2 report)");
        return func;
    }

    public EvenlyDiscretizedFunc getParsons95PercentPoisFunction(Location loc) {
        int siteIndex = this.getParsonsIndexForLoc(loc);
        if (siteIndex == -1) {
            return null;
        }
        return this.getParsons95PercentPoisFunction(siteIndex);
    }

    public String getParsonsSiteName(int index) {
        return this.parsonsSiteNames.get(index);
    }

    public Location getParsonsSiteLoc(int index) {
        return this.parsonsSiteLocs.get(index);
    }

    public int getParsonsIndexForLoc(Location loc) {
        int index = -1;
        for (int i = 0; i < this.parsonsSiteLocs.size(); ++i) {
            if (!this.parsonsSiteLocs.get(i).equals(loc)) continue;
            index = i;
        }
        return index;
    }

    public ArrayList<EvenlyDiscretizedFunc> getParsonsPois_MRI_PDF_Funcs() {
        return this.parsonsPoisPDF_Funcs;
    }

    public ArrayList<EvenlyDiscretizedFunc> getParsonsBPT_MRI_COV_0pt01_PDF_Funcs() {
        return this.parsonsBPT0pt01_PDF_Funcs;
    }

    public ArrayList<EvenlyDiscretizedFunc> getParsonsBPT_MRI_COV_0pt10_PDF_Funcs() {
        return this.parsonsBPT0pt10_PDF_Funcs;
    }

    public ArrayList<EvenlyDiscretizedFunc> getParsonsBPT_MRI_COV_0pt20_PDF_Funcs() {
        return this.parsonsBPT0pt20_PDF_Funcs;
    }

    public ArrayList<EvenlyDiscretizedFunc> getParsonsBPT_MRI_COV_0pt30_PDF_Funcs() {
        return this.parsonsBPT0pt30_PDF_Funcs;
    }

    public ArrayList<EvenlyDiscretizedFunc> getParsonsBPT_MRI_COV_0pt40_PDF_Funcs() {
        return this.parsonsBPT0pt40_PDF_Funcs;
    }

    public ArrayList<EvenlyDiscretizedFunc> getParsonsBPT_MRI_COV_0pt50_PDF_Funcs() {
        return this.parsonsBPT0pt50_PDF_Funcs;
    }

    public ArrayList<EvenlyDiscretizedFunc> getParsonsBPT_MRI_COV_0pt60_PDF_Funcs() {
        return this.parsonsBPT0pt60_PDF_Funcs;
    }

    public ArrayList<EvenlyDiscretizedFunc> getParsonsBPT_MRI_COV_0pt70_PDF_Funcs() {
        return this.parsonsBPT0pt70_PDF_Funcs;
    }

    public ArrayList<EvenlyDiscretizedFunc> getParsonsBPT_MRI_COV_0pt80_PDF_Funcs() {
        return this.parsonsBPT0pt80_PDF_Funcs;
    }

    public ArrayList<EvenlyDiscretizedFunc> getParsonsBPT_MRI_COV_0pt90_PDF_Funcs() {
        return this.parsonsBPT0pt90_PDF_Funcs;
    }

    public ArrayList<EvenlyDiscretizedFunc> getParsonsBPT_MRI_COV_0pt99_PDF_Funcs() {
        return this.parsonsBPT0pt99_PDF_Funcs;
    }

    private void setParsonsBPT_MRI_statsData() {
    }

    public static void main(String[] args) {
        UCERF2_DataForComparisonFetcher test = new UCERF2_DataForComparisonFetcher();
    }
}

