/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.util;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.text.WordUtils;
import org.apache.commons.math3.util.Precision;
import org.opensha.commons.data.Site;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.sha.imr.param.SiteParams.DepthTo1pt0kmPerSecParam;
import org.opensha.sha.imr.param.SiteParams.DepthTo2pt5kmPerSecParam;
import org.opensha.sha.imr.param.SiteParams.Vs30_Param;
import org.opensha.sha.imr.param.SiteParams.Vs30_TypeParam;

public enum NEHRP_TestCity {
    LOS_ANGELES(34.05, -118.25),
    CENTURY_CITY(34.05, -118.4),
    NORTHRIDGE(34.2, -118.55),
    LONG_BEACH(33.8, -118.2),
    IRVINE(33.65, -117.8),
    RIVERSIDE(33.95, -117.4),
    SAN_BERNARDINO(34.1, -117.3),
    SAN_LUIS_OBISPO(35.3, -120.65),
    SAN_DIEGO(32.7, -117.15),
    SANTA_BARBARA(34.45, -119.7),
    VENTURA(34.3, -119.3),
    OAKLAND(37.8, -122.25),
    CONCORD(37.95, -122.0),
    MONTEREY(36.6, -121.9),
    SACRAMENTO(38.6, -121.5),
    SAN_FRANCISCO(37.75, -122.4),
    SAN_MATEO(37.55, -122.3),
    SAN_JOSE(37.35, -121.9),
    SANTA_CRUZ(36.95, -122.05),
    VALLEJO(38.1, -122.25),
    SANTA_ROSA(38.45, -122.7),
    SEATTLE(47.6, -122.3),
    TACOMA(47.25, -122.45),
    EVERETT(48.0, -122.2),
    PORTLAND(45.5, -122.65),
    SALT_LAKE_CITY(40.75, -111.9),
    BOISE(43.6, -116.2),
    RENO(39.55, -119.8),
    LAS_VEGAS(36.2, -115.15),
    ST_LOUIS(38.6, -90.2),
    MEMPHIS(35.15, -90.05),
    CHARLESTON(32.8, -79.95),
    CHICAGO(41.85, -87.65),
    NEW_YORK(40.75, -74.0);

    private Location loc;

    private NEHRP_TestCity(double lat, double lon) {
        this.loc = new Location(lat, lon);
    }

    public Location location() {
        return this.loc;
    }

    public Location shiftedLocation() {
        double lat = Precision.round((double)this.loc.getLatitude(), (int)1);
        double lon = Precision.round((double)this.loc.getLongitude(), (int)1);
        return new Location(lat, lon, this.loc.getDepth());
    }

    public static EnumSet<NEHRP_TestCity> getCA() {
        return EnumSet.range(LOS_ANGELES, SANTA_ROSA);
    }

    public static EnumSet<NEHRP_TestCity> getShortListCA() {
        return EnumSet.of(LOS_ANGELES, new NEHRP_TestCity[]{RIVERSIDE, SAN_DIEGO, SANTA_BARBARA, OAKLAND, SACRAMENTO, SAN_FRANCISCO, SAN_JOSE});
    }

    public static NEHRP_TestCity forLocation(Location loc) {
        for (NEHRP_TestCity city : NEHRP_TestCity.values()) {
            if (!LocationUtils.areSimilar(city.loc, loc)) continue;
            return city;
        }
        return null;
    }

    public static Map<String, Location> asMap() {
        HashMap cityMap = Maps.newHashMap();
        for (NEHRP_TestCity city : NEHRP_TestCity.values()) {
            cityMap.put(city.name(), city.location());
        }
        return ImmutableMap.copyOf((Map)cityMap);
    }

    public Site getSite() {
        Site s = new Site(this.loc, this.name());
        DepthTo1pt0kmPerSecParam d10p = new DepthTo1pt0kmPerSecParam(null, 0.0, 1000.0, true);
        d10p.setValueAsDefault();
        s.addParameter(d10p);
        DepthTo2pt5kmPerSecParam d25p = new DepthTo2pt5kmPerSecParam(null, 0.0, 1000.0, true);
        d25p.setValueAsDefault();
        s.addParameter(d25p);
        Vs30_Param vs30p = new Vs30_Param(760.0);
        vs30p.setValueAsDefault();
        s.addParameter(vs30p);
        Vs30_TypeParam vs30tp = new Vs30_TypeParam();
        s.addParameter(vs30tp);
        return s;
    }

    public static void main(String[] args) {
        for (NEHRP_TestCity city : NEHRP_TestCity.values()) {
            Location loc = city.location();
            System.out.println(city.name() + "," + Precision.round((double)loc.getLatitude(), (int)2) + "," + Precision.round((double)loc.getLongitude(), (int)2));
            System.out.println();
        }
    }

    public String toString() {
        return WordUtils.capitalizeFully((String)this.name().replace('_', ' '));
    }
}

