/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.util.component;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.sha.imr.param.OtherParams.Component;
import org.opensha.sha.util.component.Boore2010Trans;
import org.opensha.sha.util.component.ComponentTranslation;
import org.opensha.sha.util.component.ReverseComponentTranslation;
import org.opensha.sha.util.component.ShahiBaker2014Trans;

public class ComponentConverter {
    private static Table<Component, Component, ComponentTranslation> transTable = HashBasedTable.create();

    public static boolean isConversionSupported(Component from, Component to) {
        return transTable.contains((Object)from, (Object)to);
    }

    public static ComponentTranslation getConverter(Component from, Component to) {
        return (ComponentTranslation)transTable.get((Object)from, (Object)to);
    }

    public static DiscretizedFunc convert(Component from, Component to, DiscretizedFunc curve, double period) {
        Preconditions.checkState((boolean)ComponentConverter.isConversionSupported(from, to), (Object)"Conversion is not supported");
        return ComponentConverter.getConverter(from, to).convertCurve(curve, period);
    }

    static {
        ShahiBaker2014Trans shahiBaker = new ShahiBaker2014Trans();
        transTable.put((Object)Component.RotD50, (Object)Component.RotD100, (Object)shahiBaker);
        transTable.put((Object)Component.RotD100, (Object)Component.RotD50, (Object)new ReverseComponentTranslation(shahiBaker));
        for (Boore2010Trans trans : Boore2010Trans.getAllConverters()) {
            transTable.put((Object)trans.getFromComponent(), (Object)trans.getToComponent(), (Object)trans);
        }
    }
}

