/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sra.calc;

import Jama.Matrix;
import java.util.ArrayList;
import java.util.Iterator;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.sra.vulnerability.AbstractVulnerability;

public class LossCurveCalculator {
    public ArbitrarilyDiscretizedFunc getLossCurve(ArbitrarilyDiscretizedFunc hazFunc, AbstractVulnerability curVulnModel) {
        ArbitrarilyDiscretizedFunc lossCurve = new ArbitrarilyDiscretizedFunc();
        double[] dfs = curVulnModel.getDEMDFVals();
        Iterator<Double> iter = hazFunc.getYValuesIterator();
        ArrayList<Double> pelist = new ArrayList<Double>();
        while (iter.hasNext()) {
            pelist.add(iter.next());
        }
        pelist = LossCurveCalculator.diffIt(pelist);
        Matrix PEMatrix = new Matrix(pelist.size(), 1);
        for (int i = 0; i < pelist.size(); ++i) {
            PEMatrix.set(i, 0, pelist.get(i).doubleValue());
        }
        Matrix DEMMatrix = new Matrix(curVulnModel.getDEMMatrix());
        Matrix result = DEMMatrix.times(PEMatrix);
        for (int i = 0; i < dfs.length; ++i) {
            lossCurve.set(dfs[i], result.get(i, 0));
        }
        return lossCurve;
    }

    public double getLossExceedance(ArbitrarilyDiscretizedFunc hazFunc, ArbitrarilyDiscretizedFunc fragilityFunc) {
        int numIMLs = fragilityFunc.size();
        if (numIMLs != hazFunc.size()) {
            throw new IllegalArgumentException("X-Values must match for hazard curve and fragility curve.");
        }
        Matrix hazMatrix = new Matrix(1, numIMLs);
        Matrix fragMatrix = new Matrix(numIMLs, 1);
        ArrayList<Double> hazFuncVals = new ArrayList<Double>();
        Iterator<Double> iter = hazFunc.getYValuesIterator();
        while (iter.hasNext()) {
            hazFuncVals.add(iter.next());
        }
        hazFuncVals = LossCurveCalculator.diffIt(hazFuncVals);
        for (int i = 0; i < numIMLs; ++i) {
            hazMatrix.set(0, i, hazFuncVals.get(i).doubleValue());
            fragMatrix.set(i, 0, fragilityFunc.getY(i));
        }
        Matrix result = hazMatrix.times(fragMatrix);
        return result.get(0, 0);
    }

    public static ArrayList<Double> diffIt(ArrayList<Double> vals) {
        ArrayList<Double> rtn = new ArrayList<Double>();
        int i = 1;
        for (i = 1; i < vals.size(); ++i) {
            rtn.add(Math.abs(vals.get(i) - vals.get(i - 1)));
        }
        rtn.add(vals.get(--i));
        return rtn;
    }

    public static void main(String[] args) {
        ArbitrarilyDiscretizedFunc hazFunc = new ArbitrarilyDiscretizedFunc();
        ArbitrarilyDiscretizedFunc fragilityFunc = new ArbitrarilyDiscretizedFunc();
        for (double x = 0.0; x < 3.0; x += 0.1) {
            hazFunc.set(x, Math.random());
            fragilityFunc.set(x, Math.random());
        }
        LossCurveCalculator calc = new LossCurveCalculator();
        calc.getLossExceedance(hazFunc, fragilityFunc);
    }
}

