/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sra.calc.parallel;

import com.google.common.base.Preconditions;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.ListIterator;
import org.opensha.commons.data.Site;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.geo.Location;
import org.opensha.commons.param.Parameter;
import org.opensha.sha.earthquake.ERF;
import org.opensha.sha.imr.IntensityMeasureRelationship;
import org.opensha.sha.imr.ScalarIMR;
import org.opensha.sra.gui.portfolioeal.Asset;
import org.opensha.sra.gui.portfolioeal.CalculationExceptionHandler;

public class ThreadedEALCalc {
    protected List<Asset> assets;
    protected ERF[] erfs;
    protected ScalarIMR[] imrs;
    protected Site[] sites;
    private CalculationExceptionHandler handler;
    protected Deque<Asset> stack;
    private double maxSourceDistance;
    private ArbitrarilyDiscretizedFunc magThreshFunc;

    public ThreadedEALCalc(List<Asset> assets, ERF[] erfs, ScalarIMR[] imrs, CalculationExceptionHandler handler, double maxSourceDistance, ArbitrarilyDiscretizedFunc magThreshFunc) {
        Preconditions.checkNotNull(assets);
        Preconditions.checkArgument((!assets.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)erfs);
        Preconditions.checkNotNull((Object)imrs);
        Preconditions.checkArgument((imrs.length > 0 ? 1 : 0) != 0);
        for (ScalarIMR scalarIMR : imrs) {
            Preconditions.checkNotNull((Object)scalarIMR);
        }
        Preconditions.checkArgument((erfs.length > 0 ? 1 : 0) != 0);
        for (Comparable<IntensityMeasureRelationship> comparable : erfs) {
            Preconditions.checkNotNull(comparable);
        }
        if (erfs.length > 1) {
            Preconditions.checkState((erfs.length == imrs.length ? 1 : 0) != 0);
        }
        this.assets = assets;
        this.erfs = erfs;
        this.imrs = imrs;
        this.handler = handler;
        this.maxSourceDistance = maxSourceDistance;
        this.magThreshFunc = magThreshFunc;
        this.sites = new Site[imrs.length];
        for (int i = 0; i < imrs.length; ++i) {
            ScalarIMR imr = imrs[i];
            this.sites[i] = new Site(new Location(34.0, -118.0));
            ListIterator<Parameter<?>> it = imr.getSiteParamsIterator();
            while (it.hasNext()) {
                this.sites[i].addParameter((Parameter)((Parameter)it.next()).clone());
            }
        }
    }

    public double[] calculateBatch(int[] batch) throws InterruptedException {
        ArrayDeque<Asset> deque = new ArrayDeque<Asset>();
        for (int index : batch) {
            deque.add(this.assets.get(index));
        }
        this.calculateBatch(deque);
        double[] results = new double[batch.length];
        for (int i = 0; i < batch.length; ++i) {
            results[i] = this.assets.get(batch[i]).getAssetEAL();
        }
        return results;
    }

    public synchronized Asset popAsset() {
        try {
            return this.stack.pop();
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void calculateBatch(Deque<Asset> stack) throws InterruptedException {
        this.stack = stack;
        int numThreads = this.imrs.length;
        ArrayList<CalcThread> threads = new ArrayList<CalcThread>();
        for (int i = 0; i < numThreads; ++i) {
            void var5_6;
            if (this.erfs.length > 1) {
                ERF eRF = this.erfs[i];
            } else {
                ERF eRF = this.erfs[0];
            }
            threads.add(new CalcThread((ERF)var5_6, this.imrs[i], this.sites[i]));
        }
        for (Thread thread : threads) {
            thread.start();
        }
        for (Thread thread : threads) {
            thread.join();
        }
    }

    public List<Asset> getAssets() {
        return this.assets;
    }

    public ERF[] getERFs() {
        return this.erfs;
    }

    public ScalarIMR[] getIMRs() {
        return this.imrs;
    }

    private class CalcThread
    extends Thread {
        private ScalarIMR imr;
        private Site site;
        private ERF erf;

        public CalcThread(ERF erf, ScalarIMR imr, Site site) {
            this.imr = imr;
            this.site = site;
            this.erf = erf;
        }

        @Override
        public void run() {
            Asset asset = ThreadedEALCalc.this.popAsset();
            while (asset != null) {
                asset.calculateEAL(this.imr, ThreadedEALCalc.this.maxSourceDistance, ThreadedEALCalc.this.magThreshFunc, this.site, this.erf, ThreadedEALCalc.this.handler);
                asset = ThreadedEALCalc.this.popAsset();
            }
        }
    }
}

