/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sra.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.apache.commons.lang3.SystemUtils;
import org.opensha.commons.data.Site;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.gui.DisclaimerDialog;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.util.ApplicationVersion;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.commons.util.FileUtils;
import org.opensha.commons.util.ServerPrefUtils;
import org.opensha.commons.util.bugReports.BugReport;
import org.opensha.commons.util.bugReports.BugReportDialog;
import org.opensha.commons.util.bugReports.DefaultExceptionHandler;
import org.opensha.sha.calc.HazardCurveCalculator;
import org.opensha.sha.calc.HazardCurveCalculatorAPI;
import org.opensha.sha.calc.params.MaxDistanceParam;
import org.opensha.sha.earthquake.BaseERF;
import org.opensha.sha.earthquake.ERF;
import org.opensha.sha.earthquake.ERF_Ref;
import org.opensha.sha.gui.beans.ERF_GuiBean;
import org.opensha.sha.gui.beans.IMR_GuiBean;
import org.opensha.sha.gui.beans.IMR_GuiBeanAPI;
import org.opensha.sha.gui.beans.Site_GuiBean;
import org.opensha.sha.gui.controls.SetMinSourceSiteDistanceControlPanel;
import org.opensha.sha.gui.controls.SetSiteParamsFromWebServicesControlPanel;
import org.opensha.sha.gui.controls.SitesOfInterestControlPanel;
import org.opensha.sha.gui.infoTools.CalcProgressBar;
import org.opensha.sha.gui.infoTools.IMT_Info;
import org.opensha.sha.imr.ScalarIMR;
import org.opensha.sra.calc.BenefitCostCalculator;
import org.opensha.sra.calc.EALCalculator;
import org.opensha.sra.gui.components.BenefitCostBean;
import org.opensha.sra.vulnerability.AbstractVulnerability;

public class BCR_Application
extends JFrame
implements Runnable,
ParameterChangeListener,
IMR_GuiBeanAPI {
    protected static final String APP_NAME = "Benefit Cost Ratio Application";
    protected static final String APP_SHORT_NAME = "BCR_Application";
    private static final long serialVersionUID = 28858527L;
    private static final String C = "BCR_Application";
    protected static final boolean D = false;
    protected ERF_GuiBean erfGuiBean;
    protected IMR_GuiBean imrGuiBean;
    protected Site_GuiBean siteGuiBean;
    private JLabel openshaImgLabel = new JLabel(new ImageIcon(FileUtils.loadImage("logos/PoweredByOpenSHA_Agua.jpg")));
    private JLabel usgsImgLabel = new JLabel(new ImageIcon(FileUtils.loadImage("logos/usgs_resrisk.gif")));
    private JLabel riskAgoraImgLabel = new JLabel(new ImageIcon(FileUtils.loadImage("logos/AgoraOpenRisk.jpg")));
    protected static final String CONTROL_PANELS = "Control Panels";
    protected static final String DISTANCE_CONTROL = "Max Source-Site Distance";
    protected static final String SITES_OF_INTEREST_CONTROL = "Sites of Interest";
    protected static final String CVM_CONTROL = "Set Site Params from Web Services";
    protected SetMinSourceSiteDistanceControlPanel distanceControlPanel;
    protected SitesOfInterestControlPanel sitesOfInterest;
    protected SetSiteParamsFromWebServicesControlPanel cvmControlPanel;
    private Insets plotInsets = new Insets(4, 10, 4, 4);
    private Border border1;
    protected Insets defaultInsets = new Insets(4, 4, 4, 4);
    protected static final int W = 1100;
    protected static final int H = 770;
    protected ArbitrarilyDiscretizedFunc function;
    protected String TITLE = new String("BCR Calculator");
    private JPanel jPanel1 = new JPanel();
    private Border border2;
    private static final Dimension COMBO_DIM = new Dimension(180, 30);
    private static final Dimension BUTTON_DIM = new Dimension(80, 20);
    private Border border3;
    private Border border4;
    private Border border5;
    private Border border6;
    private Border border7;
    private Border border8;
    JSplitPane topSplitPane = new JSplitPane();
    JButton clearButton = new JButton();
    JPanel buttonPanel = new JPanel();
    JCheckBox progressCheckBox = new JCheckBox();
    JButton addButton = new JButton();
    JComboBox controlComboBox = new JComboBox();
    JSplitPane chartSplit = new JSplitPane();
    JPanel panel = new JPanel();
    private JScrollPane dataScrollPane = new JScrollPane();
    private JTextArea pointsTextArea = new JTextArea();
    GridBagLayout gridBagLayout9 = new GridBagLayout();
    GridBagLayout gridBagLayout8 = new GridBagLayout();
    JSplitPane imrSplitPane = new JSplitPane();
    GridBagLayout gridBagLayout5 = new GridBagLayout();
    JPanel erfTimespanPanel = new JPanel();
    JPanel siteLocPanel = new JPanel();
    JSplitPane controlsSplit = new JSplitPane();
    JTabbedPane paramsTabbedPane = new JTabbedPane();
    JPanel structuralPanel = new JPanel();
    private BenefitCostBean bcbean;
    private JPanel bcPanel;
    GridBagLayout gridBagLayout15 = new GridBagLayout();
    GridBagLayout gridBagLayout13 = new GridBagLayout();
    GridBagLayout gridBagLayout12 = new GridBagLayout();
    JPanel imrPanel = new JPanel();
    GridBagLayout gridBagLayout10 = new GridBagLayout();
    BorderLayout borderLayout1 = new BorderLayout();
    HazardCurveCalculatorAPI calc;
    CalcProgressBar progressClass;
    protected CalcProgressBar startAppProgressClass;
    Timer timer;
    Thread calcThread;
    boolean isHazardCalcDone = false;
    private int computationDisplayCount = 0;
    private DecimalFormat bcrFormat = new DecimalFormat("0.00");
    boolean addData = true;
    protected JButton cancelCalcButton = new JButton();
    private FlowLayout flowLayout1 = new FlowLayout();
    private static ApplicationVersion version;

    public void init() {
        try {
            this.initControlList();
            this.startAppProgressClass = new CalcProgressBar("Starting Application", "Initializing Application .. Please Wait");
            this.jbInit();
            this.initBenefitCostBean();
            this.initIMR_GuiBean();
            this.initSiteGuiBean();
            try {
                this.initERF_GuiBean();
            }
            catch (RuntimeException e) {
                JOptionPane.showMessageDialog(this, "Connection to ERF's failed", "Internet Connection Problem", 0);
                e.printStackTrace();
                this.startAppProgressClass.dispose();
                System.exit(0);
            }
        }
        catch (Exception e) {
            ExceptionUtils.throwAsRuntimeException(e);
        }
        this.startAppProgressClass.dispose();
        ((JPanel)this.getContentPane()).updateUI();
    }

    public static ApplicationVersion getAppVersion() {
        if (version == null) {
            try {
                version = ApplicationVersion.loadBuildVersion();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return version;
    }

    protected void jbInit() throws Exception {
        this.border1 = BorderFactory.createLineBorder(SystemColor.controlText, 1);
        this.border2 = BorderFactory.createLineBorder(SystemColor.controlText, 1);
        this.border3 = BorderFactory.createEmptyBorder();
        this.border4 = BorderFactory.createLineBorder(SystemColor.controlText, 1);
        this.border5 = BorderFactory.createLineBorder(SystemColor.controlText, 1);
        this.border6 = BorderFactory.createBevelBorder(0, Color.white, Color.white, new Color(98, 98, 112), new Color(140, 140, 161));
        this.border7 = BorderFactory.createBevelBorder(0, Color.white, Color.white, new Color(98, 98, 112), new Color(140, 140, 161));
        this.border8 = BorderFactory.createBevelBorder(0, Color.white, Color.white, new Color(98, 98, 112), new Color(140, 140, 161));
        this.getContentPane().setLayout(this.borderLayout1);
        this.jPanel1.setLayout(this.gridBagLayout10);
        this.jPanel1.setBackground(Color.white);
        this.jPanel1.setBorder(this.border4);
        this.jPanel1.setMinimumSize(new Dimension(959, 600));
        this.jPanel1.setPreferredSize(new Dimension(959, 600));
        this.topSplitPane.setOrientation(0);
        this.clearButton.setText("Clear Results");
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BCR_Application.this.clearButton_actionPerformed(e);
            }
        });
        this.buttonPanel.setMinimumSize(new Dimension(568, 20));
        this.buttonPanel.setLayout(this.flowLayout1);
        this.progressCheckBox.setFont(new Font("Dialog", 1, 12));
        this.progressCheckBox.setSelected(true);
        this.progressCheckBox.setText("Show Progress Bar");
        this.addButton.setText("Compute");
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BCR_Application.this.addButton_actionPerformed(e);
            }
        });
        this.controlComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BCR_Application.this.controlComboBox_actionPerformed(e);
            }
        });
        this.panel.setLayout(this.gridBagLayout9);
        this.panel.setBackground(Color.white);
        this.panel.setBorder(this.border5);
        this.panel.setMinimumSize(new Dimension(0, 0));
        this.imrSplitPane.setOrientation(0);
        this.dataScrollPane.setHorizontalScrollBarPolicy(30);
        this.dataScrollPane.setVerticalScrollBarPolicy(20);
        this.dataScrollPane.setBorder(BorderFactory.createEtchedBorder());
        this.dataScrollPane.getViewport().add((Component)this.pointsTextArea, null);
        this.pointsTextArea.setEditable(false);
        this.pointsTextArea.setLineWrap(true);
        this.panel.add((Component)this.dataScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, this.plotInsets, 0, 0));
        this.erfTimespanPanel.setLayout(this.gridBagLayout13);
        this.erfTimespanPanel.setBackground(Color.white);
        this.siteLocPanel.setLayout(this.gridBagLayout8);
        this.siteLocPanel.setBackground(Color.white);
        this.controlsSplit.setDividerSize(5);
        this.structuralPanel.setLayout(this.gridBagLayout5);
        this.structuralPanel.setBackground(Color.white);
        this.structuralPanel.setBorder(this.border2);
        this.structuralPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 10000));
        this.structuralPanel.setMinimumSize(new Dimension(2, 300));
        this.structuralPanel.setPreferredSize(new Dimension(2, 300));
        this.imrPanel.setLayout(this.gridBagLayout15);
        this.imrPanel.setBackground(Color.white);
        this.chartSplit.setLeftComponent(this.panel);
        this.chartSplit.setRightComponent(this.paramsTabbedPane);
        this.cancelCalcButton.setText("Cancel");
        this.cancelCalcButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BCR_Application.this.cancelCalcButton_actionPerformed(e);
            }
        });
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.jPanel1.add((Component)this.topSplitPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(11, 4, 5, 6), 243, 231));
        this.buttonPanel.add((Component)this.controlComboBox, 0);
        this.buttonPanel.add((Component)this.addButton, 1);
        this.buttonPanel.add((Component)this.cancelCalcButton, 2);
        this.buttonPanel.add((Component)this.clearButton, 3);
        this.buttonPanel.add((Component)this.progressCheckBox, 4);
        this.buttonPanel.add((Component)this.usgsImgLabel, 5);
        this.buttonPanel.add((Component)this.openshaImgLabel, 6);
        this.buttonPanel.add((Component)this.riskAgoraImgLabel, 7);
        this.cancelCalcButton.setVisible(false);
        this.topSplitPane.add((Component)this.chartSplit, "top");
        this.chartSplit.add((Component)this.panel, "left");
        this.chartSplit.add((Component)this.paramsTabbedPane, "right");
        this.imrSplitPane.add((Component)this.imrPanel, "top");
        this.imrSplitPane.add((Component)this.siteLocPanel, "bottom");
        this.controlsSplit.add((Component)this.imrSplitPane, "left");
        this.controlsSplit.add((Component)this.erfTimespanPanel, "right");
        this.paramsTabbedPane.add((Component)this.structuralPanel, "Set Structural Type");
        this.paramsTabbedPane.add((Component)this.controlsSplit, "Set Hazard Curve");
        this.topSplitPane.add((Component)this.buttonPanel, "bottom");
        this.topSplitPane.setDividerLocation(590);
        this.imrSplitPane.setDividerLocation(300);
        this.controlsSplit.setDividerLocation(230);
        this.structuralPanel.setLayout(this.gridBagLayout5);
        this.chartSplit.setDividerLocation(590);
        this.setSize(1100, 770);
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dim.width - this.getSize().width) / 2, 0);
        this.setDefaultCloseOperation(3);
        this.setTitle("BCR Application ");
    }

    public static void main(String[] args) {
        new DisclaimerDialog(APP_NAME, "BCR_Application", BCR_Application.getAppVersion());
        DefaultExceptionHandler exp = new DefaultExceptionHandler("BCR_Application", BCR_Application.getAppVersion(), null, null);
        Thread.setDefaultUncaughtExceptionHandler(exp);
        BCR_Application applet = new BCR_Application();
        exp.setApp(applet);
        exp.setParent(applet);
        applet.init();
        applet.setVisible(true);
    }

    void addButton_actionPerformed(ActionEvent e) {
        this.cancelCalcButton.setVisible(true);
        this.addButton();
    }

    @Override
    public void run() {
        try {
            this.computeHazardCurve();
            this.cancelCalcButton.setVisible(false);
            this.calcThread = null;
        }
        catch (Exception e) {
            this.setButtonsEnable(true);
            e.printStackTrace();
            BugReport bug = new BugReport(e, this.getParametersInfoAsString(), "BCR_Application", BCR_Application.getAppVersion(), this);
            BugReportDialog bugDialog = new BugReportDialog((Component)this, bug, false);
            bugDialog.setVisible(true);
        }
    }

    protected void createCalcInstance() {
        try {
            this.calc = new HazardCurveCalculator();
            this.calc.setTrackProgress(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected void addButton() {
        this.setButtonsEnable(false);
        this.imrGuiBean.showWarningMessages(false);
        try {
            this.createCalcInstance();
        }
        catch (Exception e) {
            this.setButtonsEnable(true);
            e.printStackTrace();
            BugReport bug = new BugReport(e, this.getParametersInfoAsString(), "BCR_Application", BCR_Application.getAppVersion(), this);
            BugReportDialog bugDialog = new BugReportDialog((Component)this, bug, true);
            bugDialog.setVisible(true);
        }
        if (this.progressCheckBox.isSelected()) {
            this.calcThread = new Thread(this);
            this.calcThread.start();
            this.timer = new Timer(200, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    try {
                        int totRupture = BCR_Application.this.calc.getTotRuptures();
                        int currRupture = BCR_Application.this.calc.getCurrRuptures();
                        boolean totCurCalculated = true;
                        if (currRupture == -1) {
                            BCR_Application.this.progressClass.setProgressMessage("Please wait, calculating total rutures ....");
                            totCurCalculated = false;
                        }
                        if (!BCR_Application.this.isHazardCalcDone && totCurCalculated) {
                            BCR_Application.this.progressClass.updateProgress(currRupture, totRupture);
                        }
                        if (BCR_Application.this.isHazardCalcDone) {
                            BCR_Application.this.timer.stop();
                            BCR_Application.this.progressClass.dispose();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        } else {
            this.computeHazardCurve();
        }
    }

    protected Component getApplicationComponent() {
        return this;
    }

    void clearButton_actionPerformed(ActionEvent e) {
        this.pointsTextArea.setText("");
        this.computationDisplayCount = 0;
    }

    @Override
    public void parameterChange(ParameterChangeEvent event) {
        String S = "BCR_Application: parameterChange(): ";
        String name1 = event.getParameterName();
        if (name1.equalsIgnoreCase("IMR")) {
            ScalarIMR imr = this.imrGuiBean.getSelectedIMR_Instance();
            this.siteGuiBean.replaceSiteParams(imr.getSiteParamsIterator());
            this.siteGuiBean.validate();
            this.siteGuiBean.repaint();
        }
        if (name1.equalsIgnoreCase(this.bcbean.getCurrentVulnParam().getName())) {
            AbstractVulnerability currentModel = this.bcbean.getVulnModel(0);
            String currentIMT = currentModel.getIMT();
            double currentPeriod = 0.0;
            if (currentIMT.equals("SA")) {
                currentPeriod = currentModel.getPeriod();
            }
            AbstractVulnerability newModel = this.bcbean.getVulnModel(1);
            String newIMT = newModel.getIMT();
            double newPeriod = 0.0;
            if (newIMT.equals("SA")) {
                newPeriod = newModel.getPeriod();
            }
            this.imrGuiBean.setIMRParamListAndEditor(currentIMT, newIMT, currentPeriod, newPeriod);
            ScalarIMR imr = this.imrGuiBean.getSelectedIMR_Instance();
            this.siteGuiBean.replaceSiteParams(imr.getSiteParamsIterator());
            this.siteGuiBean.validate();
            this.siteGuiBean.repaint();
        }
    }

    protected void setButtonsEnable(boolean b) {
        this.addButton.setEnabled(b);
        this.clearButton.setEnabled(b);
        this.progressCheckBox.setEnabled(b);
    }

    protected void computeHazardCurve() {
        this.isHazardCalcDone = false;
        BaseERF forecast = null;
        try {
            this.erfGuiBean.showProgressBar(this.progressCheckBox.isSelected());
            forecast = this.erfGuiBean.getSelectedERF();
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, e.getMessage(), "Incorrect Values", 0);
            this.setButtonsEnable(true);
            return;
        }
        if (this.progressCheckBox.isSelected()) {
            this.progressClass = new CalcProgressBar("Hazard-Curve Calc Status", "Beginning Calculation ");
            this.progressClass.displayProgressBar();
            this.timer.start();
        }
        AbstractVulnerability currentModel = this.bcbean.getVulnModel(0);
        String currentIMT = currentModel.getIMT();
        double currentPeriod = 0.0;
        if (currentIMT.equals("SA")) {
            currentPeriod = currentModel.getPeriod();
        }
        double[] currentIMLs = currentModel.getIMLValues();
        AbstractVulnerability newModel = this.bcbean.getVulnModel(1);
        String newIMT = newModel.getIMT();
        double newPeriod = 0.0;
        if (newIMT.equals("SA")) {
            newPeriod = newModel.getPeriod();
        }
        double[] newIMLs = newModel.getIMLValues();
        ScalarIMR imr = this.imrGuiBean.getSelectedIMR_Instance();
        Site site = this.siteGuiBean.getSite();
        LocationList locs = new LocationList();
        Location loc = site.getLocation();
        locs.add(loc);
        try {
            if (this.distanceControlPanel != null) {
                this.calc.setMaxSourceDistance(this.distanceControlPanel.getDistance());
            }
        }
        catch (Exception e) {
            this.setButtonsEnable(true);
            e.printStackTrace();
            BugReport bug = new BugReport(e, this.getParametersInfoAsString(), "BCR_Application", BCR_Application.getAppVersion(), this);
            BugReportDialog bugDialog = new BugReportDialog((Component)this, bug, false);
            bugDialog.setVisible(true);
        }
        ArbitrarilyDiscretizedFunc currentHazardCurve = this.calcHazardCurve(currentIMT, currentPeriod, currentIMLs, site, forecast, imr);
        ArbitrarilyDiscretizedFunc currentAnnualizedRates = null;
        currentAnnualizedRates = (ArbitrarilyDiscretizedFunc)this.calc.getAnnualizedRates(currentHazardCurve, forecast.getTimeSpan().getDuration());
        ArbitrarilyDiscretizedFunc retroHazardCurve = this.calcHazardCurve(newIMT, newPeriod, newIMLs, site, forecast, imr);
        ArbitrarilyDiscretizedFunc retroAnnualizedRates = null;
        retroAnnualizedRates = (ArbitrarilyDiscretizedFunc)this.calc.getAnnualizedRates(retroHazardCurve, forecast.getTimeSpan().getDuration());
        EALCalculator currentCalc = new EALCalculator((DiscretizedFunc)currentAnnualizedRates, (DiscretizedFunc)currentModel.getVulnerabilityFunc(), this.bcbean.getCurrentReplaceCost());
        double currentEALVal = currentCalc.computeEAL();
        EALCalculator retroCalc = new EALCalculator((DiscretizedFunc)retroAnnualizedRates, (DiscretizedFunc)newModel.getVulnerabilityFunc(), this.bcbean.getRetroReplaceCost());
        double newEALVal = retroCalc.computeEAL();
        BenefitCostCalculator bcCalc = new BenefitCostCalculator(currentEALVal, newEALVal, this.bcbean.getDiscountRate(), this.bcbean.getDesignLife(), this.bcbean.getRetroCost());
        double bcr = bcCalc.computeBCR();
        double benefit = bcCalc.computeBenefit();
        double cost = bcCalc.computeCost();
        this.isHazardCalcDone = true;
        this.displayData(currentHazardCurve, retroHazardCurve, currentEALVal, newEALVal, bcr, benefit, cost);
        this.setButtonsEnable(true);
    }

    private void displayData(ArbitrarilyDiscretizedFunc currentHazardCurve, ArbitrarilyDiscretizedFunc retroHazardCurve, double currentEALVal, double newEALVal, double bcr, double benefit, double cost) {
        ++this.computationDisplayCount;
        Object data = this.pointsTextArea.getText();
        if (this.computationDisplayCount != 1) {
            data = (String)data + "\n\n";
        }
        data = (String)data + "Benefit Cost Ratio Calculation # " + this.computationDisplayCount + "\n";
        data = (String)data + "BCR Desc. = " + this.bcbean.getDescription() + "\n";
        data = (String)data + "Current EAL Val = " + currentEALVal + "\nRetrofitted EAL Val = " + newEALVal + "\n";
        data = (String)data + "Benefit = $" + this.bcrFormat.format(benefit) + "\nBenefit Cost Ratio = " + bcr + "\n";
        data = (String)data + "Curent Hazard Curve\n" + currentHazardCurve.toString();
        data = (String)data + "Retrofitted Hazard Curve\n" + retroHazardCurve.toString() + "\n\n";
        this.pointsTextArea.setText((String)data);
    }

    private ArbitrarilyDiscretizedFunc calcHazardCurve(String imt, double period, double[] imls, Site site, BaseERF forecast, ScalarIMR imr) {
        ArbitrarilyDiscretizedFunc hazFunction = new ArbitrarilyDiscretizedFunc();
        this.initX_Values(hazFunction, imls, imt);
        imr.setIntensityMeasure(imt);
        imr.getParameter("SA Period").setValue(period);
        try {
            try {
                hazFunction = (ArbitrarilyDiscretizedFunc)this.calc.getHazardCurve((DiscretizedFunc)hazFunction, site, imr, (ERF)forecast);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.setButtonsEnable(true);
            }
            hazFunction = this.toggleHazFuncLogValues(hazFunction, imls);
            hazFunction.setInfo(this.getParametersInfoAsString());
        }
        catch (RuntimeException e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Parameters Invalid", 1);
            e.printStackTrace();
            this.setButtonsEnable(true);
            return null;
        }
        return hazFunction;
    }

    private void initX_Values(DiscretizedFunc arb, double[] imls, String imt) {
        IMT_Info imtInfo = new IMT_Info();
        if (IMT_Info.isIMT_LogNormalDist(imt)) {
            for (int i = 0; i < imls.length; ++i) {
                arb.set(Math.log(imls[i]), 1.0);
            }
        } else {
            throw new RuntimeException("Unsupported IMT");
        }
    }

    protected void initIMR_GuiBean() {
        AbstractVulnerability currentModel = this.bcbean.getVulnModel(0);
        String currentIMT = currentModel.getIMT();
        double currentPeriod = 0.0;
        if (currentIMT.equals("SA")) {
            currentPeriod = currentModel.getPeriod();
        }
        AbstractVulnerability newModel = this.bcbean.getVulnModel(1);
        String newIMT = newModel.getIMT();
        double newPeriod = 0.0;
        if (newIMT.equals("SA")) {
            newPeriod = newModel.getPeriod();
        }
        this.imrPanel.removeAll();
        this.imrGuiBean = new IMR_GuiBean(this, currentIMT, newIMT, currentPeriod, newPeriod);
        this.imrGuiBean.getParameterEditor("IMR").getParameter().addParameterChangeListener(this);
        this.imrPanel.add((Component)this.imrGuiBean, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, this.defaultInsets, 0, 0));
        this.imrPanel.updateUI();
    }

    private void initSiteGuiBean() {
        ScalarIMR imr = this.imrGuiBean.getSelectedIMR_Instance();
        this.siteGuiBean = new Site_GuiBean();
        this.siteGuiBean.addSiteParams(imr.getSiteParamsIterator());
        this.siteLocPanel.setLayout(this.gridBagLayout8);
        this.siteLocPanel.add((Component)this.siteGuiBean, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, this.defaultInsets, 0, 0));
        this.siteLocPanel.updateUI();
    }

    protected void initERF_GuiBean() {
        if (this.erfGuiBean == null) {
            try {
                this.erfGuiBean = new ERF_GuiBean(ERF_Ref.get(false, ServerPrefUtils.SERVER_PREFS));
                this.erfGuiBean.getParameter("Eqk Rup Forecast").addParameterChangeListener(this);
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        this.erfTimespanPanel.add((Component)this.erfGuiBean, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, this.defaultInsets, 0, 0));
        this.erfTimespanPanel.updateUI();
    }

    protected void initBenefitCostBean() {
        try {
            this.bcbean = new BenefitCostBean();
        }
        catch (IOException e) {
            ExceptionUtils.throwAsRuntimeException(e);
        }
        this.bcPanel = (JPanel)this.bcbean.getVisualization(0);
        this.bcbean.getRetroVulnParam().addParameterChangeListener(this);
        this.bcbean.getCurrentVulnParam().addParameterChangeListener(this);
        this.structuralPanel.add((Component)this.bcPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.structuralPanel.validate();
        this.structuralPanel.repaint();
    }

    protected void initControlList() {
        this.controlComboBox.addItem(CONTROL_PANELS);
        this.controlComboBox.addItem(DISTANCE_CONTROL);
        this.controlComboBox.addItem(SITES_OF_INTEREST_CONTROL);
        this.controlComboBox.addItem(CVM_CONTROL);
    }

    void controlComboBox_actionPerformed(ActionEvent e) {
        if (this.controlComboBox.getItemCount() <= 0) {
            return;
        }
        String selectedControl = this.controlComboBox.getSelectedItem().toString();
        if (selectedControl.equalsIgnoreCase(DISTANCE_CONTROL)) {
            this.initDistanceControl();
        } else if (selectedControl.equalsIgnoreCase(SITES_OF_INTEREST_CONTROL)) {
            this.initSitesOfInterestControl();
        } else if (selectedControl.equalsIgnoreCase(CVM_CONTROL)) {
            this.initCVMControl();
        }
        this.controlComboBox.setSelectedItem(CONTROL_PANELS);
    }

    private void initDistanceControl() {
        if (this.distanceControlPanel == null) {
            this.distanceControlPanel = new SetMinSourceSiteDistanceControlPanel((Component)this);
        }
        this.distanceControlPanel.pack();
        this.distanceControlPanel.setVisible(true);
    }

    private void initSitesOfInterestControl() {
        if (this.sitesOfInterest == null) {
            this.sitesOfInterest = new SitesOfInterestControlPanel(this, this.siteGuiBean);
        }
        this.sitesOfInterest.getComponent().pack();
        this.sitesOfInterest.getComponent().setVisible(true);
    }

    private void initCVMControl() {
        if (this.cvmControlPanel == null) {
            this.cvmControlPanel = new SetSiteParamsFromWebServicesControlPanel(this, this.imrGuiBean, this.siteGuiBean);
        }
        this.cvmControlPanel.pack();
        this.cvmControlPanel.setVisible(true);
    }

    private ArbitrarilyDiscretizedFunc toggleHazFuncLogValues(ArbitrarilyDiscretizedFunc hazFunc, double[] imls) {
        int numPoints = hazFunc.size();
        ArbitrarilyDiscretizedFunc tempFunc = hazFunc.deepClone();
        hazFunc = new ArbitrarilyDiscretizedFunc();
        for (int i = 0; i < tempFunc.size(); ++i) {
            hazFunc.set(imls[i], tempFunc.getY(i));
        }
        return hazFunc;
    }

    public String getParametersInfoAsString() {
        return this.getMapParametersInfoAsHTML().replaceAll("<br>", SystemUtils.LINE_SEPARATOR);
    }

    public String getMapParametersInfoAsHTML() {
        String imrMetadata = this.imrGuiBean.getVisibleParametersCloned().getParameterListMetadataString();
        double maxSourceSiteDistance = this.distanceControlPanel != null ? this.distanceControlPanel.getDistance() : MaxDistanceParam.DEFAULT.doubleValue();
        return "<br>IMR Param List:<br>---------------<br>" + imrMetadata + "<br><br>Site Param List: <br>----------------<br>" + this.siteGuiBean.getParameterListEditor().getVisibleParametersCloned().getParameterListMetadataString() + "<br><br>Forecast Param List: <br>--------------------<br>" + this.erfGuiBean.getERFParameterList().getParameterListMetadataString() + "<br><br>TimeSpan Param List: <br>--------------------<br>" + this.erfGuiBean.getSelectedERFTimespanGuiBean().getParameterListMetadataString() + "<br><br>Max. Source-Site Distance = " + maxSourceSiteDistance;
    }

    void cancelCalcButton_actionPerformed(ActionEvent e) {
        this.calcThread.stop();
        this.calcThread = null;
        this.erfGuiBean.closeProgressBar();
        if (this.timer != null && this.progressClass != null) {
            this.timer.stop();
            this.timer = null;
            this.progressClass.dispose();
        }
        if (this.calc != null) {
            try {
                this.calc.stopCalc();
                this.calc = null;
            }
            catch (RuntimeException ee) {
                ee.printStackTrace();
                this.setButtonsEnable(true);
                BugReport bug = new BugReport(ee, this.getParametersInfoAsString(), "BCR_Application", BCR_Application.getAppVersion(), this);
                BugReportDialog bugDialog = new BugReportDialog((Component)this, bug, false);
                bugDialog.setVisible(true);
            }
        }
        this.isHazardCalcDone = false;
        this.setButtonsEnable(true);
        this.cancelCalcButton.setVisible(false);
    }

    public ERF_GuiBean getEqkRupForecastGuiBeanInstance() {
        return this.erfGuiBean;
    }

    public Site_GuiBean getSiteGuiBeanInstance() {
        return this.siteGuiBean;
    }

    @Override
    public void updateIM() {
    }

    @Override
    public void updateSiteParams() {
        ScalarIMR imr = this.imrGuiBean.getSelectedIMR_Instance();
        this.siteGuiBean.replaceSiteParams(imr.getSiteParamsIterator());
        this.siteGuiBean.validate();
        this.siteGuiBean.repaint();
    }

    static {
        String osName = System.getProperty("os.name");
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

