/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sra.gui.portfolioeal;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;
import org.opensha.sha.gui.infoTools.CalcProgressBar;
import org.opensha.sra.gui.portfolioeal.Asset;

public class CalcProgressListener
extends Thread
implements ActionListener {
    private Asset asset;
    private Timer timer;
    private CalcProgressBar progressBar;
    private int totalRuptures;
    private int currentRuptures;

    public CalcProgressListener(Asset asset) {
        this.asset = asset;
        this.progressBar = new CalcProgressBar("Hazard-Curve Calc Status", "Beginning Calculation ");
        this.progressBar.displayProgressBar();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.totalRuptures = this.asset.getTotalRuptures();
            this.currentRuptures = this.asset.getCurrentRuptures();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        boolean isCalculationDone = this.asset.isCalculationDone();
        boolean rupturesStarted = false;
        if (this.currentRuptures == -1) {
            this.progressBar.setProgressMessage("Please wait, calculating total rutures for asset ....");
        } else {
            rupturesStarted = true;
        }
        if (rupturesStarted && !isCalculationDone) {
            this.progressBar.updateProgress(this.currentRuptures, this.totalRuptures);
        }
        if (isCalculationDone) {
            this.progressBar.dispose();
            this.timer.stop();
        }
    }

    @Override
    public void run() {
        this.timer = new Timer(150, this);
        this.timer.start();
    }
}

