/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sra.gui.portfolioeal;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Iterator;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.apache.commons.lang3.time.StopWatch;
import org.opensha.commons.data.Site;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.util.CustomFileFilter;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.sha.gui.infoTools.CalcProgressBar;
import org.opensha.sra.gui.portfolioeal.Asset;
import org.opensha.sra.gui.portfolioeal.CalculationExceptionHandler;
import org.opensha.sra.gui.portfolioeal.Portfolio;
import org.opensha.sra.gui.portfolioeal.gui.PortfolioEALCalculatorView;

public class PortfolioEALCalculatorController
implements ActionListener,
ItemListener,
Runnable,
CalculationExceptionHandler {
    public static final String APP_NAME = "Portfolio EAL Application";
    public static final String APP_SHORT_NAME = "PortfolioEAL";
    private double EAL;
    private PortfolioEALCalculatorView view;
    private String aString = "";
    private int count;
    private Site site;
    private String fileName = "";
    private Thread calcThread = null;
    private File portfolioFile = null;
    private Portfolio portfolio = null;
    private JFileChooser chooser;

    public PortfolioEALCalculatorController() {
        CalcProgressBar startAppProgressClass = new CalcProgressBar("Starting Application", "Initializing Application .. Please Wait");
        this.view = PortfolioEALCalculatorView.getView();
        this.view.registerUI(this);
        this.view.setDefaultCloseOperation(3);
        this.view.setVisible(true);
        startAppProgressClass.dispose();
        this.EAL = 0.0;
    }

    public static void main(String[] args) {
        PortfolioEALCalculatorController controller = new PortfolioEALCalculatorController();
        controller.toString();
    }

    public double computeEAL() {
        double retVal = 0.0;
        try {
            this.portfolio = Portfolio.createPortfolio(this.portfolioFile);
            System.gc();
            retVal = this.portfolio.calculatePortfolioEAL(this.view.getIMR().getIMRBean().getSelectedIMR_Instance(), this.view.getDistanceControlPanel().getDistance(), this.view.getSite().getSiteBean().getSite(), this.view.getERF().getPanel().getSelectedERF(), this);
        }
        catch (Exception e) {
            ExceptionUtils.throwAsRuntimeException(e);
        }
        return retVal;
    }

    private void printToIO(double secs) {
        ++this.count;
        this.aString = this.aString + "Portfolio EAL Calculation # " + this.count + "\n\n";
        this.aString = this.aString + "Portfolio File Name: " + this.fileName + "\n\n";
        this.aString = this.aString + this.formatOutput(this.view.getERF().getPanel().getERFParameterList(), "Earthquake Rupture Forecast");
        this.aString = this.aString + this.formatOutput(this.view.getIMR().getIMRBean().getParameterList(), "Intesity Measure Relationship");
        this.aString = this.aString + this.formatOutput(this.view.getIMR().getIMRBean().getSelectedIMR_Instance().getIntensityMeasure().getIndependentParameterList(), "Intesity Measure Type");
        Iterator<Site> iterator = this.portfolio.getSiteList().iterator();
        while (iterator.hasNext()) {
            Site assetSite;
            this.site = assetSite = iterator.next();
            this.aString = this.aString + this.formatOutput(this.site, "Site");
        }
        this.aString = this.aString + this.formatOutput(this.view.getERF().getPanel().getSelectedERFTimespanGuiBean().getParameterList(), "Timespan");
        this.aString = this.aString + "Max. Source-Site Distance = " + this.view.getDistanceControlPanel().getDistance() + "\n\n";
        DecimalFormat money = new DecimalFormat("$0.00");
        for (int i = 0; i < this.portfolio.getAssetList().size(); ++i) {
            Asset asset = this.portfolio.getAssetList().get(i);
            this.aString = this.aString + "Asset " + i + " - Hazard Curve\n";
            this.aString = this.aString + asset.getHazardFunction().toString();
            this.aString = this.aString + "Asset " + (i + 1) + " EAL = " + money.format(asset.getAssetEAL()) + "\n\n";
        }
        String formatEAL = money.format(this.EAL);
        this.aString = this.aString + "Portfolio EAL " + this.count + " = " + formatEAL + "\n\n";
        this.aString = this.aString + "\nCalculation Time: " + secs + " seconds\n";
        this.aString = this.aString + "----------------------------------------\n\n";
        this.view.setIO(this.aString);
    }

    private String formatOutput(ParameterList params, String type) {
        this.aString = type + " Parameter List\n-------------------\n";
        if (type.equals("Site")) {
            if (this.site.getName() != null) {
                this.aString = this.aString + "Name: " + this.site.getName() + "\n";
            }
            this.aString = this.aString + "Latitute: " + this.site.getLocation().getLatitude() + "\n";
            this.aString = this.aString + "Longitude: " + this.site.getLocation().getLongitude() + "\n";
        }
        for (Parameter<?> next : params) {
            this.aString = this.aString + next.getName() + ": " + String.valueOf(next.getValue()) + "\n";
        }
        this.aString = this.aString + "\n";
        return this.aString;
    }

    private void computeButtonPressed() {
        if (this.portfolioFile != null) {
            this.view.setButtonsOnCompute();
            this.calcThread = new Thread(this);
            this.calcThread.start();
        } else {
            JOptionPane.showMessageDialog(this.view, "You must select a portfolio file first!", "Error", 0);
        }
    }

    private void clearButtonPressed() {
        int choice = JOptionPane.showConfirmDialog(this.view, "Are you sure you would like to clear the screen?", "Confirm", 0, 3);
        if (choice == 0) {
            this.aString = "";
            this.view.setIO(null);
        }
    }

    private void cancelButtonPressed() {
        this.view.setButtonsOnCancel();
        this.calcThread.stop();
    }

    private void openPortfolioButtonPressed() {
        int retval;
        if (this.chooser == null) {
            this.chooser = new JFileChooser(new File(".").getAbsoluteFile());
            CustomFileFilter csvFF = new CustomFileFilter("csv", "Portfolio Files");
            this.chooser.addChoosableFileFilter(csvFF);
            this.chooser.setFileFilter(csvFF);
        }
        if ((retval = this.chooser.showOpenDialog(this.view)) == 0) {
            this.portfolioFile = this.chooser.getSelectedFile();
            try {
                this.fileName = this.portfolioFile.getName();
                this.view.setPortfolioField(this.portfolioFile.getCanonicalPath());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource().getClass().toString().equals("class javax.swing.JComboBox")) {
            this.view.comboBoxSelection(((JComboBox)event.getSource()).getSelectedItem().toString());
            ((JComboBox)event.getSource()).setSelectedIndex(0);
        } else if (event.getSource().getClass().toString().equals("class javax.swing.JButton")) {
            String buttonName = event.getActionCommand();
            if (buttonName.equals("Compute")) {
                this.computeButtonPressed();
            } else if (buttonName.equals("Clear Results")) {
                this.clearButtonPressed();
            } else if (buttonName.equals("Cancel")) {
                this.cancelButtonPressed();
            } else if (buttonName.equals("Open Portfolio")) {
                this.openPortfolioButtonPressed();
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        if (event.getSource().getClass().toString().equals("class javax.swing.JCheckBox")) {
            if (event.getStateChange() == 1) {
                this.view.setProgressBarChecked(true);
            } else {
                this.view.setProgressBarChecked(false);
            }
        }
    }

    @Override
    public void run() {
        StopWatch watch = new StopWatch();
        watch.start();
        this.EAL = this.computeEAL();
        watch.stop();
        double secs = (double)watch.getTime() / 1000.0;
        this.printToIO(secs);
        this.view.setButtonsOnCancel();
    }

    @Override
    public void calculationException(String errorMessage) {
        JOptionPane.showMessageDialog(this.view, errorMessage, "Error", 0);
        this.view.setButtonsOnCancel();
        this.calcThread.stop();
    }
}

