/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sra.rtgm;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import com.google.common.primitives.Doubles;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.math3.distribution.NormalDistribution;
import org.apache.commons.math3.special.Erf;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.geo.Location;
import org.opensha.commons.util.Interpolate;
import org.opensha.sha.util.NEHRP_TestCity;

class RTGM_Util {
    private static final double SQRT2PI = Math.sqrt(Math.PI * 2);
    private static final double SQRT2 = Math.sqrt(2.0);
    private static NormalDistribution normDist = new NormalDistribution();
    private static final Joiner JOIN_LINE = Joiner.on((String)System.getProperty("line.separator"));
    private static final Joiner JOIN_STR = Joiner.on((String)"','");

    RTGM_Util() {
    }

    static double findLogLogX(double[] xs, double[] ys, double y) {
        double[] revXs = Doubles.toArray((Collection)Lists.reverse((List)Doubles.asList((double[])xs)));
        double[] revYs = Doubles.toArray((Collection)Lists.reverse((List)Doubles.asList((double[])ys)));
        return Interpolate.findLogLogY(revYs, revXs, y);
    }

    static double trapz(DiscretizedFunc f) {
        Preconditions.checkNotNull((Object)f, (Object)"Supplied function is null");
        Preconditions.checkArgument((f.size() > 1 ? 1 : 0) != 0, (Object)"Supplied function is too short");
        double sum = 0.0;
        for (int i = 1; i < f.size(); ++i) {
            Point2D p1 = f.get(i - 1);
            Point2D p2 = f.get(i);
            sum += (p2.getX() - p1.getX()) * (p2.getY() + p1.getY());
        }
        return sum * 0.5;
    }

    static double trapz(double[] xs, double[] ys) {
        Preconditions.checkNotNull((Object)xs, (Object)"Supplied x-values are null");
        Preconditions.checkNotNull((Object)ys, (Object)"Supplied y-values are null");
        Preconditions.checkArgument((xs.length > 1 ? 1 : 0) != 0, (Object)"Supplied function is too short");
        double sum = 0.0;
        for (int i = 1; i < xs.length; ++i) {
            sum += (xs[i] - xs[i - 1]) * (ys[i] + ys[i - 1]);
        }
        return sum * 0.5;
    }

    static void multiplyFunc(DiscretizedFunc f1, DiscretizedFunc f2) {
        Preconditions.checkNotNull((Object)f1, (Object)"Supplied function f1 is null");
        Preconditions.checkNotNull((Object)f2, (Object)"Supplied function f2 is null");
        Preconditions.checkArgument((f1.size() == f2.size() ? 1 : 0) != 0, (Object)"Supplied functions are not the same size");
        for (int i = 0; i < f1.size(); ++i) {
            f1.set(i, f1.getY(i) * f2.getY(i));
        }
    }

    static double logNormalDensity(double x, double mean, double std) {
        if (x <= 0.0) {
            return 0.0;
        }
        double x0 = Math.log(x) - mean;
        double x1 = x0 / std;
        return Math.exp(-0.5 * x1 * x1) / (std * SQRT2PI * x);
    }

    static double logNormalCumProb(double x, double mean, double std) {
        if (x <= 0.0) {
            return 0.0;
        }
        double dev = Math.log(x) - mean;
        if (Math.abs(dev) > 40.0 * std) {
            return dev < 0.0 ? 0.0 : 1.0;
        }
        return 0.5 + 0.5 * Erf.erf((double)(dev / (std * SQRT2)));
    }

    static double norminv(double p) {
        try {
            return normDist.inverseCumulativeProbability(p);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            return Double.NaN;
        }
    }

    static void buildCityStructForMatlab() {
        ArrayList names = Lists.newArrayList();
        ArrayList lats = Lists.newArrayList();
        ArrayList lons = Lists.newArrayList();
        for (NEHRP_TestCity city : NEHRP_TestCity.values()) {
            names.add(city.toString());
            Location loc = city.location();
            lats.add(String.format("%.2f", loc.getLatitude()));
            lons.add(String.format("%.2f", loc.getLongitude()));
        }
        ArrayList lines = Lists.newArrayList();
        lines.add("cities = struct( ...");
        lines.add("\t'name', {'" + JOIN_STR.join((Iterable)names) + "'}, ...");
        lines.add("\t'lat', {'" + JOIN_STR.join((Iterable)lats) + "'}, ...");
        lines.add("\t'lon', {'" + JOIN_STR.join((Iterable)lons) + "'});");
        File f = new File("tmp/Cities.m");
        try {
            Files.write((CharSequence)JOIN_LINE.join((Iterable)lines), (File)f, (Charset)Charsets.US_ASCII);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }
}

