/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.ui.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.opensha.ui.components.TaskComponent;

public class ProgressPane
extends JFrame {
    private static final int PANEL_WIDTH = 320;
    private static final int PANEL_HEIGHT = 480;
    private static final int PANEL_INSET = 140;
    private static final Color STRIPE = new Color(240, 240, 240);
    private JPanel content;

    public ProgressPane(String title) {
        super(title);
        this.setPreferredSize(new Dimension(320, 480));
        this.content = new Content();
        JScrollPane scroller = new JScrollPane(20, 31);
        scroller.setBorder(null);
        scroller.setViewportView(this.content);
        this.getContentPane().add((Component)scroller, "Center");
        this.pack();
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        int xPos = d.width - 320 - 140;
        this.setLocation(xPos, 140);
        this.setVisible(true);
    }

    public TaskComponent addTask(ActionListener listener) {
        TaskComponent pc = new TaskComponent(listener);
        this.content.add(pc);
        return pc;
    }

    public void removeTask(TaskComponent task) {
        if (task != null) {
            for (ActionListener l : task.cancel.getActionListeners()) {
                task.cancel.removeActionListener(l);
            }
            this.remove(task);
        }
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProgressPane pp = new ProgressPane("Progress Monitor");
                pp.addTask(null);
                pp.addTask(null);
            }
        });
    }

    private class Content
    extends JPanel {
        Content() {
            this.setLayout(new BoxLayout(this, 3));
            this.setBackground(Color.WHITE);
            this.setForeground(STRIPE);
        }

        @Override
        protected void paintComponent(Graphics g) {
            int w = this.getWidth();
            int h = this.getHeight();
            g.setColor(this.getBackground());
            g.fillRect(0, 0, w, h);
            for (int i = 60; i < this.getHeight(); i += 120) {
                g.setColor(this.getForeground());
                g.fillRect(0, i, w, 60);
            }
        }
    }
}

