/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.opensha.commons.util.ClassUtils;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.commons.util.FileUtils;
import org.opensha.commons.util.XMLUtils;
import org.opensha.sha.earthquake.faultSysSolution.modules.GridSourceProvider;
import org.opensha.sha.faultSurface.FaultSection;
import scratch.UCERF3.U3FaultSystemSolution;
import scratch.UCERF3.U3FaultSystemSolutionFetcher;
import scratch.UCERF3.enumTreeBranches.DeformationModels;
import scratch.UCERF3.enumTreeBranches.FaultModels;
import scratch.UCERF3.enumTreeBranches.InversionModels;
import scratch.UCERF3.enumTreeBranches.MaxMagOffFault;
import scratch.UCERF3.enumTreeBranches.MomentRateFixes;
import scratch.UCERF3.enumTreeBranches.ScalingRelationships;
import scratch.UCERF3.enumTreeBranches.SpatialSeisPDF;
import scratch.UCERF3.enumTreeBranches.TotalMag5Rate;
import scratch.UCERF3.griddedSeismicity.GridSourceFileReader;
import scratch.UCERF3.inversion.BatchPlotGen;
import scratch.UCERF3.inversion.InversionFaultSystemSolution;
import scratch.UCERF3.logicTree.U3LogicTreeBranch;
import scratch.UCERF3.logicTree.U3LogicTreeBranchNode;
import scratch.UCERF3.logicTree.VariableLogicTreeBranch;
import scratch.UCERF3.utils.MatrixIO;
import scratch.UCERF3.utils.U3FaultSystemIO;

public class U3CompoundFaultSystemSolution
extends U3FaultSystemSolutionFetcher {
    private ZipFile zip;
    private List<U3LogicTreeBranch> branches;
    private static Map<String, List<Class<? extends U3LogicTreeBranchNode<?>>>> dependencyMap = Maps.newHashMap();

    public U3CompoundFaultSystemSolution(ZipFile zip) {
        this.zip = zip;
        this.branches = Lists.newArrayList();
        Enumeration<? extends ZipEntry> zipEnum = zip.entries();
        ArrayList entriesList = Lists.newArrayList();
        while (zipEnum.hasMoreElements()) {
            entriesList.add(zipEnum.nextElement());
        }
        Collections.sort(entriesList, new Comparator<ZipEntry>(){

            @Override
            public int compare(ZipEntry o1, ZipEntry o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        for (ZipEntry entry : entriesList) {
            if (!entry.getName().endsWith("_rates.bin")) continue;
            this.branches.add(VariableLogicTreeBranch.fromFileName(entry.getName()));
        }
        System.out.println("Detected " + this.branches.size() + " branches in zip file!");
    }

    @Override
    public Collection<U3LogicTreeBranch> getBranches() {
        return this.branches;
    }

    @Override
    protected InversionFaultSystemSolution fetchSolution(U3LogicTreeBranch branch) {
        try {
            Map<String, String> nameRemappings = U3CompoundFaultSystemSolution.getRemappings(branch);
            U3FaultSystemSolution sol = U3FaultSystemIO.loadSolAsApplicable(this.zip, nameRemappings);
            Preconditions.checkState((boolean)(sol instanceof InversionFaultSystemSolution), (Object)"Non IVFSS in Compound Sol?");
            return (InversionFaultSystemSolution)sol;
        }
        catch (Exception e) {
            throw ExceptionUtils.asRuntimeException(e);
        }
    }

    @Override
    public double[] getRates(U3LogicTreeBranch branch) {
        return this.loadDoubleArray(branch, "rates.bin");
    }

    public double[] loadDoubleArray(U3LogicTreeBranch branch, String fileName) {
        try {
            Map<String, String> nameRemappings = U3CompoundFaultSystemSolution.getRemappings(branch);
            Object remapped = nameRemappings.get(fileName);
            if (remapped == null) {
                remapped = branch.buildFileName() + "_" + fileName;
            }
            ZipEntry ratesEntry = this.zip.getEntry((String)remapped);
            return MatrixIO.doubleArrayFromInputStream(new BufferedInputStream(this.zip.getInputStream(ratesEntry)), ratesEntry.getSize());
        }
        catch (IOException e) {
            throw ExceptionUtils.asRuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getInfo(U3LogicTreeBranch branch) {
        try {
            Map<String, String> nameRemappings = U3CompoundFaultSystemSolution.getRemappings(branch);
            ZipEntry infoEntry = this.zip.getEntry(nameRemappings.get("info.txt"));
            StringBuilder text = new StringBuilder();
            String NL = System.getProperty("line.separator");
            try (Scanner scanner = new Scanner(new BufferedInputStream(this.zip.getInputStream(infoEntry)));){
                while (scanner.hasNextLine()) {
                    text.append(scanner.nextLine() + NL);
                }
            }
            return text.toString();
        }
        catch (IOException e) {
            throw ExceptionUtils.asRuntimeException(e);
        }
    }

    @Override
    public double[] getMags(U3LogicTreeBranch branch) {
        return this.loadDoubleArray(branch, "mags.bin");
    }

    public double[] getLengths(U3LogicTreeBranch branch) {
        return this.loadDoubleArray(branch, "rup_lengths.bin");
    }

    public List<FaultSection> getSubSects(U3LogicTreeBranch branch) throws DocumentException, IOException {
        Map<String, String> nameRemappings = U3CompoundFaultSystemSolution.getRemappings(branch);
        ZipEntry fsdEntry = this.zip.getEntry(nameRemappings.get("fault_sections.xml"));
        Document doc = XMLUtils.loadDocument(new BufferedInputStream(this.zip.getInputStream(fsdEntry)));
        Element fsEl = doc.getRootElement().element("FaultSectionPrefDataList");
        Preconditions.checkNotNull((Object)fsEl, (Object)"Fault sections element not found");
        return U3FaultSystemIO.fsDataFromXML(fsEl);
    }

    public GridSourceProvider loadGridSourceProviderFile(U3LogicTreeBranch branch) throws DocumentException, IOException {
        ZipEntry gridSourcesRegEntry;
        Map<String, String> nameRemappings = U3CompoundFaultSystemSolution.getRemappings(branch);
        ZipEntry gridSourcesEntry = this.zip.getEntry(nameRemappings.get("grid_sources.xml"));
        ZipEntry gridSourcesBinEntry = this.zip.getEntry(nameRemappings.get("grid_sources.bin"));
        if (gridSourcesBinEntry == null) {
            System.out.println("Doesn't have: " + nameRemappings.get("grid_sources.bin"));
        }
        if ((gridSourcesRegEntry = this.zip.getEntry(nameRemappings.get("grid_sources_reg.xml"))) == null) {
            System.out.println("Doesn't have: " + nameRemappings.get("grid_sources_reg.xml"));
        }
        if (gridSourcesEntry != null) {
            return GridSourceFileReader.fromInputStream(this.zip.getInputStream(gridSourcesEntry));
        }
        if (gridSourcesBinEntry != null && gridSourcesRegEntry != null) {
            return GridSourceFileReader.fromBinStreams(this.zip.getInputStream(gridSourcesBinEntry), this.zip.getInputStream(gridSourcesRegEntry));
        }
        throw new FileNotFoundException();
    }

    private static List<Class<? extends U3LogicTreeBranchNode<?>>> buildList(Class<? extends U3LogicTreeBranchNode<?>> ... vals) {
        ArrayList list = Lists.newArrayList();
        for (Class<? extends U3LogicTreeBranchNode<?>> val : vals) {
            list.add(val);
        }
        return list;
    }

    public void toZipFile(File file) throws IOException {
        U3CompoundFaultSystemSolution.toZipFile(file, this);
    }

    public static void toZipFile(File file, U3FaultSystemSolutionFetcher fetcher) throws IOException {
        System.out.println("Making compound zip file: " + file.getName());
        File tempDir = FileUtils.createTempDir();
        HashSet<String> zipFileNames = new HashSet<String>();
        for (U3LogicTreeBranch branch : fetcher.getBranches()) {
            InversionFaultSystemSolution sol = fetcher.getSolution(branch);
            Map<String, String> remappings = U3CompoundFaultSystemSolution.getRemappings(branch);
            U3FaultSystemIO.writeSolFilesForZip(sol, tempDir, zipFileNames, remappings);
        }
        FileUtils.createZipFile(file.getAbsolutePath(), tempDir.getAbsolutePath(), zipFileNames);
        System.out.println("Deleting temp files");
        FileUtils.deleteRecursive(tempDir);
        System.out.println("Done saving!");
    }

    private static Map<String, String> getRemappings(U3LogicTreeBranch branch) {
        HashMap remappings = Maps.newHashMap();
        for (String name : dependencyMap.keySet()) {
            remappings.put(name, U3CompoundFaultSystemSolution.getRemappedName(name, branch));
        }
        return remappings;
    }

    public static String getRemappedName(String name, U3LogicTreeBranch branch) {
        Object nodeStr = "";
        List<Class<U3LogicTreeBranchNode<?>>> dependencies = dependencyMap.get(name);
        if (dependencies == null) {
            nodeStr = branch.buildFileName() + "_";
        } else {
            for (Class<? extends U3LogicTreeBranchNode<?>> clazz : dependencies) {
                nodeStr = (String)nodeStr + ((U3LogicTreeBranchNode)branch.getValueUnchecked(clazz)).encodeChoiceString() + "_";
            }
        }
        return (String)nodeStr + name;
    }

    public static U3CompoundFaultSystemSolution fromZipFile(File file) throws ZipException, IOException {
        ZipFile zip = new ZipFile(file);
        return new U3CompoundFaultSystemSolution(zip);
    }

    public static void main(String[] args) throws IOException {
        File dir;
        if (args.length >= 1) {
            dir = new File(args[0]);
            ArrayList nameGreps = Lists.newArrayList();
            for (int i = 1; i < args.length; ++i) {
                nameGreps.add(args[i]);
            }
            BatchPlotGen.writeCombinedFSS(dir, nameGreps);
            System.exit(0);
        }
        dir = new File("/home/kevin/workspace/OpenSHA/dev/scratch/UCERF3/data/scratch/InversionSolutions");
        File compoundFile = new File(dir, "2013_05_10-ucerf3p3-production-10runs_COMPOUND_SOL_WITH_IND_RUNS.zip");
        Stopwatch watch = Stopwatch.createStarted();
        U3CompoundFaultSystemSolution compoundSol = U3CompoundFaultSystemSolution.fromZipFile(compoundFile);
        for (U3LogicTreeBranch branch : compoundSol.getBranches()) {
            System.out.println("Loading " + String.valueOf(branch));
            System.out.println(ClassUtils.getClassNameWithoutPackage(compoundSol.getSolution(branch).getClass()));
        }
        System.out.println("Took " + watch.elapsed(TimeUnit.SECONDS) + " seconds to load");
    }

    static {
        dependencyMap.put("close_sections.bin", U3CompoundFaultSystemSolution.buildList(FaultModels.class));
        dependencyMap.put("cluster_rups.bin", U3CompoundFaultSystemSolution.buildList(FaultModels.class));
        dependencyMap.put("cluster_sects.bin", U3CompoundFaultSystemSolution.buildList(FaultModels.class));
        dependencyMap.put("fault_sections.xml", U3CompoundFaultSystemSolution.buildList(FaultModels.class, DeformationModels.class));
        dependencyMap.put("info.txt", null);
        dependencyMap.put("mags.bin", U3CompoundFaultSystemSolution.buildList(FaultModels.class, DeformationModels.class, ScalingRelationships.class));
        dependencyMap.put("rakes.bin", U3CompoundFaultSystemSolution.buildList(FaultModels.class, DeformationModels.class));
        dependencyMap.put("rates.bin", null);
        dependencyMap.put("rup_areas.bin", U3CompoundFaultSystemSolution.buildList(FaultModels.class, DeformationModels.class));
        dependencyMap.put("rup_lengths.bin", U3CompoundFaultSystemSolution.buildList(FaultModels.class));
        dependencyMap.put("rup_avg_slips.bin", U3CompoundFaultSystemSolution.buildList(FaultModels.class, DeformationModels.class, ScalingRelationships.class));
        dependencyMap.put("rup_sec_slip_type.txt", null);
        dependencyMap.put("rup_sections.bin", U3CompoundFaultSystemSolution.buildList(FaultModels.class));
        dependencyMap.put("rakes.bin", U3CompoundFaultSystemSolution.buildList(FaultModels.class, DeformationModels.class));
        dependencyMap.put("sect_areas.bin", U3CompoundFaultSystemSolution.buildList(FaultModels.class, DeformationModels.class));
        dependencyMap.put("sect_slips.bin", U3CompoundFaultSystemSolution.buildList(FaultModels.class, DeformationModels.class, ScalingRelationships.class, InversionModels.class, TotalMag5Rate.class, MaxMagOffFault.class, MomentRateFixes.class, SpatialSeisPDF.class));
        dependencyMap.put("sect_slips_std_dev.bin", U3CompoundFaultSystemSolution.buildList(FaultModels.class, DeformationModels.class, ScalingRelationships.class, InversionModels.class, TotalMag5Rate.class, MaxMagOffFault.class, MomentRateFixes.class, SpatialSeisPDF.class));
        dependencyMap.put("inv_rup_set_metadata.xml", null);
        dependencyMap.put("inv_sol_metadata.xml", null);
        dependencyMap.put("grid_sources.xml", null);
        dependencyMap.put("grid_sources_reg.xml", U3CompoundFaultSystemSolution.buildList(new Class[0]));
        dependencyMap.put("grid_sources.bin", null);
        dependencyMap.put("rup_mfds.bin", null);
        dependencyMap.put("sub_seismo_on_fault_mfds.bin", null);
        dependencyMap.put("plausibility.json", U3CompoundFaultSystemSolution.buildList(FaultModels.class));
        dependencyMap.put("cluster_ruptures.json", null);
    }
}

