/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.List;
import org.opensha.commons.calc.FaultMomentCalc;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.modules.ClusterRuptures;
import org.opensha.sha.earthquake.faultSysSolution.modules.InfoModule;
import org.opensha.sha.earthquake.faultSysSolution.modules.SectAreas;
import org.opensha.sha.earthquake.faultSysSolution.modules.SectSlipRates;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.ClusterRupture;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityConfiguration;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.RuptureConnectionSearch;
import org.opensha.sha.faultSurface.FaultSection;
import scratch.UCERF3.analysis.DeformationModelsCalc;

public class U3FaultSystemRupSet
extends FaultSystemRupSet
implements Serializable {
    public U3FaultSystemRupSet(List<? extends FaultSection> faultSectionData, double[] sectSlipRates, double[] sectSlipRateStdDevs, double[] sectAreas, List<List<Integer>> sectionForRups, double[] mags, double[] rakes, double[] rupAreas, double[] rupLengths, String info) {
        this.init(faultSectionData, sectSlipRates, sectSlipRateStdDevs, sectAreas, sectionForRups, mags, rakes, rupAreas, rupLengths, info);
    }

    protected U3FaultSystemRupSet() {
    }

    protected void init(U3FaultSystemRupSet rupSet) {
        this.init(rupSet.getFaultSectionDataList(), rupSet.getSlipRateForAllSections(), rupSet.getSlipRateStdDevForAllSections(), rupSet.getAreaForAllSections(), rupSet.getSectionIndicesForAllRups(), rupSet.getMagForAllRups(), rupSet.getAveRakeForAllRups(), rupSet.getAreaForAllRups(), rupSet.getLengthForAllRups(), rupSet.getInfoString());
        this.copyCacheFrom(rupSet);
    }

    protected void init(List<? extends FaultSection> faultSectionData, double[] sectSlipRates, double[] sectSlipRateStdDevs, double[] sectAreas, List<List<Integer>> sectionForRups, double[] mags, double[] rakes, double[] rupAreas, double[] rupLengths, String info) {
        this.init(faultSectionData, sectionForRups, mags, rakes, rupAreas, rupLengths);
        if (sectSlipRates != null || sectSlipRateStdDevs != null) {
            this.addModule(SectSlipRates.precomputed(this, sectSlipRates, sectSlipRateStdDevs));
        }
        if (sectAreas != null) {
            this.addModule(SectAreas.precomputed(this, sectAreas));
        }
        if (info != null && !info.isBlank()) {
            this.addModule(new InfoModule(info));
        }
    }

    public double getMomentRateReductionFraction(int sectIndex) {
        double origSlipRate = this.getFaultSectionData(sectIndex).getReducedAveSlipRate() * 0.001;
        double reducedSlipRate = this.getSlipRateForSection(sectIndex);
        return 1.0 - reducedSlipRate / origSlipRate;
    }

    public double getTotalMomentRateReduction() {
        return this.getTotalOrigMomentRate() - this.getTotalReducedMomentRate();
    }

    public double getTotalMomentRateReductionFraction() {
        return this.getTotalMomentRateReduction() / this.getTotalOrigMomentRate();
    }

    public double getOrigMomentRate(int sectIndex) {
        FaultSection sectData = this.getFaultSectionData(sectIndex);
        double moRate = sectData.calcMomentRate(true);
        if (Double.isNaN(moRate)) {
            return 0.0;
        }
        return moRate;
    }

    public double getTotalOrigMomentRate() {
        return DeformationModelsCalc.calculateTotalMomentRate(this.getFaultSectionDataList(), true);
    }

    public double getReducedMomentRate(int sectIndex) {
        return this.getOrigMomentRate(sectIndex) * (1.0 - this.getMomentRateReductionFraction(sectIndex));
    }

    public double getTotalReducedMomentRate() {
        double totMoRate = 0.0;
        for (int sectIndex = 0; sectIndex < this.getNumSections(); ++sectIndex) {
            double sectMoment = this.getReducedMomentRate(sectIndex);
            if (Double.isNaN(sectMoment)) continue;
            totMoRate += sectMoment;
        }
        return totMoRate;
    }

    public void setMagForallRups(double[] mags) {
        Preconditions.checkArgument((mags.length == this.getNumRuptures() ? 1 : 0) != 0, (Object)("Called setMag for " + mags.length + " rups but rup set has " + this.getNumRuptures() + " rups!"));
        super.init(this.getFaultSectionDataList(), this.getSectionIndicesForAllRups(), mags, this.getAveRakeForAllRups(), this.getAreaForAllRups(), this.getLengthForAllRups());
    }

    protected double calcTotalAvailableMomentRate(int rupIndex) {
        List<Integer> sectsInRup = this.getSectionsIndicesForRup(rupIndex);
        double totMoRate = 0.0;
        for (Integer sectID : sectsInRup) {
            double area = this.getAreaForSection(sectID);
            totMoRate += FaultMomentCalc.getMoment(area, this.getSlipRateForSection(sectID));
        }
        return totMoRate;
    }

    @Deprecated
    public PlausibilityConfiguration getPlausibilityConfiguration() {
        return this.getModule(PlausibilityConfiguration.class);
    }

    @Deprecated
    public void setPlausibilityConfiguration(PlausibilityConfiguration plausibilityConfig) {
        if (plausibilityConfig == null) {
            this.removeModuleInstances(PlausibilityConfiguration.class);
        } else {
            this.addModule(plausibilityConfig);
        }
    }

    @Deprecated
    public List<ClusterRupture> getClusterRuptures() {
        if (this.hasModule(ClusterRuptures.class)) {
            return this.getModule(ClusterRuptures.class).getAll();
        }
        return null;
    }

    @Deprecated
    public void setClusterRuptures(List<ClusterRupture> clusterRuptures) {
        if (clusterRuptures == null) {
            this.removeModuleInstances(ClusterRuptures.class);
        } else {
            Preconditions.checkState((clusterRuptures.size() == this.getNumRuptures() ? 1 : 0) != 0, (String)"Cluster ruptures list is of size=%s but numRuptures=%s", (int)clusterRuptures.size(), (int)this.getNumRuptures());
            this.addModule(ClusterRuptures.instance((FaultSystemRupSet)this, clusterRuptures));
        }
    }

    @Deprecated
    public void buildClusterRups(RuptureConnectionSearch search) {
        this.addModule(ClusterRuptures.instance((FaultSystemRupSet)this, search));
    }

    public void copyCacheFrom(U3FaultSystemRupSet rupSet) {
        super.copyCacheFrom(rupSet);
    }
}

