/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3;

import com.google.common.base.Preconditions;
import java.util.List;
import org.opensha.sha.earthquake.faultSysSolution.modules.SlipAlongRuptureModel;
import org.opensha.sha.faultSurface.FaultSection;
import scratch.UCERF3.U3SlipEnabledRupSet;
import scratch.UCERF3.enumTreeBranches.SlipAlongRuptureModels;

public abstract class U3SlipAlongRuptureModelRupSet
extends U3SlipEnabledRupSet {
    private SlipAlongRuptureModels slipAlongModel;
    private double[] rupAveSlips;

    public U3SlipAlongRuptureModelRupSet(List<? extends FaultSection> faultSectionData, double[] sectSlipRates, double[] sectSlipRateStdDevs, double[] sectAreas, List<List<Integer>> sectionForRups, double[] mags, double[] rakes, double[] rupAreas, double[] rupLengths, SlipAlongRuptureModels slipAlongModel, String info) {
        this(slipAlongModel);
        this.init(faultSectionData, sectSlipRates, sectSlipRateStdDevs, sectAreas, sectionForRups, mags, rakes, rupAreas, rupLengths, info);
    }

    protected U3SlipAlongRuptureModelRupSet(SlipAlongRuptureModels slipAlongModel) {
        this.slipAlongModel = slipAlongModel;
        this.addModule(SlipAlongRuptureModel.forModel(slipAlongModel));
    }

    @Override
    protected double[] calcSlipOnSectionsForRup(int rthRup) {
        Preconditions.checkNotNull((Object)this.slipAlongModel);
        List<Integer> sectionIndices = this.getSectionsIndicesForRup(rthRup);
        int numSects = sectionIndices.size();
        double[] sectArea = new double[numSects];
        int index = 0;
        for (Integer sectID : sectionIndices) {
            sectArea[index] = this.getAreaForSection(sectID);
            ++index;
        }
        double aveSlip = this.getAveSlipForRup(rthRup);
        return SlipAlongRuptureModels.calcSlipOnSectionsForRup(this, rthRup, this.slipAlongModel, sectArea, aveSlip);
    }
}

