/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.analysis;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import com.google.common.io.Files;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Ints;
import com.itextpdf.text.DocumentException;
import edu.usc.kmilner.mpj.taskDispatch.MPJTaskCalculator;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.AbstractCollection;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipException;
import mpi.MPI;
import org.apache.commons.math3.stat.StatUtils;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.jfree.data.Range;
import org.opensha.commons.calc.FractileCurveCalculator;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.data.Site;
import org.opensha.commons.data.function.AbstractXY_DataSet;
import org.opensha.commons.data.function.ArbDiscrEmpiricalDistFunc;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.data.function.XY_DataSet;
import org.opensha.commons.data.function.XY_DataSetList;
import org.opensha.commons.data.region.CaliforniaRegions;
import org.opensha.commons.data.xyz.ArbDiscrGeoDataSet;
import org.opensha.commons.data.xyz.GeoDataSet;
import org.opensha.commons.data.xyz.GeoDataSetMath;
import org.opensha.commons.data.xyz.GriddedGeoDataSet;
import org.opensha.commons.exceptions.GMT_MapException;
import org.opensha.commons.geo.GriddedRegion;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.Region;
import org.opensha.commons.gui.plot.HeadlessGraphPanel;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotElement;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.gui.plot.PlotSpec;
import org.opensha.commons.mapping.gmt.elements.GMT_CPT_Files;
import org.opensha.commons.metadata.XMLSaveable;
import org.opensha.commons.util.ClassUtils;
import org.opensha.commons.util.DataUtils;
import org.opensha.commons.util.DeadlockDetectionThread;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.commons.util.FileUtils;
import org.opensha.commons.util.IDPairing;
import org.opensha.commons.util.XMLUtils;
import org.opensha.commons.util.cpt.CPT;
import org.opensha.commons.util.threads.Task;
import org.opensha.commons.util.threads.ThreadedTaskComputer;
import org.opensha.nshmp2.util.Period;
import org.opensha.sha.calc.HazardCurveCalculator;
import org.opensha.sha.calc.hazardMap.BinaryHazardCurveReader;
import org.opensha.sha.calc.hazardMap.HazardDataSetLoader;
import org.opensha.sha.calc.hazardMap.components.BinaryCurveArchiver;
import org.opensha.sha.calc.hazardMap.components.CurveMetadata;
import org.opensha.sha.earthquake.ERF;
import org.opensha.sha.earthquake.EqkRupture;
import org.opensha.sha.earthquake.ProbEqkRupture;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.earthquake.calc.ERF_Calculator;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl.PaleoProbabilityModel;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl.UncertainDataConstraint;
import org.opensha.sha.earthquake.faultSysSolution.modules.FaultGridAssociations;
import org.opensha.sha.earthquake.faultSysSolution.modules.MFDGridSourceProvider;
import org.opensha.sha.earthquake.faultSysSolution.modules.PolygonFaultGridAssociations;
import org.opensha.sha.earthquake.faultSysSolution.modules.SubSeismoOnFaultMFDs;
import org.opensha.sha.earthquake.param.BPTAveragingTypeOptions;
import org.opensha.sha.earthquake.param.IncludeBackgroundOption;
import org.opensha.sha.earthquake.param.MagDependentAperiodicityOptions;
import org.opensha.sha.earthquake.param.ProbabilityModelOptions;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.MeanUCERF2.MeanUCERF2;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.UCERF2;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.UCERF2_TimeDependentEpistemicList;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.UCERF2_TimeIndependentEpistemicList;
import org.opensha.sha.faultSurface.CompoundSurface;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.faultSurface.RupInRegionCache;
import org.opensha.sha.faultSurface.RupNodesCache;
import org.opensha.sha.faultSurface.RuptureSurface;
import org.opensha.sha.imr.AttenRelRef;
import org.opensha.sha.imr.ScalarIMR;
import org.opensha.sha.imr.param.SiteParams.DepthTo1pt0kmPerSecParam;
import org.opensha.sha.imr.param.SiteParams.DepthTo2pt5kmPerSecParam;
import org.opensha.sha.imr.param.SiteParams.Vs30_Param;
import org.opensha.sha.imr.param.SiteParams.Vs30_TypeParam;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import org.opensha.sha.magdist.SummedMagFreqDist;
import scratch.UCERF3.U3AverageFaultSystemSolution;
import scratch.UCERF3.U3CompoundFaultSystemSolution;
import scratch.UCERF3.U3FaultSystemSolutionFetcher;
import scratch.UCERF3.analysis.BranchSensitivityHistogram;
import scratch.UCERF3.analysis.FaultBasedMapGen;
import scratch.UCERF3.analysis.FaultSysSolutionERF_Calc;
import scratch.UCERF3.enumTreeBranches.DeformationModels;
import scratch.UCERF3.enumTreeBranches.FaultModels;
import scratch.UCERF3.enumTreeBranches.InversionModels;
import scratch.UCERF3.enumTreeBranches.MomentRateFixes;
import scratch.UCERF3.enumTreeBranches.TotalMag5Rate;
import scratch.UCERF3.erf.FSSRupsInRegionCache;
import scratch.UCERF3.erf.FaultSystemSolutionERF;
import scratch.UCERF3.griddedSeismicity.GridSourceFileReader;
import scratch.UCERF3.inversion.BatchPlotGen;
import scratch.UCERF3.inversion.CommandLineInversionRunner;
import scratch.UCERF3.inversion.InversionFaultSystemRupSet;
import scratch.UCERF3.inversion.InversionFaultSystemRupSetFactory;
import scratch.UCERF3.inversion.InversionFaultSystemSolution;
import scratch.UCERF3.inversion.U3InversionTargetMFDs;
import scratch.UCERF3.inversion.UCERF2_ComparisonSolutionFetcher;
import scratch.UCERF3.inversion.laughTest.UCERF3PlausibilityConfig;
import scratch.UCERF3.logicTree.U3APrioriBranchWeightProvider;
import scratch.UCERF3.logicTree.U3BranchWeightProvider;
import scratch.UCERF3.logicTree.U3LogicTreeBranch;
import scratch.UCERF3.logicTree.U3LogicTreeBranchNode;
import scratch.UCERF3.logicTree.VariableLogicTreeBranch;
import scratch.UCERF3.utils.DeformationModelFetcher;
import scratch.UCERF3.utils.DeformationModelFileParser;
import scratch.UCERF3.utils.GardnerKnopoffAftershockFilter;
import scratch.UCERF3.utils.MatrixIO;
import scratch.UCERF3.utils.U3FaultSystemIO;
import scratch.UCERF3.utils.UCERF2_MFD_ConstraintFetcher;
import scratch.UCERF3.utils.UCERF2_Section_MFDs.UCERF2_Section_MFDsCalc;
import scratch.UCERF3.utils.UCERF3_DataUtils;
import scratch.UCERF3.utils.aveSlip.U3AveSlipConstraint;
import scratch.UCERF3.utils.paleoRateConstraints.PaleoFitPlotter;
import scratch.UCERF3.utils.paleoRateConstraints.PaleoSiteCorrelationData;
import scratch.UCERF3.utils.paleoRateConstraints.U3PaleoRateConstraint;
import scratch.UCERF3.utils.paleoRateConstraints.UCERF3_PaleoProbabilityModel;
import scratch.UCERF3.utils.paleoRateConstraints.UCERF3_PaleoRateConstraintFetcher;
import scratch.kevin.ucerf3.TestPDFCombine;
import scratch.kevin.ucerf3.inversion.MiniSectRecurrenceGen;
import scratch.peter.ucerf3.calc.UC3_CalcUtils;

public abstract class CompoundFSSPlots
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Color BROWN = new Color(130, 86, 5);
    static double[] time_dep_durations = new double[]{30.0, 5.0};
    private static String hostname;
    protected static final SimpleDateFormat df;
    private String className;
    private long computeTimeMillis = 0L;
    private long finalizeTimeMillis = 0L;
    private static long MILLIS_PER_SEC;
    private static long MILLIS_PER_MIN;

    public static void writeRegionalMFDPlots(U3FaultSystemSolutionFetcher fetch, U3BranchWeightProvider weightProvider, List<Region> regions, File dir, String prefix) throws IOException {
        RegionalMFDPlot plot = new RegionalMFDPlot(weightProvider, regions);
        plot.buildPlot(fetch);
        CompoundFSSPlots.writeRegionalMFDPlots(plot.specs, plot.cumulative_specs, regions, dir, prefix);
    }

    public static void writeRegionalMFDPlots(List<PlotSpec> specs, List<PlotSpec> cumulative_specs, List<Region> regions, File dir, String prefix) throws IOException {
        File subDir = new File(dir, "fss_mfd_plots");
        if (!subDir.exists()) {
            subDir.mkdir();
        }
        int unnamedRegionCnt = 0;
        for (int i = 0; i < regions.size(); ++i) {
            for (boolean cumulative : RegionalMFDPlot.cumulatives) {
                PlotSpec spec = cumulative ? cumulative_specs.get(i) : specs.get(i);
                Region region = regions.get(i);
                HeadlessGraphPanel gp = new HeadlessGraphPanel();
                CommandLineInversionRunner.setFontSizes(gp);
                gp.setYLog(true);
                if (cumulative) {
                    gp.setUserBounds(5.0, 9.0, 1.0E-5, 10.0);
                } else {
                    gp.setUserBounds(5.0, 9.0, 3.0E-6, 3.0);
                }
                gp.drawGraphPanel(spec);
                Object fname = prefix;
                fname = cumulative ? (String)fname + "_CUMULATIVE_MFD" : (String)fname + "_MFD";
                fname = region.getName() != null && !region.getName().isEmpty() ? (String)fname + "_" + region.getName().replaceAll("\\W+", "_") : (String)fname + "_UNNAMED_REGION_" + ++unnamedRegionCnt;
                File file = new File(subDir, (String)fname);
                gp.getChartPanel().setSize(1000, 800);
                gp.saveAsPDF(file.getAbsolutePath() + ".pdf");
                gp.saveAsPNG(file.getAbsolutePath() + ".png");
                gp.saveAsTXT(file.getAbsolutePath() + ".txt");
                File smallDir = new File(dir, "small_MFD_plots");
                if (!smallDir.exists()) {
                    smallDir.mkdir();
                }
                file = new File(smallDir, (String)fname + "_small");
                gp.getChartPanel().setSize(500, 400);
                gp.saveAsPDF(file.getAbsolutePath() + ".pdf");
                gp.saveAsPNG(file.getAbsolutePath() + ".png");
            }
        }
    }

    public static List<PlotSpec> getERFBasedRegionalMFDPlotSpecs(U3FaultSystemSolutionFetcher fetch, U3BranchWeightProvider weightProvider, List<Region> regions) {
        ERFBasedRegionalMFDPlot plot = new ERFBasedRegionalMFDPlot(weightProvider, regions, ERFBasedRegionalMFDPlot.getDefaultFractiles());
        plot.buildPlot(fetch);
        return plot.specs;
    }

    public static void writeERFBasedRegionalMFDPlots(U3FaultSystemSolutionFetcher fetch, U3BranchWeightProvider weightProvider, List<Region> regions, File dir, String prefix) throws IOException {
        List<PlotSpec> specs = CompoundFSSPlots.getERFBasedRegionalMFDPlotSpecs(fetch, weightProvider, regions);
        CompoundFSSPlots.writeERFBasedRegionalMFDPlots(specs, regions, dir, prefix);
    }

    public static void writeERFBasedRegionalMFDPlots(List<PlotSpec> specs, List<Region> regions, File dir, String prefix) throws IOException {
        File subDir = new File(dir, "erf_mfd_plots");
        if (!subDir.exists()) {
            subDir.mkdir();
        }
        int unnamedRegionCnt = 0;
        for (int i = 0; i < regions.size(); ++i) {
            PlotSpec spec = specs.get(i);
            Region region = regions.get(i);
            HeadlessGraphPanel gp = new HeadlessGraphPanel();
            CommandLineInversionRunner.setFontSizes(gp);
            gp.setYLog(true);
            gp.setUserBounds(5.0, 9.0, 1.0E-5, 10.0);
            gp.drawGraphPanel(spec);
            String fname = prefix + "_MFD_ERF";
            fname = region.getName() != null && !region.getName().isEmpty() ? fname + "_" + region.getName().replaceAll("\\W+", "_") : fname + "_UNNAMED_REGION_" + ++unnamedRegionCnt;
            File file = new File(subDir, fname);
            gp.getChartPanel().setSize(1000, 800);
            gp.saveAsPDF(file.getAbsolutePath() + ".pdf");
            gp.saveAsPNG(file.getAbsolutePath() + ".png");
            gp.saveAsTXT(file.getAbsolutePath() + ".txt");
            File smallDir = new File(dir, "small_MFD_plots");
            if (!smallDir.exists()) {
                smallDir.mkdir();
            }
            file = new File(smallDir, fname + "_small");
            gp.getChartPanel().setSize(500, 400);
            gp.saveAsPDF(file.getAbsolutePath() + ".pdf");
            gp.saveAsPNG(file.getAbsolutePath() + ".png");
        }
    }

    public static void writeERFBasedRegionalProbDistPlots(ERFBasedRegionalMagProbPlot plot, File dir, String prefix) throws IOException {
        File regionM6p7Dir;
        File smallFaultsDir;
        File smallMPDDir;
        Map<Double, List<PlotSpec>> specs = plot.specs;
        Map<Double, List<PlotSpec>> faultSpecs = plot.faultSpecs;
        Map<Double, List<Map<U3LogicTreeBranch, Map<MagDependentAperiodicityOptions, Double>>>> regionM6p7Vals = plot.regionM6p7Vals;
        List<Region> regions = plot.regions;
        File subDir = new File(dir, "erf_mag_prob_plots");
        if (!subDir.exists()) {
            subDir.mkdir();
        }
        if (!(smallMPDDir = new File(dir, "small_MPD_plots")).exists()) {
            smallMPDDir.mkdir();
        }
        if (!(smallFaultsDir = new File(dir, "small_MPD_faults")).exists()) {
            smallFaultsDir.mkdir();
        }
        if (!(regionM6p7Dir = new File(dir, "region_m6p7_branch_hists")).exists()) {
            regionM6p7Dir.mkdir();
        }
        int unnamedRegionCnt = 0;
        for (double duration : ERFBasedRegionalMagProbPlot.durations) {
            String csvPrefix;
            List csvs;
            String fName;
            String indepStr;
            CSVFile csv;
            HeadlessGraphPanel gp;
            String durStr = (int)duration + "yr";
            File durDir = new File(subDir, durStr);
            if (!durDir.exists()) {
                durDir.mkdir();
            }
            ArrayList regSmallPDFs = Lists.newArrayList();
            ArrayList faultSmallPDFs = Lists.newArrayList();
            File regionM6p7DurDir = new File(regionM6p7Dir, (int)duration + "yr");
            if (!regionM6p7DurDir.exists()) {
                regionM6p7DurDir.mkdir();
            }
            for (int i = 0; i < regions.size(); ++i) {
                Iterator<String> spec = specs.get(duration).get(i);
                Region region = regions.get(i);
                gp = new HeadlessGraphPanel();
                CommandLineInversionRunner.setFontSizes(gp);
                gp.setUserBounds(5.0, 9.0, 0.0, 1.0);
                gp.drawGraphPanel((PlotSpec)((Object)spec));
                Object regNameFileSafe = region.getName() != null && !region.getName().isEmpty() ? region.getName().replaceAll("\\W+", "_") : "UNNAMED_REGION_" + ++unnamedRegionCnt;
                String fname = prefix + "_" + (int)duration + "yr_MPD_ERF_" + (String)regNameFileSafe;
                File file = new File(durDir, fname);
                gp.getChartPanel().setSize(1000, 800);
                gp.saveAsPDF(file.getAbsolutePath() + ".pdf");
                gp.saveAsPNG(file.getAbsolutePath() + ".png");
                gp.saveAsTXT(file.getAbsolutePath() + ".txt");
                file = new File(smallMPDDir, fname + "_small");
                gp.getChartPanel().setSize(500, 400);
                gp.saveAsPDF(file.getAbsolutePath() + ".pdf");
                gp.saveAsPNG(file.getAbsolutePath() + ".png");
                regSmallPDFs.add(new File(file.getAbsolutePath() + ".pdf"));
                File regionHistDir = new File(regionM6p7DurDir, (String)regNameFileSafe);
                if (!regionHistDir.exists()) {
                    regionHistDir.mkdir();
                }
                BranchSensitivityHistogram sensHist = ERFBasedRegionalMagProbPlot.buildHist(regionM6p7Vals.get(duration).get(i), plot.weightProvider);
                Range range = sensHist.getRange();
                double delta = 0.025;
                Map<String, PlotSpec> histSpecs = sensHist.getStackedHistPlots(true, delta);
                ArrayList histPDFs = Lists.newArrayList();
                ArrayList names = Lists.newArrayList();
                for (Class<U3LogicTreeBranchNode<?>> clazz : U3LogicTreeBranch.getLogicTreeNodeClasses()) {
                    if (clazz.equals(InversionModels.class) || clazz.equals(MomentRateFixes.class)) continue;
                    names.add(ClassUtils.getClassNameWithoutPackage(U3LogicTreeBranch.getEnumEnclosingClass(clazz)));
                }
                names.add("MagDepAperiodicity");
                System.out.println("Histograms for " + (String)regNameFileSafe + ", duration=" + (int)duration);
                for (String name : names) {
                    PlotSpec histSpec = histSpecs.get(name);
                    Preconditions.checkNotNull((Object)histSpec, (Object)("No plot found for: " + name));
                    List<? extends PlotElement> elems = histSpec.getPlotElems();
                    double maxY = 0.0;
                    double min = 0.0;
                    int num = -1;
                    for (PlotElement plotElement : elems) {
                        if (!(plotElement instanceof DiscretizedFunc)) continue;
                        double myMax = ((DiscretizedFunc)plotElement).getMaxY();
                        if (myMax > maxY) {
                            maxY = myMax;
                        }
                        if (num >= 0 || !(plotElement instanceof EvenlyDiscretizedFunc)) continue;
                        EvenlyDiscretizedFunc eFunc = (EvenlyDiscretizedFunc)plotElement;
                        num = eFunc.size();
                        min = eFunc.getMinX();
                    }
                    double plotMaxY = maxY * 1.3;
                    if (plotMaxY > 1.0) {
                        plotMaxY = 1.0;
                    }
                    gp = new HeadlessGraphPanel();
                    CommandLineInversionRunner.setFontSizes(gp);
                    gp.setUserBounds(min - 0.5 * delta - 0.5 * delta, min + ((double)num - 0.5) * delta + 0.5 * delta, 0.0, plotMaxY);
                    gp.drawGraphPanel(histSpec);
                    file = new File(regionHistDir, name);
                    gp.getChartPanel().setSize(500, 400);
                    gp.saveAsPDF(file.getAbsolutePath() + ".pdf");
                    gp.saveAsPNG(file.getAbsolutePath() + ".png");
                    histPDFs.add(new File(file.getAbsolutePath() + ".pdf"));
                }
                try {
                    FaultSysSolutionERF_Calc.combineBranchSensHists(histPDFs, new File(regionHistDir, "histograms_combined.pdf"));
                    continue;
                }
                catch (DocumentException e) {
                    throw ExceptionUtils.asRuntimeException(e);
                }
            }
            File faultDir = new File(durDir, "faults");
            if (!faultDir.exists()) {
                faultDir.mkdir();
            }
            for (PlotSpec spec : faultSpecs.get(duration)) {
                gp = new HeadlessGraphPanel();
                CommandLineInversionRunner.setFontSizes(gp);
                gp.setYLog(false);
                gp.setUserBounds(5.0, 9.0, 0.0, 1.0);
                gp.drawGraphPanel(spec);
                String fname = spec.getTitle().replaceAll("\\W+", "_") + "_" + (int)duration + "yr";
                File file = new File(faultDir, fname);
                gp.getChartPanel().setSize(1000, 800);
                gp.saveAsPDF(file.getAbsolutePath() + ".pdf");
                gp.saveAsPNG(file.getAbsolutePath() + ".png");
                gp.saveAsTXT(file.getAbsolutePath() + ".txt");
                file = new File(smallFaultsDir, fname + "_small");
                gp.getChartPanel().setSize(500, 400);
                gp.saveAsPDF(file.getAbsolutePath() + ".pdf");
                gp.saveAsPNG(file.getAbsolutePath() + ".png");
            }
            for (String faultName : ERFBasedRegionalMagProbPlot.mainFaultsCombinedPFDNames) {
                faultSmallPDFs.add(new File(smallFaultsDir, faultName.replaceAll("\\W+", "_") + "_" + (int)duration + "yr_small.pdf"));
            }
            try {
                if (regSmallPDFs.size() > 1) {
                    TestPDFCombine.combine(regSmallPDFs, new File(smallMPDDir, (int)duration + "yr_combined.pdf"), 2, 0.5, false, 0.03, 0.05);
                }
                if (faultSmallPDFs.size() > 1) {
                    TestPDFCombine.combine(faultSmallPDFs, new File(smallFaultsDir, (int)duration + "yr_combined.pdf"), 2, 0.43, false, 0.06, 0.03);
                }
            }
            catch (DocumentException e) {
                throw ExceptionUtils.asRuntimeException(e);
            }
            for (Boolean indepVal : plot.regionProbCSVs.row((Object)duration).keySet()) {
                csv = (CSVFile)plot.regionProbCSVs.get((Object)duration, (Object)indepVal);
                indepStr = indepVal != false ? "dep" : "indep";
                fName = "region_" + durStr + "_" + indepStr + "_mag_prob_dists.csv";
                csv.writeToFile(new File(durDir, fName));
            }
            for (Boolean indepVal : plot.regionRateCSVs.row((Object)duration).keySet()) {
                csv = (CSVFile)plot.regionRateCSVs.get((Object)duration, (Object)indepVal);
                indepStr = indepVal != false ? "dep" : "indep";
                fName = "region_" + durStr + "_" + indepStr + "_mag_rate_dists.csv";
                csv.writeToFile(new File(durDir, fName));
            }
            for (Boolean indepVal : plot.faultProbCSVs.row((Object)duration).keySet()) {
                csv = (CSVFile)plot.faultProbCSVs.get((Object)duration, (Object)indepVal);
                indepStr = indepVal != false ? "dep" : "indep";
                fName = "fault_" + durStr + "_" + indepStr + "_mag_prob_dists.csv";
                csv.writeToFile(new File(faultDir, fName));
            }
            for (Boolean indepVal : plot.faultRateCSVs.row((Object)duration).keySet()) {
                csv = (CSVFile)plot.faultRateCSVs.get((Object)duration, (Object)indepVal);
                indepStr = indepVal != false ? "dep" : "indep";
                fName = "fault_" + durStr + "_" + indepStr + "_mag_freq_dists.csv";
                csv.writeToFile(new File(faultDir, fName));
            }
            for (FaultModels fm : plot.subSectsCSVs.columnKeySet()) {
                csvs = (List)plot.subSectsCSVs.get((Object)duration, (Object)fm);
                csvPrefix = fm.encodeChoiceString() + "_" + durStr + "_sub_sect_probs";
                ((CSVFile)csvs.get(0)).writeToFile(new File(durDir, csvPrefix + "_u3_td_mean.csv"));
                ((CSVFile)csvs.get(1)).writeToFile(new File(durDir, csvPrefix + "_u3_td_min.csv"));
                ((CSVFile)csvs.get(2)).writeToFile(new File(durDir, csvPrefix + "_u3_td_max.csv"));
                ((CSVFile)csvs.get(3)).writeToFile(new File(durDir, csvPrefix + "_u3_poisson_mean.csv"));
                csvs = (List)plot.subSectsPercentileCSVs.get((Object)duration, (Object)fm);
                for (int i = 0; i < plot.sub_sect_fractiles.length; ++i) {
                    CSVFile csv2 = (CSVFile)csvs.get(i);
                    String name = csvPrefix + "_u3_td_p" + (float)(plot.sub_sect_fractiles[i] * 100.0) + ".csv";
                    csv2.writeToFile(new File(durDir, name));
                }
            }
            for (FaultModels fm : plot.parentSectsCSVs.columnKeySet()) {
                csvs = (List)plot.parentSectsCSVs.get((Object)duration, (Object)fm);
                csvPrefix = fm.encodeChoiceString() + "_" + durStr + "_parent_sect_probs";
                ((CSVFile)csvs.get(0)).writeToFile(new File(durDir, csvPrefix + "_u3_td_mean.csv"));
                ((CSVFile)csvs.get(1)).writeToFile(new File(durDir, csvPrefix + "_u3_td_min.csv"));
                ((CSVFile)csvs.get(2)).writeToFile(new File(durDir, csvPrefix + "_u3_td_max.csv"));
                ((CSVFile)csvs.get(3)).writeToFile(new File(durDir, csvPrefix + "_u3_poisson_mean.csv"));
            }
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");
        for (File d : new File[]{subDir, smallFaultsDir, smallMPDDir}) {
            File mFile = new File(d, "metadata.txt");
            FileWriter fw = new FileWriter(mFile);
            fw.write("ERF Based Regional/Fault Probability Distributions\n");
            fw.write("Generated on: " + df.format(new Date()) + "\n");
            fw.write("Generated by: " + ERFBasedRegionalMagProbPlot.class.getName() + "\n");
            fw.write("\n");
            fw.write("All data INCLUDES aftershocks. UCERF3 data uses default BPT averaging method and UCERF3 Preferred Blend for the time dependence. This historical open interval is set as 2014 - 1875 = 139.\n");
            fw.close();
        }
    }

    private static void recombineMagProbDistPDFs(File smallMPDDir, File smallFaultsDir, String prefix) throws IOException {
        List<Region> regions = ERFBasedRegionalMagProbPlot.getDefaultRegions();
        for (double duration : ERFBasedRegionalMagProbPlot.durations) {
            ArrayList regSmallPDFs = Lists.newArrayList();
            ArrayList faultSmallPDFs = Lists.newArrayList();
            for (int i = 0; i < regions.size(); ++i) {
                Region region = regions.get(i);
                String fname = prefix + "_" + (int)duration + "yr_MPD_ERF";
                fname = fname + "_" + region.getName().replaceAll("\\W+", "_");
                regSmallPDFs.add(new File(smallMPDDir, fname + "_small.pdf"));
            }
            for (String faultName : ERFBasedRegionalMagProbPlot.mainFaultsCombinedPFDNames) {
                faultSmallPDFs.add(new File(smallFaultsDir, faultName.replaceAll("\\W+", "_") + "_" + (int)duration + "yr_small.pdf"));
            }
            try {
                TestPDFCombine.combine(regSmallPDFs, new File(smallMPDDir, (int)duration + "yr_combined.pdf"), 2, 0.5, false, 0.03, 0.05);
                TestPDFCombine.combine(faultSmallPDFs, new File(smallFaultsDir, (int)duration + "yr_combined.pdf"), 2, 0.43, false, 0.06, 0.03);
            }
            catch (DocumentException e) {
                throw ExceptionUtils.asRuntimeException(e);
            }
        }
    }

    private static int getInversionIndex(ProbEqkSource source) {
        String srcName = source.getName();
        return Integer.parseInt(srcName.substring(srcName.indexOf("#") + 1, srcName.indexOf(";")));
    }

    public static void writeERFBasedSiteHazardHists(ERFBasedSiteHazardHistPlot plot, File dir) throws IOException {
        CompoundFSSPlots.writeERFBasedSiteHazardHists(plot.plots, dir);
    }

    public static void writeERFBasedSiteHazardHists(SiteHazardResults results, File dir) throws IOException {
        File subDir = new File(dir, "site_hazard_hists");
        if (!subDir.exists()) {
            subDir.mkdir();
        }
        Map<Site, Table<Period, Double, Map<String, PlotSpec>>> plotsMap = results.plotsMap;
        Map<Site, Table<Period, Double, CSVFile<String>>> csvsMap = results.csvsMap;
        File tempDir = Files.createTempDir();
        for (Site site : plotsMap.keySet()) {
            Table<Period, Double, Map<String, PlotSpec>> sitePlots = plotsMap.get(site);
            Table<Period, Double, CSVFile<String>> siteCSVs = csvsMap.get(site);
            File siteDir = new File(subDir, site.getName());
            if (!siteDir.exists()) {
                siteDir.mkdir();
            }
            for (Period period : sitePlots.rowKeySet()) {
                Iterator iterator = sitePlots.columnKeySet().iterator();
                while (iterator.hasNext()) {
                    double prob = (Double)iterator.next();
                    String prefix = (int)(prob * 100.0) + "in50_" + period.getLabel();
                    Map specs = (Map)sitePlots.get((Object)period, (Object)prob);
                    ArrayList histPDFs = Lists.newArrayList();
                    ArrayList names = Lists.newArrayList();
                    for (Class<U3LogicTreeBranchNode<?>> clazz : U3LogicTreeBranch.getLogicTreeNodeClasses()) {
                        if (clazz.equals(InversionModels.class) || clazz.equals(MomentRateFixes.class)) continue;
                        names.add(ClassUtils.getClassNameWithoutPackage(U3LogicTreeBranch.getEnumEnclosingClass(clazz)));
                    }
                    names.add("MagDepAperiodicity");
                    names.add("GMPE");
                    for (String name : names) {
                        PlotSpec histSpec = (PlotSpec)specs.get(name);
                        if (histSpec == null) {
                            System.out.println("WARNING: no spec found for " + name);
                            continue;
                        }
                        Preconditions.checkNotNull((Object)histSpec, (Object)("No plot found for: " + name));
                        List<? extends PlotElement> elems = histSpec.getPlotElems();
                        HeadlessGraphPanel gp = new HeadlessGraphPanel();
                        CommandLineInversionRunner.setFontSizes(gp);
                        EvenlyDiscretizedFunc f1 = (EvenlyDiscretizedFunc)elems.get(0);
                        double min = f1.getMinX();
                        double delta = f1.getDelta();
                        int num = f1.size();
                        double plotMaxY = 0.0;
                        for (int i = 0; i < elems.size(); ++i) {
                            double max;
                            if (!(elems.get(i) instanceof DiscretizedFunc) || !((max = ((XY_DataSet)elems.get(i)).getMaxY()) > plotMaxY)) continue;
                            plotMaxY = max;
                        }
                        if ((plotMaxY *= 1.3) > 1.0) {
                            plotMaxY = 1.0;
                        }
                        double plotMinX = min - 0.5 * delta - 0.5 * delta;
                        double plotMaxX = min + ((double)num - 0.5) * delta + 0.5 * delta;
                        gp.setUserBounds(plotMinX, plotMaxX, 0.0, plotMaxY);
                        if (plotMinX >= plotMaxX) {
                            System.out.println("Data bounds: " + f1.getMinX() + " " + f1.getMaxX() + " " + f1.getMinY() + " " + f1.getMaxY());
                            System.out.println("Plot bounds: " + plotMinX + " " + plotMaxX + " 0 " + plotMaxY);
                            System.out.println("Delta=" + delta);
                            System.out.println(f1);
                        }
                        gp.drawGraphPanel(histSpec);
                        File file = new File(tempDir, name);
                        gp.getChartPanel().setSize(500, 400);
                        gp.saveAsPDF(file.getAbsolutePath() + ".pdf");
                        gp.saveAsPNG(file.getAbsolutePath() + ".png");
                        histPDFs.add(new File(file.getAbsolutePath() + ".pdf"));
                    }
                    try {
                        FaultSysSolutionERF_Calc.combineBranchSensHists(histPDFs, new File(siteDir, prefix + ".pdf"));
                    }
                    catch (DocumentException e) {
                        throw ExceptionUtils.asRuntimeException(e);
                    }
                    CSVFile csv = (CSVFile)siteCSVs.get((Object)period, (Object)prob);
                    csv.writeToFile(new File(siteDir, prefix + ".csv"));
                }
            }
        }
        FileUtils.deleteRecursive(tempDir);
    }

    public static void writeERFProbModelsFile(File dir, Table<Double, U3LogicTreeBranch, Map<MagDependentAperiodicityOptions, double[]>> probsTable) throws IOException {
        File tempDir = Files.createTempDir();
        if (!dir.exists()) {
            dir.mkdir();
        }
        for (double duration : ERFProbModelCalc.durations) {
            for (MagDependentAperiodicityOptions cov : ERFProbModelCalc.covs) {
                ArrayList binFileNames = Lists.newArrayList();
                for (U3LogicTreeBranch branch : probsTable.columnKeySet()) {
                    double[] probs = (double[])((Map)probsTable.get((Object)duration, (Object)branch)).get((Object)cov);
                    File binFile = new File(tempDir, branch.buildFileName() + ".bin");
                    MatrixIO.doubleArrayToFile(probs, binFile);
                    binFileNames.add(binFile.getName());
                }
                String covStr = cov == null ? "POISSON" : cov.name();
                File zipFile = new File(dir, "probs_" + (int)duration + "yr_" + covStr + ".zip");
                FileUtils.createZipFile(zipFile.getAbsolutePath(), tempDir.getAbsolutePath(), binFileNames);
            }
        }
        FileUtils.deleteRecursive(tempDir);
    }

    public static void writePaleoFaultPlots(U3FaultSystemSolutionFetcher fetch, U3BranchWeightProvider weightProvider, File dir) throws IOException {
        PaleoFaultPlot plot = new PaleoFaultPlot(weightProvider);
        plot.buildPlot(fetch);
        CompoundFSSPlots.writePaleoFaultPlots(plot.plotsMap, dir);
    }

    public static void writePaleoFaultPlots(Map<FaultModels, Map<String, PlotSpec[]>> plotsMap, File dir) throws IOException {
        boolean multiple;
        boolean bl = multiple = plotsMap.keySet().size() > 1;
        if (!dir.exists()) {
            dir.mkdir();
        }
        for (FaultModels fm : plotsMap.keySet()) {
            Map<String, PlotSpec[]> specs = plotsMap.get(fm);
            String prefix = null;
            if (multiple) {
                prefix = fm.getShortName();
            }
            CommandLineInversionRunner.writePaleoFaultPlots(specs, prefix, dir);
        }
    }

    public static void writePaleoCorrelationPlots(U3FaultSystemSolutionFetcher fetch, U3BranchWeightProvider weightProvider, File dir) throws IOException {
        PaleoSiteCorrelationPlot plot = new PaleoSiteCorrelationPlot(weightProvider);
        plot.buildPlot(fetch);
        CompoundFSSPlots.writePaleoCorrelationPlots(plot.plotsMap, dir);
    }

    public static void writePaleoCorrelationPlots(Map<String, PlotSpec> plotsMap, File dir) throws IOException {
        System.out.println("Making paleo corr plots for " + plotsMap.keySet().size() + " Faults");
        if (!dir.exists()) {
            dir.mkdir();
        }
        CommandLineInversionRunner.writePaleoCorrelationPlots(dir, plotsMap);
    }

    public static void writeParentSectionMFDPlots(U3FaultSystemSolutionFetcher fetch, U3BranchWeightProvider weightProvider, File dir) throws IOException {
        ParentSectMFDsPlot plot = new ParentSectMFDsPlot(weightProvider);
        plot.buildPlot(fetch);
        CompoundFSSPlots.writeParentSectionMFDPlots(plot, dir);
    }

    public static void writeParentSectionMFDPlots(ParentSectMFDsPlot plot, File dir) throws IOException {
        File nuclCmlSubDir;
        File nuclIncrSubDir;
        File particCmlSubDir;
        File particIncrSubDir;
        System.out.println("Making parent sect MFD plots for " + plot.plotNuclIncrMFDs.keySet().size() + " Faults");
        if (!dir.exists()) {
            dir.mkdir();
        }
        if (!(particIncrSubDir = new File(dir, "participation_incremental")).exists()) {
            particIncrSubDir.mkdir();
        }
        if (!(particCmlSubDir = new File(dir, "participation_cumulative")).exists()) {
            particCmlSubDir.mkdir();
        }
        if (!(nuclIncrSubDir = new File(dir, "nucleation_incremental")).exists()) {
            nuclIncrSubDir.mkdir();
        }
        if (!(nuclCmlSubDir = new File(dir, "nucleation_cumulative")).exists()) {
            nuclCmlSubDir.mkdir();
        }
        CSVFile<String> nucleationCSV = new CSVFile<String>(true);
        CSVFile<String> nucleationMinCSV = new CSVFile<String>(true);
        CSVFile<String> nucleationMaxCSV = new CSVFile<String>(true);
        CSVFile<String> participationCSV = new CSVFile<String>(true);
        CSVFile<String> participationMinCSV = new CSVFile<String>(true);
        CSVFile<String> participationMaxCSV = new CSVFile<String>(true);
        ArrayList header = Lists.newArrayList();
        ArrayList xVals = Lists.newArrayList();
        for (double x = 5.05; x <= 9.05; x += 0.1) {
            xVals.add(x);
        }
        header.add("Fault ID");
        header.add("Fault Name");
        Iterator<Object> iterator = xVals.iterator();
        while (iterator.hasNext()) {
            double x = (Double)iterator.next();
            header.add("M" + (float)x);
            header.add("(UCERF2)");
        }
        nucleationCSV.addLine(header);
        nucleationMinCSV.addLine(header);
        nucleationMaxCSV.addLine(header);
        participationCSV.addLine(header);
        participationMinCSV.addLine(header);
        participationMaxCSV.addLine(header);
        for (Integer parentID : plot.plotNuclIncrMFDs.keySet()) {
            ArrayList<IncrementalMagFreqDist> ucerf2NuclMFDs = UCERF2_Section_MFDsCalc.getMeanMinAndMaxMFD(parentID, false, false);
            ArrayList<IncrementalMagFreqDist> ucerf2NuclCmlMFDs = UCERF2_Section_MFDsCalc.getMeanMinAndMaxMFD(parentID, false, true);
            ArrayList<IncrementalMagFreqDist> ucerf2PartMFDs = UCERF2_Section_MFDsCalc.getMeanMinAndMaxMFD(parentID, true, false);
            ArrayList<IncrementalMagFreqDist> ucerf2PartCmlMFDs = UCERF2_Section_MFDsCalc.getMeanMinAndMaxMFD(parentID, true, true);
            String name = (String)plot.namesMap.get(parentID);
            List<IncrementalMagFreqDist> nuclMFDs = plot.plotNuclIncrMFDs.get(parentID);
            List<EvenlyDiscretizedFunc> nuclCmlMFDs = plot.plotNuclCmlMFDs.get(parentID);
            List<IncrementalMagFreqDist> partMFDs = plot.plotPartIncrMFDs.get(parentID);
            List<EvenlyDiscretizedFunc> partCmlMFDs = plot.plotPartCmlMFDs.get(parentID);
            for (int i = 0; i < nuclMFDs.size(); ++i) {
                nuclMFDs.get(i).setInfo(" ");
                nuclCmlMFDs.get(i).setInfo(" ");
                partMFDs.get(i).setInfo(" ");
                partCmlMFDs.get(i).setInfo(" ");
            }
            EvenlyDiscretizedFunc nuclCmlMFD = nuclCmlMFDs.get(nuclCmlMFDs.size() - 3);
            nuclCmlMFD.setInfo(CompoundFSSPlots.getCmlMFDInfo(nuclCmlMFD, false));
            EvenlyDiscretizedFunc partCmlMFD = partCmlMFDs.get(partCmlMFDs.size() - 3);
            partCmlMFD.setInfo(CompoundFSSPlots.getCmlMFDInfo(partCmlMFD, false));
            EvenlyDiscretizedFunc ucerf2NuclCmlMFD = null;
            EvenlyDiscretizedFunc ucerf2NuclCmlMinMFD = null;
            EvenlyDiscretizedFunc ucerf2NuclCmlMaxMFD = null;
            EvenlyDiscretizedFunc ucerf2PartCmlMFD = null;
            EvenlyDiscretizedFunc ucerf2PartCmlMinMFD = null;
            EvenlyDiscretizedFunc ucerf2PartCmlMaxMFD = null;
            if (ucerf2NuclCmlMFDs != null) {
                ucerf2NuclCmlMFD = ucerf2NuclCmlMFDs.get(0);
                ucerf2NuclCmlMinMFD = ucerf2NuclCmlMFDs.get(1);
                ucerf2NuclCmlMaxMFD = ucerf2NuclCmlMFDs.get(2);
                ucerf2PartCmlMFD = ucerf2PartCmlMFDs.get(0);
                ucerf2PartCmlMinMFD = ucerf2PartCmlMFDs.get(1);
                ucerf2PartCmlMaxMFD = ucerf2PartCmlMFDs.get(2);
            }
            nucleationCSV.addLine(CompoundFSSPlots.getCSVLine(xVals, parentID, name, nuclCmlMFD, ucerf2NuclCmlMFD));
            nucleationMinCSV.addLine(CompoundFSSPlots.getCSVLine(xVals, parentID, name, nuclCmlMFDs.get(nuclCmlMFDs.size() - 2), ucerf2NuclCmlMinMFD));
            nucleationMaxCSV.addLine(CompoundFSSPlots.getCSVLine(xVals, parentID, name, nuclCmlMFDs.get(nuclCmlMFDs.size() - 1), ucerf2NuclCmlMaxMFD));
            participationCSV.addLine(CompoundFSSPlots.getCSVLine(xVals, parentID, name, partCmlMFD, ucerf2PartCmlMFD));
            participationMinCSV.addLine(CompoundFSSPlots.getCSVLine(xVals, parentID, name, partCmlMFDs.get(partCmlMFDs.size() - 2), ucerf2PartCmlMinMFD));
            participationMaxCSV.addLine(CompoundFSSPlots.getCSVLine(xVals, parentID, name, partCmlMFDs.get(partCmlMFDs.size() - 1), ucerf2PartCmlMaxMFD));
            List<IncrementalMagFreqDist> subSeismoMFDs = plot.plotSubSeismoIncrMFDs.get(parentID);
            List<EvenlyDiscretizedFunc> subSeismoCmlMFDs = plot.plotSubSeismoCmlMFDs.get(parentID);
            List<IncrementalMagFreqDist> subPlusSupraSeismoNuclMFDs = plot.plotSubPlusSupraSeismoNuclMFDs.get(parentID);
            List<EvenlyDiscretizedFunc> subPlusSupraSeismoNuclCmlMFDs = plot.plotSubPlusSupraSeismoNuclCmlMFDs.get(parentID);
            List<IncrementalMagFreqDist> subPlusSupraSeismoParticMFDs = plot.plotSubPlusSupraSeismoParticMFDs.get(parentID);
            List<EvenlyDiscretizedFunc> subPlusSupraSeismoParticCmlMFDs = plot.plotSubPlusSupraSeismoParticCmlMFDs.get(parentID);
            CompoundFSSPlots.writeParentSectionMFDPlot(nuclIncrSubDir, nuclMFDs, ucerf2NuclMFDs, subSeismoMFDs, subPlusSupraSeismoNuclMFDs, parentID, name, true, false);
            CompoundFSSPlots.writeParentSectionMFDPlot(nuclCmlSubDir, nuclCmlMFDs, ucerf2NuclCmlMFDs, subSeismoCmlMFDs, subPlusSupraSeismoNuclCmlMFDs, parentID, name, true, true);
            CompoundFSSPlots.writeParentSectionMFDPlot(particIncrSubDir, partMFDs, ucerf2PartMFDs, subSeismoMFDs, subPlusSupraSeismoParticMFDs, parentID, name, false, false);
            CompoundFSSPlots.writeParentSectionMFDPlot(particCmlSubDir, partCmlMFDs, ucerf2PartCmlMFDs, subSeismoCmlMFDs, subPlusSupraSeismoParticCmlMFDs, parentID, name, false, true);
        }
        nucleationCSV.writeToFile(new File(dir, "cumulative_nucleation_mfd_comparisons.csv"));
        nucleationMinCSV.writeToFile(new File(dir, "cumulative_nucleation_min_mfd_comparisons.csv"));
        nucleationMaxCSV.writeToFile(new File(dir, "cumulative_nucleation_max_mfd_comparisons.csv"));
        participationCSV.writeToFile(new File(dir, "cumulative_participation_mfd_comparisons.csv"));
        participationMinCSV.writeToFile(new File(dir, "cumulative_participation_min_mfd_comparisons.csv"));
        participationMaxCSV.writeToFile(new File(dir, "cumulative_participation_max_mfd_comparisons.csv"));
    }

    private static List<String> getCSVLine(List<Double> xVals, int parentID, String name, EvenlyDiscretizedFunc cmlMFD, EvenlyDiscretizedFunc ucerf2CmlMFD) {
        ArrayList line = Lists.newArrayList((Object[])new String[]{"" + parentID, name});
        for (int i = 0; i < xVals.size(); ++i) {
            line.add("" + cmlMFD.getY(i));
            double x = xVals.get(i);
            if (ucerf2CmlMFD != null && ucerf2CmlMFD.getMinX() <= x && ucerf2CmlMFD.getMaxX() >= x) {
                line.add("" + ucerf2CmlMFD.getClosestYtoX(x));
                continue;
            }
            line.add("");
        }
        return line;
    }

    private static String getCmlMFDInfo(EvenlyDiscretizedFunc cmlMFD, boolean isAlreadyRI) {
        String info;
        double totRate = cmlMFD.getMaxY();
        double rate6p7 = cmlMFD.getInterpolatedY_inLogYDomain(6.7);
        if (isAlreadyRI) {
            info = "\t\tTotal RI: " + (int)Math.round(totRate) + "\n";
            info = (String)info + "\t\tRI M>=6.7: " + (int)Math.round(rate6p7);
        } else {
            info = "\t\tTotal Rate: " + (float)totRate + "\n";
            info = info + "\t\tRate M>=6.7: " + (float)rate6p7 + "\n";
            double totRI = 1.0 / totRate;
            double ri6p7 = 1.0 / rate6p7;
            info = info + "\t\tTotal RI: " + (int)Math.round(totRI) + "\n";
            info = info + "\t\tRI M>=6.7: " + (int)Math.round(ri6p7);
        }
        return info;
    }

    private static void writeParentSectionMFDPlot(File dir, List<? extends EvenlyDiscretizedFunc> mfds, List<? extends EvenlyDiscretizedFunc> ucerf2MFDs, List<? extends EvenlyDiscretizedFunc> subSeismoMFDs, List<? extends EvenlyDiscretizedFunc> subPlusSupraSeismoMFDs, int id, String name, boolean nucleation, boolean cumulative) throws IOException {
        CommandLineInversionRunner.writeParentSectMFDPlot(dir, mfds, subSeismoMFDs, subPlusSupraSeismoMFDs, ucerf2MFDs, false, id, name, nucleation, cumulative);
    }

    public static void writeJumpPlots(U3FaultSystemSolutionFetcher fetch, U3BranchWeightProvider weightProvider, File dir, String prefix) throws IOException {
        RupJumpPlot plot = new RupJumpPlot(weightProvider);
        plot.buildPlot(fetch);
        CompoundFSSPlots.writeJumpPlots(plot, dir, prefix);
    }

    public static void writeJumpPlots(RupJumpPlot plot, File dir, String prefix) throws IOException {
        System.out.println("Making rup jump plots for " + plot.weights.size() + " sols");
        File subDir = new File(dir, "rup_jump_plots");
        if (!subDir.exists()) {
            subDir.mkdir();
        }
        for (int i = 0; i < plot.minMags.length; ++i) {
            CommandLineInversionRunner.writeJumpPlot(subDir, prefix, plot.plotSolFuncs.get(i), plot.plotRupSetFuncs.get(i), 1.0, plot.minMags[i], plot.paleoProbs[i]);
        }
    }

    public static void writeSubSectRITables(U3FaultSystemSolutionFetcher fetch, U3BranchWeightProvider weightProvider, File dir, String prefix) throws IOException {
        SubSectRITable plot = new SubSectRITable(weightProvider);
        plot.buildPlot(fetch);
        CompoundFSSPlots.writeSubSectRITables(plot, dir, prefix);
    }

    public static void writeSubSectRITables(SubSectRITable plot, File dir, String prefix) throws IOException {
        System.out.println("Making sub sect RI plot!");
        for (FaultModels fm : plot.csvTable.rowKeySet()) {
            Iterator iterator = plot.csvTable.columnKeySet().iterator();
            while (iterator.hasNext()) {
                double minMag = (Double)iterator.next();
                CSVFile csv = (CSVFile)plot.csvTable.get((Object)fm, (Object)minMag);
                Object fileName = prefix != null && !prefix.isEmpty() ? prefix + "_" : "";
                if (plot.csvTable.rowKeySet().size() > 1) {
                    fileName = (String)fileName + fm.name() + "_";
                }
                fileName = minMag > 0.0 ? (String)fileName + "m" + (float)minMag : (String)fileName + "supra_seis";
                File file = new File(dir, (String)fileName + ".csv");
                csv.writeToFile(file);
            }
            CSVFile<String> csv = plot.mfdCSVs.get(fm);
            Object fileName = prefix != null && !prefix.isEmpty() ? prefix + "_" : "";
            if (plot.csvTable.rowKeySet().size() > 1) {
                fileName = (String)fileName + fm.name() + "_";
            }
            fileName = (String)fileName + "cumulative_mfds";
            File file = new File(dir, (String)fileName + ".csv");
            csv.writeToFile(file);
        }
    }

    public static void writeMiniSectRITables(U3FaultSystemSolutionFetcher fetch, U3BranchWeightProvider weightProvider, File dir, String prefix) throws IOException {
        MiniSectRIPlot plot = new MiniSectRIPlot(weightProvider);
        plot.buildPlot(fetch);
        CompoundFSSPlots.writeMiniSectRITables(plot, dir, prefix);
    }

    public static void writeMiniSectRITables(MiniSectRIPlot plot, File dir, String prefix) throws IOException {
        System.out.println("Making mini sect RI plot!");
        for (FaultModels fm : plot.solRatesMap.keySet()) {
            Map<Integer, DeformationModelFileParser.DeformationSection> dm = plot.loadDM(fm);
            for (int i = 0; i < plot.minMags.length; ++i) {
                File file = new File(dir, prefix + "_" + fm.getShortName() + "_mini_sect_RIs_" + (float)plot.minMags[i] + "+.csv");
                MiniSectRecurrenceGen.writeRates(file, dm, plot.avgRatesMap.get(fm).get(i));
            }
        }
    }

    public static void writeMisfitTables(U3FaultSystemSolutionFetcher fetch, U3BranchWeightProvider weightProvider, File dir, String prefix) throws IOException {
        MisfitTable plot = new MisfitTable();
        plot.buildPlot(fetch);
        CompoundFSSPlots.writeMisfitTables(plot, dir, prefix);
    }

    public static void writeMisfitTables(MisfitTable plot, File dir, String prefix) throws IOException {
        System.out.println("Making mini sect RI plot!");
        BatchPlotGen.writeMisfitsCSV(dir, prefix, plot.misfitsMap);
    }

    public static void writePaleoRatesTables(U3FaultSystemSolutionFetcher fetch, U3BranchWeightProvider weightProvider, File dir, String prefix) throws IOException {
        PaleoRatesTable plot = new PaleoRatesTable(weightProvider);
        plot.buildPlot(fetch);
        CompoundFSSPlots.writePaleoRatesTables(plot, dir, prefix);
    }

    public static void writePaleoRatesTables(PaleoRatesTable plot, File dir, String prefix) throws IOException {
        System.out.println("Making paleo/ave slip tables!");
        File subDir = new File(dir, "paleo_fault_based");
        if (!subDir.exists()) {
            subDir.mkdir();
        }
        for (FaultModels fm : plot.aveSlipCSVOutputMap.keySet()) {
            File aveSlipFile = new File(subDir, fm.getShortName() + "_ave_slip_rates.csv");
            plot.aveSlipCSVOutputMap.get(fm).writeToFile(aveSlipFile);
            File paleoFile = new File(subDir, fm.getShortName() + "_paleo_rates.csv");
            plot.paleoCSVOutputMap.get(fm).writeToFile(paleoFile);
        }
        plot.carrizoCSV.writeToFile(new File(subDir, "carrizo_paleo_obs_rates.csv"));
    }

    public static void writeMeanSolutions(U3FaultSystemSolutionFetcher fetch, U3BranchWeightProvider weightProvider, File dir, String prefix) throws IOException {
        BranchAvgFSSBuilder plot = new BranchAvgFSSBuilder(weightProvider);
        plot.buildPlot(fetch);
        CompoundFSSPlots.writeMeanSolutions(plot, dir, prefix);
    }

    public static void writeMeanSolutions(BranchAvgFSSBuilder plot, File dir, String prefix) throws IOException {
        System.out.println("Making mean solutions!");
        UCERF3PlausibilityConfig laughTest = UCERF3PlausibilityConfig.getDefault();
        GriddedRegion region = plot.region;
        for (FaultModels fm : plot.weightsMap.keySet()) {
            Object myPrefix = prefix;
            U3LogicTreeBranch runningBranch = plot.runningBranches.get(fm);
            for (int i = 0; i < runningBranch.size(); ++i) {
                U3LogicTreeBranchNode val = (U3LogicTreeBranchNode)runningBranch.getValue(i);
                if (val == null || !(val.getRelativeWeight(runningBranch.getValue(InversionModels.class)) < 1.0)) continue;
                if (!((String)myPrefix).isEmpty()) {
                    myPrefix = (String)myPrefix + "_";
                }
                myPrefix = (String)myPrefix + val.encodeChoiceString();
            }
            if (plot.solIndex >= 0) {
                if (!((String)myPrefix).isEmpty()) {
                    myPrefix = (String)myPrefix + "_";
                }
                myPrefix = (String)myPrefix + "run" + plot.solIndex;
            }
            File outputFile = new File(dir, (String)myPrefix + "_MEAN_BRANCH_AVG_SOL.zip");
            double[] rates = plot.ratesMap.get(fm);
            double[] mags = plot.magsMap.get(fm);
            if (rates.length == 229104 || rates.length == 249656) {
                System.err.println("WARNING: Using UCERF3.2 laugh test filter!");
                laughTest = UCERF3PlausibilityConfig.getUCERF3p2Filter();
                DeformationModelFetcher.IMPERIAL_DDW_HACK = true;
            }
            DeformationModels dm = plot.defModelsMap.get(fm).size() == 1 ? plot.defModelsMap.get(fm).iterator().next() : DeformationModels.MEAN_UCERF3;
            InversionFaultSystemRupSet reference = InversionFaultSystemRupSetFactory.forBranch(laughTest, 0.1, U3LogicTreeBranch.getMEAN_UCERF3(fm, dm));
            Object info = reference.getInfoString();
            info = "****** BRANCH AVERAGED SOLUTION FOR " + plot.weightsMap.get(fm).size() + " SOLUTIONS ******\n\n";
            info = (String)info + "****** Logic Tree Branch ******";
            for (int i = 0; i < runningBranch.size(); ++i) {
                U3LogicTreeBranchNode node = (U3LogicTreeBranchNode)runningBranch.getValue(i);
                info = (String)info + "\n" + ClassUtils.getClassNameWithoutPackage(U3LogicTreeBranch.getEnumEnclosingClass(U3LogicTreeBranch.getLogicTreeNodeClasses().get(i))) + ": ";
                info = node == null ? (String)info + "(multiple)" : (String)info + node.name();
            }
            info = (String)info + "\n*******************************";
            ArrayList clusterRups = Lists.newArrayList();
            ArrayList clusterSects = Lists.newArrayList();
            for (int i = 0; i < reference.getNumClusters(); ++i) {
                clusterRups.add(reference.getRupturesForCluster(i));
                clusterSects.add(reference.getSectionsForCluster(i));
            }
            FaultSystemRupSet rupSet = new FaultSystemRupSet(reference.getFaultSectionDataList(), reference.getSectionIndicesForAllRups(), mags, reference.getAveRakeForAllRups(), reference.getAreaForAllRups(), reference.getLengthForAllRups());
            rupSet.setInfoString((String)info);
            GridSourceFileReader gridSources = new GridSourceFileReader(region, plot.nodeSubSeisMFDsMap.get(fm), plot.nodeUnassociatedMFDsMap.get(fm));
            FaultSystemSolution sol = new FaultSystemSolution(rupSet, rates);
            sol.addModule(new SubSeismoOnFaultMFDs(plot.subSeisMFDsMap.get(fm)));
            sol.setGridSourceProvider(gridSources);
            sol.getArchive().write(outputFile);
            DeformationModelFetcher.IMPERIAL_DDW_HACK = false;
        }
    }

    public static List<DiscretizedFunc> getFractiles(XY_DataSetList data, List<Double> weights, String name, double[] fractiles) {
        ArrayList funcs = Lists.newArrayList();
        FractileCurveCalculator calc = new FractileCurveCalculator(data, weights);
        for (double fractile : fractiles) {
            DiscretizedFunc func = (DiscretizedFunc)((Object)calc.getFractile(fractile));
            func.setName(name + " (fractile at " + fractile + ")");
            funcs.add(func);
        }
        DiscretizedFunc meanFunc = (DiscretizedFunc)((Object)calc.getMeanCurve());
        meanFunc.setName(name + " (weighted mean)");
        funcs.add(meanFunc);
        DiscretizedFunc minFunc = (DiscretizedFunc)((Object)calc.getMinimumCurve());
        minFunc.setName(name + " (minimum)");
        funcs.add(minFunc);
        DiscretizedFunc maxFunc = (DiscretizedFunc)((Object)calc.getMaximumCurve());
        maxFunc.setName(name + " (maximum)");
        funcs.add(maxFunc);
        return funcs;
    }

    public static List<PlotCurveCharacterstics> getFractileChars(Color color, int numFractiles) {
        return CompoundFSSPlots.getFractileChars(color, color, numFractiles);
    }

    public static List<PlotCurveCharacterstics> getFractileChars(Color color, Color fractileColor, int numFractiles) {
        ArrayList chars = Lists.newArrayList();
        PlotCurveCharacterstics thinChar = new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, color);
        PlotCurveCharacterstics medChar = new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, fractileColor);
        PlotCurveCharacterstics thickChar = new PlotCurveCharacterstics(PlotLineType.SOLID, 4.0f, color);
        for (int i = 0; i < numFractiles; ++i) {
            chars.add(medChar);
        }
        chars.add(thickChar);
        chars.add(thinChar);
        chars.add(thinChar);
        return chars;
    }

    protected abstract void processSolution(U3LogicTreeBranch var1, InversionFaultSystemSolution var2, int var3);

    protected abstract void combineDistributedCalcs(Collection<CompoundFSSPlots> var1);

    protected void flushResults() {
    }

    protected abstract void doFinalizePlot();

    protected void finalizePlot() {
        Stopwatch watch = Stopwatch.createStarted();
        this.doFinalizePlot();
        watch.stop();
        this.addToFinalizeTimeCount(watch.elapsed(TimeUnit.MILLISECONDS));
    }

    protected boolean usesERFs() {
        return false;
    }

    protected boolean isApplyAftershockFilter() {
        return false;
    }

    protected boolean isTimeDependent() {
        return false;
    }

    protected void processERF(U3LogicTreeBranch branch, FaultSystemSolutionERF erf, int solIndex) {
        if (this.usesERFs()) {
            throw new IllegalStateException("Must be overridden if usesERFs() == true");
        }
        throw new IllegalStateException("Should not be called if usesERFs() == false");
    }

    private static synchronized String getHostname() {
        if (hostname == null) {
            try {
                hostname = InetAddress.getLocalHost().getHostName();
                if (hostname.contains(".")) {
                    hostname = hostname.split("\\.")[0];
                }
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return hostname;
    }

    private synchronized String getClassName() {
        if (this.className == null) {
            this.className = ClassUtils.getClassNameWithoutPackage(this.getClass());
            while (this.className.contains("$")) {
                this.className = this.className.substring(this.className.indexOf("$") + 1);
            }
        }
        return this.className;
    }

    protected void debug(int solIndex, String message) {
        System.out.println("[" + df.format(new Date()) + " (" + CompoundFSSPlots.getHostname() + ") " + this.getClassName() + "(" + solIndex + ")]: " + message);
    }

    protected synchronized void addToComputeTimeCount(long time) {
        this.computeTimeMillis += time;
    }

    protected long getComputeTimeCount() {
        return this.computeTimeMillis;
    }

    protected synchronized void addToFinalizeTimeCount(long time) {
        this.finalizeTimeMillis += time;
    }

    protected long getFinalizeTimeCount() {
        return this.finalizeTimeMillis;
    }

    public void buildPlot(U3FaultSystemSolutionFetcher fetcher) {
        ArrayList<CompoundFSSPlots> plots = new ArrayList<CompoundFSSPlots>();
        plots.add(this);
        CompoundFSSPlots.batchPlot(plots, fetcher);
    }

    public static void batchPlot(Collection<CompoundFSSPlots> plots, U3FaultSystemSolutionFetcher fetcher) {
        int threads = Runtime.getRuntime().availableProcessors();
        threads *= 3;
        if ((threads /= 4) < 1) {
            threads = 1;
        }
        CompoundFSSPlots.batchPlot(plots, fetcher, threads);
    }

    public static void batchPlot(Collection<CompoundFSSPlots> plots, U3FaultSystemSolutionFetcher fetcher, int threads) {
        ArrayList tasks = Lists.newArrayList();
        int index = 0;
        for (U3LogicTreeBranch branch : fetcher.getBranches()) {
            tasks.add(new PlotSolComputeTask(plots, fetcher, branch, index++));
        }
        System.out.println("Making " + plots.size() + " plot(s) with " + tasks.size() + " branches");
        ThreadedTaskComputer comp = new ThreadedTaskComputer(tasks);
        try {
            comp.computeThreaded(threads);
        }
        catch (InterruptedException e) {
            ExceptionUtils.throwAsRuntimeException(e);
        }
        for (CompoundFSSPlots plot : plots) {
            plot.flushResults();
        }
        for (CompoundFSSPlots plot : plots) {
            plot.finalizePlot();
        }
        long overheadTime = 0L;
        for (Task task : tasks) {
            overheadTime += ((PlotSolComputeTask)task).overheadMillis;
        }
        float overheadMins = (float)((double)overheadTime / (double)MILLIS_PER_MIN);
        System.out.println("TOTAL OVERHEAD TIME: " + overheadMins + "m");
        CompoundFSSPlots.printComputeTimes(plots);
    }

    protected static void printComputeTimes(Collection<CompoundFSSPlots> plots) {
        long totCompTime = 0L;
        long totFinalizeTime = 0L;
        for (CompoundFSSPlots plot : plots) {
            totCompTime += plot.computeTimeMillis;
            totFinalizeTime += plot.finalizeTimeMillis;
        }
        double totCompTimeMins = (double)totCompTime / (double)MILLIS_PER_MIN;
        double totFinalizeTimeMins = (double)totFinalizeTime / (double)MILLIS_PER_MIN;
        System.out.println("*** CompoundFSSPlots Compute Times ***");
        System.out.println("TOTAL COMPUTE TIME: " + totCompTimeMins + " m");
        for (CompoundFSSPlots plot : plots) {
            float compTimeMins = (float)((double)plot.computeTimeMillis / (double)MILLIS_PER_MIN);
            float compTimePercent = (float)(100.0 * (double)compTimeMins / totCompTimeMins);
            System.out.println("\t" + ClassUtils.getClassNameWithoutPackage(plot.getClass()) + ": " + compTimeMins + " m (" + compTimePercent + " %)");
        }
        System.out.println("***************************************");
        System.out.println("*** CompoundFSSPlots Finalize Times ***");
        System.out.println("TOTAL FINALIZE TIME: " + totFinalizeTimeMins + " m");
        for (CompoundFSSPlots plot : plots) {
            float finalizeTimeMins = (float)((double)plot.finalizeTimeMillis / (double)MILLIS_PER_MIN);
            float finalizeTimePercent = (float)(100.0 * (double)finalizeTimeMins / totFinalizeTimeMins);
            System.out.println("\t" + ClassUtils.getClassNameWithoutPackage(plot.getClass()) + ": " + finalizeTimeMins + " m (" + finalizeTimePercent + " %)");
        }
        System.out.println("***************************************");
    }

    public static void batchWritePlots(Collection<CompoundFSSPlots> plots, File dir, String prefix) throws Exception {
        CompoundFSSPlots.batchWritePlots(plots, dir, prefix, true);
    }

    public static void batchWritePlots(Collection<CompoundFSSPlots> plots, File dir, String prefix, boolean makeMapPlots) throws Exception {
        for (CompoundFSSPlots plot : plots) {
            File paleoPlotsDir;
            CompoundFSSPlots paleo;
            CompoundFSSPlots mfd;
            if (plot instanceof RegionalMFDPlot) {
                mfd = (RegionalMFDPlot)plot;
                CompoundFSSPlots.writeRegionalMFDPlots(((RegionalMFDPlot)mfd).specs, ((RegionalMFDPlot)mfd).cumulative_specs, ((RegionalMFDPlot)mfd).getRegions(), dir, prefix);
                continue;
            }
            if (plot instanceof ERFBasedRegionalMFDPlot) {
                mfd = (ERFBasedRegionalMFDPlot)plot;
                CompoundFSSPlots.writeERFBasedRegionalMFDPlots(((ERFBasedRegionalMFDPlot)mfd).specs, ((ERFBasedRegionalMFDPlot)mfd).regions, dir, prefix);
                continue;
            }
            if (plot instanceof ERFBasedRegionalMagProbPlot) {
                mfd = (ERFBasedRegionalMagProbPlot)plot;
                CompoundFSSPlots.writeERFBasedRegionalProbDistPlots((ERFBasedRegionalMagProbPlot)mfd, dir, prefix);
                continue;
            }
            if (plot instanceof ERFBasedSiteHazardHistPlot) {
                ERFBasedSiteHazardHistPlot haz = (ERFBasedSiteHazardHistPlot)plot;
                CompoundFSSPlots.writeERFBasedSiteHazardHists(haz, dir);
                continue;
            }
            if (plot instanceof ERFProbModelCalc) {
                ERFProbModelCalc prob = (ERFProbModelCalc)plot;
                File probModelDir = new File(dir, "time_dep_rup_probs");
                CompoundFSSPlots.writeERFProbModelsFile(probModelDir, prob.probsTable);
                continue;
            }
            if (plot instanceof PaleoFaultPlot) {
                paleo = (PaleoFaultPlot)plot;
                paleoPlotsDir = new File(dir, "paleo_fault_based");
                if (!paleoPlotsDir.exists()) {
                    // empty if block
                }
                paleoPlotsDir.mkdir();
                CompoundFSSPlots.writePaleoFaultPlots(((PaleoFaultPlot)paleo).getPlotsMap(), paleoPlotsDir);
                continue;
            }
            if (plot instanceof PaleoSiteCorrelationPlot) {
                paleo = (PaleoSiteCorrelationPlot)plot;
                paleoPlotsDir = new File(dir, "paleo_correlation");
                if (!paleoPlotsDir.exists()) {
                    paleoPlotsDir.mkdir();
                }
                CompoundFSSPlots.writePaleoCorrelationPlots(((PaleoSiteCorrelationPlot)paleo).getPlotsMap(), paleoPlotsDir);
                continue;
            }
            if (plot instanceof ParentSectMFDsPlot) {
                ParentSectMFDsPlot parentPlots = (ParentSectMFDsPlot)plot;
                File parentPlotsDir = new File(dir, "parent_sect_mfds");
                if (!parentPlotsDir.exists()) {
                    parentPlotsDir.mkdir();
                }
                CompoundFSSPlots.writeParentSectionMFDPlots(parentPlots, parentPlotsDir);
                continue;
            }
            if (plot instanceof RupJumpPlot) {
                RupJumpPlot jumpPlot = (RupJumpPlot)plot;
                CompoundFSSPlots.writeJumpPlots(jumpPlot, dir, prefix);
                continue;
            }
            if (plot instanceof SubSectRITable) {
                SubSectRITable subSectPlot = (SubSectRITable)plot;
                CompoundFSSPlots.writeSubSectRITables(subSectPlot, dir, prefix);
                continue;
            }
            if (plot instanceof MiniSectRIPlot) {
                MiniSectRIPlot miniPlot = (MiniSectRIPlot)plot;
                CompoundFSSPlots.writeMiniSectRITables(miniPlot, dir, prefix);
                continue;
            }
            if (plot instanceof PaleoRatesTable) {
                PaleoRatesTable aveSlip = (PaleoRatesTable)plot;
                CompoundFSSPlots.writePaleoRatesTables(aveSlip, dir, prefix);
                continue;
            }
            if (plot instanceof MisfitTable) {
                MisfitTable table = (MisfitTable)plot;
                BatchPlotGen.writeMisfitsCSV(dir, prefix, table.misfitsMap);
                continue;
            }
            if (plot instanceof BranchAvgFSSBuilder) {
                BranchAvgFSSBuilder builder = (BranchAvgFSSBuilder)plot;
                CompoundFSSPlots.writeMeanSolutions(builder, dir, prefix);
                continue;
            }
            if (!(plot instanceof MapBasedPlot)) continue;
            MapBasedPlot faultPlot = (MapBasedPlot)plot;
            faultPlot.writePlotData(dir);
            faultPlot.writeExtraData(dir, prefix);
            if (!makeMapPlots) continue;
            faultPlot.makeMapPlots(dir, prefix);
        }
    }

    private static void writeU2RegProbTable(File csvFile, boolean nucleation) throws ZipException, IOException {
        File compoundFile = new File(new File(UCERF3_DataUtils.DEFAULT_SCRATCH_DATA_DIR, "InversionSolutions"), "2013_05_10-ucerf3p3-production-10runs_COMPOUND_SOL.zip");
        ERFBasedRegionalMagProbPlot.NUCLEATION_PROBS = nucleation;
        U3FaultSystemSolutionFetcher fetch = U3CompoundFaultSystemSolution.fromZipFile(compoundFile);
        U3APrioriBranchWeightProvider weightProvider = new U3APrioriBranchWeightProvider();
        int threads = 3;
        fetch = U3FaultSystemSolutionFetcher.getRandomSample(fetch, threads, FaultModels.FM3_1);
        ArrayList plots = Lists.newArrayList();
        ERFBasedRegionalMagProbPlot withAftershocks = new ERFBasedRegionalMagProbPlot(weightProvider);
        ERFBasedRegionalMagProbPlot.INCLUDE_AFTERSHOCKS = true;
        plots.add(withAftershocks);
        CompoundFSSPlots.batchPlot(plots, fetch, threads);
        plots = Lists.newArrayList();
        ERFBasedRegionalMagProbPlot withoutAftershocks = new ERFBasedRegionalMagProbPlot(weightProvider);
        ERFBasedRegionalMagProbPlot.INCLUDE_AFTERSHOCKS = false;
        plots.add(withoutAftershocks);
        CompoundFSSPlots.batchPlot(plots, fetch, threads);
        CSVFile<String> csv = new CSVFile<String>(true);
        csv.addLine("Region", "U2 w/o Aftershock Mean", "U2 w/o Aftershock Min", "U2 w/o Aftershock Max", "U2 w/ Aftershock Mean", "U2 w/ Aftershock Min", "U2 w/ Aftershock Max");
        double duration = 30.0;
        double mag = 6.7;
        ERFBasedRegionalMagProbPlot[] probs = new ERFBasedRegionalMagProbPlot[]{withoutAftershocks, withAftershocks};
        List<Region> defaultRegions = ERFBasedRegionalMagProbPlot.getDefaultRegions();
        for (int i = 0; i < defaultRegions.size(); ++i) {
            Region r = defaultRegions.get(i);
            ArrayList line = Lists.newArrayList();
            line.add(r.getName());
            for (ERFBasedRegionalMagProbPlot prob : probs) {
                XY_DataSetList ucerf2Funcs = new XY_DataSetList();
                ArrayList<Double> ucerf2Weights = new ArrayList<Double>();
                for (int e = 0; e < prob.ucerf2DepMPDs.get(duration).get(i).length; ++e) {
                    EvenlyDiscretizedFunc mfd = prob.ucerf2DepMPDs.get(duration).get(i)[e];
                    if (mfd == null) continue;
                    ucerf2Funcs.add(prob.ucerf2DepMPDs.get(duration).get(i)[e]);
                    ucerf2Weights.add(prob.ucerf2DepWeights[e]);
                }
                List<DiscretizedFunc> fractiles = CompoundFSSPlots.getFractiles(ucerf2Funcs, ucerf2Weights, "asdf", new double[0]);
                double mean = fractiles.get(0).getY(mag);
                double min = fractiles.get(1).getY(mag);
                double max = fractiles.get(2).getY(mag);
                line.add("" + mean);
                line.add("" + min);
                line.add("" + max);
            }
            csv.addLine(line);
        }
        csv.writeToFile(csvFile);
    }

    private static boolean hasBothFMs(U3FaultSystemSolutionFetcher fetch) {
        boolean has31 = false;
        boolean has32 = false;
        for (U3LogicTreeBranch branch : fetch.getBranches()) {
            FaultModels fm = branch.getValue(FaultModels.class);
            if (fm == FaultModels.FM3_1) {
                has31 = true;
            }
            if (fm == FaultModels.FM3_2) {
                has32 = true;
            }
            if (!has31 || !has32) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] args) throws ZipException, Exception {
        boolean meanDebug;
        if (args.length >= 3) {
            File dir = new File(args[0]);
            String prefix = args[1];
            for (int i = 2; i < args.length; ++i) {
                File plotFile = new File(dir, args[i]);
                MapBasedPlot.makeMapPlots(dir, prefix, MapBasedPlot.loadPlotData(plotFile));
            }
            System.exit(0);
        }
        U3APrioriBranchWeightProvider weightProvider = new U3APrioriBranchWeightProvider();
        File dir = new File("/tmp/comp_plots");
        File file = new File(dir, "2013_05_10-ucerf3p3-production-10runs_COMPOUND_SOL.zip");
        U3FaultSystemSolutionFetcher fetch = U3CompoundFaultSystemSolution.fromZipFile(file);
        double wts = 0.0;
        for (U3LogicTreeBranch branch : fetch.getBranches()) {
            wts += weightProvider.getWeight(branch);
        }
        System.out.println("Total weight: " + wts);
        int sols = 8;
        int threads = 4;
        if (sols > 0) {
            fetch = U3FaultSystemSolutionFetcher.getRandomSample(fetch, sols, FaultModels.FM3_1);
            System.out.println("Now has " + fetch.getBranches().size() + " branches");
        }
        if (meanDebug = false) {
            final Collection<U3LogicTreeBranch> branches = fetch.getBranches();
            final InversionFaultSystemSolution meanSol = U3FaultSystemIO.loadInvSol(new File(new File(UCERF3_DataUtils.DEFAULT_SCRATCH_DATA_DIR, "InversionSolutions"), "2013_05_10-ucerf3p3-production-10runs_COMPOUND_SOL_FM3_1_MEAN_BRANCH_AVG_SOL.zip"));
            fetch = new U3FaultSystemSolutionFetcher(){

                @Override
                public Collection<U3LogicTreeBranch> getBranches() {
                    return branches;
                }

                @Override
                protected InversionFaultSystemSolution fetchSolution(U3LogicTreeBranch branch) {
                    return meanSol;
                }
            };
        }
        new DeadlockDetectionThread(3000L).start();
        ArrayList regions = RegionalMFDPlot.getDefaultRegions().subList(0, 1);
        regions = Lists.newArrayList(regions);
        String prefix = dir.getName();
        ArrayList plots = Lists.newArrayList();
        plots.add(new SubSectRITable(weightProvider));
        CompoundFSSPlots.batchPlot(plots, fetch, threads);
        CompoundFSSPlots.batchWritePlots(plots, dir, prefix, true);
        System.exit(0);
    }

    static {
        df = new SimpleDateFormat("HH:mm:ss.SSS");
        MILLIS_PER_SEC = 1000L;
        MILLIS_PER_MIN = MILLIS_PER_SEC * 60L;
    }

    public static class RegionalMFDPlot
    extends CompoundFSSPlots {
        private transient U3BranchWeightProvider weightProvider;
        private List<Region> regions;
        private List<Double> weights;
        private double[] fractiles;
        private List<XY_DataSetList> solMFDs;
        private List<XY_DataSetList> solOffMFDs;
        private List<XY_DataSetList> solTotalMFDs;
        private static final double minX = 5.05;
        private static final double maxX = 9.05;
        private static final double delta = 0.1;
        private List<PlotSpec> specs;
        private List<PlotSpec> cumulative_specs;
        private static final boolean[] cumulatives = new boolean[]{false, true};

        public static List<Region> getDefaultRegions() {
            ArrayList regions = Lists.newArrayList();
            regions.add(new CaliforniaRegions.RELM_TESTING());
            regions.add(new CaliforniaRegions.RELM_NOCAL());
            regions.add(new CaliforniaRegions.RELM_SOCAL());
            regions.add(new CaliforniaRegions.LA_BOX());
            regions.add(new CaliforniaRegions.SF_BOX());
            regions.add(new CaliforniaRegions.NORTHRIDGE_BOX());
            return regions;
        }

        public RegionalMFDPlot(U3BranchWeightProvider weightProvider, List<Region> regions) {
            this(weightProvider, regions, new double[0]);
        }

        public RegionalMFDPlot(U3BranchWeightProvider weightProvider, List<Region> regions, double[] fractiles) {
            this.weightProvider = weightProvider;
            this.regions = regions;
            this.fractiles = fractiles;
            this.solMFDs = Lists.newArrayList();
            this.solOffMFDs = Lists.newArrayList();
            this.solTotalMFDs = Lists.newArrayList();
            for (int i = 0; i < regions.size(); ++i) {
                this.solMFDs.add(new XY_DataSetList());
                this.solOffMFDs.add(new XY_DataSetList());
                this.solTotalMFDs.add(new XY_DataSetList());
            }
            this.weights = Lists.newArrayList();
        }

        private static boolean isStatewide(Region region) {
            return region.getName().startsWith("RELM_TESTING");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void processSolution(U3LogicTreeBranch branch, InversionFaultSystemSolution sol, int solIndex) {
            double wt = this.weightProvider.getWeight(branch);
            ArrayList onMFDs = Lists.newArrayList();
            ArrayList offMFDs = Lists.newArrayList();
            ArrayList totMFDs = Lists.newArrayList();
            for (int i = 0; i < this.regions.size(); ++i) {
                this.debug(solIndex, "calculating region " + i);
                Region region = this.regions.get(i);
                IncrementalMagFreqDist onMFD = sol.calcNucleationMFD_forRegion(region, 5.05, 9.05, 0.1, true);
                onMFDs.add(onMFD);
                if (RegionalMFDPlot.isStatewide(region)) {
                    IncrementalMagFreqDist offMFD = sol.getFinalTotalGriddedSeisMFD();
                    IncrementalMagFreqDist trimmedOffMFD = new IncrementalMagFreqDist(onMFD.getMinX(), onMFD.getMaxX(), onMFD.size());
                    IncrementalMagFreqDist totMFD = new IncrementalMagFreqDist(onMFD.getMinX(), onMFD.getMaxX(), onMFD.size());
                    for (int n = 0; n < trimmedOffMFD.size(); ++n) {
                        double x = trimmedOffMFD.getX(n);
                        if (x <= offMFD.getMaxX()) {
                            trimmedOffMFD.set(n, offMFD.getY(x));
                        }
                        totMFD.set(n, onMFD.getY(n) + trimmedOffMFD.getY(n));
                    }
                    offMFDs.add(trimmedOffMFD);
                    totMFDs.add(totMFD);
                } else {
                    offMFDs.add(null);
                    totMFDs.add(null);
                }
                this.debug(solIndex, "DONE calculating region " + i);
            }
            this.debug(solIndex, "archiving");
            RegionalMFDPlot regionalMFDPlot = this;
            synchronized (regionalMFDPlot) {
                this.weights.add(wt);
                for (int i = 0; i < this.regions.size(); ++i) {
                    this.solMFDs.get(i).add((XY_DataSet)onMFDs.get(i));
                    if (offMFDs.get(i) != null) {
                        this.solOffMFDs.get(i).add((XY_DataSet)offMFDs.get(i));
                    }
                    if (totMFDs.get(i) == null) continue;
                    this.solTotalMFDs.get(i).add((XY_DataSet)totMFDs.get(i));
                }
            }
            this.debug(solIndex, "DONE archiving");
        }

        @Override
        protected void doFinalizePlot() {
            UCERF2_MFD_ConstraintFetcher ucerf2Fetch = null;
            System.out.println("Finalizing MFD plot for " + this.solMFDs.get(0).size() + " branches!");
            this.specs = Lists.newArrayList();
            this.cumulative_specs = Lists.newArrayList();
            for (int i = 0; i < this.regions.size(); ++i) {
                Region region = this.regions.get(i);
                for (boolean cumulative : cumulatives) {
                    String title;
                    XY_DataSetList solMFDsForRegion = this.solMFDs.get(i);
                    XY_DataSetList solOffMFDsForRegion = this.solOffMFDs.get(i);
                    XY_DataSetList totalMFDsForRegion = this.solTotalMFDs.get(i);
                    if (ucerf2Fetch == null) {
                        ucerf2Fetch = new UCERF2_MFD_ConstraintFetcher(region);
                    } else {
                        ucerf2Fetch.setRegion(region);
                    }
                    EvenlyDiscretizedFunc ucerf2TotalMFD = ucerf2Fetch.getTotalMFD();
                    EvenlyDiscretizedFunc ucerf2OffMFD = ucerf2Fetch.getBackgroundSeisMFD();
                    if (cumulative) {
                        int j;
                        XY_DataSetList cml_solMFDsForRegion = new XY_DataSetList();
                        XY_DataSetList cml_solOffMFDsForRegion = new XY_DataSetList();
                        XY_DataSetList cml_totalMFDsForRegion = new XY_DataSetList();
                        for (j = 0; j < solMFDsForRegion.size(); ++j) {
                            cml_solMFDsForRegion.add(((IncrementalMagFreqDist)solMFDsForRegion.get(j)).getCumRateDistWithOffset());
                        }
                        for (j = 0; j < solOffMFDsForRegion.size(); ++j) {
                            cml_solOffMFDsForRegion.add(((IncrementalMagFreqDist)solOffMFDsForRegion.get(j)).getCumRateDistWithOffset());
                        }
                        for (j = 0; j < totalMFDsForRegion.size(); ++j) {
                            cml_totalMFDsForRegion.add(((IncrementalMagFreqDist)totalMFDsForRegion.get(j)).getCumRateDistWithOffset());
                        }
                        solMFDsForRegion = cml_solMFDsForRegion;
                        solOffMFDsForRegion = cml_solOffMFDsForRegion;
                        totalMFDsForRegion = cml_totalMFDsForRegion;
                        ucerf2TotalMFD = ((IncrementalMagFreqDist)ucerf2TotalMFD).getCumRateDistWithOffset();
                        ucerf2OffMFD = ((IncrementalMagFreqDist)ucerf2OffMFD).getCumRateDistWithOffset();
                    }
                    ArrayList funcs = Lists.newArrayList();
                    ArrayList chars = Lists.newArrayList();
                    funcs.add(ucerf2TotalMFD);
                    chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, BROWN));
                    funcs.add(ucerf2OffMFD);
                    chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, Color.MAGENTA));
                    if (!solOffMFDsForRegion.isEmpty()) {
                        if (cumulative) {
                            funcs.add(U3InversionTargetMFDs.getTotalTargetGR_upToM9(TotalMag5Rate.RATE_9p6.getRateMag5()).getCumRateDistWithOffset());
                            funcs.add(U3InversionTargetMFDs.getTotalTargetGR_upToM9(TotalMag5Rate.RATE_7p9.getRateMag5()).getCumRateDistWithOffset());
                            funcs.add(U3InversionTargetMFDs.getTotalTargetGR_upToM9(TotalMag5Rate.RATE_6p5.getRateMag5()).getCumRateDistWithOffset());
                        } else {
                            funcs.add(U3InversionTargetMFDs.getTotalTargetGR_upToM9(TotalMag5Rate.RATE_9p6.getRateMag5()));
                            funcs.add(U3InversionTargetMFDs.getTotalTargetGR_upToM9(TotalMag5Rate.RATE_7p9.getRateMag5()));
                            funcs.add(U3InversionTargetMFDs.getTotalTargetGR_upToM9(TotalMag5Rate.RATE_6p5.getRateMag5()));
                        }
                        chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, Color.BLACK));
                        chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLACK));
                        chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, Color.BLACK));
                        funcs.addAll(RegionalMFDPlot.getFractiles(solOffMFDsForRegion, this.weights, "Solution Off Fault MFDs", this.fractiles));
                        chars.addAll(RegionalMFDPlot.getFractileChars(Color.GRAY, this.fractiles.length));
                    }
                    funcs.addAll(RegionalMFDPlot.getFractiles(solMFDsForRegion, this.weights, "Solution On Fault MFDs", this.fractiles));
                    chars.addAll(RegionalMFDPlot.getFractileChars(Color.BLUE, this.fractiles.length));
                    if (!totalMFDsForRegion.isEmpty()) {
                        funcs.addAll(RegionalMFDPlot.getFractiles(totalMFDsForRegion, this.weights, "Solution Total MFDs", this.fractiles));
                        chars.addAll(RegionalMFDPlot.getFractileChars(Color.RED, this.fractiles.length));
                    }
                    if ((title = region.getName()) == null || title.isEmpty()) {
                        title = "Unnamed Region";
                    }
                    String xAxisLabel = "Magnitude";
                    String yAxisLabel = cumulative ? "Cumulative Rate (per yr)" : "Incremental Rate (per yr)";
                    PlotSpec spec = new PlotSpec(funcs, chars, title, xAxisLabel, yAxisLabel);
                    if (cumulative) {
                        this.cumulative_specs.add(spec);
                        continue;
                    }
                    this.specs.add(spec);
                }
            }
        }

        @Override
        protected void combineDistributedCalcs(Collection<CompoundFSSPlots> otherCalcs) {
            for (CompoundFSSPlots otherCalc : otherCalcs) {
                RegionalMFDPlot o = (RegionalMFDPlot)otherCalc;
                this.weights.addAll(o.weights);
                for (int r = 0; r < this.regions.size(); ++r) {
                    this.solMFDs.get(r).addAll(o.solMFDs.get(r));
                    this.solOffMFDs.get(r).addAll(o.solOffMFDs.get(r));
                    this.solTotalMFDs.get(r).addAll(o.solTotalMFDs.get(r));
                }
            }
        }

        protected List<Region> getRegions() {
            return this.regions;
        }

        protected List<PlotSpec> getSpecs() {
            return this.specs;
        }
    }

    public static class ERFBasedRegionalMFDPlot
    extends CompoundFSSPlots {
        private static final long serialVersionUID = 1L;
        private static final boolean infer_off_fault = false;
        private static final boolean INCLUDE_AFTERSHOCKS = true;
        private transient U3BranchWeightProvider weightProvider;
        private List<Region> regions;
        private List<Double> weights;
        private double[] ucerf2Weights;
        private double[] fractiles;
        private List<XY_DataSetList> solMFDs;
        private List<XY_DataSetList> solOnMFDs;
        private List<XY_DataSetList> solOffMFDs;
        private List<EvenlyDiscretizedFunc[]> ucerf2MFDs;
        private List<EvenlyDiscretizedFunc[]> ucerf2OnMFDs;
        private List<EvenlyDiscretizedFunc[]> ucerf2OffMFDs;
        private transient Deque<UCERF2_TimeIndependentEpistemicList> ucerf2_erf_lists = new ArrayDeque<UCERF2_TimeIndependentEpistemicList>();
        private static final double minX = 5.05;
        private static final double maxX = 9.05;
        private static final double delta = 0.1;
        private static final int num = 41;
        private List<PlotSpec> specs;
        private int numUCEF2_ERFs;
        private transient Map<FaultModels, RupInRegionCache> rupInRegionsCaches = Maps.newHashMap();

        public static List<Region> getDefaultRegions() {
            ArrayList regions = Lists.newArrayList();
            regions.add(new CaliforniaRegions.RELM_TESTING());
            regions.add(new CaliforniaRegions.LA_BOX());
            regions.add(new CaliforniaRegions.SF_BOX());
            regions.add(new CaliforniaRegions.NORTHRIDGE_BOX());
            return regions;
        }

        private static double[] getDefaultFractiles() {
            double[] ret = new double[]{};
            return ret;
        }

        public ERFBasedRegionalMFDPlot(U3BranchWeightProvider weightProvider) {
            this(weightProvider, ERFBasedRegionalMFDPlot.getDefaultRegions());
        }

        public ERFBasedRegionalMFDPlot(U3BranchWeightProvider weightProvider, List<Region> regions) {
            this(weightProvider, regions, ERFBasedRegionalMFDPlot.getDefaultFractiles());
        }

        public ERFBasedRegionalMFDPlot(U3BranchWeightProvider weightProvider, List<Region> regions, double[] fractiles) {
            this.weightProvider = weightProvider;
            this.regions = regions;
            this.fractiles = fractiles;
            UCERF2_TimeIndependentEpistemicList ucerf2_erf_list = this.checkOutUCERF2_ERF();
            this.numUCEF2_ERFs = ucerf2_erf_list.getNumERFs();
            this.returnUCERF2_ERF(ucerf2_erf_list);
            ucerf2_erf_list = null;
            this.solMFDs = Lists.newArrayList();
            this.solOnMFDs = Lists.newArrayList();
            this.solOffMFDs = Lists.newArrayList();
            this.ucerf2MFDs = Lists.newArrayList();
            this.ucerf2OnMFDs = Lists.newArrayList();
            this.ucerf2OffMFDs = Lists.newArrayList();
            this.weights = Lists.newArrayList();
            this.ucerf2Weights = new double[this.numUCEF2_ERFs];
            for (int i = 0; i < regions.size(); ++i) {
                this.solMFDs.add(new XY_DataSetList());
                this.solOnMFDs.add(new XY_DataSetList());
                this.solOffMFDs.add(new XY_DataSetList());
                this.ucerf2MFDs.add(new EvenlyDiscretizedFunc[this.numUCEF2_ERFs]);
                this.ucerf2OnMFDs.add(new EvenlyDiscretizedFunc[this.numUCEF2_ERFs]);
                this.ucerf2OffMFDs.add(new EvenlyDiscretizedFunc[this.numUCEF2_ERFs]);
            }
        }

        private synchronized UCERF2_TimeIndependentEpistemicList checkOutUCERF2_ERF() {
            if (this.ucerf2_erf_lists.isEmpty()) {
                UCERF2_TimeIndependentEpistemicList ucerf2_erf_list = new UCERF2_TimeIndependentEpistemicList();
                ucerf2_erf_list.setParameter("Floater Type", "Only along strike ( rupture full DDW)");
                ucerf2_erf_list.setParameter(UCERF2.BACK_SEIS_NAME, UCERF2.BACK_SEIS_INCLUDE);
                ucerf2_erf_list.setParameter(UCERF2.BACK_SEIS_RUP_NAME, UCERF2.BACK_SEIS_RUP_POINT);
                ucerf2_erf_list.getTimeSpan().setDuration(1.0);
                ucerf2_erf_list.updateForecast();
                return ucerf2_erf_list;
            }
            return this.ucerf2_erf_lists.pop();
        }

        private synchronized void returnUCERF2_ERF(UCERF2_TimeIndependentEpistemicList erf) {
            this.ucerf2_erf_lists.push(erf);
        }

        private void calcUCERF2MFDs(int erfIndex) {
            IncrementalMagFreqDist mfdPart;
            Region region;
            int regionIndex;
            UCERF2_TimeIndependentEpistemicList ucerf2_erf_list = this.checkOutUCERF2_ERF();
            ERF erf = ucerf2_erf_list.getERF(erfIndex);
            this.ucerf2Weights[erfIndex] = ucerf2_erf_list.getERF_RelativeWeight(erfIndex);
            System.out.println("Calculating UCERF2 On Fault MFDs for branch " + erfIndex + ", " + this.regions.size() + " regions");
            ucerf2_erf_list.getParameter(UCERF2.BACK_SEIS_NAME).setValue(UCERF2.BACK_SEIS_EXCLUDE);
            erf = ucerf2_erf_list.getERF(erfIndex);
            for (regionIndex = 0; regionIndex < this.regions.size(); ++regionIndex) {
                region = this.regions.get(regionIndex);
                mfdPart = ERF_Calculator.getParticipationMagFreqDistInRegion(erf, region, 5.05, 41, 0.1, true);
                ((SummedMagFreqDist)mfdPart).scale(1.0309278350515465);
                this.ucerf2OnMFDs.get((int)regionIndex)[erfIndex] = mfdPart.getCumRateDistWithOffset();
            }
            System.out.println("Calculating UCERF2 Off Fault MFDs for branch " + erfIndex + ", " + this.regions.size() + " regions");
            ucerf2_erf_list.getParameter(UCERF2.BACK_SEIS_NAME).setValue(UCERF2.BACK_SEIS_ONLY);
            erf = ucerf2_erf_list.getERF(erfIndex);
            for (regionIndex = 0; regionIndex < this.regions.size(); ++regionIndex) {
                region = this.regions.get(regionIndex);
                mfdPart = ERF_Calculator.getParticipationMagFreqDistInRegion(erf, region, 5.05, 41, 0.1, true);
                IncrementalMagFreqDist scaled = new IncrementalMagFreqDist(mfdPart.getMinX(), mfdPart.size(), mfdPart.getDelta());
                for (int i = 0; i < mfdPart.size(); ++i) {
                    double scale = GardnerKnopoffAftershockFilter.scaleForMagnitude(mfdPart.getX(i));
                    scaled.set(i, mfdPart.getY(i) / scale);
                }
                mfdPart = scaled;
                this.ucerf2OffMFDs.get((int)regionIndex)[erfIndex] = mfdPart.getCumRateDistWithOffset();
            }
            System.out.println("Calculating UCERF2 MFDs for branch " + erfIndex + ", " + this.regions.size() + " regions");
            for (regionIndex = 0; regionIndex < this.regions.size(); ++regionIndex) {
                SummedMagFreqDist summedMFD = new SummedMagFreqDist(5.0, 41, 0.1);
                summedMFD.addIncrementalMagFreqDist(this.ucerf2OnMFDs.get(regionIndex)[erfIndex]);
                summedMFD.addIncrementalMagFreqDist(this.ucerf2OffMFDs.get(regionIndex)[erfIndex]);
                this.ucerf2MFDs.get((int)regionIndex)[erfIndex] = summedMFD;
            }
            ucerf2_erf_list.getParameter(UCERF2.BACK_SEIS_NAME).setValue(UCERF2.BACK_SEIS_INCLUDE);
            this.returnUCERF2_ERF(ucerf2_erf_list);
        }

        private void checkCalcAllUCERF2MFDs() {
            for (int erfIndex = 0; erfIndex < this.numUCEF2_ERFs; ++erfIndex) {
                if (this.ucerf2MFDs.get(0)[erfIndex] != null) continue;
                this.calcUCERF2MFDs(erfIndex);
            }
        }

        @Override
        protected void processSolution(U3LogicTreeBranch branch, InversionFaultSystemSolution sol, int solIndex) {
            throw new IllegalStateException("Should not be called, ERF plot!");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void processERF(U3LogicTreeBranch branch, FaultSystemSolutionERF erf, int solIndex) {
            SummedMagFreqDist ucerf3_Part;
            Stopwatch watch;
            Region region;
            int r;
            this.debug(solIndex, "checking UCERF2");
            if (solIndex < this.numUCEF2_ERFs) {
                this.calcUCERF2MFDs(solIndex);
            }
            this.debug(solIndex, " done UCERF2");
            FaultModels fm = branch.getValue(FaultModels.class);
            RupInRegionCache rupsCache = this.rupInRegionsCaches.get(fm);
            if (rupsCache == null) {
                ERFBasedRegionalMFDPlot eRFBasedRegionalMFDPlot = this;
                synchronized (eRFBasedRegionalMFDPlot) {
                    if (!this.rupInRegionsCaches.containsKey(fm)) {
                        this.rupInRegionsCaches.put(fm, new RupInRegionsCache());
                    }
                }
                rupsCache = this.rupInRegionsCaches.get(fm);
            }
            this.debug(solIndex, "done cache");
            ArrayList mfds = Lists.newArrayList();
            ArrayList offMFDs = Lists.newArrayList();
            ArrayList onMFDs = Lists.newArrayList();
            for (r = 0; r < this.regions.size(); ++r) {
                region = this.regions.get(r);
                watch = Stopwatch.createStarted();
                this.debug(solIndex, "calculating region (COMBINED) " + r);
                ucerf3_Part = ERF_Calculator.getParticipationMagFreqDistInRegion(erf, region, 5.05, 41, 0.1, true, rupsCache);
                watch.stop();
                this.debug(solIndex, "done region (COMBINED) " + r + " (" + watch.elapsed(TimeUnit.SECONDS) + " s)");
                mfds.add(ucerf3_Part.getCumRateDistWithOffset());
            }
            erf.getParameter("Background Seismicity").setValue(IncludeBackgroundOption.EXCLUDE);
            erf.updateForecast();
            for (r = 0; r < this.regions.size(); ++r) {
                region = this.regions.get(r);
                watch = Stopwatch.createStarted();
                this.debug(solIndex, "calculating region (ON FAULT) " + r);
                ucerf3_Part = ERF_Calculator.getParticipationMagFreqDistInRegion(erf, region, 5.05, 41, 0.1, true, rupsCache);
                watch.stop();
                this.debug(solIndex, "done region (ON FAULT) " + r + " (" + watch.elapsed(TimeUnit.SECONDS) + " s)");
                onMFDs.add(ucerf3_Part.getCumRateDistWithOffset());
            }
            erf.getParameter("Background Seismicity").setValue(IncludeBackgroundOption.ONLY);
            erf.updateForecast();
            for (r = 0; r < this.regions.size(); ++r) {
                region = this.regions.get(r);
                watch = Stopwatch.createStarted();
                this.debug(solIndex, "calculating region (OFF FAULT) " + r);
                ucerf3_Part = ERF_Calculator.getParticipationMagFreqDistInRegion(erf, region, 5.05, 41, 0.1, true, rupsCache);
                watch.stop();
                this.debug(solIndex, "done region (OFF FAULT) " + r + " (" + watch.elapsed(TimeUnit.SECONDS) + " s)");
                offMFDs.add(ucerf3_Part.getCumRateDistWithOffset());
            }
            erf.getParameter("Background Seismicity").setValue(IncludeBackgroundOption.INCLUDE);
            erf.updateForecast();
            this.debug(solIndex, " archiving");
            ERFBasedRegionalMFDPlot eRFBasedRegionalMFDPlot = this;
            synchronized (eRFBasedRegionalMFDPlot) {
                this.weights.add(this.weightProvider.getWeight(branch));
                for (int r2 = 0; r2 < this.regions.size(); ++r2) {
                    this.solMFDs.get(r2).add((XY_DataSet)mfds.get(r2));
                    this.solOnMFDs.get(r2).add((XY_DataSet)onMFDs.get(r2));
                    this.solOffMFDs.get(r2).add((XY_DataSet)offMFDs.get(r2));
                }
            }
            this.debug(solIndex, " archiving done");
        }

        @Override
        protected void combineDistributedCalcs(Collection<CompoundFSSPlots> otherCalcs) {
            for (CompoundFSSPlots otherCalc : otherCalcs) {
                ERFBasedRegionalMFDPlot o = (ERFBasedRegionalMFDPlot)otherCalc;
                for (int r = 0; r < this.regions.size(); ++r) {
                    this.solMFDs.get(r).addAll(o.solMFDs.get(r));
                    this.solOnMFDs.get(r).addAll(o.solOnMFDs.get(r));
                    this.solOffMFDs.get(r).addAll(o.solOffMFDs.get(r));
                }
                this.weights.addAll(o.weights);
                for (int e = 0; e < this.numUCEF2_ERFs; ++e) {
                    if (o.ucerf2MFDs.get(0)[e] == null) continue;
                    for (int r = 0; r < this.regions.size(); ++r) {
                        this.ucerf2MFDs.get((int)r)[e] = o.ucerf2MFDs.get(r)[e];
                        this.ucerf2OnMFDs.get((int)r)[e] = o.ucerf2OnMFDs.get(r)[e];
                        this.ucerf2OffMFDs.get((int)r)[e] = o.ucerf2OffMFDs.get(r)[e];
                    }
                    this.ucerf2Weights[e] = o.ucerf2Weights[e];
                }
            }
        }

        @Override
        protected void doFinalizePlot() {
            this.specs = Lists.newArrayList();
            this.checkCalcAllUCERF2MFDs();
            for (int r = 0; r < this.regions.size(); ++r) {
                Region region = this.regions.get(r);
                XY_DataSetList ucerf2Funcs = new XY_DataSetList();
                XY_DataSetList ucerf2OnFuncs = new XY_DataSetList();
                XY_DataSetList ucerf2OffFuncs = new XY_DataSetList();
                ArrayList<Double> ucerf2Weights = new ArrayList<Double>();
                for (int e = 0; e < this.ucerf2MFDs.get(r).length; ++e) {
                    EvenlyDiscretizedFunc mfd = this.ucerf2MFDs.get(r)[e];
                    if (mfd == null) continue;
                    ucerf2Funcs.add(this.ucerf2MFDs.get(r)[e]);
                    ucerf2OnFuncs.add(this.ucerf2OnMFDs.get(r)[e]);
                    ucerf2OffFuncs.add(this.ucerf2OffMFDs.get(r)[e]);
                    ucerf2Weights.add(this.ucerf2Weights[e]);
                }
                ArrayList funcs = Lists.newArrayList();
                ArrayList chars = Lists.newArrayList();
                funcs.addAll(ERFBasedRegionalMFDPlot.getFractiles(ucerf2OnFuncs, ucerf2Weights, "UCERF2 Epistemic List On Fault MFDs", this.fractiles));
                chars.addAll(ERFBasedRegionalMFDPlot.getFractileChars(Color.GREEN, this.fractiles.length));
                funcs.addAll(ERFBasedRegionalMFDPlot.getFractiles(ucerf2OffFuncs, ucerf2Weights, "UCERF2 Epistemic List Off Fault MFDs", this.fractiles));
                chars.addAll(ERFBasedRegionalMFDPlot.getFractileChars(Color.MAGENTA, this.fractiles.length));
                funcs.addAll(ERFBasedRegionalMFDPlot.getFractiles(this.solOnMFDs.get(r), this.weights, "UCERF3 On Fault MFDs", this.fractiles));
                chars.addAll(ERFBasedRegionalMFDPlot.getFractileChars(Color.ORANGE, this.fractiles.length));
                funcs.addAll(ERFBasedRegionalMFDPlot.getFractiles(this.solOffMFDs.get(r), this.weights, "UCERF3 Off Fault MFDs", this.fractiles));
                chars.addAll(ERFBasedRegionalMFDPlot.getFractileChars(Color.GRAY, this.fractiles.length));
                funcs.addAll(ERFBasedRegionalMFDPlot.getFractiles(ucerf2Funcs, ucerf2Weights, "UCERF2 Epistemic List", this.fractiles));
                chars.addAll(ERFBasedRegionalMFDPlot.getFractileChars(Color.RED, this.fractiles.length));
                funcs.addAll(ERFBasedRegionalMFDPlot.getFractiles(this.solMFDs.get(r), this.weights, "UCERF3 MFDs", this.fractiles));
                chars.addAll(ERFBasedRegionalMFDPlot.getFractileChars(Color.BLUE, this.fractiles.length));
                String title = region.getName();
                if (title == null || title.isEmpty()) {
                    title = "Unnamed Region";
                }
                String xAxisLabel = "Magnitude";
                String yAxisLabel = "Cumulative Rate (per yr)";
                PlotSpec spec = new PlotSpec(funcs, chars, title, xAxisLabel, yAxisLabel);
                this.specs.add(spec);
            }
        }

        @Override
        protected boolean usesERFs() {
            return true;
        }

        @Override
        protected boolean isApplyAftershockFilter() {
            return false;
        }

        protected List<PlotSpec> getSpecs() {
            return this.specs;
        }
    }

    public static class ERFBasedRegionalMagProbPlot
    extends CompoundFSSPlots {
        private static final long serialVersionUID = 1L;
        private static final boolean infer_off_fault = false;
        private static boolean INCLUDE_AFTERSHOCKS = true;
        private static boolean NUCLEATION_PROBS = false;
        private static double[] durations = time_dep_durations;
        private transient U3BranchWeightProvider weightProvider;
        private List<Region> regions;
        private Map<Double, List<Double>> weights;
        private Map<Double, Map<FaultModels, List<Double>>> fmWeights;
        private Map<Double, List<U3LogicTreeBranch>> branches;
        private double[] ucerf2DepWeights;
        private double[] ucerf2IndepWeights;
        private double[] region_fractiles;
        private double[] sub_sect_fractiles = new double[]{0.025, 0.16, 0.84, 0.975};
        private static MagDependentAperiodicityOptions[] covs = new MagDependentAperiodicityOptions[]{MagDependentAperiodicityOptions.LOW_VALUES, MagDependentAperiodicityOptions.MID_VALUES, MagDependentAperiodicityOptions.HIGH_VALUES, null};
        private Map<Double, List<Map<MagDependentAperiodicityOptions, XY_DataSetList>>> solMPDs = Maps.newHashMap();
        private Map<Double, List<Map<MagDependentAperiodicityOptions, XY_DataSetList>>> solMFDs = Maps.newHashMap();
        private Map<Double, List<Map<MagDependentAperiodicityOptions, XY_DataSetList>>> solOnMPDs = Maps.newHashMap();
        private Map<Double, List<Map<MagDependentAperiodicityOptions, XY_DataSetList>>> solOffMPDs = Maps.newHashMap();
        private Map<Double, List<EvenlyDiscretizedFunc[]>> ucerf2DepMPDs = Maps.newHashMap();
        private Map<Double, List<EvenlyDiscretizedFunc[]>> ucerf2DepMFDs = Maps.newHashMap();
        private Map<Double, List<EvenlyDiscretizedFunc[]>> ucerf2DepOnMPDs = Maps.newHashMap();
        private Map<Double, List<EvenlyDiscretizedFunc[]>> ucerf2DepOffMPDs = Maps.newHashMap();
        private Map<Double, List<EvenlyDiscretizedFunc[]>> ucerf2IndepMPDs = Maps.newHashMap();
        private Map<Double, List<EvenlyDiscretizedFunc[]>> ucerf2IndepMFDs = Maps.newHashMap();
        private Map<Double, List<Map<U3LogicTreeBranch, Map<MagDependentAperiodicityOptions, Double>>>> regionM6p7Vals = Maps.newHashMap();
        private Map<Double, Map<MagDependentAperiodicityOptions, Map<String, XY_DataSetList>>> solMainFaultProbs = Maps.newHashMap();
        private Map<Double, Map<MagDependentAperiodicityOptions, Map<String, XY_DataSetList>>> solMainFaultRates = Maps.newHashMap();
        private Map<Double, Map<MagDependentAperiodicityOptions, Map<FaultModels, XY_DataSetList[]>>> solSubSectProbs = Maps.newHashMap();
        private Map<Double, Map<MagDependentAperiodicityOptions, Map<FaultModels, Map<Integer, XY_DataSetList>>>> solParentSectProbs = Maps.newHashMap();
        private transient Deque<UCERF2_TimeDependentEpistemicList> ucerf2_dep_erf_lists = new ArrayDeque<UCERF2_TimeDependentEpistemicList>();
        private transient Deque<UCERF2_TimeIndependentEpistemicList> ucerf2_indep_erf_lists = new ArrayDeque<UCERF2_TimeIndependentEpistemicList>();
        private static final double minX = 5.05;
        private static final double maxX = 9.05;
        private static final double delta = 0.1;
        private static final int num = 41;
        private Map<Double, List<PlotSpec>> specs;
        private Map<Double, List<PlotSpec>> faultSpecs;
        private Table<Double, Boolean, CSVFile<String>> faultProbCSVs;
        private Table<Double, Boolean, CSVFile<String>> regionProbCSVs;
        private Table<Double, Boolean, CSVFile<String>> faultRateCSVs;
        private Table<Double, Boolean, CSVFile<String>> regionRateCSVs;
        private Table<Double, FaultModels, List<CSVFile<String>>> subSectsCSVs;
        private Table<Double, FaultModels, List<CSVFile<String>>> subSectsPercentileCSVs;
        private Table<Double, FaultModels, List<CSVFile<String>>> parentSectsCSVs;
        private int numUCEF2_DepERFs;
        private int numUCEF2_IndepERFs;
        private transient Map<FaultModels, FSSRupsInRegionCache> rupInRegionsCaches = Maps.newHashMap();
        private Map<String, List<Integer>> mainFaultsMap;
        private List<String> mainFaultsSorted;
        private static List<String> mainFaultsCombinedPFDNames = Lists.newArrayList();
        private Map<FaultModels, Map<String, HashSet<Integer>>> mainFaultsRuptures;
        private Map<FaultModels, Map<Integer, HashSet<Integer>>> parentSectRuptures;
        private Map<FaultModels, Map<Integer, String>> parentSectNamesMap;

        public static List<Region> getDefaultRegions() {
            ArrayList regions = Lists.newArrayList();
            regions.add(new CaliforniaRegions.RELM_TESTING());
            regions.add(new CaliforniaRegions.RELM_NOCAL());
            regions.add(new CaliforniaRegions.RELM_SOCAL());
            regions.add(new CaliforniaRegions.SF_BOX());
            regions.add(new CaliforniaRegions.LA_BOX());
            regions.add(new CaliforniaRegions.NORTHRIDGE_BOX());
            regions.add(new CaliforniaRegions.SAN_DIEGO_BOX());
            return regions;
        }

        private static double[] getDefaultFractiles() {
            double[] ret = new double[]{};
            return ret;
        }

        public ERFBasedRegionalMagProbPlot(U3BranchWeightProvider weightProvider) {
            this(weightProvider, ERFBasedRegionalMagProbPlot.getDefaultRegions());
        }

        public ERFBasedRegionalMagProbPlot(U3BranchWeightProvider weightProvider, List<Region> regions) {
            this(weightProvider, regions, ERFBasedRegionalMagProbPlot.getDefaultFractiles());
        }

        public ERFBasedRegionalMagProbPlot(U3BranchWeightProvider weightProvider, List<Region> regions, double[] fractiles) {
            this.weightProvider = weightProvider;
            this.regions = regions;
            this.region_fractiles = fractiles;
            UCERF2_TimeDependentEpistemicList ucerf2_erf_list = this.checkOutUCERF2_DepERF();
            this.numUCEF2_DepERFs = ucerf2_erf_list.getNumERFs();
            this.returnUCERF2_DepERF(ucerf2_erf_list);
            ucerf2_erf_list = null;
            UCERF2_TimeIndependentEpistemicList ucerf2_indep_erf_list = this.checkOutUCERF2_IndepERF();
            this.numUCEF2_IndepERFs = ucerf2_indep_erf_list.getNumERFs();
            this.returnUCERF2_IndepERF(ucerf2_indep_erf_list);
            ucerf2_indep_erf_list = null;
            try {
                this.mainFaultsMap = FaultModels.parseNamedFaultsAltFile(UCERF3_DataUtils.getReader("FaultModels", "MainFaultsForTimeDepComparison.txt"));
                HashSet elsinoreIDs = new HashSet();
                elsinoreIDs.addAll(this.mainFaultsMap.remove("Elsinore FM3.1"));
                elsinoreIDs.addAll(this.mainFaultsMap.remove("Elsinore FM3.2"));
                this.mainFaultsMap.put("Elsinore", Lists.newArrayList(elsinoreIDs));
                this.mainFaultsSorted = Lists.newArrayList(this.mainFaultsMap.keySet());
                Collections.sort(this.mainFaultsSorted);
                this.mainFaultsRuptures = Maps.newHashMap();
                this.parentSectRuptures = Maps.newHashMap();
                this.parentSectNamesMap = Maps.newHashMap();
            }
            catch (IOException e) {
                ExceptionUtils.throwAsRuntimeException(e);
            }
            for (double duration : durations) {
                this.solMPDs.put(duration, ERFBasedRegionalMagProbPlot.buildPopulatedList(regions.size()));
                this.solMFDs.put(duration, ERFBasedRegionalMagProbPlot.buildPopulatedList(regions.size()));
                this.solOnMPDs.put(duration, ERFBasedRegionalMagProbPlot.buildPopulatedList(regions.size()));
                this.solOffMPDs.put(duration, ERFBasedRegionalMagProbPlot.buildPopulatedList(regions.size()));
                this.ucerf2DepMPDs.put(duration, ERFBasedRegionalMagProbPlot.buildPopulatedFuncList(regions.size(), this.numUCEF2_DepERFs));
                this.ucerf2DepMFDs.put(duration, ERFBasedRegionalMagProbPlot.buildPopulatedFuncList(regions.size(), this.numUCEF2_DepERFs));
                this.ucerf2DepOnMPDs.put(duration, ERFBasedRegionalMagProbPlot.buildPopulatedFuncList(regions.size(), this.numUCEF2_DepERFs));
                this.ucerf2DepOffMPDs.put(duration, ERFBasedRegionalMagProbPlot.buildPopulatedFuncList(regions.size(), this.numUCEF2_DepERFs));
                this.ucerf2IndepMPDs.put(duration, ERFBasedRegionalMagProbPlot.buildPopulatedFuncList(regions.size(), this.numUCEF2_IndepERFs));
                this.ucerf2IndepMFDs.put(duration, ERFBasedRegionalMagProbPlot.buildPopulatedFuncList(regions.size(), this.numUCEF2_IndepERFs));
                this.solMainFaultProbs.put(duration, ERFBasedRegionalMagProbPlot.buildPopulatedMainFaultMap(this.mainFaultsMap));
                this.solMainFaultRates.put(duration, ERFBasedRegionalMagProbPlot.buildPopulatedMainFaultMap(this.mainFaultsMap));
                HashMap sectMap = Maps.newHashMap();
                for (MagDependentAperiodicityOptions cov : covs) {
                    HashMap fmMap = Maps.newHashMap();
                    sectMap.put(cov, fmMap);
                }
                this.solSubSectProbs.put(duration, sectMap);
                HashMap parentSectMap = Maps.newHashMap();
                for (MagDependentAperiodicityOptions cov : covs) {
                    HashMap fmMap = Maps.newHashMap();
                    parentSectMap.put(cov, fmMap);
                }
                this.solParentSectProbs.put(duration, parentSectMap);
                ArrayList maps = Lists.newArrayList();
                for (int r = 0; r < regions.size(); ++r) {
                    HashMap map = Maps.newHashMap();
                    maps.add(map);
                }
                this.regionM6p7Vals.put(duration, maps);
            }
            this.weights = Maps.newHashMap();
            this.fmWeights = Maps.newHashMap();
            this.branches = Maps.newHashMap();
            for (double duration : durations) {
                this.weights.put(duration, new ArrayList());
                this.fmWeights.put(duration, new HashMap());
                this.branches.put(duration, new ArrayList());
            }
            this.ucerf2DepWeights = new double[this.numUCEF2_DepERFs];
            this.ucerf2IndepWeights = new double[this.numUCEF2_IndepERFs];
        }

        private static List<Map<MagDependentAperiodicityOptions, XY_DataSetList>> buildPopulatedList(int num) {
            ArrayList l = Lists.newArrayList();
            for (int i = 0; i < num; ++i) {
                HashMap map = Maps.newHashMap();
                for (MagDependentAperiodicityOptions cov : covs) {
                    map.put(cov, new XY_DataSetList());
                }
                l.add(map);
            }
            return l;
        }

        private static Map<MagDependentAperiodicityOptions, Map<String, XY_DataSetList>> buildPopulatedMainFaultMap(Map<String, List<Integer>> mainFaultsMap) {
            HashMap map = Maps.newHashMap();
            for (MagDependentAperiodicityOptions cov : covs) {
                HashMap faultMap = Maps.newHashMap();
                for (String fault : mainFaultsMap.keySet()) {
                    faultMap.put(fault, new XY_DataSetList());
                }
                map.put(cov, faultMap);
            }
            return map;
        }

        private static List<EvenlyDiscretizedFunc[]> buildPopulatedFuncList(int num, int numUCEF2_ERFs) {
            ArrayList l = Lists.newArrayList();
            for (int i = 0; i < num; ++i) {
                l.add(new EvenlyDiscretizedFunc[numUCEF2_ERFs]);
            }
            return l;
        }

        private synchronized UCERF2_TimeDependentEpistemicList checkOutUCERF2_DepERF() {
            if (this.ucerf2_dep_erf_lists.isEmpty()) {
                UCERF2_TimeDependentEpistemicList ucerf2_erf_list = new UCERF2_TimeDependentEpistemicList();
                ucerf2_erf_list.setParameter("Floater Type", "Only along strike ( rupture full DDW)");
                ucerf2_erf_list.setParameter(UCERF2.BACK_SEIS_NAME, UCERF2.BACK_SEIS_INCLUDE);
                ucerf2_erf_list.setParameter(UCERF2.BACK_SEIS_RUP_NAME, UCERF2.BACK_SEIS_RUP_POINT);
                return ucerf2_erf_list;
            }
            return this.ucerf2_dep_erf_lists.pop();
        }

        private synchronized UCERF2_TimeIndependentEpistemicList checkOutUCERF2_IndepERF() {
            if (this.ucerf2_indep_erf_lists.isEmpty()) {
                UCERF2_TimeIndependentEpistemicList ucerf2_erf_list = new UCERF2_TimeIndependentEpistemicList();
                ucerf2_erf_list.setParameter("Floater Type", "Only along strike ( rupture full DDW)");
                ucerf2_erf_list.setParameter(UCERF2.BACK_SEIS_NAME, UCERF2.BACK_SEIS_INCLUDE);
                ucerf2_erf_list.setParameter(UCERF2.BACK_SEIS_RUP_NAME, UCERF2.BACK_SEIS_RUP_POINT);
                return ucerf2_erf_list;
            }
            return this.ucerf2_indep_erf_lists.pop();
        }

        private synchronized void returnUCERF2_DepERF(UCERF2_TimeDependentEpistemicList erf) {
            this.ucerf2_dep_erf_lists.push(erf);
        }

        private synchronized void returnUCERF2_IndepERF(UCERF2_TimeIndependentEpistemicList erf) {
            this.ucerf2_indep_erf_lists.push(erf);
        }

        private void calcUCERF2_DepMFDs(int erfIndex, double duration) {
            int regionIndex;
            UCERF2_TimeDependentEpistemicList ucerf2_erf_list = this.checkOutUCERF2_DepERF();
            ucerf2_erf_list.getTimeSpan().setDuration(duration);
            ucerf2_erf_list.getTimeSpan().setStartTime(2007);
            Preconditions.checkState((ucerf2_erf_list.getTimeSpan().getDuration() == duration ? 1 : 0) != 0);
            ucerf2_erf_list.updateForecast();
            ERF erf = ucerf2_erf_list.getERF(erfIndex);
            this.ucerf2DepWeights[erfIndex] = ucerf2_erf_list.getERF_RelativeWeight(erfIndex);
            System.out.println("Calculating UCERF2 On Fault MFDs for branch " + erfIndex + ", " + this.regions.size() + " regions");
            ucerf2_erf_list.getParameter(UCERF2.BACK_SEIS_NAME).setValue(UCERF2.BACK_SEIS_EXCLUDE);
            erf = ucerf2_erf_list.getERF(erfIndex);
            EvenlyDiscretizedFunc[] onCmlMFDs = new EvenlyDiscretizedFunc[this.regions.size()];
            for (int regionIndex2 = 0; regionIndex2 < this.regions.size(); ++regionIndex2) {
                Region region = this.regions.get(regionIndex2);
                SummedMagFreqDist mfdPart = NUCLEATION_PROBS ? ERF_Calculator.getMagFreqDistInRegionFaster(erf, region, 5.05, 41, 0.1, true) : ERF_Calculator.getParticipationMagFreqDistInRegion(erf, region, 5.05, 41, 0.1, true);
                if (INCLUDE_AFTERSHOCKS) {
                    mfdPart.scale(1.0309278350515465);
                }
                onCmlMFDs[regionIndex2] = mfdPart.getCumRateDistWithOffset();
                this.ucerf2DepOnMPDs.get((Object)Double.valueOf((double)duration)).get((int)regionIndex2)[erfIndex] = FaultSysSolutionERF_Calc.calcProbsFromSummedMFD(onCmlMFDs[regionIndex2], duration);
            }
            System.out.println("Calculating UCERF2 Off Fault MFDs for branch " + erfIndex + ", " + this.regions.size() + " regions");
            ucerf2_erf_list.getParameter(UCERF2.BACK_SEIS_NAME).setValue(UCERF2.BACK_SEIS_ONLY);
            erf = ucerf2_erf_list.getERF(erfIndex);
            EvenlyDiscretizedFunc[] offCmlMFDs = new EvenlyDiscretizedFunc[this.regions.size()];
            for (regionIndex = 0; regionIndex < this.regions.size(); ++regionIndex) {
                Region region = this.regions.get(regionIndex);
                IncrementalMagFreqDist mfdPart = NUCLEATION_PROBS ? ERF_Calculator.getMagFreqDistInRegionFaster(erf, region, 5.05, 41, 0.1, true) : ERF_Calculator.getParticipationMagFreqDistInRegion(erf, region, 5.05, 41, 0.1, true);
                if (INCLUDE_AFTERSHOCKS) {
                    IncrementalMagFreqDist scaled = new IncrementalMagFreqDist(mfdPart.getMinX(), mfdPart.size(), mfdPart.getDelta());
                    for (int i = 0; i < mfdPart.size(); ++i) {
                        double scale = GardnerKnopoffAftershockFilter.scaleForMagnitude(mfdPart.getX(i));
                        scaled.set(i, mfdPart.getY(i) / scale);
                    }
                    mfdPart = scaled;
                }
                offCmlMFDs[regionIndex] = mfdPart.getCumRateDistWithOffset();
                this.ucerf2DepOffMPDs.get((Object)Double.valueOf((double)duration)).get((int)regionIndex)[erfIndex] = FaultSysSolutionERF_Calc.calcProbsFromSummedMFD(offCmlMFDs[regionIndex], duration);
            }
            System.out.println("Calculating UCERF2 MFDs for branch " + erfIndex + ", " + this.regions.size() + " regions");
            for (regionIndex = 0; regionIndex < this.regions.size(); ++regionIndex) {
                SummedMagFreqDist summedMFD = new SummedMagFreqDist(5.0, 41, 0.1);
                summedMFD.addIncrementalMagFreqDist(onCmlMFDs[regionIndex]);
                summedMFD.addIncrementalMagFreqDist(offCmlMFDs[regionIndex]);
                this.ucerf2DepMPDs.get((Object)Double.valueOf((double)duration)).get((int)regionIndex)[erfIndex] = FaultSysSolutionERF_Calc.calcProbsFromSummedMFD(summedMFD, duration);
                summedMFD.scale(duration);
                this.ucerf2DepMFDs.get((Object)Double.valueOf((double)duration)).get((int)regionIndex)[erfIndex] = summedMFD;
            }
            ucerf2_erf_list.getParameter(UCERF2.BACK_SEIS_NAME).setValue(UCERF2.BACK_SEIS_INCLUDE);
            this.returnUCERF2_DepERF(ucerf2_erf_list);
        }

        private void calcUCERF2_IndepMFDs(int erfIndex, double duration) {
            int regionIndex;
            UCERF2_TimeIndependentEpistemicList ucerf2_erf_list = this.checkOutUCERF2_IndepERF();
            ucerf2_erf_list.getTimeSpan().setDuration(duration);
            Preconditions.checkState((ucerf2_erf_list.getTimeSpan().getDuration() == duration ? 1 : 0) != 0);
            ucerf2_erf_list.updateForecast();
            ERF erf = ucerf2_erf_list.getERF(erfIndex);
            this.ucerf2IndepWeights[erfIndex] = ucerf2_erf_list.getERF_RelativeWeight(erfIndex);
            System.out.println("Calculating UCERF2  Time Independent On Fault MFDs for branch " + erfIndex + ", " + this.regions.size() + " regions");
            ucerf2_erf_list.getParameter(UCERF2.BACK_SEIS_NAME).setValue(UCERF2.BACK_SEIS_EXCLUDE);
            erf = ucerf2_erf_list.getERF(erfIndex);
            EvenlyDiscretizedFunc[] onCmlMFDs = new EvenlyDiscretizedFunc[this.regions.size()];
            for (int regionIndex2 = 0; regionIndex2 < this.regions.size(); ++regionIndex2) {
                Region region = this.regions.get(regionIndex2);
                SummedMagFreqDist mfdPart = NUCLEATION_PROBS ? ERF_Calculator.getMagFreqDistInRegionFaster(erf, region, 5.05, 41, 0.1, true) : ERF_Calculator.getParticipationMagFreqDistInRegion(erf, region, 5.05, 41, 0.1, true);
                if (INCLUDE_AFTERSHOCKS) {
                    mfdPart.scale(1.0309278350515465);
                }
                onCmlMFDs[regionIndex2] = mfdPart.getCumRateDistWithOffset();
            }
            System.out.println("Calculating UCERF2 Off Fault MFDs for branch " + erfIndex + ", " + this.regions.size() + " regions");
            ucerf2_erf_list.getParameter(UCERF2.BACK_SEIS_NAME).setValue(UCERF2.BACK_SEIS_ONLY);
            erf = ucerf2_erf_list.getERF(erfIndex);
            EvenlyDiscretizedFunc[] offCmlMFDs = new EvenlyDiscretizedFunc[this.regions.size()];
            for (regionIndex = 0; regionIndex < this.regions.size(); ++regionIndex) {
                Region region = this.regions.get(regionIndex);
                IncrementalMagFreqDist mfdPart = NUCLEATION_PROBS ? ERF_Calculator.getMagFreqDistInRegionFaster(erf, region, 5.05, 41, 0.1, true) : ERF_Calculator.getParticipationMagFreqDistInRegion(erf, region, 5.05, 41, 0.1, true);
                if (INCLUDE_AFTERSHOCKS) {
                    IncrementalMagFreqDist scaled = new IncrementalMagFreqDist(mfdPart.getMinX(), mfdPart.size(), mfdPart.getDelta());
                    for (int i = 0; i < mfdPart.size(); ++i) {
                        double scale = GardnerKnopoffAftershockFilter.scaleForMagnitude(mfdPart.getX(i));
                        scaled.set(i, mfdPart.getY(i) / scale);
                    }
                    mfdPart = scaled;
                }
                offCmlMFDs[regionIndex] = mfdPart.getCumRateDistWithOffset();
            }
            System.out.println("Calculating UCERF2 MFDs for branch " + erfIndex + ", " + this.regions.size() + " regions");
            for (regionIndex = 0; regionIndex < this.regions.size(); ++regionIndex) {
                SummedMagFreqDist summedMFD = new SummedMagFreqDist(5.0, 41, 0.1);
                summedMFD.addIncrementalMagFreqDist(onCmlMFDs[regionIndex]);
                summedMFD.addIncrementalMagFreqDist(offCmlMFDs[regionIndex]);
                this.ucerf2IndepMPDs.get((Object)Double.valueOf((double)duration)).get((int)regionIndex)[erfIndex] = FaultSysSolutionERF_Calc.calcProbsFromSummedMFD(summedMFD, duration);
                summedMFD.scale(duration);
                this.ucerf2IndepMFDs.get((Object)Double.valueOf((double)duration)).get((int)regionIndex)[erfIndex] = summedMFD;
            }
            ucerf2_erf_list.getParameter(UCERF2.BACK_SEIS_NAME).setValue(UCERF2.BACK_SEIS_INCLUDE);
            this.returnUCERF2_IndepERF(ucerf2_erf_list);
        }

        private void checkCalcAllUCERF2MFDs() {
            int erfIndex;
            if (hostname.startsWith("steel")) {
                System.out.println("Skipping UCERF2 finish as local test");
                return;
            }
            for (erfIndex = 0; erfIndex < this.numUCEF2_DepERFs; ++erfIndex) {
                for (double duration : durations) {
                    if (this.ucerf2DepMPDs.get(duration).get(0)[erfIndex] != null) continue;
                    this.calcUCERF2_DepMFDs(erfIndex, duration);
                }
            }
            for (erfIndex = 0; erfIndex < this.numUCEF2_IndepERFs; ++erfIndex) {
                for (double duration : durations) {
                    if (this.ucerf2IndepMPDs.get(duration).get(0)[erfIndex] != null) continue;
                    this.calcUCERF2_IndepMFDs(erfIndex, duration);
                }
            }
        }

        @Override
        protected void processSolution(U3LogicTreeBranch branch, InversionFaultSystemSolution sol, int solIndex) {
            throw new IllegalStateException("Should not be called, ERF plot!");
        }

        public static void calcFaultProbs(EvenlyDiscretizedFunc probFunc, EvenlyDiscretizedFunc rateFunc, FaultSystemSolutionERF erf, FaultSystemRupSet rupSet, Collection<Integer> faultRups) {
            ArrayList probs = Lists.newArrayList();
            for (int i = 0; i < probFunc.size(); ++i) {
                probs.add(new ArrayList());
            }
            double duration = erf.getTimeSpan().getDuration();
            for (int sourceID = 0; sourceID < erf.getNumFaultSystemSources(); ++sourceID) {
                int rupID = erf.getFltSysRupIndexForSource(sourceID);
                if (!faultRups.contains(rupID)) continue;
                ProbEqkSource source = erf.getSource(sourceID);
                double prob = source.computeTotalProb();
                double rate = source.computeTotalEquivMeanAnnualRate(duration) * duration;
                double mag = rupSet.getMagForRup(rupID);
                for (int i = 0; i < probFunc.size(); ++i) {
                    if (!(mag >= probFunc.getX(i))) continue;
                    ((List)probs.get(i)).add(prob);
                    if (rateFunc == null) continue;
                    rateFunc.add(i, rate);
                }
            }
            for (int i = 0; i < probFunc.size(); ++i) {
                probFunc.set(i, FaultSysSolutionERF_Calc.calcSummedProbs((List)probs.get(i)));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        protected void processERF(U3LogicTreeBranch branch, FaultSystemSolutionERF erf, int solIndex) {
            Map<Integer, HashSet<Integer>> fmParentRups;
            Object rups;
            this.debug(solIndex, "checking UCERF2");
            for (double duration : durations) {
                if (solIndex < this.numUCEF2_DepERFs) {
                    this.calcUCERF2_DepMFDs(solIndex, duration);
                }
                if (solIndex >= this.numUCEF2_IndepERFs) continue;
                this.calcUCERF2_IndepMFDs(solIndex, duration);
            }
            this.debug(solIndex, " done UCERF2");
            FaultModels fm = branch.getValue(FaultModels.class);
            FSSRupsInRegionCache rupsCache = this.rupInRegionsCaches.get(fm);
            if (rupsCache == null) {
                ERFBasedRegionalMagProbPlot eRFBasedRegionalMagProbPlot = this;
                synchronized (eRFBasedRegionalMagProbPlot) {
                    if (!this.rupInRegionsCaches.containsKey(fm)) {
                        this.rupInRegionsCaches.put(fm, new FSSRupsInRegionCache());
                    }
                }
                rupsCache = this.rupInRegionsCaches.get(fm);
            }
            FaultSystemRupSet rupSet = erf.getSolution().getRupSet();
            Map<String, HashSet<Integer>> fmRups = this.mainFaultsRuptures.get(fm);
            if (fmRups == null) {
                FaultModels faultModels = fm;
                synchronized (faultModels) {
                    if (this.mainFaultsRuptures.get(fm) == null) {
                        HashMap newFMRups = Maps.newHashMap();
                        for (String fault : this.mainFaultsSorted) {
                            rups = new HashSet();
                            for (Integer parentID : this.mainFaultsMap.get(fault)) {
                                List<Integer> parentRups = rupSet.getRupturesForParentSection(parentID);
                                if (parentRups == null) continue;
                                ((AbstractCollection)rups).addAll(parentRups);
                            }
                            newFMRups.put(fault, rups);
                        }
                        this.mainFaultsRuptures.put(fm, newFMRups);
                    }
                    fmRups = this.mainFaultsRuptures.get(fm);
                }
            }
            if ((fmParentRups = this.parentSectRuptures.get(fm)) == null) {
                FaultModels faultModels = fm;
                synchronized (faultModels) {
                    if (this.parentSectRuptures.get(fm) == null) {
                        HashMap newParentRups = Maps.newHashMap();
                        HashMap parentNames = Maps.newHashMap();
                        for (FaultSection faultSection : rupSet.getFaultSectionDataList()) {
                            Integer parentID;
                            parentID = faultSection.getParentSectionId();
                            if (parentNames.containsKey(parentID)) continue;
                            parentNames.put(parentID, faultSection.getParentSectionName());
                        }
                        rups = parentNames.keySet().iterator();
                        while (rups.hasNext()) {
                            int n = (Integer)rups.next();
                            newParentRups.put(n, new HashSet<Integer>(rupSet.getRupturesForParentSection(n)));
                        }
                        this.parentSectRuptures.put(fm, newParentRups);
                        this.parentSectNamesMap.put(fm, parentNames);
                        for (Object duration : (Object)durations) {
                            for (MagDependentAperiodicityOptions cov : covs) {
                                Map<FaultModels, Map<Integer, XY_DataSetList>> map = this.solParentSectProbs.get((double)duration).get((Object)cov);
                                HashMap resultsMap = Maps.newHashMap();
                                Iterator iterator = parentNames.keySet().iterator();
                                while (iterator.hasNext()) {
                                    int parentID = (Integer)iterator.next();
                                    resultsMap.put(parentID, new XY_DataSetList());
                                }
                                map.put(fm, resultsMap);
                            }
                        }
                    }
                    fmParentRups = this.parentSectRuptures.get(fm);
                }
            }
            this.debug(solIndex, "done cache");
            for (Object duration : (FaultModels)durations) {
                HashMap mfds = Maps.newHashMap();
                HashMap offMFDs = Maps.newHashMap();
                HashMap onMFDs = Maps.newHashMap();
                HashMap faultMPDs = Maps.newHashMap();
                HashMap faultMFDs = Maps.newHashMap();
                HashMap sectMPDs = Maps.newHashMap();
                HashMap parentSectMPDs = Maps.newHashMap();
                for (MagDependentAperiodicityOptions cov : covs) {
                    void var28_71;
                    void var28_69;
                    SummedMagFreqDist ucerf3_Part;
                    Stopwatch watch;
                    void var28_67;
                    void var28_64;
                    mfds.put(cov, new ArrayList());
                    offMFDs.put(cov, new ArrayList());
                    onMFDs.put(cov, new ArrayList());
                    faultMPDs.put(cov, new HashMap());
                    faultMFDs.put(cov, new HashMap());
                    EvenlyDiscretizedFunc[] subSectMPDs = new EvenlyDiscretizedFunc[rupSet.getNumSections()];
                    sectMPDs.put(cov, subSectMPDs);
                    parentSectMPDs.put(cov, new HashMap());
                    if (cov == null) {
                        erf.setParameter("Probability Model", (Object)ProbabilityModelOptions.POISSON);
                    } else {
                        erf.setParameter("Probability Model", (Object)ProbabilityModelOptions.U3_BPT);
                        erf.setParameter("Aperiodicity", (Object)cov);
                    }
                    double origDuration = erf.getTimeSpan().getDuration();
                    erf.getTimeSpan().setDuration((double)duration);
                    erf.getParameter("Background Seismicity").setValue(IncludeBackgroundOption.INCLUDE);
                    erf.updateForecast();
                    this.debug(solIndex, "calculating mian fault probs, dur=" + (double)duration);
                    for (String faultName : this.mainFaultsSorted) {
                        HashSet<Integer> faultRups = fmRups.get(faultName);
                        EvenlyDiscretizedFunc probFunc = new EvenlyDiscretizedFunc(5.0, 41, 0.1);
                        EvenlyDiscretizedFunc rateFunc = new EvenlyDiscretizedFunc(5.0, 41, 0.1);
                        ERFBasedRegionalMagProbPlot.calcFaultProbs(probFunc, rateFunc, erf, rupSet, faultRups);
                        ((Map)faultMPDs.get((Object)cov)).put(faultName, probFunc);
                        ((Map)faultMFDs.get((Object)cov)).put(faultName, rateFunc);
                    }
                    this.debug(solIndex, "calculating sub section probs, dur=" + (double)duration);
                    boolean bl = false;
                    while (var28_64 < rupSet.getNumSections()) {
                        HashSet<Integer> sectRups = new HashSet<Integer>(rupSet.getRupturesForSection((int)var28_64));
                        subSectMPDs[var28_64] = new EvenlyDiscretizedFunc(5.0, 41, 0.1);
                        ERFBasedRegionalMagProbPlot.calcFaultProbs(subSectMPDs[var28_64], null, erf, rupSet, sectRups);
                        ++var28_64;
                    }
                    this.debug(solIndex, "calculating parent section probs, dur=" + (double)duration);
                    for (int parentID : fmParentRups.keySet()) {
                        HashSet<Integer> sectRups = fmParentRups.get(parentID);
                        EvenlyDiscretizedFunc parentSectMPD = new EvenlyDiscretizedFunc(5.0, 41, 0.1);
                        ERFBasedRegionalMagProbPlot.calcFaultProbs(parentSectMPD, null, erf, rupSet, sectRups);
                        ((Map)parentSectMPDs.get((Object)cov)).put(parentID, parentSectMPD);
                    }
                    this.debug(solIndex, "calculating region probs, dur=" + (double)duration);
                    boolean bl2 = false;
                    while (var28_67 < this.regions.size()) {
                        Region region = this.regions.get((int)var28_67);
                        watch = Stopwatch.createStarted();
                        this.debug(solIndex, "calculating region (COMBINED) " + (int)var28_67);
                        ucerf3_Part = ERF_Calculator.getParticipationMagFreqDistInRegion(erf, region, 5.05, 41, 0.1, true, rupsCache);
                        watch.stop();
                        this.debug(solIndex, "done region (COMBINED) " + (int)var28_67 + " (" + watch.elapsed(TimeUnit.SECONDS) + " s)");
                        ((List)mfds.get((Object)cov)).add(ucerf3_Part.getCumRateDistWithOffset());
                        ++var28_67;
                    }
                    erf.getParameter("Background Seismicity").setValue(IncludeBackgroundOption.EXCLUDE);
                    erf.updateForecast();
                    boolean bl3 = false;
                    while (var28_69 < this.regions.size()) {
                        Region region = this.regions.get((int)var28_69);
                        watch = Stopwatch.createStarted();
                        this.debug(solIndex, "calculating region (ON FAULT) " + (int)var28_69);
                        ucerf3_Part = ERF_Calculator.getParticipationMagFreqDistInRegion(erf, region, 5.05, 41, 0.1, true, rupsCache);
                        watch.stop();
                        this.debug(solIndex, "done region (ON FAULT) " + (int)var28_69 + " (" + watch.elapsed(TimeUnit.SECONDS) + " s)");
                        ((List)onMFDs.get((Object)cov)).add(ucerf3_Part.getCumRateDistWithOffset());
                        ++var28_69;
                    }
                    erf.getParameter("Background Seismicity").setValue(IncludeBackgroundOption.ONLY);
                    erf.updateForecast();
                    boolean bl4 = false;
                    while (var28_71 < this.regions.size()) {
                        Region region = this.regions.get((int)var28_71);
                        watch = Stopwatch.createStarted();
                        this.debug(solIndex, "calculating region (OFF FAULT) " + (int)var28_71);
                        ucerf3_Part = ERF_Calculator.getParticipationMagFreqDistInRegion(erf, region, 5.05, 41, 0.1, true, null);
                        watch.stop();
                        this.debug(solIndex, "done region (OFF FAULT) " + (int)var28_71 + " (" + watch.elapsed(TimeUnit.SECONDS) + " s)");
                        ((List)offMFDs.get((Object)cov)).add(ucerf3_Part.getCumRateDistWithOffset());
                        ++var28_71;
                    }
                    erf.getParameter("Background Seismicity").setValue(IncludeBackgroundOption.INCLUDE);
                    erf.getTimeSpan().setDuration(origDuration);
                    erf.updateForecast();
                }
                this.debug(solIndex, " archiving");
                ERFBasedRegionalMagProbPlot eRFBasedRegionalMagProbPlot = this;
                synchronized (eRFBasedRegionalMagProbPlot) {
                    Serializable mfd;
                    double branchWeight = this.weightProvider.getWeight(branch);
                    this.weights.get((double)duration).add(branchWeight);
                    ArrayList weightsForFM = this.fmWeights.get((double)duration).get(fm);
                    if (weightsForFM == null) {
                        weightsForFM = Lists.newArrayList();
                        this.fmWeights.get((double)duration).put(fm, weightsForFM);
                    }
                    weightsForFM.add(branchWeight);
                    this.branches.get((double)duration).add(branch);
                    for (int r = 0; r < this.regions.size(); ++r) {
                        HashMap map6p7 = Maps.newHashMap();
                        for (MagDependentAperiodicityOptions cov : covs) {
                            mfd = (EvenlyDiscretizedFunc)((List)mfds.get((Object)cov)).get(r);
                            EvenlyDiscretizedFunc probs = FaultSysSolutionERF_Calc.calcProbsFromSummedMFD(mfd, (double)duration);
                            this.solMPDs.get((double)duration).get(r).get((Object)cov).add(probs);
                            EvenlyDiscretizedFunc scaledMFD = mfd.deepClone();
                            scaledMFD.scale((double)duration);
                            this.solMFDs.get((double)duration).get(r).get((Object)cov).add(scaledMFD);
                            double prob6p7 = probs.getClosestYtoX(6.7);
                            map6p7.put(cov, prob6p7);
                            this.solOnMPDs.get((double)duration).get(r).get((Object)cov).add(FaultSysSolutionERF_Calc.calcProbsFromSummedMFD((EvenlyDiscretizedFunc)((List)onMFDs.get((Object)cov)).get(r), (double)duration));
                            this.solOffMPDs.get((double)duration).get(r).get((Object)cov).add(FaultSysSolutionERF_Calc.calcProbsFromSummedMFD((EvenlyDiscretizedFunc)((List)offMFDs.get((Object)cov)).get(r), (double)duration));
                        }
                        this.regionM6p7Vals.get((double)duration).get(r).put(branch, map6p7);
                    }
                    for (String faultName : this.mainFaultsSorted) {
                        for (MagDependentAperiodicityOptions cov : covs) {
                            this.solMainFaultProbs.get((double)duration).get((Object)cov).get(faultName).add((XY_DataSet)((Map)faultMPDs.get((Object)cov)).get(faultName));
                            this.solMainFaultRates.get((double)duration).get((Object)cov).get(faultName).add((XY_DataSet)((Map)faultMFDs.get((Object)cov)).get(faultName));
                        }
                    }
                    Iterator<Object> iterator = fmParentRups.keySet().iterator();
                    while (iterator.hasNext()) {
                        int parentID = (Integer)iterator.next();
                        for (MagDependentAperiodicityOptions cov : covs) {
                            this.solParentSectProbs.get((double)duration).get((Object)cov).get(fm).get(parentID).add((XY_DataSet)((Map)parentSectMPDs.get((Object)cov)).get(parentID));
                        }
                    }
                    for (Iterator<Object> iterator2 : covs) {
                        EvenlyDiscretizedFunc[] sectFuncs = (EvenlyDiscretizedFunc[])sectMPDs.get(iterator2);
                        Map<FaultModels, XY_DataSetList[]> fmMap = this.solSubSectProbs.get((double)duration).get(iterator2);
                        mfd = this;
                        synchronized (mfd) {
                            if (!fmMap.containsKey(fm)) {
                                XY_DataSetList[] lists = new XY_DataSetList[rupSet.getNumSections()];
                                for (int s = 0; s < lists.length; ++s) {
                                    lists[s] = new XY_DataSetList();
                                    lists[s].setName(rupSet.getFaultSectionData(s).getName());
                                }
                                fmMap.put(fm, lists);
                            }
                        }
                        XY_DataSetList[] lists = fmMap.get(fm);
                        Preconditions.checkState((sectFuncs.length == lists.length ? 1 : 0) != 0);
                        for (int s = 0; s < lists.length; ++s) {
                            lists[s].add(sectFuncs[s]);
                        }
                    }
                }
                this.debug(solIndex, " archiving done");
            }
        }

        @Override
        protected void combineDistributedCalcs(Collection<CompoundFSSPlots> otherCalcs) {
            for (CompoundFSSPlots otherCalc : otherCalcs) {
                int e;
                ERFBasedRegionalMagProbPlot o = (ERFBasedRegionalMagProbPlot)otherCalc;
                for (double duration : durations) {
                    Object oLists;
                    Object myLists;
                    Map<FaultModels, Object> o_fmMap;
                    for (int r = 0; r < this.regions.size(); ++r) {
                        for (MagDependentAperiodicityOptions cov : covs) {
                            this.solMPDs.get(duration).get(r).get((Object)cov).addAll(o.solMPDs.get(duration).get(r).get((Object)cov));
                            this.solMFDs.get(duration).get(r).get((Object)cov).addAll(o.solMFDs.get(duration).get(r).get((Object)cov));
                            this.solOnMPDs.get(duration).get(r).get((Object)cov).addAll(o.solOnMPDs.get(duration).get(r).get((Object)cov));
                            this.solOffMPDs.get(duration).get(r).get((Object)cov).addAll(o.solOffMPDs.get(duration).get(r).get((Object)cov));
                        }
                        this.regionM6p7Vals.get(duration).get(r).putAll(o.regionM6p7Vals.get(duration).get(r));
                    }
                    for (String faultName : this.mainFaultsSorted) {
                        for (MagDependentAperiodicityOptions cov : covs) {
                            this.solMainFaultProbs.get(duration).get((Object)cov).get(faultName).addAll(o.solMainFaultProbs.get(duration).get((Object)cov).get(faultName));
                            this.solMainFaultRates.get(duration).get((Object)cov).get(faultName).addAll(o.solMainFaultRates.get(duration).get((Object)cov).get(faultName));
                        }
                    }
                    for (MagDependentAperiodicityOptions cov : covs) {
                        Map<FaultModels, XY_DataSetList[]> fmMap = this.solSubSectProbs.get(duration).get((Object)cov);
                        o_fmMap = o.solSubSectProbs.get(duration).get((Object)cov);
                        for (FaultModels fm : o_fmMap.keySet()) {
                            if (!fmMap.containsKey(fm)) {
                                fmMap.put(fm, (XY_DataSetList[])o_fmMap.get(fm));
                                continue;
                            }
                            myLists = fmMap.get(fm);
                            Preconditions.checkState((((XY_DataSetList[])myLists).length == ((XY_DataSetList[])(oLists = (XY_DataSetList[])o_fmMap.get(fm))).length ? 1 : 0) != 0);
                            for (int s = 0; s < ((XY_DataSetList[])myLists).length; ++s) {
                                ((ArrayList)myLists[s]).addAll(oLists[s]);
                            }
                        }
                    }
                    for (MagDependentAperiodicityOptions cov : covs) {
                        Map<FaultModels, Map<Integer, XY_DataSetList>> fmMap = this.solParentSectProbs.get(duration).get((Object)cov);
                        o_fmMap = o.solParentSectProbs.get(duration).get((Object)cov);
                        for (FaultModels fm : o_fmMap.keySet()) {
                            if (!fmMap.containsKey(fm)) {
                                fmMap.put(fm, (Map)o_fmMap.get(fm));
                                continue;
                            }
                            myLists = fmMap.get(fm);
                            oLists = (Map)o_fmMap.get(fm);
                            Preconditions.checkState((myLists.size() == oLists.size() ? 1 : 0) != 0);
                            for (Integer parentID : myLists.keySet()) {
                                ((XY_DataSetList)myLists.get(parentID)).addAll((Collection)oLists.get(parentID));
                            }
                        }
                    }
                    this.weights.get(duration).addAll((Collection<Double>)o.weights.get(duration));
                    Map<FaultModels, List<Double>> weightsMap = this.fmWeights.get(duration);
                    Map<FaultModels, List<Double>> oWeightsMap = o.fmWeights.get(duration);
                    for (FaultModels fm : oWeightsMap.keySet()) {
                        if (!weightsMap.containsKey(fm)) {
                            weightsMap.put(fm, oWeightsMap.get(fm));
                            continue;
                        }
                        weightsMap.get(fm).addAll((Collection<Double>)oWeightsMap.get(fm));
                    }
                    this.branches.get(duration).addAll((Collection<U3LogicTreeBranch>)o.branches.get(duration));
                }
                for (e = 0; e < this.numUCEF2_DepERFs; ++e) {
                    for (double duration : durations) {
                        if (o.ucerf2DepMPDs.get(duration).get(0)[e] == null) continue;
                        for (int r = 0; r < this.regions.size(); ++r) {
                            this.ucerf2DepMPDs.get((Object)Double.valueOf((double)duration)).get((int)r)[e] = o.ucerf2DepMPDs.get(duration).get(r)[e];
                            this.ucerf2DepMFDs.get((Object)Double.valueOf((double)duration)).get((int)r)[e] = o.ucerf2DepMFDs.get(duration).get(r)[e];
                            this.ucerf2DepOnMPDs.get((Object)Double.valueOf((double)duration)).get((int)r)[e] = o.ucerf2DepOnMPDs.get(duration).get(r)[e];
                            this.ucerf2DepOffMPDs.get((Object)Double.valueOf((double)duration)).get((int)r)[e] = o.ucerf2DepOffMPDs.get(duration).get(r)[e];
                        }
                        this.ucerf2DepWeights[e] = o.ucerf2DepWeights[e];
                    }
                }
                for (e = 0; e < this.numUCEF2_IndepERFs; ++e) {
                    for (double duration : durations) {
                        if (o.ucerf2IndepMPDs.get(duration).get(0)[e] == null) continue;
                        for (int r = 0; r < this.regions.size(); ++r) {
                            this.ucerf2IndepMPDs.get((Object)Double.valueOf((double)duration)).get((int)r)[e] = o.ucerf2IndepMPDs.get(duration).get(r)[e];
                            this.ucerf2IndepMFDs.get((Object)Double.valueOf((double)duration)).get((int)r)[e] = o.ucerf2IndepMFDs.get(duration).get(r)[e];
                        }
                        this.ucerf2IndepWeights[e] = o.ucerf2IndepWeights[e];
                    }
                }
            }
        }

        static BranchSensitivityHistogram buildHist(Map<U3LogicTreeBranch, Map<MagDependentAperiodicityOptions, Double>> map, U3BranchWeightProvider weightProv) {
            BranchSensitivityHistogram hist = new BranchSensitivityHistogram("Prob M>=6.7");
            for (U3LogicTreeBranch branch : map.keySet()) {
                double branchWeight = weightProv.getWeight(branch);
                Map<MagDependentAperiodicityOptions, Double> covMap = map.get(branch);
                for (MagDependentAperiodicityOptions cov : covMap.keySet()) {
                    double prob6p7 = covMap.get((Object)cov);
                    String covName = cov == null ? "POISSON" : cov.name();
                    double subBranchWeight = branchWeight * FaultSystemSolutionERF.getWeightForCOV(cov);
                    hist.addValues(branch, prob6p7, subBranchWeight, "MagDepAperiodicity", covName);
                }
            }
            return hist;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected void doFinalizePlot() {
            this.ucerf2_dep_erf_lists.clear();
            this.ucerf2_indep_erf_lists.clear();
            System.gc();
            this.specs = Maps.newHashMap();
            this.faultSpecs = Maps.newHashMap();
            this.faultProbCSVs = HashBasedTable.create();
            this.regionProbCSVs = HashBasedTable.create();
            this.faultRateCSVs = HashBasedTable.create();
            this.regionRateCSVs = HashBasedTable.create();
            this.subSectsCSVs = HashBasedTable.create();
            this.subSectsPercentileCSVs = HashBasedTable.create();
            this.parentSectsCSVs = HashBasedTable.create();
            this.checkCalcAllUCERF2MFDs();
            Map<String, DiscretizedFunc[]> u2DepFaultVals = null;
            Map<String, DiscretizedFunc[]> u2IndepFaultVals = null;
            try {
                u2DepFaultVals = FaultSysSolutionERF_Calc.loadUCERF2MainFaultMPDs(true, true);
                u2DepFaultVals.put("Elsinore", u2DepFaultVals.get("Elsinore FM3.1"));
                u2IndepFaultVals = FaultSysSolutionERF_Calc.loadUCERF2MainFaultMPDs(true, false);
                u2IndepFaultVals.put("Elsinore", u2DepFaultVals.get("Elsinore FM3.1"));
            }
            catch (IOException e1) {
                ExceptionUtils.throwAsRuntimeException(e1);
            }
            for (double duration : durations) {
                Object allFractiles;
                Object ssProbsMaps;
                Object meanCSV;
                ArrayList weightsForFM;
                List<Double> origWeightsForFM;
                Object title;
                Object indepChar;
                List<Double> origWeights = this.weights.get(duration);
                List<U3LogicTreeBranch> origBranches = this.branches.get(duration);
                ArrayList weights = Lists.newArrayList();
                for (MagDependentAperiodicityOptions cov : covs) {
                    double covWeight = FaultSystemSolutionERF.getWeightForCOV(cov);
                    for (double weight : origWeights) {
                        weights.add(covWeight * weight);
                    }
                }
                HashMap depRegionMPDs = Maps.newHashMap();
                HashMap indepRegionMPDs = Maps.newHashMap();
                HashMap u2DepRegionMPDs = Maps.newHashMap();
                HashMap u2IndepRegionMPDs = Maps.newHashMap();
                HashMap depRegionMFDs = Maps.newHashMap();
                HashMap indepRegionMFDs = Maps.newHashMap();
                HashMap u2DepRegionMFDs = Maps.newHashMap();
                HashMap u2IndepRegionMFDs = Maps.newHashMap();
                ArrayList regionNames = Lists.newArrayList();
                ArrayList durSpecs = Lists.newArrayList();
                this.specs.put(duration, durSpecs);
                for (int r = 0; r < this.regions.size(); ++r) {
                    void var31_39;
                    Region region = this.regions.get(r);
                    regionNames.add(region.getName());
                    XY_DataSetList ucerf2Funcs = new XY_DataSetList();
                    XY_DataSetList ucerf2FreqFuncs = new XY_DataSetList();
                    XY_DataSetList ucerf2OnFuncs = new XY_DataSetList();
                    XY_DataSetList ucerf2OffFuncs = new XY_DataSetList();
                    ArrayList<Double> ucerf2Weights = new ArrayList<Double>();
                    for (int e = 0; e < this.ucerf2DepMPDs.get(duration).get(r).length; ++e) {
                        EvenlyDiscretizedFunc mfd = this.ucerf2DepMPDs.get(duration).get(r)[e];
                        if (mfd == null) continue;
                        ucerf2Funcs.add(this.ucerf2DepMPDs.get(duration).get(r)[e]);
                        ucerf2FreqFuncs.add(this.ucerf2DepMFDs.get(duration).get(r)[e]);
                        ucerf2OnFuncs.add(this.ucerf2DepOnMPDs.get(duration).get(r)[e]);
                        ucerf2OffFuncs.add(this.ucerf2DepOffMPDs.get(duration).get(r)[e]);
                        ucerf2Weights.add(this.ucerf2DepWeights[e]);
                    }
                    XY_DataSetList ucerf2IndepFuncs = new XY_DataSetList();
                    XY_DataSetList ucerf2IndepFreqFuncs = new XY_DataSetList();
                    ArrayList<Double> ucerf2IndepWeights = new ArrayList<Double>();
                    boolean bl = false;
                    while (var31_39 < this.ucerf2IndepMPDs.get(duration).get(r).length) {
                        EvenlyDiscretizedFunc mfd = this.ucerf2IndepMPDs.get(duration).get(r)[var31_39];
                        if (mfd != null) {
                            ucerf2IndepFuncs.add(this.ucerf2IndepMPDs.get(duration).get(r)[var31_39]);
                            ucerf2IndepFreqFuncs.add(this.ucerf2IndepMFDs.get(duration).get(r)[var31_39]);
                            ucerf2IndepWeights.add(this.ucerf2IndepWeights[var31_39]);
                        }
                        ++var31_39;
                    }
                    XY_DataSetList xY_DataSetList = new XY_DataSetList();
                    XY_DataSetList ucerf3RateFuncs = new XY_DataSetList();
                    XY_DataSetList ucerf3OnFuncs = new XY_DataSetList();
                    XY_DataSetList ucerf3OffFuncs = new XY_DataSetList();
                    XY_DataSetList ucerf3IndepFuncs = new XY_DataSetList();
                    XY_DataSetList ucerf3IndepRateFuncs = new XY_DataSetList();
                    for (MagDependentAperiodicityOptions cov : covs) {
                        xY_DataSetList.addAll(this.solMPDs.get(duration).get(r).get((Object)cov));
                        ucerf3RateFuncs.addAll(this.solMFDs.get(duration).get(r).get((Object)cov));
                        ucerf3OnFuncs.addAll(this.solOnMPDs.get(duration).get(r).get((Object)cov));
                        ucerf3OffFuncs.addAll(this.solOffMPDs.get(duration).get(r).get((Object)cov));
                    }
                    ucerf3IndepFuncs.addAll(this.solMPDs.get(duration).get(r).get(null));
                    ucerf3IndepRateFuncs.addAll(this.solMFDs.get(duration).get(r).get(null));
                    ArrayList funcs = Lists.newArrayList();
                    ArrayList chars = Lists.newArrayList();
                    funcs.addAll(ERFBasedRegionalMagProbPlot.getFractiles(ucerf2OnFuncs, ucerf2Weights, "UCERF2 Time Dependent On Fault MPDs", this.region_fractiles));
                    chars.addAll(ERFBasedRegionalMagProbPlot.getFractileChars(Color.GREEN, this.region_fractiles.length));
                    funcs.addAll(ERFBasedRegionalMagProbPlot.getFractiles(ucerf2OffFuncs, ucerf2Weights, "UCERF2 Time Dependent Off Fault MPDs", this.region_fractiles));
                    chars.addAll(ERFBasedRegionalMagProbPlot.getFractileChars(Color.MAGENTA, this.region_fractiles.length));
                    funcs.addAll(ERFBasedRegionalMagProbPlot.getFractiles(ucerf3OnFuncs, weights, "UCERF3 Time Dependent On Fault MPDs", this.region_fractiles));
                    chars.addAll(ERFBasedRegionalMagProbPlot.getFractileChars(Color.ORANGE, this.region_fractiles.length));
                    funcs.addAll(ERFBasedRegionalMagProbPlot.getFractiles(ucerf3OffFuncs, weights, "UCERF3 Time Dependent Off Fault MPDs", this.region_fractiles));
                    chars.addAll(ERFBasedRegionalMagProbPlot.getFractileChars(Color.GRAY, this.region_fractiles.length));
                    DiscretizedFunc u2IndepMean = ERFBasedRegionalMagProbPlot.getFractiles(ucerf2IndepFuncs, ucerf2IndepWeights, "UCERF2 Time Independent Total MPDs", this.region_fractiles).get(this.region_fractiles.length);
                    DiscretizedFunc u2IndepMeanFreq = ERFBasedRegionalMagProbPlot.getFractiles(ucerf2IndepFreqFuncs, ucerf2IndepWeights, "UCERF2 Time Independent Total MFDs", this.region_fractiles).get(this.region_fractiles.length);
                    u2IndepRegionMPDs.put(region.getName(), u2IndepMean);
                    u2IndepRegionMFDs.put(region.getName(), u2IndepMeanFreq);
                    funcs.add(u2IndepMean);
                    PlotCurveCharacterstics u2IndepChar = ERFBasedRegionalMagProbPlot.getFractileChars(Color.DARK_GRAY, this.region_fractiles.length).get(this.region_fractiles.length);
                    u2IndepChar.setLineWidth(2.0f);
                    chars.add(u2IndepChar);
                    List<DiscretizedFunc> list = ERFBasedRegionalMagProbPlot.getFractiles(ucerf2Funcs, ucerf2Weights, "UCERF2 Time Dependent Total MPDs", this.region_fractiles);
                    DiscretizedFunc u2DepFreq = ERFBasedRegionalMagProbPlot.getFractiles(ucerf2FreqFuncs, ucerf2Weights, "UCERF2 Time Dependent Total MFDs", this.region_fractiles).get(this.region_fractiles.length);
                    u2DepRegionMPDs.put(region.getName(), list.get(this.region_fractiles.length));
                    u2DepRegionMFDs.put(region.getName(), u2DepFreq);
                    funcs.addAll(list);
                    chars.addAll(ERFBasedRegionalMagProbPlot.getFractileChars(Color.RED, this.region_fractiles.length));
                    List<DiscretizedFunc> indepFractiles = ERFBasedRegionalMagProbPlot.getFractiles(ucerf3IndepFuncs, origWeights, "UCERF3 Time Independent Total MPDs", this.region_fractiles);
                    DiscretizedFunc discretizedFunc = indepFractiles.get(this.region_fractiles.length);
                    indepRegionMPDs.put(region.getName(), indepFractiles);
                    funcs.add(discretizedFunc);
                    PlotCurveCharacterstics indepChar2 = ERFBasedRegionalMagProbPlot.getFractileChars(Color.BLACK, this.region_fractiles.length).get(this.region_fractiles.length);
                    indepChar2.setLineWidth(2.0f);
                    chars.add(indepChar2);
                    List<DiscretizedFunc> indepRateFractiles = ERFBasedRegionalMagProbPlot.getFractiles(ucerf3IndepRateFuncs, origWeights, "UCERF3 Time Independent Total MPDs", this.region_fractiles);
                    DiscretizedFunc indepRateMean = indepRateFractiles.get(this.region_fractiles.length);
                    indepRegionMFDs.put(region.getName(), indepRateFractiles);
                    List<DiscretizedFunc> depFractiles = ERFBasedRegionalMagProbPlot.getFractiles(xY_DataSetList, weights, "UCERF3 Time Dependent Total MPDs", this.region_fractiles);
                    DiscretizedFunc depMean = depFractiles.get(this.region_fractiles.length);
                    depRegionMPDs.put(region.getName(), depFractiles);
                    funcs.addAll(depFractiles);
                    chars.addAll(ERFBasedRegionalMagProbPlot.getFractileChars(Color.BLUE, this.region_fractiles.length));
                    List<DiscretizedFunc> depRateFractiles = ERFBasedRegionalMagProbPlot.getFractiles(ucerf3RateFuncs, weights, "UCERF3 Time Dependent Total MPDs", this.region_fractiles);
                    depRegionMFDs.put(region.getName(), depRateFractiles);
                    String title2 = region.getName();
                    if (title2 == null || title2.isEmpty()) {
                        title2 = "Unnamed Region";
                    }
                    String xAxisLabel = "Magnitude";
                    String yAxisLabel = (int)duration + " Year Probability";
                    PlotSpec spec = new PlotSpec(funcs, chars, title2, xAxisLabel, yAxisLabel);
                    durSpecs.add(spec);
                }
                this.regionProbCSVs.put((Object)duration, (Object)true, this.getMFDCSV(depRegionMPDs, u2DepRegionMPDs, regionNames, duration, false));
                this.regionRateCSVs.put((Object)duration, (Object)true, this.getMFDCSV(depRegionMFDs, u2DepRegionMFDs, regionNames, duration, true));
                this.regionProbCSVs.put((Object)duration, (Object)false, this.getMFDCSV(indepRegionMPDs, u2IndepRegionMPDs, regionNames, duration, false));
                this.regionRateCSVs.put((Object)duration, (Object)false, this.getMFDCSV(indepRegionMFDs, u2IndepRegionMFDs, regionNames, duration, true));
                ArrayList faultSpecList = Lists.newArrayList();
                this.faultSpecs.put(duration, faultSpecList);
                HashMap depFaultMPDs = Maps.newHashMap();
                HashMap indepFaultMPDs = Maps.newHashMap();
                HashMap u2DepFaultMPDs = Maps.newHashMap();
                HashMap u2IndepFaultMPDs = Maps.newHashMap();
                HashMap depFaultMFDs = Maps.newHashMap();
                HashMap indepFaultMFDs = Maps.newHashMap();
                HashMap u2DepFaultMFDs = Maps.newHashMap();
                HashMap u2IndepFaultMFDs = Maps.newHashMap();
                for (MagDependentAperiodicityOptions[] magDependentAperiodicityOptionsArray : this.mainFaultsSorted) {
                    ArrayList funcs = Lists.newArrayList();
                    ArrayList chars = Lists.newArrayList();
                    MagDependentAperiodicityOptions[] depMPDs = new XY_DataSetList();
                    XY_DataSetList indepMPDs = new XY_DataSetList();
                    XY_DataSetList depMFDs = new XY_DataSetList();
                    XY_DataSetList indepMFDs = new XY_DataSetList();
                    for (MagDependentAperiodicityOptions cov : covs) {
                        depMPDs.addAll(this.solMainFaultProbs.get(duration).get((Object)cov).get(magDependentAperiodicityOptionsArray));
                        if (cov == null) {
                            indepMPDs.addAll(this.solMainFaultProbs.get(duration).get((Object)cov).get(magDependentAperiodicityOptionsArray));
                        }
                        depMFDs.addAll(this.solMainFaultRates.get(duration).get((Object)cov).get(magDependentAperiodicityOptionsArray));
                        if (cov != null) continue;
                        indepMFDs.addAll(this.solMainFaultRates.get(duration).get((Object)cov).get(magDependentAperiodicityOptionsArray));
                    }
                    if ((float)duration == 30.0f) {
                        DiscretizedFunc[] u2DepMPDs = u2DepFaultVals.get(magDependentAperiodicityOptionsArray);
                        DiscretizedFunc[] u2IndepMPDs = u2IndepFaultVals.get(magDependentAperiodicityOptionsArray);
                        if (u2DepMPDs != null) {
                            funcs.add(u2IndepMPDs[2]);
                            u2IndepFaultMPDs.put(magDependentAperiodicityOptionsArray, u2IndepMPDs[2]);
                            u2IndepFaultMFDs.put(magDependentAperiodicityOptionsArray, ERFBasedRegionalMagProbPlot.probsToRates(u2IndepMPDs[2], duration));
                            chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.DARK_GRAY));
                            funcs.add(u2DepMPDs[0]);
                            chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, Color.RED));
                            funcs.add(u2DepMPDs[1]);
                            chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, Color.RED));
                            funcs.add(u2DepMPDs[2]);
                            u2DepFaultMPDs.put(magDependentAperiodicityOptionsArray, u2DepMPDs[2]);
                            u2DepFaultMFDs.put(magDependentAperiodicityOptionsArray, ERFBasedRegionalMagProbPlot.probsToRates(u2DepMPDs[2], duration));
                            chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 4.0f, Color.RED));
                        }
                    }
                    List<DiscretizedFunc> indepFractiles = ERFBasedRegionalMagProbPlot.getFractiles(indepMPDs, origWeights, (String)magDependentAperiodicityOptionsArray + " Time Independent", this.region_fractiles);
                    DiscretizedFunc indepMean = indepFractiles.get(this.region_fractiles.length);
                    indepFaultMPDs.put(magDependentAperiodicityOptionsArray, indepFractiles);
                    indepFaultMFDs.put(magDependentAperiodicityOptionsArray, ERFBasedRegionalMagProbPlot.getFractiles(indepMFDs, origWeights, (String)magDependentAperiodicityOptionsArray + " Time Independent", this.region_fractiles));
                    funcs.add(indepMean);
                    indepChar = ERFBasedRegionalMagProbPlot.getFractileChars(Color.BLACK, this.region_fractiles.length).get(this.region_fractiles.length);
                    ((PlotCurveCharacterstics)indepChar).setLineWidth(2.0f);
                    chars.add(indepChar);
                    List<DiscretizedFunc> depFractiles = ERFBasedRegionalMagProbPlot.getFractiles((XY_DataSetList)depMPDs, weights, (String)magDependentAperiodicityOptionsArray + " Time Dependent", this.region_fractiles);
                    DiscretizedFunc discretizedFunc = depFractiles.get(this.region_fractiles.length);
                    depFaultMPDs.put(magDependentAperiodicityOptionsArray, depFractiles);
                    depFaultMFDs.put(magDependentAperiodicityOptionsArray, ERFBasedRegionalMagProbPlot.getFractiles(depMFDs, weights, (String)magDependentAperiodicityOptionsArray + " Time Dependent", this.region_fractiles));
                    funcs.addAll(depFractiles);
                    chars.addAll(ERFBasedRegionalMagProbPlot.getFractileChars(Color.BLUE, this.region_fractiles.length));
                    title = magDependentAperiodicityOptionsArray;
                    String xAxisLabel = "Magnitude";
                    String string = (int)duration + " Year Probability";
                    PlotSpec spec = new PlotSpec(funcs, chars, (String)title, xAxisLabel, string);
                    faultSpecList.add(spec);
                }
                this.faultProbCSVs.put((Object)duration, (Object)true, this.getMFDCSV(depFaultMPDs, u2DepFaultMPDs, this.mainFaultsSorted, duration, false));
                this.faultRateCSVs.put((Object)duration, (Object)true, this.getMFDCSV(depFaultMFDs, u2DepFaultMFDs, this.mainFaultsSorted, duration, true));
                this.faultProbCSVs.put((Object)duration, (Object)false, this.getMFDCSV(indepFaultMPDs, u2IndepFaultMPDs, this.mainFaultsSorted, duration, false));
                this.faultRateCSVs.put((Object)duration, (Object)false, this.getMFDCSV(indepFaultMFDs, u2IndepFaultMFDs, this.mainFaultsSorted, duration, true));
                for (FaultModels faultModels : this.fmWeights.get(duration).keySet()) {
                    void var42_72;
                    void var45_88;
                    origWeightsForFM = this.fmWeights.get(duration).get(faultModels);
                    weightsForFM = Lists.newArrayList();
                    for (MagDependentAperiodicityOptions cov : covs) {
                        double covWeight = FaultSystemSolutionERF.getWeightForCOV(cov);
                        indepChar = origWeightsForFM.iterator();
                        while (indepChar.hasNext()) {
                            double weight = (Double)indepChar.next();
                            weightsForFM.add(covWeight * weight);
                        }
                    }
                    meanCSV = new CSVFile(true);
                    ArrayList fractileCSVs = Lists.newArrayList();
                    for (int i = 0; i < this.sub_sect_fractiles.length; ++i) {
                        fractileCSVs.add(new CSVFile(true));
                    }
                    CSVFile<String> minCSV = new CSVFile<String>(true);
                    CSVFile<String> maxCSV = new CSVFile<String>(true);
                    CSVFile<String> poissonCSV = new CSVFile<String>(true);
                    ArrayList header = Lists.newArrayList();
                    header.add("Sub Section Name");
                    ssProbsMaps = this.solSubSectProbs.get(duration);
                    XY_DataSetList[] allCOVProbs = null;
                    Object var42_71 = null;
                    title = covs;
                    int xAxisLabel = ((MagDependentAperiodicityOptions[])title).length;
                    boolean bl = false;
                    while (var45_88 < xAxisLabel) {
                        MagDependentAperiodicityOptions cov = title[var45_88];
                        XY_DataSetList[] ssProbs = (XY_DataSetList[])((Map)ssProbsMaps.get((Object)cov)).get(faultModels);
                        if (allCOVProbs == null) {
                            allCOVProbs = new XY_DataSetList[ssProbs.length];
                            for (int s = 0; s < ssProbs.length; ++s) {
                                allCOVProbs[s] = new XY_DataSetList();
                                allCOVProbs[s].setName(ssProbs[s].getName());
                            }
                            for (Point2D pt : (XY_DataSet)ssProbs[0].get(0)) {
                                header.add("" + (float)pt.getX());
                            }
                        }
                        if (cov == null) {
                            XY_DataSetList[] xY_DataSetListArray = ssProbs;
                        }
                        for (int s = 0; s < ssProbs.length; ++s) {
                            allCOVProbs[s].addAll(ssProbs[s]);
                        }
                        ++var45_88;
                    }
                    Preconditions.checkNotNull(allCOVProbs);
                    Preconditions.checkNotNull((Object)var42_72);
                    ((CSVFile)meanCSV).addLine(header);
                    for (CSVFile fractileCSV : fractileCSVs) {
                        fractileCSV.addLine(header);
                    }
                    minCSV.addLine(header);
                    maxCSV.addLine(header);
                    poissonCSV.addLine(header);
                    for (int s = 0; s < allCOVProbs.length; ++s) {
                        XY_DataSetList allList = allCOVProbs[s];
                        void var45_89 = var42_72[s];
                        String name = var45_89.getName();
                        allFractiles = ERFBasedRegionalMagProbPlot.getFractiles(allList, weightsForFM, "", this.sub_sect_fractiles);
                        List<DiscretizedFunc> poissonFractiles = ERFBasedRegionalMagProbPlot.getFractiles((XY_DataSetList)var45_89, origWeightsForFM, "", new double[0]);
                        int counter = 0;
                        for (int i = 0; i < this.sub_sect_fractiles.length; ++i) {
                            ((CSVFile)fractileCSVs.get(i)).addLine(ERFBasedRegionalMagProbPlot.getMFDRow((DiscretizedFunc)allFractiles.get(counter++), name));
                        }
                        ((CSVFile)meanCSV).addLine(ERFBasedRegionalMagProbPlot.getMFDRow((DiscretizedFunc)allFractiles.get(counter++), name));
                        minCSV.addLine(ERFBasedRegionalMagProbPlot.getMFDRow((DiscretizedFunc)allFractiles.get(counter++), name));
                        maxCSV.addLine(ERFBasedRegionalMagProbPlot.getMFDRow((DiscretizedFunc)allFractiles.get(counter++), name));
                        poissonCSV.addLine(ERFBasedRegionalMagProbPlot.getMFDRow(poissonFractiles.get(0), name));
                    }
                    ArrayList csvs = Lists.newArrayList();
                    csvs.add(meanCSV);
                    csvs.add(minCSV);
                    csvs.add(maxCSV);
                    csvs.add(poissonCSV);
                    this.subSectsCSVs.put((Object)duration, (Object)faultModels, (Object)csvs);
                    this.subSectsPercentileCSVs.put((Object)duration, (Object)faultModels, (Object)fractileCSVs);
                }
                for (FaultModels faultModels : this.fmWeights.get(duration).keySet()) {
                    origWeightsForFM = this.fmWeights.get(duration).get(faultModels);
                    weightsForFM = Lists.newArrayList();
                    for (MagDependentAperiodicityOptions cov : covs) {
                        double covWeight = FaultSystemSolutionERF.getWeightForCOV(cov);
                        ssProbsMaps = origWeightsForFM.iterator();
                        while (ssProbsMaps.hasNext()) {
                            double weight = ssProbsMaps.next();
                            weightsForFM.add(covWeight * weight);
                        }
                    }
                    meanCSV = new CSVFile(true);
                    CSVFile<String> minCSV = new CSVFile<String>(true);
                    CSVFile<String> maxCSV = new CSVFile<String>(true);
                    CSVFile<String> poissonCSV = new CSVFile<String>(true);
                    ArrayList header = Lists.newArrayList();
                    header.add("Parent Section Name");
                    Map<MagDependentAperiodicityOptions, Map<FaultModels, Map<Integer, XY_DataSetList>>> parentProbsMaps = this.solParentSectProbs.get(duration);
                    HashMap<Integer, XY_DataSetList> allCOVProbs = null;
                    Map<Integer, XY_DataSetList> poissonProbs = null;
                    for (MagDependentAperiodicityOptions magDependentAperiodicityOptions : covs) {
                        Map<Integer, XY_DataSetList> parentProbs = parentProbsMaps.get((Object)magDependentAperiodicityOptions).get(faultModels);
                        if (allCOVProbs == null) {
                            allCOVProbs = new HashMap<Integer, XY_DataSetList>();
                            allFractiles = parentProbs.keySet().iterator();
                            while (allFractiles.hasNext()) {
                                int parentID2 = allFractiles.next();
                                XY_DataSetList parentList = new XY_DataSetList();
                                parentList.setName(parentProbs.get(parentID2).getName());
                                allCOVProbs.put(parentID2, parentList);
                            }
                            for (Point2D pt : (XY_DataSet)parentProbs.values().iterator().next().get(0)) {
                                header.add("" + (float)pt.getX());
                            }
                        }
                        if (magDependentAperiodicityOptions == null) {
                            poissonProbs = parentProbs;
                        }
                        allFractiles = parentProbs.keySet().iterator();
                        while (allFractiles.hasNext()) {
                            int parentID3 = allFractiles.next();
                            ((XY_DataSetList)allCOVProbs.get(parentID3)).addAll(parentProbs.get(parentID3));
                        }
                    }
                    Preconditions.checkNotNull(allCOVProbs);
                    Preconditions.checkNotNull(poissonProbs);
                    ((CSVFile)meanCSV).addLine(header);
                    minCSV.addLine(header);
                    maxCSV.addLine(header);
                    poissonCSV.addLine(header);
                    HashMap hashMap = Maps.newHashMap();
                    Map<Integer, String> parentIDsNamesMap = this.parentSectNamesMap.get(faultModels);
                    for (Integer n : parentIDsNamesMap.keySet()) {
                        hashMap.put(parentIDsNamesMap.get(n), n);
                    }
                    ArrayList parentNamesSorted = Lists.newArrayList(hashMap.keySet());
                    Collections.sort(parentNamesSorted);
                    for (String parentName : parentNamesSorted) {
                        Integer parentID5 = (Integer)hashMap.get(parentName);
                        XY_DataSetList allList = (XY_DataSetList)allCOVProbs.get(parentID5);
                        XY_DataSetList poissonList = poissonProbs.get(parentID5);
                        List<DiscretizedFunc> allFractiles2 = ERFBasedRegionalMagProbPlot.getFractiles(allList, weightsForFM, "", new double[0]);
                        List<DiscretizedFunc> poissonFractiles = ERFBasedRegionalMagProbPlot.getFractiles(poissonList, origWeightsForFM, "", new double[0]);
                        ((CSVFile)meanCSV).addLine(ERFBasedRegionalMagProbPlot.getMFDRow(allFractiles2.get(0), parentName));
                        minCSV.addLine(ERFBasedRegionalMagProbPlot.getMFDRow(allFractiles2.get(1), parentName));
                        maxCSV.addLine(ERFBasedRegionalMagProbPlot.getMFDRow(allFractiles2.get(2), parentName));
                        poissonCSV.addLine(ERFBasedRegionalMagProbPlot.getMFDRow(poissonFractiles.get(0), parentName));
                    }
                    ArrayList arrayList = Lists.newArrayList();
                    arrayList.add(meanCSV);
                    arrayList.add(minCSV);
                    arrayList.add(maxCSV);
                    arrayList.add(poissonCSV);
                    this.parentSectsCSVs.put((Object)duration, (Object)faultModels, (Object)arrayList);
                }
            }
        }

        private static List<String> getMFDRow(DiscretizedFunc func, String name) {
            ArrayList line = Lists.newArrayList();
            line.add(name);
            for (Point2D pt : func) {
                line.add("" + pt.getY());
            }
            return line;
        }

        private static DiscretizedFunc probsToRates(DiscretizedFunc probs, double duration) {
            ArbitrarilyDiscretizedFunc rates = new ArbitrarilyDiscretizedFunc();
            rates.setName(probs.getName());
            for (Point2D pt : probs) {
                rates.set(pt.getX(), -Math.log(1.0 - pt.getY()));
            }
            return rates;
        }

        private CSVFile<String> getMFDCSV(Map<String, List<DiscretizedFunc>> mpds, Map<String, DiscretizedFunc> u2MPDs, List<String> names, double duration, boolean isRate) {
            CSVFile<String> csv = new CSVFile<String>(true);
            ArrayList header = Lists.newArrayList((Object[])new String[]{"Magnitude"});
            for (String fault : names) {
                header.add(fault + " Mean");
            }
            for (String fault : names) {
                header.add(fault + " Min");
            }
            for (String fault : names) {
                header.add(fault + " Max");
            }
            if (!u2MPDs.isEmpty()) {
                for (String fault : names) {
                    header.add(fault + " U2");
                }
            }
            DiscretizedFunc xVals = mpds.values().iterator().next().get(0);
            csv.addLine(header);
            for (int i = 0; i < xVals.size(); ++i) {
                ArrayList line = Lists.newArrayList();
                line.add("" + xVals.getX(i));
                for (int j = 0; j < 3; ++j) {
                    for (String fault : names) {
                        line.add("" + mpds.get(fault).get(j + this.region_fractiles.length).getY(i));
                    }
                }
                if (!u2MPDs.isEmpty()) {
                    for (String fault : names) {
                        double x = xVals.getX(i);
                        DiscretizedFunc u2MPD = u2MPDs.get(fault);
                        int ind = u2MPD.getXIndex(x);
                        if (ind >= 0) {
                            line.add("" + u2MPD.getY(ind));
                            continue;
                        }
                        if (x > u2MPD.getMinX() && x < u2MPD.getMaxX()) {
                            line.add("" + u2MPD.getInterpolatedY(x));
                            continue;
                        }
                        line.add("");
                    }
                }
                csv.addLine(line);
            }
            return csv;
        }

        @Override
        protected boolean usesERFs() {
            return true;
        }

        @Override
        protected boolean isApplyAftershockFilter() {
            return !INCLUDE_AFTERSHOCKS;
        }

        @Override
        protected boolean isTimeDependent() {
            return true;
        }

        protected Map<Double, List<PlotSpec>> getSpecs() {
            return this.specs;
        }

        static {
            mainFaultsCombinedPFDNames.add("S. San Andreas");
            mainFaultsCombinedPFDNames.add("N. San Andreas");
            mainFaultsCombinedPFDNames.add("Hayward-Rodgers Creek");
            mainFaultsCombinedPFDNames.add("Calaveras");
            mainFaultsCombinedPFDNames.add("San Jacinto");
            mainFaultsCombinedPFDNames.add("Garlock");
            mainFaultsCombinedPFDNames.add("Elsinore");
        }
    }

    public static class ERFBasedSiteHazardHistPlot
    extends CompoundFSSPlots {
        private static MagDependentAperiodicityOptions[] covs = new MagDependentAperiodicityOptions[]{MagDependentAperiodicityOptions.LOW_VALUES, MagDependentAperiodicityOptions.MID_VALUES, MagDependentAperiodicityOptions.HIGH_VALUES, null};
        private U3BranchWeightProvider weightProv;
        private List<Site> sites;
        private Map<AttenRelRef, Double> imrs;
        private List<Period> periods;
        private List<DiscretizedFunc> xValsList;
        private File curveDir;
        private transient Map<Site, BinaryCurveArchiver> archivers;
        private U3LogicTreeBranch[] branches;
        private double[] branchWeights;
        protected static final String DEFAULT_CACHE_DIR_NAME = "site_hazard_curve_cache";
        private static final double duration = 50.0;
        private static final double[] probLevels = new double[]{0.02, 0.1};
        private transient Map<AttenRelRef, Deque<ScalarIMR>> imrsCache = Maps.newHashMap();
        private transient SiteHazardResults plots;

        public static List<Site> getSites() {
            ArrayList sites = Lists.newArrayList();
            try {
                Map<String, Location> locs = UC3_CalcUtils.readSiteFile(UCERF3_DataUtils.locateResource("misc", "srp_sites_no_pbr.txt"));
                for (String name : locs.keySet()) {
                    Location loc = locs.get(name);
                    Site s = new Site(loc, name);
                    DepthTo1pt0kmPerSecParam d10p = new DepthTo1pt0kmPerSecParam(null, 0.0, 1000.0, true);
                    d10p.setValueAsDefault();
                    s.addParameter(d10p);
                    DepthTo2pt5kmPerSecParam d25p = new DepthTo2pt5kmPerSecParam(null, 0.0, 1000.0, true);
                    d25p.setValueAsDefault();
                    s.addParameter(d25p);
                    Vs30_Param vs30p = new Vs30_Param(760.0);
                    vs30p.setValueAsDefault();
                    s.addParameter(vs30p);
                    Vs30_TypeParam vs30tp = new Vs30_TypeParam();
                    s.addParameter(vs30tp);
                    sites.add(s);
                }
            }
            catch (IOException e) {
                ExceptionUtils.throwAsRuntimeException(e);
            }
            return sites;
        }

        private static Map<AttenRelRef, Double> buildIMRMap() {
            AttenRelRef[] imrs = new AttenRelRef[]{AttenRelRef.CB_2008, AttenRelRef.BA_2008, AttenRelRef.CY_2008, AttenRelRef.AS_2008};
            HashMap map = Maps.newHashMap();
            for (AttenRelRef ref : imrs) {
                map.put(ref, 1.0 / (double)imrs.length);
            }
            return map;
        }

        public static List<Period> getPeriods() {
            ArrayList periods = Lists.newArrayList();
            periods.add(Period.GM0P00);
            periods.add(Period.GM4P00);
            periods.add(Period.GM1P00);
            periods.add(Period.GM0P20);
            return periods;
        }

        public ERFBasedSiteHazardHistPlot(U3BranchWeightProvider weightProv, File curveDir, int numBranches) {
            this.debug(-1, "ERFBasedSiteHazardHistPlot START constructor");
            this.weightProv = weightProv;
            this.curveDir = curveDir;
            if (MPI.COMM_WORLD == null || MPI.COMM_WORLD.Rank() == 0) {
                File metadataFile;
                if (!curveDir.exists()) {
                    curveDir.mkdir();
                }
                if ((metadataFile = new File(curveDir, "metadata.xml")).exists()) {
                    metadataFile.delete();
                }
            }
            this.sites = ERFBasedSiteHazardHistPlot.getSites();
            this.imrs = ERFBasedSiteHazardHistPlot.buildIMRMap();
            this.periods = ERFBasedSiteHazardHistPlot.getPeriods();
            this.xValsList = Lists.newArrayList();
            for (Period period : this.periods) {
                this.xValsList.add(period.getLogFunction());
            }
            this.archivers = Maps.newHashMap();
            this.debug(-1, "ERFBasedSiteHazardHistPlot Building Archivers");
            for (Site site : this.sites) {
                HashMap xValsMap = Maps.newHashMap();
                for (Period period : this.periods) {
                    for (AttenRelRef imr : this.imrs.keySet()) {
                        for (MagDependentAperiodicityOptions cov : covs) {
                            String prefix = ERFBasedSiteHazardHistPlot.buildBinFilePrefix(imr, period, cov);
                            xValsMap.put(prefix, period.getFunction());
                        }
                    }
                }
                File siteDir = new File(curveDir, site.getName());
                if (MPI.COMM_WORLD == null || MPI.COMM_WORLD.Rank() == 0) {
                    if (!siteDir.exists()) {
                        siteDir.mkdir();
                    }
                } else {
                    while (!siteDir.exists()) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e) {
                            ExceptionUtils.throwAsRuntimeException(e);
                        }
                    }
                }
                BinaryCurveArchiver archiver = new BinaryCurveArchiver(siteDir, numBranches, xValsMap);
                this.archivers.put(site, archiver);
                if (MPI.COMM_WORLD != null && MPI.COMM_WORLD.Rank() != 0) continue;
                this.debug(-1, "ERFBasedSiteHazardHistPlot Initializing an archiver for: " + site.getName());
                for (String prefix : xValsMap.keySet()) {
                    File file = new File(siteDir, prefix + ".bin");
                    if (!file.exists()) continue;
                    file.delete();
                }
                archiver.initialize();
            }
            this.branches = new U3LogicTreeBranch[numBranches];
            this.branchWeights = new double[numBranches];
            this.debug(-1, "ERFBasedSiteHazardHistPlot END constructor");
        }

        @Override
        protected void processSolution(U3LogicTreeBranch branch, InversionFaultSystemSolution sol, int solIndex) {
            throw new IllegalStateException("Should never be called, ERF plot");
        }

        private synchronized ScalarIMR getIMRInstance(AttenRelRef ref) {
            ScalarIMR imr;
            Deque<ScalarIMR> list = this.imrsCache.get(ref);
            if (list == null) {
                list = new ArrayDeque<ScalarIMR>();
                this.imrsCache.put(ref, list);
            }
            if (list.isEmpty()) {
                imr = ref.instance(null);
                imr.setParamDefaults();
            } else {
                imr = list.pop();
            }
            return imr;
        }

        private synchronized void returnIMRInstance(AttenRelRef ref, ScalarIMR imr) {
            this.imrsCache.get(ref).push(imr);
        }

        private static String buildBinFilePrefix(AttenRelRef imr, Period period, MagDependentAperiodicityOptions cov) {
            String str = imr.name() + "_" + period.getLabel() + "_";
            str = cov == null ? str + "POISSON" : str + cov.name();
            return str;
        }

        @Override
        protected void processERF(U3LogicTreeBranch branch, FaultSystemSolutionERF erf, int solIndex) {
            erf.getTimeSpan().setDuration(50.0);
            erf.updateForecast();
            for (MagDependentAperiodicityOptions cov : covs) {
                if (cov == null) {
                    erf.setParameter("Probability Model", (Object)ProbabilityModelOptions.POISSON);
                } else {
                    erf.setParameter("Probability Model", (Object)ProbabilityModelOptions.U3_BPT);
                    erf.setParameter("Aperiodicity", (Object)cov);
                }
                double origDuration = erf.getTimeSpan().getDuration();
                erf.getTimeSpan().setDuration(50.0);
                this.debug(solIndex, "updating forecast for cov=" + String.valueOf((Object)cov));
                erf.updateForecast();
                this.debug(solIndex, "done updating forecast for cov=" + String.valueOf((Object)cov));
                for (Site site : this.sites) {
                    ArrayList tasks = Lists.newArrayList();
                    BinaryCurveArchiver archiver = this.archivers.get(site);
                    for (AttenRelRef ref : this.imrs.keySet()) {
                        for (int i = 0; i < this.periods.size(); ++i) {
                            Period period = this.periods.get(i);
                            String prefix = ERFBasedSiteHazardHistPlot.buildBinFilePrefix(ref, period, cov);
                            DiscretizedFunc xVals = this.xValsList.get(i);
                            tasks.add(new SiteHazardCalcJob(this, archiver, erf, ref, site, period, prefix, xVals, solIndex));
                        }
                    }
                    try {
                        new ThreadedTaskComputer(tasks).computeThreaded();
                    }
                    catch (InterruptedException e) {
                        ExceptionUtils.throwAsRuntimeException(e);
                    }
                }
            }
            this.branches[solIndex] = branch;
            this.branchWeights[solIndex] = this.weightProv.getWeight(branch);
        }

        @Override
        protected void flushResults() {
            for (BinaryCurveArchiver archiver : this.archivers.values()) {
                archiver.close();
            }
        }

        @Override
        protected void combineDistributedCalcs(Collection<CompoundFSSPlots> otherCalcs) {
            for (CompoundFSSPlots other : otherCalcs) {
                ERFBasedSiteHazardHistPlot o = (ERFBasedSiteHazardHistPlot)other;
                Preconditions.checkState((this.branches.length == o.branches.length ? 1 : 0) != 0);
                for (int i = 0; i < o.branches.length; ++i) {
                    if (o.branches[i] == null) continue;
                    Preconditions.checkState((this.branches[i] == null ? 1 : 0) != 0);
                    this.branches[i] = o.branches[i];
                    this.branchWeights[i] = o.branchWeights[i];
                }
            }
        }

        @Override
        protected void doFinalizePlot() {
            ERFBasedSiteHazardHistPlot.writeMetadataFile(this.curveDir, this.sites, this.periods, this.imrs, this.branches, this.branchWeights);
            this.plots = ERFBasedSiteHazardHistPlot.doFinalizePlot(this.curveDir, this.sites, this.periods, this.imrs, this.branches, this.branchWeights);
        }

        private static void writeMetadataFileForAllBranches(List<U3LogicTreeBranch> branches, U3BranchWeightProvider prov, File curveDir) {
            U3APrioriBranchWeightProvider weightProv = new U3APrioriBranchWeightProvider();
            U3LogicTreeBranch[] branchArray = new U3LogicTreeBranch[branches.size()];
            double[] branchWeights = new double[branches.size()];
            for (int i = 0; i < branches.size(); ++i) {
                U3LogicTreeBranch branch;
                branchArray[i] = branch = branches.get(i);
                branchWeights[i] = weightProv.getWeight(branch);
            }
            ERFBasedSiteHazardHistPlot.writeMetadataFile(curveDir, ERFBasedSiteHazardHistPlot.getSites(), ERFBasedSiteHazardHistPlot.getPeriods(), ERFBasedSiteHazardHistPlot.buildIMRMap(), branchArray, branchWeights);
        }

        private static void writeMetadataFile(File curveDir, List<Site> sites, List<Period> periods, Map<AttenRelRef, Double> imrs, U3LogicTreeBranch[] branches, double[] branchWeights) {
            Element subEl;
            Document doc = XMLUtils.createDocumentWithRoot();
            Element root = doc.getRootElement();
            Site.writeSitesToXML(sites, root);
            Element periodsEl = root.addElement("Periods");
            for (Period period : periods) {
                Element subEl2 = periodsEl.addElement("Period");
                subEl2.addAttribute("name", period.name());
            }
            Element imrsEl = root.addElement("IMRs");
            for (AttenRelRef imr : imrs.keySet()) {
                subEl = imrsEl.addElement("IMR");
                subEl.addAttribute("name", imr.name());
                subEl.addAttribute("weight", imrs.get(imr).toString());
            }
            Element element = root.addElement("Branches");
            element.addAttribute("num", "" + branches.length);
            for (int i = 0; i < branches.length; ++i) {
                subEl = element.addElement("Branch");
                subEl.addAttribute("index", "" + i);
                subEl.addAttribute("name", branches[i].buildFileName());
                subEl.addAttribute("weight", "" + branchWeights[i]);
            }
            File xmlFile = new File(curveDir, "metadata.xml");
            try {
                XMLUtils.writeDocumentToFile(xmlFile, doc);
            }
            catch (IOException e) {
                throw ExceptionUtils.asRuntimeException(e);
            }
        }

        protected static SiteHazardResults doFinalizePlot(File curveDir) {
            Document doc;
            File xmlFile = new File(curveDir, "metadata.xml");
            try {
                doc = XMLUtils.loadDocument(xmlFile);
            }
            catch (Exception e) {
                throw ExceptionUtils.asRuntimeException(e);
            }
            Element root = doc.getRootElement();
            ArrayList<Site> sites = Site.loadSitesFromXML(root.element(Site.XML_METADATA_LIST_NAME), new ArrayList());
            ArrayList periods = Lists.newArrayList();
            for (Object periodEl : root.element("Periods").elements()) {
                periods.add(Period.valueOf(periodEl.attributeValue("name")));
            }
            HashMap imrs = Maps.newHashMap();
            for (Element imrEl : root.element("IMRs").elements()) {
                AttenRelRef imr = AttenRelRef.valueOf(imrEl.attributeValue("name"));
                double weight = Double.parseDouble(imrEl.attributeValue("weight"));
                imrs.put(imr, weight);
            }
            Element branchesEl = root.element("Branches");
            int numBranches = Integer.parseInt(branchesEl.attributeValue("num"));
            U3LogicTreeBranch[] branches = new U3LogicTreeBranch[numBranches];
            double[] branchWeights = new double[numBranches];
            for (Element branchEl : branchesEl.elements()) {
                U3LogicTreeBranch branch = U3LogicTreeBranch.fromFileName(branchEl.attributeValue("name"));
                double weight = Double.parseDouble(branchEl.attributeValue("weight"));
                int index = Integer.parseInt(branchEl.attributeValue("index"));
                branches[index] = branch;
                branchWeights[index] = weight;
            }
            return ERFBasedSiteHazardHistPlot.doFinalizePlot(curveDir, sites, periods, imrs, branches, branchWeights);
        }

        protected static SiteHazardResults doFinalizePlot(File curveDir, List<Site> sites, List<Period> periods, Map<AttenRelRef, Double> imrs, U3LogicTreeBranch[] branches, double[] branchWeights) {
            SiteHazardResults results = new SiteHazardResults();
            results.plotsMap = Maps.newHashMap();
            results.csvsMap = Maps.newHashMap();
            for (Site site : sites) {
                HashBasedTable sitePlots = HashBasedTable.create();
                HashBasedTable siteCSVs = HashBasedTable.create();
                results.plotsMap.put(site, (Table<Period, Double, Map<String, PlotSpec>>)sitePlots);
                results.csvsMap.put(site, (Table<Period, Double, CSVFile<String>>)siteCSVs);
                for (Period period : periods) {
                    for (double prob : probLevels) {
                        Object periodName = period == Period.GM0P00 ? "PGA" : (float)period.getValue() + "s SA";
                        String xAxisName = (String)periodName + ", " + (int)(prob * 100.0) + "% in 50yr";
                        BranchSensitivityHistogram hist = new BranchSensitivityHistogram(xAxisName);
                        for (MagDependentAperiodicityOptions cov : covs) {
                            double covWeight = FaultSystemSolutionERF.getWeightForCOV(cov);
                            String covName = cov == null ? "POISSON" : cov.name();
                            for (AttenRelRef imr : imrs.keySet()) {
                                double imrWeight = imrs.get(imr);
                                String binFilePrefix = ERFBasedSiteHazardHistPlot.buildBinFilePrefix(imr, period, cov);
                                File binFile = new File(new File(curveDir, site.getName()), binFilePrefix + ".bin");
                                Preconditions.checkState((boolean)binFile.exists(), (Object)("Bin file not found: " + binFile.getAbsolutePath()));
                                ArrayList curves = Lists.newArrayList();
                                try {
                                    BinaryHazardCurveReader reader = new BinaryHazardCurveReader(binFile.getAbsolutePath());
                                    ArbitrarilyDiscretizedFunc readCurve = reader.nextCurve();
                                    while (readCurve != null) {
                                        curves.add(readCurve);
                                        readCurve = reader.nextCurve();
                                    }
                                }
                                catch (Exception e) {
                                    ExceptionUtils.throwAsRuntimeException(e);
                                }
                                for (int i = 0; i < branches.length; ++i) {
                                    U3LogicTreeBranch branch = branches[i];
                                    double weight = branchWeights[i] * imrWeight * covWeight;
                                    DiscretizedFunc curve = (DiscretizedFunc)curves.get(i);
                                    String metadata = "site=" + site.getName() + ", prefix=" + binFilePrefix + ", branch=" + i + ", " + branch.buildFileName();
                                    ERFBasedSiteHazardHistPlot.validateCurve(curve, metadata);
                                    double val = HazardDataSetLoader.getCurveVal(curve, false, prob);
                                    if (Double.isNaN(val)) {
                                        System.err.flush();
                                        System.out.println("NaN probability value! site=" + site.getName() + ", prefix=" + binFilePrefix + ", branch=" + i + ", " + branch.buildFileName());
                                        System.out.print("\tx:");
                                        for (Point2D pt : curve) {
                                            System.out.print("\t" + (float)pt.getX());
                                        }
                                        System.out.println();
                                        System.out.print("\ty:");
                                        for (Point2D pt : curve) {
                                            System.out.print("\t" + (float)pt.getY());
                                        }
                                        System.out.println();
                                        val = curve.getMaxX();
                                        System.out.flush();
                                        System.err.println("Using max val=" + val);
                                        System.err.flush();
                                    }
                                    Preconditions.checkState((boolean)Doubles.isFinite((double)val), (Object)("Non finite val: " + val + ". " + metadata));
                                    hist.addValues(branch, val, weight, "MagDepAperiodicity", covName, "GMPE", imr.getShortName());
                                }
                            }
                        }
                        double delta = 0.02;
                        Map<String, PlotSpec> histSpecs = hist.getStackedHistPlots(true, delta);
                        DiscretizedFunc f1 = (DiscretizedFunc)histSpecs.get(histSpecs.keySet().iterator().next()).getPlotElems().get(0);
                        while (f1.size() < 5) {
                            histSpecs = hist.getStackedHistPlots(true, delta /= 2.0);
                            f1 = (DiscretizedFunc)histSpecs.get(histSpecs.keySet().iterator().next()).getPlotElems().get(0);
                        }
                        siteCSVs.put((Object)period, (Object)prob, hist.getStaticsticsCSV());
                        sitePlots.put((Object)period, (Object)prob, histSpecs);
                        hist = null;
                        System.gc();
                    }
                }
            }
            return results;
        }

        private static void validateCurve(DiscretizedFunc curve, String metadata) {
            Preconditions.checkState((curve.size() > 1 ? 1 : 0) != 0, (Object)("Hazard curve has too few points (" + curve.size() + ")! " + metadata));
            double sumY = 0.0;
            for (int i = 0; i < curve.size(); ++i) {
                Point2D pt = curve.get(i);
                if (!Doubles.isFinite((double)pt.getY())) {
                    throw new IllegalStateException("Non finite Y value at index " + i + ": " + String.valueOf(pt) + ". " + metadata);
                }
                if ((float)pt.getY() < 0.0f || (float)pt.getY() > 1.0f) {
                    throw new IllegalStateException("Y value not in range [0 1] at index " + i + ": " + String.valueOf(pt) + ". " + metadata);
                }
                if (i > 1 && (float)pt.getY() > (float)curve.getY(i - 1)) {
                    throw new IllegalStateException("Y value not monotonically decreasing at index " + i + ": " + String.valueOf(pt) + " > " + String.valueOf(curve.get(i - 1)) + ". " + metadata);
                }
                sumY += pt.getY();
                if (!Doubles.isFinite((double)pt.getX())) {
                    throw new IllegalStateException("Non finite X value at index " + i + ": " + String.valueOf(pt) + ". " + metadata);
                }
                if (!((float)pt.getY() < 0.0f)) continue;
                throw new IllegalStateException("X value < 0 at index " + i + ": " + String.valueOf(pt) + ". " + metadata);
            }
            Preconditions.checkState((sumY > 0.0 ? 1 : 0) != 0, (Object)("Hazard curve is all zeros! " + metadata));
        }

        @Override
        protected boolean usesERFs() {
            return true;
        }

        @Override
        protected boolean isApplyAftershockFilter() {
            return false;
        }

        @Override
        protected boolean isTimeDependent() {
            return true;
        }
    }

    private static class SiteHazardResults {
        private Map<Site, Table<Period, Double, Map<String, PlotSpec>>> plotsMap;
        private Map<Site, Table<Period, Double, CSVFile<String>>> csvsMap;

        private SiteHazardResults() {
        }
    }

    public static class ERFProbModelCalc
    extends CompoundFSSPlots {
        private static MagDependentAperiodicityOptions[] covs = new MagDependentAperiodicityOptions[]{MagDependentAperiodicityOptions.LOW_VALUES, MagDependentAperiodicityOptions.MID_VALUES, MagDependentAperiodicityOptions.HIGH_VALUES, null};
        private static final double[] durations = new double[]{30.0};
        private Table<Double, U3LogicTreeBranch, Map<MagDependentAperiodicityOptions, double[]>> probsTable = HashBasedTable.create();

        @Override
        protected void processSolution(U3LogicTreeBranch branch, InversionFaultSystemSolution sol, int solIndex) {
            throw new IllegalStateException("Should never be called, ERF plot");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void processERF(U3LogicTreeBranch branch, FaultSystemSolutionERF erf, int solIndex) {
            this.debug(solIndex, "processing ERF for " + branch.buildFileName());
            double origDuration = erf.getTimeSpan().getDuration();
            erf.setParameter("Background Seismicity", (Object)IncludeBackgroundOption.EXCLUDE);
            int numRups = erf.getSolution().getRupSet().getNumRuptures();
            for (double duration : durations) {
                HashMap covProbs = Maps.newHashMap();
                for (MagDependentAperiodicityOptions cov : covs) {
                    if (cov == null) {
                        erf.setParameter("Probability Model", (Object)ProbabilityModelOptions.POISSON);
                    } else {
                        erf.setParameter("Probability Model", (Object)ProbabilityModelOptions.U3_BPT);
                        erf.setParameter("Aperiodicity", (Object)cov);
                    }
                    erf.getTimeSpan().setDuration(duration);
                    this.debug(solIndex, "updating forecast for cov=" + String.valueOf((Object)cov));
                    erf.updateForecast();
                    this.debug(solIndex, "done updating forecast for cov=" + String.valueOf((Object)cov));
                    double[] probs = new double[numRups];
                    for (int rupID = 0; rupID < numRups; ++rupID) {
                        int sourceID = erf.getSrcIndexForFltSysRup(rupID);
                        if (sourceID < 0) continue;
                        ProbEqkSource source = erf.getSource(sourceID);
                        Preconditions.checkState((source.getNumRuptures() == 1 ? 1 : 0) != 0);
                        probs[rupID] = source.computeTotalProb();
                    }
                    covProbs.put(cov, probs);
                }
                ERFProbModelCalc object = this;
                synchronized (object) {
                    this.probsTable.put((Object)duration, (Object)branch, (Object)covProbs);
                }
            }
            erf.setParameter("Background Seismicity", (Object)IncludeBackgroundOption.INCLUDE);
            erf.getTimeSpan().setDuration(origDuration);
        }

        @Override
        protected void combineDistributedCalcs(Collection<CompoundFSSPlots> otherCalcs) {
            for (CompoundFSSPlots other : otherCalcs) {
                ERFProbModelCalc o = (ERFProbModelCalc)other;
                this.probsTable.putAll(o.probsTable);
            }
        }

        @Override
        protected void doFinalizePlot() {
        }

        @Override
        protected boolean usesERFs() {
            return true;
        }

        @Override
        protected boolean isApplyAftershockFilter() {
            return false;
        }

        @Override
        protected boolean isTimeDependent() {
            return true;
        }
    }

    public static class PaleoFaultPlot
    extends CompoundFSSPlots {
        private transient PaleoProbabilityModel paleoProbModel;
        private transient U3BranchWeightProvider weightProvider;
        private Map<FaultModels, Map<String, List<Integer>>> namedFaultsMaps = Maps.newHashMap();
        private Map<FaultModels, List<U3PaleoRateConstraint>> paleoConstraintMaps = Maps.newHashMap();
        private Map<FaultModels, List<U3AveSlipConstraint>> slipConstraintMaps = Maps.newHashMap();
        private Map<FaultModels, Map<Integer, List<FaultSection>>> allParentsMaps = Maps.newHashMap();
        private Map<FaultModels, List<? extends FaultSection>> fsdsMap = Maps.newHashMap();
        private Map<FaultModels, List<PaleoFitPlotter.DataForPaleoFaultPlots>> datasMap = Maps.newHashMap();
        private Map<FaultModels, List<List<Double>>> slipRatesMap = Maps.newHashMap();
        private Map<FaultModels, List<Double>> weightsMap = Maps.newHashMap();
        private Map<FaultModels, Map<String, PlotSpec[]>> plotsMap = Maps.newHashMap();

        public PaleoFaultPlot(U3BranchWeightProvider weightProvider) {
            this.weightProvider = weightProvider;
            try {
                this.paleoProbModel = UCERF3_PaleoProbabilityModel.load();
            }
            catch (IOException e) {
                ExceptionUtils.throwAsRuntimeException(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void processSolution(U3LogicTreeBranch branch, InversionFaultSystemSolution sol, int solIndex) {
            InversionFaultSystemRupSet rupSet = sol.getRupSet();
            FaultModels fm = rupSet.getFaultModel();
            try {
                this.debug(solIndex, "Preparing...");
                ArrayList<U3PaleoRateConstraint> paleoRateConstraints = this.paleoConstraintMaps.get(fm);
                if (paleoRateConstraints == null) {
                    PaleoFaultPlot paleoFaultPlot = this;
                    synchronized (paleoFaultPlot) {
                        paleoRateConstraints = this.paleoConstraintMaps.get(fm);
                        if (paleoRateConstraints == null) {
                            System.out.println("I'm in the synchronized block! " + String.valueOf(fm));
                            paleoRateConstraints = CommandLineInversionRunner.getPaleoConstraints(fm, rupSet);
                            this.slipConstraintMaps.put(fm, U3AveSlipConstraint.load(rupSet.getFaultSectionDataList()));
                            this.allParentsMaps.put(fm, PaleoFitPlotter.getAllParentsMap(rupSet.getFaultSectionDataList()));
                            this.namedFaultsMaps.put(fm, fm.getNamedFaultsMapAlt());
                            this.fsdsMap.put(fm, rupSet.getFaultSectionDataList());
                            this.paleoConstraintMaps.put(fm, paleoRateConstraints);
                        }
                    }
                }
                ArrayList slipsForConstraints = Lists.newArrayList();
                paleoRateConstraints = Lists.newArrayList(paleoRateConstraints);
                List<U3AveSlipConstraint> aveSlipConstraints = this.slipConstraintMaps.get(fm);
                for (U3AveSlipConstraint aveSlip : aveSlipConstraints) {
                    double slip = rupSet.getSlipRateForSection(aveSlip.getSubSectionIndex());
                    paleoRateConstraints.add(new PaleoFitPlotter.AveSlipFakePaleoConstraint(aveSlip, aveSlip.getSubSectionIndex(), slip));
                    slipsForConstraints.add(slip);
                }
                Map<String, List<Integer>> namedFaultsMap = this.namedFaultsMaps.get(fm);
                Map<String, List<U3PaleoRateConstraint>> namedFaultConstraintsMap = PaleoFitPlotter.getNamedFaultConstraintsMap(paleoRateConstraints, rupSet.getFaultSectionDataList(), namedFaultsMap);
                Map<Integer, List<FaultSection>> allParentsMap = this.allParentsMaps.get(fm);
                double weight = this.weightProvider.getWeight(branch);
                this.debug(solIndex, "Building...");
                PaleoFitPlotter.DataForPaleoFaultPlots data = PaleoFitPlotter.DataForPaleoFaultPlots.build(sol, namedFaultsMap, namedFaultConstraintsMap, allParentsMap, this.paleoProbModel, weight);
                this.debug(solIndex, "Archiving results...");
                PaleoFaultPlot paleoFaultPlot = this;
                synchronized (paleoFaultPlot) {
                    int i;
                    ArrayList datasList = this.datasMap.get(fm);
                    if (datasList == null) {
                        datasList = Lists.newArrayList();
                        this.datasMap.put(fm, datasList);
                    }
                    datasList.add(data);
                    ArrayList slipRates = this.slipRatesMap.get(fm);
                    if (slipRates == null) {
                        slipRates = Lists.newArrayList();
                        for (i = 0; i < slipsForConstraints.size(); ++i) {
                            slipRates.add(new ArrayList());
                        }
                        this.slipRatesMap.put(fm, slipRates);
                    }
                    Preconditions.checkState((slipRates.size() == slipsForConstraints.size() ? 1 : 0) != 0, (Object)"Slip rate sizes inconsistent!");
                    for (i = 0; i < slipsForConstraints.size(); ++i) {
                        ((List)slipRates.get(i)).add((Double)slipsForConstraints.get(i));
                    }
                    ArrayList weightsList = this.weightsMap.get(fm);
                    if (weightsList == null) {
                        weightsList = Lists.newArrayList();
                        this.weightsMap.put(fm, weightsList);
                    }
                    weightsList.add(weight);
                    this.debug(solIndex, "Done calculating data for " + fm.getShortName() + " #" + weightsList.size());
                }
            }
            catch (Exception e) {
                ExceptionUtils.throwAsRuntimeException(e);
            }
        }

        @Override
        protected void doFinalizePlot() {
            for (FaultModels fm : this.datasMap.keySet()) {
                List<U3AveSlipConstraint> aveSlips = this.slipConstraintMaps.get(fm);
                List<List<Double>> slipVals = this.slipRatesMap.get(fm);
                List<U3PaleoRateConstraint> paleoRateConstraints = this.paleoConstraintMaps.get(fm);
                double[] weights = Doubles.toArray((Collection)this.weightsMap.get(fm));
                for (int i = 0; i < aveSlips.size(); ++i) {
                    List<Double> slipList = slipVals.get(i);
                    double[] slipArray = Doubles.toArray(slipList);
                    Preconditions.checkState((slipArray.length == weights.length ? 1 : 0) != 0, (Object)(slipArray.length + " != " + weights.length));
                    U3AveSlipConstraint constr = aveSlips.get(i);
                    paleoRateConstraints.add(new PaleoFitPlotter.AveSlipFakePaleoConstraint(constr, constr.getSubSectionIndex(), slipArray, weights));
                }
                Map<String, List<Integer>> namedFaultsMap = this.namedFaultsMaps.get(fm);
                Map<String, List<U3PaleoRateConstraint>> namedFaultConstraintsMap = PaleoFitPlotter.getNamedFaultConstraintsMap(paleoRateConstraints, this.fsdsMap.get(fm), namedFaultsMap);
                List<PaleoFitPlotter.DataForPaleoFaultPlots> datas = this.datasMap.get(fm);
                Map<Integer, List<FaultSection>> allParentsMap = this.allParentsMaps.get(fm);
                Map<String, PlotSpec[]> specsMap = PaleoFitPlotter.getFaultSpecificPaleoPlotSpecs(namedFaultsMap, namedFaultConstraintsMap, datas, allParentsMap);
                this.plotsMap.put(fm, specsMap);
            }
        }

        @Override
        protected void combineDistributedCalcs(Collection<CompoundFSSPlots> otherCalcs) {
            for (CompoundFSSPlots otherCalc : otherCalcs) {
                PaleoFaultPlot o = (PaleoFaultPlot)otherCalc;
                for (FaultModels fm : o.allParentsMaps.keySet()) {
                    ArrayList datasList;
                    if (!this.allParentsMaps.containsKey(fm)) {
                        this.namedFaultsMaps.put(fm, o.namedFaultsMaps.get(fm));
                        this.paleoConstraintMaps.put(fm, o.paleoConstraintMaps.get(fm));
                        this.slipConstraintMaps.put(fm, o.slipConstraintMaps.get(fm));
                        this.allParentsMaps.put(fm, o.allParentsMaps.get(fm));
                        this.fsdsMap.put(fm, o.fsdsMap.get(fm));
                    }
                    if ((datasList = this.datasMap.get(fm)) == null) {
                        datasList = Lists.newArrayList();
                        this.datasMap.put(fm, datasList);
                    }
                    datasList.addAll((Collection)o.datasMap.get(fm));
                    ArrayList slipRatesList = this.slipRatesMap.get(fm);
                    if (slipRatesList == null) {
                        List<U3AveSlipConstraint> slipConstraints = this.slipConstraintMaps.get(fm);
                        slipRatesList = Lists.newArrayList();
                        for (int i = 0; i < slipConstraints.size(); ++i) {
                            slipRatesList.add(new ArrayList());
                        }
                        this.slipRatesMap.put(fm, slipRatesList);
                    }
                    for (int i = 0; i < slipRatesList.size(); ++i) {
                        ((List)slipRatesList.get(i)).addAll((Collection)o.slipRatesMap.get(fm).get(i));
                    }
                    ArrayList weightsList = this.weightsMap.get(fm);
                    if (weightsList == null) {
                        weightsList = Lists.newArrayList();
                        this.weightsMap.put(fm, weightsList);
                    }
                    weightsList.addAll((Collection)o.weightsMap.get(fm));
                }
            }
        }

        protected Map<FaultModels, Map<String, PlotSpec[]>> getPlotsMap() {
            return this.plotsMap;
        }
    }

    public static class PaleoSiteCorrelationPlot
    extends CompoundFSSPlots {
        private transient PaleoProbabilityModel paleoProbModel;
        private transient U3BranchWeightProvider weightProvider;
        private Map<FaultModels, Map<String, List<PaleoSiteCorrelationData>>> corrsListsMap = Maps.newHashMap();
        private List<Map<String, double[]>> data = Lists.newArrayList();
        private List<Double> weights = Lists.newArrayList();
        private Map<String, PlotSpec> plotsMap = Maps.newHashMap();

        public PaleoSiteCorrelationPlot(U3BranchWeightProvider weightProvider) {
            this.weightProvider = weightProvider;
            try {
                this.paleoProbModel = UCERF3_PaleoProbabilityModel.load();
            }
            catch (IOException e) {
                ExceptionUtils.throwAsRuntimeException(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void processSolution(U3LogicTreeBranch branch, InversionFaultSystemSolution sol, int solIndex) {
            FaultModels fm = sol.getRupSet().getFaultModel();
            try {
                this.debug(solIndex, "Preparing...");
                HashMap corrs = this.corrsListsMap.get(fm);
                if (corrs == null) {
                    FaultModels faultModels = fm;
                    synchronized (faultModels) {
                        corrs = this.corrsListsMap.get(fm);
                        if (corrs == null) {
                            this.debug(solIndex, "I'm in the synchronized block! " + String.valueOf(fm));
                            corrs = Maps.newHashMap();
                            Map<String, Table<String, String, PaleoSiteCorrelationData>> table = PaleoSiteCorrelationData.loadPaleoCorrelationData(sol);
                            for (String faultName : table.keySet()) {
                                List<PaleoSiteCorrelationData> corrsToPlot = PaleoSiteCorrelationData.getCorrelataionsToPlot(table.get(faultName));
                                corrs.put(faultName, corrsToPlot);
                            }
                            this.corrsListsMap.put(fm, corrs);
                        }
                    }
                }
                double weight = this.weightProvider.getWeight(branch);
                HashMap myData = Maps.newHashMap();
                this.debug(solIndex, "Building...");
                for (String faultName : corrs.keySet()) {
                    List corrsToPlot = (List)corrs.get(faultName);
                    double[] vals = new double[corrsToPlot.size()];
                    for (int i = 0; i < vals.length; ++i) {
                        PaleoSiteCorrelationData corr = (PaleoSiteCorrelationData)corrsToPlot.get(i);
                        vals[i] = PaleoSiteCorrelationData.getRateCorrelated(this.paleoProbModel, sol, corr.getSite1SubSect(), corr.getSite2SubSect());
                    }
                    myData.put(faultName, vals);
                }
                this.debug(solIndex, "Archiving results...");
                PaleoSiteCorrelationPlot paleoSiteCorrelationPlot = this;
                synchronized (paleoSiteCorrelationPlot) {
                    this.data.add(myData);
                    this.weights.add(weight);
                }
            }
            catch (Exception e) {
                ExceptionUtils.throwAsRuntimeException(e);
            }
        }

        @Override
        protected void combineDistributedCalcs(Collection<CompoundFSSPlots> otherCalcs) {
            for (CompoundFSSPlots otherCalc : otherCalcs) {
                PaleoSiteCorrelationPlot o = (PaleoSiteCorrelationPlot)otherCalc;
                this.data.addAll(o.data);
                this.weights.addAll(o.weights);
                for (FaultModels fm : o.corrsListsMap.keySet()) {
                    if (this.corrsListsMap.containsKey(fm)) continue;
                    this.corrsListsMap.put(fm, o.corrsListsMap.get(fm));
                }
            }
        }

        @Override
        protected void doFinalizePlot() {
            HashMap allCorrsMap = Maps.newHashMap();
            for (FaultModels fm : this.corrsListsMap.keySet()) {
                Map<String, List<PaleoSiteCorrelationData>> corrsForFM = this.corrsListsMap.get(fm);
                for (String faultName : corrsForFM.keySet()) {
                    if (allCorrsMap.containsKey(faultName)) continue;
                    allCorrsMap.put(faultName, corrsForFM.get(faultName));
                }
            }
            for (String faultName : allCorrsMap.keySet()) {
                ArrayList solValsForFault = Lists.newArrayList();
                ArrayList weightsForFault = Lists.newArrayList();
                for (int s = 0; s < this.data.size(); ++s) {
                    double[] solData = this.data.get(s).get(faultName);
                    if (solData == null) continue;
                    solValsForFault.add(solData);
                    weightsForFault.add(this.weights.get(s));
                }
                List corrs = (List)allCorrsMap.get(faultName);
                ArrayList solValues = Lists.newArrayList();
                double[] weights = Doubles.toArray((Collection)weightsForFault);
                for (int i = 0; i < corrs.size(); ++i) {
                    double[] vals = new double[solValsForFault.size()];
                    for (int s = 0; s < solValsForFault.size(); ++s) {
                        vals[s] = ((double[])solValsForFault.get(s))[i];
                    }
                    double min = StatUtils.min((double[])vals);
                    double max = StatUtils.max((double[])vals);
                    double mean = U3FaultSystemSolutionFetcher.calcScaledAverage(vals, weights);
                    double[] ret = new double[]{min, max, mean};
                    System.out.println("Vals for " + faultName + " CORR " + i + ": " + min + "," + max + "," + mean + " (" + vals.length + " sols)");
                    solValues.add(ret);
                }
                PlotSpec spec = PaleoSiteCorrelationData.getCorrelationPlotSpec(faultName, corrs, solValues, this.paleoProbModel);
                this.plotsMap.put(faultName, spec);
            }
        }

        public Map<String, PlotSpec> getPlotsMap() {
            return this.plotsMap;
        }
    }

    public static class ParentSectMFDsPlot
    extends CompoundFSSPlots {
        private transient U3BranchWeightProvider weightProvider;
        private double[] fractiles;
        private ConcurrentMap<FaultModels, HashSet<Integer>> parentMapsCache = Maps.newConcurrentMap();
        private Map<Integer, XY_DataSetList> nuclIncrMFDs = Maps.newHashMap();
        private Map<Integer, XY_DataSetList> nuclSubSeismoMFDs = Maps.newHashMap();
        private Map<Integer, XY_DataSetList> partIncrMFDs = Maps.newHashMap();
        private Map<Integer, List<Double>> weightsMap = Maps.newHashMap();
        private ConcurrentMap<Integer, String> namesMap = Maps.newConcurrentMap();
        private static final double minX = 5.05;
        private static final double maxX = 9.05;
        private static final double delta = 0.1;
        private static final int num = 41;
        private Map<Integer, List<IncrementalMagFreqDist>> plotNuclIncrMFDs = Maps.newHashMap();
        private Map<Integer, List<IncrementalMagFreqDist>> plotSubSeismoIncrMFDs = Maps.newHashMap();
        private Map<Integer, List<EvenlyDiscretizedFunc>> plotSubSeismoCmlMFDs = Maps.newHashMap();
        private Map<Integer, List<IncrementalMagFreqDist>> plotSubPlusSupraSeismoNuclMFDs = Maps.newHashMap();
        private Map<Integer, List<EvenlyDiscretizedFunc>> plotSubPlusSupraSeismoNuclCmlMFDs = Maps.newHashMap();
        private Map<Integer, List<IncrementalMagFreqDist>> plotSubPlusSupraSeismoParticMFDs = Maps.newHashMap();
        private Map<Integer, List<EvenlyDiscretizedFunc>> plotSubPlusSupraSeismoParticCmlMFDs = Maps.newHashMap();
        private Map<Integer, List<IncrementalMagFreqDist>> plotPartIncrMFDs = Maps.newHashMap();
        private Map<Integer, List<EvenlyDiscretizedFunc>> plotNuclCmlMFDs = Maps.newHashMap();
        private Map<Integer, List<EvenlyDiscretizedFunc>> plotPartCmlMFDs = Maps.newHashMap();

        private static double[] getDefaultFractiles() {
            double[] ret = new double[]{};
            return ret;
        }

        public ParentSectMFDsPlot(U3BranchWeightProvider weightProvider) {
            this(weightProvider, ParentSectMFDsPlot.getDefaultFractiles());
        }

        public ParentSectMFDsPlot(U3BranchWeightProvider weightProvider, double[] fractiles) {
            this.weightProvider = weightProvider;
            this.fractiles = fractiles;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void processSolution(U3LogicTreeBranch branch, InversionFaultSystemSolution sol, int solIndex) {
            InversionFaultSystemRupSet rupSet = sol.getRupSet();
            FaultModels fm = rupSet.getFaultModel();
            this.debug(solIndex, "cache fetching");
            HashSet<Integer> parentIDs = (HashSet<Integer>)this.parentMapsCache.get(fm);
            if (parentIDs == null) {
                parentIDs = new HashSet<Integer>();
                for (int sectIndex = 0; sectIndex < rupSet.getNumSections(); ++sectIndex) {
                    FaultSection sect = rupSet.getFaultSectionData(sectIndex);
                    Integer parentID = sect.getParentSectionId();
                    if (parentIDs.contains(parentID)) continue;
                    parentIDs.add(parentID);
                    this.namesMap.putIfAbsent(parentID, sect.getParentSectionName());
                }
                this.parentMapsCache.putIfAbsent(fm, parentIDs);
            }
            double weight = this.weightProvider.getWeight(branch);
            this.debug(solIndex, "calculating");
            for (Integer parentID : parentIDs) {
                SummedMagFreqDist nuclMFD = sol.calcNucleationMFD_forParentSect(parentID, 5.05, 9.05, 41);
                SummedMagFreqDist nuclSubSeismoMFD = sol.getFinalSubSeismoOnFaultMFDForParent(parentID);
                IncrementalMagFreqDist partMFD = sol.calcParticipationMFD_forParentSect(parentID, 5.05, 9.05, 41);
                ParentSectMFDsPlot parentSectMFDsPlot = this;
                synchronized (parentSectMFDsPlot) {
                    if (!this.nuclIncrMFDs.containsKey(parentID)) {
                        this.nuclIncrMFDs.put(parentID, new XY_DataSetList());
                        this.nuclSubSeismoMFDs.put(parentID, new XY_DataSetList());
                        this.partIncrMFDs.put(parentID, new XY_DataSetList());
                        this.weightsMap.put(parentID, new ArrayList());
                    }
                    this.nuclIncrMFDs.get(parentID).add(nuclMFD);
                    this.nuclSubSeismoMFDs.get(parentID).add(nuclSubSeismoMFD);
                    this.partIncrMFDs.get(parentID).add(partMFD);
                    this.weightsMap.get(parentID).add(weight);
                }
            }
            this.debug(solIndex, "done");
        }

        @Override
        protected void combineDistributedCalcs(Collection<CompoundFSSPlots> otherCalcs) {
            for (CompoundFSSPlots otherCalc : otherCalcs) {
                ParentSectMFDsPlot o = (ParentSectMFDsPlot)otherCalc;
                for (Integer parentID : o.nuclIncrMFDs.keySet()) {
                    if (!this.nuclIncrMFDs.containsKey(parentID)) {
                        this.nuclIncrMFDs.put(parentID, new XY_DataSetList());
                        this.nuclSubSeismoMFDs.put(parentID, new XY_DataSetList());
                        this.partIncrMFDs.put(parentID, new XY_DataSetList());
                        this.weightsMap.put(parentID, new ArrayList());
                    }
                    this.nuclIncrMFDs.get(parentID).addAll(o.nuclIncrMFDs.get(parentID));
                    this.nuclSubSeismoMFDs.get(parentID).addAll(o.nuclSubSeismoMFDs.get(parentID));
                    this.partIncrMFDs.get(parentID).addAll(o.partIncrMFDs.get(parentID));
                    this.weightsMap.get(parentID).addAll((Collection<Double>)o.weightsMap.get(parentID));
                    if (this.namesMap.containsKey(parentID)) continue;
                    this.namesMap.put(parentID, (String)o.namesMap.get(parentID));
                }
            }
        }

        @Override
        protected void doFinalizePlot() {
            for (Integer parentID : this.nuclIncrMFDs.keySet()) {
                this.plotNuclIncrMFDs.put(parentID, ParentSectMFDsPlot.asIncr(ParentSectMFDsPlot.getFractiles(this.nuclIncrMFDs.get(parentID), this.weightsMap.get(parentID), "Incremental Nucleation MFD", this.fractiles)));
                this.plotNuclCmlMFDs.put(parentID, ParentSectMFDsPlot.asEvenly(ParentSectMFDsPlot.getFractiles(ParentSectMFDsPlot.asCml(this.nuclIncrMFDs.get(parentID)), this.weightsMap.get(parentID), "Cumulative Nucleation MFD", new double[0])));
                this.plotPartIncrMFDs.put(parentID, ParentSectMFDsPlot.asIncr(ParentSectMFDsPlot.getFractiles(this.partIncrMFDs.get(parentID), this.weightsMap.get(parentID), "Incremental Participation MFD", this.fractiles)));
                this.plotPartCmlMFDs.put(parentID, ParentSectMFDsPlot.asEvenly(ParentSectMFDsPlot.getFractiles(ParentSectMFDsPlot.asCml(this.partIncrMFDs.get(parentID)), this.weightsMap.get(parentID), "Cumulative Participation MFD", new double[0])));
                this.plotSubSeismoIncrMFDs.put(parentID, ParentSectMFDsPlot.asIncr(ParentSectMFDsPlot.getFractiles(this.nuclSubSeismoMFDs.get(parentID), this.weightsMap.get(parentID), "Incremental Sub Seismogenic Nucleation MFD", this.fractiles)));
                this.plotSubSeismoCmlMFDs.put(parentID, ParentSectMFDsPlot.asEvenly(ParentSectMFDsPlot.getFractiles(ParentSectMFDsPlot.asCml(this.nuclSubSeismoMFDs.get(parentID)), this.weightsMap.get(parentID), "Cumulative Sub Seismogenic Nucleation MFD", this.fractiles)));
                XY_DataSetList subPlusSupraNuclMFDs = this.getSummed(this.nuclSubSeismoMFDs.get(parentID), this.nuclIncrMFDs.get(parentID));
                XY_DataSetList subPlusSupraParticMFDs = this.getSummed(this.nuclSubSeismoMFDs.get(parentID), this.partIncrMFDs.get(parentID));
                this.plotSubPlusSupraSeismoNuclMFDs.put(parentID, ParentSectMFDsPlot.asIncr(ParentSectMFDsPlot.getFractiles(subPlusSupraNuclMFDs, this.weightsMap.get(parentID), "Incremental Sub+Supra Seismogenic Nucleation MFD", this.fractiles)));
                this.plotSubPlusSupraSeismoNuclCmlMFDs.put(parentID, ParentSectMFDsPlot.asEvenly(ParentSectMFDsPlot.getFractiles(ParentSectMFDsPlot.asCml(subPlusSupraNuclMFDs), this.weightsMap.get(parentID), "Cumulative Sub+Supra Seismogenic Nucleation MFD", new double[0])));
                this.plotSubPlusSupraSeismoParticMFDs.put(parentID, ParentSectMFDsPlot.asIncr(ParentSectMFDsPlot.getFractiles(subPlusSupraParticMFDs, this.weightsMap.get(parentID), "Incremental Sub+Supra Seismogenic Participation MFD", this.fractiles)));
                this.plotSubPlusSupraSeismoParticCmlMFDs.put(parentID, ParentSectMFDsPlot.asEvenly(ParentSectMFDsPlot.getFractiles(ParentSectMFDsPlot.asCml(subPlusSupraParticMFDs), this.weightsMap.get(parentID), "Cumulative Sub+Supra Seismogenic Participation MFD", new double[0])));
            }
        }

        private static XY_DataSetList asCml(XY_DataSetList xyList) {
            XY_DataSetList cmlList = new XY_DataSetList();
            for (XY_DataSet xy : xyList) {
                cmlList.add(((IncrementalMagFreqDist)xy).getCumRateDistWithOffset());
            }
            return cmlList;
        }

        private static List<IncrementalMagFreqDist> asIncr(List<DiscretizedFunc> funcs) {
            ArrayList incrMFDs = Lists.newArrayList();
            for (DiscretizedFunc func : funcs) {
                incrMFDs.add((IncrementalMagFreqDist)func);
            }
            return incrMFDs;
        }

        private static List<EvenlyDiscretizedFunc> asEvenly(List<DiscretizedFunc> funcs) {
            ArrayList incrMFDs = Lists.newArrayList();
            for (DiscretizedFunc func : funcs) {
                incrMFDs.add((EvenlyDiscretizedFunc)func);
            }
            return incrMFDs;
        }

        private XY_DataSetList getSummed(XY_DataSetList list1, XY_DataSetList list2) {
            XY_DataSetList sumList = new XY_DataSetList();
            for (int i = 0; i < list1.size(); ++i) {
                IncrementalMagFreqDist mfd1 = (IncrementalMagFreqDist)list1.get(i);
                IncrementalMagFreqDist mfd2 = (IncrementalMagFreqDist)list2.get(i);
                SummedMagFreqDist sum = new SummedMagFreqDist(0.05, 90, 0.1);
                sum.addIncrementalMagFreqDist(ParentSectMFDsPlot.resizeToDimensions(mfd1, 0.05, 90, 0.1));
                sum.addIncrementalMagFreqDist(ParentSectMFDsPlot.resizeToDimensions(mfd2, 0.05, 90, 0.1));
                sumList.add(sum);
            }
            return sumList;
        }

        private static IncrementalMagFreqDist resizeToDimensions(IncrementalMagFreqDist mfd, double min, int num, double delta) {
            if (mfd.getMinX() == min && mfd.size() == num && mfd.getDelta() == delta) {
                return mfd;
            }
            IncrementalMagFreqDist resized = new IncrementalMagFreqDist(min, num, delta);
            for (int i = 0; i < mfd.size(); ++i) {
                if (!(mfd.getY(i) > 0.0)) continue;
                resized.set(mfd.get(i));
            }
            return resized;
        }

        public void addAsComparison(Integer parentID, IncrementalMagFreqDist nuclIncrMFD, EvenlyDiscretizedFunc nuclCmlMFD, IncrementalMagFreqDist partIncrMFD, EvenlyDiscretizedFunc partCmlMFD) {
            nuclIncrMFD.setName(nuclIncrMFD.getName() + " (COMPARISON!)");
            Preconditions.checkState((nuclIncrMFD.getMaxY() > 0.0 ? 1 : 0) != 0);
            nuclCmlMFD.setName(nuclCmlMFD.getName() + " (COMPARISON!)");
            partIncrMFD.setName(partIncrMFD.getName() + " (COMPARISON!)");
            partCmlMFD.setName(partCmlMFD.getName() + " (COMPARISON!)");
            this.plotNuclIncrMFDs.get(parentID).add(0, nuclIncrMFD);
            this.plotNuclCmlMFDs.get(parentID).add(0, nuclCmlMFD);
            this.plotPartIncrMFDs.get(parentID).add(0, partIncrMFD);
            this.plotPartCmlMFDs.get(parentID).add(0, partCmlMFD);
        }

        public void addMeanFromExternalAsFractile(ParentSectMFDsPlot other) {
            for (Integer parentID : other.plotNuclIncrMFDs.keySet()) {
                if (!this.plotNuclCmlMFDs.containsKey(parentID)) continue;
                this.addAsComparison(parentID, other.plotNuclIncrMFDs.get(parentID).get(0), other.plotNuclCmlMFDs.get(parentID).get(0), other.plotPartIncrMFDs.get(parentID).get(0), other.plotPartCmlMFDs.get(parentID).get(0));
            }
        }
    }

    public static class RupJumpPlot
    extends CompoundFSSPlots {
        private static final long serialVersionUID = 1L;
        private double[] minMags = new double[]{7.0, 0.0};
        private boolean[] paleoProbs = new boolean[]{false, true};
        private double[] fractiles;
        private static final double jumpDist = 1.0;
        private transient U3BranchWeightProvider weightProvider;
        private transient PaleoProbabilityModel paleoProbModel;
        private transient ConcurrentMap<FaultModels, Map<IDPairing, Double>> distancesCache = Maps.newConcurrentMap();
        private List<XY_DataSetList> solFuncs = Lists.newArrayList();
        private List<XY_DataSetList> rupSetFuncs = Lists.newArrayList();
        private List<Double> weights = Lists.newArrayList();
        private List<DiscretizedFunc[]> plotSolFuncs = Lists.newArrayList();
        private List<DiscretizedFunc[]> plotRupSetFuncs = Lists.newArrayList();

        public RupJumpPlot(U3BranchWeightProvider weightProvider) {
            this(weightProvider, new double[0]);
        }

        public RupJumpPlot(U3BranchWeightProvider weightProvider, double[] fractiles) {
            this.weightProvider = weightProvider;
            this.fractiles = fractiles;
            try {
                this.paleoProbModel = UCERF3_PaleoProbabilityModel.load();
            }
            catch (IOException e) {
                ExceptionUtils.throwAsRuntimeException(e);
            }
            for (int i = 0; i < this.minMags.length; ++i) {
                this.solFuncs.add(new XY_DataSetList());
                this.rupSetFuncs.add(new XY_DataSetList());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void processSolution(U3LogicTreeBranch branch, InversionFaultSystemSolution sol, int solIndex) {
            FaultModels fm = sol.getRupSet().getFaultModel();
            Map<IDPairing, Double> distances = (Map<IDPairing, Double>)this.distancesCache.get(fm);
            this.debug(solIndex, "cache fetching");
            if (distances == null) {
                RupJumpPlot rupJumpPlot = this;
                synchronized (rupJumpPlot) {
                    distances = (Map)this.distancesCache.get(fm);
                    if (distances == null) {
                        distances = DeformationModelFetcher.calculateDistances(5.0, sol.getRupSet().getFaultSectionDataList());
                        for (IDPairing pairing : Lists.newArrayList(distances.keySet())) {
                            distances.put(pairing.getReversed(), distances.get(pairing));
                        }
                        this.distancesCache.putIfAbsent(fm, distances);
                    }
                }
            }
            double weight = this.weightProvider.getWeight(branch);
            this.debug(solIndex, "calculating");
            ArrayList myFuncs = Lists.newArrayList();
            for (int i = 0; i < this.minMags.length; ++i) {
                EvenlyDiscretizedFunc[] funcs = CommandLineInversionRunner.getJumpFuncs(sol, distances, 1.0, this.minMags[i], this.paleoProbModel);
                myFuncs.add(funcs);
            }
            this.debug(solIndex, "archiving");
            RupJumpPlot rupJumpPlot = this;
            synchronized (rupJumpPlot) {
                for (int i = 0; i < myFuncs.size(); ++i) {
                    EvenlyDiscretizedFunc[] funcs = (EvenlyDiscretizedFunc[])myFuncs.get(i);
                    this.solFuncs.get(i).add(funcs[0]);
                    this.rupSetFuncs.get(i).add(funcs[1]);
                }
                this.weights.add(weight);
            }
            this.debug(solIndex, "done");
        }

        @Override
        protected void combineDistributedCalcs(Collection<CompoundFSSPlots> otherCalcs) {
            for (CompoundFSSPlots otherCalc : otherCalcs) {
                RupJumpPlot o = (RupJumpPlot)otherCalc;
                for (int i = 0; i < this.minMags.length; ++i) {
                    this.solFuncs.get(i).addAll(o.solFuncs.get(i));
                    this.rupSetFuncs.get(i).addAll(o.rupSetFuncs.get(i));
                }
                this.weights.addAll(o.weights);
            }
        }

        private static DiscretizedFunc[] toArray(List<DiscretizedFunc> funcs) {
            DiscretizedFunc[] array = new DiscretizedFunc[funcs.size()];
            for (int i = 0; i < funcs.size(); ++i) {
                array[i] = funcs.get(i);
            }
            return array;
        }

        @Override
        protected void doFinalizePlot() {
            for (int i = 0; i < this.solFuncs.size(); ++i) {
                List<DiscretizedFunc> solFractiles = RupJumpPlot.getFractiles(this.solFuncs.get(i), this.weights, "Solution Jumps", this.fractiles);
                List<DiscretizedFunc> rupSetFractiles = RupJumpPlot.getFractiles(this.rupSetFuncs.get(i), this.weights, "Rup Set Jumps", this.fractiles);
                this.plotSolFuncs.add(RupJumpPlot.toArray(solFractiles));
                this.plotRupSetFuncs.add(RupJumpPlot.toArray(rupSetFractiles));
            }
        }
    }

    public static class SubSectRITable
    extends CompoundFSSPlots {
        private double[] minMags = new double[]{0.0, 7.0};
        private double[] fractiles = new double[]{0.025, 0.16, 0.84, 0.975};
        private transient U3BranchWeightProvider weightProvider;
        private Table<FaultModels, Double, List<double[]>> results;
        private Map<FaultModels, List<EvenlyDiscretizedFunc[]>> mfdResults;
        private Map<FaultModels, List<Double>> weights;
        private Map<FaultModels, List<? extends FaultSection>> fmSectsMap;
        private Table<FaultModels, Double, CSVFile<String>> csvTable;
        private Map<FaultModels, CSVFile<String>> mfdCSVs;
        private static final double minX = 6.05;
        private static final double maxX = 9.05;
        private static final double delta = 0.1;
        private static final int num = 31;

        public SubSectRITable(U3BranchWeightProvider weightProvider) {
            this.weightProvider = weightProvider;
            this.results = HashBasedTable.create();
            this.mfdResults = Maps.newHashMap();
            this.weights = Maps.newHashMap();
            this.fmSectsMap = Maps.newHashMap();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void processSolution(U3LogicTreeBranch branch, InversionFaultSystemSolution sol, int solIndex) {
            FaultModels fm = branch.getValue(FaultModels.class);
            Table<FaultModels, Double, List<double[]>> table = this.results;
            synchronized (table) {
                if (!this.results.containsRow((Object)fm)) {
                    for (double minMag : this.minMags) {
                        this.results.put((Object)fm, (Object)minMag, new ArrayList());
                    }
                    this.mfdResults.put(fm, new ArrayList());
                    this.weights.put(fm, new ArrayList());
                    this.fmSectsMap.put(fm, sol.getRupSet().getFaultSectionDataList());
                }
            }
            ArrayList myRIs = Lists.newArrayList();
            for (double minMag : this.minMags) {
                double[] rates = sol.calcParticRateForAllSects(minMag, Double.POSITIVE_INFINITY);
                double[] ris = new double[rates.length];
                for (int i = 0; i < rates.length; ++i) {
                    ris[i] = 1.0 / rates[i];
                }
                myRIs.add(ris);
            }
            EvenlyDiscretizedFunc[] mfds = new EvenlyDiscretizedFunc[sol.getRupSet().getNumSections()];
            for (int s = 0; s < mfds.length; ++s) {
                IncrementalMagFreqDist mfd = sol.calcParticipationMFD_forSect(s, 6.05, 9.05, 31);
                mfds[s] = mfd.getCumRateDistWithOffset();
            }
            Table<FaultModels, Double, List<double[]>> table2 = this.results;
            synchronized (table2) {
                for (int i = 0; i < this.minMags.length; ++i) {
                    double minMag;
                    minMag = this.minMags[i];
                    ((List)this.results.get((Object)fm, (Object)minMag)).add((double[])myRIs.get(i));
                }
                this.mfdResults.get(fm).add(mfds);
                this.weights.get(fm).add(this.weightProvider.getWeight(branch));
            }
        }

        @Override
        protected void combineDistributedCalcs(Collection<CompoundFSSPlots> otherCalcs) {
            for (CompoundFSSPlots otherCalc : otherCalcs) {
                SubSectRITable o = (SubSectRITable)otherCalc;
                for (FaultModels fm : o.results.rowKeySet()) {
                    if (!this.results.containsRow((Object)fm)) {
                        for (double minMag : this.minMags) {
                            this.results.put((Object)fm, (Object)minMag, new ArrayList());
                        }
                        this.mfdResults.put(fm, new ArrayList());
                        this.weights.put(fm, new ArrayList());
                        this.fmSectsMap.put(fm, o.fmSectsMap.get(fm));
                    }
                    for (double minMag : this.minMags) {
                        ((List)this.results.get((Object)fm, (Object)minMag)).addAll((Collection)o.results.get((Object)fm, (Object)minMag));
                    }
                    this.mfdResults.get(fm).addAll((Collection<EvenlyDiscretizedFunc[]>)o.mfdResults.get(fm));
                    this.weights.get(fm).addAll((Collection<Double>)o.weights.get(fm));
                }
            }
        }

        @Override
        protected void doFinalizePlot() {
            this.csvTable = HashBasedTable.create();
            this.mfdCSVs = Maps.newHashMap();
            for (FaultModels fm : this.results.rowKeySet()) {
                List<? extends FaultSection> subSects;
                Map fmResults = this.results.row((Object)fm);
                List<Double> fmWeights = this.weights.get(fm);
                int numSects = ((double[])((List)fmResults.get(this.minMags[0])).get(0)).length;
                Preconditions.checkState((numSects == (subSects = this.fmSectsMap.get(fm)).size() ? 1 : 0) != 0);
                for (double minMag : this.minMags) {
                    List ris = (List)fmResults.get(minMag);
                    Preconditions.checkState((ris.size() == fmWeights.size() ? 1 : 0) != 0, (String)"Size mismatch. %s results, %s weights", (int)fmResults.size(), (int)fmWeights.size());
                    CSVFile csv = new CSVFile(true);
                    this.csvTable.put((Object)fm, (Object)minMag, csv);
                    ArrayList header = Lists.newArrayList((Object[])new String[]{"Subsection Index", "Parent Section ID", "Subsection Name", "Mean RI", "Min RI", "Max RI", "Std. Dev"});
                    for (double fractile : this.fractiles) {
                        float p = (float)(fractile * 100.0);
                        header.add("p" + p);
                    }
                    csv.addLine(header);
                    for (int s = 0; s < numSects; ++s) {
                        ArbDiscrEmpiricalDistFunc dist = new ArbDiscrEmpiricalDistFunc();
                        for (int i = 0; i < ris.size(); ++i) {
                            dist.set(((double[])ris.get(i))[s], (double)fmWeights.get(i));
                        }
                        FaultSection sect = subSects.get(s);
                        ArrayList line = Lists.newArrayList((Object[])new String[]{"" + sect.getSectionId(), "" + sect.getParentSectionId(), sect.getSectionName()});
                        line.add("" + dist.getMean());
                        line.add("" + dist.getMinX());
                        line.add("" + dist.getMaxX());
                        line.add("" + dist.getStdDev());
                        for (double fractile : this.fractiles) {
                            line.add("" + dist.getDiscreteFractile(fractile));
                        }
                        csv.addLine(line);
                    }
                }
                CSVFile csv = new CSVFile(true);
                ArrayList header = Lists.newArrayList((Object[])new String[]{"Subsection Index", "Parent Section ID", "Subsection Name"});
                List<EvenlyDiscretizedFunc[]> solMFDs = this.mfdResults.get(fm);
                EvenlyDiscretizedFunc testFunc = solMFDs.get(0)[0];
                for (int i = 0; i < testFunc.size(); ++i) {
                    header.add("" + (float)testFunc.getX(i));
                }
                csv.addLine(header);
                for (int s = 0; s < subSects.size(); ++s) {
                    XY_DataSetList sectMFDs = new XY_DataSetList();
                    for (int i = 0; i < solMFDs.size(); ++i) {
                        sectMFDs.add(solMFDs.get(i)[s]);
                    }
                    DiscretizedFunc meanMFD = SubSectRITable.getFractiles(sectMFDs, fmWeights, "", new double[0]).get(0);
                    FaultSection sect = subSects.get(s);
                    ArrayList line = Lists.newArrayList((Object[])new String[]{"" + sect.getSectionId(), "" + sect.getParentSectionId(), sect.getSectionName()});
                    for (int i = 0; i < meanMFD.size(); ++i) {
                        line.add("" + meanMFD.getY(i));
                    }
                    csv.addLine(line);
                }
                this.mfdCSVs.put(fm, csv);
            }
        }
    }

    public static class MiniSectRIPlot
    extends CompoundFSSPlots {
        private static final long serialVersionUID = 1L;
        private double[] minMags = new double[]{6.7};
        private transient U3BranchWeightProvider weightProvider;
        private transient ConcurrentMap<FaultModels, Map<Integer, List<List<Integer>>>> fmMappingsMap = Maps.newConcurrentMap();
        private Map<FaultModels, List<List<Map<Integer, List<Double>>>>> solRatesMap = Maps.newHashMap();
        private Map<FaultModels, List<Double>> weightsMap = Maps.newHashMap();
        private Map<FaultModels, List<Map<Integer, List<Double>>>> avgRatesMap = Maps.newHashMap();
        private transient Map<FaultModels, Map<Integer, DeformationModelFileParser.DeformationSection>> fmDMsMap = Maps.newHashMap();

        public MiniSectRIPlot(U3BranchWeightProvider weightProvider) {
            this.weightProvider = weightProvider;
        }

        private synchronized Map<Integer, DeformationModelFileParser.DeformationSection> loadDM(FaultModels fm) {
            Map<Integer, DeformationModelFileParser.DeformationSection> dm = this.fmDMsMap.get(fm);
            if (dm == null) {
                try {
                    dm = DeformationModelFileParser.load(DeformationModels.GEOLOGIC.getDataFileURL(fm));
                }
                catch (IOException e) {
                    ExceptionUtils.throwAsRuntimeException(e);
                }
                this.fmDMsMap.put(fm, dm);
                ArrayList solRates = Lists.newArrayList();
                for (int i = 0; i < this.minMags.length; ++i) {
                    solRates.add(new ArrayList());
                }
                ArrayList weights = Lists.newArrayList();
                this.solRatesMap.put(fm, solRates);
                this.weightsMap.put(fm, weights);
            }
            return dm;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void processSolution(U3LogicTreeBranch branch, InversionFaultSystemSolution sol, int solIndex) {
            FaultModels fm = sol.getRupSet().getFaultModel();
            Map<Integer, DeformationModelFileParser.DeformationSection> dm = this.loadDM(fm);
            this.debug(solIndex, "cache fetching");
            Map<Integer, List<List<Integer>>> mappings = (Map<Integer, List<List<Integer>>>)this.fmMappingsMap.get(fm);
            if (mappings == null) {
                MiniSectRIPlot miniSectRIPlot = this;
                synchronized (miniSectRIPlot) {
                    mappings = (Map)this.fmMappingsMap.get(fm);
                    if (mappings == null) {
                        mappings = MiniSectRecurrenceGen.buildSubSectMappings(dm, sol.getRupSet().getFaultSectionDataList());
                        this.fmMappingsMap.putIfAbsent(fm, mappings);
                    }
                }
            }
            double weight = this.weightProvider.getWeight(branch);
            this.debug(solIndex, "calculating");
            ArrayList myRates = Lists.newArrayList();
            for (int i = 0; i < this.minMags.length; ++i) {
                myRates.add(MiniSectRecurrenceGen.calcMinisectionParticRates(sol, mappings, this.minMags[i], false));
            }
            this.debug(solIndex, "archiving");
            MiniSectRIPlot miniSectRIPlot = this;
            synchronized (miniSectRIPlot) {
                for (int i = 0; i < this.minMags.length; ++i) {
                    this.solRatesMap.get(fm).get(i).add((Map)myRates.get(i));
                }
                this.weightsMap.get(fm).add(weight);
            }
            this.debug(solIndex, "done");
        }

        @Override
        protected void combineDistributedCalcs(Collection<CompoundFSSPlots> otherCalcs) {
            for (CompoundFSSPlots otherCalc : otherCalcs) {
                MiniSectRIPlot o = (MiniSectRIPlot)otherCalc;
                for (FaultModels fm : o.solRatesMap.keySet()) {
                    if (!this.solRatesMap.containsKey(fm)) {
                        ArrayList solRates = Lists.newArrayList();
                        ArrayList weights = Lists.newArrayList();
                        this.solRatesMap.put(fm, solRates);
                        this.weightsMap.put(fm, weights);
                    }
                    for (int i = 0; i < this.minMags.length; ++i) {
                        this.solRatesMap.get(fm).get(i).addAll((Collection<Map<Integer, List<Double>>>)o.solRatesMap.get(fm).get(i));
                    }
                    this.weightsMap.get(fm).addAll((Collection<Double>)o.weightsMap.get(fm));
                }
            }
        }

        @Override
        protected void doFinalizePlot() {
            for (int i = 0; i < this.minMags.length; ++i) {
                for (FaultModels fm : this.solRatesMap.keySet()) {
                    ArrayList avgRatesList = this.avgRatesMap.get(fm);
                    if (!this.avgRatesMap.containsKey(fm)) {
                        avgRatesList = Lists.newArrayList();
                        this.avgRatesMap.put(fm, avgRatesList);
                    }
                    List<Map<Integer, List<Double>>> solRates = this.solRatesMap.get(fm).get(i);
                    double[] weights = Doubles.toArray((Collection)this.weightsMap.get(fm));
                    Set<Integer> parents = solRates.get(0).keySet();
                    HashMap avg = Maps.newHashMap();
                    for (Integer parentID : parents) {
                        ArrayList solRatesList = Lists.newArrayList();
                        int numMinis = solRates.get(0).get(parentID).size();
                        for (int m = 0; m < numMinis; ++m) {
                            solRatesList.add(new double[solRates.size()]);
                        }
                        for (int s = 0; s < solRates.size(); ++s) {
                            List<Double> rates = solRates.get(s).get(parentID);
                            for (int m = 0; m < rates.size(); ++m) {
                                ((double[])solRatesList.get((int)m))[s] = rates.get(m);
                            }
                        }
                        ArrayList avgRates = Lists.newArrayList();
                        for (int m = 0; m < numMinis; ++m) {
                            double avgRate = U3FaultSystemSolutionFetcher.calcScaledAverage((double[])solRatesList.get(m), weights);
                            double ri = 1.0 / avgRate;
                            avgRates.add(ri);
                        }
                        avg.put(parentID, avgRates);
                    }
                    avgRatesList.add(avg);
                }
            }
        }
    }

    public static class MisfitTable
    extends CompoundFSSPlots {
        private static final long serialVersionUID = 1L;
        private ConcurrentMap<VariableLogicTreeBranch, Map<String, Double>> misfitsMap = Maps.newConcurrentMap();

        @Override
        protected void processSolution(U3LogicTreeBranch branch, InversionFaultSystemSolution sol, int solIndex) {
            VariableLogicTreeBranch vbr = new VariableLogicTreeBranch(branch, null);
            this.debug(solIndex, "calc/archiving");
            this.misfitsMap.putIfAbsent(vbr, sol.getMisfits());
            this.debug(solIndex, "done");
        }

        @Override
        protected void combineDistributedCalcs(Collection<CompoundFSSPlots> otherCalcs) {
            for (CompoundFSSPlots otherCalc : otherCalcs) {
                MisfitTable o = (MisfitTable)otherCalc;
                this.misfitsMap.putAll(o.misfitsMap);
            }
        }

        @Override
        protected void doFinalizePlot() {
        }
    }

    public static class PaleoRatesTable
    extends CompoundFSSPlots {
        private transient U3BranchWeightProvider weightProvider;
        private transient PaleoProbabilityModel paleoProbModel;
        private ConcurrentMap<FaultModels, List<U3PaleoRateConstraint>> paleoConstraintsMap = Maps.newConcurrentMap();
        private ConcurrentMap<FaultModels, List<U3AveSlipConstraint>> aveSlipConstraintsMap = Maps.newConcurrentMap();
        private transient ConcurrentMap<FaultModels, ConcurrentMap<Integer, List<Integer>>> rupsForSectsMap = Maps.newConcurrentMap();
        private ConcurrentMap<FaultModels, List<double[]>> reducedSlipsMap = Maps.newConcurrentMap();
        private ConcurrentMap<FaultModels, List<double[]>> proxyAveSlipRatesMap = Maps.newConcurrentMap();
        private ConcurrentMap<FaultModels, List<double[]>> aveSlipObsRatesMap = Maps.newConcurrentMap();
        private ConcurrentMap<FaultModels, List<double[]>> paleoObsRatesMap = Maps.newConcurrentMap();
        private ConcurrentMap<FaultModels, List<Double>> carrizoPaleoObsRatesMap = Maps.newConcurrentMap();
        private ConcurrentMap<FaultModels, List<Double>> weightsMap = Maps.newConcurrentMap();
        private ConcurrentMap<FaultModels, List<U3LogicTreeBranch>> branchesMap = Maps.newConcurrentMap();
        private transient Map<FaultModels, CSVFile<String>> aveSlipCSVOutputMap = Maps.newHashMap();
        private transient Map<FaultModels, CSVFile<String>> paleoCSVOutputMap = Maps.newHashMap();
        private transient CSVFile<String> carrizoCSV;

        public PaleoRatesTable(U3BranchWeightProvider weightProvider) {
            this.weightProvider = weightProvider;
            try {
                this.paleoProbModel = UCERF3_PaleoProbabilityModel.load();
            }
            catch (IOException e) {
                ExceptionUtils.throwAsRuntimeException(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        protected void processSolution(U3LogicTreeBranch branch, InversionFaultSystemSolution sol, int solIndex) {
            void var11_17;
            Object branchesList;
            InversionFaultSystemRupSet rupSet = sol.getRupSet();
            FaultModels fm = rupSet.getFaultModel();
            this.debug(solIndex, "cache fetching");
            List<U3AveSlipConstraint> aveSlipConstraints = (List<U3AveSlipConstraint>)this.aveSlipConstraintsMap.get(fm);
            if (aveSlipConstraints == null) {
                PaleoRatesTable paleoRatesTable = this;
                synchronized (paleoRatesTable) {
                    aveSlipConstraints = (List)this.aveSlipConstraintsMap.get(fm);
                    ArrayList<U3PaleoRateConstraint> paleoConstraints = null;
                    if (aveSlipConstraints == null) {
                        try {
                            aveSlipConstraints = U3AveSlipConstraint.load(rupSet.getFaultSectionDataList());
                            paleoConstraints = UCERF3_PaleoRateConstraintFetcher.getConstraints(rupSet.getFaultSectionDataList());
                        }
                        catch (IOException e) {
                            ExceptionUtils.throwAsRuntimeException(e);
                        }
                        this.paleoConstraintsMap.putIfAbsent(fm, paleoConstraints);
                        ConcurrentMap rupsForSectsLists = Maps.newConcurrentMap();
                        for (U3AveSlipConstraint u3AveSlipConstraint : aveSlipConstraints) {
                            rupsForSectsLists.putIfAbsent(u3AveSlipConstraint.getSubSectionIndex(), rupSet.getRupturesForSection(u3AveSlipConstraint.getSubSectionIndex()));
                        }
                        for (U3PaleoRateConstraint u3PaleoRateConstraint : paleoConstraints) {
                            rupsForSectsLists.putIfAbsent(u3PaleoRateConstraint.getSectionIndex(), rupSet.getRupturesForSection(u3PaleoRateConstraint.getSectionIndex()));
                        }
                        this.rupsForSectsMap.putIfAbsent(fm, rupsForSectsLists);
                        ArrayList slipsList = Lists.newArrayList();
                        this.reducedSlipsMap.putIfAbsent(fm, slipsList);
                        ArrayList arrayList = Lists.newArrayList();
                        this.proxyAveSlipRatesMap.putIfAbsent(fm, arrayList);
                        ArrayList obsRatesList = Lists.newArrayList();
                        this.aveSlipObsRatesMap.putIfAbsent(fm, obsRatesList);
                        ArrayList paleoObsRatesList = Lists.newArrayList();
                        this.paleoObsRatesMap.putIfAbsent(fm, paleoObsRatesList);
                        ArrayList carrizoList = Lists.newArrayList();
                        this.carrizoPaleoObsRatesMap.putIfAbsent(fm, carrizoList);
                        ArrayList weightsList = Lists.newArrayList();
                        this.weightsMap.putIfAbsent(fm, weightsList);
                        branchesList = Lists.newArrayList();
                        this.branchesMap.putIfAbsent(fm, (List<U3LogicTreeBranch>)branchesList);
                        this.aveSlipConstraintsMap.putIfAbsent(fm, aveSlipConstraints);
                    }
                }
            }
            double[] slips = new double[aveSlipConstraints.size()];
            double[] proxyRates = new double[aveSlipConstraints.size()];
            double[] obsRates = new double[aveSlipConstraints.size()];
            Map rupsForSectsLists = (Map)this.rupsForSectsMap.get(fm);
            this.debug(solIndex, "calculating ave slip");
            boolean bl = false;
            while (var11_17 < aveSlipConstraints.size()) {
                U3AveSlipConstraint constr = aveSlipConstraints.get((int)var11_17);
                int subsectionIndex = constr.getSubSectionIndex();
                slips[var11_17] = rupSet.getSlipRateForSection(subsectionIndex);
                proxyRates[var11_17] = slips[var11_17] / constr.getWeightedMean();
                double obsRate = 0.0;
                branchesList = ((List)rupsForSectsLists.get(constr.getSubSectionIndex())).iterator();
                while (branchesList.hasNext()) {
                    int rupID = (Integer)branchesList.next();
                    int sectIndexInRup = rupSet.getSectionsIndicesForRup(rupID).indexOf(subsectionIndex);
                    double slipOnSect = rupSet.getSlipOnSectionsForRup(rupID)[sectIndexInRup];
                    double probVisible = U3AveSlipConstraint.getProbabilityOfObservedSlip(slipOnSect);
                    obsRate += sol.getRateForRup(rupID) * probVisible;
                }
                obsRates[var11_17] = obsRate;
                ++var11_17;
            }
            List list = (List)this.paleoConstraintsMap.get(fm);
            this.debug(solIndex, "calculating paleo rates");
            double[] paleoRates = new double[list.size()];
            double carrizoRate = 0.0;
            for (int i = 0; i < list.size(); ++i) {
                U3PaleoRateConstraint constr = (U3PaleoRateConstraint)list.get(i);
                double obsRate = 0.0;
                Iterator iterator = ((List)rupsForSectsLists.get(constr.getSectionIndex())).iterator();
                while (iterator.hasNext()) {
                    int rupID = (Integer)iterator.next();
                    obsRate += sol.getRateForRup(rupID) * this.paleoProbModel.getProbPaleoVisible(rupSet, rupID, constr.getSectionIndex());
                }
                if (sol.getRupSet().getFaultSectionData(constr.getSectionIndex()).getParentSectionId() == 300) {
                    carrizoRate = obsRate;
                }
                paleoRates[i] = obsRate;
            }
            this.debug(solIndex, "archiving");
            PaleoRatesTable paleoRatesTable = this;
            synchronized (paleoRatesTable) {
                ((List)this.weightsMap.get(fm)).add(this.weightProvider.getWeight(branch));
                ((List)this.branchesMap.get(fm)).add(branch);
                ((List)this.reducedSlipsMap.get(fm)).add(slips);
                ((List)this.proxyAveSlipRatesMap.get(fm)).add(proxyRates);
                ((List)this.aveSlipObsRatesMap.get(fm)).add(obsRates);
                ((List)this.paleoObsRatesMap.get(fm)).add(paleoRates);
                ((List)this.carrizoPaleoObsRatesMap.get(fm)).add(carrizoRate);
            }
            this.debug(solIndex, "done");
        }

        @Override
        protected void combineDistributedCalcs(Collection<CompoundFSSPlots> otherCalcs) {
            for (CompoundFSSPlots otherCalc : otherCalcs) {
                PaleoRatesTable o = (PaleoRatesTable)otherCalc;
                for (FaultModels fm : o.weightsMap.keySet()) {
                    if (!this.weightsMap.containsKey(fm)) {
                        this.weightsMap.put(fm, new ArrayList());
                        this.branchesMap.put(fm, new ArrayList());
                        this.aveSlipConstraintsMap.put(fm, (List)o.aveSlipConstraintsMap.get(fm));
                        this.paleoConstraintsMap.put(fm, (List)o.paleoConstraintsMap.get(fm));
                        this.reducedSlipsMap.put(fm, new ArrayList());
                        this.proxyAveSlipRatesMap.put(fm, new ArrayList());
                        this.aveSlipObsRatesMap.put(fm, new ArrayList());
                        this.paleoObsRatesMap.put(fm, new ArrayList());
                        this.carrizoPaleoObsRatesMap.put(fm, new ArrayList());
                    }
                    ((List)this.weightsMap.get(fm)).addAll((Collection)o.weightsMap.get(fm));
                    ((List)this.branchesMap.get(fm)).addAll((Collection)o.branchesMap.get(fm));
                    ((List)this.reducedSlipsMap.get(fm)).addAll((Collection)o.reducedSlipsMap.get(fm));
                    ((List)this.proxyAveSlipRatesMap.get(fm)).addAll((Collection)o.proxyAveSlipRatesMap.get(fm));
                    ((List)this.aveSlipObsRatesMap.get(fm)).addAll((Collection)o.aveSlipObsRatesMap.get(fm));
                    ((List)this.paleoObsRatesMap.get(fm)).addAll((Collection)o.paleoObsRatesMap.get(fm));
                    ((List)this.carrizoPaleoObsRatesMap.get(fm)).addAll((Collection)o.carrizoPaleoObsRatesMap.get(fm));
                }
            }
        }

        @Override
        protected void doFinalizePlot() {
            Object line;
            UncertainDataConstraint.SectMappedUncertainDataConstraint ucerf2Constraint;
            UncertainDataConstraint.SectMappedUncertainDataConstraint constr;
            List constraints;
            ArrayList header;
            ArrayList<U3PaleoRateConstraint> ucerf2PaleoConstraints;
            List<U3AveSlipConstraint> ucerf2AveSlipConstraints;
            FaultSystemSolution ucerf2Sol = UCERF2_ComparisonSolutionFetcher.getUCERF2Solution(FaultModels.FM2_1);
            try {
                ucerf2AveSlipConstraints = U3AveSlipConstraint.load(ucerf2Sol.getRupSet().getFaultSectionDataList());
                ucerf2PaleoConstraints = UCERF3_PaleoRateConstraintFetcher.getConstraints(ucerf2Sol.getRupSet().getFaultSectionDataList());
            }
            catch (IOException e) {
                throw ExceptionUtils.asRuntimeException(e);
            }
            for (Object fm : this.weightsMap.keySet()) {
                CSVFile cSVFile = new CSVFile(true);
                header = Lists.newArrayList((Object[])new String[]{((FaultModels)fm).getShortName() + " Mapping", "Latitude", "Longitude", "Weighted Mean Slip", "UCERF2 Reduced Slip Rate", "UCERF2 Proxy Event Rate", "UCERF3 Mean Reduced Slip Rate", "UCERF3 Mean Proxy Event Rate", "UCERF3 Mean Paleo Visible Rate", "UCERF3 Min Paleo Visible Rate", "UCERF3 Max Paleo Visible Rate"});
                cSVFile.addLine(header);
                constraints = (List)this.aveSlipConstraintsMap.get(fm);
                for (int i = 0; i < constraints.size(); ++i) {
                    constr = (U3AveSlipConstraint)constraints.get(i);
                    ucerf2Constraint = null;
                    for (U3AveSlipConstraint u3AveSlipConstraint : ucerf2AveSlipConstraints) {
                        if (!u3AveSlipConstraint.getSiteLocation().equals(((U3AveSlipConstraint)constr).getSiteLocation())) continue;
                        ucerf2Constraint = u3AveSlipConstraint;
                        break;
                    }
                    line = Lists.newArrayList();
                    line.add(((U3AveSlipConstraint)constr).getSubSectionName());
                    line.add("" + ((U3AveSlipConstraint)constr).getSiteLocation().getLatitude());
                    line.add("" + ((U3AveSlipConstraint)constr).getSiteLocation().getLongitude());
                    line.add("" + ((U3AveSlipConstraint)constr).getWeightedMean());
                    if (ucerf2Constraint == null) {
                        line.add("");
                        line.add("");
                    } else {
                        double d = ucerf2Sol.getRupSet().getSlipRateForSection(((U3AveSlipConstraint)ucerf2Constraint).getSubSectionIndex());
                        line.add("" + d);
                        double ucerf2ProxyRate = d / ((U3AveSlipConstraint)constr).getWeightedMean();
                        line.add("" + ucerf2ProxyRate);
                    }
                    List list = (List)this.reducedSlipsMap.get(fm);
                    List proxyRatesList = (List)this.proxyAveSlipRatesMap.get(fm);
                    List obsRatesList = (List)this.aveSlipObsRatesMap.get(fm);
                    int numSols = list.size();
                    double[] slips = new double[numSols];
                    double[] proxyRates = new double[numSols];
                    double[] rates = new double[numSols];
                    double[] weigths = Doubles.toArray((Collection)((Collection)this.weightsMap.get(fm)));
                    for (int j = 0; j < numSols; ++j) {
                        slips[j] = ((double[])list.get(j))[i];
                        proxyRates[j] = ((double[])proxyRatesList.get(j))[i];
                        rates[j] = ((double[])obsRatesList.get(j))[i];
                    }
                    line.add("" + U3FaultSystemSolutionFetcher.calcScaledAverage(slips, weigths));
                    line.add("" + U3FaultSystemSolutionFetcher.calcScaledAverage(proxyRates, weigths));
                    line.add("" + U3FaultSystemSolutionFetcher.calcScaledAverage(rates, weigths));
                    line.add("" + StatUtils.min((double[])rates));
                    line.add("" + StatUtils.max((double[])rates));
                    cSVFile.addLine(line);
                }
                this.aveSlipCSVOutputMap.put((FaultModels)fm, cSVFile);
            }
            for (Object fm : this.weightsMap.keySet()) {
                CSVFile cSVFile = new CSVFile(true);
                header = Lists.newArrayList((Object[])new String[]{((FaultModels)fm).getShortName() + " Mapping", "Latitude", "Longitude", "Paleo Observed Rate", "Paleo Observed Lower Bound", "Paleo Observed Upper Bound", "UCERF2 Paleo Visible Rate", "UCERF3 Mean Paleo Visible Rate", "UCERF3 Min Paleo Visible Rate", "UCERF3 Max Paleo Visible Rate"});
                cSVFile.addLine(header);
                constraints = (List)this.paleoConstraintsMap.get(fm);
                for (int i2 = 0; i2 < constraints.size(); ++i2) {
                    constr = (U3PaleoRateConstraint)constraints.get(i2);
                    ucerf2Constraint = null;
                    for (U3PaleoRateConstraint u3PaleoRateConstraint : ucerf2PaleoConstraints) {
                        if (!u3PaleoRateConstraint.getPaleoSiteLoction().equals(((U3PaleoRateConstraint)constr).getPaleoSiteLoction())) continue;
                        ucerf2Constraint = u3PaleoRateConstraint;
                        break;
                    }
                    line = Lists.newArrayList();
                    line.add(((U3PaleoRateConstraint)constr).getFaultSectionName());
                    line.add("" + ((U3PaleoRateConstraint)constr).getPaleoSiteLoction().getLatitude());
                    line.add("" + ((U3PaleoRateConstraint)constr).getPaleoSiteLoction().getLongitude());
                    line.add("" + ((U3PaleoRateConstraint)constr).getMeanRate());
                    line.add("" + ((U3PaleoRateConstraint)constr).getLower95ConfOfRate());
                    line.add("" + ((U3PaleoRateConstraint)constr).getUpper95ConfOfRate());
                    if (ucerf2Constraint == null) {
                        line.add("");
                    } else {
                        line.add("" + PaleoFitPlotter.getPaleoRateForSect(ucerf2Sol, ((U3PaleoRateConstraint)ucerf2Constraint).getSectionIndex(), this.paleoProbModel));
                    }
                    List list = (List)this.paleoObsRatesMap.get(fm);
                    int numSols = list.size();
                    double[] rates = new double[numSols];
                    double[] weigths = Doubles.toArray((Collection)((Collection)this.weightsMap.get(fm)));
                    for (int j = 0; j < numSols; ++j) {
                        rates[j] = ((double[])list.get(j))[i2];
                    }
                    line.add("" + U3FaultSystemSolutionFetcher.calcScaledAverage(rates, weigths));
                    line.add("" + StatUtils.min((double[])rates));
                    line.add("" + StatUtils.max((double[])rates));
                    cSVFile.addLine(line);
                }
                this.paleoCSVOutputMap.put((FaultModels)fm, cSVFile);
            }
            this.carrizoCSV = new CSVFile(true);
            ArrayList header2 = Lists.newArrayList();
            for (Class clazz : U3LogicTreeBranch.getLogicTreeNodeClasses()) {
                header2.add(ClassUtils.getClassNameWithoutPackage(clazz));
            }
            header2.add("A Priori Branch Weight");
            header2.add("Carrizo Paleo Observable Rate");
            this.carrizoCSV.addLine(header2);
            double totWt = 0.0;
            for (List weights : this.weightsMap.values()) {
                Iterator i2 = weights.iterator();
                while (i2.hasNext()) {
                    double weight = (Double)i2.next();
                    totWt += weight;
                }
            }
            for (FaultModels fm : this.carrizoPaleoObsRatesMap.keySet()) {
                List branches = (List)this.branchesMap.get(fm);
                List weights = (List)this.weightsMap.get(fm);
                List rates = (List)this.carrizoPaleoObsRatesMap.get(fm);
                for (int i3 = 0; i3 < branches.size(); ++i3) {
                    ArrayList arrayList = Lists.newArrayList();
                    U3LogicTreeBranch branch = (U3LogicTreeBranch)branches.get(i3);
                    for (int j = 0; j < U3LogicTreeBranch.getLogicTreeNodeClasses().size(); ++j) {
                        arrayList.add(((U3LogicTreeBranchNode)branch.getValue(j)).getShortName());
                    }
                    double weight = (Double)weights.get(i3);
                    arrayList.add("" + weight / totWt);
                    arrayList.add(String.valueOf(rates.get(i3)));
                    this.carrizoCSV.addLine(arrayList);
                }
            }
        }
    }

    public static class BranchAvgFSSBuilder
    extends CompoundFSSPlots {
        private transient U3BranchWeightProvider weightProvider;
        private GriddedRegion region;
        private Map<FaultModels, Map<Integer, IncrementalMagFreqDist>> nodeSubSeisMFDsMap = Maps.newHashMap();
        private Map<FaultModels, Map<Integer, IncrementalMagFreqDist>> nodeUnassociatedMFDsMap = Maps.newHashMap();
        private Map<FaultModels, double[]> ratesMap = Maps.newConcurrentMap();
        private Map<FaultModels, double[]> magsMap = Maps.newConcurrentMap();
        private Map<FaultModels, List<Double>> weightsMap = Maps.newConcurrentMap();
        private Map<FaultModels, U3LogicTreeBranch> runningBranches = Maps.newConcurrentMap();
        private Map<FaultModels, List<IncrementalMagFreqDist>> subSeisMFDsMap = Maps.newConcurrentMap();
        private Map<FaultModels, HashSet<DeformationModels>> defModelsMap = Maps.newHashMap();
        private Map<FaultModels, InversionFaultSystemRupSet> rupSetCache = Maps.newHashMap();
        private int solIndex = -1;

        public BranchAvgFSSBuilder(U3BranchWeightProvider weightProvider) {
            this.weightProvider = weightProvider;
        }

        public int getSolIndex() {
            return this.solIndex;
        }

        public void setSolIndex(int solIndex) {
            this.solIndex = solIndex;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void processSolution(U3LogicTreeBranch branch, InversionFaultSystemSolution sol, int solIndex) {
            if (this.solIndex >= 0) {
                Preconditions.checkState((boolean)(sol instanceof U3AverageFaultSystemSolution), (Object)"Sol index supplied but branch isn't an average!");
                U3AverageFaultSystemSolution avgSol = (U3AverageFaultSystemSolution)sol;
                Preconditions.checkState((avgSol.getNumSolutions() > this.solIndex ? 1 : 0) != 0, (Object)("Sol index=" + this.solIndex + " but avg sol has " + avgSol.getNumSolutions() + " sols"));
                sol = avgSol.getSolution(this.solIndex);
            }
            InversionFaultSystemRupSet rupSet = sol.getRupSet();
            FaultModels fm = rupSet.getFaultModel();
            int numRups = rupSet.getNumRuptures();
            double weight = this.weightProvider.getWeight(branch);
            MFDGridSourceProvider gridSources = sol.getGridSourceProvider();
            HashMap nodeSubSeisMFDs = Maps.newHashMap();
            HashMap nodeUnassociatedMFDs = Maps.newHashMap();
            if (this.region == null) {
                this.region = gridSources.getGriddedRegion();
            }
            for (int i = 0; i < this.region.getNumLocations(); ++i) {
                nodeSubSeisMFDs.put(i, gridSources.getMFD_SubSeisOnFault(i));
                nodeUnassociatedMFDs.put(i, gridSources.getMFD_Unassociated(i));
            }
            List<? extends IncrementalMagFreqDist> subSeisMFDs = sol.getFinalSubSeismoOnFaultMFD_List();
            FaultModels faultModels = fm;
            synchronized (faultModels) {
                int i;
                ArrayList weightsList = this.weightsMap.get(fm);
                if (weightsList == null) {
                    weightsList = Lists.newArrayList();
                    this.weightsMap.put(fm, weightsList);
                    this.nodeSubSeisMFDsMap.put(fm, new HashMap());
                    this.nodeUnassociatedMFDsMap.put(fm, new HashMap());
                    this.ratesMap.put(fm, new double[numRups]);
                    this.magsMap.put(fm, new double[numRups]);
                    this.defModelsMap.put(fm, new HashSet());
                    if (numRups == 229104 || numRups == 249656) {
                        this.rupSetCache.put(fm, sol.getRupSet());
                    }
                    ArrayList runningSubSeisMFDs = Lists.newArrayList();
                    IncrementalMagFreqDist tempMFD = subSeisMFDs.get(0);
                    for (i = 0; i < subSeisMFDs.size(); ++i) {
                        runningSubSeisMFDs.add(new IncrementalMagFreqDist(tempMFD.getMinX(), tempMFD.size(), tempMFD.getDelta()));
                    }
                    this.subSeisMFDsMap.put(fm, runningSubSeisMFDs);
                    this.runningBranches.put(fm, (U3LogicTreeBranch)branch.clone());
                }
                BranchAvgFSSBuilder.updateRunningBranch(this.runningBranches.get(fm), branch);
                weightsList.add(weight);
                Map<Integer, IncrementalMagFreqDist> runningNodeSubSeisMFDs = this.nodeSubSeisMFDsMap.get(fm);
                Map<Integer, IncrementalMagFreqDist> runningNodeUnassociatedMFDs = this.nodeUnassociatedMFDsMap.get(fm);
                for (i = 0; i < this.region.getNumLocations(); ++i) {
                    BranchAvgFSSBuilder.addWeighted(runningNodeSubSeisMFDs, i, (IncrementalMagFreqDist)nodeSubSeisMFDs.get(i), weight);
                    BranchAvgFSSBuilder.addWeighted(runningNodeUnassociatedMFDs, i, (IncrementalMagFreqDist)nodeUnassociatedMFDs.get(i), weight);
                }
                List<IncrementalMagFreqDist> runningSubSeisMFDs = this.subSeisMFDsMap.get(fm);
                for (int i2 = 0; i2 < subSeisMFDs.size(); ++i2) {
                    BranchAvgFSSBuilder.addWeighted(runningSubSeisMFDs.get(i2), subSeisMFDs.get(i2), weight);
                }
                this.addWeighted(this.ratesMap.get(fm), sol.getRateForAllRups(), weight);
                this.addWeighted(this.magsMap.get(fm), rupSet.getMagForAllRups(), weight);
                Map<FaultModels, HashSet<DeformationModels>> map = this.defModelsMap;
                synchronized (map) {
                    this.defModelsMap.get(fm).add(branch.getValue(DeformationModels.class));
                }
            }
        }

        private static void updateRunningBranch(U3LogicTreeBranch runningBranch, U3LogicTreeBranch currentBranch) {
            for (int i = 0; i < currentBranch.size(); ++i) {
                if (runningBranch.getValue(i) == currentBranch.getValue(i)) continue;
                runningBranch.clearValue(i);
            }
        }

        public static void addWeighted(Map<Integer, IncrementalMagFreqDist> mfdMap, int index, IncrementalMagFreqDist newMFD, double weight) {
            if (newMFD == null) {
                return;
            }
            IncrementalMagFreqDist runningMFD = mfdMap.get(index);
            if (runningMFD == null) {
                runningMFD = new IncrementalMagFreqDist(newMFD.getMinX(), newMFD.size(), newMFD.getDelta());
                mfdMap.put(index, runningMFD);
            } else {
                Preconditions.checkState((runningMFD.size() == newMFD.size() ? 1 : 0) != 0, (Object)"MFD sizes inconsistent");
                Preconditions.checkState(((float)runningMFD.getMinX() == (float)newMFD.getMinX() ? 1 : 0) != 0, (Object)"MFD min x inconsistent");
                Preconditions.checkState(((float)runningMFD.getDelta() == (float)newMFD.getDelta() ? 1 : 0) != 0, (Object)"MFD delta inconsistent");
            }
            BranchAvgFSSBuilder.addWeighted(runningMFD, newMFD, weight);
        }

        public static void addWeighted(IncrementalMagFreqDist runningMFD, IncrementalMagFreqDist newMFD, double weight) {
            for (int i = 0; i < runningMFD.size(); ++i) {
                runningMFD.add(i, newMFD.getY(i) * weight);
            }
        }

        private void addWeighted(double[] running, double[] vals, double weight) {
            Preconditions.checkState((running.length == vals.length ? 1 : 0) != 0);
            for (int i = 0; i < running.length; ++i) {
                int n = i;
                running[n] = running[n] + vals[i] * weight;
            }
        }

        @Override
        protected void combineDistributedCalcs(Collection<CompoundFSSPlots> otherCalcs) {
            for (CompoundFSSPlots otherCalc : otherCalcs) {
                BranchAvgFSSBuilder o = (BranchAvgFSSBuilder)otherCalc;
                if (this.region == null) {
                    this.region = o.region;
                }
                for (FaultModels fm : o.weightsMap.keySet()) {
                    int i;
                    if (!this.weightsMap.containsKey(fm)) {
                        this.weightsMap.put(fm, new ArrayList());
                        this.nodeSubSeisMFDsMap.put(fm, new HashMap());
                        this.nodeUnassociatedMFDsMap.put(fm, new HashMap());
                        ArrayList<IncrementalMagFreqDist> subSeisMFDs = new ArrayList<IncrementalMagFreqDist>();
                        for (IncrementalMagFreqDist oMFD : o.subSeisMFDsMap.get(fm)) {
                            subSeisMFDs.add(new IncrementalMagFreqDist(oMFD.getMinX(), oMFD.size(), oMFD.getDelta()));
                        }
                        this.subSeisMFDsMap.put(fm, subSeisMFDs);
                        this.ratesMap.put(fm, new double[o.ratesMap.get(fm).length]);
                        this.magsMap.put(fm, new double[o.magsMap.get(fm).length]);
                        this.defModelsMap.put(fm, new HashSet());
                        this.runningBranches.put(fm, o.runningBranches.get(fm));
                    }
                    BranchAvgFSSBuilder.updateRunningBranch(this.runningBranches.get(fm), o.runningBranches.get(fm));
                    Map<Integer, IncrementalMagFreqDist> nodeSubSeisMFDs = o.nodeSubSeisMFDsMap.get(fm);
                    Map<Integer, IncrementalMagFreqDist> nodeUnassociatedMFDs = o.nodeUnassociatedMFDsMap.get(fm);
                    Map<Integer, IncrementalMagFreqDist> runningNodeSubSeisMFDs = this.nodeSubSeisMFDsMap.get(fm);
                    Map<Integer, IncrementalMagFreqDist> runningNodeUnassociatedMFDs = this.nodeUnassociatedMFDsMap.get(fm);
                    for (i = 0; i < this.region.getNumLocations(); ++i) {
                        BranchAvgFSSBuilder.addWeighted(runningNodeSubSeisMFDs, i, nodeSubSeisMFDs.get(i), 1.0);
                        BranchAvgFSSBuilder.addWeighted(runningNodeUnassociatedMFDs, i, nodeUnassociatedMFDs.get(i), 1.0);
                    }
                    for (i = 0; i < this.subSeisMFDsMap.get(fm).size(); ++i) {
                        BranchAvgFSSBuilder.addWeighted(this.subSeisMFDsMap.get(fm).get(i), o.subSeisMFDsMap.get(fm).get(i), 1.0);
                    }
                    this.weightsMap.get(fm).addAll((Collection<Double>)o.weightsMap.get(fm));
                    this.addWeighted(this.ratesMap.get(fm), o.ratesMap.get(fm), 1.0);
                    this.addWeighted(this.magsMap.get(fm), o.magsMap.get(fm), 1.0);
                    this.defModelsMap.get(fm).addAll((Collection<DeformationModels>)o.defModelsMap.get(fm));
                }
            }
        }

        @Override
        protected void doFinalizePlot() {
            for (FaultModels fm : this.weightsMap.keySet()) {
                double sum = 0.0;
                for (double weight : this.weightsMap.get(fm)) {
                    sum += weight;
                }
                double scale = 1.0 / sum;
                for (IncrementalMagFreqDist mfd : this.nodeSubSeisMFDsMap.get(fm).values()) {
                    mfd.scale(scale);
                }
                for (IncrementalMagFreqDist mfd : this.nodeUnassociatedMFDsMap.get(fm).values()) {
                    mfd.scale(scale);
                }
                for (IncrementalMagFreqDist mfd : this.subSeisMFDsMap.get(fm)) {
                    mfd.scale(scale);
                }
                double[] rates = this.ratesMap.get(fm);
                double[] mags = this.magsMap.get(fm);
                int i = 0;
                while (i < rates.length) {
                    int n = i;
                    rates[n] = rates[n] * scale;
                    int n2 = i++;
                    mags[n2] = mags[n2] * scale;
                }
            }
        }
    }

    protected static class PlotSolComputeTask
    implements Task {
        private Collection<CompoundFSSPlots> plots;
        private U3FaultSystemSolutionFetcher fetcher;
        private U3LogicTreeBranch branch;
        private boolean mpj;
        private FaultSystemSolutionERF erf;
        private int index;
        private long overheadMillis;

        public PlotSolComputeTask(Collection<CompoundFSSPlots> plots, U3FaultSystemSolutionFetcher fetcher, U3LogicTreeBranch branch, int index) {
            this(plots, fetcher, branch, false, index);
        }

        public PlotSolComputeTask(Collection<CompoundFSSPlots> plots, U3FaultSystemSolutionFetcher fetcher, U3LogicTreeBranch branch, boolean mpj, int index) {
            this.plots = plots;
            this.fetcher = fetcher;
            this.branch = branch;
            this.mpj = mpj;
            this.index = index;
        }

        private void debug(String message) {
            System.out.println("[" + df.format(new Date()) + " (" + CompoundFSSPlots.getHostname() + ") PlotSolComputeTask]: " + message + " [" + this.getMemoryDebug() + "]");
        }

        private String getMemoryDebug() {
            System.gc();
            Runtime rt = Runtime.getRuntime();
            long totalMB = rt.totalMemory() / 1024L / 1024L;
            long freeMB = rt.freeMemory() / 1024L / 1024L;
            long usedMB = totalMB - freeMB;
            return "mem t/u/f: " + totalMB + "/" + usedMB + "/" + freeMB;
        }

        @Override
        public void compute() {
            try {
                Stopwatch overheadWatch = Stopwatch.createStarted();
                this.debug("Fetching solution for branch: " + String.valueOf(this.branch));
                InversionFaultSystemSolution sol = this.fetcher.getSolution(this.branch);
                overheadWatch.stop();
                for (CompoundFSSPlots plot : this.plots) {
                    Stopwatch computeWatch = Stopwatch.createUnstarted();
                    if (plot.usesERFs()) {
                        overheadWatch.start();
                        if (this.erf == null) {
                            this.debug("Building ERF");
                            this.erf = new FaultSystemSolutionERF(sol);
                        }
                        this.erf.setParameter("Apply Aftershock Filter", plot.isApplyAftershockFilter());
                        if (plot.isTimeDependent()) {
                            this.erf.getParameter("Probability Model").setValue(ProbabilityModelOptions.U3_PREF_BLEND);
                            this.erf.setParameter("Historic Open Interval", 139.0);
                            this.erf.setParameter("BPT Averaging Type", (Object)BPTAveragingTypeOptions.AVE_RI_AVE_NORM_TIME_SINCE);
                        } else {
                            this.erf.getParameter("Probability Model").setValue(ProbabilityModelOptions.POISSON);
                        }
                        this.erf.updateForecast();
                        overheadWatch.stop();
                        this.debug("Processing ERF plot: " + ClassUtils.getClassNameWithoutPackage(plot.getClass()));
                        computeWatch.start();
                        plot.processERF(this.branch, this.erf, this.index);
                        computeWatch.stop();
                    } else {
                        this.debug("Processing Regular plot: " + ClassUtils.getClassNameWithoutPackage(plot.getClass()));
                        computeWatch.start();
                        plot.processSolution(this.branch, sol, this.index);
                        computeWatch.stop();
                    }
                    plot.addToComputeTimeCount(computeWatch.elapsed(TimeUnit.MILLISECONDS));
                }
                this.debug("DONE");
                this.erf = null;
                this.overheadMillis = overheadWatch.elapsed(TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {
                this.debug("EXCEPTION: " + String.valueOf(e.getClass()) + ": " + e.getMessage());
                e.printStackTrace();
                if (this.mpj) {
                    MPJTaskCalculator.abortAndExit((int)1);
                }
                System.exit(1);
            }
        }
    }

    public static abstract class MapBasedPlot
    extends CompoundFSSPlots {
        protected abstract List<MapPlotData> getPlotData();

        protected abstract String getPlotDataFileName();

        protected double[] getWeightedAvg(int numFaults, List<double[]> valuesList, List<Double> weightsList) {
            double[] weights = Doubles.toArray(weightsList);
            double[] values = new double[numFaults];
            for (int i = 0; i < numFaults; ++i) {
                double[] faultVals = new double[weights.length];
                for (int s = 0; s < weights.length; ++s) {
                    faultVals[s] = valuesList.get(s)[i];
                }
                values[i] = U3FaultSystemSolutionFetcher.calcScaledAverage(faultVals, weights);
            }
            return values;
        }

        protected double[] getMins(int numFaults, List<double[]> valuesList) {
            double[] values = new double[numFaults];
            int numSols = valuesList.size();
            for (int i = 0; i < numFaults; ++i) {
                double[] faultVals = new double[numSols];
                for (int s = 0; s < numSols; ++s) {
                    faultVals[s] = valuesList.get(s)[i];
                }
                values[i] = StatUtils.min((double[])faultVals);
            }
            return values;
        }

        protected double[] getMaxs(int numFaults, List<double[]> valuesList) {
            double[] values = new double[numFaults];
            int numSols = valuesList.size();
            for (int i = 0; i < numFaults; ++i) {
                double[] faultVals = new double[numSols];
                for (int s = 0; s < numSols; ++s) {
                    faultVals[s] = valuesList.get(s)[i];
                }
                values[i] = StatUtils.max((double[])faultVals);
            }
            return values;
        }

        protected double[] getStdDevs(int numFaults, List<double[]> valuesList) {
            double[] stdDevs = new double[numFaults];
            for (int i = 0; i < numFaults; ++i) {
                double[] faultVals = new double[valuesList.size()];
                for (int s = 0; s < valuesList.size(); ++s) {
                    faultVals[s] = valuesList.get(s)[i];
                }
                stdDevs[i] = Math.sqrt(StatUtils.variance((double[])faultVals));
            }
            return stdDevs;
        }

        public void writePlotData(File dir) throws IOException {
            Document doc = XMLUtils.createDocumentWithRoot();
            Element root = doc.getRootElement();
            for (MapPlotData data : this.getPlotData()) {
                data.toXMLMetadata(root);
            }
            File dataFile = new File(dir, this.getPlotDataFileName());
            XMLUtils.writeDocumentToFile(dataFile, doc);
        }

        public static List<MapPlotData> loadPlotData(File file) throws MalformedURLException, org.dom4j.DocumentException {
            Document doc = XMLUtils.loadDocument(file);
            Element root = doc.getRootElement();
            ArrayList plots = Lists.newArrayList();
            Iterator it = root.elementIterator("FaultBasedMap");
            while (it.hasNext()) {
                plots.add(MapPlotData.fromXMLMetadata((Element)it.next()));
            }
            return plots;
        }

        public void makeMapPlots(File dir, String prefix) throws GMT_MapException, RuntimeException, IOException {
            MapBasedPlot.makeMapPlots(dir, prefix, this.getPlotData());
        }

        public static void makeMapPlot(File dir, String prefix, MapPlotData plot) throws GMT_MapException, RuntimeException, IOException {
            MapBasedPlot.makeMapPlots(dir, prefix, Lists.newArrayList((Object[])new MapPlotData[]{plot}));
        }

        public static void makeMapPlots(File dir, String prefix, List<MapPlotData> plots) throws GMT_MapException, RuntimeException, IOException {
            System.out.println("*** Making " + plots.size() + " Map Plots ***");
            for (MapPlotData plot : plots) {
                MapBasedPlot.doMakePlot(dir, prefix, plot);
            }
        }

        private static void doMakePlot(File dir, String prefix, MapPlotData plot) throws GMT_MapException, RuntimeException, IOException {
            Object plotPrefix = prefix != null && !prefix.isEmpty() && plot.subDirName == null ? prefix + "_" : "";
            plotPrefix = (String)plotPrefix + plot.fileName;
            File writeDir = dir;
            if (plot.subDirName != null) {
                writeDir = new File(dir, plot.subDirName);
            }
            if (!writeDir.exists()) {
                writeDir.mkdir();
            }
            System.out.println("Making fault plot with title: " + plot.label);
            if (plot.griddedData == null) {
                FaultBasedMapGen.makeFaultPlot(plot.cpt, plot.faults, plot.faultValues, plot.region, writeDir, (String)plotPrefix, false, plot.skipNans, plot.label);
            } else {
                FaultBasedMapGen.plotMap(writeDir, (String)plotPrefix, false, FaultBasedMapGen.buildMap(plot.cpt, null, null, plot.griddedData, plot.spacing, plot.region, plot.skipNans, plot.label));
            }
            String metadata = plot.getMetadata();
            if (metadata != null && !metadata.isEmpty() && plot.subDirName != null) {
                File metadataFile = new File(writeDir, "metadata.txt");
                System.out.println("Writing plot metadata to: " + metadataFile.getAbsolutePath());
                FileWriter fw = new FileWriter(metadataFile);
                fw.write(metadata + "\n");
                fw.close();
            }
            System.out.println("DONE.");
        }

        protected void writeExtraData(File dir, String prefix) {
        }
    }

    public static class MapPlotData
    implements XMLSaveable,
    Serializable {
        private static final String XML_METADATA_NAME = "FaultBasedMap";
        private CPT cpt;
        private List<LocationList> faults;
        private double[] faultValues;
        private GeoDataSet griddedData;
        private double spacing;
        private Region region;
        private boolean skipNans;
        private String label;
        private String fileName;
        private String subDirName;
        private String metadata;

        public MapPlotData(CPT cpt, List<LocationList> faults, double[] faultValues, Region region, boolean skipNans, String label, String fileName) {
            this(cpt, faults, faultValues, null, 1.0, region, skipNans, label, fileName);
        }

        public MapPlotData(CPT cpt, GriddedGeoDataSet griddedData, boolean skipNans, String label, String fileName) {
            this(cpt, griddedData, griddedData.getRegion().getSpacing(), (Region)griddedData.getRegion(), skipNans, label, fileName);
        }

        public MapPlotData(CPT cpt, GeoDataSet griddedData, double spacing, Region region, boolean skipNans, String label, String fileName) {
            this(cpt, null, null, griddedData, spacing, region, skipNans, label, fileName);
        }

        public MapPlotData(CPT cpt, List<LocationList> faults, double[] faultValues, GeoDataSet griddedData, double spacing, Region region, boolean skipNans, String label, String fileName) {
            this.cpt = cpt;
            this.faults = faults;
            this.griddedData = griddedData;
            this.spacing = spacing;
            this.faultValues = faultValues;
            this.region = region;
            this.skipNans = skipNans;
            this.label = label;
            this.fileName = fileName;
        }

        public static MapPlotData fromXMLMetadata(Element xml) {
            Attribute metadataAtt;
            ArbDiscrGeoDataSet griddedData;
            ArrayList faults;
            double[] values;
            CPT cpt = CPT.fromXMLMetadata(xml.element("CPT"));
            double spacing = 1.0;
            Element geoEl = xml.element("GeoDataSet");
            if (geoEl != null) {
                values = null;
                faults = null;
                spacing = Double.parseDouble(geoEl.attributeValue("spacing"));
                Iterator it = geoEl.elementIterator("Node");
                ArrayList locs = Lists.newArrayList();
                ArrayList nodeVals = Lists.newArrayList();
                while (it.hasNext()) {
                    Element nodeElem = (Element)it.next();
                    locs.add(Location.fromXMLMetadata(nodeElem.element("Location")));
                    double nodeVal = Double.parseDouble(nodeElem.attributeValue("value"));
                    nodeVals.add(nodeVal);
                }
                griddedData = new ArbDiscrGeoDataSet(true);
                for (int i = 0; i < locs.size(); ++i) {
                    griddedData.set((Location)locs.get(i), (double)((Double)nodeVals.get(i)));
                }
            } else {
                griddedData = null;
                faults = Lists.newArrayList();
                ArrayList valuesList = Lists.newArrayList();
                Iterator it = xml.elementIterator("Fault");
                while (it.hasNext()) {
                    Element faultElem = (Element)it.next();
                    faults.add(LocationList.fromXMLMetadata(faultElem.element("LocationList")));
                    valuesList.add(Double.parseDouble(faultElem.attributeValue("value")));
                }
                values = Doubles.toArray((Collection)valuesList);
            }
            Region region = Region.fromXMLMetadata(xml.element("Region"));
            boolean skipNans = Boolean.parseBoolean(xml.attributeValue("skipNans"));
            String label = xml.attributeValue("label");
            String fileName = xml.attributeValue("fileName");
            Attribute subDirName = xml.attribute("subDir");
            MapPlotData data = new MapPlotData(cpt, faults, values, griddedData, spacing, region, skipNans, label, fileName);
            if (subDirName != null) {
                data.subDirName = subDirName.getStringValue();
            }
            if ((metadataAtt = xml.attribute("metadata")) != null) {
                data.metadata = metadataAtt.getStringValue().replaceAll("<br>", "\n");
            }
            return data;
        }

        @Override
        public Element toXMLMetadata(Element root) {
            Element xml = root.addElement(XML_METADATA_NAME);
            this.cpt.toXMLMetadata(xml);
            if (this.faults != null) {
                for (int i = 0; i < this.faults.size(); ++i) {
                    Element faultElem = xml.addElement("Fault");
                    faultElem.addAttribute("value", "" + this.faultValues[i]);
                    this.faults.get(i).toXMLMetadata(faultElem);
                }
            }
            if (this.griddedData != null) {
                Element geoEl = xml.addElement("GeoDataSet");
                geoEl.addAttribute("spacing", "" + this.spacing);
                for (int i = 0; i < this.griddedData.size(); ++i) {
                    Location loc = this.griddedData.getLocation(i);
                    double val = this.griddedData.get(i);
                    Element nodeEl = geoEl.addElement("Node");
                    nodeEl.addAttribute("value", "" + val);
                    loc.toXMLMetadata(nodeEl);
                }
            }
            if (this.region instanceof GriddedRegion) {
                GriddedRegion gridded = (GriddedRegion)this.region;
                if (gridded.getSpacing() <= 0.11) {
                    new Region(this.region.getBorder(), null).toXMLMetadata(xml);
                } else {
                    new Region(new Location(gridded.getMaxGridLat(), gridded.getMaxGridLon()), new Location(gridded.getMinGridLat(), gridded.getMinGridLon())).toXMLMetadata(xml);
                }
            } else {
                this.region.toXMLMetadata(xml);
            }
            xml.addAttribute("skipNans", "" + this.skipNans);
            xml.addAttribute("label", this.label);
            xml.addAttribute("fileName", this.fileName);
            if (this.subDirName != null) {
                xml.addAttribute("subDir", this.subDirName);
            }
            if (this.metadata != null && !this.metadata.isEmpty()) {
                xml.addAttribute("metadata", this.metadata.replaceAll("\n", "<br>"));
            }
            return root;
        }

        public GeoDataSet getGriddedData() {
            return this.griddedData;
        }

        public String getLabel() {
            return this.label;
        }

        public CPT getCPT() {
            return this.cpt;
        }

        public Region getRegion() {
            return this.region;
        }

        public String getFileName() {
            return this.fileName;
        }

        public String getSubDirName() {
            return this.subDirName;
        }

        public List<LocationList> getFaults() {
            return this.faults;
        }

        public double[] getFaultValues() {
            return this.faultValues;
        }

        public String getMetadata() {
            return this.metadata;
        }

        public double getSpacing() {
            return this.spacing;
        }
    }

    public static class FSSRupNodesCache
    implements RupNodesCache {
        private ConcurrentMap<Region, ConcurrentMap<Integer, int[]>> nodesMap = Maps.newConcurrentMap();
        private ConcurrentMap<Region, ConcurrentMap<Integer, double[]>> fractsMap = Maps.newConcurrentMap();

        @Override
        public int[] getNodesForRup(ProbEqkSource source, EqkRupture rup, int srcIndex, int rupIndex, GriddedRegion region) {
            RuptureSurface surf = rup.getRuptureSurface();
            if (surf instanceof CompoundSurface) {
                int[] nodes;
                int invIndex = CompoundFSSPlots.getInversionIndex(source);
                ConcurrentMap regMap = (ConcurrentMap)this.nodesMap.get(region);
                if (regMap == null) {
                    regMap = Maps.newConcurrentMap();
                    this.nodesMap.putIfAbsent(region, regMap);
                    ConcurrentMap fractMap = Maps.newConcurrentMap();
                    this.fractsMap.putIfAbsent(region, fractMap);
                    regMap = (ConcurrentMap)this.nodesMap.get(region);
                }
                if ((nodes = (int[])regMap.get(invIndex)) == null) {
                    ConcurrentMap fractMap = (ConcurrentMap)this.fractsMap.get(region);
                    ArrayList nodesList = Lists.newArrayList();
                    ArrayList fractsList = Lists.newArrayList();
                    LocationList surfLocs = surf.getEvenlyDiscritizedListOfLocsOnSurface();
                    double ptFract = 1.0 / (double)surfLocs.size();
                    for (Location loc : surfLocs) {
                        int index = region.indexForLocation(loc);
                        if (index < 0) continue;
                        int indexInList = nodesList.indexOf(index);
                        if (indexInList >= 0) {
                            fractsList.set(indexInList, (Double)fractsList.get(indexInList) + ptFract);
                            continue;
                        }
                        nodesList.add(index);
                        fractsList.add(ptFract);
                    }
                    nodes = Ints.toArray((Collection)nodesList);
                    double[] fracts = Doubles.toArray((Collection)fractsList);
                    regMap.putIfAbsent(invIndex, nodes);
                    fractMap.putIfAbsent(invIndex, fracts);
                }
                return nodes;
            }
            return null;
        }

        @Override
        public double[] getFractsInNodesForRup(ProbEqkSource source, EqkRupture rup, int srcIndex, int rupIndex, GriddedRegion region) {
            RuptureSurface surf = rup.getRuptureSurface();
            if (surf instanceof CompoundSurface) {
                int invIndex = CompoundFSSPlots.getInversionIndex(source);
                ConcurrentMap fractMap = (ConcurrentMap)this.fractsMap.get(region);
                double[] fracts = (double[])fractMap.get(invIndex);
                if (fracts == null) {
                    this.getNodesForRup(source, rup, srcIndex, rupIndex, region);
                    fracts = (double[])fractMap.get(invIndex);
                }
                return fracts;
            }
            return null;
        }
    }

    public static class GriddedParticipationMapPlot
    extends MapBasedPlot {
        private List<double[]> ranges;
        private double spacing;
        private List<List<GeoDataSet>> particDatas;
        private List<List<GeoDataSet>> nuclDatas;
        private List<Double> weights;
        private GriddedRegion griddedRegion;
        private transient Map<FaultModels, FSSRupNodesCache> rupNodesCache = Maps.newHashMap();
        private List<MapPlotData> plots;
        private transient U3BranchWeightProvider weightProvider;

        public static List<double[]> getDefaultRanges() {
            ArrayList ranges = Lists.newArrayList();
            ranges.add(GriddedParticipationMapPlot.toArray(5.0, 9.0));
            ranges.add(GriddedParticipationMapPlot.toArray(6.7, 9.0));
            ranges.add(GriddedParticipationMapPlot.toArray(7.7, 9.0));
            ranges.add(GriddedParticipationMapPlot.toArray(8.0, 9.0));
            return ranges;
        }

        private static double[] toArray(double ... vals) {
            return vals;
        }

        public GriddedParticipationMapPlot(U3BranchWeightProvider weightProvider) {
            this(weightProvider, 0.1);
        }

        public GriddedParticipationMapPlot(U3BranchWeightProvider weightProvider, double spacing) {
            this(weightProvider, GriddedParticipationMapPlot.getDefaultRanges(), spacing);
        }

        public GriddedParticipationMapPlot(U3BranchWeightProvider weightProvider, List<double[]> ranges, double spacing) {
            this.weightProvider = weightProvider;
            this.ranges = ranges;
            this.spacing = spacing;
            this.griddedRegion = new CaliforniaRegions.RELM_TESTING_GRIDDED(spacing);
            this.particDatas = Lists.newArrayList();
            this.nuclDatas = Lists.newArrayList();
            this.weights = Lists.newArrayList();
        }

        @Override
        protected String getPlotDataFileName() {
            return "gridded_participation_plots.xml";
        }

        @Override
        protected void processSolution(U3LogicTreeBranch branch, InversionFaultSystemSolution sol, int solIndex) {
            this.processERF(branch, new FaultSystemSolutionERF(sol), 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void processERF(U3LogicTreeBranch branch, FaultSystemSolutionERF erf, int solIndex) {
            double maxMag;
            double minMag;
            double[] range;
            int i;
            this.debug(solIndex, "cache check");
            FaultModels fm = branch.getValue(FaultModels.class);
            GriddedParticipationMapPlot griddedParticipationMapPlot = this;
            synchronized (griddedParticipationMapPlot) {
                if (!this.rupNodesCache.containsKey(fm)) {
                    FSSRupNodesCache cache = new FSSRupNodesCache();
                    this.rupNodesCache.put(fm, cache);
                }
            }
            this.debug(solIndex, "cache check done");
            FSSRupNodesCache cache = this.rupNodesCache.get(fm);
            ArrayList particData = Lists.newArrayList();
            ArrayList nuclData = Lists.newArrayList();
            for (i = 0; i < this.ranges.size(); ++i) {
                range = this.ranges.get(i);
                minMag = range[0];
                maxMag = range[1];
                this.debug(solIndex, "calc partic range " + i);
                particData.add(ERF_Calculator.getParticipationRatesInRegion(erf, this.griddedRegion, minMag, maxMag, cache));
                this.debug(solIndex, "done partic range " + i);
            }
            erf.getParameter("Background Seismicity").setValue(IncludeBackgroundOption.ONLY);
            erf.updateForecast();
            for (i = 0; i < this.ranges.size(); ++i) {
                range = this.ranges.get(i);
                minMag = range[0];
                maxMag = range[1];
                if (minMag > 5.0) break;
                this.debug(solIndex, "calc nucl range " + i);
                nuclData.add(ERF_Calculator.getNucleationRatesInRegion(erf, this.griddedRegion, minMag, maxMag, cache));
                this.debug(solIndex, "done nucl range " + i);
            }
            erf.getParameter("Background Seismicity").setValue(IncludeBackgroundOption.INCLUDE);
            erf.updateForecast();
            this.debug(solIndex, "archive");
            GriddedParticipationMapPlot griddedParticipationMapPlot2 = this;
            synchronized (griddedParticipationMapPlot2) {
                this.particDatas.add(particData);
                this.nuclDatas.add(nuclData);
                this.weights.add(this.weightProvider.getWeight(branch));
            }
            this.debug(solIndex, "archive done");
        }

        @Override
        protected void combineDistributedCalcs(Collection<CompoundFSSPlots> otherCalcs) {
            for (CompoundFSSPlots otherCalc : otherCalcs) {
                GriddedParticipationMapPlot o = (GriddedParticipationMapPlot)otherCalc;
                this.particDatas.addAll(o.particDatas);
                this.nuclDatas.addAll(o.nuclDatas);
                this.weights.addAll(o.weights);
            }
        }

        @Override
        protected void doFinalizePlot() {
            this.debug(-1, "Finalizing plot");
            boolean debug = false;
            this.plots = Lists.newArrayList();
            CPT particCPT = FaultBasedMapGen.getParticipationCPT().rescale(-5.0, -1.0);
            CPT nuclCPT = FaultBasedMapGen.getParticipationCPT().rescale(-6.0, -1.0);
            CPT ratioCPT = (CPT)FaultBasedMapGen.getLogRatioCPT().clone();
            ratioCPT.setNanColor(Color.WHITE);
            ratioCPT.setAboveMaxColor(Color.BLACK);
            MeanUCERF2 ucerf2 = new MeanUCERF2();
            ucerf2.setParameter("Probability Model", "Poisson");
            ucerf2.setParameter("Floater Type", "Only along strike ( rupture full DDW)");
            ucerf2.setParameter(UCERF2.BACK_SEIS_NAME, UCERF2.BACK_SEIS_INCLUDE);
            ucerf2.setParameter(UCERF2.BACK_SEIS_RUP_NAME, UCERF2.BACK_SEIS_RUP_POINT);
            ucerf2.getTimeSpan().setDuration(1.0);
            ucerf2.updateForecast();
            for (int c = 0; c < this.ranges.size() * 2; ++c) {
                String title;
                String name;
                int i;
                GeoDataSet data;
                CPT cpt;
                List<List<GeoDataSet>> datas;
                boolean nucleation = c >= this.ranges.size();
                int r = c % this.ranges.size();
                if (nucleation && r == 0) {
                    this.debug(-1, "Setting up UCERF2 comp erf for only back seis");
                    ucerf2.setParameter(UCERF2.BACK_SEIS_NAME, UCERF2.BACK_SEIS_ONLY);
                    ucerf2.updateForecast();
                }
                if (nucleation) {
                    datas = this.nuclDatas;
                    cpt = nuclCPT;
                } else {
                    datas = this.particDatas;
                    cpt = particCPT;
                }
                if (datas.get(0).size() <= r) {
                    this.debug(-1, "SKIPPING r=" + r + ", nucleation=" + nucleation);
                    continue;
                }
                this.debug(-1, "Building r=" + r + ", nucleation=" + nucleation);
                double[] range = this.ranges.get(r);
                double minMag = range[0];
                double maxMag = range[1];
                XY_DataSetList funcs = new XY_DataSetList();
                for (int i2 = 0; i2 < datas.size(); ++i2) {
                    data = datas.get(i2).get(r);
                    EvenlyDiscretizedFunc func = new EvenlyDiscretizedFunc(0.0, data.size(), 1.0);
                    for (int j = 0; j < data.size(); ++j) {
                        func.set(j, data.get(j));
                    }
                    funcs.add(func);
                }
                FractileCurveCalculator calc = new FractileCurveCalculator(funcs, this.weights);
                data = new GriddedGeoDataSet(this.griddedRegion, true);
                AbstractXY_DataSet meanDataFunc = calc.getMeanCurve();
                Preconditions.checkState((meanDataFunc.size() == ((GriddedGeoDataSet)data).size() ? 1 : 0) != 0);
                for (int i3 = 0; i3 < ((GriddedGeoDataSet)data).size(); ++i3) {
                    ((GriddedGeoDataSet)data).set(i3, meanDataFunc.getY(i3));
                }
                double[] weightsArray = Doubles.toArray(this.weights);
                data = new GriddedGeoDataSet(this.griddedRegion, true);
                for (i = 0; i < ((GriddedGeoDataSet)data).size(); ++i) {
                    double[] vals = new double[datas.size()];
                    for (int j = 0; j < datas.size(); ++j) {
                        vals[j] = datas.get(j).get(r).get(i);
                    }
                    ((GriddedGeoDataSet)data).set(i, U3FaultSystemSolutionFetcher.calcScaledAverage(vals, weightsArray));
                }
                if (debug && r == 0) {
                    for (i = 0; i < datas.size() && i < 10; ++i) {
                        GeoDataSet subData = datas.get(i).get(r).copy();
                        subData.log10();
                        this.plots.add(new MapPlotData(cpt, subData, this.spacing, (Region)this.griddedRegion, true, "Sub Participation 5+ " + i, "sub_partic_5+_" + i));
                    }
                }
                GriddedGeoDataSet logData = ((GriddedGeoDataSet)data).copy();
                logData.log10();
                if (nucleation) {
                    name = "gridded_sub_seis_nucl_rates_" + (float)minMag;
                    title = "Log10(Sub Seis Nucleation Rates " + (float)minMag;
                } else {
                    name = "gridded_partic_rates_" + (float)minMag;
                    title = "Log10(Participation Rates " + (float)minMag;
                }
                if (maxMag < 9.0) {
                    name = name + "_" + (float)maxMag;
                    title = title + "=>" + (float)maxMag;
                } else {
                    name = name + "+";
                    title = title + "+";
                }
                title = title + ")";
                MapPlotData plot = new MapPlotData(cpt, logData, true, title, name);
                plot.subDirName = "gridded_participation_plots";
                this.plots.add(plot);
                GriddedGeoDataSet ucerf2Vals = nucleation ? ERF_Calculator.getNucleationRatesInRegion(ucerf2, this.griddedRegion, range[0], range[1]) : ERF_Calculator.getParticipationRatesInRegion(ucerf2, this.griddedRegion, range[0], range[1]);
                GriddedGeoDataSet ucerf2LogVals = ucerf2Vals.copy();
                ucerf2LogVals.log10();
                if (nucleation) {
                    name = "gridded_sub_seis_nucl_rates_ucerf2_" + (float)minMag;
                    title = "Log10(UCERF2 Sub Seis Nucleation Rates " + (float)minMag;
                } else {
                    name = "gridded_partic_rates_ucerf2_" + (float)minMag;
                    title = "Log10(UCERF2 Participation Rates " + (float)minMag;
                }
                if (maxMag < 9.0) {
                    name = name + "_" + (float)maxMag;
                    title = title + "=>" + (float)maxMag;
                } else {
                    name = name + "+";
                    title = title + "+";
                }
                title = title + ")";
                plot = new MapPlotData(cpt, ucerf2LogVals, this.spacing, (Region)this.griddedRegion, true, title, name);
                plot.subDirName = "gridded_participation_plots";
                this.plots.add(plot);
                GeoDataSet ratios = GeoDataSetMath.divide(data, ucerf2Vals);
                ratios.log10();
                if (nucleation) {
                    name = "gridded_sub_seis_nucl_ratio_" + (float)minMag;
                    title = "Log10(Sub Seis Nucleation Ratios " + (float)minMag;
                } else {
                    name = "gridded_partic_ratio_" + (float)minMag;
                    title = "Log10(Participation Ratios " + (float)minMag;
                }
                if (maxMag < 9.0) {
                    name = name + "_" + (float)maxMag;
                    title = title + "=>" + (float)maxMag;
                } else {
                    name = name + "+";
                    title = title + "+";
                }
                title = title + ")";
                plot = new MapPlotData(ratioCPT, ratios, this.spacing, (Region)this.griddedRegion, true, title, name);
                plot.subDirName = "gridded_participation_plots";
                this.plots.add(plot);
            }
            this.debug(-1, "done finalizing");
        }

        @Override
        protected List<MapPlotData> getPlotData() {
            return this.plots;
        }

        @Override
        protected boolean usesERFs() {
            return true;
        }

        @Override
        protected boolean isApplyAftershockFilter() {
            return true;
        }
    }

    public static class TimeDepGriddedParticipationProbPlot
    extends MapBasedPlot {
        private List<double[]> ranges;
        private double spacing;
        private Map<Double, List<List<GeoDataSet>>> particDepDatas;
        private Map<Double, List<List<GeoDataSet>>> particIndepDatas;
        private Map<Double, List<Double>> weights;
        private Map<Double, List<GriddedGeoDataSet>> meanU2IndepDatas;
        private Map<Double, List<GriddedGeoDataSet>> meanU2DepDatas;
        private GriddedRegion griddedRegion;
        private transient Map<FaultModels, FSSRupNodesCache> rupNodesCache = Maps.newHashMap();
        private List<MapPlotData> plots;
        private static final double[] durations = time_dep_durations;
        private transient U3BranchWeightProvider weightProvider;

        public static List<double[]> getDefaultRanges() {
            ArrayList ranges = Lists.newArrayList();
            ranges.add(TimeDepGriddedParticipationProbPlot.toArray(5.0, 9.0));
            ranges.add(TimeDepGriddedParticipationProbPlot.toArray(6.7, 9.0));
            ranges.add(TimeDepGriddedParticipationProbPlot.toArray(7.7, 9.0));
            ranges.add(TimeDepGriddedParticipationProbPlot.toArray(8.0, 9.0));
            return ranges;
        }

        private static double[] toArray(double ... vals) {
            return vals;
        }

        public TimeDepGriddedParticipationProbPlot(U3BranchWeightProvider weightProvider) {
            this(weightProvider, 0.1);
        }

        public TimeDepGriddedParticipationProbPlot(U3BranchWeightProvider weightProvider, double spacing) {
            this(weightProvider, TimeDepGriddedParticipationProbPlot.getDefaultRanges(), spacing);
        }

        public TimeDepGriddedParticipationProbPlot(U3BranchWeightProvider weightProvider, List<double[]> ranges, double spacing) {
            this.weightProvider = weightProvider;
            this.ranges = ranges;
            this.spacing = spacing;
            this.griddedRegion = new CaliforniaRegions.RELM_TESTING_GRIDDED(spacing);
            this.particDepDatas = Maps.newHashMap();
            this.particIndepDatas = Maps.newHashMap();
            this.weights = Maps.newHashMap();
            this.meanU2DepDatas = Maps.newHashMap();
            this.meanU2IndepDatas = Maps.newHashMap();
            for (double duration : durations) {
                this.particDepDatas.put(duration, new ArrayList());
                this.particIndepDatas.put(duration, new ArrayList());
                this.weights.put(duration, new ArrayList());
            }
        }

        @Override
        protected String getPlotDataFileName() {
            return "gridded_participation_prob_plots.xml";
        }

        @Override
        protected void processSolution(U3LogicTreeBranch branch, InversionFaultSystemSolution sol, int solIndex) {
            this.processERF(branch, new FaultSystemSolutionERF(sol), 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void processERF(U3LogicTreeBranch branch, FaultSystemSolutionERF erf, int solIndex) {
            InversionFaultSystemRupSet rupSet = ((InversionFaultSystemSolution)erf.getSolution()).getRupSet();
            PolygonFaultGridAssociations polyManager = rupSet.getInversionTargetMFDs().getGridSeisUtils().getPolyMgr();
            this.debug(solIndex, "cache check");
            FaultModels fm = branch.getValue(FaultModels.class);
            TimeDepGriddedParticipationProbPlot timeDepGriddedParticipationProbPlot = this;
            synchronized (timeDepGriddedParticipationProbPlot) {
                if (!this.rupNodesCache.containsKey(fm)) {
                    FSSRupNodesCache cache = new FSSRupNodesCache();
                    this.rupNodesCache.put(fm, cache);
                }
            }
            this.debug(solIndex, "cache check done");
            FSSRupNodesCache cache = this.rupNodesCache.get(fm);
            double origDur = erf.getTimeSpan().getDuration();
            if (solIndex == 0) {
                this.calcUCERF2();
            }
            for (double duration : durations) {
                erf.setParameter("Background Seismicity", (Object)IncludeBackgroundOption.ONLY);
                erf.updateForecast();
                ArrayList subSeisData = Lists.newArrayList();
                for (int i = 0; i < this.ranges.size(); ++i) {
                    double[] range = this.ranges.get(i);
                    double minMag = range[0];
                    double maxMag = range[1];
                    this.debug(solIndex, "calc partic range " + i);
                    subSeisData.add(TimeDepGriddedParticipationProbPlot.getAsProbs(ERF_Calculator.getParticipationRatesInRegion(erf, this.griddedRegion, minMag, maxMag, cache), duration));
                    this.debug(solIndex, "done partic range " + i);
                }
                erf.setParameter("Background Seismicity", (Object)IncludeBackgroundOption.EXCLUDE);
                erf.getTimeSpan().setDuration(duration);
                erf.updateForecast();
                List<GeoDataSet> particDepData = this.calcProbsSupraSubSeis(polyManager, erf, subSeisData);
                erf.setParameter("Probability Model", (Object)ProbabilityModelOptions.POISSON);
                erf.getTimeSpan().setDuration(duration);
                erf.updateForecast();
                List<GeoDataSet> particIndepData = this.calcProbsSupraSubSeis(polyManager, erf, subSeisData);
                erf.getTimeSpan().setDuration(origDur);
                erf.setParameter("Probability Model", (Object)ProbabilityModelOptions.U3_PREF_BLEND);
                this.debug(solIndex, "archive");
                TimeDepGriddedParticipationProbPlot timeDepGriddedParticipationProbPlot2 = this;
                synchronized (timeDepGriddedParticipationProbPlot2) {
                    this.particDepDatas.get(duration).add(particDepData);
                    this.particIndepDatas.get(duration).add(particIndepData);
                    this.weights.get(duration).add(this.weightProvider.getWeight(branch));
                }
                this.debug(solIndex, "archive done");
            }
            erf.getTimeSpan().setDuration(origDur);
            erf.updateForecast();
        }

        private List<GeoDataSet> calcProbsSupraSubSeis(FaultGridAssociations polys, FaultSystemSolutionERF erf, List<GriddedGeoDataSet> subSeisProbs) {
            ArrayList datas = Lists.newArrayList();
            FaultSystemRupSet rupSet = erf.getSolution().getRupSet();
            for (int i = 0; i < this.ranges.size(); ++i) {
                double minMag = this.ranges.get(i)[0];
                double maxMag = this.ranges.get(i)[1];
                GriddedGeoDataSet subSeis = subSeisProbs.get(i);
                ArrayList nodeProbLists = Lists.newArrayList();
                for (int n = 0; n < subSeis.size(); ++n) {
                    nodeProbLists.add(Lists.newArrayList((Object[])new Double[]{subSeis.get(n)}));
                }
                for (int sourceID = 0; sourceID < erf.getNumFaultSystemSources(); ++sourceID) {
                    int invIndex = erf.getFltSysRupIndexForSource(sourceID);
                    for (ProbEqkRupture rup : erf.getSource(sourceID)) {
                        double mag = rup.getMag();
                        if (mag < minMag || mag > maxMag) continue;
                        double prob = rup.getProbability();
                        for (int s : rupSet.getSectionsIndicesForRup(invIndex)) {
                            Map<Integer, Double> nodeFracts = polys.getNodeFractions(s);
                            for (int n : nodeFracts.keySet()) {
                                ((List)nodeProbLists.get(n)).add(prob * nodeFracts.get(n));
                            }
                        }
                    }
                }
                GriddedGeoDataSet summed = new GriddedGeoDataSet(subSeis.getRegion(), subSeis.isLatitudeX());
                for (int n = 0; n < summed.size(); ++n) {
                    List nodeProbs = (List)nodeProbLists.get(n);
                    double prob = FaultSysSolutionERF_Calc.calcSummedProbs(nodeProbs);
                    summed.set(n, prob);
                }
                datas.add(summed);
            }
            return datas;
        }

        private void calcUCERF2() {
            MeanUCERF2 erf = new MeanUCERF2();
            for (double duration : durations) {
                Boolean[] booleanArray = new Boolean[]{true, false};
                int n = booleanArray.length;
                for (int i = 0; i < n; ++i) {
                    boolean timeDep = booleanArray[i];
                    if (timeDep) {
                        erf.setParameter("Probability Model", "WGCEP Preferred Blend");
                        erf.getTimeSpan().setDuration(duration);
                    } else {
                        erf.setParameter("Probability Model", "Poisson");
                        erf.getTimeSpan().setDuration(duration);
                    }
                    erf.updateForecast();
                    ArrayList datas = Lists.newArrayList();
                    for (int i2 = 0; i2 < this.ranges.size(); ++i2) {
                        double minMag = this.ranges.get(i2)[0];
                        double maxMag = this.ranges.get(i2)[1];
                        datas.add(TimeDepGriddedParticipationProbPlot.getAsProbs(ERF_Calculator.getParticipationRatesInRegion(erf, this.griddedRegion, minMag, maxMag, null), duration));
                    }
                    if (timeDep) {
                        this.meanU2DepDatas.put(duration, datas);
                        continue;
                    }
                    this.meanU2IndepDatas.put(duration, datas);
                }
            }
        }

        public static GriddedGeoDataSet getAsProbs(GriddedGeoDataSet ratesData, double duration) {
            GriddedGeoDataSet probsData = new GriddedGeoDataSet(ratesData.getRegion(), ratesData.isLatitudeX());
            for (int i = 0; i < ratesData.size(); ++i) {
                double rate = ratesData.get(i);
                double prob = 1.0 - Math.exp(-rate * duration);
                probsData.set(i, prob);
            }
            return probsData;
        }

        @Override
        protected void combineDistributedCalcs(Collection<CompoundFSSPlots> otherCalcs) {
            for (CompoundFSSPlots otherCalc : otherCalcs) {
                TimeDepGriddedParticipationProbPlot o = (TimeDepGriddedParticipationProbPlot)otherCalc;
                for (double duration : durations) {
                    this.particDepDatas.get(duration).addAll((Collection<List<GeoDataSet>>)o.particDepDatas.get(duration));
                    this.particIndepDatas.get(duration).addAll((Collection<List<GeoDataSet>>)o.particIndepDatas.get(duration));
                    this.weights.get(duration).addAll((Collection<Double>)o.weights.get(duration));
                }
                if (o.meanU2DepDatas.isEmpty()) continue;
                this.meanU2DepDatas.putAll(o.meanU2DepDatas);
                this.meanU2IndepDatas.putAll(o.meanU2IndepDatas);
            }
        }

        @Override
        protected void doFinalizePlot() {
            CPT ratioCPT;
            this.debug(-1, "Finalizing plot");
            boolean debug = false;
            this.plots = Lists.newArrayList();
            CPT particCPT = FaultBasedMapGen.getParticipationCPT().rescale(-5.0, 0.0);
            try {
                ratioCPT = FaultSysSolutionERF_Calc.getScaledLinearRatioCPT(0.02);
            }
            catch (IOException e) {
                throw ExceptionUtils.asRuntimeException(e);
            }
            ratioCPT.setNanColor(ratioCPT.getColor(1.0f));
            SimpleDateFormat df = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");
            for (double duration : durations) {
                for (int r = 0; r < this.ranges.size(); ++r) {
                    int i;
                    GeoDataSet data;
                    List<List<GeoDataSet>> depDatas = this.particDepDatas.get(duration);
                    List<List<GeoDataSet>> indepDatas = this.particIndepDatas.get(duration);
                    GriddedGeoDataSet meanU2DepData = this.meanU2DepDatas.get(duration).get(r);
                    GriddedGeoDataSet meanU2IndepData = this.meanU2IndepDatas.get(duration).get(r);
                    if (depDatas.get(0).size() <= r) {
                        this.debug(-1, "SKIPPING r=" + r);
                        continue;
                    }
                    this.debug(-1, "Building r=" + r);
                    double[] range = this.ranges.get(r);
                    double minMag = range[0];
                    double maxMag = range[1];
                    XY_DataSetList funcs = new XY_DataSetList();
                    for (int i2 = 0; i2 < depDatas.size(); ++i2) {
                        data = depDatas.get(i2).get(r);
                        EvenlyDiscretizedFunc func = new EvenlyDiscretizedFunc(0.0, data.size(), 1.0);
                        for (int j = 0; j < data.size(); ++j) {
                            func.set(j, data.get(j));
                        }
                        funcs.add(func);
                    }
                    FractileCurveCalculator calc = new FractileCurveCalculator(funcs, this.weights.get(duration));
                    data = new GriddedGeoDataSet(this.griddedRegion, true);
                    AbstractXY_DataSet meanDataFunc = calc.getMeanCurve();
                    Preconditions.checkState((meanDataFunc.size() == ((GriddedGeoDataSet)data).size() ? 1 : 0) != 0);
                    for (int i3 = 0; i3 < ((GriddedGeoDataSet)data).size(); ++i3) {
                        ((GriddedGeoDataSet)data).set(i3, meanDataFunc.getY(i3));
                    }
                    double[] weightsArray = Doubles.toArray((Collection)this.weights.get(duration));
                    data = new GriddedGeoDataSet(this.griddedRegion, true);
                    for (i = 0; i < ((GriddedGeoDataSet)data).size(); ++i) {
                        double[] vals = new double[depDatas.size()];
                        for (int j = 0; j < depDatas.size(); ++j) {
                            vals[j] = depDatas.get(j).get(r).get(i);
                        }
                        ((GriddedGeoDataSet)data).set(i, U3FaultSystemSolutionFetcher.calcScaledAverage(vals, weightsArray));
                    }
                    if (debug && r == 0) {
                        for (i = 0; i < depDatas.size() && i < 10; ++i) {
                            GeoDataSet subData = depDatas.get(i).get(r).copy();
                            subData.log10();
                            this.plots.add(new MapPlotData(particCPT, subData, this.spacing, (Region)this.griddedRegion, true, "Sub Participation 5+ " + i, "sub_partic_5+_" + i));
                        }
                    }
                    GriddedGeoDataSet logData = ((GriddedGeoDataSet)data).copy();
                    logData.log10();
                    String name = (int)duration + "_timedep_gridded_partic_prob_" + (float)minMag;
                    String title = "Log10(Time Dep Participation Probs " + (float)minMag;
                    if (maxMag < 9.0) {
                        name = name + "_" + (float)maxMag;
                        title = title + "=>" + (float)maxMag;
                    } else {
                        name = name + "+";
                        title = title + "+";
                    }
                    title = title + ")";
                    MapPlotData plot = new MapPlotData(particCPT, logData, true, title, name);
                    plot.subDirName = "gridded_time_dep_participation_prob_plots_" + (int)duration;
                    if (r == 0) {
                        plot.metadata = "ERF Based Time Dependend Gridded Participation Probability Plots\nGenerated on: " + df.format(new Date()) + "\nGenerated by: " + TimeDepGriddedParticipationProbPlot.class.getName() + "\nForecast Duration: " + (int)duration + "\n\nAll UCERF3 data INCLUDES aftershocks. UCERF2 data is from MeanUCERF2 and DOES NOT INCLUDE AFTERSHOCKS.\n\nUCERF3 data uses default BPT averaging method and UCERF3 Preferred Blend for the time dependence. This historical open interval is set as 2014 - 1875 = 139.\n\nUCERF3 fault probabilities are spread over their respective fault polygon (and UCERF2 faults are not).\n";
                    }
                    this.plots.add(plot);
                    funcs = new XY_DataSetList();
                    for (int i4 = 0; i4 < depDatas.size(); ++i4) {
                        GeoDataSet subData = indepDatas.get(i4).get(r);
                        EvenlyDiscretizedFunc func = new EvenlyDiscretizedFunc(0.0, subData.size(), 1.0);
                        for (int j = 0; j < subData.size(); ++j) {
                            func.set(j, subData.get(j));
                        }
                        funcs.add(func);
                    }
                    calc = new FractileCurveCalculator(funcs, this.weights.get(duration));
                    GriddedGeoDataSet indepVals = new GriddedGeoDataSet(this.griddedRegion, true);
                    meanDataFunc = calc.getMeanCurve();
                    Preconditions.checkState((meanDataFunc.size() == indepVals.size() ? 1 : 0) != 0);
                    for (int i5 = 0; i5 < indepVals.size(); ++i5) {
                        indepVals.set(i5, meanDataFunc.getY(i5));
                    }
                    GriddedGeoDataSet logIndepVals = indepVals.copy();
                    logIndepVals.log10();
                    name = (int)duration + "_timeindep_gridded_partic_prob_" + (float)minMag;
                    title = "Log10(Time Indep Participation Probs " + (float)minMag;
                    if (maxMag < 9.0) {
                        name = name + "_" + (float)maxMag;
                        title = title + "=>" + (float)maxMag;
                    } else {
                        name = name + "+";
                        title = title + "+";
                    }
                    title = title + ")";
                    plot = new MapPlotData(particCPT, logIndepVals, this.spacing, (Region)this.griddedRegion, true, title, name);
                    plot.subDirName = "gridded_time_dep_participation_prob_plots_" + (int)duration;
                    this.plots.add(plot);
                    GeoDataSet ratios = GeoDataSetMath.divide(data, indepVals);
                    name = (int)duration + "_gridded_partic_u3_ratio_" + (float)minMag;
                    title = "Time Dep/Indep Participation Prob Ratio " + (float)minMag;
                    if (maxMag < 9.0) {
                        name = name + "_" + (float)maxMag;
                        title = title + "=>" + (float)maxMag;
                    } else {
                        name = name + "+";
                        title = title + "+";
                    }
                    plot = new MapPlotData(ratioCPT, ratios, this.spacing, (Region)this.griddedRegion, true, title, name);
                    plot.subDirName = "gridded_time_dep_participation_prob_plots_" + (int)duration;
                    this.plots.add(plot);
                    GriddedGeoDataSet logU2DepVals = meanU2DepData.copy();
                    logU2DepVals.log10();
                    name = (int)duration + "_u2_timedep_gridded_partic_prob_" + (float)minMag;
                    title = "Log10(U2 Time Dep Participation Probs " + (float)minMag;
                    if (maxMag < 9.0) {
                        name = name + "_" + (float)maxMag;
                        title = title + "=>" + (float)maxMag;
                    } else {
                        name = name + "+";
                        title = title + "+";
                    }
                    title = title + ")";
                    plot = new MapPlotData(particCPT, logU2DepVals, this.spacing, (Region)this.griddedRegion, true, title, name);
                    plot.subDirName = "gridded_time_dep_participation_prob_plots_" + (int)duration;
                    this.plots.add(plot);
                    GriddedGeoDataSet logU2IndepVals = meanU2IndepData.copy();
                    logU2IndepVals.log10();
                    name = (int)duration + "_u2_timeindep_gridded_partic_prob_" + (float)minMag;
                    title = "Log10(U2 Time Indep Participation Probs " + (float)minMag;
                    if (maxMag < 9.0) {
                        name = name + "_" + (float)maxMag;
                        title = title + "=>" + (float)maxMag;
                    } else {
                        name = name + "+";
                        title = title + "+";
                    }
                    title = title + ")";
                    plot = new MapPlotData(particCPT, logU2IndepVals, this.spacing, (Region)this.griddedRegion, true, title, name);
                    plot.subDirName = "gridded_time_dep_participation_prob_plots_" + (int)duration;
                    this.plots.add(plot);
                    GeoDataSet u2Ratios = GeoDataSetMath.divide(meanU2DepData, meanU2IndepData);
                    name = (int)duration + "_gridded_partic_u2_ratio_" + (float)minMag;
                    title = "U2 Time Dep/Indep Participation Prob Ratio " + (float)minMag;
                    if (maxMag < 9.0) {
                        name = name + "_" + (float)maxMag;
                        title = title + "=>" + (float)maxMag;
                    } else {
                        name = name + "+";
                        title = title + "+";
                    }
                    plot = new MapPlotData(ratioCPT, u2Ratios, this.spacing, (Region)this.griddedRegion, true, title, name);
                    plot.subDirName = "gridded_time_dep_participation_prob_plots_" + (int)duration;
                    this.plots.add(plot);
                    GeoDataSet u3u2DepRatios = GeoDataSetMath.divide(data, meanU2DepData);
                    name = (int)duration + "_gridded_partic_u3_u2_dep_ratio_" + (float)minMag;
                    title = "Time Dep U3/U2 Participation Prob Ratio " + (float)minMag;
                    if (maxMag < 9.0) {
                        name = name + "_" + (float)maxMag;
                        title = title + "=>" + (float)maxMag;
                    } else {
                        name = name + "+";
                        title = title + "+";
                    }
                    plot = new MapPlotData(ratioCPT, u3u2DepRatios, this.spacing, (Region)this.griddedRegion, true, title, name);
                    plot.subDirName = "gridded_time_dep_participation_prob_plots_" + (int)duration;
                    this.plots.add(plot);
                    GeoDataSet u3u2IndepRatios = GeoDataSetMath.divide(indepVals, meanU2IndepData);
                    name = (int)duration + "_gridded_partic_u3_u2_indep_ratio_" + (float)minMag;
                    title = "Time Indep U3/U2 Participation Prob Ratio " + (float)minMag;
                    if (maxMag < 9.0) {
                        name = name + "_" + (float)maxMag;
                        title = title + "=>" + (float)maxMag;
                    } else {
                        name = name + "+";
                        title = title + "+";
                    }
                    plot = new MapPlotData(ratioCPT, u3u2IndepRatios, this.spacing, (Region)this.griddedRegion, true, title, name);
                    plot.subDirName = "gridded_time_dep_participation_prob_plots_" + (int)duration;
                    this.plots.add(plot);
                }
            }
            this.debug(-1, "done finalizing");
        }

        @Override
        protected List<MapPlotData> getPlotData() {
            return this.plots;
        }

        @Override
        protected boolean usesERFs() {
            return true;
        }

        @Override
        protected boolean isApplyAftershockFilter() {
            return false;
        }

        @Override
        protected boolean isTimeDependent() {
            return true;
        }
    }

    public static class ParticipationMapPlot
    extends MapBasedPlot {
        private List<double[]> ranges;
        private transient U3BranchWeightProvider weightProvider;
        private ConcurrentMap<FaultModels, List<LocationList>> faultsMap = Maps.newConcurrentMap();
        private Map<FaultModels, List<List<double[]>>> valuesMap = Maps.newHashMap();
        private Map<FaultModels, List<Double>> weightsMap = Maps.newHashMap();
        private List<MapPlotData> plots;

        public static List<double[]> getDefaultRanges() {
            ArrayList ranges = Lists.newArrayList();
            ranges.add(ParticipationMapPlot.toArray(5.0, 9.0));
            ranges.add(ParticipationMapPlot.toArray(6.7, 9.0));
            ranges.add(ParticipationMapPlot.toArray(7.7, 9.0));
            ranges.add(ParticipationMapPlot.toArray(8.0, 9.0));
            ranges.add(ParticipationMapPlot.toArray(6.5, 7.0));
            ranges.add(ParticipationMapPlot.toArray(7.0, 7.5));
            ranges.add(ParticipationMapPlot.toArray(7.5, 8.0));
            ranges.add(ParticipationMapPlot.toArray(8.0, 9.0));
            return ranges;
        }

        private static double[] toArray(double ... vals) {
            return vals;
        }

        public ParticipationMapPlot(U3BranchWeightProvider weightProvider) {
            this(weightProvider, ParticipationMapPlot.getDefaultRanges());
        }

        public ParticipationMapPlot(U3BranchWeightProvider weightProvider, List<double[]> ranges) {
            this.weightProvider = weightProvider;
            this.ranges = ranges;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void processSolution(U3LogicTreeBranch branch, InversionFaultSystemSolution sol, int solIndex) {
            double weight = this.weightProvider.getWeight(branch);
            if (weight == 0.0) {
                return;
            }
            this.debug(solIndex, "calculating");
            ArrayList myValues = Lists.newArrayList();
            for (double[] range : this.ranges) {
                myValues.add(sol.calcParticRateForAllSects(range[0], range[1]));
            }
            FaultModels fm = sol.getRupSet().getFaultModel();
            this.debug(solIndex, "trace building");
            if (!this.faultsMap.containsKey(fm)) {
                ArrayList<LocationList> faults = FaultBasedMapGen.getTraces(sol.getRupSet().getFaultSectionDataList());
                this.faultsMap.putIfAbsent(fm, faults);
            }
            this.debug(solIndex, "archiving");
            ParticipationMapPlot participationMapPlot = this;
            synchronized (participationMapPlot) {
                ArrayList valuesList = this.valuesMap.get(fm);
                if (valuesList == null) {
                    valuesList = Lists.newArrayList();
                    this.valuesMap.put(fm, valuesList);
                }
                valuesList.add(myValues);
                ArrayList weightsList = this.weightsMap.get(fm);
                if (weightsList == null) {
                    weightsList = Lists.newArrayList();
                    this.weightsMap.put(fm, weightsList);
                }
                weightsList.add(weight);
            }
            this.debug(solIndex, "done");
        }

        @Override
        protected void combineDistributedCalcs(Collection<CompoundFSSPlots> otherCalcs) {
            for (CompoundFSSPlots otherCalc : otherCalcs) {
                ParticipationMapPlot o = (ParticipationMapPlot)otherCalc;
                for (FaultModels fm : o.valuesMap.keySet()) {
                    if (!this.faultsMap.containsKey(fm)) {
                        this.faultsMap.put(fm, (List)o.faultsMap.get(fm));
                        this.valuesMap.put(fm, new ArrayList());
                        this.weightsMap.put(fm, new ArrayList());
                    }
                    this.valuesMap.get(fm).addAll((Collection<List<double[]>>)o.valuesMap.get(fm));
                    this.weightsMap.get(fm).addAll((Collection<Double>)o.weightsMap.get(fm));
                }
            }
        }

        @Override
        protected void doFinalizePlot() {
            this.plots = Lists.newArrayList();
            boolean multipleFMs = this.faultsMap.keySet().size() > 1;
            CPT participationCPT = FaultBasedMapGen.getParticipationCPT();
            CPT logCPT = FaultBasedMapGen.getLogRatioCPT();
            CaliforniaRegions.RELM_TESTING region = new CaliforniaRegions.RELM_TESTING();
            boolean skipNans = true;
            boolean omitInfinites = true;
            for (FaultModels fm : this.faultsMap.keySet()) {
                List faults = (List)this.faultsMap.get(fm);
                List<List<double[]>> valuesList = this.valuesMap.get(fm);
                List<Double> weightsList = this.weightsMap.get(fm);
                FaultSystemSolution ucerf2 = UCERF2_ComparisonSolutionFetcher.getUCERF2Solution(fm);
                for (int i = 0; i < this.ranges.size(); ++i) {
                    double minMag = this.ranges.get(i)[0];
                    double maxMag = this.ranges.get(i)[1];
                    ArrayList rangeValsList = Lists.newArrayList();
                    for (int s = 0; s < valuesList.size(); ++s) {
                        rangeValsList.add(valuesList.get(s).get(i));
                    }
                    double[] values = new double[faults.size()];
                    double[] stdDevs = new double[values.length];
                    for (int s = 0; s < values.length; ++s) {
                        ArbDiscrEmpiricalDistFunc func = new ArbDiscrEmpiricalDistFunc();
                        for (int j = 0; j < weightsList.size(); ++j) {
                            func.set(((double[])rangeValsList.get(j))[s], (double)weightsList.get(j));
                        }
                        stdDevs[s] = func.getStdDev();
                        values[s] = func.getMean();
                    }
                    double[] logValues = FaultBasedMapGen.log10(values);
                    String name = "partic_rates_" + (float)minMag;
                    String title = "Log10(Participation Rates " + (float)minMag;
                    if (maxMag < 9.0) {
                        name = name + "_" + (float)maxMag;
                        title = title + "=>" + (float)maxMag;
                    } else {
                        name = name + "+";
                        title = title + "+";
                    }
                    title = title + ")";
                    if (multipleFMs) {
                        name = fm.getShortName() + "_" + name;
                        title = fm.getShortName() + " " + title;
                    }
                    MapPlotData plot = new MapPlotData(participationCPT, faults, logValues, (Region)region, skipNans, title, name);
                    plot.subDirName = "fault_participation_plots";
                    this.plots.add(plot);
                    double[] ucerf2Vals = ucerf2.calcParticRateForAllSects(minMag, maxMag);
                    double[] ratios = new double[ucerf2Vals.length];
                    for (int j = 0; j < values.length; ++j) {
                        ratios[j] = values[j] / ucerf2Vals[j];
                        if (!omitInfinites || !Double.isInfinite(ratios[j])) continue;
                        ratios[j] = Double.NaN;
                    }
                    ratios = FaultBasedMapGen.log10(ratios);
                    name = "partic_ratio_" + (float)minMag;
                    title = "Log10(Participation Ratios " + (float)minMag;
                    if (maxMag < 9.0) {
                        name = name + "_" + (float)maxMag;
                        title = title + "=>" + (float)maxMag;
                    } else {
                        name = name + "+";
                        title = title + "+";
                    }
                    title = title + ")";
                    if (multipleFMs) {
                        name = fm.getShortName() + "_" + name;
                        title = fm.getShortName() + " " + title;
                    }
                    plot = new MapPlotData(logCPT, faults, ratios, (Region)region, skipNans, title, name);
                    plot.subDirName = "fault_participation_plots";
                    this.plots.add(plot);
                    double[] stdNormVals = new double[values.length];
                    for (int s = 0; s < stdNormVals.length; ++s) {
                        stdNormVals[s] = ucerf2Vals[s] == 0.0 ? Double.NaN : (values[s] - ucerf2Vals[s]) / stdDevs[s];
                    }
                    name = "partic_diffs_norm_std_dev_" + (float)minMag;
                    title = "(U3mean - U2mean)/U3std " + (float)minMag;
                    if (maxMag < 9.0) {
                        name = name + "_" + (float)maxMag;
                        title = title + "=>" + (float)maxMag;
                    } else {
                        name = name + "+";
                        title = title + "+";
                    }
                    if (multipleFMs) {
                        name = fm.getShortName() + "_" + name;
                        title = fm.getShortName() + " " + title;
                    }
                    plot = new MapPlotData(logCPT, faults, stdNormVals, (Region)region, skipNans, title, name);
                    plot.subDirName = "fault_participation_plots";
                    this.plots.add(plot);
                }
            }
        }

        @Override
        protected List<MapPlotData> getPlotData() {
            return this.plots;
        }

        @Override
        protected String getPlotDataFileName() {
            return "participation_plots.xml";
        }
    }

    public static class MultiFaultParticPlot
    extends MapBasedPlot {
        private static final long serialVersionUID = 1L;
        public static final String PLOT_DATA_FILE_NAME = "multi_fault_rates.xml";
        public static final String SUB_DIR_NAME = "multi_fault_partics";
        private static final double minMag = 6.7;
        private transient U3BranchWeightProvider weightProvider;
        private ConcurrentMap<FaultModels, List<LocationList>> faultsMap = Maps.newConcurrentMap();
        private ConcurrentMap<FaultModels, Map<Integer, int[]>> sectsByParentsMap = Maps.newConcurrentMap();
        private ConcurrentMap<FaultModels, Map<Integer, int[]>> parentsByParentsMap = Maps.newConcurrentMap();
        private ConcurrentMap<Integer, String> parentNamesMap = Maps.newConcurrentMap();
        private ConcurrentMap<FaultModels, Map<Integer, List<Integer>>> rupsForParentsMap = Maps.newConcurrentMap();
        private Map<FaultModels, List<Map<Integer, double[]>>> ratesMap = Maps.newHashMap();
        private Map<FaultModels, List<Double>> weightsMap = Maps.newHashMap();
        private List<MapPlotData> plots;
        private static int cnt;

        public MultiFaultParticPlot(U3BranchWeightProvider weightProvider) {
            this.weightProvider = weightProvider;
            cnt = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void processSolution(U3LogicTreeBranch branch, InversionFaultSystemSolution sol, int solIndex) {
            double weight;
            int myCnt = cnt++;
            this.debug(solIndex, "Processing solution " + myCnt);
            InversionFaultSystemRupSet rupSet = sol.getRupSet();
            FaultModels fm = rupSet.getFaultModel();
            this.debug(solIndex, "cache fetching");
            Map sectsByParents = (Map)this.sectsByParentsMap.get(fm);
            if (sectsByParents == null) {
                MultiFaultParticPlot multiFaultParticPlot = this;
                synchronized (multiFaultParticPlot) {
                    if (sectsByParents == null) {
                        sectsByParents = Maps.newHashMap();
                        HashSet<Integer> parentsSet = new HashSet<Integer>();
                        for (FaultSection faultSection : rupSet.getFaultSectionDataList()) {
                            parentsSet.add(faultSection.getParentSectionId());
                            this.parentNamesMap.putIfAbsent(faultSection.getParentSectionId(), faultSection.getParentSectionName());
                        }
                        HashMap rupsForParents = Maps.newHashMap();
                        HashMap hashMap = Maps.newHashMap();
                        for (Integer parentID : parentsSet) {
                            HashSet<Integer> subSectsSet = new HashSet<Integer>();
                            HashSet<Integer> parentsByParentsSet = new HashSet<Integer>();
                            List<Integer> rups = rupSet.getRupturesForParentSection(parentID);
                            rupsForParents.put(parentID, rups);
                            for (Integer rupID : rups) {
                                for (Integer sectIndex : rupSet.getSectionsIndicesForRup(rupID)) {
                                    subSectsSet.add(sectIndex);
                                    parentsByParentsSet.add(rupSet.getFaultSectionData(sectIndex).getParentSectionId());
                                }
                            }
                            ArrayList subSects = Lists.newArrayList(subSectsSet);
                            Collections.sort(subSects);
                            sectsByParents.put(parentID, Ints.toArray((Collection)subSects));
                            ArrayList parentsByParentsList = Lists.newArrayList(parentsByParentsSet);
                            Collections.sort(parentsByParentsList);
                            hashMap.put(parentID, Ints.toArray((Collection)parentsByParentsList));
                        }
                        this.rupsForParentsMap.put(fm, rupsForParents);
                        this.parentsByParentsMap.put(fm, hashMap);
                        this.sectsByParentsMap.put(fm, sectsByParents);
                    }
                }
                sectsByParents = (Map)this.sectsByParentsMap.get(fm);
            }
            if ((weight = this.weightProvider.getWeight(branch)) == 0.0) {
                return;
            }
            this.debug(solIndex, "calculating");
            Map rupsMap = (Map)this.rupsForParentsMap.get(fm);
            HashMap hashMap = Maps.newHashMap();
            for (Integer parentID : sectsByParents.keySet()) {
                int[] sectsInvolved = (int[])sectsByParents.get(parentID);
                double[] parentRates = new double[sectsInvolved.length];
                for (Integer rupID : (List)rupsMap.get(parentID)) {
                    if (rupSet.getMagForRup(rupID) < 6.7) continue;
                    double rate = sol.getRateForRup(rupID);
                    for (int sectID : rupSet.getSectionsIndicesForRup(rupID)) {
                        int sectIndexInArray;
                        int n = sectIndexInArray = Arrays.binarySearch(sectsInvolved, sectID);
                        parentRates[n] = parentRates[n] + rate;
                    }
                }
                hashMap.put(parentID, parentRates);
            }
            if (!this.faultsMap.containsKey(fm)) {
                ArrayList<LocationList> faults = FaultBasedMapGen.getTraces(rupSet.getFaultSectionDataList());
                this.faultsMap.putIfAbsent(fm, faults);
            }
            this.debug(solIndex, "Archiving solution " + myCnt);
            MultiFaultParticPlot multiFaultParticPlot = this;
            synchronized (multiFaultParticPlot) {
                ArrayList ratesList = this.ratesMap.get(fm);
                if (ratesList == null) {
                    ratesList = Lists.newArrayList();
                    this.ratesMap.put(fm, ratesList);
                }
                ratesList.add(hashMap);
                ArrayList weightsList = this.weightsMap.get(fm);
                if (weightsList == null) {
                    weightsList = Lists.newArrayList();
                    this.weightsMap.put(fm, weightsList);
                }
                weightsList.add(weight);
            }
            this.debug(solIndex, "Done with solution " + myCnt);
        }

        @Override
        protected void combineDistributedCalcs(Collection<CompoundFSSPlots> otherCalcs) {
            for (CompoundFSSPlots otherCalc : otherCalcs) {
                MultiFaultParticPlot o = (MultiFaultParticPlot)otherCalc;
                for (FaultModels fm : o.ratesMap.keySet()) {
                    if (!this.faultsMap.containsKey(fm)) {
                        this.faultsMap.put(fm, (List)o.faultsMap.get(fm));
                        this.sectsByParentsMap.put(fm, (Map)o.sectsByParentsMap.get(fm));
                        this.parentsByParentsMap.put(fm, (Map)o.parentsByParentsMap.get(fm));
                        this.parentNamesMap.putAll(o.parentNamesMap);
                        this.ratesMap.put(fm, new ArrayList());
                        this.weightsMap.put(fm, new ArrayList());
                    }
                    this.ratesMap.get(fm).addAll((Collection<Map<Integer, double[]>>)o.ratesMap.get(fm));
                    this.weightsMap.get(fm).addAll((Collection<Double>)o.weightsMap.get(fm));
                }
            }
        }

        @Override
        protected void doFinalizePlot() {
            CPT cpt;
            this.plots = Lists.newArrayList();
            boolean multipleFMs = this.faultsMap.keySet().size() > 1;
            try {
                cpt = GMT_CPT_Files.MAX_SPECTRUM.instance().rescale(-10.0, -2.0);
            }
            catch (IOException e) {
                throw ExceptionUtils.asRuntimeException(e);
            }
            cpt.setNanColor(Color.GRAY);
            CaliforniaRegions.RELM_TESTING region = new CaliforniaRegions.RELM_TESTING();
            boolean skipNans = false;
            ArrayList fmList = Lists.newArrayList(this.faultsMap.keySet());
            for (int f = 0; f < fmList.size(); ++f) {
                FaultModels fm = (FaultModels)fmList.get(f);
                List faults = (List)this.faultsMap.get(fm);
                List<Map<Integer, double[]>> ratesList = this.ratesMap.get(fm);
                ArrayList weightsList = this.weightsMap.get(fm);
                Map sectsByParents = (Map)this.sectsByParentsMap.get(fm);
                Map<Integer, FaultSection> parentSectsMap = fm.getFaultSectionIDMap();
                for (Integer parentID : ratesList.get(0).keySet()) {
                    int i;
                    if (!parentSectsMap.containsKey(parentID)) continue;
                    int[] sectsInvolved = (int[])sectsByParents.get(parentID);
                    ArrayList solRates = Lists.newArrayList();
                    for (Map<Integer, double[]> solRatesMap : ratesList) {
                        solRates.add(solRatesMap.get(parentID));
                    }
                    ArrayList myWeightsList = weightsList;
                    boolean comboFM = false;
                    String parentName = (String)this.parentNamesMap.get(parentID);
                    if (f == 0 && fmList.size() > 1) {
                        int[] parentsByParent = (int[])((Map)this.parentsByParentsMap.get(fm)).get(parentID);
                        boolean match = true;
                        for (i = 1; i < fmList.size(); ++i) {
                            int[] otherParentsByParent = (int[])((Map)this.parentsByParentsMap.get(fmList.get(i))).get(parentID);
                            if (otherParentsByParent != null && Arrays.equals(parentsByParent, otherParentsByParent)) continue;
                            match = false;
                            break;
                        }
                        if (match) {
                            comboFM = true;
                            myWeightsList = Lists.newArrayList(myWeightsList);
                            for (i = 1; i < fmList.size(); ++i) {
                                FaultModels ofm = (FaultModels)fmList.get(i);
                                myWeightsList.addAll((Collection)this.weightsMap.get(ofm));
                                for (Map<Integer, double[]> solRatesMap : this.ratesMap.get(ofm)) {
                                    solRates.add(solRatesMap.remove(parentID));
                                }
                            }
                        }
                    }
                    double[] rates = this.getWeightedAvg(sectsInvolved.length, solRates, weightsList);
                    double[] allRates = new double[faults.size() + 1];
                    for (i = 0; i < allRates.length; ++i) {
                        allRates[i] = Double.NaN;
                    }
                    for (i = 0; i < sectsInvolved.length; ++i) {
                        int sectIndex = sectsInvolved[i];
                        allRates[sectIndex] = rates[i];
                    }
                    allRates = FaultBasedMapGen.log10(allRates);
                    ArrayList myFaults = Lists.newArrayList((Iterable)faults);
                    myFaults.add(parentSectsMap.get(parentID).getFaultTrace());
                    allRates[allRates.length - 1] = -1.23456E25;
                    String label = (String)this.parentNamesMap.get(parentID) + " (" + parentID + ")";
                    Object prefix = parentName.replaceAll("\\W+", "_");
                    if (!comboFM) {
                        label = fm.getShortName() + " " + label;
                        prefix = (String)prefix + "_" + fm.getShortName();
                    }
                    MapPlotData plot = new MapPlotData(cpt, myFaults, allRates, (Region)region, skipNans, label, (String)prefix);
                    plot.subDirName = SUB_DIR_NAME;
                    this.plots.add(plot);
                }
            }
        }

        @Override
        protected List<MapPlotData> getPlotData() {
            return this.plots;
        }

        @Override
        protected String getPlotDataFileName() {
            return PLOT_DATA_FILE_NAME;
        }
    }

    public static class AveSlipMapPlot
    extends MapBasedPlot {
        private static final long serialVersionUID = 1L;
        public static final String PLOT_DATA_FILE_NAME = "ave_slip_plots.xml";
        private transient U3BranchWeightProvider weightProvider;
        private ConcurrentMap<FaultModels, List<LocationList>> faultsMap = Maps.newConcurrentMap();
        private Map<FaultModels, List<double[]>> aveSlipsMap = Maps.newHashMap();
        private Map<FaultModels, List<double[]>> avePaleoSlipsMap = Maps.newHashMap();
        private Map<FaultModels, List<Double>> weightsMap = Maps.newHashMap();
        private List<MapPlotData> plots;
        private static int cnt;

        public AveSlipMapPlot(U3BranchWeightProvider weightProvider) {
            this.weightProvider = weightProvider;
            cnt = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void processSolution(U3LogicTreeBranch branch, InversionFaultSystemSolution sol, int solIndex) {
            InversionFaultSystemRupSet rupSet = sol.getRupSet();
            int myCnt = cnt++;
            this.debug(solIndex, "Processing solution " + myCnt);
            double weight = this.weightProvider.getWeight(branch);
            if (weight == 0.0) {
                return;
            }
            FaultModels fm = rupSet.getFaultModel();
            double[] aveSlips = new double[rupSet.getNumSections()];
            double[] avePaleoSlips = new double[rupSet.getNumSections()];
            for (int i = 0; i < aveSlips.length; ++i) {
                aveSlips[i] = sol.calcSlipPFD_ForSect(i).getMean();
                avePaleoSlips[i] = sol.calcPaleoObsSlipPFD_ForSect(i).getMean();
            }
            if (!this.faultsMap.containsKey(fm)) {
                ArrayList<LocationList> faults = FaultBasedMapGen.getTraces(rupSet.getFaultSectionDataList());
                this.faultsMap.putIfAbsent(fm, faults);
            }
            this.debug(solIndex, "Archiving solution " + myCnt);
            AveSlipMapPlot aveSlipMapPlot = this;
            synchronized (aveSlipMapPlot) {
                ArrayList aveSlipsList = this.aveSlipsMap.get(fm);
                if (aveSlipsList == null) {
                    aveSlipsList = Lists.newArrayList();
                    this.aveSlipsMap.put(fm, aveSlipsList);
                }
                aveSlipsList.add(aveSlips);
                ArrayList avePaleoSlipsList = this.avePaleoSlipsMap.get(fm);
                if (avePaleoSlipsList == null) {
                    avePaleoSlipsList = Lists.newArrayList();
                    this.avePaleoSlipsMap.put(fm, avePaleoSlipsList);
                }
                avePaleoSlipsList.add(avePaleoSlips);
                ArrayList weightsList = this.weightsMap.get(fm);
                if (weightsList == null) {
                    weightsList = Lists.newArrayList();
                    this.weightsMap.put(fm, weightsList);
                }
                weightsList.add(weight);
            }
            this.debug(solIndex, "Done with solution " + myCnt);
        }

        @Override
        protected void combineDistributedCalcs(Collection<CompoundFSSPlots> otherCalcs) {
            for (CompoundFSSPlots otherCalc : otherCalcs) {
                AveSlipMapPlot o = (AveSlipMapPlot)otherCalc;
                for (FaultModels fm : o.aveSlipsMap.keySet()) {
                    if (!this.faultsMap.containsKey(fm)) {
                        this.faultsMap.put(fm, (List)o.faultsMap.get(fm));
                        this.aveSlipsMap.put(fm, new ArrayList());
                        this.avePaleoSlipsMap.put(fm, new ArrayList());
                        this.weightsMap.put(fm, new ArrayList());
                    }
                    this.aveSlipsMap.get(fm).addAll((Collection<double[]>)o.aveSlipsMap.get(fm));
                    this.avePaleoSlipsMap.get(fm).addAll((Collection<double[]>)o.avePaleoSlipsMap.get(fm));
                    this.weightsMap.get(fm).addAll((Collection<Double>)o.weightsMap.get(fm));
                }
            }
        }

        @Override
        protected void doFinalizePlot() {
            CPT cpt;
            this.plots = Lists.newArrayList();
            boolean multipleFMs = this.faultsMap.keySet().size() > 1;
            try {
                cpt = GMT_CPT_Files.MAX_SPECTRUM.instance().rescale(0.0, 8.0);
            }
            catch (IOException e) {
                throw ExceptionUtils.asRuntimeException(e);
            }
            CaliforniaRegions.RELM_TESTING region = new CaliforniaRegions.RELM_TESTING();
            boolean skipNans = false;
            for (FaultModels fm : this.faultsMap.keySet()) {
                List faults = (List)this.faultsMap.get(fm);
                List<double[]> aveSlipsList = this.aveSlipsMap.get(fm);
                List<Double> weightsList = this.weightsMap.get(fm);
                double[] ratios = this.getWeightedAvg(faults.size(), aveSlipsList, weightsList);
                Object label = "Average Slip (m)";
                Object prefix = "";
                if (multipleFMs) {
                    prefix = (String)prefix + fm.getShortName() + "_";
                    label = fm.getShortName() + " " + (String)label;
                }
                MapPlotData plot = new MapPlotData(cpt, faults, ratios, (Region)region, skipNans, (String)label, (String)prefix + "ave_slip");
                plot.subDirName = "ave_slip_plots";
                this.plots.add(plot);
                List<double[]> avePaleoSlipsList = this.avePaleoSlipsMap.get(fm);
                double[] fractDiffs = this.getWeightedAvg(faults.size(), avePaleoSlipsList, weightsList);
                label = "Paleo Observable Average Slip (m)";
                prefix = "";
                if (multipleFMs) {
                    prefix = (String)prefix + fm.getShortName() + "_";
                    label = fm.getShortName() + " " + (String)label;
                }
                plot = new MapPlotData(cpt, faults, fractDiffs, (Region)region, skipNans, (String)label, (String)prefix + "ave_paleo_obs_slip");
                plot.subDirName = "ave_slip_plots";
                this.plots.add(plot);
            }
        }

        @Override
        protected List<MapPlotData> getPlotData() {
            return this.plots;
        }

        @Override
        protected String getPlotDataFileName() {
            return PLOT_DATA_FILE_NAME;
        }
    }

    public static class SlipRatePlots
    extends MapBasedPlot {
        private static final long serialVersionUID = 1L;
        public static final String PLOT_DATA_FILE_NAME = "slip_misfit_plots.xml";
        private transient U3BranchWeightProvider weightProvider;
        private ConcurrentMap<FaultModels, List<? extends FaultSection>> sectDatasMap = Maps.newConcurrentMap();
        private ConcurrentMap<FaultModels, Map<String, List<Integer>>> parentSectsMap = Maps.newConcurrentMap();
        private Map<FaultModels, List<double[]>> solSlipsMap = Maps.newHashMap();
        private Map<FaultModels, List<double[]>> targetSlipsMap = Maps.newHashMap();
        private Map<FaultModels, List<Double>> weightsMap = Maps.newHashMap();
        private List<MapPlotData> plots;
        private static int cnt;
        private Map<FaultModels, CSVFile<String>> subSectCSVs = Maps.newHashMap();
        private Map<FaultModels, CSVFile<String>> parentSectCSVs = Maps.newHashMap();

        public SlipRatePlots(U3BranchWeightProvider weightProvider) {
            this.weightProvider = weightProvider;
            cnt = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void processSolution(U3LogicTreeBranch branch, InversionFaultSystemSolution sol, int solIndex) {
            InversionFaultSystemRupSet rupSet = sol.getRupSet();
            int myCnt = cnt++;
            this.debug(solIndex, "Processing solution " + myCnt);
            double weight = this.weightProvider.getWeight(branch);
            if (weight == 0.0) {
                return;
            }
            double[] solSlips = sol.calcSlipRateForAllSects();
            double[] targetSlips = rupSet.getSlipRateForAllSections();
            FaultModels fm = rupSet.getFaultModel();
            if (!this.sectDatasMap.containsKey(fm)) {
                this.sectDatasMap.putIfAbsent(fm, rupSet.getFaultSectionDataList());
            }
            if (!this.parentSectsMap.containsKey(fm)) {
                HashMap parentsMap = Maps.newHashMap();
                ArrayList sects = Lists.newArrayList();
                String prevParentName = rupSet.getFaultSectionData(0).getParentSectionName();
                for (int sectIndex = 0; sectIndex < rupSet.getNumSections(); ++sectIndex) {
                    String parentName = rupSet.getFaultSectionData(sectIndex).getParentSectionName();
                    if (!parentName.equals(prevParentName)) {
                        parentsMap.put(prevParentName, sects);
                        prevParentName = parentName;
                        sects = Lists.newArrayList();
                    }
                    sects.add(sectIndex);
                }
                if (!sects.isEmpty()) {
                    parentsMap.put(prevParentName, sects);
                }
                this.parentSectsMap.putIfAbsent(fm, parentsMap);
            }
            this.debug(solIndex, "Archiving solution " + myCnt);
            SlipRatePlots slipRatePlots = this;
            synchronized (slipRatePlots) {
                ArrayList solSlipsList = this.solSlipsMap.get(fm);
                if (solSlipsList == null) {
                    solSlipsList = Lists.newArrayList();
                    this.solSlipsMap.put(fm, solSlipsList);
                }
                solSlipsList.add(solSlips);
                ArrayList targetsList = this.targetSlipsMap.get(fm);
                if (targetsList == null) {
                    targetsList = Lists.newArrayList();
                    this.targetSlipsMap.put(fm, targetsList);
                }
                targetsList.add(targetSlips);
                ArrayList weightsList = this.weightsMap.get(fm);
                if (weightsList == null) {
                    weightsList = Lists.newArrayList();
                    this.weightsMap.put(fm, weightsList);
                }
                weightsList.add(weight);
            }
            this.debug(solIndex, "Done with solution " + myCnt);
        }

        @Override
        protected void combineDistributedCalcs(Collection<CompoundFSSPlots> otherCalcs) {
            for (CompoundFSSPlots otherCalc : otherCalcs) {
                SlipRatePlots o = (SlipRatePlots)otherCalc;
                for (FaultModels fm : o.weightsMap.keySet()) {
                    if (!this.sectDatasMap.containsKey(fm)) {
                        this.sectDatasMap.put(fm, (List)o.sectDatasMap.get(fm));
                        this.parentSectsMap.put(fm, (Map)o.parentSectsMap.get(fm));
                        this.solSlipsMap.put(fm, new ArrayList());
                        this.targetSlipsMap.put(fm, new ArrayList());
                        this.weightsMap.put(fm, new ArrayList());
                    }
                    this.solSlipsMap.get(fm).addAll((Collection<double[]>)o.solSlipsMap.get(fm));
                    this.targetSlipsMap.get(fm).addAll((Collection<double[]>)o.targetSlipsMap.get(fm));
                    this.weightsMap.get(fm).addAll((Collection<Double>)o.weightsMap.get(fm));
                }
            }
        }

        private static double meanFromIndexes(double[] array, List<Integer> indexes) {
            DataUtils.MinMaxAveTracker track = new DataUtils.MinMaxAveTracker();
            for (int index : indexes) {
                track.addValue(array[index]);
            }
            return track.getAverage();
        }

        @Override
        protected void doFinalizePlot() {
            this.plots = Lists.newArrayList();
            boolean multipleFMs = this.sectDatasMap.keySet().size() > 1;
            CPT linearCPT = FaultBasedMapGen.getLinearRatioCPT();
            CPT logCPT = FaultBasedMapGen.getLogRatioCPT().rescale(-1.0, 1.0);
            CPT slipRateCPT = FaultBasedMapGen.getSlipRateCPT();
            CaliforniaRegions.RELM_TESTING region = new CaliforniaRegions.RELM_TESTING();
            boolean skipNans = false;
            for (FaultModels fm : this.sectDatasMap.keySet()) {
                Object sect2;
                List sectDatas = (List)this.sectDatasMap.get(fm);
                ArrayList<LocationList> faults = FaultBasedMapGen.getTraces(sectDatas);
                List<double[]> solSlipsList = this.solSlipsMap.get(fm);
                List<double[]> targetsList = this.targetSlipsMap.get(fm);
                List<Double> weightsList = this.weightsMap.get(fm);
                double[] solSlips = this.getWeightedAvg(faults.size(), solSlipsList, weightsList);
                double[] solSlipMins = this.getMins(faults.size(), solSlipsList);
                double[] solSlipMaxs = this.getMaxs(faults.size(), solSlipsList);
                double[] targets = this.getWeightedAvg(faults.size(), targetsList, weightsList);
                double[] targetMins = this.getMins(faults.size(), targetsList);
                double[] targetMaxs = this.getMaxs(faults.size(), targetsList);
                double[] ratios = new double[solSlips.length];
                for (int i = 0; i < ratios.length; ++i) {
                    ratios[i] = solSlips[i] / targets[i];
                }
                CSVFile<String> subSectCSV = new CSVFile<String>(true);
                subSectCSV.addLine("Sub Section Index", "Parent Section ID", "Mean Target Slip Rate (m/yr)", "Min Target Slip Rate (m/yr)", "Max Target Slip Rate (m/yr)", "Mean Solution Slip Rate (m/yr)", "Min Solution Slip Rate (m/yr)", "Max Solution Slip Rate (m/yr)", "Mean Slip Rate Misfit Ratio");
                for (int sectIndex = 0; sectIndex < solSlips.length; ++sectIndex) {
                    subSectCSV.addLine("" + sectIndex, "" + ((FaultSection)sectDatas.get(sectIndex)).getParentSectionId(), "" + targets[sectIndex], "" + targetMins[sectIndex], "" + targetMaxs[sectIndex], "" + solSlips[sectIndex], "" + solSlipMins[sectIndex], "" + solSlipMaxs[sectIndex], "" + ratios[sectIndex]);
                }
                this.subSectCSVs.put(fm, subSectCSV);
                CSVFile<String> parentSectCSV = new CSVFile<String>(true);
                HashMap parentNamesMap = Maps.newHashMap();
                for (Object sect2 : sectDatas) {
                    parentNamesMap.put(sect2.getParentSectionId(), sect2.getParentSectionName());
                }
                ArrayList parentIDs = Lists.newArrayList(parentNamesMap.keySet());
                Collections.sort(parentIDs);
                parentSectCSV.addLine("Parent Section ID", "Parent Section Name", "Mean Target Slip Rate (m/yr)", "Min Target Slip Rate (m/yr)", "Max Target Slip Rate (m/yr)", "Mean Solution Slip Rate (m/yr)", "Min Solution Slip Rate (m/yr)", "Max Solution Slip Rate (m/yr)", "Mean Slip Rate Misfit Ratio");
                sect2 = parentIDs.iterator();
                while (sect2.hasNext()) {
                    Integer parentID = (Integer)sect2.next();
                    String parentName = (String)parentNamesMap.get(parentID);
                    List indexes = (List)((Map)this.parentSectsMap.get(fm)).get(parentName);
                    double parentTarget = SlipRatePlots.meanFromIndexes(targets, indexes);
                    double parentTargetMin = SlipRatePlots.meanFromIndexes(targetMins, indexes);
                    double parentTargetMax = SlipRatePlots.meanFromIndexes(targetMaxs, indexes);
                    double parentSolution = SlipRatePlots.meanFromIndexes(solSlips, indexes);
                    double parentSolutionMin = SlipRatePlots.meanFromIndexes(solSlipMins, indexes);
                    double parentSolutionMax = SlipRatePlots.meanFromIndexes(solSlipMaxs, indexes);
                    double parentRatio = SlipRatePlots.meanFromIndexes(ratios, indexes);
                    parentSectCSV.addLine("" + parentID, parentName, "" + parentTarget, "" + parentTargetMin, "" + parentTargetMax, "" + parentSolution, "" + parentSolutionMin, "" + parentSolutionMax, "" + parentRatio);
                }
                this.parentSectCSVs.put(fm, parentSectCSV);
                Object label = "Mean(Solution Slip Rate / Target Slip Rate)";
                Object prefix = "";
                if (multipleFMs) {
                    prefix = (String)prefix + fm.getShortName() + "_";
                    label = fm.getShortName() + " " + (String)label;
                }
                MapPlotData plot = new MapPlotData(linearCPT, faults, ratios, (Region)region, skipNans, (String)label, (String)prefix + "slip_rate_misfit");
                plot.subDirName = "slip_rate_plots";
                this.plots.add(plot);
                label = "Log10(" + (String)label + ")";
                double[] log10Values = FaultBasedMapGen.log10(ratios);
                plot = new MapPlotData(logCPT, faults, log10Values, (Region)region, skipNans, (String)label, (String)prefix + "slip_rate_misfit_log");
                plot.subDirName = "slip_rate_plots";
                this.plots.add(plot);
                label = "Mean Solution Slip Rate";
                prefix = "";
                if (multipleFMs) {
                    prefix = (String)prefix + fm.getShortName() + "_";
                    label = fm.getShortName() + " " + (String)label;
                }
                plot = new MapPlotData(slipRateCPT, faults, FaultBasedMapGen.scale(solSlips, 1000.0), (Region)region, skipNans, (String)label, (String)prefix + "sol_slip_rate");
                plot.subDirName = "slip_rate_plots";
                this.plots.add(plot);
                label = "Mean Target Slip Rate (mm/yr)";
                prefix = "";
                if (multipleFMs) {
                    prefix = (String)prefix + fm.getShortName() + "_";
                    label = fm.getShortName() + " " + (String)label;
                }
                plot = new MapPlotData(slipRateCPT, faults, FaultBasedMapGen.scale(targets, 1000.0), (Region)region, skipNans, (String)label, (String)prefix + "target_slip_rate");
                plot.subDirName = "slip_rate_plots";
                this.plots.add(plot);
            }
        }

        @Override
        protected void writeExtraData(File dir, String prefix) {
            boolean multipleFMs = this.subSectCSVs.keySet().size() > 1;
            for (FaultModels fm : this.subSectCSVs.keySet()) {
                CSVFile<String> subSectCSV = this.subSectCSVs.get(fm);
                CSVFile<String> parentSectCSV = this.parentSectCSVs.get(fm);
                Object fname = prefix;
                if (multipleFMs) {
                    fname = (String)fname + "_" + fm.getShortName();
                }
                try {
                    subSectCSV.writeToFile(new File(dir, (String)fname + "_slip_rates_sub_sections.csv"));
                    parentSectCSV.writeToFile(new File(dir, (String)fname + "_slip_rates_parent_sections.csv"));
                }
                catch (IOException e) {
                    ExceptionUtils.throwAsRuntimeException(e);
                }
            }
        }

        @Override
        protected List<MapPlotData> getPlotData() {
            return this.plots;
        }

        @Override
        protected String getPlotDataFileName() {
            return PLOT_DATA_FILE_NAME;
        }
    }

    private static class SiteHazardCalcJob
    implements Task {
        private ERFBasedSiteHazardHistPlot plot;
        private BinaryCurveArchiver archiver;
        private ERF erf;
        private AttenRelRef ref;
        private Site site;
        private Period period;
        private String prefix;
        private DiscretizedFunc func;
        private int solIndex;

        public SiteHazardCalcJob(ERFBasedSiteHazardHistPlot plot, BinaryCurveArchiver archiver, ERF erf, AttenRelRef ref, Site site, Period period, String prefix, DiscretizedFunc xVals, int solIndex) {
            this.plot = plot;
            this.archiver = archiver;
            this.erf = erf;
            this.ref = ref;
            this.site = site;
            this.period = period;
            this.prefix = prefix;
            this.func = xVals.deepClone();
            this.solIndex = solIndex;
        }

        @Override
        public void compute() {
            HazardCurveCalculator calc = new HazardCurveCalculator();
            ScalarIMR imr = this.plot.getIMRInstance(this.ref);
            if (this.period == Period.GM0P00) {
                imr.setIntensityMeasure("PGA");
            } else {
                imr.setIntensityMeasure("SA");
                imr.getParameter("SA Period").setValue(this.period.getValue());
            }
            Stopwatch watch = Stopwatch.createStarted();
            this.plot.debug(this.solIndex, "calculating curve: " + this.site.getName() + ". " + this.prefix);
            calc.getHazardCurve(this.func, this.site, imr, this.erf);
            watch.stop();
            this.plot.debug(this.solIndex, "archiving curve: " + this.site.getName() + ". " + this.prefix + " (" + watch.elapsed(TimeUnit.SECONDS) + " s)");
            ArbitrarilyDiscretizedFunc unLogged = new ArbitrarilyDiscretizedFunc();
            for (int j = 0; j < this.func.size(); ++j) {
                unLogged.set(Math.exp(this.func.getX(j)), this.func.getY(j));
            }
            CurveMetadata meta = new CurveMetadata(this.site, this.solIndex, null, this.prefix);
            try {
                this.archiver.archiveCurve(unLogged, meta);
            }
            catch (IOException e) {
                ExceptionUtils.throwAsRuntimeException(e);
            }
            this.plot.debug(this.solIndex, "done archiving curve: " + this.site.getName() + ". " + this.prefix);
            this.plot.returnIMRInstance(this.ref, imr);
        }
    }

    public static class RupInRegionsCache
    implements RupInRegionCache {
        private ConcurrentMap<Region, ConcurrentMap<Integer, Boolean>> map = Maps.newConcurrentMap();

        @Override
        public boolean isRupInRegion(ERF erf, ProbEqkSource source, EqkRupture rup, int srcIndex, int rupIndex, Region region) {
            RuptureSurface surf = rup.getRuptureSurface();
            if (surf instanceof CompoundSurface) {
                Boolean inside;
                int invIndex = CompoundFSSPlots.getInversionIndex(source);
                ConcurrentMap regMap = (ConcurrentMap)this.map.get(region);
                if (regMap == null) {
                    regMap = Maps.newConcurrentMap();
                    this.map.putIfAbsent(region, regMap);
                    regMap = (ConcurrentMap)this.map.get(region);
                }
                if ((inside = (Boolean)regMap.get(invIndex)) == null) {
                    inside = false;
                    for (Location loc : surf.getEvenlyDiscritizedListOfLocsOnSurface()) {
                        if (!region.contains(loc)) continue;
                        inside = true;
                        break;
                    }
                    regMap.putIfAbsent(invIndex, inside);
                }
                return inside;
            }
            for (Location loc : surf.getEvenlyDiscritizedListOfLocsOnSurface()) {
                if (!region.contains(loc)) continue;
                return true;
            }
            return false;
        }
    }
}

