/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.analysis;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.faultSurface.FaultTrace;
import org.opensha.sha.faultSurface.RuptureSurface;
import scratch.UCERF3.enumTreeBranches.FaultModels;

public class FaultModelsCalc {
    public static void writeSectionsForEachNamedFault(FaultModels fm) {
        Map<Integer, List<Integer>> namedMap = fm.getNamedFaultsMap();
        List<FaultSection> sects = fm.getFaultSections();
        HashMap<Integer, String> idNameMap = new HashMap<Integer, String>();
        for (FaultSection data : sects) {
            idNameMap.put(data.getSectionId(), data.getName());
        }
        for (Integer key : namedMap.keySet()) {
            if (namedMap.get(key).size() <= 1) continue;
            System.out.print(key);
            for (Integer id : namedMap.get(key)) {
                System.out.print("\t" + (String)idNameMap.get(id));
            }
            System.out.print("\n");
        }
    }

    public static void writeSectionsForEachNamedFaultAlt(FaultModels fm) {
        Map<String, List<Integer>> namedMap = fm.getNamedFaultsMapAlt();
        List<FaultSection> sects = fm.getFaultSections();
        HashMap<Integer, String> idNameMap = new HashMap<Integer, String>();
        for (FaultSection data : sects) {
            idNameMap.put(data.getSectionId(), data.getName());
        }
        for (String faultName : namedMap.keySet()) {
            System.out.println(faultName + " Sections");
            for (Integer id : namedMap.get(faultName)) {
                System.out.println("\t" + (String)idNameMap.get(id));
            }
            System.out.print("\n");
        }
    }

    public static void writeSectionsNamesAndSomeAttributes(FaultModels fm, boolean includeTrace) {
        List<FaultSection> sects = fm.getFaultSections();
        for (FaultSection data : fm.getFaultSections()) {
            System.out.print(data.getName() + "\t" + (float)data.getOrigDownDipWidth() + "\t" + (float)data.getReducedDownDipWidth() + "\t" + (float)data.getFaultTrace().getTraceLength() + "\t" + (float)data.getAseismicSlipFactor() + "\t" + data.getAveLowerDepth() + "\t" + data.getOrigAveUpperDepth());
            if (includeTrace) {
                FaultTrace trace = data.getFaultTrace();
                System.out.print("\t" + trace.size());
                for (int l = 0; l < trace.size(); ++l) {
                    System.out.print("\t" + (float)((Location)trace.get(l)).getLatitude() + "\t" + (float)((Location)trace.get(l)).getLongitude());
                }
                System.out.print("\n");
                continue;
            }
            System.out.print("\n");
        }
    }

    public static void writeSectionDataForSuppleTable() {
        String line;
        HashMap<Integer, String> nameList = new HashMap<Integer, String>();
        ArrayList<CallSite> lineList = new ArrayList<CallSite>();
        HashMap<Integer, Boolean> inFM3pt1 = new HashMap<Integer, Boolean>();
        HashMap<Integer, Boolean> inFM3pt2 = new HashMap<Integer, Boolean>();
        List<FaultSection> fm1_data = FaultModels.FM3_1.getFaultSections();
        List<FaultSection> fm2_data = FaultModels.FM3_2.getFaultSections();
        for (FaultSection data : fm1_data) {
            nameList.put(data.getSectionId(), data.getName());
            inFM3pt1.put(data.getSectionId(), true);
            inFM3pt2.put(data.getSectionId(), false);
        }
        for (FaultSection data : fm2_data) {
            if (inFM3pt1.keySet().contains(data.getSectionId())) {
                inFM3pt2.put(data.getSectionId(), true);
                continue;
            }
            inFM3pt1.put(data.getSectionId(), false);
            inFM3pt2.put(data.getSectionId(), true);
        }
        for (FaultSection data : fm1_data) {
            line = data.getName() + "\t" + data.getSectionId() + "\ttrue\t" + String.valueOf(inFM3pt2.get(data.getSectionId())) + "\t" + data.getAveDip() + "\t" + data.getOrigAveUpperDepth() + "\t" + data.getAveLowerDepth() + "\t" + data.getTraceLength();
            for (Location location : data.getFaultTrace()) {
                line = line + "\t" + location.getLatitude() + "\t" + location.getLongitude();
            }
            lineList.add((CallSite)((Object)line));
        }
        for (FaultSection data : fm2_data) {
            if (((Boolean)inFM3pt1.get(data.getSectionId())).booleanValue()) continue;
            line = data.getName() + "\t" + data.getSectionId() + "\tfalse\ttrue\t" + data.getAveDip() + "\t" + data.getOrigAveUpperDepth() + "\t" + data.getAveLowerDepth() + "\t" + data.getTraceLength();
            for (Location location : data.getFaultTrace()) {
                line = line + "\t" + location.getLatitude() + "\t" + location.getLongitude();
            }
            lineList.add((CallSite)((Object)line));
        }
        File dataFile = new File("dev/scratch/UCERF3/data/scratch/FaultSectionDataForSuplTable.txt");
        try {
            FileWriter fw = new FileWriter(dataFile);
            String header = "Name\tID\tIn FM3.1\tIn FM3.2\tAve Dip\tUpper Seis Depth\tLower Seis Depth\tTrace Length\tTrace Locations (Lat, Lon)";
            fw.write(header + "\n");
            for (String string : lineList) {
                fw.write(string + "\n");
            }
            fw.close();
        }
        catch (IOException e) {
            System.out.println("IO exception = " + String.valueOf(e));
        }
    }

    public static void writeSectionOutlineForGMT(FaultModels fm, String fileName) {
        List<FaultSection> fm_data = fm.getFaultSections();
        ArrayList<CallSite> lineList = new ArrayList<CallSite>();
        for (FaultSection data : fm_data) {
            lineList.add((CallSite)((Object)("> " + data.getName())));
            RuptureSurface surface = data.getFaultSurface(1.0, false, false);
            FaultTrace faultTrace = surface.getEvenlyDiscritizedUpperEdge();
            for (Location loc : faultTrace) {
                lineList.add((CallSite)((Object)((float)loc.getLatitude() + "\t" + (float)loc.getLongitude() + "\t" + (float)loc.getDepth())));
            }
            LocationList lowerEdge = surface.getEvenlyDiscritizedLowerEdge();
            lowerEdge.reverse();
            for (Location loc : lowerEdge) {
                lineList.add((CallSite)((Object)((float)loc.getLatitude() + "\t" + (float)loc.getLongitude() + "\t" + (float)loc.getDepth())));
            }
        }
        File dataFile = new File("dev/scratch/UCERF3/data/scratch/" + fileName);
        try {
            FileWriter fw = new FileWriter(dataFile);
            for (String string : lineList) {
                fw.write(string + "\n");
            }
            fw.close();
        }
        catch (IOException e) {
            System.out.println("IO exception = " + String.valueOf(e));
        }
    }

    public static void main(String[] args) {
        FaultModelsCalc.writeSectionOutlineForGMT(FaultModels.FM3_1, "fm3pt1_forGMT.txt");
    }
}

