/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.analysis;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.primitives.Doubles;
import edu.usc.kmilner.mpj.taskDispatch.MPJTaskCalculator;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import mpi.MPI;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.opensha.commons.geo.Region;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.commons.util.threads.ThreadedTaskComputer;
import scratch.UCERF3.U3CompoundFaultSystemSolution;
import scratch.UCERF3.U3FaultSystemSolutionFetcher;
import scratch.UCERF3.analysis.CompoundFSSPlots;
import scratch.UCERF3.enumTreeBranches.FaultModels;
import scratch.UCERF3.inversion.InversionFaultSystemSolution;
import scratch.UCERF3.logicTree.U3APrioriBranchWeightProvider;
import scratch.UCERF3.logicTree.U3BranchWeightProvider;
import scratch.UCERF3.logicTree.U3LogicTreeBranch;
import scratch.UCERF3.logicTree.U3LogicTreeBranchNode;
import scratch.UCERF3.logicTree.U3UniformBranchWeightProvider;
import scratch.UCERF3.logicTree.UCERF3p2BranchWeightProvider;
import scratch.UCERF3.utils.U3FaultSystemIO;

public class MPJDistributedCompoundFSSPlots
extends MPJTaskCalculator {
    private U3FaultSystemSolutionFetcher fetcher;
    private List<U3LogicTreeBranch> branches;
    private List<CompoundFSSPlots> plots;
    private int threads;
    private int myCalcs = 0;
    private MPJDistributedCompoundFSSPlots parentMFDCompare;

    public MPJDistributedCompoundFSSPlots(CommandLine cmd, U3FaultSystemSolutionFetcher fetcher, List<CompoundFSSPlots> plots) {
        super(cmd);
        String fname;
        ArrayList filtered;
        ArrayList greps;
        Preconditions.checkState((!plots.isEmpty() ? 1 : 0) != 0, (Object)"No plots specified!");
        this.branches = Lists.newArrayList();
        this.branches.addAll(fetcher.getBranches());
        if (cmd.hasOption("name-grep")) {
            greps = Lists.newArrayList((Iterable)Splitter.on((String)",").split((CharSequence)cmd.getOptionValue("name-grep")));
            filtered = Lists.newArrayList();
            block2: for (U3LogicTreeBranch branch : this.branches) {
                fname = branch.buildFileName();
                for (String grep : greps) {
                    if (fname.contains(grep)) continue;
                    continue block2;
                }
                filtered.add(branch);
            }
            System.out.println("Filtered branches size: " + filtered.size() + "/" + this.branches.size());
            this.branches = filtered;
        }
        if (cmd.hasOption("name-exclude")) {
            greps = Lists.newArrayList((Iterable)Splitter.on((String)",").split((CharSequence)cmd.getOptionValue("name-exclude")));
            filtered = Lists.newArrayList();
            block4: for (U3LogicTreeBranch branch : this.branches) {
                fname = branch.buildFileName();
                for (String grep : greps) {
                    if (!fname.contains(grep)) continue;
                    continue block4;
                }
                filtered.add(branch);
            }
            System.out.println("Filtered branches size: " + filtered.size() + "/" + this.branches.size());
            this.branches = filtered;
        }
        this.fetcher = fetcher;
        this.plots = plots;
        this.threads = this.getNumThreads();
        if (cmd.hasOption("plot-parent-mfd-compare")) {
            if (plots.get(0) == null) {
                plots.remove(0);
            } else {
                File compFile = new File(cmd.getOptionValue("plot-parent-mfd-compare"));
                ArrayList subPlots = Lists.newArrayList();
                subPlots.add(null);
                subPlots.add(new CompoundFSSPlots.ParentSectMFDsPlot(new UCERF3p2BranchWeightProvider()));
                try {
                    U3FaultSystemSolutionFetcher subFetch = U3CompoundFaultSystemSolution.fromZipFile(compFile);
                    if (cmd.hasOption("rand")) {
                        int num = Integer.parseInt(cmd.getOptionValue("rand"));
                        subFetch = U3FaultSystemSolutionFetcher.getRandomSample(subFetch, num, new U3LogicTreeBranchNode[0]);
                    }
                    this.parentMFDCompare = new MPJDistributedCompoundFSSPlots(cmd, subFetch, subPlots);
                }
                catch (Exception e) {
                    ExceptionUtils.throwAsRuntimeException(e);
                }
            }
        }
    }

    protected int getNumTasks() {
        return this.branches.size();
    }

    protected void calculateBatch(int[] batch) throws Exception {
        ArrayList tasks = Lists.newArrayList();
        for (int index : batch) {
            U3LogicTreeBranch branch = this.branches.get(index);
            ArrayList myPlots = Lists.newArrayList(this.plots);
            Collections.shuffle(myPlots);
            tasks.add(new CompoundFSSPlots.PlotSolComputeTask(myPlots, this.fetcher, branch, true, index));
        }
        this.debug("Making " + this.plots.size() + " plot(s) with " + tasks.size() + " branches");
        ThreadedTaskComputer comp = new ThreadedTaskComputer(tasks);
        try {
            comp.computeThreaded(this.threads);
        }
        catch (InterruptedException e) {
            this.debug("Exception computing threaded: " + e.getMessage());
            ExceptionUtils.throwAsRuntimeException(e);
        }
        this.myCalcs += batch.length;
    }

    protected void doFinalAssembly() throws Exception {
        for (CompoundFSSPlots plot : this.plots) {
            plot.flushResults();
        }
        System.out.println(this.rank + ". My number of calcs: " + this.myCalcs);
        int numPlots = this.plots.size();
        CompoundFSSPlots[] sendbuf = new CompoundFSSPlots[numPlots];
        for (int i = 0; i < numPlots; ++i) {
            sendbuf[i] = this.myCalcs > 0 ? this.plots.get(i) : null;
        }
        int recvcount = numPlots * this.size;
        CompoundFSSPlots[] recvbuf = this.rank == 0 ? new CompoundFSSPlots[recvcount] : null;
        if (this.parentMFDCompare != null) {
            this.debug("Running MFD compare!");
            this.parentMFDCompare.run();
        }
        if (this.rank == 0) {
            CompoundFSSPlots oPlot;
            for (int source = 1; source < this.size; ++source) {
                System.out.println("Receiving from " + source);
                MPI.COMM_WORLD.Recv((Object)sendbuf, 0, sendbuf.length, MPI.OBJECT, source, 0);
                for (int p = 0; p < numPlots; ++p) {
                    if (sendbuf[p] == null) continue;
                    CompoundFSSPlots plot = this.plots.get(p);
                    oPlot = sendbuf[p];
                    plot.combineDistributedCalcs(Lists.newArrayList((Object[])new CompoundFSSPlots[]{oPlot}));
                    plot.addToComputeTimeCount(oPlot.getComputeTimeCount());
                    sendbuf[p] = null;
                }
                System.gc();
            }
            for (CompoundFSSPlots plot : this.plots) {
                plot.finalizePlot();
                if (this.parentMFDCompare == null || !(plot instanceof CompoundFSSPlots.ParentSectMFDsPlot)) continue;
                this.debug("Merging in MFD compare");
                CompoundFSSPlots.ParentSectMFDsPlot mainPlot = (CompoundFSSPlots.ParentSectMFDsPlot)plot;
                oPlot = (CompoundFSSPlots.ParentSectMFDsPlot)this.parentMFDCompare.plots.get(0);
                mainPlot.addMeanFromExternalAsFractile((CompoundFSSPlots.ParentSectMFDsPlot)oPlot);
            }
            CompoundFSSPlots.printComputeTimes(this.plots);
        } else {
            MPI.COMM_WORLD.Send((Object)sendbuf, 0, sendbuf.length, MPI.OBJECT, 0, 0);
        }
    }

    protected static Options createOptions() {
        Options options = MPJTaskCalculator.createOptions();
        Option mfdOption = new Option("mfd", "plot-mfds", false, "Flag for plotting MFDs");
        mfdOption.setRequired(false);
        options.addOption(mfdOption);
        Option paleoFaultOption = new Option("paleofault", "plot-paleo-faults", false, "Flag for plotting paleo faults");
        paleoFaultOption.setRequired(false);
        options.addOption(paleoFaultOption);
        Option paleoCorrOption = new Option("paleocorr", "plot-paleo-corrs", false, "Flag for plotting paleo correlations");
        paleoCorrOption.setRequired(false);
        options.addOption(paleoCorrOption);
        Option parentMFDsOption = new Option("parentmfds", "plot-parent-mfds", false, "Flag for plotting parent section MFDs");
        parentMFDsOption.setRequired(false);
        options.addOption(parentMFDsOption);
        Option parentMFDCompareOption = new Option("parentmfdcompare", "plot-parent-mfd-compare", true, "Flag for plotting parent section MFDs");
        parentMFDCompareOption.setRequired(false);
        options.addOption(parentMFDCompareOption);
        Option jumpsOption = new Option("jumps", "plot-rup-jumps", false, "Flag for plotting rupture jumps");
        jumpsOption.setRequired(false);
        options.addOption(jumpsOption);
        Option slipMisfitsOption = new Option("slips", "plot-slip-rates", false, "Flag for plotting slip misfits");
        slipMisfitsOption.setRequired(false);
        options.addOption(slipMisfitsOption);
        Option particsOption = new Option("partics", "plot-participations", false, "Flag for plotting fault based section participations");
        particsOption.setRequired(false);
        options.addOption(particsOption);
        Option gridParticsOption = new Option("gridpartics", "plot-gridded-participations", false, "Flag for plotting gridded participations");
        gridParticsOption.setRequired(false);
        options.addOption(gridParticsOption);
        Option gridParticsProbsOption = new Option("gridparticprobs", "plot-gridded-partic-probs", false, "Flag for plotting gridded participation probabilities");
        gridParticsProbsOption.setRequired(false);
        options.addOption(gridParticsProbsOption);
        Option erfMFDsOption = new Option("erfmfds", "plot-erf-mfds", false, "Flag for plotting gridded participations");
        erfMFDsOption.setRequired(false);
        options.addOption(erfMFDsOption);
        Option erfProbDistsOption = new Option("erfmpds", "plot-erf-prob-dists", false, "Flag for erf prob dists");
        erfProbDistsOption.setRequired(false);
        options.addOption(erfProbDistsOption);
        Option erfHazOption = new Option("erfhaz", "plot-erf-hazard", false, "Flag for erf hazard histograms");
        erfHazOption.setRequired(false);
        options.addOption(erfHazOption);
        Option erfProbsOption = new Option("erfprob", "plot-erf-probs", false, "Flag for erf probability models calc");
        erfProbsOption.setRequired(false);
        options.addOption(erfProbsOption);
        Option subSectRIsOption = new Option("ssris", "plot-sub-sect-ris", false, "Flag for creating sub section RIs tables");
        subSectRIsOption.setRequired(false);
        options.addOption(subSectRIsOption);
        Option miniSectRIsOption = new Option("miniris", "plot-mini-sect-ris", false, "Flag for creating mini section RIs tables");
        miniSectRIsOption.setRequired(false);
        options.addOption(miniSectRIsOption);
        Option paleoTablesOption = new Option("paleotables", "plot-paleo-tables", false, "Flag for creating paleo rate tables");
        paleoTablesOption.setRequired(false);
        options.addOption(paleoTablesOption);
        Option aveSlipsOption = new Option("aveslips", "plot-ave-slips", false, "Flag for creating ave slip map based plots");
        aveSlipsOption.setRequired(false);
        options.addOption(aveSlipsOption);
        Option multiFaultOption = new Option("multi", "plot-multi-faults", false, "Flag for creating ave slip map based plots");
        multiFaultOption.setRequired(false);
        options.addOption(multiFaultOption);
        Option misfitOption = new Option("misfit", "plot-misfits", false, "Flag for creating misfits table");
        misfitOption.setRequired(false);
        options.addOption(misfitOption);
        Option meanOption = new Option("mean", "build-mean", false, "Flag for building mean FSS");
        meanOption.setRequired(false);
        options.addOption(meanOption);
        Option meanIndOption = new Option("meanind", "mean-sol-ind", true, "Index in average fault system solutions to use for mean (optional)");
        meanIndOption.setRequired(false);
        options.addOption(meanIndOption);
        Option plotAllOption = new Option("all", "plot-all", false, "Flag for making all plots");
        plotAllOption.setRequired(false);
        options.addOption(plotAllOption);
        Option noERFOption = new Option("noerf", "no-erf-plots", false, "Flag for disabling ERF based plots (can be used with --plot-all");
        noERFOption.setRequired(false);
        options.addOption(noERFOption);
        Option onlyERFOption = new Option("onlyerf", "only-erf-plots", false, "Flag for only ERF based plots (when used with --plot-all");
        onlyERFOption.setRequired(false);
        options.addOption(onlyERFOption);
        Option noMapOption = new Option("nomap", "no-map-plots", false, "Flag for disabling Map based plots (can be used with --plot-all");
        noMapOption.setRequired(false);
        options.addOption(noMapOption);
        Option onlyMapOption = new Option("onlymap", "only-map-plots", false, "Flag for only Map based plots (when used with --plot-all");
        onlyMapOption.setRequired(false);
        options.addOption(onlyMapOption);
        Option randomSampleOption = new Option("rand", "random-sample", true, "If supplied, a random sample of the given size will be used.");
        randomSampleOption.setRequired(false);
        options.addOption(randomSampleOption);
        Option meanSampleOption = new Option("mean", "mean-sol", true, "If supplied along with --random-sample, the given solution will be loaded and used for each sample");
        meanSampleOption.setRequired(false);
        options.addOption(meanSampleOption);
        Option nameGrepsOption = new Option("ng", "name-grep", true, "If supplied, logic tree branches will be only be included out based on grepping for these comma separated strings.");
        nameGrepsOption.setRequired(false);
        options.addOption(nameGrepsOption);
        Option nameExcludeOption = new Option("ne", "name-exclude", true, "If supplied, logic tree branches will be filtered out based on grepping for these comma separated strings.");
        nameExcludeOption.setRequired(false);
        options.addOption(nameExcludeOption);
        Option u3p2WeightsOption = new Option("u3p2weight", "ucerf3p2-weights", false, "If supplied, UCERF3.2 weights will be used.");
        u3p2WeightsOption.setRequired(false);
        options.addOption(u3p2WeightsOption);
        Option uniformWeightsOption = new Option("uniwt", "uniform-weights", false, "If supplied, equal weights for all branches will be used.");
        uniformWeightsOption.setRequired(false);
        options.addOption(uniformWeightsOption);
        Option durationsOption = new Option("dur", "duration", true, "Override the default set of durations for time dependent plots (comma separated)");
        durationsOption.setRequired(false);
        options.addOption(durationsOption);
        return options;
    }

    public static void main(String[] args) {
        args = MPJTaskCalculator.initMPJ((String[])args);
        try {
            CompoundFSSPlots miniRIs;
            CompoundFSSPlots erfMFDs;
            CompoundFSSPlots.MapBasedPlot partics;
            CompoundFSSPlots plot;
            CompoundFSSPlots paleo;
            Options options = MPJDistributedCompoundFSSPlots.createOptions();
            CommandLine cmd = MPJDistributedCompoundFSSPlots.parse((Options)options, (String[])args, MPJDistributedCompoundFSSPlots.class);
            args = cmd.getArgs();
            Preconditions.checkArgument((args.length == 2 ? 1 : 0) != 0, (Object)"Must specify inputfile file/output dir!");
            File inputFile = new File(args[0]);
            File dir = new File(args[1]);
            if (!dir.exists()) {
                dir.mkdir();
            }
            Preconditions.checkArgument((boolean)inputFile.exists(), (Object)("Input file doesn't exist!: " + String.valueOf(inputFile)));
            U3FaultSystemSolutionFetcher fetcher = U3CompoundFaultSystemSolution.fromZipFile(inputFile);
            if (cmd.hasOption("rand")) {
                int num = Integer.parseInt(cmd.getOptionValue("rand"));
                if (cmd.hasOption("mean")) {
                    final InversionFaultSystemSolution meanSol = U3FaultSystemIO.loadInvSol(new File(cmd.getOptionValue("mean")));
                    fetcher = U3FaultSystemSolutionFetcher.getRandomSample(fetcher, num, meanSol.getLogicTreeBranch().getValue(FaultModels.class));
                    final Collection<U3LogicTreeBranch> branches = fetcher.getBranches();
                    fetcher = new U3FaultSystemSolutionFetcher(){

                        @Override
                        public Collection<U3LogicTreeBranch> getBranches() {
                            return branches;
                        }

                        @Override
                        protected InversionFaultSystemSolution fetchSolution(U3LogicTreeBranch branch) {
                            return meanSol;
                        }
                    };
                } else {
                    fetcher = U3FaultSystemSolutionFetcher.getRandomSample(fetcher, num, new U3LogicTreeBranchNode[0]);
                }
            }
            U3BranchWeightProvider weightProvider = new U3APrioriBranchWeightProvider();
            if (cmd.hasOption("ucerf3p2-weights")) {
                weightProvider = new UCERF3p2BranchWeightProvider();
            }
            if (cmd.hasOption("uniform-weights")) {
                weightProvider = new U3UniformBranchWeightProvider();
            }
            ArrayList plots = Lists.newArrayList();
            boolean plotAll = cmd.hasOption("all");
            if (cmd.hasOption("duration")) {
                String durStr = cmd.getOptionValue("duration").trim();
                ArrayList vals = Lists.newArrayList();
                for (String val : durStr.split(",")) {
                    val = val.trim();
                    vals.add(Double.parseDouble(val));
                }
                Preconditions.checkArgument((!vals.isEmpty() ? 1 : 0) != 0, (Object)"Must supply at least one duration");
                CompoundFSSPlots.time_dep_durations = Doubles.toArray((Collection)vals);
            }
            if (plotAll || cmd.hasOption("mfd")) {
                List<Region> regions = CompoundFSSPlots.RegionalMFDPlot.getDefaultRegions();
                CompoundFSSPlots.RegionalMFDPlot mfd = new CompoundFSSPlots.RegionalMFDPlot(weightProvider, regions);
                plots.add(mfd);
            }
            if (plotAll || cmd.hasOption("paleofault")) {
                paleo = new CompoundFSSPlots.PaleoFaultPlot(weightProvider);
                plots.add(paleo);
            }
            if (plotAll || cmd.hasOption("paleocorr")) {
                paleo = new CompoundFSSPlots.PaleoSiteCorrelationPlot(weightProvider);
                plots.add(paleo);
            }
            if (plotAll || cmd.hasOption("parentmfds")) {
                plot = new CompoundFSSPlots.ParentSectMFDsPlot(weightProvider);
                plots.add(plot);
            }
            if (plotAll || cmd.hasOption("jumps")) {
                plot = new CompoundFSSPlots.RupJumpPlot(weightProvider);
                plots.add(plot);
            }
            if (plotAll || cmd.hasOption("slips")) {
                CompoundFSSPlots.SlipRatePlots slips = new CompoundFSSPlots.SlipRatePlots(weightProvider);
                plots.add(slips);
            }
            if (plotAll || cmd.hasOption("partics")) {
                partics = new CompoundFSSPlots.ParticipationMapPlot(weightProvider);
                plots.add(partics);
            }
            if (plotAll || cmd.hasOption("gridpartics")) {
                partics = new CompoundFSSPlots.GriddedParticipationMapPlot(weightProvider);
                plots.add(partics);
            }
            if (plotAll || cmd.hasOption("gridparticprobs")) {
                partics = new CompoundFSSPlots.TimeDepGriddedParticipationProbPlot(weightProvider);
                plots.add(partics);
            }
            if (plotAll || cmd.hasOption("erfmfds")) {
                erfMFDs = new CompoundFSSPlots.ERFBasedRegionalMFDPlot(weightProvider);
                plots.add(erfMFDs);
            }
            if (plotAll || cmd.hasOption("plot-erf-prob-dists")) {
                erfMFDs = new CompoundFSSPlots.ERFBasedRegionalMagProbPlot(weightProvider);
                plots.add(erfMFDs);
            }
            if (plotAll || cmd.hasOption("plot-erf-probs")) {
                CompoundFSSPlots.ERFProbModelCalc erfProbs = new CompoundFSSPlots.ERFProbModelCalc();
                plots.add(erfProbs);
            }
            if (plotAll || cmd.hasOption("erfhaz")) {
                CompoundFSSPlots.ERFBasedSiteHazardHistPlot erfHaz = new CompoundFSSPlots.ERFBasedSiteHazardHistPlot(weightProvider, new File(dir, "site_hazard_curve_cache"), fetcher.getBranches().size());
                plots.add(erfHaz);
            }
            if (plotAll || cmd.hasOption("miniris")) {
                miniRIs = new CompoundFSSPlots.MiniSectRIPlot(weightProvider);
                plots.add(miniRIs);
            }
            if (plotAll || cmd.hasOption("ssris")) {
                miniRIs = new CompoundFSSPlots.SubSectRITable(weightProvider);
                plots.add(miniRIs);
            }
            if (plotAll || cmd.hasOption("paleotables")) {
                miniRIs = new CompoundFSSPlots.PaleoRatesTable(weightProvider);
                plots.add(miniRIs);
            }
            if (plotAll || cmd.hasOption("aveslips")) {
                CompoundFSSPlots.AveSlipMapPlot aveSlip = new CompoundFSSPlots.AveSlipMapPlot(weightProvider);
                plots.add(aveSlip);
            }
            if (plotAll || cmd.hasOption("multi")) {
                CompoundFSSPlots.MultiFaultParticPlot multi = new CompoundFSSPlots.MultiFaultParticPlot(weightProvider);
                plots.add(multi);
            }
            if (plotAll || cmd.hasOption("misfit")) {
                CompoundFSSPlots.MisfitTable misfit = new CompoundFSSPlots.MisfitTable();
                plots.add(misfit);
            }
            if (plotAll || cmd.hasOption("mean")) {
                CompoundFSSPlots.BranchAvgFSSBuilder builder = new CompoundFSSPlots.BranchAvgFSSBuilder(weightProvider);
                if (cmd.hasOption("meanind")) {
                    int meanInd = Integer.parseInt(cmd.getOptionValue("meanind"));
                    builder.setSolIndex(meanInd);
                }
                plots.add(builder);
            }
            if (cmd.hasOption("noerf")) {
                int i = plots.size();
                while (--i >= 0) {
                    if (!((CompoundFSSPlots)plots.get(i)).usesERFs()) continue;
                    plots.remove(i);
                }
            }
            if (cmd.hasOption("onlyerf")) {
                int i = plots.size();
                while (--i >= 0) {
                    if (((CompoundFSSPlots)plots.get(i)).usesERFs()) continue;
                    plots.remove(i);
                }
            }
            if (cmd.hasOption("nomap")) {
                int i = plots.size();
                while (--i >= 0) {
                    if (!(plots.get(i) instanceof CompoundFSSPlots.MapBasedPlot)) continue;
                    plots.remove(i);
                }
            }
            if (cmd.hasOption("onlymap")) {
                int i = plots.size();
                while (--i >= 0) {
                    if (plots.get(i) instanceof CompoundFSSPlots.MapBasedPlot) continue;
                    plots.remove(i);
                }
            }
            MPJDistributedCompoundFSSPlots driver = new MPJDistributedCompoundFSSPlots(cmd, fetcher, plots);
            driver.run();
            String prefix = inputFile.getName();
            if (prefix.endsWith(".zip")) {
                prefix = prefix.substring(0, prefix.indexOf(".zip"));
            }
            if (driver.rank == 0) {
                MPJDistributedCompoundFSSPlots.debug((int)driver.rank, null, (String)"Writing all plots");
                CompoundFSSPlots.batchWritePlots(plots, dir, prefix, false);
                MPJDistributedCompoundFSSPlots.debug((int)driver.rank, null, (String)"DONE writing all plots");
            }
            MPJDistributedCompoundFSSPlots.finalizeMPJ();
            System.exit(0);
        }
        catch (Throwable t) {
            MPJDistributedCompoundFSSPlots.abortAndExit((Throwable)t);
        }
    }
}

