/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.analysis;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.dom4j.DocumentException;
import org.jfree.chart.plot.DatasetRenderingOrder;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.DefaultXY_DataSet;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.data.function.HistogramFunction;
import org.opensha.commons.data.function.XY_DataSetList;
import org.opensha.commons.data.region.CaliforniaRegions;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.gui.plot.GraphWindow;
import org.opensha.commons.gui.plot.HeadlessGraphPanel;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.gui.plot.PlotSymbol;
import org.opensha.commons.logicTree.LogicTreeBranch;
import org.opensha.commons.util.ClassUtils;
import org.opensha.sha.earthquake.calc.recurInterval.BPT_DistCalc;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.param.IncludeBackgroundOption;
import org.opensha.sha.faultSurface.FaultSection;
import scratch.UCERF3.U3AverageFaultSystemSolution;
import scratch.UCERF3.U3CompoundFaultSystemSolution;
import scratch.UCERF3.analysis.CompoundFSSPlots;
import scratch.UCERF3.analysis.DeformationModelsCalc;
import scratch.UCERF3.analysis.FaultBasedMapGen;
import scratch.UCERF3.analysis.FaultSysSolutionERF_Calc;
import scratch.UCERF3.analysis.FaultSystemRupSetCalc;
import scratch.UCERF3.analysis.GMT_CA_Maps;
import scratch.UCERF3.enumTreeBranches.DeformationModels;
import scratch.UCERF3.enumTreeBranches.FaultModels;
import scratch.UCERF3.enumTreeBranches.InversionModels;
import scratch.UCERF3.enumTreeBranches.MaxMagOffFault;
import scratch.UCERF3.enumTreeBranches.MomentRateFixes;
import scratch.UCERF3.enumTreeBranches.ScalingRelationships;
import scratch.UCERF3.enumTreeBranches.SlipAlongRuptureModels;
import scratch.UCERF3.enumTreeBranches.SpatialSeisPDF;
import scratch.UCERF3.enumTreeBranches.TotalMag5Rate;
import scratch.UCERF3.erf.FaultSystemSolutionERF;
import scratch.UCERF3.inversion.CommandLineInversionRunner;
import scratch.UCERF3.inversion.InversionFaultSystemRupSet;
import scratch.UCERF3.inversion.InversionFaultSystemRupSetFactory;
import scratch.UCERF3.logicTree.U3APrioriBranchWeightProvider;
import scratch.UCERF3.logicTree.U3LogicTreeBranch;
import scratch.UCERF3.logicTree.U3LogicTreeBranchNode;
import scratch.UCERF3.utils.DeformationModelFetcher;
import scratch.UCERF3.utils.U3FaultSystemIO;
import scratch.UCERF3.utils.UCERF3_DataUtils;
import scratch.UCERF3.utils.aveSlip.U3AveSlipConstraint;

public class TablesAndPlotsGen {
    private static final String FAULT_SUPRA_TARGET = "Fault Target Supra Seis Moment Rate";
    private static final String FAULT_SUPRA_SOLUTION = "Fault Solution Supra Seis Moment Rate";
    private static final String FAULT_SUB_TARGET = "Fault Target Sub Seis Moment Rate";
    private static final String FAULT_SUB_SOLUTION = "Fault Solution Sub Seis Moment Rate";
    private static final String TRULY_OFF_TARGET = "Truly Off Fault Target Moment Rate";
    private static final String TRULY_OFF_SOLUTION = "Truly Off Fault Solution Moment Rate";

    public static void buildAveSlipDataTable(File outputFile) throws IOException {
        boolean includeUCERF2 = true;
        ArrayList dms = Lists.newArrayList();
        if (includeUCERF2) {
            dms.add(DeformationModels.UCERF2_ALL);
        }
        dms.add(DeformationModels.ABM);
        dms.add(DeformationModels.GEOLOGIC);
        dms.add(DeformationModels.NEOKINEMA);
        dms.add(DeformationModels.ZENGBB);
        HashMap aveSlipConstraints = Maps.newHashMap();
        HashMap subSectDatasMap = Maps.newHashMap();
        ArrayList dmReducedSlipRates = Lists.newArrayList();
        ArrayList header = Lists.newArrayList((Object[])new String[]{"FM 3.1 Mapping", "Latitude", "Longitude", "Weighted Mean"});
        for (DeformationModels dm : dms) {
            FaultModels fm = dm == DeformationModels.UCERF2_ALL ? FaultModels.FM2_1 : FaultModels.FM3_1;
            InversionFaultSystemRupSet rupSet = InversionFaultSystemRupSetFactory.forBranch(InversionModels.CHAR_CONSTRAINED, fm, dm);
            dmReducedSlipRates.add(rupSet.getSlipRateForAllSections());
            if (!aveSlipConstraints.containsKey(fm)) {
                aveSlipConstraints.put(fm, U3AveSlipConstraint.load(rupSet.getFaultSectionDataList()));
            }
            if (!subSectDatasMap.containsKey(fm)) {
                subSectDatasMap.put(fm, rupSet.getFaultSectionDataList());
            }
            header.add(dm.getName() + " Reduced Slip Rate");
            header.add(dm.getName() + " Proxy Event Rate");
        }
        CSVFile csv = new CSVFile(true);
        csv.addLine(header);
        List fm2Constraints = (List)aveSlipConstraints.get(FaultModels.FM2_1);
        List fm3Constraints = (List)aveSlipConstraints.get(FaultModels.FM3_1);
        for (U3AveSlipConstraint u3AveSlipConstraint : fm3Constraints) {
            ArrayList line = Lists.newArrayList();
            String subSectName = ((FaultSection)((List)subSectDatasMap.get(FaultModels.FM3_1)).get(u3AveSlipConstraint.getSubSectionIndex())).getSectionName();
            line.add(subSectName);
            line.add("" + u3AveSlipConstraint.getSiteLocation().getLatitude());
            line.add("" + u3AveSlipConstraint.getSiteLocation().getLongitude());
            line.add("" + u3AveSlipConstraint.getWeightedMean());
            for (int i = 0; i < dms.size(); ++i) {
                DeformationModels dm = (DeformationModels)dms.get(i);
                U3AveSlipConstraint myConstr = null;
                if (dm == DeformationModels.UCERF2_ALL) {
                    for (U3AveSlipConstraint u2Constr : fm2Constraints) {
                        if (!u2Constr.getSiteLocation().equals(u3AveSlipConstraint.getSiteLocation())) continue;
                        myConstr = u2Constr;
                        break;
                    }
                } else {
                    myConstr = u3AveSlipConstraint;
                }
                if (myConstr == null) {
                    line.add("");
                    line.add("");
                    continue;
                }
                double reducedSlip = ((double[])dmReducedSlipRates.get(i))[myConstr.getSubSectionIndex()];
                line.add("" + reducedSlip);
                double proxyRate = reducedSlip / myConstr.getWeightedMean();
                line.add("" + proxyRate);
            }
            csv.addLine(line);
        }
        if (outputFile == null) {
            for (List list : csv) {
                System.out.println(Joiner.on((char)'\t').join((Iterable)list));
            }
        } else {
            csv.writeToFile(outputFile);
        }
    }

    public static void makePreInversionMFDsFig() {
        InversionFaultSystemRupSet rupSet = InversionFaultSystemRupSetFactory.forBranch(FaultModels.FM3_1, DeformationModels.ZENG, InversionModels.CHAR_CONSTRAINED, ScalingRelationships.SHAW_2009_MOD, SlipAlongRuptureModels.TAPERED, TotalMag5Rate.RATE_7p9, MaxMagOffFault.MAG_7p6, MomentRateFixes.NONE, SpatialSeisPDF.UCERF3);
        System.out.println(rupSet.getPreInversionAnalysisData(true));
        FaultSystemRupSetCalc.plotPreInversionMFDs(rupSet, false, false, true, "preInvCharMFDs.pdf");
        rupSet = InversionFaultSystemRupSetFactory.forBranch(FaultModels.FM3_1, DeformationModels.ZENG, InversionModels.GR_CONSTRAINED, ScalingRelationships.SHAW_2009_MOD, SlipAlongRuptureModels.TAPERED, TotalMag5Rate.RATE_7p9, MaxMagOffFault.MAG_7p6, MomentRateFixes.NONE, SpatialSeisPDF.UCERF3);
        FaultSystemRupSetCalc.plotPreInversionMFDs(rupSet, false, false, false, "preInvGR_MFDs.pdf");
        rupSet = InversionFaultSystemRupSetFactory.forBranch(FaultModels.FM3_1, DeformationModels.ZENG, InversionModels.GR_CONSTRAINED, ScalingRelationships.SHAW_2009_MOD, SlipAlongRuptureModels.TAPERED, TotalMag5Rate.RATE_7p9, MaxMagOffFault.MAG_7p6, MomentRateFixes.APPLY_IMPLIED_CC, SpatialSeisPDF.UCERF3);
        FaultSystemRupSetCalc.plotPreInversionMFDs(rupSet, false, false, false, "preInvGR_MFDs_applCC.pdf");
    }

    public static void makeDefModSlipRateMaps() {
        CaliforniaRegions.RELM_TESTING region = new CaliforniaRegions.RELM_TESTING();
        File saveDir = GMT_CA_Maps.GMT_DIR;
        boolean display = true;
        try {
            FaultBasedMapGen.plotDeformationModelSlips(region, saveDir, display);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void makeParentSectConvergenceTable(File csvOutputFile, U3AverageFaultSystemSolution aveSol, int parentSectionID) throws IOException {
        List<Integer> rups = aveSol.getRupSet().getRupturesForParentSection(parentSectionID);
        CSVFile csv = new CSVFile(true);
        int numSols = aveSol.getNumSolutions();
        ArrayList header = Lists.newArrayList();
        header.add("Rup ID");
        header.add("Mag");
        header.add("Length (km)");
        header.add("Start Sect");
        header.add("End Sect");
        header.add("Mean Rate");
        header.add("Min Rate");
        header.add("Max Rate");
        header.add("Std Dev Rate");
        for (int i = 0; i < numSols; ++i) {
            header.add("Rate #" + i);
        }
        csv.addLine(header);
        for (int rup : rups) {
            ArrayList line = Lists.newArrayList();
            List<FaultSection> sects = aveSol.getRupSet().getFaultSectionDataForRupture(rup);
            double[] rates = aveSol.getRatesForAllSols(rup);
            line.add("" + rup);
            line.add("" + aveSol.getRupSet().getMagForRup(rup));
            line.add("" + aveSol.getRupSet().getLengthForRup(rup) / 1000.0);
            line.add(sects.get(0).getSectionName());
            line.add(sects.get(sects.size() - 1).getSectionName());
            line.add("" + aveSol.getRateForRup(rup));
            line.add("" + aveSol.getRateMin(rup));
            line.add("" + aveSol.getRateMax(rup));
            line.add("" + aveSol.getRateStdDev(rup));
            for (int i = 0; i < rates.length; ++i) {
                line.add("" + rates[i]);
            }
            csv.addLine(line);
        }
        csv.writeToFile(csvOutputFile);
    }

    public static void makeCompoundFSSMomentRatesTable(U3CompoundFaultSystemSolution cfss, File csvFile) throws IOException {
        double target;
        DiscretizedFunc func;
        int i;
        Object dmWeights;
        CSVFile csv = new CSVFile(true);
        ArrayList header = Lists.newArrayList();
        for (Class<? extends U3LogicTreeBranchNode<?>> clazz : U3LogicTreeBranch.getLogicTreeNodeClasses()) {
            header.add(ClassUtils.getClassNameWithoutPackage(clazz));
        }
        header.add("A Priori Branch Weight");
        header.add(FAULT_SUPRA_TARGET);
        header.add(FAULT_SUPRA_SOLUTION);
        header.add(FAULT_SUB_TARGET);
        header.add(FAULT_SUB_SOLUTION);
        header.add(TRULY_OFF_TARGET);
        header.add(TRULY_OFF_SOLUTION);
        csv.addLine(header);
        ArrayList branches = Lists.newArrayList(cfss.getBranches());
        Collections.sort(branches);
        Splitter splitter = Splitter.on((String)"\n");
        U3APrioriBranchWeightProvider weightProv = new U3APrioriBranchWeightProvider();
        HashMap dmWeightsMap = Maps.newHashMap();
        double totWt = 0.0;
        for (Object branch : branches) {
            double weight = weightProv.getWeight((U3LogicTreeBranch)branch);
            totWt += weight;
            DeformationModels dm = ((LogicTreeBranch)branch).getValue(DeformationModels.class);
            dmWeights = (List)dmWeightsMap.get(dm);
            if (dmWeights == null) {
                dmWeights = Lists.newArrayList();
                dmWeightsMap.put(dm, dmWeights);
            }
            dmWeights.add(weight);
        }
        HashMap dmWeightTotsMap = Maps.newHashMap();
        for (DeformationModels dm : dmWeightsMap.keySet()) {
            double dmTotWt = 0.0;
            dmWeights = ((List)dmWeightsMap.get(dm)).iterator();
            while (dmWeights.hasNext()) {
                double weight = (Double)dmWeights.next();
                dmTotWt += weight;
            }
            dmWeightTotsMap.put(dm, dmTotWt);
        }
        double hist_min = 0.0;
        double hist_max = 3.0;
        double hist_delta = 0.1;
        int hist_num = (int)((hist_max - hist_min) / hist_delta + 1.0);
        HistogramFunction totOffHist = new HistogramFunction(hist_min, hist_num, hist_delta);
        HashMap dmOffHistMap = Maps.newHashMap();
        for (DeformationModels dm : dmWeightTotsMap.keySet()) {
            dmOffHistMap.put(dm, new HistogramFunction(hist_min, hist_num, hist_delta));
        }
        HistogramFunction totOnHist = new HistogramFunction(hist_min, hist_num, hist_delta);
        HashMap dmOnHistMap = Maps.newHashMap();
        for (DeformationModels dm : dmWeightTotsMap.keySet()) {
            dmOnHistMap.put(dm, new HistogramFunction(hist_min, hist_num, hist_delta));
        }
        HistogramFunction totTotHist = new HistogramFunction(hist_min, hist_num, hist_delta);
        HashMap dmTotHistMap = Maps.newHashMap();
        for (DeformationModels dm : dmWeightTotsMap.keySet()) {
            dmTotHistMap.put(dm, new HistogramFunction(hist_min, hist_num, hist_delta));
        }
        for (U3LogicTreeBranch branch : branches) {
            DeformationModels dm = branch.getValue(DeformationModels.class);
            ArrayList line = Lists.newArrayList();
            for (int i2 = 0; i2 < U3LogicTreeBranch.getLogicTreeNodeClasses().size(); ++i2) {
                line.add(((U3LogicTreeBranchNode)branch.getValue(i2)).getShortName());
            }
            ArrayList info = Lists.newArrayList((Iterable)splitter.split((CharSequence)cfss.getInfo(branch)));
            double origWt = weightProv.getWeight(branch);
            double totScaledWt = origWt / totWt;
            double dmScaledWt = origWt / (Double)dmWeightTotsMap.get(dm);
            line.add("" + totScaledWt);
            double supra = TablesAndPlotsGen.getField(info, FAULT_SUPRA_SOLUTION);
            double sub = TablesAndPlotsGen.getField(info, FAULT_SUB_SOLUTION);
            double off = TablesAndPlotsGen.getField(info, TRULY_OFF_SOLUTION);
            line.add("" + TablesAndPlotsGen.getField(info, FAULT_SUPRA_TARGET));
            line.add("" + supra);
            line.add("" + TablesAndPlotsGen.getField(info, FAULT_SUB_TARGET));
            line.add("" + sub);
            line.add("" + TablesAndPlotsGen.getField(info, TRULY_OFF_TARGET));
            line.add("" + off);
            double tot = supra + sub + off;
            double onTot = sub + supra;
            totTotHist.add(tot / 1.0E19, totScaledWt);
            ((HistogramFunction)dmTotHistMap.get(dm)).add(tot / 1.0E19, totScaledWt);
            totOnHist.add(onTot / 1.0E19, totScaledWt);
            ((HistogramFunction)dmOnHistMap.get(dm)).add(onTot / 1.0E19, totScaledWt);
            totOffHist.add(off / 1.0E19, totScaledWt);
            ((HistogramFunction)dmOffHistMap.get(dm)).add(off / 1.0E19, totScaledWt);
            csv.addLine(line);
        }
        csv.writeToFile(csvFile);
        Color[] dmColors = new Color[]{Color.RED, Color.ORANGE, Color.GREEN, Color.MAGENTA};
        ArrayList dms = Lists.newArrayList(dmTotHistMap.keySet());
        Collections.sort(dms, new Comparator<DeformationModels>(){

            @Override
            public int compare(DeformationModels o1, DeformationModels o2) {
                return o1.name().compareTo(o2.name());
            }
        });
        String name = csvFile.getName();
        if (name.contains("_mo_rates.csv")) {
            name = name.substring(0, name.indexOf("_mo_rates"));
        }
        if (name.contains(".csv")) {
            name = name.substring(0, name.indexOf(".csv"));
        }
        HashMap dmTotTargets = Maps.newHashMap();
        HashMap dmOnTargets = Maps.newHashMap();
        HashMap dmOffTargets = Maps.newHashMap();
        FaultModels[] fms = new FaultModels[]{FaultModels.FM3_1, FaultModels.FM3_2};
        for (DeformationModels dm : dms) {
            double dmTotTarget = 0.0;
            double dmOnTarget = 0.0;
            double dmOffTarget = 0.0;
            for (FaultModels fm : fms) {
                DeformationModelFetcher defFetch = new DeformationModelFetcher(fm, dm, UCERF3_DataUtils.DEFAULT_SCRATCH_DATA_DIR, 0.1);
                double moRate = DeformationModelsCalc.calculateTotalMomentRate(defFetch.getSubSectionList(), true);
                double moRateOffFaults = DeformationModelsCalc.calcMoRateOffFaultsForDefModel(fm, dm);
                double totMoRate = moRate + moRateOffFaults;
                dmTotTarget += totMoRate;
                dmOffTarget += moRateOffFaults;
                dmOnTarget += moRate;
            }
            dmTotTargets.put(dm, (dmTotTarget /= (double)fms.length) / 1.0E19);
            dmOnTargets.put(dm, (dmOnTarget /= (double)fms.length) / 1.0E19);
            dmOffTargets.put(dm, (dmOffTarget /= (double)fms.length) / 1.0E19);
        }
        File dir = csvFile.getParentFile();
        double minX = 0.0;
        double maxX = 3.0;
        double minY = 0.0;
        double maxY = 0.525;
        ArrayList funcs = Lists.newArrayList();
        ArrayList chars = Lists.newArrayList();
        totOnHist.setName("On Fault Histogram");
        totOnHist.setInfo("Mean: " + totOnHist.computeMean() + "\nStd Dev: " + totOnHist.computeStdDev());
        funcs.add(totOnHist);
        chars.add(new PlotCurveCharacterstics(PlotLineType.HISTOGRAM, 10.0f, Color.BLUE));
        for (i = 0; i < dms.size(); ++i) {
            DeformationModels dm = (DeformationModels)dms.get(i);
            Color color = dmColors[i];
            func = (DiscretizedFunc)dmOnHistMap.get(dm);
            func.setName(dm.getName());
            funcs.add(func);
            chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, color));
            target = (Double)dmOnTargets.get(dm);
            ArbitrarilyDiscretizedFunc targetLine = new ArbitrarilyDiscretizedFunc();
            targetLine.set(target, 0.0);
            targetLine.set(target * 1.0001, maxY);
            targetLine.setName(dm.getName() + " On Fault Target");
            funcs.add(targetLine);
            System.out.println("On Fault Target (" + dm.name() + "): " + target);
            chars.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 2.0f, color));
        }
        totOffHist.setName("Off Fault Histogram");
        totOffHist.setInfo("Mean: " + totOffHist.computeMean() + "\nStd Dev: " + totOffHist.computeStdDev());
        funcs.add(totOffHist);
        chars.add(new PlotCurveCharacterstics(PlotLineType.HISTOGRAM, 10.0f, Color.GRAY));
        for (i = 0; i < dms.size(); ++i) {
            DeformationModels dm = (DeformationModels)dms.get(i);
            Color color = dmColors[i];
            func = (DiscretizedFunc)dmOffHistMap.get(dm);
            func.setName(dm.getName());
            funcs.add(func);
            chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, color));
            if (dm == DeformationModels.GEOLOGIC) continue;
            target = (Double)dmOffTargets.get(dm);
            ArbitrarilyDiscretizedFunc targetLine = new ArbitrarilyDiscretizedFunc();
            targetLine.set(target, 0.0);
            targetLine.set(target * 1.0001, maxY);
            targetLine.setName(dm.getName() + " Off Fault Target");
            funcs.add(targetLine);
            System.out.println("Off Fault Target (" + dm.name() + "): " + target);
            chars.add(new PlotCurveCharacterstics(PlotLineType.DOTTED, 2.0f, color));
        }
        HeadlessGraphPanel gp = new HeadlessGraphPanel();
        CommandLineInversionRunner.setFontSizes(gp);
        gp.setBackgroundColor(Color.WHITE);
        gp.setUserBounds(minX, maxX, minY, maxY);
        gp.drawGraphPanel("Moment Rate (10^19 Nm/yr)", "Branch Weight", funcs, chars, "Moment Rate Distribution");
        File outputFile = new File(dir, name + "_mo_rate_dist_on_off");
        gp.getChartPanel().setSize(1000, 800);
        gp.saveAsPNG(outputFile.getAbsolutePath() + ".png");
        gp.saveAsPDF(outputFile.getAbsolutePath() + ".pdf");
        gp.saveAsTXT(outputFile.getAbsolutePath() + ".txt");
        outputFile = new File(outputFile.getAbsolutePath() + "_small");
        gp.getChartPanel().setSize(500, 400);
        gp.saveAsPNG(outputFile.getAbsolutePath() + ".png");
        gp.saveAsPDF(outputFile.getAbsolutePath() + ".pdf");
        gp.saveAsTXT(outputFile.getAbsolutePath() + ".txt");
        funcs = Lists.newArrayList();
        chars = Lists.newArrayList();
        totTotHist.setName("Total Histogram");
        totTotHist.setInfo("Mean: " + totTotHist.computeMean() + "\nStd Dev: " + totTotHist.computeStdDev());
        funcs.add(totTotHist);
        chars.add(new PlotCurveCharacterstics(PlotLineType.HISTOGRAM, 10.0f, Color.BLACK));
        for (int i3 = 0; i3 < dms.size(); ++i3) {
            DeformationModels dm = (DeformationModels)dms.get(i3);
            Color color = dmColors[i3];
            DiscretizedFunc func2 = (DiscretizedFunc)dmTotHistMap.get(dm);
            func2.setName(dm.getName());
            funcs.add(func2);
            chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, color));
            if (dm == DeformationModels.GEOLOGIC) continue;
            double target2 = (Double)dmTotTargets.get(dm);
            ArbitrarilyDiscretizedFunc targetLine = new ArbitrarilyDiscretizedFunc();
            targetLine.set(target2, 0.0);
            targetLine.set(target2 * 1.0001, maxY);
            targetLine.setName(dm.getName() + " Total Target");
            funcs.add(targetLine);
            System.out.println("Total Target (" + dm.name() + "): " + target2);
            chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, color));
        }
        gp = new HeadlessGraphPanel();
        CommandLineInversionRunner.setFontSizes(gp);
        gp.setBackgroundColor(Color.WHITE);
        gp.setUserBounds(minX, maxX, minY, maxY);
        gp.drawGraphPanel("Moment Rate (10^19 Nm/yr)", "Branch Weight", funcs, chars, "Moment Rate Distribution");
        outputFile = new File(dir, name + "_mo_rate_dist_total");
        gp.getChartPanel().setSize(1000, 800);
        gp.saveAsPNG(outputFile.getAbsolutePath() + ".png");
        gp.saveAsPDF(outputFile.getAbsolutePath() + ".pdf");
        gp.saveAsTXT(outputFile.getAbsolutePath() + ".txt");
        outputFile = new File(outputFile.getAbsolutePath() + "_small");
        gp.getChartPanel().setSize(500, 400);
        gp.saveAsPNG(outputFile.getAbsolutePath() + ".png");
        gp.saveAsPDF(outputFile.getAbsolutePath() + ".pdf");
        gp.saveAsTXT(outputFile.getAbsolutePath() + ".txt");
    }

    private static double getField(List<String> infoLines, String fieldStart) {
        for (String infoLine : infoLines) {
            if (!(infoLine = infoLine.trim()).startsWith(fieldStart)) continue;
            return Double.parseDouble(infoLine.substring(infoLine.lastIndexOf(" ") + 1));
        }
        return Double.NaN;
    }

    public static HistogramFunction loadSurfaceRupData() throws IOException {
        POIFSFileSystem fs = new POIFSFileSystem(UCERF3_DataUtils.locateResourceAsStream("misc", "Surface_Rupture_Data_Wells_043013.xls"));
        HSSFWorkbook wb = new HSSFWorkbook(fs);
        HSSFSheet sheet = wb.getSheetAt(0);
        int allSRL_col = 28;
        HistogramFunction hist = TablesAndPlotsGen.buildEmptyLengthHist();
        int cnt = 0;
        for (int rowIndex = 0; rowIndex <= sheet.getLastRowNum(); ++rowIndex) {
            HSSFCell cell;
            HSSFRow row = sheet.getRow(rowIndex);
            if (row == null || (cell = row.getCell(allSRL_col)) == null || cell.getCellType() != 0) continue;
            double length = cell.getNumericCellValue();
            hist.add(length, 1.0);
            ++cnt;
        }
        wb.close();
        System.out.println("Loaded " + cnt + " values from data file");
        hist.normalizeBySumOfY_Vals();
        return hist;
    }

    private static HistogramFunction buildEmptyLengthHist() {
        return new HistogramFunction(25.0, 25, 50.0);
    }

    public static void buildRupLengthComparisonPlot(U3CompoundFaultSystemSolution cfss, File dir, String prefix) throws IOException {
        Object lengths;
        ArrayList hists = Lists.newArrayList();
        for (U3LogicTreeBranch branch : cfss.getBranches()) {
            lengths = cfss.getLengths(branch);
            double[] rates = cfss.getRates(branch);
            HistogramFunction hist = TablesAndPlotsGen.buildEmptyLengthHist();
            for (int r = 0; r < ((Object)lengths).length; ++r) {
                hist.add((double)(lengths[r] / 1000.0), rates[r]);
            }
            hist.normalizeBySumOfY_Vals();
            hists.add(hist);
        }
        HistogramFunction data = TablesAndPlotsGen.loadSurfaceRupData();
        XY_DataSetList xyList = new XY_DataSetList();
        lengths = hists.iterator();
        while (lengths.hasNext()) {
            HistogramFunction hist = (HistogramFunction)lengths.next();
            xyList.add(hist);
        }
        U3APrioriBranchWeightProvider weightProv = new U3APrioriBranchWeightProvider();
        ArrayList weights = Lists.newArrayList();
        for (U3LogicTreeBranch branch : cfss.getBranches()) {
            weights.add(weightProv.getWeight(branch));
        }
        List<DiscretizedFunc> solFuncs = CompoundFSSPlots.getFractiles(xyList, weights, "Surface Rupture Length", new double[0]);
        List<PlotCurveCharacterstics> solChars = CompoundFSSPlots.getFractileChars(Color.RED, 0);
        ArrayList funcs = Lists.newArrayList();
        ArrayList chars = Lists.newArrayList();
        funcs.addAll(solFuncs);
        chars.addAll(solChars);
        funcs.add(data);
        chars.add(new PlotCurveCharacterstics(PlotLineType.HISTOGRAM, 1.0f, Color.BLUE));
        HeadlessGraphPanel gp = new HeadlessGraphPanel();
        CommandLineInversionRunner.setFontSizes(gp);
        gp.setBackgroundColor(Color.WHITE);
        gp.setRenderingOrder(DatasetRenderingOrder.REVERSE);
        gp.setUserBounds(0.0, 500.0, 0.0, 1.0);
        gp.drawGraphPanel("Rupture Length (km)", "Fraction of Earthquakes", funcs, chars, "Rupture Length Distribution");
        File outputFile = new File(dir, prefix + "_length_dists");
        gp.getChartPanel().setSize(1000, 800);
        gp.saveAsPNG(outputFile.getAbsolutePath() + ".png");
        gp.saveAsPDF(outputFile.getAbsolutePath() + ".pdf");
        gp.saveAsTXT(outputFile.getAbsolutePath() + ".txt");
    }

    public static void makeNumRunsForRateWithin10Plot(U3AverageFaultSystemSolution avgSol, File outputDir, String prefix) throws IOException {
        DefaultXY_DataSet scatter = new DefaultXY_DataSet();
        for (int r = 0; r < avgSol.getRupSet().getNumRuptures(); ++r) {
            double s = avgSol.getRateStdDev(r);
            double m = avgSol.getRateForRup(r);
            double n = Math.pow(19.6 * s / m, 2.0);
            scatter.set(m, n);
        }
        ArrayList funcs = Lists.newArrayList();
        funcs.add(scatter);
        ArrayList chars = Lists.newArrayList();
        chars.add(new PlotCurveCharacterstics(PlotSymbol.CROSS, 3.0f, Color.BLACK));
        double minX = Double.POSITIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        for (Point2D pt : scatter) {
            double x = pt.getX();
            double y = pt.getY();
            if (x < 1.0E-14 || y < 1.0E-14) continue;
            if (x < minX) {
                minX = x;
            }
            if (!(y < minY)) continue;
            minY = y;
        }
        System.out.println("mins: " + minX + ", " + minY);
        HeadlessGraphPanel gp = new HeadlessGraphPanel();
        CommandLineInversionRunner.setFontSizes(gp);
        gp.setBackgroundColor(Color.WHITE);
        gp.setXLog(true);
        gp.setYLog(true);
        gp.setUserBounds(minX, scatter.getMaxX(), minY, scatter.getMaxY());
        gp.drawGraphPanel("Mean Rupture Rate", "N for 95%-Conf within 10%", funcs, chars, "");
        File file = new File(outputDir, prefix);
        gp.getChartPanel().setSize(1000, 800);
        gp.saveAsPNG(file.getAbsolutePath() + ".png");
        gp.saveAsPDF(file.getAbsolutePath() + ".pdf");
        file = new File(outputDir, prefix + "_small");
        gp.getChartPanel().setSize(500, 400);
        gp.saveAsPDF(file.getAbsolutePath() + ".pdf");
        gp.saveAsPNG(file.getAbsolutePath() + ".png");
    }

    /*
     * WARNING - void declaration
     */
    public static void makeSlipMisfitHistograms(File u3XMLFile, File u2XMLFile, File outputDir) throws DocumentException, IOException {
        void var17_22;
        boolean norm = true;
        List<CompoundFSSPlots.MapPlotData> u3Datas = CompoundFSSPlots.MapBasedPlot.loadPlotData(u3XMLFile);
        List<CompoundFSSPlots.MapPlotData> u2Datas = CompoundFSSPlots.MapBasedPlot.loadPlotData(u2XMLFile);
        CompoundFSSPlots.MapPlotData u3Misfits = null;
        for (CompoundFSSPlots.MapPlotData mapPlotData : u3Datas) {
            String name = mapPlotData.getFileName();
            if (!name.endsWith("slip_rate_misfit") || name.startsWith("FM") && !name.startsWith("FM3_1")) continue;
            u3Misfits = mapPlotData;
        }
        Preconditions.checkNotNull(u3Misfits, (Object)("Couldn't find slip misfit data in xml file: " + u3XMLFile.getAbsolutePath()));
        CompoundFSSPlots.MapPlotData u2Misfits = null;
        for (CompoundFSSPlots.MapPlotData data : u2Datas) {
            String name = data.getFileName();
            if (!name.endsWith("slip_rate_misfit")) continue;
            u2Misfits = data;
        }
        Preconditions.checkNotNull(u2Misfits, (Object)("Couldn't find slip misfit data in xml file: " + u2XMLFile.getAbsolutePath()));
        int n = 100;
        double histDelta = 0.05;
        HistogramFunction u2Hist = new HistogramFunction(0.0, n, histDelta);
        HistogramFunction u3Hist = new HistogramFunction(0.0, n, histDelta);
        ArrayList u2SkipTraces = null;
        ArrayList u2SkipParentIDs = Lists.newArrayList((Object[])new Integer[]{12, 29, 16, 17});
        if (u2SkipParentIDs != null && !u2SkipParentIDs.isEmpty()) {
            u2SkipTraces = Lists.newArrayList();
            List<? extends FaultSection> u2SubSects = new DeformationModelFetcher(FaultModels.FM2_1, DeformationModels.UCERF2_ALL, UCERF3_DataUtils.DEFAULT_SCRATCH_DATA_DIR, 0.1).getSubSectionList();
            for (FaultSection faultSection : u2SubSects) {
                if (!u2SkipParentIDs.contains(faultSection.getParentSectionId())) continue;
                u2SkipTraces.add(faultSection.getFaultTrace());
            }
        }
        FileWriter u2FW = new FileWriter(new File(outputDir, "slip_misfit_u2_vals.txt"));
        FileWriter u3FW = new FileWriter(new File(outputDir, "slip_misfit_u3_vals.txt"));
        boolean bl = false;
        while (var17_22 < u2Misfits.getFaults().size()) {
            double value = u2Misfits.getFaultValues()[var17_22];
            if (u2SkipTraces != null) {
                LocationList trace = u2Misfits.getFaults().get((int)var17_22);
                block4: for (LocationList oTrace : u2SkipTraces) {
                    for (int i = 0; i < trace.size(); ++i) {
                        if (!((Location)oTrace.get(i)).equals(trace.get(i))) continue block4;
                    }
                    System.out.println("Skipping a sub sect!");
                    break;
                }
            } else {
                u2Hist.add(Math.abs(value), 1.0);
                u2FW.write(Math.abs(value) + "\n");
            }
            ++var17_22;
        }
        for (double value : u3Misfits.getFaultValues()) {
            u3Hist.add(Math.abs(value), 1.0);
            u3FW.write(Math.abs(value) + "\n");
        }
        u2FW.close();
        u3FW.close();
        if (norm) {
            u3Hist.normalizeBySumOfY_Vals();
            u2Hist.normalizeBySumOfY_Vals();
        }
        u2Hist.setName("UCERF2 Slip Rate Misfit Histogram");
        u2Hist.setInfo("Mean: " + u2Hist.computeMean() + "\nStd Dev: " + u2Hist.computeStdDev());
        u3Hist.setName("UCERF3 Slip Rate Misfit Histogram");
        u3Hist.setInfo("Mean: " + u3Hist.computeMean() + "\nStd Dev: " + u3Hist.computeStdDev());
        ArrayList arrayList = Lists.newArrayList();
        arrayList.add(u3Hist);
        arrayList.add(u2Hist);
        ArrayList chars = Lists.newArrayList();
        chars.add(new PlotCurveCharacterstics(PlotLineType.HISTOGRAM, 1.0f, Color.BLACK));
        chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.RED));
        HeadlessGraphPanel gp = new HeadlessGraphPanel();
        CommandLineInversionRunner.setFontSizes(gp);
        gp.setBackgroundColor(Color.WHITE);
        gp.setXLog(false);
        gp.setYLog(false);
        gp.setUserBounds(0.0, 3.0, 0.0, u3Hist.getMaxY() * 1.1);
        String yAxisLabel = norm ? "Fraction" : "Number";
        gp.drawGraphPanel("Subsection Slip Rate Misfit (solution/target)", yAxisLabel, arrayList, chars, "Slip Rate Misfits");
        File file = new File(outputDir, "slip_misfit_hist");
        gp.getChartPanel().setSize(1000, 800);
        gp.saveAsPNG(file.getAbsolutePath() + ".png");
        gp.saveAsPDF(file.getAbsolutePath() + ".pdf");
        gp.saveAsTXT(file.getAbsolutePath() + ".txt");
        file = new File(file.getAbsolutePath() + "_small");
        gp.getChartPanel().setSize(500, 400);
        gp.saveAsPDF(file.getAbsolutePath() + ".pdf");
        gp.saveAsPNG(file.getAbsolutePath() + ".png");
    }

    public static void makeRenewalModelNoDateOfLastPlots() {
        BPT_DistCalc bptCalc = new BPT_DistCalc();
        double mean = 100.0;
        double deltaX = 0.01;
        int numPoints = (int)Math.round(5.0 * mean / deltaX);
        double histOpenInterval = 0.0;
        double[] aperArray = new double[]{0.2, 0.7};
        PlotLineType[] lineType = new PlotLineType[]{PlotLineType.DASHED, PlotLineType.SOLID};
        ArrayList<ArbitrarilyDiscretizedFunc> funcList = new ArrayList<ArbitrarilyDiscretizedFunc>();
        ArrayList<PlotCurveCharacterstics> plotChars = new ArrayList<PlotCurveCharacterstics>();
        int index = -1;
        for (double aperiodicity : aperArray) {
            ++index;
            EvenlyDiscretizedFunc logX_func = new EvenlyDiscretizedFunc(Math.log10(0.01), Math.log10(4.0), 100);
            ArbitrarilyDiscretizedFunc bpt_func = new ArbitrarilyDiscretizedFunc();
            bpt_func.setName("bpt_func");
            ArbitrarilyDiscretizedFunc poisN1_func = new ArbitrarilyDiscretizedFunc();
            poisN1_func.setName("poisN1_func");
            ArbitrarilyDiscretizedFunc poisNge1_func = new ArbitrarilyDiscretizedFunc();
            poisNge1_func.setName("poisNge1_func");
            ArbitrarilyDiscretizedFunc bpt_poisNge1_ratio_func = new ArbitrarilyDiscretizedFunc();
            for (int i = 0; i < logX_func.size(); ++i) {
                double durOverMean = Math.pow(10.0, logX_func.getX(i));
                double duration = mean * durOverMean;
                bptCalc.setAllParameters(mean, aperiodicity, deltaX, numPoints, duration, histOpenInterval);
                double bptProb = bptCalc.getCondProbForUnknownTimeSinceLastEvent();
                bpt_func.set(durOverMean, bptProb);
                double poisNge1_prob = 1.0 - Math.exp(-durOverMean);
                poisNge1_func.set(durOverMean, poisNge1_prob);
                double poisProbOf1 = durOverMean * Math.exp(-durOverMean);
                poisN1_func.set(durOverMean, poisProbOf1);
                bpt_poisNge1_ratio_func.set(durOverMean, bptProb / poisNge1_prob);
            }
            double maxRatio = bpt_poisNge1_ratio_func.getMaxY();
            bpt_func.setInfo(bptCalc.getAdjParams().toString() + "\nbptProb/poisNge1_prob = 1.1 at durOverMean = " + (float)bpt_poisNge1_ratio_func.getFirstInterpolatedX(1.1) + "\nbptProb/poisNge1_prob for durOverMean of 1.2 (30yr Parkfiled forecast) = " + bpt_poisNge1_ratio_func.getInterpolatedY(1.2) + "\nbptProb/poisNge1_prob has maximum of " + maxRatio + " durOverMean=" + (float)bpt_poisNge1_ratio_func.getFirstInterpolatedX(maxRatio));
            if (index == 1) {
                funcList.add(poisNge1_func);
                plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, null, 0.0f, Color.GRAY));
            }
            funcList.add(bpt_func);
            plotChars.add(new PlotCurveCharacterstics(lineType[index], 3.0f, null, 0.0f, Color.BLACK));
        }
        GraphWindow graph = new GraphWindow(funcList, "", plotChars);
        graph.setX_AxisRange(0.0, 4.0);
        graph.setY_AxisRange(0.0, 1.01);
        graph.setX_AxisLabel("Duration/Mean");
        graph.setY_AxisLabel("Probability");
        graph.setTickLabelFontSize(24);
        graph.setAxisLabelFontSize(28);
        graph.setPlotLabelFontSize(18);
        String fileName = "RenewalModelNoDateOfLastPlot.pdf";
        try {
            graph.saveAsPDF(fileName);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void makeRenewalModelPDF_CDF_EtcPlot() {
        BPT_DistCalc bptCalc = new BPT_DistCalc();
        double mean = 1.0;
        double deltaX = 0.01;
        int numPoints = (int)Math.round(4.0 * mean / deltaX);
        double[] aperArray = new double[]{0.2, 0.7};
        PlotLineType[] lineType = new PlotLineType[]{PlotLineType.DASHED, PlotLineType.SOLID};
        ArrayList<EvenlyDiscretizedFunc> funcList1 = new ArrayList<EvenlyDiscretizedFunc>();
        ArrayList<PlotCurveCharacterstics> plotChars1 = new ArrayList<PlotCurveCharacterstics>();
        ArrayList<EvenlyDiscretizedFunc> funcList2 = new ArrayList<EvenlyDiscretizedFunc>();
        ArrayList<PlotCurveCharacterstics> plotChars2 = new ArrayList<PlotCurveCharacterstics>();
        int index = -1;
        for (double aperiodicity : aperArray) {
            bptCalc.setAllParameters(mean, aperiodicity, deltaX, numPoints, 0.3, 0.0);
            funcList1.add(bptCalc.getPDF());
            ((DiscretizedFunc)funcList1.get(funcList1.size() - 1)).setName("PDF; aper=+aperiodicity");
            plotChars1.add(new PlotCurveCharacterstics(lineType[++index], 3.0f, null, 0.0f, Color.BLACK));
            funcList2.add(bptCalc.getCDF());
            ((DiscretizedFunc)funcList2.get(funcList2.size() - 1)).setName("CDF; aper=+aperiodicity");
            plotChars2.add(new PlotCurveCharacterstics(lineType[index], 3.0f, null, 0.0f, Color.BLACK));
            funcList2.add(bptCalc.getTimeSinceLastEventPDF());
            ((DiscretizedFunc)funcList2.get(funcList2.size() - 1)).setName("Prob date of last; aper=+aperiodicity");
            plotChars2.add(new PlotCurveCharacterstics(lineType[index], 3.0f, null, 0.0f, Color.GRAY));
        }
        GraphWindow graph1 = new GraphWindow(funcList1, "", plotChars1);
        graph1.setX_AxisRange(0.0, 4.0);
        graph1.setY_AxisRange(0.0, 2.1);
        graph1.setX_AxisLabel("Time Since Last Event (years)");
        graph1.setY_AxisLabel("Probability");
        graph1.setTickLabelFontSize(24);
        graph1.setAxisLabelFontSize(28);
        graph1.setPlotLabelFontSize(18);
        String fileName1 = "RenewalModelPDF.pdf";
        GraphWindow graph2 = new GraphWindow(funcList2, "", plotChars2);
        graph2.setX_AxisRange(0.0, 4.0);
        graph2.setY_AxisRange(0.0, 1.05);
        graph2.setX_AxisLabel("Time Since Last Event (years)");
        graph2.setY_AxisLabel("Probability");
        graph2.setTickLabelFontSize(24);
        graph2.setAxisLabelFontSize(28);
        graph2.setPlotLabelFontSize(18);
        String fileName2 = "RenewalModelCDF_EtcPlot.pdf";
        try {
            graph1.saveAsPDF(fileName1);
            graph2.saveAsPDF(fileName2);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void makeRenewalModelHistoricOpenIntervalPlots() {
        BPT_DistCalc bptCalc = new BPT_DistCalc();
        double mean = 100.0;
        double[] durationOverMeanArray = new double[]{0.001, 0.1, 0.3, 0.5, 0.7, 1.0};
        double deltaX = 0.01;
        int numPoints = (int)Math.round(5.0 * mean / deltaX);
        double[] aperArray = new double[]{0.2, 0.3, 0.7};
        double[] yAxisMaxForPlot = new double[]{10.0, 5.5, 1.5};
        double[] yAxisMinForPlot = new double[]{0.0, 0.5, 0.95};
        int aperIndex = -1;
        for (double aperiodicity : aperArray) {
            ++aperIndex;
            System.out.println("aperiodicity = " + aperiodicity);
            ArrayList<ArbitrarilyDiscretizedFunc> funcList = new ArrayList<ArbitrarilyDiscretizedFunc>();
            for (double durOverMean : durationOverMeanArray) {
                double duration = durOverMean * mean;
                bptCalc.setAllParameters(mean, aperiodicity, deltaX, numPoints, duration, 0.0);
                double zeroOpenIntBPT_Prob = bptCalc.getCondProbForUnknownTimeSinceLastEvent();
                EvenlyDiscretizedFunc logX_func = new EvenlyDiscretizedFunc(Math.log10(1.0E-4), Math.log10(2.0), 100);
                ArbitrarilyDiscretizedFunc bpt_func = new ArbitrarilyDiscretizedFunc();
                bpt_func.setName("BPT Prob Ratio for durOverMean=" + durOverMean + " & aper=" + aperiodicity);
                for (int i = 0; i < logX_func.size(); ++i) {
                    double openIntOverMean = Math.pow(10.0, logX_func.getX(i));
                    double histOpenInterval = mean * openIntOverMean;
                    bptCalc.setAllParameters(mean, aperiodicity, deltaX, numPoints, duration, histOpenInterval);
                    double bptProb = bptCalc.getCondProbForUnknownTimeSinceLastEvent();
                    bpt_func.set(openIntOverMean, bptProb / zeroOpenIntBPT_Prob);
                }
                double xAtY_1pt1 = Double.NaN;
                try {
                    xAtY_1pt1 = bpt_func.getFirstInterpolatedX(1.1);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                System.out.println("\tRatio = 1.1 at x = " + xAtY_1pt1 + " for durOverMean=" + durOverMean);
                bpt_func.setInfo("Ratio = 1.1 at x = " + xAtY_1pt1);
                funcList.add(bpt_func);
            }
            GraphWindow graph = new GraphWindow(funcList, "");
            graph.setX_AxisRange(0.0, 2.0);
            graph.setY_AxisRange(yAxisMinForPlot[aperIndex], yAxisMaxForPlot[aperIndex]);
            graph.setX_AxisLabel("HistOpenInverval/Mean");
            graph.setY_AxisLabel("Probability Ratio");
            graph.setTickLabelFontSize(24);
            graph.setAxisLabelFontSize(28);
            graph.setPlotLabelFontSize(18);
            String fileName = "RenewalModelHistoricOpenIntervalPlot_aper0pt" + (int)Math.round(aperiodicity * 10.0) + ".pdf";
            try {
                graph.saveAsPDF(fileName);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void plotCumulativeDistOfAveU3pt3_FM3pt1_SubsectionRecurrenceIntervals(boolean wtBySectoRate) {
        String f = "dev/scratch/UCERF3/data/scratch/InversionSolutions/2013_05_10-ucerf3p3-production-10runs_COMPOUND_SOL_FM3_1_MEAN_BRANCH_AVG_SOL.zip";
        File file = new File(f);
        System.out.println("Instantiating ERF...");
        FaultSystemSolutionERF erf = null;
        try {
            erf = new FaultSystemSolutionERF(U3FaultSystemIO.loadSol(file));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        erf.getParameter("Apply Aftershock Filter").setValue(false);
        erf.getParameter("Background Seismicity").setValue(IncludeBackgroundOption.EXCLUDE);
        erf.updateForecast();
        File pdfFileName = new File("CumulativeDistOfAveU3pt3_FM3pt1_SubsectionRecurrenceIntervals");
        FaultSysSolutionERF_Calc.plotCumulativeDistOfSubsectionRecurrenceIntervals(erf, wtBySectoRate, pdfFileName);
    }

    public static void writeSubSectRITable(FaultSystemSolution sol, File csvFile) throws IOException {
        CSVFile<String> csv = new CSVFile<String>(true);
        csv.addLine("Subsection Index", "Subsection Name", "Supra-Seis Annual Participation Rate", "Supra-Seis Partitipation RI", "Subsection Min Mag", "Subsection Area (sq m)", "Rake (Degrees)", "Start Lat", "Start Lon", "End Lat", "End Lon");
        double[] particRates = sol.calcParticRateForAllSects(0.0, 10.0);
        FaultSystemRupSet rupSet = sol.getRupSet();
        for (int i = 0; i < particRates.length; ++i) {
            FaultSection subsect = rupSet.getFaultSectionData(i);
            double minMag = Double.POSITIVE_INFINITY;
            for (int r : rupSet.getRupturesForSection(i)) {
                double mag = rupSet.getMagForRup(r);
                if (!(sol.getRateForRup(r) > 0.0) || !(mag < minMag)) continue;
                minMag = mag;
            }
            Location startLoc = subsect.getFaultTrace().first();
            Location endLoc = subsect.getFaultTrace().last();
            csv.addLine("" + i, subsect.getName(), "" + particRates[i], "" + 1.0 / particRates[i], "" + minMag, "" + rupSet.getAreaForSection(i), "" + subsect.getAveRake(), "" + startLoc.getLatitude(), "" + startLoc.getLongitude(), "" + endLoc.getLatitude(), "" + endLoc.getLongitude());
        }
        csv.writeToFile(csvFile);
    }

    public static void main(String[] args) throws IOException, DocumentException {
        TablesAndPlotsGen.makeRenewalModelHistoricOpenIntervalPlots();
    }
}

