/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.enumTreeBranches;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.opensha.commons.data.region.CaliforniaRegions;
import org.opensha.commons.logicTree.Affects;
import org.opensha.commons.logicTree.LogicTreeBranch;
import org.opensha.commons.logicTree.LogicTreeLevel;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.commons.util.XMLUtils;
import org.opensha.commons.util.modules.OpenSHA_Module;
import org.opensha.refFaultParamDb.dao.db.DB_AccessAPI;
import org.opensha.refFaultParamDb.dao.db.DB_ConnectionPool;
import org.opensha.refFaultParamDb.dao.db.FaultModelDB_DAO;
import org.opensha.refFaultParamDb.dao.db.PrefFaultSectionDataDB_DAO;
import org.opensha.refFaultParamDb.vo.FaultSectionPrefData;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.RupSetFaultModel;
import org.opensha.sha.earthquake.faultSysSolution.modules.NamedFaults;
import org.opensha.sha.earthquake.faultSysSolution.modules.PolygonFaultGridAssociations;
import org.opensha.sha.earthquake.faultSysSolution.modules.RegionsOfInterest;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.NSHM23_SegmentationModels;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.U3_UncertAddDeformationModels;
import org.opensha.sha.faultSurface.FaultSection;
import scratch.UCERF3.enumTreeBranches.DeformationModels;
import scratch.UCERF3.enumTreeBranches.InversionModels;
import scratch.UCERF3.griddedSeismicity.FaultPolyMgr;
import scratch.UCERF3.logicTree.U3LogicTreeBranchNode;
import scratch.UCERF3.utils.U3FaultSystemIO;
import scratch.UCERF3.utils.UCERF3_DataUtils;

@Affects.Affected(value={@Affects(value="fault_sections.geojson"), @Affects(value="indices.csv"), @Affects(value="properties.csv"), @Affects(value="rates.csv")})
public enum FaultModels implements U3LogicTreeBranchNode<FaultModels>,
RupSetFaultModel
{
    FM2_1("Fault Model 2.1", 41, 0.0),
    FM3_1("Fault Model 3.1", 101, 0.5),
    FM3_2("Fault Model 3.2", 102, 0.5);

    public static final String XML_ELEMENT_NAME = "FaultModel";
    public static final String FAULT_MODEL_STORE_PROPERTY_NAME = "FaultModelStore";
    private static final String FAULT_MODEL_STORE_DIR_NAME = "FaultModels";
    private String modelName;
    private int id;
    private double weight;
    private Map<Integer, List<Integer>> namedFaultsMap;
    private Map<String, List<Integer>> namedFaultsMapAlt;

    private FaultModels(String modelName, int id, double weight) {
        this.modelName = modelName;
        this.id = id;
        this.weight = weight;
    }

    @Override
    public String getName() {
        return this.modelName;
    }

    @Override
    public String getShortName() {
        return this.name();
    }

    public int getID() {
        return this.id;
    }

    public DeformationModels getFilterBasis() {
        switch (this.ordinal()) {
            case 1: {
                return DeformationModels.GEOLOGIC;
            }
            case 2: {
                return DeformationModels.GEOLOGIC;
            }
        }
        return null;
    }

    public DB_AccessAPI getDBAccess() {
        switch (this.ordinal()) {
            case 0: {
                return DB_ConnectionPool.getDB2ReadOnlyConn();
            }
            case 1: {
                return DB_ConnectionPool.getDB3ReadOnlyConn();
            }
            case 2: {
                return DB_ConnectionPool.getDB3ReadOnlyConn();
            }
        }
        throw new IllegalStateException("DB access cannot be created for Fault Model: " + String.valueOf(this));
    }

    public static ArrayList<FaultSection> loadStoredFaultSections(File fmStoreFile) throws MalformedURLException, DocumentException {
        System.out.println("Loading fault model from: " + fmStoreFile.getAbsolutePath());
        Document doc = XMLUtils.loadDocument(fmStoreFile);
        return FaultModels.loadStoredFaultSections(doc);
    }

    public static ArrayList<FaultSection> loadStoredFaultSections(Document doc) {
        Element root = doc.getRootElement();
        return U3FaultSystemIO.fsDataFromXML(root.element(XML_ELEMENT_NAME));
    }

    @Override
    public Map<Integer, FaultSection> getFaultSectionIDMap() {
        HashMap map = Maps.newHashMap();
        for (FaultSection sect : this.getFaultSections()) {
            map.put(sect.getSectionId(), sect);
        }
        return map;
    }

    public List<FaultSection> getFaultSections() {
        return this.fetchFaultSections(false);
    }

    public ArrayList<FaultSection> fetchFaultSections(boolean ignoreCache) {
        if (!ignoreCache) {
            File fmStoreFile;
            String fmFileName = this.getShortName() + ".xml";
            String fmStoreProp = System.getProperty(FAULT_MODEL_STORE_PROPERTY_NAME);
            if (fmStoreProp != null && (fmStoreFile = new File(fmStoreProp, fmFileName)).exists()) {
                try {
                    return FaultModels.loadStoredFaultSections(fmStoreFile);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            try {
                InputStream is = UCERF3_DataUtils.locateResourceAsStream(FAULT_MODEL_STORE_DIR_NAME, fmFileName);
                System.out.println("Loading FM from cached file: " + fmFileName);
                return FaultModels.loadStoredFaultSections(XMLUtils.loadDocument(is));
            }
            catch (Exception is) {
                // empty catch block
            }
        }
        System.out.println("Loading FM from database: " + String.valueOf(this));
        DB_AccessAPI db = this.getDBAccess();
        PrefFaultSectionDataDB_DAO pref2db = new PrefFaultSectionDataDB_DAO(db);
        ArrayList<FaultSectionPrefData> datas = pref2db.getAllFaultSectionPrefData();
        FaultModelDB_DAO fm2db = new FaultModelDB_DAO(db);
        ArrayList<Integer> faultSectionIds = fm2db.getFaultSectionIdList(this.id);
        ArrayList<FaultSection> faultModel = new ArrayList<FaultSection>();
        for (FaultSection faultSection : datas) {
            if (!faultSectionIds.contains(faultSection.getSectionId())) continue;
            faultModel.add(faultSection);
        }
        return faultModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Integer, List<Integer>> getNamedFaultsMap() {
        if (this.namedFaultsMap == null) {
            FaultModels faultModels = this;
            synchronized (faultModels) {
                try {
                    HashMap map = Maps.newHashMap();
                    BufferedReader br = new BufferedReader(UCERF3_DataUtils.getReader(FAULT_MODEL_STORE_DIR_NAME, this.getShortName() + "FaultsByName.txt"));
                    String line = br.readLine();
                    Splitter s = Splitter.on((char)'\t');
                    while (line != null) {
                        if (!(line = line.trim()).isEmpty()) {
                            ArrayList sects = Lists.newArrayList();
                            for (String idStr : s.split((CharSequence)line)) {
                                sects.add(Integer.parseInt(idStr));
                            }
                            Preconditions.checkState((!sects.isEmpty() ? 1 : 0) != 0, (Object)"Shouldn't be empty here!");
                            for (Integer id : sects) {
                                map.put(id, sects);
                            }
                        }
                        line = br.readLine();
                    }
                    if (this.namedFaultsMap == null) {
                        this.namedFaultsMap = map;
                    }
                }
                catch (Throwable t) {
                    throw ExceptionUtils.asRuntimeException(t);
                }
            }
        }
        return this.namedFaultsMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<Integer>> getNamedFaultsMapAlt() {
        if (this.namedFaultsMapAlt == null) {
            FaultModels faultModels = this;
            synchronized (faultModels) {
                try {
                    Reader reader = UCERF3_DataUtils.getReader(FAULT_MODEL_STORE_DIR_NAME, this.getShortName() + "FaultsByNameAlt.txt");
                    Map<String, List<Integer>> map = FaultModels.parseNamedFaultsAltFile(reader);
                    if (this.namedFaultsMapAlt == null) {
                        this.namedFaultsMapAlt = map;
                    }
                }
                catch (Throwable t) {
                    throw ExceptionUtils.asRuntimeException(t);
                }
            }
        }
        return this.namedFaultsMapAlt;
    }

    public static Map<String, List<Integer>> parseNamedFaultsAltFile(Reader reader) throws IOException {
        HashMap map = Maps.newHashMap();
        BufferedReader br = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        String line = br.readLine();
        Splitter s = Splitter.on((char)'\t');
        while (line != null) {
            if (!(line = line.trim()).isEmpty()) {
                ArrayList sects = Lists.newArrayList();
                String faultname = null;
                boolean isFirst = true;
                for (String idStr : s.split((CharSequence)line)) {
                    if (isFirst) {
                        faultname = idStr.trim();
                        isFirst = false;
                        continue;
                    }
                    sects.add(Integer.parseInt(idStr));
                }
                Preconditions.checkState((!sects.isEmpty() ? 1 : 0) != 0, (Object)"Shouldn't be empty here!");
                map.put(faultname, sects);
            }
            line = br.readLine();
        }
        br.close();
        return map;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public double getRelativeWeight(InversionModels im) {
        return this.weight;
    }

    @Override
    public String encodeChoiceString() {
        return this.getShortName();
    }

    @Override
    public String getBranchLevelName() {
        return "Fault Model";
    }

    @Override
    public String getShortBranchLevelName() {
        return "FM";
    }

    @Override
    public DeformationModels getDefaultDeformationModel() {
        return this.getFilterBasis();
    }

    @Override
    public void attachDefaultModules(final FaultSystemRupSet rupSet) {
        LogicTreeBranch branch = rupSet.getModule(LogicTreeBranch.class);
        boolean nshm23 = false;
        if (branch != null) {
            boolean bl = nshm23 = branch.hasValue(U3_UncertAddDeformationModels.class) || branch.hasValue(NSHM23_SegmentationModels.class);
            if (!nshm23) {
                for (LogicTreeLevel level : branch.getLevels()) {
                    if (level.getType().equals(U3_UncertAddDeformationModels.class)) {
                        nshm23 = true;
                        continue;
                    }
                    if (!level.getType().equals(NSHM23_SegmentationModels.class)) continue;
                    nshm23 = true;
                }
            }
        }
        if (nshm23) {
            rupSet.addAvailableModule((Callable<OpenSHA_Module>)new Callable<NamedFaults>(){
                final /* synthetic */ FaultModels this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public NamedFaults call() throws Exception {
                    Gson gson = new GsonBuilder().create();
                    String namedFaultsFile = "/data/erf/nshm23/fault_models/UCERF3_FM3_1/special_faults.json";
                    BufferedReader reader = new BufferedReader(new InputStreamReader(FaultModels.class.getResourceAsStream(namedFaultsFile)));
                    Type type = TypeToken.getParameterized(Map.class, (Type[])new Type[]{String.class, TypeToken.getParameterized(List.class, (Type[])new Type[]{Integer.class}).getType()}).getType();
                    Map namedFaults = (Map)gson.fromJson((Reader)reader, type);
                    Preconditions.checkState((!namedFaults.isEmpty() ? 1 : 0) != 0, (Object)"No named faults found");
                    return new NamedFaults(rupSet, namedFaults);
                }
            }, NamedFaults.class);
        } else {
            rupSet.addAvailableModule((Callable<OpenSHA_Module>)new Callable<NamedFaults>(){
                final /* synthetic */ FaultModels this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public NamedFaults call() throws Exception {
                    NamedFaults named = this.this$0.getNamedFaults();
                    named.setParent(rupSet);
                    return named;
                }
            }, NamedFaults.class);
        }
        rupSet.addAvailableModule((Callable<OpenSHA_Module>)new Callable<RegionsOfInterest>(){

            @Override
            public RegionsOfInterest call() throws Exception {
                return new RegionsOfInterest(new CaliforniaRegions.RELM_NOCAL(), new CaliforniaRegions.RELM_SOCAL(), new CaliforniaRegions.SF_BOX(), new CaliforniaRegions.LA_BOX());
            }
        }, RegionsOfInterest.class);
        rupSet.addAvailableModule((Callable<OpenSHA_Module>)new Callable<PolygonFaultGridAssociations>(){
            final /* synthetic */ FaultModels this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public PolygonFaultGridAssociations call() throws Exception {
                if (this.this$0 == FM3_1 || this.this$0 == FM3_2) {
                    try {
                        return FaultPolyMgr.loadSerializedUCERF3(this.this$0);
                    }
                    catch (IOException e) {
                        throw ExceptionUtils.asRuntimeException(e);
                    }
                }
                return FaultPolyMgr.create(rupSet.getFaultSectionDataList(), 12.0);
            }
        }, PolygonFaultGridAssociations.class);
    }

    @Override
    public NamedFaults getNamedFaults() {
        Map<String, List<Integer>> namedFaultsMap = this.getNamedFaultsMapAlt();
        if (namedFaultsMap != null) {
            return new NamedFaults(null, this.getNamedFaultsMapAlt());
        }
        return null;
    }
}

