/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.erf.ETAS;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import com.google.common.primitives.Doubles;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.TimeZone;
import javax.swing.JOptionPane;
import org.dom4j.DocumentException;
import org.opensha.commons.data.Named;
import org.opensha.commons.data.TimeSpan;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.data.function.IntegerPDF_FunctionSampler;
import org.opensha.commons.data.region.CaliforniaRegions;
import org.opensha.commons.exceptions.GMT_MapException;
import org.opensha.commons.geo.GriddedRegion;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.commons.geo.LocationVector;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.editor.impl.ParameterListEditor;
import org.opensha.commons.param.impl.DoubleParameter;
import org.opensha.commons.param.impl.LocationParameter;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.commons.util.cpt.CPT;
import org.opensha.sha.earthquake.AbstractNthRupERF;
import org.opensha.sha.earthquake.ProbEqkRupture;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.faultSysSolution.modules.GridSourceProvider;
import org.opensha.sha.earthquake.faultSysSolution.modules.PolygonFaultGridAssociations;
import org.opensha.sha.earthquake.faultSysSolution.modules.SubSeismoOnFaultMFDs;
import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupOrigTimeComparator;
import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupture;
import org.opensha.sha.earthquake.param.ProbabilityModelOptions;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.faultSurface.RuptureSurface;
import org.opensha.sha.gui.infoTools.CalcProgressBar;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import scratch.UCERF3.U3FaultSystemSolution;
import scratch.UCERF3.analysis.FaultBasedMapGen;
import scratch.UCERF3.erf.ETAS.ETAS_CatalogIO;
import scratch.UCERF3.erf.ETAS.ETAS_CubeDiscretizationParams;
import scratch.UCERF3.erf.ETAS.ETAS_EqkRupture;
import scratch.UCERF3.erf.ETAS.ETAS_LongTermMFDs;
import scratch.UCERF3.erf.ETAS.ETAS_Params.ETAS_ParameterList;
import scratch.UCERF3.erf.ETAS.ETAS_Params.U3ETAS_ProbabilityModelOptions;
import scratch.UCERF3.erf.ETAS.ETAS_PrimaryEventSampler;
import scratch.UCERF3.erf.ETAS.ETAS_SimAnalysisTools;
import scratch.UCERF3.erf.ETAS.ETAS_SimulationMetadata;
import scratch.UCERF3.erf.ETAS.ETAS_Utils;
import scratch.UCERF3.erf.ETAS.FaultSystemSolutionERF_ETAS;
import scratch.UCERF3.erf.ETAS.MiscInfoAndPlotsCalc;
import scratch.UCERF3.erf.ETAS.SeisDepthDistribution;
import scratch.UCERF3.erf.ETAS.launcher.ETAS_Launcher;
import scratch.UCERF3.erf.ETAS.launcher.TriggerRupture;
import scratch.UCERF3.erf.FaultSystemSolutionERF;
import scratch.UCERF3.griddedSeismicity.FaultPolyMgr;
import scratch.UCERF3.griddedSeismicity.GriddedSeisUtils;
import scratch.UCERF3.utils.MatrixIO;
import scratch.UCERF3.utils.RELM_RegionUtils;
import scratch.UCERF3.utils.U3FaultSystemIO;
import scratch.UCERF3.utils.U3_EqkCatalogStatewideCompleteness;

public class ETAS_Simulator {
    public static boolean D = true;
    private static boolean live_map = false;
    static boolean pause_for_events = false;
    static boolean exit_after_scenario_diagnostics = false;

    public static ETAS_SimulationMetadata runETAS_Simulation(File resultsDir, AbstractNthRupERF erf, GriddedRegion griddedRegion, ETAS_EqkRupture scenarioRup, List<? extends ObsEqkRupture> histQkList, boolean includeSpontEvents, boolean includeIndirectTriggering, double gridSeisDiscr, String simulationName, Long randomSeed, List<float[]> fractionSrcInCubeList, List<int[]> srcInCubeList, int[] inputIsCubeInsideFaultPolygon, ETAS_ParameterList etasParams, ETAS_CubeDiscretizationParams cubeParams, ETAS_LongTermMFDs longTermMFDs) throws IOException {
        ArrayList<ETAS_EqkRupture> scenarioRups = null;
        if (scenarioRup != null) {
            scenarioRups = new ArrayList<ETAS_EqkRupture>();
            scenarioRups.add(scenarioRup);
        }
        return ETAS_Simulator.runETAS_Simulation(resultsDir, erf, griddedRegion, scenarioRups, histQkList, includeSpontEvents, includeIndirectTriggering, gridSeisDiscr, simulationName, randomSeed, fractionSrcInCubeList, srcInCubeList, inputIsCubeInsideFaultPolygon, etasParams, cubeParams, longTermMFDs);
    }

    /*
     * WARNING - void declaration
     */
    public static ETAS_SimulationMetadata runETAS_Simulation(File resultsDir, AbstractNthRupERF erf, GriddedRegion griddedRegion, List<ETAS_EqkRupture> scenarioRups, List<? extends ObsEqkRupture> histQkList, boolean includeSpontEvents, boolean includeIndirectTriggering, double gridSeisDiscr, String simulationName, Long randomSeed, List<float[]> fractionSrcInCubeList, List<int[]> srcInCubeList, int[] inputIsCubeInsideFaultPolygon, ETAS_ParameterList etasParams, ETAS_CubeDiscretizationParams cubeParams, ETAS_LongTermMFDs longTermMFDs) throws IOException {
        CalcProgressBar progressBar;
        long simulationStartTime = System.currentTimeMillis();
        if (etasParams.getU3ETAS_ProbModel() == U3ETAS_ProbabilityModelOptions.POISSON) {
            erf.setParameter("Probability Model", (Object)ProbabilityModelOptions.POISSON);
            erf.updateForecast();
        }
        boolean generateDiagnostics = false;
        boolean generateDiagnosticsForScenario = true;
        int numFaultSysSources = 0;
        FaultSystemSolutionERF fssERF = null;
        if (erf instanceof FaultSystemSolutionERF) {
            fssERF = (FaultSystemSolutionERF)erf;
            numFaultSysSources = fssERF.getNumFaultSystemSources();
            ETAS_Simulator.getPolyManager(fssERF.getSolution());
        }
        if (randomSeed == null) {
            randomSeed = System.currentTimeMillis();
        }
        ETAS_Utils etas_utils = new ETAS_Utils(randomSeed);
        SeisDepthDistribution seisDepthDistribution = new SeisDepthDistribution();
        if (!resultsDir.exists()) {
            resultsDir.mkdir();
        }
        int bufferSize = 1000000;
        BufferedWriter info_fr = new BufferedWriter(new FileWriter(new File(resultsDir, "infoString.txt")), bufferSize);
        BufferedWriter simulatedEventsFileWriter = new BufferedWriter(new FileWriter(new File(resultsDir, "simulatedEvents.txt")), bufferSize);
        ETAS_CatalogIO.writeEventHeaderToFile(simulatedEventsFileWriter);
        info_fr.write(simulationName + "\n");
        info_fr.write("\nrandomSeed=" + etas_utils.getRandomSeed() + "\n");
        if (D) {
            System.out.println("\nrandomSeed=" + etas_utils.getRandomSeed());
        }
        if (histQkList == null) {
            info_fr.write("\nhistQkList.size()=null\n");
        } else {
            info_fr.write("\nhistQkList.size()=" + histQkList.size() + "\n");
        }
        info_fr.write("includeSpontEvents=" + includeSpontEvents + "\n");
        info_fr.write("includeIndirectTriggering=" + includeIndirectTriggering + "\n");
        info_fr.write("\nERF Adjustable Paramteres:\n\n");
        for (Parameter<?> param : erf.getAdjustableParameterList()) {
            info_fr.write("\t" + param.getName() + " = " + String.valueOf(param.getValue()) + "\n");
        }
        TimeSpan tsp = erf.getTimeSpan();
        String startTimeString = tsp.getStartTimeMonth() + "/" + tsp.getStartTimeDay() + "/" + tsp.getStartTimeYear() + "; hr=" + tsp.getStartTimeHour() + "; min=" + tsp.getStartTimeMinute() + "; sec=" + tsp.getStartTimeSecond();
        info_fr.write("\nERF StartTime: " + startTimeString + "\n");
        info_fr.write("\nERF TimeSpan Duration: " + erf.getTimeSpan().getDuration() + " years\n");
        info_fr.write("\nETAS Paramteres:\n\n");
        if (D) {
            System.out.println("\nETAS Paramteres:\n\n");
        }
        for (Parameter<?> param : etasParams) {
            info_fr.write("\t" + param.getName() + " = " + String.valueOf(param.getValue()) + "\n");
            if (!D) continue;
            System.out.println("\t" + param.getName() + " = " + String.valueOf(param.getValue()));
        }
        ((Writer)info_fr).flush();
        ArrayList<ETAS_EqkRupture> obsEqkRuptureList = new ArrayList<ETAS_EqkRupture>();
        Range rangeHistCatalogParentIDs = null;
        int maxObsEqkRupID = 0;
        if (histQkList != null) {
            int id = scenarioRups != null && !scenarioRups.isEmpty() ? scenarioRups.size() : 1;
            int startID = id;
            for (ObsEqkRupture obsEqkRupture : histQkList) {
                Location hyp = obsEqkRupture.getHypocenterLocation();
                if (!griddedRegion.contains(hyp) || !(hyp.getDepth() < 24.0)) continue;
                ETAS_EqkRupture etasRup = obsEqkRupture instanceof ETAS_EqkRupture ? (ETAS_EqkRupture)obsEqkRupture : new ETAS_EqkRupture(obsEqkRupture);
                etasRup.setID(id);
                maxObsEqkRupID = id++;
                obsEqkRuptureList.add(etasRup);
            }
            if (id > startID) {
                rangeHistCatalogParentIDs = Range.closed((Comparable)Integer.valueOf(startID), (Comparable)Integer.valueOf(id - 1));
            }
            if (D) {
                System.out.println("histQkList.size()=" + histQkList.size());
            }
            if (D) {
                System.out.println("obsEqkRuptureList.size()=" + obsEqkRuptureList.size());
            }
        }
        int[] scenarioRupIDs = null;
        HashMap<Integer, Integer> numPrimaryAshockForScenarios = null;
        Range rangeTriggerRupIDs = null;
        if (scenarioRups != null && !scenarioRups.isEmpty()) {
            void var36_38;
            scenarioRupIDs = new int[scenarioRups.size()];
            numPrimaryAshockForScenarios = new HashMap<Integer, Integer>();
            boolean bl = false;
            while (var36_38 < scenarioRups.size()) {
                ETAS_EqkRupture scenarioRup = scenarioRups.get((int)var36_38);
                scenarioRupIDs[var36_38] = var36_38;
                scenarioRup.setID((int)var36_38);
                maxObsEqkRupID = Integer.max(maxObsEqkRupID, (int)var36_38);
                obsEqkRuptureList.add(scenarioRup);
                if (D) {
                    System.out.println("Num locs on scenario " + (int)var36_38 + " rup surface: " + scenarioRup.getRuptureSurface().getEvenlyDiscritizedListOfLocsOnSurface().size());
                }
                ++var36_38;
            }
            rangeTriggerRupIDs = Range.closed((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(scenarioRups.size() - 1));
        }
        ObsEqkRupOrigTimeComparator obsEqkRupOrigTimeComparator = new ObsEqkRupOrigTimeComparator();
        PriorityQueue<ObsEqkRupture> simulatedRupsQueue = new PriorityQueue<ObsEqkRupture>(1000, obsEqkRupOrigTimeComparator);
        ArrayList<Integer> nthFaultSysRupAftershocks = D ? new ArrayList<Integer>() : null;
        long simStartTimeMillis = erf.getTimeSpan().getStartTimeCalendar().getTimeInMillis();
        long simEndTimeMillis = erf.getTimeSpan().getEndTimeCalendar().getTimeInMillis();
        double simDurationYrs = erf.getTimeSpan().getDuration();
        if (D) {
            System.out.println("Updating forecast in testETAS_Simulation");
        }
        erf.getTimeSpan().setDuration(1.0);
        erf.updateForecast();
        if (D) {
            System.out.println("Done updating forecast in testETAS_Simulation");
        }
        if (D) {
            System.out.println("Computing original spontaneousRupSampler & sourceRates[s]");
        }
        long st = System.currentTimeMillis();
        double origTotRate = 0.0;
        double[] sourceRates = new double[erf.getNumSources()];
        double duration = erf.getTimeSpan().getDuration();
        IntegerPDF_FunctionSampler spontaneousRupSampler = new IntegerPDF_FunctionSampler(erf.getTotNumRups());
        int nthRup = 0;
        if (D) {
            System.out.println("total number of ruptures: " + erf.getTotNumRups());
        }
        for (int s = 0; s < erf.getNumSources(); ++s) {
            ProbEqkSource src = erf.getSource(s);
            sourceRates[s] = src.computeTotalEquivMeanAnnualRate(duration);
            if (D && sourceRates[s] == 0.0) {
                double rate = fssERF.getSolution().getRateForRup(fssERF.getFltSysRupIndexForSource(s));
                System.out.println("ZERO RATE FAULT SOURCE: " + rate + "\t" + src.getRupture(0).getProbability() + "\t" + src.getName());
            }
            for (int r = 0; r < src.getNumRuptures(); ++r) {
                ProbEqkRupture rup = src.getRupture(r);
                if (nthRup >= spontaneousRupSampler.size()) {
                    throw new RuntimeException("Weird...tot num=" + erf.getTotNumRups() + ", nth=" + nthRup);
                }
                double rupRate = rup.getMeanAnnualRate(duration);
                if (!Double.isFinite(rupRate)) {
                    Preconditions.checkState((boolean)Doubles.isFinite((double)rupRate), (String)"Non fininte rup rate: %s, prob=%s, src=%s, rup=%s, mag=%s, ptSource=%s", (Object[])new Object[]{rupRate, rup.getProbability(), s, r, rup.getMag(), rup.getRuptureSurface().isPointSurface()});
                }
                origTotRate += rupRate;
                spontaneousRupSampler.set(nthRup, rupRate);
                ++nthRup;
            }
        }
        info_fr.write("\nExpected mean annual rate over timeSpan (per year) = " + (float)origTotRate + "\n");
        if (D) {
            System.out.println("\tspontaneousRupSampler.calcSumOfY_Vals()=" + (float)spontaneousRupSampler.calcSumOfY_Vals() + "; that took (sec): " + (float)(System.currentTimeMillis() - st) / 1000.0f);
        }
        if (D) {
            System.out.println("Making ETAS_PrimaryEventSampler");
        }
        st = System.currentTimeMillis();
        if (cubeParams == null) {
            cubeParams = new ETAS_CubeDiscretizationParams(griddedRegion);
        }
        if (longTermMFDs == null) {
            longTermMFDs = new ETAS_LongTermMFDs(fssERF, etasParams.getApplySubSeisForSupraNucl());
        }
        ETAS_PrimaryEventSampler etas_PrimEventSampler = new ETAS_PrimaryEventSampler(cubeParams, erf, longTermMFDs, sourceRates, null, etasParams, etas_utils, fractionSrcInCubeList, srcInCubeList, inputIsCubeInsideFaultPolygon);
        if (D) {
            System.out.println("ETAS_PrimaryEventSampler creation took " + (float)(System.currentTimeMillis() - st) / 60000.0f + " min");
        }
        info_fr.write("\nMaking ETAS_PrimaryEventSampler took " + (System.currentTimeMillis() - st) / 60000L + " min");
        if (D) {
            System.out.println("Making primary aftershocks from input obsEqkRuptureList, size = " + obsEqkRuptureList.size());
        }
        PriorityQueue<ObsEqkRupture> eventsToProcess = new PriorityQueue<ObsEqkRupture>(1000, obsEqkRupOrigTimeComparator);
        int eventID = maxObsEqkRupID + 1;
        for (ETAS_EqkRupture parRup : obsEqkRuptureList) {
            int parID = parRup.getID();
            long rupOT = parRup.getOriginTime();
            double startDay = (double)(simStartTimeMillis - rupOT) / 8.64E7;
            double endDay = (double)(simEndTimeMillis - rupOT) / 8.64E7;
            etas_utils.setETAS_ParamsForRupture(parRup, etasParams);
            double[] randomAftShockTimes = etas_utils.getRandomEventTimes(parRup.getETAS_k(), parRup.getETAS_p(), parRup.getMag(), 2.5, parRup.getETAS_c(), startDay, endDay);
            if (scenarioRupIDs != null && rangeTriggerRupIDs.contains((Comparable)Integer.valueOf(parRup.getID()))) {
                numPrimaryAshockForScenarios.put(parRup.getID(), randomAftShockTimes.length);
            }
            Object var67_83 = null;
            if (randomAftShockTimes.length <= 0) continue;
            for (int i = 0; i < randomAftShockTimes.length; ++i) {
                long ot = rupOT + (long)(randomAftShockTimes[i] * 8.64E7);
                ETAS_EqkRupture newRup = new ETAS_EqkRupture(parRup, eventID, ot);
                newRup.setParentID(parID);
                newRup.setGeneration(1);
                if (parRup.getFSSIndex() == -1) {
                    newRup.setParentTriggerLoc(etas_utils.getRandomLocationOnRupSurface(parRup));
                } else {
                    int tempIndex;
                    Location tempLoc;
                    void var67_82;
                    if (var67_82 == null) {
                        RuptureSurface ruptureSurface = etas_utils.getRuptureSurfaceWithNoCreepReduction(parRup.getFSSIndex(), fssERF, 0.05);
                    }
                    if ((tempLoc = var67_82.getEvenlyDiscretizedLocation(tempIndex = etas_utils.getRandomInt(var67_82.getEvenlyDiscretizedNumLocs() - 1))).getDepth() > etas_PrimEventSampler.maxDepth) {
                        Location newLoc;
                        tempLoc = newLoc = new Location(tempLoc.getLatitude(), tempLoc.getLongitude(), etas_PrimEventSampler.maxDepth);
                    }
                    newRup.setParentTriggerLoc(etas_PrimEventSampler.getRandomFuzzyLocation(tempLoc));
                }
                etas_PrimEventSampler.addRuptureToProcess(newRup);
                eventsToProcess.add(newRup);
                ++eventID;
            }
        }
        if (D) {
            System.out.println("The " + obsEqkRuptureList.size() + " input events produced " + eventsToProcess.size() + " primary aftershocks");
        }
        info_fr.write("\nThe " + obsEqkRuptureList.size() + " input observed events produced " + eventsToProcess.size() + " primary aftershocks\n");
        if (includeSpontEvents) {
            if (D) {
                System.out.println("Making spontaneous events and times of primary aftershocks...");
            }
            long histCatStartTime = simStartTimeMillis;
            IncrementalMagFreqDist mfd = etas_PrimEventSampler.getLongTermTotalERF_MFD().deepClone();
            mfd.scale(etasParams.getTotalRateScaleFactor());
            long[] spontEventTimes = histQkList == null || histQkList.isEmpty() ? etas_utils.getRandomSpontanousEventTimes(mfd, histCatStartTime, simStartTimeMillis, simEndTimeMillis, 1000, etasParams.get_k(), etasParams.get_p(), 2.5, etasParams.get_c()) : etas_utils.getRandomSpontanousEventTimes(mfd, etasParams.getStatewideCompletenessModel().getEvenlyDiscretizedMagYearFunc(), simStartTimeMillis, simEndTimeMillis, 1000, etasParams.get_k(), etasParams.get_p(), 2.5, etasParams.get_c());
            for (int r = 0; r < spontEventTimes.length; ++r) {
                ETAS_EqkRupture rup = new ETAS_EqkRupture();
                rup.setOriginTime(spontEventTimes[r]);
                rup.setID(eventID);
                rup.setGeneration(0);
                eventsToProcess.add(rup);
                ++eventID;
            }
            double fractionNonTriggered = (double)spontEventTimes.length / (origTotRate * simDurationYrs);
            String spEvStringInfo = "Spontaneous Events:\n\n\tFraction non-triggered = " + fractionNonTriggered + "\t(sample num over total expected num)\n\tnumSpontEventsSampled=" + spontEventTimes.length + "\n";
            if (D) {
                System.out.println(spEvStringInfo);
            }
            info_fr.write("\n" + spEvStringInfo);
        }
        List expectedPrimaryMFDsForScenarioList = null;
        if (scenarioRups != null) {
            for (int i = 0; i < scenarioRups.size(); ++i) {
                boolean scenWrite;
                ETAS_EqkRupture scenarioRup = scenarioRups.get(i);
                boolean bl = scenWrite = D || scenarioRups.size() < 100 || scenarioRup.getMag() >= 5.0;
                if (!scenWrite) continue;
                long rupOT = scenarioRup.getOriginTime();
                double startDay = (double)(simStartTimeMillis - rupOT) / 8.64E7;
                double endDay = (double)(simEndTimeMillis - rupOT) / 8.64E7;
                info_fr.write("\nMagnitude of Scenario: " + (float)scenarioRup.getMag() + "\n");
                if (D) {
                    System.out.println("\nMagnitude of Scenario: " + (float)scenarioRup.getMag());
                }
                double d = scenarioRup.getETAS_k();
                double p = scenarioRup.getETAS_p();
                double c = scenarioRup.getETAS_c();
                if (d != etasParams.get_k()) {
                    info_fr.write("\tCustom k-value for Scenario: " + d + "\n");
                    if (D) {
                        System.out.println("\tCustom k-value for Scenario: " + d + "\n");
                    }
                }
                if (p != etasParams.get_p()) {
                    info_fr.write("\tCustom p-value for Scenario: " + p + "\n");
                    if (D) {
                        System.out.println("\tCustom p-value for Scenario: " + p + "\n");
                    }
                }
                if (c != etasParams.get_c()) {
                    info_fr.write("\tCustom c-value for Scenario: " + c + "\n");
                    if (D) {
                        System.out.println("\tCustom c-value for Scenario: " + c + "\n");
                    }
                }
                double expNum = ETAS_Utils.getExpectedNumEvents(d, p, scenarioRup.getMag(), 2.5, c, startDay, endDay);
                info_fr.write("Expected number of primary events for Scenario: " + expNum + "\n");
                int numPrimaryAftershocks = (Integer)numPrimaryAshockForScenarios.get(scenarioRup.getID());
                info_fr.write("Observed number of primary events for Scenario: " + numPrimaryAftershocks + "\n");
                if (!D) continue;
                System.out.println("Expected number of primary events for Scenario: " + expNum);
                System.out.println("Observed number of primary events for Scenario: " + numPrimaryAftershocks + "\n");
            }
        }
        if (D) {
            System.out.println("Testing the etas_PrimEventSampler");
            etas_PrimEventSampler.testRates();
        }
        try {
            progressBar = new CalcProgressBar("Primary aftershocks to process", "junk");
            progressBar.showProgress(true);
        }
        catch (Throwable t) {
            progressBar = null;
        }
        if (D) {
            System.out.println("Looping over eventsToProcess (initial num = " + eventsToProcess.size() + ")...\n");
        }
        if (D) {
            System.out.println("\tFault system ruptures triggered (date\tmag\tname\tnthRup,src,rupInSrc,fltSysRup):");
        }
        info_fr.write("\nFault system ruptures triggered (date\tmag\tname\tnthRup,src,rupInSrc,fltSysRup):\n");
        st = System.currentTimeMillis();
        int numSimulatedEvents = 0;
        ETAS_SimAnalysisTools.EpicenterMapThread mapThread = D && live_map ? ETAS_SimAnalysisTools.plotUpdatingEpicenterMap(simulationName, null, simulatedRupsQueue, griddedRegion.getBorder()) : null;
        if (D && pause_for_events) {
            try {
                JOptionPane.showMessageDialog(null, "Continue", "Ready To Generate Events", -1);
            }
            catch (HeadlessException rupOT) {
                // empty catch block
            }
        }
        if (D) {
            ((Writer)info_fr).flush();
        }
        double maxPointSourceMag = etasParams.getMaxPointSourceMag();
        while (eventsToProcess.size() > 0) {
            if (progressBar != null) {
                progressBar.updateProgress(numSimulatedEvents, eventsToProcess.size() + numSimulatedEvents);
            }
            ETAS_EqkRupture rup = (ETAS_EqkRupture)eventsToProcess.poll();
            boolean succeededInSettingRupture = true;
            if (rup.getParentID() == -1) {
                Location hypoLoc = null;
                nthRup = spontaneousRupSampler.getRandomInt(etas_utils.getRandomDouble());
                ProbEqkRupture erf_rup = erf.getNthRupture(nthRup);
                LocationList locationList = erf_rup.getRuptureSurface().getEvenlyDiscritizedListOfLocsOnSurface();
                if (locationList.size() == 1) {
                    Location ptLoc = (Location)locationList.get(0);
                    hypoLoc = new Location(ptLoc.getLatitude() + (etas_utils.getRandomDouble() - 0.5) * 0.1 * 0.99, ptLoc.getLongitude() + (etas_utils.getRandomDouble() - 0.5) * 0.1 * 0.99, seisDepthDistribution.getRandomDepth(etas_utils));
                    double aveDip = erf_rup.getRuptureSurface().getAveDip();
                    if (erf_rup.getMag() < maxPointSourceMag) {
                        rup.setPointSurface(hypoLoc, aveDip);
                    } else {
                        rup.setRuptureSurface(etas_utils.getRandomFiniteRupSurface(erf_rup.getMag(), hypoLoc, aveDip));
                    }
                } else {
                    int hypIndex = etas_utils.getRandomInt(locationList.size() - 1);
                    hypoLoc = (Location)locationList.get(hypIndex);
                    rup.setRuptureSurface(erf_rup.getRuptureSurface());
                }
                rup.setAveRake(erf_rup.getAveRake());
                rup.setMag(erf_rup.getMag());
                rup.setNthERF_Index(nthRup);
                rup.setHypocenterLocation(hypoLoc);
                int sourceIndex = erf.getSrcIndexForNthRup(nthRup);
                if (sourceIndex < numFaultSysSources) {
                    rup.setFSSIndex(fssERF.getFltSysRupIndexForNthRup(nthRup));
                } else {
                    rup.setGridNodeIndex(sourceIndex - numFaultSysSources);
                }
            } else {
                succeededInSettingRupture = etas_PrimEventSampler.setRandomPrimaryEvent(rup, maxPointSourceMag);
            }
            if (!succeededInSettingRupture) continue;
            nthRup = rup.getNthERF_Index();
            int srcIndex = erf.getSrcIndexForNthRup(nthRup);
            int fltSysRupIndex = -1;
            if (srcIndex < numFaultSysSources) {
                fltSysRupIndex = fssERF.getFltSysRupIndexForNthRup(nthRup);
                rup.setFSSIndex(fltSysRupIndex);
            }
            simulatedRupsQueue.add(rup);
            ++numSimulatedEvents;
            if (includeIndirectTriggering) {
                etas_utils.setETAS_ParamsForRupture(rup, etasParams);
            }
            ETAS_CatalogIO.writeEventToFile(simulatedEventsFileWriter, rup);
            long l = rup.getOriginTime();
            if (includeIndirectTriggering) {
                int parID = rup.getID();
                int gen = rup.getGeneration() + 1;
                double startDay = 0.0;
                double endDay = (double)(simEndTimeMillis - l) / 8.64E7;
                double[] eventTimes = etas_utils.getRandomEventTimes(rup.getETAS_k(), rup.getETAS_p(), rup.getMag(), 2.5, rup.getETAS_c(), startDay, endDay);
                RuptureSurface surf = null;
                if (eventTimes.length > 0) {
                    for (int i = 0; i < eventTimes.length; ++i) {
                        long ot = l + (long)(eventTimes[i] * 8.64E7);
                        ETAS_EqkRupture newRup = new ETAS_EqkRupture(rup, eventID, ot);
                        newRup.setGeneration(gen);
                        newRup.setParentID(parID);
                        if (rup.getFSSIndex() == -1) {
                            newRup.setParentTriggerLoc(etas_utils.getRandomLocationOnRupSurface(rup));
                        } else {
                            int tempIndex;
                            Location tempLoc;
                            if (surf == null) {
                                surf = etas_utils.getRuptureSurfaceWithNoCreepReduction(rup.getFSSIndex(), fssERF, 0.05);
                            }
                            if ((tempLoc = surf.getEvenlyDiscretizedLocation(tempIndex = etas_utils.getRandomInt(surf.getEvenlyDiscretizedNumLocs() - 1))).getDepth() > etas_PrimEventSampler.maxDepth) {
                                Location newLoc;
                                tempLoc = newLoc = new Location(tempLoc.getLatitude(), tempLoc.getLongitude(), etas_PrimEventSampler.maxDepth);
                            }
                            newRup.setParentTriggerLoc(etas_PrimEventSampler.getRandomFuzzyLocation(tempLoc));
                        }
                        etas_PrimEventSampler.addRuptureToProcess(newRup);
                        eventsToProcess.add(newRup);
                        ++eventID;
                    }
                }
            }
            if (srcIndex < numFaultSysSources) {
                erf.getTimeSpan().setStartTimeInMillis(l);
                if (D) {
                    nthFaultSysRupAftershocks.add(nthRup);
                    Toolkit.getDefaultToolkit().beep();
                    System.out.println("GOT A FAULT SYSTEM RUPTURE!");
                }
                TimeSpan ts = erf.getTimeSpan();
                String rupString = "\t" + ts.getStartTimeMonth() + "/" + ts.getStartTimeDay() + "/" + ts.getStartTimeYear() + "\tmag=" + (float)rup.getMag() + "\t" + erf.getSource(srcIndex).getName() + "\n\tnthRup=" + nthRup + ", srcIndex=" + srcIndex + ", RupIndexInSource=" + erf.getRupIndexInSourceForNthRup(nthRup) + ", fltSysRupIndex=" + fltSysRupIndex + "\tgen=" + rup.getGeneration();
                rupString = rup.getParentRup() != null ? rupString + "\tparID=" + rup.getParentRup().getID() + "\tparMag=" + rup.getParentRup().getMag() : rupString + "\tparID=-1 (spontaneous)";
                if (D) {
                    System.out.println(rupString);
                }
                info_fr.write(rupString + "\n");
                fssERF.setFltSystemSourceOccurranceTime(srcIndex, l);
                if (D) {
                    System.out.print("\tUpdating src rates for etas_PrimEventSampler & spontaneousRupSampler; ");
                }
                Long st2 = System.currentTimeMillis();
                if (erf.getParameter("Probability Model").getValue() != ProbabilityModelOptions.POISSON) {
                    erf.updateForecast();
                    for (int s = 0; s < numFaultSysSources; ++s) {
                        ProbEqkSource src = erf.getSource(s);
                        double oldRate = sourceRates[s];
                        sourceRates[s] = src.computeTotalEquivMeanAnnualRate(duration);
                        double newRate = sourceRates[s];
                        if (D && s == erf.getSrcIndexForNthRup(nthRup)) {
                            System.out.print("for rup that occurred, oldRate=" + (float)oldRate + " & newRate = " + (float)newRate + "\n");
                        }
                        for (int r = 0; r < src.getNumRuptures(); ++r) {
                            ProbEqkRupture rupInSrc = src.getRupture(r);
                            double rate = rupInSrc.getMeanAnnualRate(duration);
                            spontaneousRupSampler.set(erf.getIndexN_ForSrcAndRupIndices(s, r), rate);
                        }
                    }
                    etas_PrimEventSampler.declareRateChange();
                }
                if (D) {
                    System.out.println("Sampler update took " + (System.currentTimeMillis() - st2) / 1000L + " secs");
                    System.out.println("Running generateRuptureDiagnostics(*)");
                    double startDay = 0.0;
                    double endDay = (double)(simEndTimeMillis - l) / 8.64E7;
                    double expNum = ETAS_Utils.getExpectedNumEvents(rup.getETAS_k(), rup.getETAS_p(), rup.getMag(), 2.5, rup.getETAS_c(), startDay, endDay);
                    String rupInfo = "FltSysRup" + fltSysRupIndex + "_trigNum" + (nthFaultSysRupAftershocks.size() - 1);
                    info_fr.write("\nExpected number of primary events for " + rupInfo + ": " + expNum + "\n");
                    System.out.println("\nExpected number of primary events for " + rupInfo + ": " + expNum);
                    if (generateDiagnostics) {
                        etas_PrimEventSampler.generateRuptureDiagnostics(rup, expNum, rupInfo, resultsDir, info_fr);
                    }
                }
            }
            if (!D) continue;
            ((Writer)info_fr).flush();
        }
        if (progressBar != null) {
            progressBar.showProgress(false);
        }
        if (mapThread != null) {
            mapThread.kill();
        }
        if (D) {
            System.out.println("\nLooping over events took " + (System.currentTimeMillis() - st) / 1000L + " secs\n");
        }
        info_fr.write("\nLooping over events took " + (System.currentTimeMillis() - st) / 1000L + " secs\n\n");
        ETAS_SimAnalysisTools.writeMemoryUse("Memory after loop:");
        int[] numInEachGeneration = ETAS_SimAnalysisTools.getNumAftershocksForEachGeneration(simulatedRupsQueue, 10);
        String numInfo = "Total num ruptures: " + simulatedRupsQueue.size() + "\n";
        numInfo = numInfo + "Num spontaneous: " + numInEachGeneration[0] + "\n";
        numInfo = numInfo + "Num 1st Gen: " + numInEachGeneration[1] + "\n";
        numInfo = numInfo + "Num 2nd Gen: " + numInEachGeneration[2] + "\n";
        numInfo = numInfo + "Num 3rd Gen: " + numInEachGeneration[3] + "\n";
        numInfo = numInfo + "Num 4th Gen: " + numInEachGeneration[4] + "\n";
        numInfo = numInfo + "Num 5th Gen: " + numInEachGeneration[5] + "\n";
        numInfo = numInfo + "Num 6th Gen: " + numInEachGeneration[6] + "\n";
        numInfo = numInfo + "Num 7th Gen: " + numInEachGeneration[7] + "\n";
        numInfo = numInfo + "Num 8th Gen: " + numInEachGeneration[8] + "\n";
        numInfo = numInfo + "Num 9th Gen: " + numInEachGeneration[9] + "\n";
        numInfo = numInfo + "Num 10th Gen: " + numInEachGeneration[10] + "\n";
        if (D) {
            System.out.println(numInfo);
        }
        info_fr.write(numInfo + "\n");
        if (D && scenarioRups != null && !scenarioRups.isEmpty()) {
            for (ETAS_EqkRupture scenarioRup : scenarioRups) {
                int n = scenarioRup.getID();
                ETAS_SimAnalysisTools.plotRateVsLogTimeForPrimaryAshocksOfRup(simulationName, new File(resultsDir, "logRateDecayForScenarioPrimaryAftershocks.pdf").getAbsolutePath(), simulatedRupsQueue, scenarioRup, etasParams.get_k(), etasParams.get_p(), etasParams.get_c());
                ETAS_SimAnalysisTools.plotRateVsLogTimeForAllAshocksOfRup(simulationName, new File(resultsDir, "logRateDecayForScenarioAllAftershocks.pdf").getAbsolutePath(), simulatedRupsQueue, scenarioRup, etasParams.get_k(), etasParams.get_p(), etasParams.get_c());
                ETAS_SimAnalysisTools.plotEpicenterMap(simulationName, new File(resultsDir, "hypoMap.pdf").getAbsolutePath(), (ObsEqkRupture)obsEqkRuptureList.get(0), simulatedRupsQueue, griddedRegion.getBorder());
                ETAS_SimAnalysisTools.plotDistDecayDensityOfAshocksForRup("Scenario in " + simulationName, new File(resultsDir, "distDecayDensityForScenario.pdf").getAbsolutePath(), simulatedRupsQueue, etasParams.get_q(), etasParams.get_d(), scenarioRup);
                ArrayList<IncrementalMagFreqDist> obsAshockMFDsForScenario = ETAS_SimAnalysisTools.getAftershockMFDsForRup(simulatedRupsQueue, n, simulationName);
                if (generateDiagnosticsForScenario) {
                    obsAshockMFDsForScenario.add((IncrementalMagFreqDist)expectedPrimaryMFDsForScenarioList.get(0));
                }
                ETAS_SimAnalysisTools.plotMagFreqDistsForRup("AshocksOfScenarioMFD", resultsDir, obsAshockMFDsForScenario);
                double expPrimNumAtMainMag = Double.NaN;
                double expPrimNumAtMainMagMinusOne = Double.NaN;
                if (generateDiagnosticsForScenario && expectedPrimaryMFDsForScenarioList.get(1) != null) {
                    expPrimNumAtMainMag = ((EvenlyDiscretizedFunc)expectedPrimaryMFDsForScenarioList.get(1)).getInterpolatedY(scenarioRup.getMag());
                    expPrimNumAtMainMagMinusOne = ((EvenlyDiscretizedFunc)expectedPrimaryMFDsForScenarioList.get(1)).getInterpolatedY(scenarioRup.getMag() - 1.0);
                }
                EvenlyDiscretizedFunc obsPrimCumMFD = obsAshockMFDsForScenario.get(1).getCumRateDistWithOffset();
                double obsPrimNumAtMainMag = obsPrimCumMFD.getInterpolatedY(scenarioRup.getMag());
                double obsPrimNumAtMainMagMinusOne = obsPrimCumMFD.getInterpolatedY(scenarioRup.getMag() - 1.0);
                EvenlyDiscretizedFunc obsAllCumMFD = obsAshockMFDsForScenario.get(1).getCumRateDistWithOffset();
                double obsAllNumAtMainMag = obsAllCumMFD.getInterpolatedY(scenarioRup.getMag());
                double obsAllNumAtMainMagMinusOne = obsAllCumMFD.getInterpolatedY(scenarioRup.getMag() - 1.0);
                Object testEventStats = "\nAftershock Stats for Scenario event (only):\n";
                testEventStats = (String)testEventStats + "\tNum Primary Aftershocks at main shock mag(" + (float)scenarioRup.getMag() + "):\n\t\tExpected=" + expPrimNumAtMainMag + "\n\t\tObserved=" + obsPrimNumAtMainMag + "\n";
                testEventStats = (String)testEventStats + "\tNum Primary Aftershocks at one minus main-shock mag(" + (float)(scenarioRup.getMag() - 1.0) + "):\n\t\tExpected=" + expPrimNumAtMainMagMinusOne + "\n\t\tObserved=" + obsPrimNumAtMainMagMinusOne + "\n";
                testEventStats = (String)testEventStats + "\tTotal Observed Num Aftershocks:\n\t\tAt main-shock mag = " + obsAllNumAtMainMag + "\n\t\tAt one minus main-shock mag = " + obsAllNumAtMainMagMinusOne + "\n";
                if (D) {
                    System.out.println((String)testEventStats);
                }
                info_fr.write((String)testEventStats);
            }
        } else if (D) {
            ETAS_SimAnalysisTools.plotEpicenterMap(simulationName, new File(resultsDir, "hypoMap.pdf").getAbsolutePath(), null, simulatedRupsQueue, griddedRegion.getBorder());
            ArrayList<ETAS_EqkRupture> bigGridSeisEventsList = new ArrayList<ETAS_EqkRupture>();
            for (ETAS_EqkRupture eTAS_EqkRupture : simulatedRupsQueue) {
                if (eTAS_EqkRupture.getFSSIndex() != -1 || !(eTAS_EqkRupture.getMag() > maxPointSourceMag)) continue;
                bigGridSeisEventsList.add(eTAS_EqkRupture);
            }
            ETAS_SimAnalysisTools.plotFiniteGridSeisRupMap(simulationName, new File(resultsDir, "hypoMapBigGridSeisEvents.pdf").getAbsolutePath(), bigGridSeisEventsList, griddedRegion.getBorder());
        }
        if (D) {
            ETAS_SimAnalysisTools.plotRateVsLogTimeForPrimaryAshocks(simulationName, new File(resultsDir, "logRateDecayPDF_ForAllPrimaryEvents.pdf").getAbsolutePath(), simulatedRupsQueue, etasParams.get_k(), etasParams.get_p(), etasParams.get_c());
            ETAS_SimAnalysisTools.plotDistDecayDensityFromParentTriggerLocHist(simulationName, new File(resultsDir, "distDecayForAllPrimaryEvents.pdf").getAbsolutePath(), simulatedRupsQueue, etasParams.get_q(), etasParams.get_d());
            ETAS_SimAnalysisTools.plotMagFreqDists(simulationName, resultsDir, simulatedRupsQueue);
        }
        ((Writer)info_fr).close();
        ETAS_SimulationMetadata meta = ETAS_SimulationMetadata.instance(randomSeed, -1, (Range<Integer>)rangeHistCatalogParentIDs, (Range<Integer>)rangeTriggerRupIDs, simulationStartTime, System.currentTimeMillis(), 2.5, simulatedRupsQueue);
        ETAS_CatalogIO.writeMetadataToFile(simulatedEventsFileWriter, meta);
        ((Writer)simulatedEventsFileWriter).close();
        ETAS_SimAnalysisTools.writeMemoryUse("Memory at end of simultation");
        return meta;
    }

    public static ETAS_EqkRupture buildScenarioRup(TestScenario scenario, FaultSystemSolutionERF_ETAS erf, long origTimeMillis) {
        Preconditions.checkArgument((origTimeMillis < erf.getTimeSpan().getStartTimeInMillis() ? 1 : 0) != 0, (Object)("start time (" + erf.getTimeSpan().getStartTimeInMillis() + ") must be grater than or equal to the scenario origin time (" + origTimeMillis + ")"));
        ETAS_EqkRupture scenarioRup = null;
        if (scenario != null) {
            scenarioRup = new ETAS_EqkRupture();
            scenarioRup.setOriginTime(origTimeMillis);
            int fssIndex = scenario.fssIndex;
            if (fssIndex >= 0) {
                int srcID = erf.getSrcIndexForFltSysRup(fssIndex);
                Preconditions.checkState((srcID >= 0 ? 1 : 0) != 0, (Object)("Source not found for FSS index=" + fssIndex));
                int rupIndex = 0;
                if (erf.getSource(srcID).getNumRuptures() > 1) {
                    rupIndex = (int)Math.round((double)erf.getSource(srcID).getNumRuptures() / 2.0);
                }
                ProbEqkRupture rupFromERF = erf.getSource(srcID).getRupture(rupIndex);
                scenarioRup.setAveRake(rupFromERF.getAveRake());
                scenarioRup.setMag(rupFromERF.getMag());
                if (!Double.isNaN(scenario.mag)) {
                    scenarioRup.setMag(scenario.mag);
                }
                scenarioRup.setFSSIndex(fssIndex);
                scenarioRup.setRuptureSurface(rupFromERF.getRuptureSurface());
                if (D) {
                    System.out.println("\tProbBeforeDateOfLastReset: " + erf.getSource(srcID).getRupture(rupIndex).getProbability());
                }
                erf.setFltSystemSourceOccurranceTime(srcID, origTimeMillis);
                erf.updateForecast();
                if (D) {
                    System.out.println("\tProbAfterDateOfLastReset: " + erf.getSource(srcID).getRupture(rupIndex).getProbability());
                }
            } else {
                scenarioRup.setAveRake(0.0);
                if (scenario == TestScenario.CUSTOM) {
                    ParameterList params = new ParameterList();
                    DoubleParameter magParam = new DoubleParameter("Magnitude", 2.0, 8.89, (Double)scenario.mag);
                    params.addParameter(magParam);
                    LocationParameter locParam = new LocationParameter("Hpocenter Location", scenario.loc);
                    params.addParameter(locParam);
                    ParameterListEditor edit = new ParameterListEditor(params);
                    JOptionPane.showMessageDialog(null, edit, "Custom Rupture", -1);
                    scenarioRup.setMag((Double)magParam.getValue());
                    scenarioRup.setPointSurface((Location)locParam.getValue());
                    System.out.println("Loaded custom scenario: M" + (float)scenarioRup.getMag() + ", " + String.valueOf(scenarioRup.getHypocenterLocation()));
                } else {
                    scenarioRup.setMag(scenario.mag);
                    scenarioRup.setPointSurface(scenario.loc);
                    scenarioRup.setHypocenterLocation(scenario.loc);
                }
            }
        }
        return scenarioRup;
    }

    public static List<ETAS_EqkRupture> getFilteredHistCatalog(long startTimeMillis, FaultSystemSolutionERF_ETAS erf, U3_EqkCatalogStatewideCompleteness completenessModel) throws IOException, DocumentException {
        File file1 = new File("src/scratch/UCERF3/data/EarthquakeCatalog/ofr2013-1165_EarthquakeCat.txt");
        File file2 = new File("src/scratch/UCERF3/data/EarthquakeCatalog/u3_historical_catalog_finite_fault_mappings.xml");
        HashMap<Long, List<Integer>> resetSubSectsMap = new HashMap<Long, List<Integer>>();
        List<ETAS_EqkRupture> histCat = ETAS_Launcher.loadHistoricalCatalog(file1, file2, erf.getSolution(), startTimeMillis, resetSubSectsMap, completenessModel);
        if (!resetSubSectsMap.isEmpty()) {
            ArrayList times = new ArrayList(resetSubSectsMap.keySet());
            Collections.sort(times);
            for (Long time : times) {
                Iterator iterator = ((List)resetSubSectsMap.get(time)).iterator();
                while (iterator.hasNext()) {
                    int sectIndex = (Integer)iterator.next();
                    erf.setFltSectOccurranceTime(sectIndex, time);
                }
            }
        }
        return histCat;
    }

    public static void runBugReproduce() throws IOException {
    }

    public static FaultSystemSolutionERF_ETAS getU3_ETAS_ERF(double startYear, double durationYears, boolean applyGridSeisCorr) {
        return ETAS_Simulator.getU3_ETAS_ERF(ETAS_Simulator.getTimeInMillisFromYear(startYear), durationYears, applyGridSeisCorr);
    }

    public static FaultSystemSolutionERF_ETAS getU3_ETAS_ERF(long startTimeMillis, double durationYears, boolean applyGridSeisCorr) {
        U3FaultSystemSolution fss;
        System.out.println("Starting ERF instantiation");
        long st = System.currentTimeMillis();
        String fileName = "src/scratch/UCERF3/data/scratch/InversionSolutions/2013_05_10-ucerf3p3-production-10runs_COMPOUND_SOL_FM3_1_SpatSeisU3_MEAN_BRANCH_AVG_SOL.zip";
        try {
            fss = U3FaultSystemIO.loadSol(new File(fileName));
        }
        catch (Exception e) {
            throw ExceptionUtils.asRuntimeException(e);
        }
        int numSectsReset = 0;
        for (FaultSection faultSection : ((FaultSystemSolution)fss).getRupSet().getFaultSectionDataList()) {
            if (faultSection.getDateOfLastEvent() <= startTimeMillis) continue;
            ++numSectsReset;
            faultSection.setDateOfLastEvent(Long.MIN_VALUE);
        }
        FaultSystemSolutionERF_ETAS erf = ETAS_Launcher.buildERF_millis(fss, false, durationYears, startTimeMillis);
        erf.updateForecast();
        if (applyGridSeisCorr) {
            double[] dArray;
            try {
                dArray = MatrixIO.doubleArrayFromFile(new File("src/main/resources/scratchData/ucerf3/InversionSolutions/griddedSeisCorrectionCache"));
            }
            catch (IOException e) {
                throw ExceptionUtils.asRuntimeException(e);
            }
            ETAS_Simulator.correctGriddedSeismicityRatesInERF(erf.getSolution(), false, dArray);
        }
        if (D) {
            System.out.println(numSectsReset + " of " + ((FaultSystemSolution)fss).getRupSet().getFaultSectionDataList().size() + " sects had reset date of last due to start time");
            float f = (float)(System.currentTimeMillis() - st) / 1000.0f;
            System.out.println("ERF instantiation took " + f + " sec");
        }
        return erf;
    }

    private static PolygonFaultGridAssociations getPolyManager(FaultSystemSolution sol) {
        FaultSystemRupSet rupSet = sol.getRupSet();
        PolygonFaultGridAssociations faultPolyMgr = rupSet.getModule(PolygonFaultGridAssociations.class);
        if (faultPolyMgr == null) {
            faultPolyMgr = FaultPolyMgr.create(rupSet.getFaultSectionDataList(), 12.0);
            rupSet.addModule(faultPolyMgr);
        }
        return faultPolyMgr;
    }

    public static void correctGriddedSeismicityRatesInERF(FaultSystemSolution sol, boolean plotRateRatio, double[] gridSeisCorrValsArray) {
        GridSourceProvider gridSources = sol.getGridSourceProvider();
        gridSources.scaleAll(gridSeisCorrValsArray);
        double totalRate = 0.0;
        double[] nodeRateArray = new double[gridSources.getNumLocations()];
        for (int i = 0; i < nodeRateArray.length; ++i) {
            nodeRateArray[i] = gridSources.getMFD(i).getCumRate(2.55);
            totalRate += nodeRateArray[i];
        }
        double[] nodeRatePDF = new double[gridSources.getNumLocations()];
        for (int i = 0; i < nodeRateArray.length; ++i) {
            nodeRatePDF[i] = nodeRateArray[i] / totalRate;
        }
        GriddedSeisUtils griddedSeisUtils = new GriddedSeisUtils(sol.getRupSet().getFaultSectionDataList(), nodeRatePDF, ETAS_Simulator.getPolyManager(sol));
        ImmutableList<IncrementalMagFreqDist> longTermSubSeisMFD_OnSectList = sol.requireModule(SubSeismoOnFaultMFDs.class).getAll();
        double[] oldRateArray = new double[longTermSubSeisMFD_OnSectList.size()];
        double[] newRateArray = new double[longTermSubSeisMFD_OnSectList.size()];
        double[] ratioArray = new double[longTermSubSeisMFD_OnSectList.size()];
        for (int sectIndex = 0; sectIndex < longTermSubSeisMFD_OnSectList.size(); ++sectIndex) {
            oldRateArray[sectIndex] = ((IncrementalMagFreqDist)longTermSubSeisMFD_OnSectList.get(sectIndex)).getCumRate(2.55);
            newRateArray[sectIndex] = totalRate * griddedSeisUtils.pdfValForSection(sectIndex);
            ratioArray[sectIndex] = oldRateArray[sectIndex] > 0.0 ? newRateArray[sectIndex] / oldRateArray[sectIndex] : 1.0;
            ((IncrementalMagFreqDist)longTermSubSeisMFD_OnSectList.get(sectIndex)).scale(ratioArray[sectIndex]);
        }
        if (plotRateRatio) {
            List<? extends FaultSection> faults = sol.getRupSet().getFaultSectionDataList();
            String name = "SubSeisRateChange";
            String title = "SubSeisRateChange";
            CPT cpt = FaultBasedMapGen.getLinearRatioCPT().rescale(0.0, 10.0);
            try {
                File file = new File("SubSeisRateChange");
                if (!file.exists()) {
                    file.mkdir();
                }
                FaultBasedMapGen.makeFaultPlot(cpt, FaultBasedMapGen.getTraces(faults), ratioArray, gridSources.getGriddedRegion(), file, name, true, false, title);
            }
            catch (GMT_MapException e) {
                e.printStackTrace();
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static long getTimeInMillisFromYear(double year) {
        double year1 = Math.floor(year);
        double year2 = Math.ceil(year);
        GregorianCalendar cal1 = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        cal1.clear();
        cal1.set((int)year1, 0, 1);
        long startTimeMillis1 = cal1.getTimeInMillis();
        GregorianCalendar cal2 = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        cal2.clear();
        cal2.set((int)year2, 0, 1);
        long startTimeMillis2 = cal2.getTimeInMillis();
        long result = startTimeMillis1 + (long)((double)(startTimeMillis2 - startTimeMillis1) * (year - year1));
        return result;
    }

    public static double getYearFromTimeInMillis(long millis) {
        GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        cal.clear();
        cal.setTimeInMillis(millis);
        int year = cal.get(1);
        double year1 = year;
        double year2 = (double)year + 1.0;
        GregorianCalendar cal1 = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        cal1.clear();
        cal1.set((int)year1, 0, 1);
        long millis1 = cal1.getTimeInMillis();
        GregorianCalendar cal2 = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        cal2.clear();
        cal2.set((int)year2, 0, 1);
        long millis2 = cal2.getTimeInMillis();
        double fractYear = (double)(millis - millis1) / (double)(millis2 - millis1);
        return year1 + fractYear;
    }

    public static void configAndRunSimulation() {
        D = true;
        live_map = true;
        TestScenario scenario = null;
        Object simulationName = "Test40yrSim";
        String incrementString = "_1";
        Long seed = null;
        double startTimeYear = 2012.0;
        long startTimeMillis = ETAS_Simulator.getTimeInMillisFromYear(startTimeYear);
        double durationYears = 40.0;
        ETAS_ParameterList params = new ETAS_ParameterList();
        params.setImposeGR(false);
        params.setApplyGridSeisCorr(true);
        params.setApplySubSeisForSupraNucl(true);
        params.set_kCOV(1.5);
        params.setTotalRateScaleFactor(1.14);
        params.setU3ETAS_ProbModel(U3ETAS_ProbabilityModelOptions.FULL_TD);
        params.setStatewideCompletenessModel(U3_EqkCatalogStatewideCompleteness.RELAXED);
        params.setMaxPointSourceMag(6.0);
        boolean includeSpontEvents = true;
        boolean includeIndirectTriggering = true;
        double gridSeisDiscr = 0.1;
        boolean includeHistCat = true;
        FaultSystemSolutionERF_ETAS erf = ETAS_Simulator.getU3_ETAS_ERF(startTimeMillis, durationYears, params.getApplyGridSeisCorr());
        List<ETAS_EqkRupture> histCat = null;
        if (includeHistCat) {
            try {
                histCat = ETAS_Simulator.getFilteredHistCatalog(startTimeMillis, erf, params.getStatewideCompletenessModel());
            }
            catch (IOException | DocumentException e1) {
                e1.printStackTrace();
            }
            for (int i = 0; i < histCat.size(); ++i) {
                ETAS_EqkRupture rup = histCat.get(i);
                if (!(rup.getMag() > 7.0)) continue;
                System.out.println(i + "\t" + rup.getMag() + "\t" + rup.getOriginTime() + "\t" + String.valueOf(rup.getOriginTimeCal().getTime()) + "\t" + rup.getEventId() + "\t" + rup.getID());
            }
        }
        ArrayList<ETAS_EqkRupture> scenarioList = null;
        if (scenario != null) {
            ETAS_EqkRupture scenarioRup = ETAS_Simulator.buildScenarioRup(scenario, erf, startTimeMillis);
            scenarioList = new ArrayList<ETAS_EqkRupture>();
            scenarioList.add(scenarioRup);
        }
        String imposeGR_string = "";
        if (params.getImposeGR()) {
            imposeGR_string = "_GRcorrApplied";
        }
        simulationName = scenario == null ? (String)simulationName + "NoScenario_" + String.valueOf((Object)params.getU3ETAS_ProbModel()) + imposeGR_string : (String)simulationName + String.valueOf(scenario) + "_" + String.valueOf((Object)params.getU3ETAS_ProbModel()) + imposeGR_string;
        simulationName = (String)simulationName + incrementString;
        ETAS_SimAnalysisTools.writeMemoryUse("Memory at beginning of run");
        Long st = System.currentTimeMillis();
        CaliforniaRegions.RELM_TESTING_GRIDDED griddedRegion = RELM_RegionUtils.getGriddedRegionInstance();
        System.out.println("Starting RunETAS_Simulation");
        try {
            String dirNameForSavingFiles = "U3_ETAS_" + (String)simulationName + "/";
            File resultsDir = new File(dirNameForSavingFiles);
            ETAS_Simulator.runETAS_Simulation(resultsDir, (AbstractNthRupERF)erf, (GriddedRegion)griddedRegion, scenarioList, histCat, includeSpontEvents, includeIndirectTriggering, gridSeisDiscr, (String)simulationName, seed, null, null, null, params, null, null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        float timeMin = (float)(System.currentTimeMillis() - st) / 60000.0f;
        System.out.println("Total simulation took " + timeMin + " min");
    }

    static void testRandomRuptureSurfaces() {
        ETAS_Utils etas_utils = new ETAS_Utils(0xFF8F68L);
        double depth = 8.0;
        etas_utils.getRandomFiniteRupSurface(5.5, new Location(36.0, -122.0, depth), 90.0);
    }

    public static void main(String[] args) {
        ETAS_Simulator.configAndRunSimulation();
    }

    public static enum TestScenario {
        MOJAVE_M7pt4("MojaveM7.4", 193830),
        MOJAVE_M7pt8("MojaveM7.8", 18366),
        MOJAVE_M7("MojaveM7", 193821),
        MOJAVE_M7_ALT("MojaveM7_Alt", 195766),
        MOJAVE_M6pt3_FSS("MojaveM6.3_FSS", 195759),
        MOJAVE_M6pt3_ptSrc("MojaveM6.3_PtSrc", new Location(34.42295, -117.80177, 5.8), 6.3),
        MOJAVE_M7pt5_ptSrc("MojaveM7.5_PtSrc", new Location(34.42295, -117.80177, 5.8), 7.5),
        MOJAVE_M5p5("MojaveM5.5", new Location(34.42295, -117.80177, 5.8), 5.5),
        MOJAVE_M5p5_SECT1850("Mojave_M5.5_Sect1850", new Location(34.354, -117.639, 6.55), 5.5),
        MOJAVE_M5p5_2kmAway("MojaveM5.5_2kmAway", LocationUtils.location(new Location(34.42295, -117.80177, 5.8), new LocationVector(25.036999999999978, 2.0, 0.0)), 5.5),
        MOJAVE_M5p5_5kmAway("MojaveM5.5_5kmAway", LocationUtils.location(new Location(34.42295, -117.80177, 5.8), new LocationVector(25.036999999999978, 5.0, 0.0)), 5.5),
        MOJAVE_M5("MojaveM5", new Location(34.42295, -117.80177, 5.8), 5.0),
        N_PALM_SPRINGS_1986("N Palm Springs M6.0", new Location(34.02, -116.76, 10.0), 6.0),
        MOJAVE_OLD("Mojave M7.05", 197792),
        LANDERS("Landers", 246711),
        NORTHRIDGE("Northridge", 187455),
        LA_HABRA_6p2("La Habra 6.2", new Location(33.932, -117.917, 4.8), 6.2),
        SURPRISE_VALLEY_5p0("SurpriseValley5pt0", new Location(41.83975, -120.12356, 4.675), 5.0),
        SURPRISE_VALLEY_5p5("SurpriseValley5pt5", new Location(41.83975, -120.12356, 4.675), 5.5),
        NEAR_MAACAMA("Near Maacama", new Location(39.79509, -123.60665, 7.54615), 7.0),
        ON_MAACAMA("On Maacama", new Location(39.79509, -123.56665, 7.54615), 7.0),
        ON_N_MOJAVE("On N Mojave", MiscInfoAndPlotsCalc.getMojaveTestLoc(0.0), 6.0),
        NEAR_N_MOJAVE_3KM("On N Mojave", MiscInfoAndPlotsCalc.getMojaveTestLoc(3.0), 5.0),
        CUSTOM("Custom (will prompt)", new Location(34.0, -118.0), 5.0),
        NAPA("Napa 6.0", 93902, null, 6.0),
        PARKFIELD("Parkfield M6", 30473),
        BOMBAY_BEACH_M6("Bombay Beach M6", new Location(33.3183, -115.7283, 5.8), 6.0),
        BOMBAY_BEACH_M4pt8("Bombay Beach M4.8", new Location(33.3172, -115.728, 5.96), 4.8),
        ROBINSON_CREEK_M5p5("Robinson Creek M5pt5", new Location(38.22137, -119.24255, 7.15), 5.5),
        CENTRAL_VALLEY_M3("Central Valley M3", new Location(37.622, -119.993, 5.8), 3.0),
        CENTRAL_VALLEY_M5p0("Central Valley M5", new Location(37.622, -119.993, 5.8), 5.0),
        ZAYANTE_VERGELES_M5p5("Zayante-Vergeles M5pt5", new Location(36.71779, -121.59369, 6.49), 5.5),
        SAN_JACINTO_0_M4p8("San Jacinto (Borrego) M4pt8", new Location(33.1917, -116.17999, 7.41061), 4.8),
        SAN_JACINTO_0_M5p5("San Jacinto (Borrego) M5pt5", new Location(33.1917, -116.17999, 7.41061), 5.5),
        MENDOCINO_12_M5p5("Mendocino M5pt5", new Location(40.3854, -125.01342, 6.0), 5.5),
        SAF_PENINSULA_M5p5("SAF_PeninsulaM5pt5", new Location(37.72793, -122.54861, 7.0), 5.5),
        SAF_PENINSULA_M6p3("SAF_PeninsulaM6pt3", 122568),
        SAF_PENINSULA_M7("SAF_PeninsulaM7", 119367),
        HAYWIRED_M7("HaywiredM7pt1", 101499),
        SANTA_CRUZ_M5p3("SantaCruzM5.3", new Location(33.844, -119.716, 16.8), 5.3);

        private String name;
        private int fssIndex;
        private Location loc;
        private double mag;

        private TestScenario(String name, int fssIndex) {
            this(name, fssIndex, null, Double.NaN);
        }

        private TestScenario(String name, Location loc, double mag) {
            this(name, -1, loc, mag);
        }

        private TestScenario(String name, int fssIndex, Location loc, double mag) {
            this.fssIndex = fssIndex;
            this.name = name;
            this.loc = loc;
            this.mag = mag;
            Preconditions.checkState((loc != null || fssIndex >= 0 ? 1 : 0) != 0);
            if (fssIndex >= 0) {
                Preconditions.checkState((loc == null ? 1 : 0) != 0);
            } else {
                Preconditions.checkState((loc != null ? 1 : 0) != 0);
            }
        }

        public String toString() {
            return this.name;
        }

        public int getFSS_Index() {
            return this.fssIndex;
        }

        public void setFSS_Index(int fssIndex) {
            this.fssIndex = fssIndex;
        }

        public Location getLocation() {
            return this.loc;
        }

        public double getMagnitude() {
            return this.mag;
        }

        public void updateMag(double mag) {
            this.mag = mag;
        }

        public void relocatePtAwayFromFault(FaultSystemRupSet rupSet, double distAway) {
            Named closest = null;
            double closestDist = Double.MAX_VALUE;
            for (FaultSection faultSection : rupSet.getFaultSectionDataList()) {
                for (Location loc : faultSection.getFaultTrace()) {
                    double dist = LocationUtils.horzDistanceFast(loc, this.loc);
                    if (!(dist < closestDist)) continue;
                    closestDist = dist;
                    closest = faultSection;
                }
            }
            Preconditions.checkNotNull(closest);
            System.out.println("Cloasest section: " + closest.getName() + ". Trace dist: " + closestDist);
            this.relocatePtAwayFromFault((FaultSection)closest, distAway);
        }

        public void relocatePtAwayFromFault(FaultSection closestSect, double distAway) {
            double strike = closestSect.getFaultTrace().getAveStrike();
            double strikeRad = Math.toRadians(strike);
            double azimuth = strikeRad + 1.5707963267948966;
            Location newLoc = LocationUtils.location(this.loc, azimuth, distAway);
            RuptureSurface surf = closestSect.getFaultSurface(0.1);
            double origDist = Double.POSITIVE_INFINITY;
            double newDist = Double.POSITIVE_INFINITY;
            for (Location surfLoc : surf.getEvenlyDiscritizedListOfLocsOnSurface()) {
                origDist = Math.min(LocationUtils.linearDistanceFast(surfLoc, this.loc), origDist);
                newDist = Math.min(LocationUtils.linearDistanceFast(surfLoc, newLoc), newDist);
            }
            double delta = newDist - origDist;
            System.out.println("Attempted to move away by " + distAway + " from " + closestSect.getName() + ". Actual: " + origDist + " => " + newDist + " = " + delta);
            System.out.println("\tOrig Loc: " + String.valueOf(this.loc));
            System.out.println("\tNew Loc: " + String.valueOf(newLoc));
            System.out.println("\tStrike: " + strike);
            System.out.println("\tMoved in direction: " + LocationUtils.azimuth(this.loc, newLoc));
            System.out.println("\tMoved distance: " + LocationUtils.linearDistanceFast(this.loc, newLoc));
            this.loc = newLoc;
        }

        public TriggerRupture buildTriggerRupture() {
            return this.buildTriggerRupture(null);
        }

        public TriggerRupture buildTriggerRupture(Long customOccurrenceTime) {
            if (this.fssIndex >= 0) {
                Double overrideMag = null;
                if (Double.isNaN(this.mag)) {
                    overrideMag = this.mag;
                }
                return new TriggerRupture.FSS(this.fssIndex, customOccurrenceTime, overrideMag);
            }
            return new TriggerRupture.Point(this.loc, customOccurrenceTime, this.mag);
        }
    }
}

