/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.erf.ETAS;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import java.util.Arrays;
import java.util.Collection;
import org.opensha.commons.data.function.IntegerPDF_FunctionSampler;

class SectionSourceNuclRates {
    private int[] sourceIndexes;
    private float[] nuclRates;

    public SectionSourceNuclRates(Collection<Integer> sourceIndexes) {
        this(Ints.toArray(sourceIndexes));
    }

    public SectionSourceNuclRates(int[] sourceIndexes) {
        this.sourceIndexes = sourceIndexes;
        Arrays.sort(sourceIndexes);
        this.nuclRates = new float[sourceIndexes.length];
    }

    public int size() {
        return this.sourceIndexes.length;
    }

    public int getSourceIndex(int index) {
        return this.sourceIndexes[index];
    }

    public float getSourceNucleationRate(int index) {
        return this.nuclRates[index];
    }

    public void setSourceNucleationRate(int index, float rate) {
        this.nuclRates[index] = rate;
    }

    public int indexOf(int sourceIndex) {
        int ind = Arrays.binarySearch(this.sourceIndexes, sourceIndex);
        Preconditions.checkState((ind >= 0 && ind < this.sourceIndexes.length ? 1 : 0) != 0, (String)"Source %s not found in this SectionSourceNuclRates datastore", (int)sourceIndex);
        return ind;
    }

    public IntegerPDF_FunctionSampler buildSampler() {
        return new IntegerPDF_FunctionSampler(this.nuclRates);
    }
}

