/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.erf.ETAS;

import java.awt.Color;
import java.util.ArrayList;
import org.opensha.commons.data.function.AbstractDiscretizedFunc;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.HistogramFunction;
import org.opensha.commons.gui.plot.GraphWindow;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import scratch.UCERF3.erf.ETAS.ETAS_Utils;

public class SeisDepthDistribution {
    double[] depthVals = new double[]{0.0, 3.0, 6.0, 12.0, 24.0};
    double[] relWtVals = new double[]{0.0, 1.0, 10.0, 2.0, 0.0};
    ArbitrarilyDiscretizedFunc depthDistFunc = new ArbitrarilyDiscretizedFunc();
    ArbitrarilyDiscretizedFunc inverseCumDepthDistFunc;
    HistogramFunction cumHistFunc;

    public SeisDepthDistribution() {
        int i;
        for (int i2 = 0; i2 < this.depthVals.length; ++i2) {
            this.depthDistFunc.set(this.depthVals[i2], this.relWtVals[i2]);
        }
        double totArea = 0.0;
        for (int i3 = 1; i3 < this.depthVals.length; ++i3) {
            totArea += 0.5 * (this.depthVals[i3] - this.depthVals[i3 - 1]) * Math.abs(this.relWtVals[i3] - this.relWtVals[i3 - 1]) + Math.min(this.relWtVals[i3], this.relWtVals[i3 - 1]) * (this.depthVals[i3] - this.depthVals[i3 - 1]);
        }
        this.depthDistFunc.scale(1.0 / totArea);
        this.depthDistFunc.setName("Depth Distribution Function");
        HistogramFunction histFunc = new HistogramFunction(0.05, 240, 0.1);
        for (i = 0; i < histFunc.size(); ++i) {
            histFunc.set(i, this.depthDistFunc.getInterpolatedY(histFunc.getX(i)));
        }
        this.cumHistFunc = histFunc.getCumulativeDistFunctionWithHalfBinOffset();
        this.cumHistFunc.scale(1.0 / this.cumHistFunc.getMaxY());
        this.inverseCumDepthDistFunc = new ArbitrarilyDiscretizedFunc();
        for (i = 0; i < this.cumHistFunc.size(); ++i) {
            this.inverseCumDepthDistFunc.set(this.cumHistFunc.getY(i), this.cumHistFunc.getX(i));
        }
    }

    public ArbitrarilyDiscretizedFunc getDepthDistributionFunction() {
        return this.depthDistFunc;
    }

    public double getProbAtDepth(double depth) {
        return this.depthDistFunc.getInterpolatedY(depth);
    }

    public double getProbBetweenDepths(double depth1, double depth2) {
        return this.cumHistFunc.getInterpolatedY(depth2) - this.cumHistFunc.getInterpolatedY(depth1);
    }

    public double getRandomDepth(ETAS_Utils etas_utils) {
        return this.inverseCumDepthDistFunc.getInterpolatedY(etas_utils.getRandomDouble());
    }

    public void plotBinnedDepthDistribution() {
        double delta = 2.0;
        HistogramFunction binnedDepthDistFunc = new HistogramFunction(1.0, 12, delta);
        for (int i = 0; i < binnedDepthDistFunc.size(); ++i) {
            double prob = this.getProbBetweenDepths(binnedDepthDistFunc.getX(i) - delta / 2.0, binnedDepthDistFunc.getX(i) + delta / 2.0);
            binnedDepthDistFunc.set(i, prob);
        }
        System.out.println("totBinnedProb=" + binnedDepthDistFunc.calcSumOfY_Vals());
        PlotCurveCharacterstics plotChar = new PlotCurveCharacterstics(PlotLineType.HISTOGRAM, 1.0f, Color.BLACK);
        GraphWindow graph2 = new GraphWindow(binnedDepthDistFunc, "Seismicity Depth Distribution", plotChar);
        graph2.setGriddedFuncAxesTicks(true);
        graph2.setX_AxisRange(0.0, 24.0);
        graph2.setY_AxisRange(0.0, 0.301);
        graph2.setX_AxisLabel("Depth (km)");
        graph2.setY_AxisLabel("Fraction");
        graph2.setAxisLabelFontSize(20);
        graph2.setPlotLabelFontSize(22);
        graph2.setTickLabelFontSize(18);
        graph2.setGriddedFuncAxesTicks(true);
    }

    public void testRandomDepth(int numSamples, ETAS_Utils etas_utils) {
        HistogramFunction testRandHistFunc = new HistogramFunction(0.05, 240, 0.1);
        long st = System.currentTimeMillis();
        for (int i = 0; i < numSamples; ++i) {
            double depth = this.getRandomDepth(etas_utils);
            if (depth < 0.0 || depth > 24.0) {
                throw new RuntimeException("problem depth: " + depth);
            }
            testRandHistFunc.add(depth, 1.0);
        }
        testRandHistFunc.scale(1.0 / ((double)numSamples * 0.1));
        System.out.println("That took " + (System.currentTimeMillis() - st) + " millisec");
        testRandHistFunc.setName("Randome Depth Distribution Histogram");
        ArrayList<AbstractDiscretizedFunc> funcs = new ArrayList<AbstractDiscretizedFunc>();
        funcs.add(this.depthDistFunc);
        funcs.add(testRandHistFunc);
        GraphWindow graph1 = new GraphWindow(funcs, "Test Random Depths");
        graph1.setX_AxisLabel("Depth (km)");
        graph1.setY_AxisLabel("Density");
    }

    public static void main(String[] args) {
        SeisDepthDistribution test = new SeisDepthDistribution();
        test.testRandomDepth(100000000, new ETAS_Utils());
    }
}

