/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.erf.ETAS.analysis;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Table;
import com.google.common.primitives.Doubles;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.commons.math3.stat.StatUtils;
import org.jfree.data.Range;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.data.region.CaliforniaRegions;
import org.opensha.commons.exceptions.GMT_MapException;
import org.opensha.commons.gui.plot.HeadlessGraphPanel;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.gui.plot.PlotSpec;
import org.opensha.commons.mapping.gmt.elements.GMT_CPT_Files;
import org.opensha.commons.util.ComparablePairing;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.commons.util.MarkdownUtils;
import org.opensha.commons.util.cpt.CPT;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import scratch.UCERF3.analysis.FaultBasedMapGen;
import scratch.UCERF3.analysis.FaultSysSolutionERF_Calc;
import scratch.UCERF3.erf.ETAS.ETAS_CatalogIO;
import scratch.UCERF3.erf.ETAS.ETAS_EqkRupture;
import scratch.UCERF3.erf.ETAS.analysis.ETAS_AbstractPlot;
import scratch.UCERF3.erf.ETAS.analysis.SimulationMarkdownGenerator;
import scratch.UCERF3.erf.ETAS.launcher.ETAS_Config;
import scratch.UCERF3.erf.ETAS.launcher.ETAS_Launcher;
import scratch.UCERF3.erf.FaultSystemSolutionERF;

public class ETAS_FaultParticipationPlot
extends ETAS_AbstractPlot {
    private String prefix;
    private boolean annualize;
    private boolean skipMaps;
    private boolean hasSpont;
    private boolean hasTriggered;
    private static final double[] default_calc_durations = new double[]{0.0027378507871321013, 0.019164955509924708, 0.08213552361396304, 1.0};
    private static final double[] default_mpd_durations = new double[]{0.019164955509924708, 0.08213552361396304, 1.0};
    private static final double[] default_map_durations = new double[]{1.0};
    private double[] durations;
    private double[] mapDurations;
    private double[] mpdDurations;
    private long[] maxOTs;
    private double[] plotMagBins = new double[]{0.0, 6.5, 7.0, 7.5, 8.0};
    private FaultStats[] subSectStats;
    private Map<Integer, FaultStats> parentSectStats;
    private Map<Integer, HashSet<FaultStats>> fssIndexToStatsMap;
    private boolean hasAny = false;
    private boolean[] hasMags;
    private int catalogCount = 0;
    private Map<Double, CSVFile<String>> sectionCSVs;
    private Map<Double, CSVFile<String>> parentCSVs;
    private static final double mfdMinMag = 6.05;
    private static final double mfdDeltaMag = 0.1;
    private static final int mfdNumMag = 31;
    private EvenlyDiscretizedFunc magXIndexes;
    private TD_CalcThread tdCalcThread;
    private Table<Double, Boolean, String[]> mapPlotPrefixes;
    private Table<String, Double, String> faultMFDPrefixes;
    private static boolean MAP_D = false;

    public ETAS_FaultParticipationPlot(ETAS_Config config, ETAS_Launcher launcher, String prefix, boolean annualize, boolean skipMaps) {
        super(config, launcher);
        this.prefix = prefix;
        this.annualize = annualize;
        this.skipMaps = skipMaps;
        this.hasTriggered = config.hasTriggers();
        this.hasSpont = config.isIncludeSpontaneous() || config.getTriggerCatalogFile() != null && config.isTreatTriggerCatalogAsSpontaneous();
        double calcDuration = config.getDuration();
        if (annualize) {
            this.durations = new double[]{calcDuration};
            this.mapDurations = this.durations;
            this.mpdDurations = this.durations;
        } else {
            ArrayList<Double> durList = new ArrayList<Double>();
            for (double dur : default_calc_durations) {
                if (!(dur <= calcDuration)) continue;
                durList.add(dur);
            }
            if (!durList.contains(calcDuration)) {
                durList.add(calcDuration);
            }
            this.durations = Doubles.toArray(durList);
            durList = new ArrayList();
            for (double dur : default_map_durations) {
                if (!(dur <= calcDuration)) continue;
                durList.add(dur);
            }
            if (!durList.contains(calcDuration)) {
                durList.add(calcDuration);
            }
            this.mapDurations = Doubles.toArray(durList);
            durList = new ArrayList();
            for (double dur : default_mpd_durations) {
                if (!(dur <= calcDuration)) continue;
                durList.add(dur);
            }
            if (!durList.contains(calcDuration)) {
                durList.add(calcDuration);
            }
            this.mpdDurations = Doubles.toArray(durList);
        }
        this.maxOTs = new long[this.durations.length];
        for (int i = 0; i < this.maxOTs.length; ++i) {
            this.maxOTs[i] = config.getSimulationStartTimeMillis() + (long)(this.durations[i] * 3.15576E10 + 0.5);
        }
        this.magXIndexes = new EvenlyDiscretizedFunc(6.05, 31, 0.1);
    }

    @Override
    public int getVersion() {
        return 3;
    }

    @Override
    public boolean isFilterSpontaneous() {
        return this.hasTriggered;
    }

    public Map<Integer, FaultStats> getParentSectStats() {
        return this.parentSectStats;
    }

    @Override
    protected synchronized void doProcessCatalog(ETAS_CatalogIO.ETAS_Catalog completeCatalog, ETAS_CatalogIO.ETAS_Catalog triggeredOnlyCatalog, FaultSystemSolution fss) {
        if (this.subSectStats == null) {
            System.out.println("Initializing section stats/mappings");
            FaultSystemRupSet rupSet = fss.getRupSet();
            this.subSectStats = new FaultStats[rupSet.getNumSections()];
            this.parentSectStats = new HashMap<Integer, FaultStats>();
            this.fssIndexToStatsMap = new HashMap<Integer, HashSet<FaultStats>>();
            for (int s = 0; s < rupSet.getNumSections(); ++s) {
                FaultSection sect = rupSet.getFaultSectionData(s);
                HashSet<Integer> rupIDs = new HashSet<Integer>(rupSet.getRupturesForSection(s));
                this.subSectStats[s] = new FaultStats(s, sect.getName(), rupIDs);
                this.mapRupturesToStat(this.subSectStats[s]);
                Integer parentID = sect.getParentSectionId();
                if (this.parentSectStats.containsKey(parentID)) continue;
                HashSet<Integer> parentRups = new HashSet<Integer>(rupSet.getRupturesForParentSection(parentID));
                FaultStats parentStats = new FaultStats(parentID, sect.getParentSectionName(), parentRups);
                this.mapRupturesToStat(parentStats);
                this.parentSectStats.put(parentID, parentStats);
            }
            this.hasMags = new boolean[this.plotMagBins.length];
            System.out.println("DONE Initializing section stats/mappings");
            this.tdCalcThread = new TD_CalcThread();
            this.tdCalcThread.start();
        }
        HashSet statsToProcess = new HashSet();
        for (ETAS_EqkRupture rup : completeCatalog) {
            if (rup.getFSSIndex() < 0) continue;
            statsToProcess.addAll(this.fssIndexToStatsMap.get(rup.getFSSIndex()));
        }
        this.hasAny = this.hasAny || !statsToProcess.isEmpty();
        for (FaultStats stats : statsToProcess) {
            stats.processCatalog(completeCatalog, triggeredOnlyCatalog);
        }
        ++this.catalogCount;
    }

    private void mapRupturesToStat(FaultStats stat) {
        for (Integer fssIndex : stat.allRupIDs) {
            HashSet<FaultStats> statsForIndex = this.fssIndexToStatsMap.get(fssIndex);
            if (statsForIndex == null) {
                statsForIndex = new HashSet();
                this.fssIndexToStatsMap.put(fssIndex, statsForIndex);
            }
            statsForIndex.add(stat);
        }
    }

    private CSVFile<String> buildCSV(FaultStats[] stats, boolean parents, double minMag, FaultSystemSolution fss) {
        CSVFile<String> csv = new CSVFile<String>(true);
        ArrayList<Object> header = new ArrayList<Object>();
        if (parents) {
            HashMap<String, FaultStats> namesMap = new HashMap<String, FaultStats>();
            for (FaultStats stat : stats) {
                namesMap.put(stat.name, stat);
            }
            ArrayList names = new ArrayList(namesMap.keySet());
            Collections.sort(names);
            stats = new FaultStats[names.size()];
            for (int i = 0; i < names.size(); ++i) {
                stats[i] = (FaultStats)namesMap.get(names.get(i));
            }
            header.add("Parent ID");
            header.add("Parent Name");
        } else {
            header.add("Subsection Index");
            header.add("Subsection Name");
        }
        double calcDuration = this.getConfig().getDuration();
        if (this.annualize) {
            if (this.hasSpont) {
                header.add("Total Mean Annual Rate");
                for (double duration : this.durations) {
                    header.add("Total " + ETAS_FaultParticipationPlot.getTimeLabel(duration, false) + " Prob");
                }
            }
            if (this.hasTriggered) {
                header.add("Triggered Mean Annual Rate");
                for (double duration : this.durations) {
                    header.add("Triggered " + ETAS_FaultParticipationPlot.getTimeLabel(duration, false) + " Prob");
                }
                header.add("Triggered Primary Mean Annual Rate");
            }
            header.add("Long-Term Fault System Solution Rate");
        } else {
            if (this.hasSpont) {
                header.add("Total " + ETAS_FaultParticipationPlot.getTimeLabel(calcDuration, false) + " Mean Count");
                for (double duration : this.durations) {
                    header.add("Total " + ETAS_FaultParticipationPlot.getTimeLabel(duration, false) + " Prob");
                }
            }
            if (this.hasTriggered) {
                header.add("Triggered " + ETAS_FaultParticipationPlot.getTimeLabel(calcDuration, false) + " Mean Count");
                for (double duration : this.durations) {
                    header.add("Triggered " + ETAS_FaultParticipationPlot.getTimeLabel(duration, false) + " Prob");
                }
                header.add("Triggered " + ETAS_FaultParticipationPlot.getTimeLabel(calcDuration, false) + " Primary Mean Count");
            }
        }
        csv.addLine((List<String>)header);
        int magIndex = this.getMFD_magIndex(minMag);
        for (FaultStats stat : stats) {
            int d;
            ArrayList<Object> line = new ArrayList<Object>();
            line.add("" + stat.id);
            line.add(stat.name);
            if (this.hasSpont) {
                line.add("" + (float)stat.spontCumulativeMNDs[this.durations.length - 1].getY(magIndex));
                for (d = 0; d < this.durations.length; ++d) {
                    line.add("" + (float)stat.spontCumulativeProbs[d].getY(magIndex));
                }
            }
            if (this.hasTriggered) {
                line.add("" + (float)stat.triggeredCumulativeMNDs[this.durations.length - 1].getY(magIndex));
                for (d = 0; d < this.durations.length; ++d) {
                    line.add("" + (float)stat.triggeredCumulativeProbs[d].getY(magIndex));
                }
                line.add("" + (float)stat.triggeredPrimaryCumulativeMNDs[this.durations.length - 1].getY(magIndex));
            }
            if (this.annualize) {
                EvenlyDiscretizedFunc fssMFD = stat.getFSS_IncrMFD(fss).getCumRateDistWithOffset();
                line.add("" + (float)fssMFD.getY(magIndex));
            }
            csv.addLine((List<String>)line);
        }
        return csv;
    }

    private int getMFD_magIndex(double minMag) {
        int minIndex = 31;
        int i = 31;
        while (--i >= 0 && (float)this.magXIndexes.getX(i) >= (float)minMag) {
            minIndex = i;
        }
        Preconditions.checkState((minIndex < 31 ? 1 : 0) != 0);
        return minIndex;
    }

    @Override
    protected List<? extends Runnable> doFinalize(File outputDir, FaultSystemSolution fss, ExecutorService exec) throws IOException {
        if (!this.hasAny) {
            return null;
        }
        for (FaultStats stats : this.subSectStats) {
            stats.calcStats(this.catalogCount);
        }
        for (FaultStats stats : this.parentSectStats.values()) {
            stats.calcStats(this.catalogCount);
        }
        this.writeCSVs(outputDir, fss);
        if (!this.skipMaps) {
            this.writeMaps(outputDir, fss);
        }
        this.writeFaultMFDs(outputDir, fss);
        return null;
    }

    private void writeMaps(File outputDir, FaultSystemSolution fss) throws IOException {
        CPT cpt = GMT_CPT_Files.MAX_SPECTRUM.instance();
        CPT ratioCPT = GMT_CPT_Files.GMT_POLAR.instance().rescale(-1.0, 1.0);
        ratioCPT.setNanColor(Color.GRAY);
        double maxRate = 0.0;
        int minPlotMagIndex = this.getMFD_magIndex(StatUtils.min((double[])this.plotMagBins));
        int maxDurationIndex = 0;
        for (int d = 1; d < this.mapDurations.length; ++d) {
            if (!(this.mapDurations[d] > this.mapDurations[maxDurationIndex])) continue;
            maxDurationIndex = d;
        }
        FaultStats maxStat = null;
        for (FaultStats stats : this.subSectStats) {
            double statRate = this.annualize ? (this.hasSpont ? stats.spontCumulativeMNDs[maxDurationIndex].getY(minPlotMagIndex) : stats.triggeredCumulativeMNDs[maxDurationIndex].getY(minPlotMagIndex)) : (this.hasSpont ? stats.spontCumulativeProbs[maxDurationIndex].getY(minPlotMagIndex) : stats.triggeredCumulativeProbs[maxDurationIndex].getY(minPlotMagIndex));
            if (!(statRate > maxRate)) continue;
            maxStat = stats;
            maxRate = statRate;
        }
        if (maxStat != null) {
            System.out.println("Max rate: " + maxRate + " from " + maxStat.name);
        }
        double fractionalRate = this.annualize ? 1.0 / Math.max(1.0, (double)Math.round((double)this.catalogCount * this.getConfig().getDuration())) : 1.0 / (double)this.catalogCount;
        double cptMin = Math.min(-3.0, Math.log10(fractionalRate));
        double cptMax = Math.max(-1.0, Math.ceil(Math.log10(maxRate)));
        if (!this.annualize) {
            cptMax = Math.min(1.0, cptMax);
        }
        System.out.println("CPT Range: " + cptMin + "\t" + cptMax);
        if (!Doubles.isFinite((double)cptMin) || !Doubles.isFinite((double)cptMax)) {
            return;
        }
        while (cptMax <= cptMin) {
            cptMax += 1.0;
        }
        cpt = cpt.rescale(cptMin, cptMax);
        cpt.setBelowMinColor(Color.LIGHT_GRAY);
        FaultSystemRupSet rupSet = fss.getRupSet();
        ArrayList faults = Lists.newArrayList();
        for (int sectIndex = 0; sectIndex < rupSet.getNumSections(); ++sectIndex) {
            faults.add(rupSet.getFaultSectionData(sectIndex).getFaultTrace());
        }
        Preconditions.checkState((faults.size() == this.subSectStats.length ? 1 : 0) != 0);
        ArrayList<Boolean> sponts = new ArrayList<Boolean>();
        if (this.hasSpont) {
            sponts.add(true);
        }
        if (this.hasTriggered) {
            sponts.add(false);
        }
        CaliforniaRegions.RELM_TESTING region = new CaliforniaRegions.RELM_TESTING();
        this.mapPlotPrefixes = HashBasedTable.create();
        for (int d = 0; d < this.mapDurations.length; ++d) {
            double duration = this.mapDurations[d];
            int statDurIndex = Arrays.binarySearch(this.durations, duration);
            Preconditions.checkState((statDurIndex >= 0 ? 1 : 0) != 0, (String)"Couldn't locate duration index for %s", (Object)duration);
            Iterator iterator = sponts.iterator();
            while (iterator.hasNext()) {
                boolean spont = (Boolean)iterator.next();
                this.mapPlotPrefixes.put((Object)duration, (Object)spont, (Object)new String[this.plotMagBins.length]);
                for (int p = 0; p < this.plotMagBins.length; ++p) {
                    String particTitle;
                    Object prefixAdd;
                    Object magStr;
                    if (!this.hasMags[p]) continue;
                    int magIndex = this.getMFD_magIndex(this.plotMagBins[p]);
                    double[] particRates = new double[this.subSectStats.length];
                    double[] primaryRates = null;
                    if (!spont && d == maxDurationIndex) {
                        primaryRates = new double[this.subSectStats.length];
                    }
                    double[] fssRates = this.annualize ? new double[this.subSectStats.length] : null;
                    for (int s = 0; s < this.subSectStats.length; ++s) {
                        if (this.annualize) {
                            if (spont) {
                                particRates[s] = this.subSectStats[s].spontCumulativeMNDs[statDurIndex].getY(magIndex);
                            } else {
                                particRates[s] = this.subSectStats[s].triggeredCumulativeMNDs[statDurIndex].getY(magIndex);
                                if (primaryRates != null) {
                                    primaryRates[s] = this.subSectStats[s].triggeredPrimaryCumulativeMNDs[statDurIndex].getY(magIndex);
                                }
                            }
                            if (this.annualize) {
                                fssRates[s] = this.subSectStats[s].getFSS_IncrMFD(fss).getCumRateDistWithOffset().getY(magIndex);
                            }
                        } else if (spont) {
                            particRates[s] = this.subSectStats[s].spontCumulativeProbs[statDurIndex].getY(magIndex);
                        } else {
                            particRates[s] = this.subSectStats[s].triggeredCumulativeProbs[statDurIndex].getY(magIndex);
                            if (primaryRates != null) {
                                primaryRates[s] = this.subSectStats[s].triggeredPrimaryCumulativeProbs[statDurIndex].getY(magIndex);
                            }
                        }
                        if (!MAP_D) continue;
                        if (this.subSectStats[s].name.toLowerCase().contains("mojave")) {
                            System.out.println("DEBUG: " + this.subSectStats[s].name + ", spont?\t" + spont + "\trate: " + particRates[s]);
                        }
                        if (maxStat == null || this.subSectStats[s].name != maxStat.name) continue;
                        System.out.println("DEBUG: MAX " + this.subSectStats[s].name + ", spont?\t" + spont + "\trate: " + particRates[s]);
                    }
                    if (MAP_D) {
                        System.out.println("Max calc rate for spont=" + spont + ", mag=" + (float)this.plotMagBins[p] + ", duration=" + (float)duration + ": " + StatUtils.max((double[])particRates));
                    }
                    if (this.plotMagBins[p] > 1.0) {
                        magStr = " M>=" + (float)this.plotMagBins[p];
                        prefixAdd = "_m" + (float)this.plotMagBins[p];
                    } else {
                        magStr = "";
                        prefixAdd = "";
                    }
                    if (this.annualize) {
                        particTitle = "Log10" + (String)magStr + " Participation Rate";
                    } else if (this.mapDurations.length > 1) {
                        prefixAdd = "_" + ETAS_FaultParticipationPlot.getTimeShortLabel(duration).replaceAll(" ", "") + (String)prefixAdd;
                        particTitle = "Log10 " + ETAS_FaultParticipationPlot.getTimeShortLabel(duration) + (String)magStr + " Participation Prob";
                    } else {
                        particTitle = "Log10" + (String)magStr + " Participation Prob";
                    }
                    if (!spont) {
                        particTitle = particTitle + ", Triggered Only";
                        prefixAdd = (String)prefixAdd + "_triggered";
                    }
                    ((String[])this.mapPlotPrefixes.get((Object)Double.valueOf((double)duration), (Object)Boolean.valueOf((boolean)spont)))[p] = this.prefix + "_partic" + (String)prefixAdd;
                    try {
                        FaultBasedMapGen.makeFaultPlot(cpt, faults, FaultBasedMapGen.log10(particRates), region, outputDir, this.prefix + "_partic" + (String)prefixAdd, false, false, particTitle);
                        if (!spont && primaryRates != null) {
                            FaultBasedMapGen.makeFaultPlot(cpt, faults, FaultBasedMapGen.log10(primaryRates), region, outputDir, this.prefix + "_partic" + (String)prefixAdd + "_primary", false, false, particTitle + ", Primary");
                        }
                    }
                    catch (RuntimeException | GMT_MapException e) {
                        throw ExceptionUtils.asRuntimeException(e);
                    }
                    if (!spont || !this.annualize) continue;
                    double[] ratios = new double[fssRates.length];
                    for (int i = 0; i < ratios.length; ++i) {
                        ratios[i] = particRates[i] / fssRates[i];
                    }
                    String title = "Log10" + (String)magStr + " Participation Rate/FSS Ratio";
                    try {
                        FaultBasedMapGen.makeFaultPlot(ratioCPT, faults, FaultBasedMapGen.log10(ratios), region, outputDir, this.prefix + "_partic" + (String)prefixAdd + "_ratio", false, false, title);
                        continue;
                    }
                    catch (RuntimeException | GMT_MapException e) {
                        throw ExceptionUtils.asRuntimeException(e);
                    }
                }
            }
        }
    }

    private void writeCSVs(File outputDir, FaultSystemSolution fss) throws IOException {
        this.sectionCSVs = new HashMap<Double, CSVFile<String>>();
        this.parentCSVs = new HashMap<Double, CSVFile<String>>();
        FaultStats[] parentStatsArray = new ArrayList<FaultStats>(this.parentSectStats.values()).toArray(new FaultStats[0]);
        for (int p = 0; p < this.plotMagBins.length; ++p) {
            double plotMinMag = this.plotMagBins[p];
            if (!this.hasMags[p]) continue;
            Object magStr = plotMinMag == 0.0 ? "supra_seis" : "m" + optionalDigitDF.format(plotMinMag);
            CSVFile<String> sectionCSV = this.buildCSV(this.subSectStats, false, plotMinMag, fss);
            this.sectionCSVs.put(plotMinMag, sectionCSV);
            sectionCSV.writeToFile(new File(outputDir, this.prefix + "_" + (String)magStr + "_sub_sects.csv"));
            CSVFile<String> parentCSV = this.buildCSV(parentStatsArray, true, plotMinMag, fss);
            this.parentCSVs.put(plotMinMag, parentCSV);
            parentCSV.writeToFile(new File(outputDir, this.prefix + "_" + (String)magStr + "_parent_sects.csv"));
        }
    }

    public Table<Integer, Double, EvenlyDiscretizedFunc> getTDCumulativeMPDs() {
        if (this.tdCalcThread.isAlive()) {
            try {
                this.tdCalcThread.join();
            }
            catch (InterruptedException e) {
                throw ExceptionUtils.asRuntimeException(e);
            }
        }
        return this.tdCalcThread.tdFuncs;
    }

    public double[] getDurations() {
        return this.durations;
    }

    private void writeFaultMFDs(File outputDir, FaultSystemSolution fss) throws IOException {
        this.faultMFDPrefixes = HashBasedTable.create();
        File subDir = new File(outputDir, "parent_sect_mpds");
        Preconditions.checkState((subDir.exists() || subDir.mkdir() ? 1 : 0) != 0);
        Table<Integer, Double, EvenlyDiscretizedFunc> tdFuncs = this.getTDCumulativeMPDs();
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("# Parent Section Magnitude-Probability Distributions");
        lines.add("");
        HashMap<String, FaultStats> nameStatsMap = new HashMap<String, FaultStats>();
        for (FaultStats stats : this.parentSectStats.values()) {
            nameStatsMap.put(stats.name, stats);
        }
        ArrayList<Object> names = new ArrayList();
        if (this.annualize || !this.hasTriggered) {
            names = new ArrayList(nameStatsMap.keySet());
            Collections.sort(names);
        } else {
            HashMap<FaultStats, Integer> triggerMap = new HashMap<FaultStats, Integer>();
            for (FaultStats faultStats : this.parentSectStats.values()) {
                if (faultStats.totTriggerCount <= 0) continue;
                triggerMap.put(faultStats, faultStats.totTriggerCount);
            }
            names = new ArrayList();
            for (FaultStats faultStats : ComparablePairing.getSortedData(triggerMap)) {
                names.add(faultStats.name);
            }
            Collections.reverse(names);
            lines.add("Only fault sections with at least one triggered aftershock are plotted. Sections are sorted by total supraseismogenic trigger rate (decreasing)");
            lines.add("");
        }
        int tocIndex = lines.size();
        String topLink = "*[(top)](#table-of-contents)*";
        lines.add("");
        System.out.print("Writing U3-TD parent section MFDs...");
        for (String string : names) {
            lines.add("## " + string);
            lines.add(topLink);
            lines.add("");
            FaultStats stats = (FaultStats)nameStatsMap.get(string);
            String prefix = stats.name.replaceAll("\\W+", "_");
            while (prefix.contains("__")) {
                prefix = prefix.replaceAll("__", "_");
            }
            if (prefix.startsWith("_")) {
                prefix = prefix.substring(1);
            }
            if (prefix.endsWith("_")) {
                prefix = prefix.substring(0, prefix.length() - 1);
            }
            this.writeFaultMFD(stats, subDir, prefix, fss, tdFuncs, lines);
            lines.add("");
        }
        System.out.println("DONE");
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("## Table Of Contents");
        arrayList.add("");
        arrayList.addAll(MarkdownUtils.buildTOC(lines, 2));
        lines.addAll(tocIndex, arrayList);
        MarkdownUtils.writeReadmeAndHTML(lines, subDir);
    }

    private void writeFaultMFD(FaultStats stats, File outputDir, String prefix, FaultSystemSolution fss, Table<Integer, Double, EvenlyDiscretizedFunc> tdFuncs, List<String> lines) throws IOException {
        int parentSectID = stats.id;
        IncrementalMagFreqDist tiRateFunc = fss.calcParticipationMFD_forParentSect(parentSectID, 6.05, this.magXIndexes.getMaxX(), 31);
        EvenlyDiscretizedFunc tdCumulativeRateFunc = tiRateFunc.getCumRateDistWithOffset();
        MarkdownUtils.TableBuilder plotTable = MarkdownUtils.tableBuilder();
        CSVFile<String> csv = new CSVFile<String>(true);
        ArrayList<Object> header = new ArrayList<Object>();
        header.add("Magnitude");
        if (this.annualize) {
            Preconditions.checkState((this.mpdDurations.length == 1 ? 1 : 0) != 0);
            header.add("UCERF3-TI Prob");
            header.add("UCERF3-TD Prob");
            header.add("UCERF3-ETAS Prob");
        } else {
            plotTable.initNewLine();
            for (int i = 0; i < this.mpdDurations.length; ++i) {
                double duration = this.mpdDurations[i];
                plotTable.addColumn(ETAS_FaultParticipationPlot.getTimeLabel(duration, false));
                String time = ETAS_FaultParticipationPlot.getTimeShortLabel(duration);
                header.add(time + " TI Prob");
                header.add(time + " TD Prob");
                header.add(time + " ETAS Prob");
                header.add(time + " ETAS/TD Gain");
                if (!this.hasTriggered) continue;
                if (this.hasSpont) {
                    header.add(time + " ETAS Triggered+TD");
                }
                header.add(time + " ETAS Triggered Only");
            }
            plotTable.finalizeLine();
        }
        csv.addLine((List<String>)header);
        ArrayList<EvenlyDiscretizedFunc> csvFuncs = new ArrayList<EvenlyDiscretizedFunc>();
        plotTable.initNewLine();
        for (double duration : this.mpdDurations) {
            int i;
            ArrayList<EvenlyDiscretizedFunc> funcs = new ArrayList<EvenlyDiscretizedFunc>();
            ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
            EvenlyDiscretizedFunc myTIFunc = new EvenlyDiscretizedFunc(tdCumulativeRateFunc.getMinX(), tdCumulativeRateFunc.getMaxX(), tdCumulativeRateFunc.size());
            for (int i2 = 0; i2 < myTIFunc.size(); ++i2) {
                myTIFunc.set(i2, 1.0 - Math.exp(-tdCumulativeRateFunc.getY(i2) * duration));
            }
            myTIFunc.setName("UCERF3-TI");
            funcs.add(myTIFunc);
            chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, Color.BLACK));
            csvFuncs.add(myTIFunc);
            EvenlyDiscretizedFunc myTDFunc = (EvenlyDiscretizedFunc)tdFuncs.get((Object)parentSectID, (Object)duration);
            myTDFunc.setName("UCERF3-TD");
            funcs.add(myTDFunc);
            chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, Color.BLUE));
            csvFuncs.add(myTDFunc);
            int durationIndex = -1;
            for (int i3 = 0; i3 < this.durations.length; ++i3) {
                double calcDuration = this.durations[i3];
                if (duration != calcDuration) continue;
                durationIndex = i3;
            }
            Preconditions.checkState((durationIndex >= 0 ? 1 : 0) != 0);
            if (this.hasSpont) {
                EvenlyDiscretizedFunc totFunc = stats.spontCumulativeProbs[durationIndex];
                totFunc.setName("UCERF3-ETAS");
                funcs.add(totFunc);
                chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, Color.RED));
                csvFuncs.add(totFunc);
                if (!this.annualize) {
                    EvenlyDiscretizedFunc gainFunc = new EvenlyDiscretizedFunc(totFunc.getMinX(), totFunc.getMaxX(), totFunc.size());
                    for (i = 0; i < gainFunc.size(); ++i) {
                        gainFunc.set(i, totFunc.getY(i) / myTDFunc.getY(i));
                    }
                    csvFuncs.add(gainFunc);
                }
            }
            if (this.hasTriggered && !this.annualize) {
                EvenlyDiscretizedFunc triggeredOnlyFunc = stats.triggeredCumulativeProbs[durationIndex];
                EvenlyDiscretizedFunc triggeredPlusTDFunc = new EvenlyDiscretizedFunc(triggeredOnlyFunc.getMinX(), triggeredOnlyFunc.getMaxX(), triggeredOnlyFunc.size());
                for (i = 0; i < triggeredOnlyFunc.size(); ++i) {
                    Preconditions.checkState((myTDFunc.getX(i) == triggeredOnlyFunc.getX(i) ? 1 : 0) != 0);
                    double tdProb = myTDFunc.getY(i);
                    double triggeredProb = triggeredOnlyFunc.getY(i);
                    double combProb = FaultSysSolutionERF_Calc.calcSummedProbs(tdProb, triggeredProb);
                    triggeredPlusTDFunc.set(i, combProb);
                }
                if (this.hasSpont) {
                    triggeredPlusTDFunc.setName("ETAS Triggered+TD");
                    funcs.add(triggeredPlusTDFunc);
                    chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, Color.RED.darker()));
                    csvFuncs.add(triggeredPlusTDFunc);
                } else {
                    triggeredPlusTDFunc.setName("UCERF3-ETAS");
                    funcs.add(triggeredPlusTDFunc);
                    chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, Color.RED));
                    csvFuncs.add(triggeredPlusTDFunc);
                    EvenlyDiscretizedFunc gainFunc = new EvenlyDiscretizedFunc(triggeredPlusTDFunc.getMinX(), triggeredPlusTDFunc.getMaxX(), triggeredPlusTDFunc.size());
                    for (int i4 = 0; i4 < gainFunc.size(); ++i4) {
                        gainFunc.set(i4, triggeredPlusTDFunc.getY(i4) / myTDFunc.getY(i4));
                    }
                    csvFuncs.add(gainFunc);
                }
                triggeredOnlyFunc.setName("ETAS Triggered Only");
                funcs.add(triggeredOnlyFunc);
                chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, Color.RED));
                csvFuncs.add(triggeredOnlyFunc);
            }
            String yAxisLabel = this.annualize ? "Annual Probability" : ETAS_FaultParticipationPlot.getTimeLabel(duration, false) + " Probability";
            PlotSpec spec = new PlotSpec(funcs, chars, stats.name, "Magnitude", yAxisLabel);
            spec.setLegendVisible(true);
            Range xRange = new Range(myTDFunc.getMinX(), myTDFunc.getMaxX());
            Range yRange = new Range(1.0E-8, 1.0);
            HeadlessGraphPanel gp = ETAS_FaultParticipationPlot.buildGraphPanel();
            gp.drawGraphPanel(spec, false, true, xRange, yRange);
            gp.getChartPanel().setSize(800, 600);
            String myPrefix = this.annualize ? prefix : prefix + "_" + ETAS_FaultParticipationPlot.getTimeShortLabel(duration).replaceAll(" ", "");
            gp.saveAsPNG(new File(outputDir, myPrefix + ".png").getAbsolutePath());
            plotTable.addColumn("![MPD](" + myPrefix + ".png)");
            this.faultMFDPrefixes.put((Object)stats.name, (Object)duration, (Object)myPrefix);
        }
        plotTable.finalizeLine();
        Preconditions.checkState((csvFuncs.size() == header.size() - 1 ? 1 : 0) != 0, (String)"Header len=%s, funcs=%s", (int)header.size(), (int)csvFuncs.size());
        DiscretizedFunc xVals = (DiscretizedFunc)csvFuncs.get(0);
        for (int i = 0; i < xVals.size(); ++i) {
            ArrayList<CallSite> line = new ArrayList<CallSite>();
            if (xVals.getY(i) == 0.0) break;
            line.add((CallSite)((Object)("" + (float)xVals.getX(i))));
            for (DiscretizedFunc discretizedFunc : csvFuncs) {
                line.add((CallSite)((Object)("" + (float)discretizedFunc.getY(i))));
            }
            csv.addLine((List<String>)line);
        }
        csv.writeToFile(new File(outputDir, prefix + ".csv"));
        lines.addAll(plotTable.build());
        lines.add("");
        lines.addAll(MarkdownUtils.tableFromCSV(csv, false).build());
    }

    @Override
    public List<String> generateMarkdown(String relativePathToOutputDir, String topLevelHeading, String topLink) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(topLevelHeading + " Section Participation");
        lines.add(topLink);
        lines.add("");
        if (!this.hasAny) {
            lines.add("No supra-seismogenic ruptures in any catalog");
            return lines;
        }
        if (!this.skipMaps) {
            lines.add(topLevelHeading + "# Section Participation Plots");
            lines.add(topLink);
            lines.add("");
            MarkdownUtils.TableBuilder builder = MarkdownUtils.tableBuilder();
            builder.initNewLine();
            builder.addColumn("Min Mag");
            for (int d = 0; d < this.mapDurations.length; ++d) {
                String label;
                String string = label = this.annualize ? "" : ETAS_FaultParticipationPlot.getTimeShortLabel(this.mapDurations[d]) + " ";
                if (this.hasSpont) {
                    builder.addColumn(label + "Complete Catalog (including spontaneous)");
                    if (this.annualize) {
                        builder.addColumn("Ratio WRT Long-Term Model");
                    }
                }
                if (!this.hasTriggered) continue;
                builder.addColumn(label + "Triggered Ruptures (no spontaneous)");
            }
            if (this.hasTriggered) {
                String titlePprefix = this.annualize ? "" : ETAS_FaultParticipationPlot.getTimeShortLabel(StatUtils.max((double[])this.mapDurations)) + " ";
                builder.addColumn(titlePprefix + "Triggered Ruptures (primary aftershocks only)");
            }
            builder.finalizeLine();
            for (int i = 0; i < this.plotMagBins.length; ++i) {
                double minMag = this.plotMagBins[i];
                if (!this.hasMags[i]) continue;
                builder.initNewLine();
                if (minMag == 0.0) {
                    builder.addColumn("**All Supra. Seis.**");
                } else {
                    builder.addColumn("**M&ge;" + optionalDigitDF.format(minMag) + "**");
                }
                String maxTriggeredPrefix = null;
                for (int d = 0; d < this.mapDurations.length; ++d) {
                    String prefix;
                    if (this.hasSpont) {
                        prefix = ((String[])this.mapPlotPrefixes.get((Object)this.mapDurations[d], (Object)true))[i];
                        builder.addColumn("![Participation Plot](" + relativePathToOutputDir + "/" + prefix + ".png)");
                        if (this.annualize) {
                            builder.addColumn("![Participation Plot](" + relativePathToOutputDir + "/" + prefix + "_ratio.png)");
                        }
                    }
                    if (!this.hasTriggered) continue;
                    prefix = ((String[])this.mapPlotPrefixes.get((Object)this.mapDurations[d], (Object)false))[i];
                    if (this.mapDurations[d] == StatUtils.max((double[])this.mapDurations)) {
                        maxTriggeredPrefix = prefix;
                    }
                    builder.addColumn("![Participation Plot](" + relativePathToOutputDir + "/" + prefix + ".png)");
                }
                if (this.hasTriggered) {
                    builder.addColumn("![Participation Plot](" + relativePathToOutputDir + "/" + maxTriggeredPrefix + "_primary.png)");
                }
                builder.finalizeLine();
            }
            lines.addAll(builder.build());
        }
        for (int m = 0; m < this.plotMagBins.length; ++m) {
            double minMag = this.plotMagBins[m];
            if (!this.hasMags[m]) continue;
            CSVFile<String> parentCSV = this.parentCSVs.get(minMag);
            parentCSV.sort(2, 1, new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    Double v1 = Double.parseDouble(o1);
                    Double v2 = Double.parseDouble(o2);
                    return v2.compareTo(v1);
                }
            });
            int numParentsWith = 0;
            for (int row = 1; row < parentCSV.getNumRows(); ++row) {
                if (!(Double.parseDouble(parentCSV.get(row, 2)) > 0.0)) continue;
                ++numParentsWith;
            }
            Preconditions.checkState((numParentsWith > 0 ? 1 : 0) != 0);
            int numParentsToPlot = Integer.min(10, numParentsWith);
            MarkdownUtils.TableBuilder builder = MarkdownUtils.tableBuilder();
            builder.initNewLine();
            for (int col = 1; col < parentCSV.getNumCols(); ++col) {
                String header = parentCSV.get(0, col);
                builder.addColumn(header);
                if (!header.contains("Prob")) continue;
                builder.addColumn(header.replaceAll("Prob", "95% Conf"));
            }
            builder.finalizeLine();
            int numForConf = this.getNumProcessed();
            for (int i = 0; i < numParentsToPlot; ++i) {
                int row = i + 1;
                builder.initNewLine();
                for (int col = 1; col < parentCSV.getNumCols(); ++col) {
                    String colStr = parentCSV.get(row, col);
                    if (parentCSV.get(0, col).contains("Prob")) {
                        double prob = Double.parseDouble(colStr);
                        builder.addColumn(ETAS_FaultParticipationPlot.getProbStr(prob, true));
                        builder.addColumn(ETAS_FaultParticipationPlot.getConfString(prob, numForConf, true));
                        continue;
                    }
                    builder.addColumn(colStr);
                }
                builder.finalizeLine();
            }
            Object magStr = minMag == 0.0 ? "Supra-Seismogenic" : "M\u2265" + optionalDigitDF.format(minMag);
            lines.add("");
            lines.add(topLevelHeading + "# " + (String)magStr + " Parent Sections Table");
            lines.add(topLink);
            lines.add("");
            if (numParentsWith > numParentsToPlot) {
                lines.add("*First " + numParentsToPlot + " of " + numParentsWith + " with matching ruptures shown*");
                lines.add("");
            }
            lines.addAll(builder.build());
        }
        if (!this.annualize && this.hasTriggered) {
            lines.add("");
            lines.add(topLevelHeading + " Fault Magnitude-Probability Distributions");
            lines.add(topLink);
            lines.add("");
            HashMap<FaultStats, Integer> triggerParentStats = new HashMap<FaultStats, Integer>();
            for (FaultStats stats : this.parentSectStats.values()) {
                if (stats.totTriggerCount <= 0) continue;
                triggerParentStats.put(stats, stats.totTriggerCount);
            }
            List sortedParents = ComparablePairing.getSortedData(triggerParentStats);
            Collections.reverse(sortedParents);
            int numParentsToPlot = Integer.min(5, sortedParents.size());
            lines.add("The first " + numParentsToPlot + " sections (sorted by trigger rate) are plotted below. All fault MPDs are available [here](" + relativePathToOutputDir + "/parent_sect_mpds/README.md)");
            if (numParentsToPlot > 0) {
                lines.add("");
                MarkdownUtils.TableBuilder table = MarkdownUtils.tableBuilder();
                table.initNewLine();
                for (double duration : this.mpdDurations) {
                    table.addColumn(ETAS_FaultParticipationPlot.getTimeLabel(duration, false));
                }
                table.finalizeLine();
                for (int i = 0; i < numParentsToPlot; ++i) {
                    FaultStats stats = (FaultStats)sortedParents.get(i);
                    table.initNewLine();
                    for (double duration : this.mpdDurations) {
                        table.addColumn("![MPD](" + relativePathToOutputDir + "/parent_sect_mpds/" + (String)this.faultMFDPrefixes.get((Object)stats.name, (Object)duration) + ".png)");
                    }
                    table.finalizeLine();
                }
                lines.addAll(table.build());
            }
        }
        return lines;
    }

    public static void main(String[] args) {
        File simDir = new File("/home/kevin/OpenSHA/UCERF3/etas/simulations/2019_09_04-ComCatM7p1_ci38457511_ShakeMapSurfaces");
        File configFile = new File(simDir, "config.json");
        try {
            ETAS_Config config = ETAS_Config.readJSON(configFile);
            ETAS_Launcher launcher = new ETAS_Launcher(config, false);
            int maxNumCatalogs = -1;
            ETAS_FaultParticipationPlot plot = new ETAS_FaultParticipationPlot(config, launcher, "fault_participation", false, false);
            File outputDir = new File(simDir, "plots");
            Preconditions.checkState((outputDir.exists() || outputDir.mkdir() ? 1 : 0) != 0);
            FaultSystemSolution fss = launcher.checkOutFSS();
            File inputFile = SimulationMarkdownGenerator.locateInputFile(config);
            int processed = 0;
            for (ETAS_CatalogIO.ETAS_Catalog catalog : ETAS_CatalogIO.getBinaryCatalogsIterable(inputFile, 0.0)) {
                if (processed % 1000 == 0) {
                    System.out.println("Catalog " + processed);
                }
                plot.processCatalog(catalog, fss);
                if (maxNumCatalogs <= 0 || ++processed != maxNumCatalogs) continue;
                break;
            }
            plot.finalize(outputDir, launcher.checkOutFSS());
            System.exit(0);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public class FaultStats
    implements Comparable<FaultStats> {
        private int id;
        private String name;
        private HashSet<Integer> allRupIDs;
        private IncrementalMagFreqDist[] spontMNDs;
        private IncrementalMagFreqDist[] triggeredMNDs;
        private IncrementalMagFreqDist[] triggeredPrimaryMNDs;
        private EvenlyDiscretizedFunc[] spontCumulativeMNDs;
        private EvenlyDiscretizedFunc[] triggeredCumulativeMNDs;
        private EvenlyDiscretizedFunc[] triggeredPrimaryCumulativeMNDs;
        private List<boolean[][]> spontAnyList;
        private List<boolean[][]> triggeredAnyList;
        private List<boolean[][]> triggeredPrimaryList;
        private IncrementalMagFreqDist[] spontIncrProbs;
        private EvenlyDiscretizedFunc[] spontCumulativeProbs;
        private IncrementalMagFreqDist[] triggeredIncrProbs;
        private EvenlyDiscretizedFunc[] triggeredCumulativeProbs;
        private IncrementalMagFreqDist[] triggeredPrimaryIncrProbs;
        private EvenlyDiscretizedFunc[] triggeredPrimaryCumulativeProbs;
        private IncrementalMagFreqDist fssIncrMFD;
        private int totTriggerCount = 0;

        private FaultStats(int id, String name, HashSet<Integer> allRupIDs) {
            int i;
            this.id = id;
            this.name = name;
            this.allRupIDs = allRupIDs;
            if (ETAS_FaultParticipationPlot.this.hasSpont) {
                this.spontMNDs = new IncrementalMagFreqDist[ETAS_FaultParticipationPlot.this.durations.length];
                for (i = 0; i < ETAS_FaultParticipationPlot.this.durations.length; ++i) {
                    this.spontMNDs[i] = new IncrementalMagFreqDist(6.05, 31, 0.1);
                }
                this.spontAnyList = new ArrayList<boolean[][]>();
            }
            if (ETAS_FaultParticipationPlot.this.hasTriggered) {
                this.triggeredMNDs = new IncrementalMagFreqDist[ETAS_FaultParticipationPlot.this.durations.length];
                this.triggeredPrimaryMNDs = new IncrementalMagFreqDist[ETAS_FaultParticipationPlot.this.durations.length];
                for (i = 0; i < ETAS_FaultParticipationPlot.this.durations.length; ++i) {
                    this.triggeredMNDs[i] = new IncrementalMagFreqDist(6.05, 31, 0.1);
                    this.triggeredPrimaryMNDs[i] = new IncrementalMagFreqDist(6.05, 31, 0.1);
                }
                this.triggeredAnyList = new ArrayList<boolean[][]>();
                this.triggeredPrimaryList = new ArrayList<boolean[][]>();
            }
        }

        public void processCatalog(List<ETAS_EqkRupture> catalog, List<ETAS_EqkRupture> triggeredOnlyCatalog) {
            Preconditions.checkState((this.spontIncrProbs == null && this.triggeredIncrProbs == null ? 1 : 0) != 0);
            if (ETAS_FaultParticipationPlot.this.hasSpont) {
                this.doProcessCatalog(catalog, this.spontMNDs, null, this.spontAnyList, null);
            }
            if (ETAS_FaultParticipationPlot.this.hasTriggered) {
                this.totTriggerCount += this.doProcessCatalog(triggeredOnlyCatalog, this.triggeredMNDs, this.triggeredPrimaryMNDs, this.triggeredAnyList, this.triggeredPrimaryList);
            }
        }

        private int doProcessCatalog(List<ETAS_EqkRupture> catalog, IncrementalMagFreqDist[] mnds, IncrementalMagFreqDist[] primaryMNDs, List<boolean[][]> anyList, List<boolean[][]> anyPrimaryList) {
            boolean[][] myAny = null;
            boolean[][] myAnyPrimary = null;
            int myCount = 0;
            for (ETAS_EqkRupture rup : catalog) {
                int fssIndex = rup.getFSSIndex();
                if (fssIndex < 0 || !this.allRupIDs.contains(fssIndex)) continue;
                double mag = rup.getMag();
                int magIndex = mnds[0].getClosestXIndex(mag);
                if (myAny == null) {
                    myAny = new boolean[ETAS_FaultParticipationPlot.this.durations.length][31];
                    if (anyPrimaryList != null) {
                        myAnyPrimary = new boolean[ETAS_FaultParticipationPlot.this.durations.length][31];
                    }
                }
                boolean primary = rup.getGeneration() == 1;
                for (int d = 0; d < ETAS_FaultParticipationPlot.this.durations.length; ++d) {
                    if (rup.getOriginTime() > ETAS_FaultParticipationPlot.this.maxOTs[d]) continue;
                    mnds[d].add(magIndex, 1.0);
                    if (primary && primaryMNDs != null) {
                        primaryMNDs[d].add(magIndex, 1.0);
                    }
                    myAny[d][magIndex] = true;
                    if (!primary || anyPrimaryList == null) continue;
                    myAnyPrimary[d][magIndex] = true;
                }
                ++myCount;
            }
            anyList.add(myAny);
            if (anyPrimaryList != null) {
                anyPrimaryList.add(myAnyPrimary);
            }
            return myCount;
        }

        public void calcStats(int numCatalogs) {
            Preconditions.checkState((this.spontIncrProbs == null && this.triggeredIncrProbs == null ? 1 : 0) != 0);
            double rateScalar = 1.0 / (double)numCatalogs;
            if (ETAS_FaultParticipationPlot.this.hasSpont) {
                Preconditions.checkState((this.spontCumulativeMNDs == null ? 1 : 0) != 0);
                this.spontCumulativeMNDs = new EvenlyDiscretizedFunc[ETAS_FaultParticipationPlot.this.durations.length];
                this.spontIncrProbs = new IncrementalMagFreqDist[ETAS_FaultParticipationPlot.this.durations.length];
                this.spontCumulativeProbs = new EvenlyDiscretizedFunc[ETAS_FaultParticipationPlot.this.durations.length];
            }
            if (ETAS_FaultParticipationPlot.this.hasTriggered) {
                Preconditions.checkState((this.triggeredCumulativeMNDs == null && this.triggeredPrimaryCumulativeMNDs == null ? 1 : 0) != 0);
                this.triggeredCumulativeMNDs = new EvenlyDiscretizedFunc[ETAS_FaultParticipationPlot.this.durations.length];
                this.triggeredPrimaryCumulativeMNDs = new EvenlyDiscretizedFunc[ETAS_FaultParticipationPlot.this.durations.length];
                this.triggeredIncrProbs = new IncrementalMagFreqDist[ETAS_FaultParticipationPlot.this.durations.length];
                this.triggeredCumulativeProbs = new EvenlyDiscretizedFunc[ETAS_FaultParticipationPlot.this.durations.length];
                this.triggeredPrimaryIncrProbs = new IncrementalMagFreqDist[ETAS_FaultParticipationPlot.this.durations.length];
                this.triggeredPrimaryCumulativeProbs = new EvenlyDiscretizedFunc[ETAS_FaultParticipationPlot.this.durations.length];
            }
            for (int d = 0; d < ETAS_FaultParticipationPlot.this.durations.length; ++d) {
                double durScalar;
                double d2 = durScalar = ETAS_FaultParticipationPlot.this.annualize ? rateScalar / ETAS_FaultParticipationPlot.this.durations[d] : rateScalar;
                if (ETAS_FaultParticipationPlot.this.hasSpont) {
                    this.spontMNDs[d].scale(durScalar);
                    this.spontCumulativeMNDs[d] = this.spontMNDs[d].getCumRateDistWithOffset();
                    this.calcProbs(this.spontAnyList, this.spontIncrProbs, this.spontCumulativeProbs, numCatalogs);
                }
                if (!ETAS_FaultParticipationPlot.this.hasTriggered) continue;
                this.triggeredMNDs[d].scale(durScalar);
                this.triggeredCumulativeMNDs[d] = this.triggeredMNDs[d].getCumRateDistWithOffset();
                this.triggeredPrimaryMNDs[d].scale(durScalar);
                this.triggeredPrimaryCumulativeMNDs[d] = this.triggeredPrimaryMNDs[d].getCumRateDistWithOffset();
                this.calcProbs(this.triggeredAnyList, this.triggeredIncrProbs, this.triggeredCumulativeProbs, numCatalogs);
                this.calcProbs(this.triggeredPrimaryList, this.triggeredPrimaryIncrProbs, this.triggeredPrimaryCumulativeProbs, numCatalogs);
            }
        }

        private void calcProbs(List<boolean[][]> anyList, IncrementalMagFreqDist[] incrProbs, EvenlyDiscretizedFunc[] cumulativeProbs, int numCatalogs) {
            for (int d = 0; d < ETAS_FaultParticipationPlot.this.durations.length; ++d) {
                incrProbs[d] = new IncrementalMagFreqDist(6.05, 31, 0.1);
                cumulativeProbs[d] = new EvenlyDiscretizedFunc(6.0, 31, 0.1);
                int[] incrCounts = new int[31];
                int[] cumulativeCounts = new int[31];
                for (boolean[][] any : anyList) {
                    int m;
                    if (any == null) continue;
                    int maxMagIndex = -1;
                    for (m = 0; m < 31; ++m) {
                        if (!any[d][m]) continue;
                        int n = m;
                        incrCounts[n] = incrCounts[n] + 1;
                        maxMagIndex = Integer.max(maxMagIndex, m);
                    }
                    if (maxMagIndex < 0) continue;
                    m = 0;
                    while (m <= maxMagIndex) {
                        int n = m++;
                        cumulativeCounts[n] = cumulativeCounts[n] + 1;
                    }
                    double plotMag = incrProbs[d].getX(maxMagIndex);
                    for (int m2 = 0; m2 < ETAS_FaultParticipationPlot.this.plotMagBins.length; ++m2) {
                        if (!(plotMag >= ETAS_FaultParticipationPlot.this.plotMagBins[m2])) continue;
                        ETAS_FaultParticipationPlot.this.hasMags[m2] = true;
                    }
                }
                for (int m = 0; m < 31; ++m) {
                    incrProbs[d].set(m, (double)incrCounts[m] / (double)numCatalogs);
                    cumulativeProbs[d].set(m, (double)cumulativeCounts[m] / (double)numCatalogs);
                    Preconditions.checkState((cumulativeCounts[m] >= incrCounts[m] ? 1 : 0) != 0);
                }
            }
        }

        public IncrementalMagFreqDist getFSS_IncrMFD(FaultSystemSolution fss) {
            if (this.fssIncrMFD == null) {
                IncrementalMagFreqDist mfd = new IncrementalMagFreqDist(6.05, 31, 0.1);
                FaultSystemRupSet rupSet = fss.getRupSet();
                for (int rup : this.allRupIDs) {
                    double mag = rupSet.getMagForRup(rup);
                    double rate = fss.getRateForRup(rup);
                    mfd.add(mfd.getClosestXIndex(mag), rate);
                }
                this.fssIncrMFD = mfd;
            }
            return this.fssIncrMFD;
        }

        @Override
        public int compareTo(FaultStats o) {
            return -Integer.compare(this.totTriggerCount, o.totTriggerCount);
        }

        public EvenlyDiscretizedFunc[] getTriggeredCumulativeMPDs() {
            return this.triggeredCumulativeProbs;
        }

        public EvenlyDiscretizedFunc[] getSpontCumulativeMPDs() {
            return this.spontCumulativeProbs;
        }

        public String getName() {
            return this.name;
        }
    }

    private class TD_CalcThread
    extends Thread {
        Table<Integer, Double, EvenlyDiscretizedFunc> tdFuncs;

        private TD_CalcThread() {
        }

        @Override
        public void run() {
            this.tdFuncs = HashBasedTable.create();
            System.out.print("Calculating U3-TD parent section MFDs in background...");
            FaultSystemSolutionERF erf = (FaultSystemSolutionERF)ETAS_FaultParticipationPlot.this.getLauncher().checkOutERF();
            for (double duration : ETAS_FaultParticipationPlot.this.mpdDurations) {
                erf.getTimeSpan().setDuration(duration);
                erf.updateForecast();
                Map<Integer, EvenlyDiscretizedFunc> mfds = FaultSysSolutionERF_Calc.calcParentSectSupraSeisMagProbDists(erf, 6.0, 31, 0.1);
                for (Integer parentID : mfds.keySet()) {
                    this.tdFuncs.put((Object)parentID, (Object)duration, (Object)mfds.get(parentID));
                }
            }
            ETAS_FaultParticipationPlot.this.getLauncher().checkInERF(erf);
            System.out.println("Finished background thread calculating U3-TD parent section MFDs");
        }
    }
}

