/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.erf.ETAS.analysis;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Doubles;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.apache.commons.math3.stat.descriptive.rank.Percentile;
import org.opensha.commons.data.function.XY_DataSet;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.commons.geo.LocationVector;
import org.opensha.commons.geo.Region;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.mapping.PoliticalBoundariesData;
import org.opensha.commons.util.DataUtils;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.commons.util.MarkdownUtils;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.faultSurface.RuptureSurface;
import scratch.UCERF3.erf.ETAS.ETAS_CatalogIO;
import scratch.UCERF3.erf.ETAS.ETAS_EqkRupture;
import scratch.UCERF3.erf.ETAS.analysis.ETAS_AbstractPlot;
import scratch.UCERF3.erf.ETAS.analysis.ETAS_EventMapPlotUtils;
import scratch.UCERF3.erf.ETAS.analysis.SimulationMarkdownGenerator;
import scratch.UCERF3.erf.ETAS.launcher.ETAS_Config;
import scratch.UCERF3.erf.ETAS.launcher.ETAS_Launcher;

public class ETAS_SimulatedCatalogPlot
extends ETAS_AbstractPlot {
    private List<List<ETAS_EqkRupture>> matchingCatalogs = null;
    private Percentile percentileCalc = new Percentile();
    private double smallest = Double.POSITIVE_INFINITY;
    private double largest = 0.0;
    private double[] catalogSizes;
    private int catalogCount = 0;
    private double[] percentiles;
    private int percentileRecalcModulus = 1;
    private String prefix;
    private double maxMag = Double.NaN;
    private static final double[] default_map_durations = new double[]{0.019164955509924708, 0.08213552361396304, 1.0};
    private double[] durations;
    private boolean noTitles = false;
    private boolean includeInputEvents = true;
    private Region forceRegion = null;
    private static final int max_generation = 5;
    private boolean plotGenerations = false;
    public static DecimalFormat pDF = new DecimalFormat("0.0#####");

    public ETAS_SimulatedCatalogPlot(ETAS_Config config, ETAS_Launcher launcher, String prefix, double ... percentiles) {
        super(config, launcher);
        this.prefix = prefix;
        Preconditions.checkState((percentiles.length > 0 ? 1 : 0) != 0);
        this.percentiles = percentiles;
        ArrayList<Double> durations = new ArrayList<Double>();
        for (double duration : default_map_durations) {
            if (!(duration <= config.getDuration())) continue;
            durations.add(duration);
        }
        if (!durations.contains(config.getDuration())) {
            durations.add(config.getDuration());
        }
        this.durations = Doubles.toArray(durations);
    }

    @Override
    public int getVersion() {
        return 1;
    }

    @Override
    public boolean isFilterSpontaneous() {
        return false;
    }

    @Override
    protected void doProcessCatalog(ETAS_CatalogIO.ETAS_Catalog completeCatalog, ETAS_CatalogIO.ETAS_Catalog triggeredOnlyCatalog, FaultSystemSolution fss) {
        double myCount;
        if (Double.isNaN(this.maxMag)) {
            this.maxMag = 0.0;
            if (this.getConfig().hasTriggers()) {
                for (ETAS_EqkRupture trigger : this.getLauncher().getCombinedTriggers()) {
                    this.maxMag = Math.max(this.maxMag, trigger.getMag());
                }
            }
        }
        boolean newSmallLarge = (myCount = (double)completeCatalog.size()) < this.smallest || myCount > this.largest;
        this.smallest = Math.min(myCount, this.smallest);
        this.largest = Math.max(myCount, this.largest);
        if (this.matchingCatalogs == null) {
            this.matchingCatalogs = new ArrayList<List<ETAS_EqkRupture>>();
            for (int i = 0; i < this.percentiles.length; ++i) {
                this.matchingCatalogs.add(completeCatalog);
            }
            this.catalogSizes = new double[0];
        }
        ++this.catalogCount;
        this.catalogSizes = Doubles.ensureCapacity((double[])this.catalogSizes, (int)this.catalogCount, (int)1000);
        this.catalogSizes[this.catalogCount - 1] = myCount;
        if (this.catalogCount % this.percentileRecalcModulus == 0 || newSmallLarge) {
            this.percentileCalc.setData(this.catalogSizes, 0, this.catalogCount);
        }
        if (this.catalogCount == 100) {
            this.percentileRecalcModulus = 10;
        }
        if (this.catalogCount == 1000) {
            this.percentileRecalcModulus = 50;
        }
        if (this.catalogCount == 10000) {
            this.percentileRecalcModulus = 100;
        }
        if (this.catalogCount == 50000) {
            this.percentileRecalcModulus = 500;
        }
        if (this.catalogCount == 100000) {
            this.percentileRecalcModulus = 1000;
        }
        for (int p = 0; p < this.percentiles.length; ++p) {
            double curDist;
            double expected = this.percentiles[p] == 0.0 ? 0.0 : this.percentileCalc.evaluate(this.percentiles[p]);
            double myDist = Math.abs(myCount - expected);
            if (!(myDist < (curDist = Math.abs((double)this.matchingCatalogs.get(p).size() - expected)))) continue;
            this.matchingCatalogs.set(p, completeCatalog);
        }
        for (ETAS_EqkRupture rup : completeCatalog) {
            this.maxMag = Math.max(this.maxMag, rup.getMag());
        }
    }

    public void setHideTitles() {
        this.noTitles = true;
    }

    public void setHideInputEvents() {
        this.includeInputEvents = false;
    }

    public void setForceRegion(Region forceRegion) {
        this.forceRegion = forceRegion;
    }

    public void setMaxMag(double maxMag) {
        this.maxMag = maxMag;
    }

    public void setPlotDurations(double[] durations) {
        this.durations = durations;
    }

    public void setPlotGenerations(boolean plotGenerations) {
        this.plotGenerations = plotGenerations;
    }

    @Override
    protected List<? extends Runnable> doFinalize(File outputDir, FaultSystemSolution fss, ExecutorService exec) throws IOException {
        ArrayList<XY_DataSet> inputFuncs = new ArrayList<XY_DataSet>();
        ArrayList<PlotCurveCharacterstics> inputChars = new ArrayList<PlotCurveCharacterstics>();
        XY_DataSet[] caXYs = PoliticalBoundariesData.loadCAOutlines();
        PlotCurveCharacterstics caOutlineChar = new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, Color.BLACK);
        for (XY_DataSet caXY : caXYs) {
            inputFuncs.add(caXY);
            inputChars.add(caOutlineChar);
        }
        PlotCurveCharacterstics faultTraceChar = new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.LIGHT_GRAY);
        PlotCurveCharacterstics faultOutlineChar = new PlotCurveCharacterstics(PlotLineType.DOTTED, 1.5f, Color.LIGHT_GRAY);
        boolean first = true;
        for (FaultSection faultSection : fss.getRupSet().getFaultSectionDataList()) {
            RuptureSurface surf = faultSection.getFaultSurface(1.0, false, false);
            List<XY_DataSet> outlines = ETAS_EventMapPlotUtils.getSurfOutlines(surf);
            Iterator<XY_DataSet> iterator = outlines.iterator();
            while (iterator.hasNext()) {
                XY_DataSet outline = iterator.next();
                inputFuncs.add(outline);
                inputChars.add(faultOutlineChar);
            }
            List<XY_DataSet> traces = ETAS_EventMapPlotUtils.getSurfTraces(surf);
            for (int i = 0; i < traces.size(); ++i) {
                XY_DataSet trace = traces.get(i);
                if (first) {
                    trace.setName("Fault Traces");
                    first = false;
                }
                inputFuncs.add(trace);
                inputChars.add(faultTraceChar);
            }
        }
        DataUtils.MinMaxAveTracker inputLatTrack = new DataUtils.MinMaxAveTracker();
        DataUtils.MinMaxAveTracker minMaxAveTracker = new DataUtils.MinMaxAveTracker();
        if (this.getConfig().hasTriggers() && this.includeInputEvents) {
            List<ETAS_EqkRupture> triggers = this.getLauncher().getCombinedTriggers();
            ETAS_EventMapPlotUtils.buildEventPlot(triggers, inputFuncs, inputChars, this.maxMag);
            for (ETAS_EqkRupture trigger : triggers) {
                Location loc = trigger.getHypocenterLocation();
                if (loc == null) continue;
                inputLatTrack.addValue(loc.getLatitude());
                minMaxAveTracker.addValue(loc.getLongitude());
            }
            first = true;
            for (int i = 0; i < inputFuncs.size(); ++i) {
                if (first && ((PlotCurveCharacterstics)inputChars.get(i)).getSymbol() != null) {
                    ((XY_DataSet)inputFuncs.get(i)).setName("Input Events");
                    first = false;
                } else {
                    ((XY_DataSet)inputFuncs.get(i)).setName(null);
                }
                ((PlotCurveCharacterstics)inputChars.get(i)).setColor(Color.GRAY);
            }
            if (first) {
                ((XY_DataSet)inputFuncs.get(inputFuncs.size() - 1)).setName("Input Events");
            }
        }
        ArrayList<MapRunnable> runnables = new ArrayList<MapRunnable>();
        for (int i = 0; i < this.percentiles.length; ++i) {
            Region mapRegion;
            Object topRight;
            double percentile = this.percentiles[i];
            List<ETAS_EqkRupture> catalog = this.matchingCatalogs.get(i);
            System.out.println("Creating map for percentile: " + (float)percentile);
            if (percentile > 0.0) {
                System.out.println("\tExpected number of events: " + (float)this.percentileCalc.evaluate(percentile));
            }
            System.out.println("\tActual number of events: " + catalog.size());
            DataUtils.MinMaxAveTracker latTrack = new DataUtils.MinMaxAveTracker();
            latTrack.addFrom(inputLatTrack);
            DataUtils.MinMaxAveTracker lonTrack = new DataUtils.MinMaxAveTracker();
            lonTrack.addFrom(minMaxAveTracker);
            ArrayList<Location> catalogLocs = new ArrayList<Location>();
            for (ETAS_EqkRupture rup : catalog) {
                Location hypo = rup.getHypocenterLocation();
                latTrack.addValue(hypo.getLatitude());
                lonTrack.addValue(hypo.getLongitude());
                catalogLocs.add(hypo);
                if (rup.getFSSIndex() < 0) continue;
                RuptureSurface surf = fss.getRupSet().getSurfaceForRupture(rup.getFSSIndex(), 1.0);
                rup.setRuptureSurface(surf);
            }
            if (this.forceRegion == null) {
                ETAS_Config.ComcatMetadata cMeta;
                double maxSpan = Math.max(latTrack.getMax() - latTrack.getMin(), lonTrack.getMax() - lonTrack.getMin());
                double centerLat = latTrack.getAverage();
                double centerLon = lonTrack.getAverage();
                double halfSpan = maxSpan * 0.5;
                topRight = new Location(centerLat + halfSpan, centerLon + halfSpan);
                Location bottomLeft = new Location(centerLat - halfSpan, centerLon - halfSpan);
                topRight = LocationUtils.location((Location)topRight, new LocationVector(45.0, 20.0, 0.0));
                bottomLeft = LocationUtils.location(bottomLeft, new LocationVector(225.0, 20.0, 0.0));
                mapRegion = new Region((Location)topRight, bottomLeft);
                int minNumInside = (int)Math.round((double)catalogLocs.size() * 0.95);
                double mySpan = maxSpan;
                while (mySpan > 3.0) {
                    halfSpan = (mySpan *= 0.9) * 0.5;
                    topRight = new Location(centerLat + halfSpan, centerLon + halfSpan);
                    bottomLeft = new Location(centerLat - halfSpan, centerLon - halfSpan);
                    topRight = LocationUtils.location((Location)topRight, new LocationVector(45.0, 20.0, 0.0));
                    bottomLeft = LocationUtils.location(bottomLeft, new LocationVector(225.0, 20.0, 0.0));
                    Region testRegion = new Region((Location)topRight, bottomLeft);
                    int numInside = 0;
                    for (Location loc : catalogLocs) {
                        if (!testRegion.contains(loc)) continue;
                        ++numInside;
                    }
                    if (numInside < minNumInside) break;
                    mapRegion = testRegion;
                }
                if ((cMeta = this.getConfig().getComcatMetadata()) != null && cMeta.region != null) {
                    Region cReg = this.getConfig().getComcatMetadata().region;
                    double minLat = Math.min(mapRegion.getMinLat(), cReg.getMinLat());
                    double minLon = Math.min(mapRegion.getMinLon(), cReg.getMinLon());
                    double maxLat = Math.max(mapRegion.getMaxLat(), cReg.getMaxLat());
                    double maxLon = Math.max(mapRegion.getMaxLon(), cReg.getMaxLon());
                    mapRegion = new Region(new Location(minLat, minLon), new Location(maxLat, maxLon));
                }
            } else {
                mapRegion = this.forceRegion;
            }
            for (double duration : this.durations) {
                ETAS_EqkRupture rup;
                ArrayList<ETAS_EqkRupture> subCatalog = new ArrayList<ETAS_EqkRupture>();
                long maxOT = (long)((double)this.getConfig().getSimulationStartTimeMillis() + duration * 3.15576E10 + 0.5);
                topRight = catalog.iterator();
                while (topRight.hasNext() && (rup = (ETAS_EqkRupture)topRight.next()).getOriginTime() <= maxOT) {
                    subCatalog.add(rup);
                }
                String myPrefix = this.prefix + "_p" + this.pLabel(percentile) + "_" + ETAS_SimulatedCatalogPlot.getTimeShortLabel(duration).replace(" ", "");
                String title = this.noTitles ? " " : "p" + this.pLabel(percentile) + " %-ile Catalog, " + subCatalog.size() + " Events, " + ETAS_SimulatedCatalogPlot.getTimeLabel(duration, false);
                runnables.add(new MapRunnable(outputDir, inputFuncs, inputChars, mapRegion, subCatalog, myPrefix, title, false));
                if (!this.plotGenerations) continue;
                myPrefix = myPrefix + "_generations";
                runnables.add(new MapRunnable(outputDir, inputFuncs, inputChars, mapRegion, subCatalog, myPrefix, title, true));
            }
        }
        return runnables;
    }

    @Override
    public List<String> generateMarkdown(String relativePathToOutputDir, String topLevelHeading, String topLink) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(topLevelHeading + " Individual Simulated Catalog Maps");
        lines.add(topLink);
        lines.add("");
        lines.add("These are map plots of individual catalogs from the simulations, selected as the closest catalog to each of the given percentiles in terms of total number of events.");
        lines.add("");
        MarkdownUtils.TableBuilder table = MarkdownUtils.tableBuilder();
        table.initNewLine();
        table.addColumn("Duration");
        for (double percentile : this.percentiles) {
            table.addColumn("p" + this.pLabel(percentile) + " %-ile");
        }
        table.finalizeLine();
        for (double duration : this.durations) {
            table.initNewLine();
            table.addColumn("**" + ETAS_SimulatedCatalogPlot.getTimeLabel(duration, false) + "**");
            for (double percentile : this.percentiles) {
                table.addColumn("![Map](" + relativePathToOutputDir + "/" + this.prefix + "_p" + this.pLabel(percentile) + "_" + ETAS_SimulatedCatalogPlot.getTimeShortLabel(duration).replace(" ", "") + ".png)");
            }
            table.finalizeLine();
            if (!this.plotGenerations) continue;
            table.initNewLine();
            table.addColumn("*Event Generations*");
            for (double percentile : this.percentiles) {
                table.addColumn("![Map](" + relativePathToOutputDir + "/" + this.prefix + "_p" + this.pLabel(percentile) + "_" + ETAS_SimulatedCatalogPlot.getTimeShortLabel(duration).replace(" ", "") + "_generations.png)");
            }
            table.finalizeLine();
        }
        lines.addAll(table.build());
        return lines;
    }

    private String pLabel(double percentile) {
        if (percentile == 100.0) {
            percentile = 100.0 * ((double)this.catalogCount - 1.0) / (double)this.catalogCount;
        }
        return pDF.format(percentile);
    }

    public static void main(String[] args) {
        File simDir = new File("/home/kevin/OpenSHA/UCERF3/etas/simulations/2019_07_16-ComCatM7p1_ci38457511_ShakeMapSurfaces-noSpont-full_td-scale1.14");
        File configFile = new File(simDir, "config.json");
        try {
            ETAS_Config config = ETAS_Config.readJSON(configFile);
            ETAS_Launcher launcher = new ETAS_Launcher(config, false);
            int maxNumCatalogs = 1000;
            ETAS_SimulatedCatalogPlot plot = new ETAS_SimulatedCatalogPlot(config, launcher, "sim_catalog_map", 0.0, 25.0, 50.0, 75.0, 100.0);
            File outputDir = new File(simDir, "plots");
            Preconditions.checkState((outputDir.exists() || outputDir.mkdir() ? 1 : 0) != 0);
            FaultSystemSolution fss = launcher.checkOutFSS();
            File inputFile = SimulationMarkdownGenerator.locateInputFile(config);
            int processed = 0;
            for (ETAS_CatalogIO.ETAS_Catalog catalog : ETAS_CatalogIO.getBinaryCatalogsIterable(inputFile, 0.0)) {
                if (processed % 1000 == 0) {
                    System.out.println("Catalog " + processed);
                }
                plot.processCatalog(catalog, fss);
                if (maxNumCatalogs <= 0 || ++processed != maxNumCatalogs) continue;
                break;
            }
            plot.finalize(outputDir, launcher.checkOutFSS());
            System.exit(0);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private class MapRunnable
    implements Runnable {
        private File outputDir;
        private List<XY_DataSet> inputFuncs;
        private List<PlotCurveCharacterstics> inputChars;
        private Region mapRegion;
        private List<ETAS_EqkRupture> subCatalog;
        private String title;
        private String prefix;
        private boolean generation;

        public MapRunnable(File outputDir, List<XY_DataSet> inputFuncs, List<PlotCurveCharacterstics> inputChars, Region mapRegion, List<ETAS_EqkRupture> subCatalog, String prefix, String title, boolean generation) {
            this.outputDir = outputDir;
            this.inputFuncs = inputFuncs;
            this.inputChars = inputChars;
            this.mapRegion = mapRegion;
            this.subCatalog = subCatalog;
            this.prefix = prefix;
            this.title = title;
            this.generation = generation;
        }

        @Override
        public void run() {
            ArrayList<XY_DataSet> funcs = new ArrayList<XY_DataSet>(this.inputFuncs);
            ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>(this.inputChars);
            try {
                if (this.generation) {
                    ETAS_EventMapPlotUtils.buildGenerationPlot(this.subCatalog, funcs, chars, ETAS_SimulatedCatalogPlot.this.maxMag, 5);
                } else {
                    ETAS_EventMapPlotUtils.buildEventPlot(this.subCatalog, funcs, chars, ETAS_SimulatedCatalogPlot.this.maxMag);
                }
                ETAS_EventMapPlotUtils.writeMapPlot(funcs, chars, this.mapRegion, this.title, this.outputDir, this.prefix, 700);
            }
            catch (IOException e) {
                throw ExceptionUtils.asRuntimeException(e);
            }
        }
    }
}

