/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.erf.ETAS.analysis;

import com.google.common.base.Preconditions;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.data.function.DefaultXY_DataSet;
import org.opensha.commons.data.function.XY_DataSet;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.commons.geo.Region;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.mapping.PoliticalBoundariesData;
import org.opensha.commons.util.ClassUtils;
import org.opensha.commons.util.DataUtils;
import org.opensha.commons.util.FaultUtils;
import org.opensha.commons.util.MarkdownUtils;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.faultSysSolution.modules.PolygonFaultGridAssociations;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.faultSurface.RuptureSurface;
import org.opensha.sha.faultSurface.Surface3D;
import scratch.UCERF3.erf.ETAS.ETAS_CatalogIO;
import scratch.UCERF3.erf.ETAS.ETAS_EqkRupture;
import scratch.UCERF3.erf.ETAS.analysis.ETAS_AbstractPlot;
import scratch.UCERF3.erf.ETAS.analysis.ETAS_EventMapPlotUtils;
import scratch.UCERF3.erf.ETAS.launcher.ETAS_Config;
import scratch.UCERF3.erf.ETAS.launcher.ETAS_Launcher;

public class ETAS_TriggerRuptureFaultDistancesPlot
extends ETAS_AbstractPlot {
    private List<FaultDistStats> distStats;
    private CSVFile<String> csv;
    private double maxDist;
    private File outputDir;
    private boolean hasFinite = false;
    private static DecimalFormat distDF = new DecimalFormat("0.000");

    public ETAS_TriggerRuptureFaultDistancesPlot(ETAS_Config config, ETAS_Launcher launcher, double maxDist) {
        super(config, launcher);
        this.maxDist = maxDist;
    }

    @Override
    public int getVersion() {
        return 1;
    }

    @Override
    public boolean isFilterSpontaneous() {
        return false;
    }

    @Override
    protected void doProcessCatalog(ETAS_CatalogIO.ETAS_Catalog completeCatalog, ETAS_CatalogIO.ETAS_Catalog triggeredOnlyCatalog, FaultSystemSolution fss) {
    }

    @Override
    protected List<? extends Runnable> doFinalize(File outputDir, FaultSystemSolution fss, ExecutorService exec) throws IOException {
        this.outputDir = outputDir;
        List<? extends FaultSection> subSects = fss.getRupSet().getFaultSectionDataList();
        PolygonFaultGridAssociations polyMgr = fss.getRupSet().getModule(PolygonFaultGridAssociations.class);
        System.out.println("Building polygons");
        Region mapRegion = ETAS_EventMapPlotUtils.getMapRegion(this.getConfig(), this.getLauncher());
        List<ETAS_EqkRupture> triggers = this.getLauncher().getTriggerRuptures();
        ArrayList<LocationList> triggerLocLists = new ArrayList<LocationList>();
        DataUtils.MinMaxAveTracker latTrack = new DataUtils.MinMaxAveTracker();
        DataUtils.MinMaxAveTracker lonTrack = new DataUtils.MinMaxAveTracker();
        for (ETAS_EqkRupture trigger : triggers) {
            LocationList surfLocs = trigger.getRuptureSurface().getEvenlyDiscritizedListOfLocsOnSurface();
            for (Location loc : surfLocs) {
                latTrack.addValue(loc.getLatitude());
                lonTrack.addValue(loc.getLongitude());
            }
            triggerLocLists.add(surfLocs);
        }
        latTrack.addValue(mapRegion.getMaxLat());
        latTrack.addValue(mapRegion.getMinLat());
        lonTrack.addValue(mapRegion.getMaxLon());
        lonTrack.addValue(mapRegion.getMinLon());
        ETAS_Config.ComcatMetadata meta = this.getConfig().getComcatMetadata();
        if (meta != null && meta.region != null) {
            latTrack.addValue(meta.region.getMinLat());
            latTrack.addValue(meta.region.getMaxLat());
            lonTrack.addValue(meta.region.getMinLon());
            lonTrack.addValue(meta.region.getMaxLon());
        }
        Location maxLoc = new Location(latTrack.getMax(), lonTrack.getMax());
        Location minLoc = new Location(latTrack.getMin(), lonTrack.getMin());
        maxLoc = LocationUtils.location(maxLoc, 0.7853981633974483, this.maxDist * 1.5);
        minLoc = LocationUtils.location(minLoc, 3.9269908169872414, this.maxDist * 1.5);
        Region totSurfRegion = new Region(maxLoc, minLoc);
        ArrayList<FaultSection> nearSects = new ArrayList<FaultSection>();
        for (FaultSection faultSection : subSects) {
            boolean contains = false;
            for (Location loc : faultSection.getFaultTrace()) {
                contains = contains || totSurfRegion.contains(loc);
            }
            if (!contains) continue;
            nearSects.add(faultSection);
        }
        boolean skip = nearSects.size() > 500 && triggers.size() > 500;
        HashMap<Integer, FaultDistStats> hashMap = new HashMap<Integer, FaultDistStats>();
        for (FaultSection sect : nearSects) {
            Integer parentID = sect.getParentSectionId();
            if (!hashMap.containsKey(parentID)) {
                hashMap.put(parentID, new FaultDistStats(sect.getParentSectionName()));
            }
            Region poly = polyMgr == null ? null : polyMgr.getPoly(sect.getSectionId());
            ((FaultDistStats)hashMap.get(parentID)).addSubSect(sect, poly);
        }
        this.distStats = new ArrayList(hashMap.values());
        if (skip) {
            System.out.println("Skipping distances as there are too many triggers (" + triggers.size() + ") and nearby sections (" + nearSects.size() + ")");
        } else {
            System.out.println("Will compute distances for " + nearSects.size() + " nearby sections (of " + subSects.size() + " total)");
            System.out.println("Processing " + triggers.size() + " triggers");
            for (int i = 0; i < triggers.size(); ++i) {
                ETAS_EqkRupture trigger = triggers.get(i);
                this.hasFinite = this.hasFinite || !trigger.getRuptureSurface().isPointSurface();
                LocationList surfLocs = (LocationList)triggerLocLists.get(i);
                for (FaultDistStats stats : this.distStats) {
                    stats.processTrigger(trigger, surfLocs);
                }
            }
            Collections.sort(this.distStats);
            this.csv = new CSVFile(true);
            ArrayList<String> header = new ArrayList<String>();
            header.add("Section Name");
            header.add("Strike, Dip, Rake");
            if (triggers.size() > 1) {
                header.add("# Hypos In Poly");
                header.add("Max Mag w/ Hypo In Poly");
                header.add("# Surfs In Poly");
                header.add("Max Mag w/ Surf In Poly");
                header.add("Min Dist To Any (km)");
                header.add("Min Poly Dist To Any (km)");
                header.add("Min Dist To Largest (km)");
                header.add("Min Poly Dist To Largest (km)");
                if (this.hasFinite) {
                    header.add("Min Hypo Dist To Largest (km)");
                    header.add("Min Hypo Poly Dist To Largest (km)");
                }
            } else {
                header.add("Hypocenter In Polygon?");
                header.add("Surface In Polygon?");
                if (this.hasFinite) {
                    header.add("Minimum Surface Distance (km)");
                    header.add("Minimum Surface Poly Distance (km)");
                    header.add("Minimum Hypo Distance (km)");
                    header.add("Minimum Hypo Poly Distance (km)");
                } else {
                    header.add("Minimum Distance (km)");
                    header.add("Minimum Poly Distance (km)");
                }
            }
            this.csv.addLine((List<String>)header);
            for (FaultDistStats dists : this.distStats) {
                ArrayList<Object> line = new ArrayList<Object>();
                line.add(dists.parentName);
                ArrayList<Double> strikes = new ArrayList<Double>();
                ArrayList<Double> dips = new ArrayList<Double>();
                ArrayList<Double> rakes = new ArrayList<Double>();
                for (FaultSection sect : dists.subSects) {
                    strikes.add(sect.getFaultTrace().getAveStrike());
                    dips.add(sect.getAveDip());
                    rakes.add(sect.getAveRake());
                }
                double aveStrike = FaultUtils.getAngleAverage(strikes);
                double aveDip = FaultUtils.getAngleAverage(dips);
                double aveRake = FaultUtils.getInRakeRange(FaultUtils.getAngleAverage(rakes));
                line.add(Math.round(aveStrike) + ", " + Math.round(aveDip) + ", " + Math.round(aveRake));
                if (triggers.size() > 1) {
                    line.add("" + dists.numHyposInsidePolygon);
                    line.add(Double.isFinite(dists.maxMagHypoInsidePolygon) ? "" + (float)dists.maxMagHypoInsidePolygon : "");
                    line.add("" + dists.numSurfsInsidePolygon);
                    line.add(Double.isFinite(dists.maxMagSurfsInsidePolygon) ? "" + (float)dists.maxMagSurfsInsidePolygon : "");
                    line.add(ETAS_TriggerRuptureFaultDistancesPlot.distStr(dists.minDistToAny));
                    line.add(ETAS_TriggerRuptureFaultDistancesPlot.distStr(dists.minPolyDistToAny));
                    line.add(ETAS_TriggerRuptureFaultDistancesPlot.distStr(dists.minDistToMax));
                    line.add(ETAS_TriggerRuptureFaultDistancesPlot.distStr(dists.minPolyDistToMax));
                    if (this.hasFinite) {
                        line.add(ETAS_TriggerRuptureFaultDistancesPlot.distStr(dists.minHypoDistToMax));
                        line.add(ETAS_TriggerRuptureFaultDistancesPlot.distStr(dists.minHypoPolyDistToMax));
                    }
                } else {
                    line.add(dists.numHyposInsidePolygon > 0 ? "true" : "false");
                    line.add(dists.numSurfsInsidePolygon > 0 ? "true" : "false");
                    line.add(ETAS_TriggerRuptureFaultDistancesPlot.distStr(dists.minDistToAny));
                    line.add(ETAS_TriggerRuptureFaultDistancesPlot.distStr(dists.minPolyDistToAny));
                    if (this.hasFinite) {
                        line.add(ETAS_TriggerRuptureFaultDistancesPlot.distStr(dists.minHypoDistToMax));
                        line.add(ETAS_TriggerRuptureFaultDistancesPlot.distStr(dists.minHypoPolyDistToMax));
                    }
                }
                this.csv.addLine((List<String>)line);
            }
            this.csv.writeToFile(new File(outputDir, "trigger_rup_fault_distances.csv"));
        }
        this.makeMapPlot(outputDir, "trigger_rup_fault_map", triggers, mapRegion);
        if (!skip) {
            this.makeDepthPlot(outputDir, "trigger_rup_depth_map", triggers);
        }
        return null;
    }

    private static String distStr(double dist) {
        if (Double.isFinite(dist)) {
            return distDF.format(dist);
        }
        return "N/A";
    }

    private void makeMapPlot(File outputDir, String prefix, List<ETAS_EqkRupture> triggers, Region mapRegion) throws IOException {
        int i;
        ArrayList<XY_DataSet> funcs = new ArrayList<XY_DataSet>();
        ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
        XY_DataSet[] caXYs = PoliticalBoundariesData.loadCAOutlines();
        PlotCurveCharacterstics caOutlineChar = new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, Color.BLACK);
        for (XY_DataSet caXY : caXYs) {
            funcs.add(caXY);
            chars.add(caOutlineChar);
        }
        ArrayList<XY_DataSet> traceXYs = new ArrayList<XY_DataSet>();
        ArrayList<XY_DataSet> outlineXYs = new ArrayList<XY_DataSet>();
        ArrayList<DefaultXY_DataSet> polyXYs = new ArrayList<DefaultXY_DataSet>();
        PlotCurveCharacterstics faultTraceChar = new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, Color.BLACK);
        PlotCurveCharacterstics faultOutlineChar = new PlotCurveCharacterstics(PlotLineType.DOTTED, 2.0f, Color.BLACK);
        PlotCurveCharacterstics faultPolyChar = new PlotCurveCharacterstics(PlotLineType.SOLID, 1.5f, Color.LIGHT_GRAY);
        for (FaultDistStats stats : this.distStats) {
            for (int i2 = 0; i2 < stats.subSects.size(); ++i2) {
                Region poly = stats.polys.get(i2);
                if (poly != null) {
                    DefaultXY_DataSet polyXY = new DefaultXY_DataSet();
                    for (Location loc : poly.getBorder()) {
                        polyXY.set(loc.getLongitude(), loc.getLatitude());
                    }
                    polyXY.set(polyXY.get(0));
                    polyXYs.add(polyXY);
                }
                traceXYs.addAll(ETAS_EventMapPlotUtils.getSurfTraces(stats.subSectSurfs.get(i2)));
                outlineXYs.addAll(ETAS_EventMapPlotUtils.getSurfOutlines(stats.subSectSurfs.get(i2)));
            }
        }
        for (i = 0; i < polyXYs.size(); ++i) {
            if (i == 0) {
                ((XY_DataSet)polyXYs.get(i)).setName("Fault Polygons");
            }
            funcs.add((XY_DataSet)polyXYs.get(i));
            chars.add(faultPolyChar);
        }
        for (i = 0; i < outlineXYs.size(); ++i) {
            funcs.add((XY_DataSet)outlineXYs.get(i));
            chars.add(faultOutlineChar);
        }
        for (i = 0; i < traceXYs.size(); ++i) {
            if (i == 0) {
                ((XY_DataSet)traceXYs.get(i)).setName("Fault Traces");
            }
            funcs.add((XY_DataSet)traceXYs.get(i));
            chars.add(faultTraceChar);
        }
        ETAS_EventMapPlotUtils.buildEventPlot(triggers, funcs, chars);
        ETAS_EventMapPlotUtils.writeMapPlot(funcs, chars, mapRegion, "Trigger Ruptures & Faults", outputDir, prefix);
    }

    private void makeDepthPlot(File outputDir, String prefix, List<ETAS_EqkRupture> triggers) throws IOException {
        double surfMag = Double.NEGATIVE_INFINITY;
        Surface3D surf = null;
        for (ETAS_EqkRupture trigger : triggers) {
            RuptureSurface mySurf = trigger.getRuptureSurface();
            if (mySurf.isPointSurface() || !(trigger.getMag() > surfMag)) continue;
            surf = mySurf;
            surfMag = trigger.getMag();
        }
        if (triggers.isEmpty() || surf == null || surf.isPointSurface()) {
            System.out.println("Skipping depth plot:");
            if (triggers.isEmpty()) {
                System.out.println("\tno triggers");
            }
            if (surf == null) {
                System.out.println("\tno surf");
            } else if (surf.isPointSurface()) {
                System.out.println("\tpoint surface (" + ClassUtils.getClassNameWithoutPackage(surf.getClass()) + ")");
            }
            return;
        }
        ArrayList<XY_DataSet> funcs = new ArrayList<XY_DataSet>();
        ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
        ETAS_EventMapPlotUtils.buildEventDepthPlot(triggers, funcs, chars, (RuptureSurface)surf);
        ETAS_EventMapPlotUtils.writeDepthPlot(funcs, chars, "Trigger Rupture Depth Profile", outputDir, prefix);
    }

    @Override
    public List<String> generateMarkdown(String relativePathToOutputDir, String topLevelHeading, String topLink) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(topLevelHeading + " Trigger Rupture Fault Map");
        lines.add(topLink);
        lines.add("");
        lines.add("![Map](" + relativePathToOutputDir + "/trigger_rup_fault_map.png)");
        File depthFile = new File(this.outputDir, "trigger_rup_depth_map.png");
        if (depthFile.exists()) {
            lines.add(topLevelHeading + " Trigger Rupture Depth Map");
            lines.add(topLink);
            lines.add("");
            lines.add("![Map](" + relativePathToOutputDir + "/trigger_rup_depth_map.png)");
        }
        if (this.csv == null) {
            return lines;
        }
        lines.add("");
        lines.add(topLevelHeading + " Fault Distances To Triggers");
        lines.add(topLink);
        lines.add("");
        CSVFile<String> filteredCSV = new CSVFile<String>(true);
        filteredCSV.addLine(this.csv.getLine(0));
        for (int i = 0; i < this.distStats.size(); ++i) {
            if (!(this.distStats.get((int)i).minDistToAny <= this.maxDist)) continue;
            filteredCSV.addLine(this.csv.getLine(i + 1));
        }
        if (filteredCSV.getNumRows() > 1) {
            lines.addAll(MarkdownUtils.tableFromCSV(filteredCSV, false).build());
        } else {
            lines.add("No fault sections within " + (float)this.maxDist + " km of any trigger rupture");
        }
        return lines;
    }

    public static void main(String[] args) {
        File simDir = new File("/home/kevin/OpenSHA/UCERF3/etas/simulations/2019_09_04-ComCatM7p1_ci38457511_ShakeMapSurfaces_CulledSurface");
        File configFile = new File(simDir, "config.json");
        try {
            ETAS_Config config = ETAS_Config.readJSON(configFile);
            ETAS_Launcher launcher = new ETAS_Launcher(config, false);
            ETAS_TriggerRuptureFaultDistancesPlot plot = new ETAS_TriggerRuptureFaultDistancesPlot(config, launcher, 20.0);
            File outputDir = new File(simDir, "plots");
            Preconditions.checkState((outputDir.exists() || outputDir.mkdir() ? 1 : 0) != 0);
            plot.finalize(outputDir, launcher.checkOutFSS());
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private class FaultDistStats
    implements Comparable<FaultDistStats> {
        private String parentName;
        private List<FaultSection> subSects;
        private List<RuptureSurface> subSectSurfs;
        private List<LocationList> sectLocs;
        private List<Region> polys;
        private int numHyposInsidePolygon = 0;
        private double maxMagHypoInsidePolygon = Double.NEGATIVE_INFINITY;
        private int numSurfsInsidePolygon = 0;
        private double maxMagSurfsInsidePolygon = Double.NEGATIVE_INFINITY;
        private double maxMag = Double.NEGATIVE_INFINITY;
        private double minDistToAny = Double.POSITIVE_INFINITY;
        private double minPolyDistToAny = Double.POSITIVE_INFINITY;
        private double minDistToMax = Double.POSITIVE_INFINITY;
        private double minPolyDistToMax = Double.POSITIVE_INFINITY;
        private double minHypoDistToMax = Double.POSITIVE_INFINITY;
        private double minHypoPolyDistToMax = Double.POSITIVE_INFINITY;

        public FaultDistStats(String parentName) {
            this.parentName = parentName;
            this.subSects = new ArrayList<FaultSection>();
            this.subSectSurfs = new ArrayList<RuptureSurface>();
            this.sectLocs = new ArrayList<LocationList>();
            this.polys = new ArrayList<Region>();
        }

        public void addSubSect(FaultSection sect, Region poly) {
            this.subSects.add(sect);
            RuptureSurface surf = sect.getFaultSurface(1.0, false, false);
            this.subSectSurfs.add(surf);
            this.sectLocs.add(surf.getEvenlyDiscritizedListOfLocsOnSurface());
            this.polys.add(poly);
        }

        public void processTrigger(ETAS_EqkRupture trigger, LocationList surfLocs) {
            boolean isMaxMag;
            Location hypo = trigger.getHypocenterLocation();
            boolean bl = isMaxMag = trigger.getMag() > this.maxMag;
            if (isMaxMag) {
                this.maxMag = trigger.getMag();
                this.minDistToMax = Double.POSITIVE_INFINITY;
                this.minPolyDistToMax = Double.POSITIVE_INFINITY;
            }
            boolean hypoContains = false;
            boolean surfContains = false;
            for (int i = 0; i < this.subSects.size(); ++i) {
                Region poly = this.polys.get(i);
                LocationList sectLocs = this.sectLocs.get(i);
                hypoContains = hypoContains || poly != null && hypo != null && poly.contains(hypo);
                for (Location rupLoc : surfLocs) {
                    surfContains = surfContains || poly.contains(rupLoc);
                    double polyDist = poly.distanceToLocation(rupLoc);
                    this.minPolyDistToAny = Math.min(this.minPolyDistToAny, polyDist);
                    if (!isMaxMag) continue;
                    this.minPolyDistToMax = Math.min(this.minPolyDistToMax, polyDist);
                }
                for (Location rupLoc : surfLocs) {
                    for (Location sectLoc : sectLocs) {
                        double dist = LocationUtils.linearDistanceFast(rupLoc, sectLoc);
                        this.minDistToAny = Math.min(this.minDistToAny, dist);
                        if (!isMaxMag) continue;
                        this.minDistToMax = Math.min(this.minDistToMax, dist);
                    }
                }
                if (!isMaxMag || surfLocs.size() <= 1 || hypo == null) continue;
                for (Location sectLoc : sectLocs) {
                    double dist = LocationUtils.linearDistanceFast(hypo, sectLoc);
                    this.minHypoDistToMax = Math.min(this.minHypoDistToMax, dist);
                }
                double polyDist = poly == null ? Double.POSITIVE_INFINITY : poly.distanceToLocation(hypo);
                this.minHypoPolyDistToMax = Math.min(this.minHypoPolyDistToMax, polyDist);
            }
            if (hypoContains) {
                ++this.numHyposInsidePolygon;
                this.maxMagHypoInsidePolygon = Math.max(this.maxMagHypoInsidePolygon, trigger.getMag());
            }
            if (surfContains) {
                ++this.numSurfsInsidePolygon;
                this.maxMagSurfsInsidePolygon = Math.max(this.maxMagSurfsInsidePolygon, trigger.getMag());
            }
        }

        @Override
        public int compareTo(FaultDistStats o) {
            if (this.numHyposInsidePolygon != o.numHyposInsidePolygon) {
                return -Integer.compare(this.numHyposInsidePolygon, o.numHyposInsidePolygon);
            }
            if (this.numSurfsInsidePolygon != o.numSurfsInsidePolygon) {
                return -Integer.compare(this.numSurfsInsidePolygon, o.numSurfsInsidePolygon);
            }
            return Double.compare(this.minDistToAny, o.minDistToAny);
        }
    }
}

