/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.erf.ETAS.launcher;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import org.opensha.commons.data.comcat.EdgeRuptureSurface;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.util.FaultUtils;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.faultSurface.CompoundSurface;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.faultSurface.RuptureSurface;
import org.opensha.sha.faultSurface.SimpleFaultData;
import org.opensha.sha.faultSurface.StirlingGriddedSurface;
import scratch.UCERF3.erf.ETAS.ETAS_EqkRupture;
import scratch.UCERF3.erf.ETAS.ETAS_Params.ETAS_ParameterList;

public abstract class TriggerRupture {
    final Long customOccurrenceTime;
    private String comcatEventID;
    private Double etas_log10_k;
    private Double etas_p;
    private Double etas_c;

    protected TriggerRupture(Long customOccurrenceTime) {
        this.customOccurrenceTime = customOccurrenceTime;
    }

    public long getOccurrenceTime(long simulationStartTime) {
        if (this.customOccurrenceTime != null && this.customOccurrenceTime > Long.MIN_VALUE) {
            Preconditions.checkState((this.customOccurrenceTime <= simulationStartTime ? 1 : 0) != 0, (String)"Trigger rupture custom occurrence time (%s) cannot be after simulation start time (%s)", (Object)this.customOccurrenceTime, (long)simulationStartTime);
            return this.customOccurrenceTime;
        }
        return simulationStartTime;
    }

    public String getComcatEventID() {
        return this.comcatEventID;
    }

    public void setComcatEventID(String comcatEventID) {
        this.comcatEventID = comcatEventID;
    }

    public void setETAS_Params(Double log10_k, Double p, Double c) {
        this.etas_log10_k = log10_k;
        this.etas_p = p;
        this.etas_c = c;
    }

    public Double getETAS_log10_k() {
        return this.etas_log10_k;
    }

    public Double getETAS_p() {
        return this.etas_p;
    }

    public Double getETAS_c() {
        return this.etas_c;
    }

    public ETAS_EqkRupture buildRupture(FaultSystemRupSet rupSet, long simulationStartTime, ETAS_ParameterList etasParams) {
        ETAS_EqkRupture rupture = new ETAS_EqkRupture();
        long ot = this.getOccurrenceTime(simulationStartTime);
        rupture.setOriginTime(ot);
        if (this.comcatEventID != null) {
            rupture.setEventId(this.comcatEventID);
        }
        Double k = null;
        if (this.etas_log10_k != null) {
            k = Math.pow(10.0, this.etas_log10_k);
        }
        rupture.setCustomETAS_Params(k, this.etas_p, this.etas_c);
        this.populateRupture(rupSet, rupture);
        return rupture;
    }

    protected abstract void populateRupture(FaultSystemRupSet var1, ETAS_EqkRupture var2);

    public abstract Double getMag(FaultSystemRupSet var1);

    public abstract int[] getSectionsRuptured(FaultSystemRupSet var1);

    public static class EdgeFault
    extends TriggerRupture {
        public final LocationList[] outlines;
        public final Location hypo;
        public final double mag;
        public final int[] sectsReset;

        public EdgeFault(Long customOccurrenceTime, Location hypo, double mag, LocationList ... outlines) {
            this(customOccurrenceTime, hypo, mag, (int[])null, outlines);
        }

        public EdgeFault(Long customOccurrenceTime, Location hypo, double mag, int[] sectsReset, LocationList ... outlines) {
            super(customOccurrenceTime);
            Preconditions.checkState((outlines.length > 0 ? 1 : 0) != 0, (Object)"Must supply at least 1 rupture outline!");
            this.outlines = outlines;
            this.hypo = hypo;
            this.mag = mag;
            this.sectsReset = sectsReset;
        }

        @Override
        public void populateRupture(FaultSystemRupSet rupSet, ETAS_EqkRupture rupture) {
            System.out.println("Building rupture from " + this.outlines.length + " fault outlines, OT=" + rupture.getOriginTime() + " and M=" + (float)this.mag);
            rupture.setMag(this.mag);
            rupture.setHypocenterLocation(this.hypo);
            ArrayList<EdgeRuptureSurface> rupSurfs = new ArrayList<EdgeRuptureSurface>();
            double gridSpacing = 1.0;
            for (LocationList outline : this.outlines) {
                rupSurfs.add(EdgeRuptureSurface.build(outline, gridSpacing));
            }
            if (rupSurfs.size() == 1) {
                rupture.setRuptureSurface((RuptureSurface)rupSurfs.get(0));
            } else {
                rupture.setRuptureSurface(new CompoundSurface(rupSurfs));
            }
        }

        @Override
        public int[] getSectionsRuptured(FaultSystemRupSet rupSet) {
            return this.sectsReset;
        }

        @Override
        public Double getMag(FaultSystemRupSet rupSet) {
            return this.mag;
        }
    }

    public static class SimpleFault
    extends TriggerRupture {
        public final SimpleFaultData[] sfds;
        public final Location hypo;
        public final double mag;
        public final int[] sectsReset;

        public SimpleFault(Long customOccurrenceTime, Location hypo, double mag, SimpleFaultData ... sfds) {
            this(customOccurrenceTime, hypo, mag, (int[])null, sfds);
        }

        public SimpleFault(Long customOccurrenceTime, Location hypo, double mag, int[] sectsReset, SimpleFaultData ... sfds) {
            super(customOccurrenceTime);
            Preconditions.checkState((sfds.length > 0 ? 1 : 0) != 0, (Object)"Must supply at least 1 simple fault description!");
            this.sfds = sfds;
            this.hypo = hypo;
            this.mag = mag;
            this.sectsReset = sectsReset;
        }

        @Override
        public void populateRupture(FaultSystemRupSet rupSet, ETAS_EqkRupture rupture) {
            System.out.println("Building rupture from " + this.sfds.length + " simple faults OT=" + rupture.getOriginTime() + " and M=" + (float)this.mag);
            rupture.setMag(this.mag);
            rupture.setHypocenterLocation(this.hypo);
            ArrayList<StirlingGriddedSurface> rupSurfs = new ArrayList<StirlingGriddedSurface>();
            double gridSpacing = 1.0;
            for (SimpleFaultData sfd : this.sfds) {
                rupSurfs.add(new StirlingGriddedSurface(sfd, gridSpacing, gridSpacing));
            }
            if (rupSurfs.size() == 1) {
                rupture.setRuptureSurface((RuptureSurface)rupSurfs.get(0));
            } else {
                rupture.setRuptureSurface(new CompoundSurface(rupSurfs));
            }
        }

        @Override
        public int[] getSectionsRuptured(FaultSystemRupSet rupSet) {
            return this.sectsReset;
        }

        @Override
        public Double getMag(FaultSystemRupSet rupSet) {
            return this.mag;
        }
    }

    public static class Point
    extends TriggerRupture {
        final Location hypocenter;
        final double mag;
        public final int[] sectsReset;

        public Point(Location hypocenter, Long customOccurrenceTime, double mag) {
            this(hypocenter, customOccurrenceTime, mag, null);
        }

        public Point(Location hypocenter, Long customOccurrenceTime, double mag, int[] sectsReset) {
            super(customOccurrenceTime);
            this.hypocenter = hypocenter;
            this.mag = mag;
            this.sectsReset = sectsReset;
        }

        @Override
        public void populateRupture(FaultSystemRupSet rupSet, ETAS_EqkRupture rupture) {
            rupture.setAveRake(0.0);
            rupture.setMag(this.mag);
            rupture.setPointSurface(this.hypocenter);
            rupture.setHypocenterLocation(this.hypocenter);
        }

        @Override
        public int[] getSectionsRuptured(FaultSystemRupSet rupSet) {
            return this.sectsReset;
        }

        @Override
        public Double getMag(FaultSystemRupSet rupSet) {
            return this.mag;
        }
    }

    public static class SectionBased
    extends TriggerRupture {
        public final int[] subSects;
        final double mag;

        public SectionBased(int[] subSects, Long customOccurrenceTime, double mag) {
            super(customOccurrenceTime);
            Preconditions.checkState((subSects.length > 0 ? 1 : 0) != 0, (Object)"Must supply at least 1 subsection index!");
            this.subSects = subSects;
            this.mag = mag;
        }

        @Override
        public void populateRupture(FaultSystemRupSet rupSet, ETAS_EqkRupture rupture) {
            System.out.println("Building rupture from " + this.subSects.length + " specified subsections with OT=" + rupture.getOriginTime() + " and M=" + (float)this.mag);
            rupture.setMag(this.mag);
            ArrayList<RuptureSurface> rupSurfs = new ArrayList<RuptureSurface>();
            ArrayList<Double> rakes = new ArrayList<Double>();
            ArrayList<Double> areas = new ArrayList<Double>();
            double gridSpacing = 1.0;
            for (int sectIndex : this.subSects) {
                Preconditions.checkState((sectIndex >= 0 && sectIndex < rupSet.getNumSections() ? 1 : 0) != 0, (String)"Bad subsection index. %s is outside of bounts [0, %s]", (int)sectIndex, (int)(rupSet.getNumSections() - 1));
                FaultSection fltData = rupSet.getFaultSectionData(sectIndex);
                rakes.add(fltData.getAveRake());
                areas.add(fltData.getReducedDownDipWidth() * fltData.getTraceLength());
                rupSurfs.add(fltData.getFaultSurface(gridSpacing, false, true));
            }
            if (rupSurfs.size() == 1) {
                rupture.setAveRake((Double)rakes.get(0));
                rupture.setRuptureSurface((RuptureSurface)rupSurfs.get(0));
            } else {
                rupture.setAveRake(FaultUtils.getInRakeRange(FaultUtils.getScaledAngleAverage(areas, rakes)));
                rupture.setRuptureSurface(new CompoundSurface(rupSurfs));
            }
        }

        @Override
        public int[] getSectionsRuptured(FaultSystemRupSet rupSet) {
            return this.subSects;
        }

        @Override
        public Double getMag(FaultSystemRupSet rupSet) {
            return this.mag;
        }
    }

    public static class FSS
    extends TriggerRupture {
        final int fssIndex;
        final Double overrideMag;

        public FSS(int fssIndex) {
            this(fssIndex, null, null);
        }

        public FSS(int fssIndex, Long customOccurrenceTime, Double overrideMag) {
            super(customOccurrenceTime);
            this.fssIndex = fssIndex;
            this.overrideMag = overrideMag;
        }

        @Override
        public void populateRupture(FaultSystemRupSet rupSet, ETAS_EqkRupture rupture) {
            double origMag = rupSet.getMagForRup(this.fssIndex);
            System.out.println("Building FSS rupture with index=" + this.fssIndex + ", OT=" + rupture.getOriginTime() + ", original M=" + (float)origMag);
            rupture.setAveRake(rupSet.getAveRakeForRup(this.fssIndex));
            rupture.setMag(origMag);
            rupture.setRuptureSurface(rupSet.getSurfaceForRupture(this.fssIndex, 1.0));
            rupture.setFSSIndex(this.fssIndex);
            if (this.overrideMag != null && this.overrideMag > 0.0) {
                System.out.println("\tOverriding magnitude with specified mag: " + this.overrideMag);
                rupture.setMag(this.overrideMag);
            }
        }

        @Override
        public int[] getSectionsRuptured(FaultSystemRupSet rupSet) {
            return Ints.toArray(rupSet.getSectionsIndicesForRup(this.fssIndex));
        }

        @Override
        public Double getMag(FaultSystemRupSet rupSet) {
            if (this.overrideMag != null && this.overrideMag > 0.0) {
                return this.overrideMag;
            }
            if (rupSet != null) {
                rupSet.getMagForRup(this.fssIndex);
            }
            return null;
        }
    }
}

