/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.erf.ETAS.launcher.util;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.opensha.commons.geo.Location;
import org.opensha.commons.util.FileNameUtils;
import scratch.UCERF3.enumTreeBranches.FaultModels;
import scratch.UCERF3.erf.ETAS.ETAS_Params.U3ETAS_ProbabilityModelOptions;
import scratch.UCERF3.erf.ETAS.analysis.ETAS_AbstractPlot;
import scratch.UCERF3.erf.ETAS.launcher.ETAS_Config;
import scratch.UCERF3.erf.ETAS.launcher.TriggerRupture;
import scratch.UCERF3.erf.ETAS.launcher.util.ETAS_ConfigBuilder;

public class ETAS_HardCodedConfigGenerator {
    public static final DateFormat df = new SimpleDateFormat("yyyy_MM_dd");

    public static void main(String[] args) throws IOException {
        File fssFile;
        File cacheDir;
        boolean mpj = true;
        ETAS_ConfigBuilder.HPC_Sites hpcSite = ETAS_ConfigBuilder.HPC_Sites.USC_CARC;
        FaultModels fm = FaultModels.FM3_1;
        boolean u2 = false;
        Integer startYear = null;
        Long startTimeMillis = 1562261628000L;
        boolean histCatalog = false;
        boolean includeSpontaneous = false;
        int numSimulations = 100000;
        double duration = 10.0;
        Long randomSeed = 123456789L;
        Boolean reuseERFs = true;
        U3ETAS_ProbabilityModelOptions probModel = U3ETAS_ProbabilityModelOptions.FULL_TD;
        Double p = null;
        Double c = null;
        Double log10k = null;
        String nameAdd = null;
        TriggerRupture[] triggerRups = new TriggerRupture[]{new TriggerRupture.Point(new Location(35.705, -117.508, 8.7), null, 6.4)};
        String scenarioName = "Searles Valley M6.4";
        Object customCatalogName = null;
        int nodes = 36;
        int hours = 24;
        String queue = hpcSite == ETAS_ConfigBuilder.HPC_Sites.USC_CARC ? "scec_hiprio" : null;
        Integer nodeThreads = null;
        Integer threads = null;
        if (hpcSite == ETAS_ConfigBuilder.HPC_Sites.USC_CARC && threads != null && threads > 12) {
            throw new IllegalStateException("did you set the threads right?");
        }
        File mainOutputDir = new File("${ETAS_SIM_DIR}");
        File launcherDir = new File("${ETAS_LAUNCHER}");
        File inputsDir = new File(launcherDir, "inputs");
        switch (fm) {
            case FM3_1: {
                if (u2) {
                    cacheDir = new File(inputsDir, "cache_u2_mapped_fm3p1");
                    fssFile = new File(inputsDir, "ucerf2_mapped_fm3p1.zip");
                    break;
                }
                cacheDir = new File(inputsDir, "cache_fm3p1_ba");
                fssFile = new File(inputsDir, "2013_05_10-ucerf3p3-production-10runs_COMPOUND_SOL_FM3_1_SpatSeisU3_MEAN_BRANCH_AVG_SOL.zip");
                break;
            }
            case FM3_2: {
                Preconditions.checkState((!u2 ? 1 : 0) != 0);
                cacheDir = new File(inputsDir, "cache_fm3p2_ba");
                fssFile = new File(inputsDir, "2013_05_10-ucerf3p3-production-10runs_COMPOUND_SOL_FM3_2_SpatSeisU3_MEAN_BRANCH_AVG_SOL.zip");
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        File triggerCatalog = null;
        File triggerCatalogSurfaceMappings = null;
        Preconditions.checkState((customCatalogName == null || !histCatalog ? 1 : 0) != 0, (Object)"Can't have both custom catalog and historical catalog");
        if (histCatalog) {
            triggerCatalog = new File(inputsDir, "u3_historical_catalog.txt");
            triggerCatalogSurfaceMappings = new File(inputsDir, "u3_historical_catalog_finite_fault_mappings.xml");
        }
        String dateStr = df.format(new Date());
        Preconditions.checkNotNull((Object)scenarioName);
        Object scenarioFileName = FileNameUtils.simplify(scenarioName.replaceAll(" ", "-"));
        if (u2) {
            scenarioFileName = fm == FaultModels.FM2_1 ? (String)scenarioFileName + "-u2" : (String)scenarioFileName + "-u2mapped";
        }
        scenarioFileName = includeSpontaneous ? (String)scenarioFileName + "-includeSpont" : (String)scenarioFileName + "-noSpont";
        if (histCatalog) {
            scenarioFileName = (String)scenarioFileName + "-historicalCatalog";
        }
        scenarioFileName = (String)scenarioFileName + "-" + probModel.name().toLowerCase();
        scenarioFileName = (String)scenarioFileName + "-" + ETAS_AbstractPlot.getTimeShortLabel(duration).replaceAll(" ", "");
        if (nameAdd != null && !nameAdd.isEmpty()) {
            scenarioFileName = (String)scenarioFileName + "-" + nameAdd;
        }
        String jobName = dateStr + "-" + (String)scenarioFileName;
        System.out.println("Job dir name: " + jobName);
        File outputDir = new File(mainOutputDir, jobName);
        File localOutputDir = ETAS_Config.resolvePath(outputDir.getPath());
        Preconditions.checkState((localOutputDir.exists() || localOutputDir.mkdir() ? 1 : 0) != 0);
        ETAS_Config config = new ETAS_Config(numSimulations, duration, includeSpontaneous, cacheDir, fssFile, outputDir, triggerCatalog, triggerCatalogSurfaceMappings, triggerRups);
        config.setReuseERFs(reuseERFs);
        config.setSimulationName(scenarioName);
        config.setRandomSeed(randomSeed);
        config.setProbModel(probModel);
        Preconditions.checkState((startYear == null || startTimeMillis == null ? 1 : 0) != 0, (Object)"cannot supply both startYear and startTimeMillis");
        Preconditions.checkState((startYear != null || startTimeMillis != null ? 1 : 0) != 0, (Object)"must supply either startYear and startTimeMillis");
        if (startYear != null) {
            config.setStartYear(startYear);
        } else {
            config.setStartTimeMillis(startTimeMillis);
        }
        if (p != null) {
            config.setETAS_P(p);
        }
        if (c != null) {
            config.setETAS_C(c);
        }
        if (log10k != null) {
            config.setETAS_Log10_K(log10k);
        }
        File configFile = new File(outputDir, "config.json");
        File localConfFile = new File(localOutputDir, "config.json");
        config.writeJSON(localConfFile);
        if (mpj) {
            File slurmScriptFile = new File(localOutputDir, "etas_sim_mpj.slurm");
            File template = hpcSite.getSlurmFile();
            ETAS_ConfigBuilder.updateSlurmScript(template, slurmScriptFile, (Integer)nodes, nodeThreads, threads, (Integer)hours, queue, configFile);
        }
    }
}

