/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.erf.UCERF2_Mapped;

import java.util.ArrayList;
import org.opensha.commons.data.region.CaliforniaRegions;
import org.opensha.commons.geo.Location;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.sha.earthquake.ProbEqkRupture;
import org.opensha.sha.earthquake.ProbEqkSource;
import scratch.UCERF3.enumTreeBranches.FaultModels;
import scratch.UCERF3.erf.ETAS.ETAS_EqkRupture;
import scratch.UCERF3.erf.FaultSystemSolutionERF;
import scratch.UCERF3.inversion.UCERF2_ComparisonSolutionFetcher;
import scratch.UCERF3.utils.ModUCERF2.NSHMP_GridSourceGeneratorMod2;

public class UCERF2_FM2pt1_FaultSysSolTimeDepERF
extends FaultSystemSolutionERF {
    NSHMP_GridSourceGeneratorMod2 nshmp_gridSrcGen;

    public UCERF2_FM2pt1_FaultSysSolTimeDepERF() {
        super(UCERF2_ComparisonSolutionFetcher.getUCERF2Solution(FaultModels.FM2_1));
        this.nshmp_gridSrcGen = new NSHMP_GridSourceGeneratorMod2(this.bgSettings.distanceCorrections);
        this.nshmp_gridSrcGen.setAsPointSources(true);
        this.numOtherSources = this.nshmp_gridSrcGen.getNumSources();
    }

    @Override
    public void parameterChange(ParameterChangeEvent event) {
        super.parameterChange(event);
        if (event.getParameter() == this.bgSettingsParam) {
            this.nshmp_gridSrcGen.setDistanceCorrections(this.bgSettings.distanceCorrections);
        }
    }

    @Override
    protected ProbEqkSource getOtherSource(int iSource) {
        return this.nshmp_gridSrcGen.getRandomStrikeGriddedSource(iSource, this.timeSpan.getDuration());
    }

    public static void main(String[] args) {
        UCERF2_FM2pt1_FaultSysSolTimeDepERF erf = new UCERF2_FM2pt1_FaultSysSolTimeDepERF();
        erf.aleatoryMagAreaStdDevParam.setValue(0.0);
        erf.getParameter("BPT Aperiodicity").setValue(0.2);
        erf.getTimeSpan().setStartTimeInMillis(0L);
        erf.getTimeSpan().setDuration(1.0);
        long runtime = System.currentTimeMillis();
        CaliforniaRegions.RELM_GRIDDED griddedRegion = new CaliforniaRegions.RELM_GRIDDED();
        erf.updateForecast();
        int nthRup = erf.getIndexN_ForSrcAndRupIndices(4755, 0);
        ProbEqkRupture landers = erf.getSource(4755).getRupture(0);
        ETAS_EqkRupture landersObs = new ETAS_EqkRupture();
        landersObs.setAveRake(landers.getAveRake());
        landersObs.setMag(landers.getMag());
        Location ptSurf = new Location(34.4, -113.19, 13.0);
        landersObs.setMag(7.0);
        landersObs.setPointSurface(ptSurf);
        System.out.println("main shock: s=4755, r=0, nthRup=" + nthRup + "mag=" + landersObs.getMag() + "; src name: " + erf.getSource(4755).getName());
        ArrayList<ETAS_EqkRupture> obsEqkRuptureList = new ArrayList<ETAS_EqkRupture>();
        obsEqkRuptureList.add(landersObs);
        boolean includeSpontEvents = false;
        boolean includeIndirectTriggering = false;
        boolean includeEqkRates = false;
        System.out.println("simulation took " + (double)(runtime -= System.currentTimeMillis()) / 60000.0 + " minutes");
    }
}

