/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.erf;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.zip.ZipException;
import javax.swing.JOptionPane;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.impl.EnumParameter;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.earthquake.param.BPTAveragingTypeOptions;
import org.opensha.sha.earthquake.param.IncludeBackgroundOption;
import org.opensha.sha.earthquake.param.MagDependentAperiodicityOptions;
import org.opensha.sha.earthquake.param.ProbabilityModelOptions;
import scratch.UCERF3.U3CompoundFaultSystemSolution;
import scratch.UCERF3.U3FaultSystemSolutionFetcher;
import scratch.UCERF3.enumTreeBranches.DeformationModels;
import scratch.UCERF3.enumTreeBranches.FaultModels;
import scratch.UCERF3.enumTreeBranches.InversionModels;
import scratch.UCERF3.enumTreeBranches.MaxMagOffFault;
import scratch.UCERF3.enumTreeBranches.MomentRateFixes;
import scratch.UCERF3.enumTreeBranches.ScalingRelationships;
import scratch.UCERF3.enumTreeBranches.SlipAlongRuptureModels;
import scratch.UCERF3.enumTreeBranches.SpatialSeisPDF;
import scratch.UCERF3.enumTreeBranches.TotalMag5Rate;
import scratch.UCERF3.erf.FaultSystemSolutionERF;
import scratch.UCERF3.erf.mean.MeanUCERF3;
import scratch.UCERF3.inversion.InversionFaultSystemSolution;
import scratch.UCERF3.logicTree.U3LogicTreeBranch;
import scratch.UCERF3.logicTree.U3LogicTreeBranchNode;
import scratch.UCERF3.utils.UCERF3_Downloader;

public class UCERF3_CompoundSol_ERF
extends FaultSystemSolutionERF {
    private static final long serialVersionUID = 1L;
    private static final boolean D = false;
    public static final String NAME = "UCERF3 Single Branch ERF";
    private Map<Class<? extends U3LogicTreeBranchNode<?>>, EnumParameter<?>> enumParamsMap;
    private U3FaultSystemSolutionFetcher fetch;
    private boolean solutionStale = true;
    private static final String COMPOUND_FILE_NAME = "full_ucerf3_compound_sol.zip";
    private CompletableFuture<U3FaultSystemSolutionFetcher> fetchFuture;

    private static CompletableFuture<U3FaultSystemSolutionFetcher> loadFetcher() throws ZipException, IOException {
        File storeDir = UCERF3_Downloader.getStoreDir();
        return MeanUCERF3.checkDownload(new File(storeDir, COMPOUND_FILE_NAME)).thenApply(compoundFile -> {
            if (compoundFile == null || !compoundFile.exists()) {
                JOptionPane.showMessageDialog(null, "Failed to download full_ucerf3_compound_sol.zip. Verify internet connection and restart. Server may be down.", "UCERF3_CompoundSol_ERF", 0);
                return null;
            }
            try {
                return U3CompoundFaultSystemSolution.fromZipFile(compoundFile);
            }
            catch (IOException e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(null, e.getMessage(), "UCERF3_CompoundSol_ERF", 0);
                return null;
            }
        });
    }

    public UCERF3_CompoundSol_ERF() throws ZipException, IOException {
        this(UCERF3_CompoundSol_ERF.loadFetcher(), null);
    }

    public UCERF3_CompoundSol_ERF(CompletableFuture<U3FaultSystemSolutionFetcher> fetchFuture, U3LogicTreeBranch initial) {
        this.fetchFuture = fetchFuture;
        fetchFuture.thenAccept(fetch -> {
            this.enumParamsMap = Maps.newHashMap();
            Preconditions.checkState((initial == null || initial.isFullySpecified() ? 1 : 0) != 0, (Object)"Initial branch must be null or fully specified");
            if (fetch != null && !fetch.getBranches().isEmpty()) {
                Collection<U3LogicTreeBranch> branches = fetch.getBranches();
                List<Class<U3LogicTreeBranchNode<?>>> logicTreeNodeClasses = U3LogicTreeBranch.getLogicTreeNodeClasses();
                for (int i = 0; i < logicTreeNodeClasses.size(); ++i) {
                    Class<? extends U3LogicTreeBranchNode<?>> clazz = logicTreeNodeClasses.get(i);
                    EnumParameter param = UCERF3_CompoundSol_ERF.buildParam(clazz, branches, initial);
                    param.addParameterChangeListener(this);
                    this.enumParamsMap.put(clazz, param);
                }
            }
            this.createParamList();
        });
    }

    @Override
    protected void createParamList() {
        super.createParamList();
        if (this.enumParamsMap == null) {
            return;
        }
        List<Class<U3LogicTreeBranchNode<?>>> logicTreeNodeClasses = U3LogicTreeBranch.getLogicTreeNodeClasses();
        for (int i = 0; i < logicTreeNodeClasses.size(); ++i) {
            Class<? extends U3LogicTreeBranchNode<?>> clazz = logicTreeNodeClasses.get(i);
            EnumParameter<?> param = this.enumParamsMap.get(clazz);
            if (param == null) continue;
            this.adjustableParams.addParameter(i, param);
        }
        if (this.adjustableParams.containsParameter("Solution Input File")) {
            this.adjustableParams.removeParameter(this.fileParam);
        }
    }

    public void setLogicTreeBranch(U3LogicTreeBranch branch) {
        this.fetchFuture.thenAccept(fetch -> {
            Preconditions.checkArgument((boolean)branch.isFullySpecified(), (Object)"Branch must be fully specified");
            Preconditions.checkArgument((boolean)fetch.getBranches().contains(branch), (Object)"Branch not present in compound solution");
            for (U3LogicTreeBranchNode node : branch) {
                this.setParameter(node.getBranchLevelName(), node);
            }
        });
    }

    private static EnumParameter buildParam(Class<? extends U3LogicTreeBranchNode<?>> clazz, Collection<U3LogicTreeBranch> branches, U3LogicTreeBranch initial) {
        HashSet<Enum> set = new HashSet<Enum>();
        Enum defaultValue = initial != null ? (Enum)initial.getValueUnchecked(clazz) : null;
        String name = null;
        for (U3LogicTreeBranch branch : branches) {
            Preconditions.checkState((boolean)branch.isFullySpecified());
            U3LogicTreeBranchNode val = (U3LogicTreeBranchNode)branch.getValueUnchecked(clazz);
            Preconditions.checkNotNull((Object)val);
            set.add((Enum)((Object)val));
            if (defaultValue == null) {
                defaultValue = (Enum)((Object)val);
            }
            if (name != null) continue;
            name = val.getBranchLevelName();
        }
        EnumSet choices = EnumSet.copyOf(set);
        return new EnumParameter<Enum>(name, choices, defaultValue, null);
    }

    @Override
    public void updateForecast() {
        System.out.println("updateForecast called");
        if (this.solutionStale) {
            this.fetchSolution();
        }
        this.fetchFuture.join();
        super.updateForecast();
    }

    private void fetchSolution() {
        this.fetchFuture.thenAccept(fetch -> {
            if (fetch == null) {
                return;
            }
            ArrayList vals = Lists.newArrayList();
            for (EnumParameter<?> param : this.enumParamsMap.values()) {
                vals.add((U3LogicTreeBranchNode)param.getValue());
            }
            U3LogicTreeBranch branch = U3LogicTreeBranch.fromValues(vals);
            Preconditions.checkState((boolean)branch.isFullySpecified(), (Object)"Somehow branch from enums isn't fully specified");
            InversionFaultSystemSolution sol = fetch.getSolution(branch);
            this.setSolution(sol);
            this.solutionStale = false;
        });
    }

    @Override
    public void parameterChange(ParameterChangeEvent event) {
        if (this.enumParamsMap != null && this.enumParamsMap.values().contains(event.getParameter())) {
            this.solutionStale = true;
        } else {
            super.parameterChange(event);
        }
    }

    public static void main(String[] args) {
        UCERF3_CompoundSol_ERF erf;
        try {
            erf = new UCERF3_CompoundSol_ERF();
        }
        catch (Exception e) {
            throw ExceptionUtils.asRuntimeException(e);
        }
        U3LogicTreeBranch branch = U3LogicTreeBranch.fromValues(FaultModels.FM3_1, DeformationModels.ZENGBB, ScalingRelationships.SHAW_2009_MOD, SlipAlongRuptureModels.UNIFORM, InversionModels.CHAR_CONSTRAINED, TotalMag5Rate.RATE_7p9, MaxMagOffFault.MAG_7p9, MomentRateFixes.NONE, SpatialSeisPDF.UCERF2);
        erf.setLogicTreeBranch(branch);
        erf.setParameter("Probability Model", (Object)ProbabilityModelOptions.U3_BPT);
        erf.setParameter("Background Seismicity", (Object)IncludeBackgroundOption.EXCLUDE);
        erf.setParameter("Historic Open Interval", 139.0);
        MagDependentAperiodicityOptions[] testCOVs = new MagDependentAperiodicityOptions[]{MagDependentAperiodicityOptions.LOW_VALUES, MagDependentAperiodicityOptions.MID_VALUES, MagDependentAperiodicityOptions.HIGH_VALUES};
        for (BPTAveragingTypeOptions aveType : BPTAveragingTypeOptions.values()) {
            erf.setParameter("BPT Averaging Type", (Object)aveType);
            for (MagDependentAperiodicityOptions cov : testCOVs) {
                erf.setParameter("Aperiodicity", (Object)cov);
                erf.updateForecast();
                System.out.println("Testing " + aveType.name() + ", " + cov.name() + ", " + String.valueOf(((InversionFaultSystemSolution)erf.getSolution()).getLogicTreeBranch()));
                for (int sourceID = 0; sourceID < erf.getNumSources(); ++sourceID) {
                    ProbEqkSource source = erf.getSource(sourceID);
                    for (int rupID = 0; rupID < source.getNumRuptures(); ++rupID) {
                        Preconditions.checkState((!Double.isNaN(source.getRupture(rupID).getProbability()) ? 1 : 0) != 0, (Object)("Source " + sourceID + ", Rup " + rupID + " is NaN"));
                    }
                }
            }
        }
    }
}

