/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.erf.mean;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.primitives.Ints;
import java.awt.geom.Point2D;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.apache.commons.math3.stat.StatUtils;
import org.dom4j.DocumentException;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.geo.GriddedRegion;
import org.opensha.commons.util.DataUtils;
import org.opensha.commons.util.FaultUtils;
import org.opensha.commons.util.FileUtils;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.modules.GridSourceProvider;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import scratch.UCERF3.U3CompoundFaultSystemSolution;
import scratch.UCERF3.U3FaultSystemRupSet;
import scratch.UCERF3.U3FaultSystemSolution;
import scratch.UCERF3.enumTreeBranches.DeformationModels;
import scratch.UCERF3.enumTreeBranches.FaultModels;
import scratch.UCERF3.enumTreeBranches.ScalingRelationships;
import scratch.UCERF3.griddedSeismicity.GridSourceFileReader;
import scratch.UCERF3.inversion.InversionFaultSystemRupSet;
import scratch.UCERF3.logicTree.U3APrioriBranchWeightProvider;
import scratch.UCERF3.logicTree.U3LogicTreeBranch;
import scratch.UCERF3.logicTree.U3LogicTreeBranchNode;
import scratch.UCERF3.utils.MatrixIO;
import scratch.UCERF3.utils.U3FaultSystemIO;

public class TrueMeanBuilder {
    public static void main(String[] args) throws ZipException, IOException, DocumentException {
        List<? extends FaultSection> fsd;
        Object rates;
        File invDir = new File("/home/kevin/workspace/opensha-ucerf3/src/scratch/UCERF3/data/scratch/InversionSolutions");
        File outputDir = new File("/tmp/true_mean");
        File compoundFile = new File(invDir, "2013_05_10-ucerf3p3-production-10runs_COMPOUND_SOL.zip");
        U3CompoundFaultSystemSolution cfss = U3CompoundFaultSystemSolution.fromZipFile(compoundFile);
        cfss.setCacheCopying(false);
        U3APrioriBranchWeightProvider weightProvider = new U3APrioriBranchWeightProvider();
        FaultModels[] fms = new FaultModels[]{FaultModels.FM3_1, FaultModels.FM3_2};
        String nameAdd = "";
        HashSet<FaultModels> fmSet = new HashSet<FaultModels>();
        for (FaultModels fm : fms) {
            fmSet.add(fm);
        }
        ArrayList branches = Lists.newArrayList(cfss.getBranches());
        int i = branches.size();
        while (--i >= 0) {
            FaultModels fm;
            U3LogicTreeBranch branch = (U3LogicTreeBranch)branches.get(i);
            fm = branch.getValue(FaultModels.class);
            if (fmSet.contains(fm)) continue;
            branches.remove(i);
        }
        Collections.shuffle(branches);
        System.out.println("Generating global IDs");
        HashMap fmGlobalRupIDsMaps = Maps.newHashMap();
        HashBasedTable globalToRupSetIDTable = HashBasedTable.create();
        HashMap rupSectNamesToGlobalIDMap = Maps.newHashMap();
        HashMap fmRupCountMap = Maps.newHashMap();
        int globalRupCount = 0;
        HashMap fmGlobalSectIDsMaps = Maps.newHashMap();
        HashMap sectNamesToGlobalIDMap = Maps.newHashMap();
        HashMap subSectIndexesMap = Maps.newHashMap();
        int globalSectCount = 0;
        for (FaultModels fm : fms) {
            Object rupSet = null;
            for (U3LogicTreeBranch branch : branches) {
                if (branch.getValue(FaultModels.class) != fm) continue;
                rupSet = cfss.getSolution(branch).getRupSet();
                break;
            }
            fmRupCountMap.put(fm, ((FaultSystemRupSet)rupSet).getNumRuptures());
            HashMap globalRupIDsMap = Maps.newHashMap();
            fmGlobalRupIDsMaps.put(fm, globalRupIDsMap);
            for (int r = 0; r < ((FaultSystemRupSet)rupSet).getNumRuptures(); ++r) {
                HashSet<String> sectNames = new HashSet<String>();
                for (FaultSection sect : ((FaultSystemRupSet)rupSet).getFaultSectionDataForRupture(r)) {
                    sectNames.add(sect.getSectionName());
                }
                Integer globalID = (Integer)rupSectNamesToGlobalIDMap.get(sectNames);
                if (globalID == null) {
                    globalID = globalRupCount++;
                    rupSectNamesToGlobalIDMap.put(sectNames, globalID);
                }
                globalToRupSetIDTable.put((Object)globalID, (Object)fm, (Object)r);
                globalRupIDsMap.put(r, globalID);
            }
            System.out.println(fm.getShortName() + ": globalRupCount=" + globalRupCount);
            List<List<Integer>> subSectIndexes = ((FaultSystemRupSet)rupSet).getSectionIndicesForAllRups();
            subSectIndexesMap.put(fm, subSectIndexes);
            HashMap globalSectIDsMap = Maps.newHashMap();
            fmGlobalSectIDsMaps.put(fm, globalSectIDsMap);
            for (int s = 0; s < ((FaultSystemRupSet)rupSet).getNumSections(); ++s) {
                String sectName = ((FaultSystemRupSet)rupSet).getFaultSectionData(s).getSectionName();
                Integer globalID = (Integer)sectNamesToGlobalIDMap.get(sectName);
                if (globalID == null) {
                    globalID = globalSectCount++;
                    sectNamesToGlobalIDMap.put(sectName, globalID);
                }
                globalSectIDsMap.put(s, globalID);
            }
            System.out.println(fm.getShortName() + ": globalSectCount=" + globalSectCount);
        }
        ArrayList uniqueRupturesList = Lists.newArrayList();
        for (int i2 = 0; i2 < globalRupCount; ++i2) {
            uniqueRupturesList.add(new HashMap());
        }
        ArrayList uniqueSectionsList = Lists.newArrayList();
        for (int i3 = 0; i3 < globalSectCount; ++i3) {
            uniqueSectionsList.add(new HashMap());
        }
        double totWeight = 0.0;
        for (U3LogicTreeBranch branch : branches) {
            totWeight += weightProvider.getWeight(branch);
        }
        int branchCnt = 0;
        int uniqueRupCount = 0;
        int origNumRups = 0;
        int uniqueSectCount = 0;
        int origNumSects = 0;
        int rupSetCount = 0;
        int lastChangedBranch = 0;
        double origTotalRate = 0.0;
        double mfdMin = 5.0;
        double mfdDelta = 0.01;
        int mfdNum = 500;
        IncrementalMagFreqDist origAvgMFD = new IncrementalMagFreqDist(mfdMin, mfdNum, mfdDelta);
        origAvgMFD.setTolerance(mfdDelta);
        HashMap minMagArrays = Maps.newHashMap();
        for (U3LogicTreeBranch branch : branches) {
            FaultModels fm = branch.getValue(FaultModels.class);
            Map globalRupIDsMap = (Map)fmGlobalRupIDsMaps.get(fm);
            Map globalSectIDsMap = (Map)fmGlobalSectIDsMaps.get(fm);
            double[] mags = cfss.getMags(branch);
            rates = cfss.getRates(branch);
            double[] areas = cfss.loadDoubleArray(branch, "rup_areas.bin");
            double[] rakes = cfss.loadDoubleArray(branch, "rakes.bin");
            origNumRups += mags.length;
            origNumSects += ((Map)fmGlobalSectIDsMaps.get(fm)).size();
            double scaledWt = weightProvider.getWeight(branch) / totWeight;
            fsd = null;
            InversionFaultSystemRupSet rupSet = null;
            U3LogicTreeBranch fmDmScaleBranch = (U3LogicTreeBranch)branch.clone();
            for (int i4 = 0; i4 < branch.size(); ++i4) {
                U3LogicTreeBranchNode val = (U3LogicTreeBranchNode)branch.getValue(i4);
                if (val instanceof FaultModels || val instanceof DeformationModels || val instanceof ScalingRelationships) continue;
                fmDmScaleBranch.clearValue(i4);
            }
            boolean[] belowMinMag = (boolean[])minMagArrays.get(fmDmScaleBranch);
            if (belowMinMag == null) {
                rupSet = cfss.getSolution(branch).getRupSet();
                fsd = rupSet.getFaultSectionDataList();
                ++rupSetCount;
                belowMinMag = rupSet.getRuptureBelowSectMinMagArray();
                minMagArrays.put(fmDmScaleBranch, belowMinMag);
            }
            boolean print = false;
            for (int r = 0; r < mags.length; ++r) {
                double mag;
                int index;
                if (belowMinMag[r]) continue;
                int globalRupID = (Integer)globalRupIDsMap.get(r);
                HashMap rupRates = (HashMap)uniqueRupturesList.get(globalRupID);
                UniqueRupture rup = new UniqueRupture(globalRupID, rakes[r], areas[r]);
                reference var59_91 = rates[r] * scaledWt;
                UniqueRupture matchedRup = (UniqueRupture)rupRates.get(rup);
                if (matchedRup == null) {
                    int numSinceChanged = branchCnt - lastChangedBranch;
                    if (numSinceChanged > 150 || numSinceChanged > 10 && uniqueRupCount == 1634466 || fms.length == 1 && numSinceChanged > 10 && uniqueRupCount == 930563 || fms.length == 1 && numSinceChanged > 10 && uniqueRupCount == 1128358) continue;
                    List subSectIndexes = (List)((List)subSectIndexesMap.get(fm)).get(r);
                    if (rupSet == null) {
                        rupSet = cfss.getSolution(branch).getRupSet();
                        fsd = rupSet.getFaultSectionDataList();
                        ++rupSetCount;
                    }
                    ArrayList rupSects = Lists.newArrayList();
                    Iterator iterator = subSectIndexes.iterator();
                    while (iterator.hasNext()) {
                        int ind = (Integer)iterator.next();
                        int globalSectID = (Integer)globalSectIDsMap.get(ind);
                        FaultSection sectFSD = fsd.get(ind);
                        UniqueSection sect = new UniqueSection(sectFSD, globalSectID);
                        UniqueSection matchedSect = (UniqueSection)((HashMap)uniqueSectionsList.get(globalSectID)).get(sect);
                        if (matchedSect == null) {
                            matchedSect = sect;
                            ((HashMap)uniqueSectionsList.get(globalSectID)).put(sect, sect);
                            ++uniqueSectCount;
                        }
                        matchedSect.addBranch(branch, sectFSD);
                        rupSects.add(matchedSect);
                    }
                    rup.sects = rupSects;
                    if (uniqueRupCount % 100000 == 0) {
                        print = true;
                    }
                    ++uniqueRupCount;
                    lastChangedBranch = branchCnt;
                    rupRates.put(rup, rup);
                    matchedRup = rup;
                }
                if ((index = matchedRup.rupMFD.getXIndex(mag = mags[r])) >= 0) {
                    matchedRup.rupMFD.set(index, matchedRup.rupMFD.getY(index) + var59_91);
                } else {
                    matchedRup.rupMFD.set(mag, (double)var59_91);
                }
                matchedRup.branchesWithRup.add(branch);
                ++matchedRup.cnt;
                origTotalRate += scaledWt * rates[r];
                origAvgMFD.add(mags[r], (double)(rates[r] * scaledWt));
            }
            if (!(print = print || ++branchCnt % 10 == 0)) continue;
            System.out.println("unique rup count: " + uniqueRupCount + "; unique sect count: " + uniqueSectCount + "; branch count: " + branchCnt + "; loaded rupSet count: " + rupSetCount);
        }
        double keptPercent = 100.0 * (double)uniqueRupCount / (double)origNumRups;
        System.out.println("Ruptures kept: " + uniqueRupCount + "/" + origNumRups + " (" + (float)keptPercent + " %)");
        keptPercent = 100.0 * (double)uniqueSectCount / (double)origNumSects;
        System.out.println("Sections kept: " + uniqueSectCount + "/" + origNumSects + " (" + (float)keptPercent + " %)");
        double[] uniquesPerRup = new double[uniqueRupturesList.size()];
        for (int r = 0; r < uniqueRupturesList.size(); ++r) {
            uniquesPerRup[r] = ((HashMap)uniqueRupturesList.get(r)).size();
        }
        Arrays.sort(uniquesPerRup);
        System.out.println("uniques per rup:\tmin=" + uniquesPerRup[0] + "\tmax=" + uniquesPerRup[uniquesPerRup.length - 1] + "\tmean=" + StatUtils.mean((double[])uniquesPerRup) + "\tmedian=" + DataUtils.median_sorted(uniquesPerRup));
        int fsdIndex = 0;
        ArrayList faultSectionData = Lists.newArrayList();
        HashMap uniqueSectIndexMap = Maps.newHashMap();
        rates = uniqueSectionsList.iterator();
        while (rates.hasNext()) {
            Map uniqueSects = (Map)rates.next();
            int indexInSect = 0;
            for (UniqueSection sect : uniqueSects.keySet()) {
                fsd = sect.sect;
                fsd.setSectionId(fsdIndex);
                fsd.setSectionName(fsd.getSectionName() + " (instance " + indexInSect++ + ")");
                ArrayList<Double> myRakes = new ArrayList<Double>();
                ArrayList<Double> myWeights = new ArrayList<Double>();
                for (U3LogicTreeBranch branch : sect.branchSects.keySet()) {
                    myRakes.add(sect.branchSects.get(branch).getAveRake());
                    myWeights.add(weightProvider.getWeight(branch));
                }
                double avgRake = FaultUtils.getInRakeRange(FaultUtils.getScaledAngleAverage(myWeights, myRakes));
                fsd.setAveRake(avgRake);
                fsd.setAveSlipRate(Double.NaN);
                faultSectionData.add(fsd);
                uniqueSectIndexMap.put(sect, fsdIndex);
                ++fsdIndex;
            }
        }
        ArrayList sectionForRups = Lists.newArrayList();
        double[] mags = new double[uniqueRupCount];
        double[] rakes = new double[uniqueRupCount];
        double[] rupAreas = new double[uniqueRupCount];
        double[] rates2 = new double[uniqueRupCount];
        DiscretizedFunc[] mfds = new DiscretizedFunc[uniqueRupCount];
        IncrementalMagFreqDist newMFD = new IncrementalMagFreqDist(mfdMin, mfdNum, mfdDelta);
        newMFD.setTolerance(mfdDelta);
        HashMap branchIDsMap = Maps.newHashMap();
        int rupIndex = 0;
        for (Map uniqueRups : uniqueRupturesList) {
            for (UniqueRupture rup : uniqueRups.keySet()) {
                ArrayList sects = Lists.newArrayList();
                for (UniqueSection sect : rup.sects) {
                    sects.add((Integer)uniqueSectIndexMap.get(sect));
                }
                rakes[rupIndex] = rup.rake;
                rupAreas[rupIndex] = rup.area;
                sectionForRups.add(sects);
                DiscretizedFunc discretizedFunc = rup.rupMFD;
                double totRate = 0.0;
                double runningMag = 0.0;
                for (Point2D pt : discretizedFunc) {
                    totRate += pt.getY();
                    runningMag += pt.getX() * pt.getY();
                    newMFD.add(pt.getX(), pt.getY());
                }
                rates2[rupIndex] = totRate;
                mags[rupIndex] = runningMag / totRate;
                mfds[rupIndex] = discretizedFunc;
                for (U3LogicTreeBranch branch : rup.branchesWithRup) {
                    int[] ids = (int[])branchIDsMap.get(branch);
                    if (ids == null) {
                        ids = new int[((Integer)fmRupCountMap.get(branch.getValue(FaultModels.class))).intValue()];
                        for (int i5 = 0; i5 < ids.length; ++i5) {
                            ids[i5] = -1;
                        }
                        branchIDsMap.put(branch, ids);
                    }
                    int rupSetIndex = (Integer)globalToRupSetIDTable.get((Object)rup.id, (Object)branch.getValue(FaultModels.class));
                    ids[rupSetIndex] = rupIndex;
                }
                ++rupIndex;
            }
        }
        double newTotRate = StatUtils.sum((double[])rates2);
        TrueMeanBuilder.checkEqual(origTotalRate, newTotRate, "Rates");
        for (int i6 = 0; i6 < mfdNum; ++i6) {
            TrueMeanBuilder.checkEqual(origAvgMFD.getY(i6), newMFD.getY(i6), "MFD pt " + i6 + ", mag=" + origAvgMFD.getX(i6));
        }
        newTotRate = 0.0;
        for (DiscretizedFunc discretizedFunc : mfds) {
            for (Point2D pt : discretizedFunc) {
                newTotRate += pt.getY();
            }
        }
        TrueMeanBuilder.checkEqual(origTotalRate, newTotRate, "MFD Rates");
        String info = "UCERF3 Mean Solution";
        U3FaultSystemRupSet rupSet = new U3FaultSystemRupSet(faultSectionData, null, null, null, sectionForRups, mags, rakes, rupAreas, null, info);
        U3FaultSystemSolution sol = new U3FaultSystemSolution(rupSet, rates2);
        HashMap hashMap = Maps.newHashMap();
        hashMap.put(FaultModels.FM3_1, new File(invDir, "2013_05_10-ucerf3p3-production-10runs_COMPOUND_SOL_FM3_1_MEAN_BRANCH_AVG_SOL.zip"));
        hashMap.put(FaultModels.FM3_2, new File(invDir, "2013_05_10-ucerf3p3-production-10runs_COMPOUND_SOL_FM3_2_MEAN_BRANCH_AVG_SOL.zip"));
        sol.setGridSourceProvider(TrueMeanBuilder.buildAvgGridSources(hashMap, fms));
        sol.setRupMagDists(mfds);
        String outputFilePrefix = compoundFile.getName().replaceAll(".zip", "") + nameAdd + "_TRUE_HAZARD_MEAN_SOL";
        File outputFile = new File(outputDir, outputFilePrefix + ".zip");
        U3FaultSystemIO.writeSol(sol, outputFile);
        File tempDir = FileUtils.createTempDir();
        FileUtils.unzipFile(outputFile, tempDir);
        ArrayList fileNames = Lists.newArrayList();
        for (File file : tempDir.listFiles()) {
            if (file.isDirectory()) continue;
            fileNames.add(file.getName());
        }
        branches = Lists.newArrayList(cfss.getBranches());
        Collections.sort(branches);
        File branchesFile = new File(tempDir, "branch_list.txt");
        FileWriter fw = new FileWriter(branchesFile);
        for (U3LogicTreeBranch branch : branches) {
            fw.write(branch.buildFileName() + "\n");
        }
        fw.close();
        fileNames.add(branchesFile.getName());
        ArrayList branchRupsMapping = Lists.newArrayList();
        double[] negCounts = new double[branches.size()];
        for (int i7 = 0; i7 < branches.size(); ++i7) {
            int[] ids;
            U3LogicTreeBranch branch = (U3LogicTreeBranch)branches.get(i7);
            for (int id : ids = (int[])branchIDsMap.get(branch)) {
                if (id >= 0) continue;
                int n = i7;
                negCounts[n] = negCounts[n] + 1.0;
            }
            if (Math.random() < 0.01) {
                System.out.println("Performing audit on: " + branch.buildFileName());
                InversionFaultSystemRupSet auditRupSet = cfss.getSolution(branch).getRupSet();
                for (int j = 0; j < ids.length; ++j) {
                    int id = ids[j];
                    if (id >= 0) continue;
                    if (!auditRupSet.isRuptureBelowSectMinMag(j)) {
                        U3LogicTreeBranch fmDmScaleBranch = (U3LogicTreeBranch)branch.clone();
                        for (int k = 0; k < branch.size(); ++k) {
                            U3LogicTreeBranchNode val = (U3LogicTreeBranchNode)branch.getValue(k);
                            if (val instanceof FaultModels || val instanceof DeformationModels || val instanceof ScalingRelationships) continue;
                            fmDmScaleBranch.clearValue(k);
                        }
                        boolean[] belowOrig = (boolean[])minMagArrays.get(fmDmScaleBranch);
                        boolean[] below = auditRupSet.getRuptureBelowSectMinMagArray();
                        int negs = 0;
                        int badNegs = 0;
                        int belowDiscreps = 0;
                        for (int k = 0; k < ids.length; ++k) {
                            if (ids[k] < 0) {
                                ++negs;
                                if (!below[k]) {
                                    ++badNegs;
                                }
                            }
                            if (below[k] == belowOrig[k]) continue;
                            ++belowDiscreps;
                        }
                        System.out.println("negs: " + negs);
                        System.out.println("badNegs: " + badNegs);
                        System.out.println("belowDiscreps: " + belowDiscreps);
                        System.out.flush();
                    }
                    Preconditions.checkState((boolean)auditRupSet.isRuptureBelowSectMinMag(j), (Object)("rup " + j + " mapping is -1, but not below min mag. mag=" + auditRupSet.getMagForRup(j)));
                }
            }
            branchRupsMapping.add(Ints.asList((int[])ids));
        }
        System.out.println("Neg index counts:");
        System.out.println("\tmin=" + StatUtils.min((double[])negCounts));
        System.out.println("\tmax=" + StatUtils.max((double[])negCounts));
        System.out.println("\tmean=" + StatUtils.mean((double[])negCounts));
        System.out.println("\tmeduan=" + DataUtils.median(negCounts));
        File branchIDsFile = new File(tempDir, "branch_ids.bin");
        MatrixIO.intListListToFile(branchRupsMapping, branchIDsFile);
        fileNames.add(branchIDsFile.getName());
        outputFile = new File(outputDir, outputFilePrefix + "_WITH_MAPPING.zip");
        FileUtils.createZipFile(outputFile.getAbsolutePath(), tempDir.getAbsolutePath(), fileNames);
        FileUtils.deleteRecursive(tempDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<U3LogicTreeBranch, List<Integer>> loadRuptureMappings(File fssFile) throws IOException {
        ArrayList branches = Lists.newArrayList();
        ZipFile zip = new ZipFile(fssFile);
        ZipEntry branchesEntry = zip.getEntry("branch_list.txt");
        Preconditions.checkNotNull((Object)branchesEntry, (Object)"Given file doesn't have branch list!");
        try (Scanner scanner = new Scanner(new BufferedInputStream(zip.getInputStream(branchesEntry)));){
            while (scanner.hasNextLine()) {
                branches.add(U3LogicTreeBranch.fromFileName(scanner.nextLine()));
            }
        }
        ZipEntry mappingEntry = zip.getEntry("branch_ids.bin");
        Preconditions.checkNotNull((Object)branchesEntry, (Object)"Given file doesn't have mappings!");
        List<List<Integer>> idsList = MatrixIO.intListListFromInputStream(zip.getInputStream(mappingEntry));
        zip.close();
        Preconditions.checkState((branches.size() == idsList.size() ? 1 : 0) != 0, (Object)"mappings lengths inconsistent!");
        HashMap mapping = Maps.newHashMap();
        for (int i = 0; i < branches.size(); ++i) {
            mapping.put((U3LogicTreeBranch)branches.get(i), idsList.get(i));
        }
        return mapping;
    }

    private static void checkEqual(double origVal, double newVal, String description) {
        double pDiff = DataUtils.getPercentDiff(newVal, origVal);
        Preconditions.checkState((pDiff < 1.0E-4 ? 1 : 0) != 0, (Object)(description + ": " + origVal + " != " + newVal + " (pDiff=" + pDiff + " %)"));
    }

    private static GridSourceFileReader buildAvgGridSources(Map<FaultModels, File> branchAvgFiles, FaultModels[] fms) throws IOException, DocumentException {
        ArrayList providers = Lists.newArrayList();
        for (FaultModels fm : fms) {
            providers.add(U3FaultSystemIO.loadSol(branchAvgFiles.get(fm)).getGridSourceProvider());
        }
        double weight = 1.0 / (double)providers.size();
        GriddedRegion region = null;
        HashMap nodeSubSeisMFDs = null;
        HashMap nodeUnassociatedMFDs = null;
        for (GridSourceProvider prov : providers) {
            if (region == null) {
                region = prov.getGriddedRegion();
                nodeSubSeisMFDs = Maps.newHashMap();
                nodeUnassociatedMFDs = Maps.newHashMap();
            } else {
                Preconditions.checkState((boolean)region.equals(prov.getGriddedRegion()));
            }
            for (int index = 0; index < region.getNodeCount(); ++index) {
                TrueMeanBuilder.addToMFD(nodeSubSeisMFDs, index, prov.getMFD_SubSeisOnFault(index), weight);
                TrueMeanBuilder.addToMFD(nodeUnassociatedMFDs, index, prov.getMFD_Unassociated(index), weight);
            }
        }
        GridSourceFileReader avg = new GridSourceFileReader(region, nodeSubSeisMFDs, nodeUnassociatedMFDs);
        return avg;
    }

    private static void addToMFD(Map<Integer, IncrementalMagFreqDist> mfds, int index, IncrementalMagFreqDist newMFD, double weight) {
        if (newMFD == null) {
            return;
        }
        IncrementalMagFreqDist mfd = mfds.get(index);
        if (mfd == null) {
            mfd = new IncrementalMagFreqDist(newMFD.getMinX(), newMFD.size(), newMFD.getDelta());
            mfds.put(index, mfd);
        } else {
            Preconditions.checkState(((float)mfd.getMinX() == (float)newMFD.getMinX() ? 1 : 0) != 0);
            Preconditions.checkState(((float)mfd.getMaxX() == (float)newMFD.getMaxX() ? 1 : 0) != 0);
            Preconditions.checkState((mfd.size() == newMFD.size() ? 1 : 0) != 0);
        }
        for (int i = 0; i < mfd.size(); ++i) {
            mfd.add(i, newMFD.getY(i) * weight);
        }
    }

    private static class UniqueRupture {
        private int id;
        private double rake;
        private double area;
        private DiscretizedFunc rupMFD;
        private List<UniqueSection> sects;
        private int cnt = 0;
        private List<U3LogicTreeBranch> branchesWithRup;

        public UniqueRupture(int id, double rake, double area) {
            this.id = id;
            this.rake = rake;
            this.area = area;
            this.rupMFD = new ArbitrarilyDiscretizedFunc();
            this.branchesWithRup = Lists.newArrayList();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            long temp = Float.floatToIntBits((float)this.area);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            result = 31 * result + this.id;
            temp = Float.floatToIntBits((float)this.rake);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            UniqueRupture other = (UniqueRupture)obj;
            if (Float.floatToIntBits((float)this.area) != Float.floatToIntBits((float)other.area)) {
                return false;
            }
            if (this.id != other.id) {
                return false;
            }
            return Float.floatToIntBits((float)this.rake) == Float.floatToIntBits((float)other.rake);
        }
    }

    private static class UniqueSection {
        private int id;
        private double aveDip;
        private double aveUpperDepth;
        private double aveLowerDepth;
        private FaultSection sect;
        private Map<U3LogicTreeBranch, FaultSection> branchSects;

        public UniqueSection(FaultSection sect, int globalID) {
            this.id = globalID;
            this.aveDip = sect.getAveDip();
            this.aveUpperDepth = sect.getReducedAveUpperDepth();
            this.aveLowerDepth = sect.getAveLowerDepth();
            this.sect = sect.clone();
            this.branchSects = new HashMap<U3LogicTreeBranch, FaultSection>();
        }

        public void addBranch(U3LogicTreeBranch branch, FaultSection sect) {
            this.branchSects.put(branch, sect);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            long temp = Float.floatToIntBits((float)this.aveDip);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            temp = Float.floatToIntBits((float)this.aveLowerDepth);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            temp = Float.floatToIntBits((float)this.aveUpperDepth);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            result = 31 * result + this.id;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            UniqueSection other = (UniqueSection)obj;
            if (Float.floatToIntBits((float)this.aveDip) != Float.floatToIntBits((float)other.aveDip)) {
                return false;
            }
            if (Float.floatToIntBits((float)this.aveLowerDepth) != Float.floatToIntBits((float)other.aveLowerDepth)) {
                return false;
            }
            if (Float.floatToIntBits((float)this.aveUpperDepth) != Float.floatToIntBits((float)other.aveUpperDepth)) {
                return false;
            }
            return this.id == other.id;
        }
    }
}

