/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.erf.utils;

import java.awt.Color;
import java.util.ArrayList;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.data.function.HistogramFunction;
import org.opensha.commons.gui.plot.GraphWindow;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.sha.earthquake.calc.recurInterval.BPT_DistCalc;
import org.opensha.sha.earthquake.calc.recurInterval.LognormalDistCalc;
import org.opensha.sha.earthquake.calc.recurInterval.WeibullDistCalc;

public class ProbModelsPlottingUtils {
    public static ArrayList<EvenlyDiscretizedFunc> getNormRI_DistributionWithFits(ArrayList<Double> normRI_List, double bptAperForComparison) {
        int firstIndex;
        double delta = 0.1;
        HistogramFunction dist = ProbModelsPlottingUtils.getNormRI_Distribution(normRI_List, delta);
        ArrayList<EvenlyDiscretizedFunc> funcList = new ArrayList<EvenlyDiscretizedFunc>();
        funcList.add(dist);
        funcList.addAll(ProbModelsPlottingUtils.getRenewalModelFunctionFitsToDist(dist));
        double obsAboveFive = 0.0;
        for (int i = firstIndex = dist.getClosestXIndex(5.0); i < dist.size(); ++i) {
            obsAboveFive += dist.getY(i);
        }
        double bptAboveFive = 0.0;
        EvenlyDiscretizedFunc bptDist = (EvenlyDiscretizedFunc)funcList.get(1);
        for (int i = firstIndex = bptDist.getClosestXIndex(5.0); i < bptDist.size(); ++i) {
            bptAboveFive += bptDist.getY(i);
        }
        dist.setName("Recur. Int. Dist");
        String info = "NumObs\tObsMean\tObsCOV\tObsOverBPTAboveFive\tbestFitBPTmean\tbestFitBPTaper\n" + normRI_List.size() + "\t" + (float)dist.computeMean() + "\t" + (float)dist.computeCOV() + "\t" + (float)(obsAboveFive / bptAboveFive);
        info = info + "\t" + bptDist.getInfo().split("\n")[1];
        dist.setInfo(info);
        if (!Double.isNaN(bptAperForComparison)) {
            BPT_DistCalc bpt_calc = new BPT_DistCalc();
            bpt_calc.setAll(1.0, bptAperForComparison, funcList.get(1).getDelta() / 2.0, funcList.get(1).size());
            EvenlyDiscretizedFunc bpt_func = bpt_calc.getPDF();
            bpt_func.setName("BPT Dist for comparison");
            bpt_func.setInfo("(mean=1.0, aper=" + bptAperForComparison + ")");
            funcList.add(bpt_func);
        }
        return funcList;
    }

    public static ArrayList<EvenlyDiscretizedFunc> addBPT_Fit(HistogramFunction dist) {
        int firstIndex;
        ArrayList<EvenlyDiscretizedFunc> funcList = new ArrayList<EvenlyDiscretizedFunc>();
        funcList.add(dist);
        funcList.add(ProbModelsPlottingUtils.getRenewalModelFunctionFitsToDist(dist).get(0));
        double obsAboveFive = 0.0;
        for (int i = firstIndex = dist.getClosestXIndex(5.0); i < dist.size(); ++i) {
            obsAboveFive += dist.getY(i);
        }
        double bptAboveFive = 0.0;
        EvenlyDiscretizedFunc bptDist = (EvenlyDiscretizedFunc)funcList.get(1);
        for (int i = firstIndex = bptDist.getClosestXIndex(5.0); i < bptDist.size(); ++i) {
            bptAboveFive += bptDist.getY(i);
        }
        dist.setName("Recur. Int. Dist");
        String info = "ObsMean\tObsCOV\tObsOverBPTAboveFive\n" + (float)dist.computeMean() + "\t" + (float)dist.computeCOV() + "\t" + (float)(obsAboveFive / bptAboveFive);
        dist.setInfo(info);
        return funcList;
    }

    public static GraphWindow plotNormRI_DistributionWithFits(ArrayList<EvenlyDiscretizedFunc> funcList, String plotTitle) {
        ArrayList<PlotCurveCharacterstics> curveCharacteristics = new ArrayList<PlotCurveCharacterstics>();
        curveCharacteristics.add(new PlotCurveCharacterstics(PlotLineType.HISTOGRAM, 2.0f, Color.RED));
        curveCharacteristics.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLACK));
        curveCharacteristics.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLUE));
        curveCharacteristics.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.GREEN));
        if (funcList.size() == 5) {
            curveCharacteristics.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.GRAY));
        }
        GraphWindow graph = new GraphWindow(funcList, plotTitle, curveCharacteristics);
        graph.setX_AxisLabel("RI (yrs)");
        graph.setY_AxisLabel("Density");
        graph.setX_AxisRange(0.0, 5.0);
        graph.setY_AxisRange(0.0, 5.0);
        graph.setAxisLabelFontSize(22);
        graph.setTickLabelFontSize(20);
        graph.setPlotLabelFontSize(22);
        return graph;
    }

    public static HistogramFunction getNormRI_Distribution(ArrayList<Double> normRI_List, double deltaT) {
        double max = 0.0;
        for (Double val : normRI_List) {
            if (!(val > max)) continue;
            max = val;
        }
        int num = (int)Math.ceil(max / deltaT) + 2;
        HistogramFunction dist = new HistogramFunction(deltaT / 2.0, num, deltaT);
        dist.setTolerance(2.0 * deltaT);
        int numData = normRI_List.size();
        for (Double val : normRI_List) {
            dist.add(val, 1.0 / ((double)numData * deltaT));
        }
        return dist;
    }

    public static ArrayList<EvenlyDiscretizedFunc> getRenewalModelFunctionFitsToDist(EvenlyDiscretizedFunc dist) {
        ArrayList<EvenlyDiscretizedFunc> funcList = new ArrayList<EvenlyDiscretizedFunc>();
        BPT_DistCalc bpt_calc = new BPT_DistCalc();
        bpt_calc.fitToThisFunction(dist, 0.5, 1.5, 101, 0.1, 1.5, 141);
        EvenlyDiscretizedFunc fitBPT_func = bpt_calc.getPDF();
        fitBPT_func.setName("Best Fit BPT Dist");
        fitBPT_func.setInfo("mean\taper\n" + (float)bpt_calc.getMean() + "\t" + (float)bpt_calc.getAperiodicity());
        funcList.add(fitBPT_func);
        LognormalDistCalc logNorm_calc = new LognormalDistCalc();
        logNorm_calc.fitToThisFunction(dist, 0.5, 1.5, 101, 0.1, 1.5, 141);
        EvenlyDiscretizedFunc fitLogNorm_func = logNorm_calc.getPDF();
        fitLogNorm_func.setName("Best Fit Lognormal Dist");
        fitLogNorm_func.setInfo("mean\taper\n" + (float)logNorm_calc.getMean() + "\t" + (float)logNorm_calc.getAperiodicity() + ")");
        funcList.add(fitLogNorm_func);
        WeibullDistCalc weibull_calc = new WeibullDistCalc();
        weibull_calc.fitToThisFunction(dist, 0.5, 1.5, 101, 0.1, 1.5, 141);
        EvenlyDiscretizedFunc fitWeibull_func = weibull_calc.getPDF();
        fitWeibull_func.setName("Best Fit Weibull Dist");
        fitWeibull_func.setInfo("mean\taper\n" + (float)weibull_calc.getMean() + "\t" + (float)weibull_calc.getAperiodicity() + ")");
        funcList.add(fitWeibull_func);
        return funcList;
    }

    public static void main(String[] args) {
    }
}

