/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.griddedSeismicity;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import java.awt.geom.Area;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opensha.commons.data.region.CaliforniaRegions;
import org.opensha.commons.geo.GriddedRegion;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.Region;
import org.opensha.commons.util.io.archive.ArchiveInput;
import org.opensha.commons.util.io.archive.ArchiveOutput;
import org.opensha.commons.util.modules.ArchivableModule;
import org.opensha.commons.util.modules.ModuleArchive;
import org.opensha.sha.earthquake.faultSysSolution.modules.PolygonFaultGridAssociations;
import org.opensha.sha.faultSurface.FaultSection;
import scratch.UCERF3.enumTreeBranches.FaultModels;
import scratch.UCERF3.griddedSeismicity.SectionPolygons;
import scratch.UCERF3.utils.UCERF3_DataUtils;

public class FaultPolyMgr
implements Iterable<Area>,
PolygonFaultGridAssociations,
ArchivableModule {
    private static boolean log = false;
    private SectionPolygons polys;
    private Double buffer;
    private Table<Integer, Integer, Double> nodeInSectPartic;
    private Table<Integer, Integer, Double> sectInNodePartic;
    private Multimap<Integer, Integer> sectToProbNodes;
    private Multimap<Integer, Integer> sectToNodes;
    private Multimap<Integer, Integer> nodeToSects;
    private Map<Integer, Area> nodeAreas;
    private Map<Integer, Double> nodeExtents;
    private Map<Integer, Double> sectExtents;
    private GriddedRegion region;
    private static Map<FaultModels, PolygonFaultGridAssociations> serializedCache = null;

    private FaultPolyMgr() {
    }

    @Override
    public GriddedRegion getRegion() {
        return this.region;
    }

    @Override
    public Map<Integer, Double> getNodeExtents() {
        return ImmutableMap.copyOf(this.nodeExtents);
    }

    @Override
    public double getNodeFraction(int nodeIdx) {
        Double fraction = this.nodeExtents.get(nodeIdx);
        return fraction == null ? 0.0 : fraction;
    }

    @Override
    public Map<Integer, Double> getScaledNodeFractions(int sectIdx) {
        return this.sectInNodePartic.row((Object)sectIdx);
    }

    @Override
    public Map<Integer, Double> getScaledSectFracsOnNode(int nodeIdx) {
        return this.sectInNodePartic.column((Object)nodeIdx);
    }

    @Override
    public Map<Integer, Double> getNodeFractions(int sectIdx) {
        return this.nodeInSectPartic.row((Object)sectIdx);
    }

    @Override
    public Map<Integer, Double> getSectionFracsOnNode(int nodeIdx) {
        return this.nodeInSectPartic.column((Object)nodeIdx);
    }

    @Override
    public Region getPoly(int sectIdx) {
        Area a = this.polys.get(sectIdx);
        if (a == null) {
            return null;
        }
        LocationList locs = SectionPolygons.areaToLocLists(a).get(0);
        return new Region(locs, null);
    }

    public Set<Integer> sectIndices() {
        return this.polys.indices();
    }

    @Override
    public Iterator<Area> iterator() {
        return this.polys.polys().iterator();
    }

    public Double getBuffer() {
        return this.buffer;
    }

    public static FaultPolyMgr create(List<? extends FaultSection> fspd, Double buf, GriddedRegion region) {
        FaultPolyMgr mgr = new FaultPolyMgr();
        if (log) {
            System.out.println("Building poly mgr...");
        }
        if (log) {
            System.out.println("   section polygons");
        }
        mgr.region = region;
        mgr.polys = SectionPolygons.create(fspd, buf, null);
        mgr.init();
        mgr.buffer = buf;
        return mgr;
    }

    public static FaultPolyMgr create(List<? extends FaultSection> fspd, Double buf) {
        CaliforniaRegions.RELM_TESTING_GRIDDED region = new CaliforniaRegions.RELM_TESTING_GRIDDED();
        return FaultPolyMgr.create(fspd, buf, region);
    }

    public static FaultPolyMgr create(FaultModels fm, Double buf, Double len, GriddedRegion region) {
        FaultPolyMgr mgr = new FaultPolyMgr();
        if (log) {
            System.out.println("Building poly mgr...");
        }
        if (log) {
            System.out.println("   getting faults from model");
        }
        List<FaultSection> faults = fm.getFaultSections();
        if (log) {
            System.out.println("   subsection polygons");
        }
        mgr.region = region;
        mgr.polys = SectionPolygons.create(faults, buf, len);
        mgr.init();
        mgr.buffer = buf;
        return mgr;
    }

    public static FaultPolyMgr create(FaultModels fm, Double buf, Double len) {
        CaliforniaRegions.RELM_TESTING_GRIDDED region = new CaliforniaRegions.RELM_TESTING_GRIDDED();
        return FaultPolyMgr.create(fm, buf, len, region);
    }

    private void init() {
        if (log) {
            System.out.println("   section:node map");
        }
        this.initSectionToProbableNodes();
        if (log) {
            System.out.println("   node area cache");
        }
        this.initNodeAreas();
        if (log) {
            System.out.println("   section extents");
        }
        this.initSectionExtents();
        if (log) {
            System.out.println("   section participation");
        }
        this.initSectInNodeParticipTable();
        if (log) {
            System.out.println("   update node cache");
        }
        this.updateNodeAreas();
        if (log) {
            System.out.println("   node participation");
        }
        this.initNodeInSectParticipTable();
        if (log) {
            System.out.println("   node participation");
        }
        this.initNodeParticipation();
        if (log) {
            System.out.println("   update section participation");
        }
        this.updateParticipationTable();
        if (log) {
            System.out.println("   Done.");
        }
    }

    private void initSectionToProbableNodes() {
        this.sectToProbNodes = ArrayListMultimap.create();
        for (Integer id : this.polys.indices()) {
            Area poly = this.polys.get(id);
            List<Integer> indices = null;
            if (poly == null) continue;
            indices = this.region.indicesForBounds(poly.getBounds2D());
            this.sectToProbNodes.putAll((Object)id, indices);
        }
    }

    private void initNodeAreas() {
        this.nodeAreas = Maps.newHashMap();
        this.nodeExtents = Maps.newHashMap();
        HashSet nodeIdxs = Sets.newHashSet((Iterable)this.sectToProbNodes.values());
        for (Integer nodeIdx : nodeIdxs) {
            Area nodeArea = this.region.areaForIndex(nodeIdx);
            double nodeExtent = SectionPolygons.getExtent(nodeArea);
            this.nodeAreas.put(nodeIdx, nodeArea);
            this.nodeExtents.put(nodeIdx, nodeExtent);
        }
    }

    private void initSectionExtents() {
        this.sectExtents = Maps.newHashMap();
        for (Integer id : this.polys.indices()) {
            Area area = this.polys.get(id);
            double extent = area == null ? 0.0 : SectionPolygons.getExtent(area);
            this.sectExtents.put(id, extent);
        }
    }

    private void initSectInNodeParticipTable() {
        this.sectToNodes = ArrayListMultimap.create();
        this.sectInNodePartic = HashBasedTable.create();
        for (Integer ssIdx : this.sectToProbNodes.keySet()) {
            Collection nodeIdxs = this.sectToProbNodes.get((Object)ssIdx);
            List<Integer> revisedIdxs = this.processFault(ssIdx, nodeIdxs);
            this.sectToNodes.putAll((Object)ssIdx, revisedIdxs);
        }
        this.nodeToSects = ArrayListMultimap.create();
        Multimaps.invertFrom(this.sectToNodes, this.nodeToSects);
    }

    private List<Integer> processFault(Integer ssIdx, Iterable<Integer> nodeIdxs) {
        ArrayList newNodeIdxs = Lists.newArrayList();
        Area ssArea = this.polys.get(ssIdx);
        for (Integer nodeIdx : nodeIdxs) {
            Area nodeArea = this.region.areaForIndex(nodeIdx);
            nodeArea.intersect(ssArea);
            nodeArea = SectionPolygons.cleanBorder(nodeArea);
            if (nodeArea.isEmpty()) continue;
            double faultExtent = SectionPolygons.getExtent(nodeArea);
            double ratio = faultExtent / this.nodeExtents.get(nodeIdx);
            newNodeIdxs.add(nodeIdx);
            this.sectInNodePartic.put((Object)ssIdx, (Object)nodeIdx, (Object)ratio);
        }
        return newNodeIdxs;
    }

    private void initNodeInSectParticipTable() {
        this.nodeInSectPartic = HashBasedTable.create();
        for (Table.Cell cell : this.sectInNodePartic.cellSet()) {
            int sectIdx = (Integer)cell.getRowKey();
            int nodeIdx = (Integer)cell.getColumnKey();
            double sectExtent = this.sectExtents.get(sectIdx);
            double nodeExtent = this.nodeExtents.get(nodeIdx);
            double sectPartic = (Double)cell.getValue();
            double nodePartic = nodeExtent * sectPartic / sectExtent;
            this.nodeInSectPartic.put((Object)sectIdx, (Object)nodeIdx, (Object)nodePartic);
        }
    }

    private void updateNodeAreas() {
        HashSet allIdxs = Sets.newHashSet((Iterable)this.sectToProbNodes.values());
        HashSet goodIdxs = Sets.newHashSet((Iterable)this.sectToNodes.values());
        Sets.SetView badIdxs = Sets.difference((Set)allIdxs, (Set)goodIdxs);
        this.nodeAreas.keySet().removeAll((Collection<?>)badIdxs);
        this.nodeExtents.keySet().removeAll((Collection<?>)badIdxs);
    }

    private void initNodeParticipation() {
        for (Integer nodeIdx : this.nodeToSects.keySet()) {
            Area nodeArea = this.nodeAreas.get(nodeIdx);
            double totalExtent = this.nodeExtents.get(nodeIdx);
            for (Integer sectIdx : this.nodeToSects.get((Object)nodeIdx)) {
                nodeArea.subtract(this.polys.get(sectIdx));
            }
            nodeArea = SectionPolygons.cleanBorder(nodeArea);
            this.nodeAreas.put(nodeIdx, nodeArea);
            double nodeExtent = SectionPolygons.getExtent(nodeArea);
            nodeExtent = 1.0 - nodeExtent / totalExtent;
            this.nodeExtents.put(nodeIdx, nodeExtent);
        }
    }

    private void updateParticipationTable() {
        for (Integer nodeIdx : this.sectInNodePartic.columnKeySet()) {
            Map sects = this.sectInNodePartic.column((Object)nodeIdx);
            double totalPartic = FaultPolyMgr.sum(sects.values());
            double nodePartic = this.nodeExtents.get(nodeIdx);
            for (Integer sectIdx : sects.keySet()) {
                double val = (Double)sects.get(sectIdx) / totalPartic * nodePartic;
                sects.put(sectIdx, val);
            }
        }
    }

    private static double sum(Iterable<Double> values) {
        double sum = 0.0;
        for (Double v : values) {
            sum += v.doubleValue();
        }
        return sum;
    }

    public static double[] getNodeFractions(FaultModels model, Double buf, Double len) {
        if (model == null) {
            model = FaultModels.FM3_1;
        }
        if (len == null) {
            len = 7.0;
        }
        FaultPolyMgr mgr = FaultPolyMgr.create(model, buf, len);
        double[] values = new double[mgr.region.getNodeCount()];
        for (int i = 0; i < mgr.region.getNodeCount(); ++i) {
            values[i] = mgr.getNodeFraction(i);
        }
        return values;
    }

    public static synchronized PolygonFaultGridAssociations loadSerializedUCERF3(FaultModels fm) throws IOException {
        PolygonFaultGridAssociations associations;
        if (serializedCache == null) {
            serializedCache = new HashMap<FaultModels, PolygonFaultGridAssociations>();
        }
        if ((associations = serializedCache.get(fm)) == null) {
            InputStream zipIS = UCERF3_DataUtils.locateResourceAsStream("seismicityGrids", fm.name().toLowerCase() + "_fault_polygon_grid_node_associations.zip");
            File tmpFile = File.createTempFile("u3_poly_associations", ".zip");
            FileOutputStream tmpOut = new FileOutputStream(tmpFile);
            zipIS.transferTo(tmpOut);
            tmpOut.close();
            ModuleArchive archive = new ModuleArchive(tmpFile);
            associations = archive.requireModule(PolygonFaultGridAssociations.class);
            tmpFile.delete();
            serializedCache.put(fm, associations);
        }
        return associations;
    }

    public static void main(String[] args) {
        System.out.println(Arrays.toString(FaultPolyMgr.getNodeFractions(FaultModels.FM3_1, 0.0, 7.0)));
    }

    @Override
    public String getName() {
        return "Polygon Fault Association Manager";
    }

    @Override
    public void writeToArchive(ArchiveOutput output, String entryPrefix) throws IOException {
        new PolygonFaultGridAssociations.Precomputed(this).writeToArchive(output, entryPrefix);
    }

    @Override
    public void initFromArchive(ArchiveInput input, String entryPrefix) throws IOException {
        throw new IllegalStateException("Should be loaded back in via the Precomputed class");
    }

    @Override
    public Class<? extends ArchivableModule> getLoadingClass() {
        return PolygonFaultGridAssociations.Precomputed.class;
    }
}

