/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.griddedSeismicity;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.io.LittleEndianDataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.opensha.commons.data.region.CaliforniaRegions;
import org.opensha.commons.geo.GriddedRegion;
import org.opensha.commons.geo.Location;

class UCERF2_GridBuilder {
    private static List<String> gridNames = Lists.newArrayList();
    private static List<List<Double>> gridMechWts;

    UCERF2_GridBuilder() {
    }

    public static void main(String[] args) {
        UCERF2_GridBuilder.generateMechWeights();
    }

    private static void generateMechWeights() {
        double minLat = 24.6;
        double maxLat = 51.0;
        double dLat = 0.1;
        double minLon = -126.5;
        double maxLon = -100.0;
        double dLon = 0.1;
        GriddedRegion gridRegion = new GriddedRegion(new Location(minLat, minLon), new Location(maxLat, maxLon), dLat, GriddedRegion.ANCHOR_0_0);
        CaliforniaRegions.RELM_TESTING_GRIDDED ucerfRegion = new CaliforniaRegions.RELM_TESTING_GRIDDED();
        int nRows = (int)Math.rint((maxLat - minLat) / dLat) + 1;
        int nCols = (int)Math.rint((maxLon - minLon) / dLon) + 1;
        ArrayList aGrids = Lists.newArrayList();
        double[] aSum = null;
        for (String gridName : gridNames) {
            File gridFile = new File("src/main/resources/data/nshmp/sources/" + gridName);
            double[] aDat = UCERF2_GridBuilder.readGrid(gridFile, nRows, nCols);
            aGrids.add(aDat);
            if (aSum == null) {
                aSum = (double[])aDat.clone();
                continue;
            }
            UCERF2_GridBuilder.addArray(aSum, aDat);
        }
        for (double[] aDat : aGrids) {
            UCERF2_GridBuilder.arrayDivide(aDat, aSum);
        }
        double[] s = new double[aSum.length];
        double[] r = new double[aSum.length];
        double[] n = new double[aSum.length];
        for (int i = 0; i < aGrids.size(); ++i) {
            List<Double> mechWts = gridMechWts.get(i);
            double[] aDat = (double[])aGrids.get(i);
            for (int j = 0; j < aDat.length; ++j) {
                s[j] = s[j] + mechWts.get(0) * aDat[j];
                r[j] = r[j] + mechWts.get(1) * aDat[j];
                n[j] = n[j] + mechWts.get(2) * aDat[j];
            }
        }
        ArrayList sRecords = Lists.newArrayList();
        ArrayList rRecords = Lists.newArrayList();
        ArrayList nRecords = Lists.newArrayList();
        for (Location loc : ucerfRegion) {
            int idx = gridRegion.indexForLocation(loc);
            double sVal = idx == -1 ? Double.NaN : s[idx];
            double rVal = idx == -1 ? Double.NaN : r[idx];
            double nVal = idx == -1 ? Double.NaN : n[idx];
            double lat = loc.getLatitude();
            double lon = loc.getLongitude();
            sRecords.add(String.format("%.3f %.3f %.10f", lat, lon, sVal));
            rRecords.add(String.format("%.3f %.3f %.10f", lat, lon, rVal));
            nRecords.add(String.format("%.3f %.3f %.10f", lat, lon, nVal));
        }
        File dir = new File("tmp");
        File sOut = new File(dir, "StrikeSlipWts.txt");
        File rOut = new File(dir, "ReverseWts.txt");
        File nOut = new File(dir, "NormalWts.txt");
        try {
            FileUtils.writeLines((File)sOut, (Collection)sRecords);
            FileUtils.writeLines((File)rOut, (Collection)rRecords);
            FileUtils.writeLines((File)nOut, (Collection)nRecords);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private static void arrayDivide(double[] a1, double[] a2) {
        Preconditions.checkNotNull((Object)a1);
        Preconditions.checkNotNull((Object)a2);
        Preconditions.checkArgument((a1.length == a2.length ? 1 : 0) != 0, (Object)"Arrays are different sizes");
        for (int i = 0; i < a1.length; ++i) {
            int n = i;
            a1[n] = a1[n] / a2[i];
        }
    }

    private static void generateUCERF2pdf() {
        double minLat = 24.6;
        double maxLat = 51.0;
        double dLat = 0.1;
        double minLon = -126.5;
        double maxLon = -100.0;
        double dLon = 0.1;
        GriddedRegion gridRegion = new GriddedRegion(new Location(minLat, minLon), new Location(maxLat, maxLon), dLat, GriddedRegion.ANCHOR_0_0);
        CaliforniaRegions.RELM_TESTING_GRIDDED ucerfRegion = new CaliforniaRegions.RELM_TESTING_GRIDDED();
        int nRows = (int)Math.rint((maxLat - minLat) / dLat) + 1;
        int nCols = (int)Math.rint((maxLon - minLon) / dLon) + 1;
        double[] gridSum = null;
        for (String gridName : gridNames) {
            File gridFile = new File("src/main/resources/data/nshmp/sources/" + gridName);
            double[] aDat = UCERF2_GridBuilder.readGrid(gridFile, nRows, nCols);
            if (gridSum == null) {
                gridSum = (double[])aDat.clone();
                continue;
            }
            UCERF2_GridBuilder.addArray(gridSum, aDat);
        }
        double regionSum = 0.0;
        for (Object loc : ucerfRegion) {
            int idx = gridRegion.indexForLocation((Location)loc);
            regionSum += idx == -1 ? 0.0 : gridSum[idx];
        }
        ArrayList records = Lists.newArrayList();
        for (Location loc : ucerfRegion) {
            int idx = gridRegion.indexForLocation(loc);
            double value = idx == -1 ? 0.0 : gridSum[idx] / regionSum;
            records.add(String.format("%.3f %.3f %.10f", loc.getLatitude(), loc.getLongitude(), value));
        }
        File dir = new File("tmp");
        File out = new File(dir, "SmoothSeis_UCERF2.txt");
        try {
            FileUtils.writeLines((File)out, (Collection)records);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private static void addArray(double[] a1, double[] a2) {
        for (int i = 0; i < a1.length; ++i) {
            int n = i;
            a1[n] = a1[n] + a2[i];
        }
    }

    private static int calcIndex(int idx, int nRows, int nCols) {
        return (nRows - idx / nCols - 1) * nCols + idx % nCols;
    }

    private static double[] readGrid(File file, int nRows, int nCols) {
        int count = nRows * nCols;
        double[] data = new double[count];
        try {
            LittleEndianDataInputStream in = new LittleEndianDataInputStream((InputStream)FileUtils.openInputStream((File)file));
            for (int i = 0; i < count; ++i) {
                double value;
                data[UCERF2_GridBuilder.calcIndex((int)i, (int)nRows, (int)nCols)] = value = Float.valueOf(in.readFloat()).doubleValue();
            }
            in.close();
        }
        catch (IOException ioe) {
            System.out.println(ioe);
        }
        return data;
    }

    static {
        gridNames.add("CA/gridded/GR_DOS/agrd_brawly.out");
        gridNames.add("CA/gridded/GR_DOS/agrd_mendos.out");
        gridNames.add("CA/gridded/GR_DOS/agrd_creeps.out");
        gridNames.add("CA/gridded/GR_DOS/agrd_deeps.out");
        gridNames.add("CA/gridded/GR_DOS/agrd_impext.out");
        gridNames.add("CA/gridded/GR_DOS/agrd_cstcal.out");
        gridNames.add("WUS/gridded/GR_DOS/agrd_wuscmp.out");
        gridNames.add("WUS/gridded/GR_DOS/agrd_wusext.out");
        gridMechWts = Lists.newArrayList();
        gridMechWts.add((List<Double>)ImmutableList.of((Object)0.5, (Object)0.0, (Object)0.5));
        gridMechWts.add((List<Double>)ImmutableList.of((Object)0.5, (Object)0.5, (Object)0.0));
        gridMechWts.add((List<Double>)ImmutableList.of((Object)1.0, (Object)0.0, (Object)0.0));
        gridMechWts.add((List<Double>)ImmutableList.of((Object)1.0, (Object)0.0, (Object)0.0));
        gridMechWts.add((List<Double>)ImmutableList.of((Object)0.5, (Object)0.0, (Object)0.5));
        gridMechWts.add((List<Double>)ImmutableList.of((Object)0.5, (Object)0.5, (Object)0.0));
        gridMechWts.add((List<Double>)ImmutableList.of((Object)0.5, (Object)0.5, (Object)0.0));
        gridMechWts.add((List<Double>)ImmutableList.of((Object)0.5, (Object)0.0, (Object)0.5));
    }
}

