/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.inversion;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.dom4j.DocumentException;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.data.region.CaliforniaRegions;
import org.opensha.commons.exceptions.GMT_MapException;
import org.opensha.commons.util.ClassUtils;
import org.opensha.commons.util.IDPairing;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.SimulatedAnnealing;
import scratch.UCERF3.U3AverageFaultSystemSolution;
import scratch.UCERF3.U3CompoundFaultSystemSolution;
import scratch.UCERF3.U3FileBasedFSSIterator;
import scratch.UCERF3.analysis.FaultBasedMapGen;
import scratch.UCERF3.enumTreeBranches.DeformationModels;
import scratch.UCERF3.enumTreeBranches.FaultModels;
import scratch.UCERF3.inversion.CommandLineInversionRunner;
import scratch.UCERF3.inversion.InversionFaultSystemRupSet;
import scratch.UCERF3.inversion.InversionFaultSystemSolution;
import scratch.UCERF3.inversion.UCERF2_ComparisonSolutionFetcher;
import scratch.UCERF3.inversion.laughTest.UCERF3PlausibilityConfig;
import scratch.UCERF3.logicTree.U3LogicTreeBranchNode;
import scratch.UCERF3.logicTree.VariableLogicTreeBranch;
import scratch.UCERF3.utils.DeformationModelFetcher;
import scratch.UCERF3.utils.MatrixIO;
import scratch.UCERF3.utils.U3FaultSystemIO;
import scratch.UCERF3.utils.UCERF3_DataUtils;
import scratch.UCERF3.utils.aveSlip.U3AveSlipConstraint;
import scratch.UCERF3.utils.paleoRateConstraints.U3PaleoRateConstraint;
import scratch.UCERF3.utils.paleoRateConstraints.UCERF3_PaleoProbabilityModel;

public class BatchPlotGen {
    public static ArrayList<double[]> partic_mag_ranges = new ArrayList();
    private static HashMap<FaultModels, FaultSystemSolution> ucerf2SolutionCache;
    static File lockFile;

    private static double[] toArray(double ... vals) {
        return vals;
    }

    public static void makeMapPlots(InversionFaultSystemSolution sol, File dir, String prefix) throws GMT_MapException, RuntimeException, IOException, DocumentException {
        CaliforniaRegions.CA_Region region = sol.getRupSet().getDeformationModel() == DeformationModels.UCERF2_NCAL || sol.getRupSet().getDeformationModel() == DeformationModels.UCERF2_BAYAREA ? new CaliforniaRegions.RELM_NOCAL() : new CaliforniaRegions.RELM_TESTING();
        FaultBasedMapGen.plotOrigNonReducedSlipRates(sol, region, dir, prefix, false);
        FaultBasedMapGen.plotOrigCreepReducedSlipRates(sol, region, dir, prefix, false);
        FaultBasedMapGen.plotTargetSlipRates(sol, region, dir, prefix, false);
        FaultBasedMapGen.plotSolutionSlipRates(sol, region, dir, prefix, false);
        FaultBasedMapGen.plotSolutionSlipMisfit(sol, region, dir, prefix, false, true);
        FaultBasedMapGen.plotSolutionSlipMisfit(sol, region, dir, prefix, false, false);
        FaultSystemSolution ucerf2 = BatchPlotGen.getUCERF2Comparision(sol.getRupSet().getFaultModel(), dir);
        for (double[] range : partic_mag_ranges) {
            FaultBasedMapGen.plotParticipationRates(sol, region, dir, prefix, false, range[0], range[1]);
            FaultBasedMapGen.plotParticipationRatios(sol, ucerf2, region, dir, prefix, false, range[0], range[1], true);
        }
        FaultBasedMapGen.plotSectionPairRates(sol, region, dir, prefix, false);
        FaultBasedMapGen.plotSegmentation(sol, region, dir, prefix, false, 0.0, 10.0);
        FaultBasedMapGen.plotSegmentation(sol, region, dir, prefix, false, 7.0, 10.0);
        FaultBasedMapGen.plotSegmentation(sol, region, dir, prefix, false, 7.5, 10.0);
    }

    private static FaultSystemSolution getUCERF2Comparision(FaultModels fm, File dir) throws IOException, DocumentException {
        FaultSystemSolution sol;
        if (ucerf2SolutionCache.containsKey(fm)) {
            return ucerf2SolutionCache.get(fm);
        }
        File cachedFile = new File(dir, fm.getShortName() + "_UCERF2_COMPARISON_SOL.zip");
        if (cachedFile.exists()) {
            System.out.println("Loading UCERF2 comparison from: " + cachedFile.getName());
            sol = FaultSystemSolution.load(cachedFile);
        } else {
            sol = UCERF2_ComparisonSolutionFetcher.getUCERF2Solution(fm);
            try {
                sol.getArchive().write(cachedFile);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        ucerf2SolutionCache.put(fm, sol);
        return sol;
    }

    public static void writeMisfitsCSV(File dir, Map<VariableLogicTreeBranch, Map<String, Double>> misfitsMap) throws IOException {
        BatchPlotGen.writeMisfitsCSV(dir, dir.getName(), misfitsMap);
    }

    public static void writeMisfitsCSV(File dir, String prefix, Map<VariableLogicTreeBranch, Map<String, Double>> misfitsMap) throws IOException {
        int cols;
        ArrayList misfitNames = Lists.newArrayList();
        for (Map<String, Double> misfits : misfitsMap.values()) {
            for (String name : misfits.keySet()) {
                if (misfitNames.contains(name)) continue;
                misfitNames.add(name);
            }
        }
        Collections.sort(misfitNames);
        File misfitsCSV = new File(dir, prefix + "_misfits.csv");
        int numLogicTreeElems = -1;
        for (VariableLogicTreeBranch branch : misfitsMap.keySet()) {
            int num = branch.size();
            if (branch.getVariations() != null) {
                num += branch.getVariations().size();
            }
            if (numLogicTreeElems < 0) {
                numLogicTreeElems = num;
                continue;
            }
            Preconditions.checkState((numLogicTreeElems == num ? 1 : 0) != 0, (Object)"Logic Tree Branch Lengths Inconsistent!");
        }
        HashMap misfitCols = Maps.newHashMap();
        CSVFile<String> csv = new CSVFile<String>(true);
        ArrayList header = Lists.newArrayList();
        VariableLogicTreeBranch branch1 = misfitsMap.keySet().iterator().next();
        for (U3LogicTreeBranchNode node : branch1) {
            header.add(ClassUtils.getClassNameWithoutPackage(node.getClass()));
        }
        if (branch1.getVariations() != null) {
            for (int i = 0; i < branch1.getVariations().size(); ++i) {
                header.add("Variation " + (i + 1));
            }
        }
        for (Object misfitName : misfitNames) {
            int col = header.size();
            header.add(misfitName);
            misfitCols.put(misfitName, col);
        }
        csv.addLine(header);
        int numCols = csv.getNumCols();
        for (VariableLogicTreeBranch branch : misfitsMap.keySet()) {
            Map<String, Double> misfits = misfitsMap.get(branch);
            ArrayList line = Lists.newArrayList();
            for (U3LogicTreeBranchNode node : branch) {
                line.add(node.getShortName());
            }
            if (branch.getVariations() != null) {
                for (int i = 0; i < branch.getVariations().size(); ++i) {
                    line.add(branch.getVariations().get(i));
                }
            }
            while (line.size() < numCols) {
                line.add("");
            }
            for (String misfitName : misfits.keySet()) {
                line.set((Integer)misfitCols.get(misfitName), String.valueOf(misfits.get(misfitName)));
            }
            csv.addLine(line);
        }
        Comparator<String> comparator = new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                try {
                    double d1 = Double.parseDouble(o1);
                    double d2 = Double.parseDouble(o2);
                    return Double.compare(d1, d2);
                }
                catch (NumberFormatException e) {
                    return o1.compareTo(o2);
                }
            }
        };
        int col = cols = csv.getNumCols();
        while (--col >= 0) {
            csv.sort(col, 1, comparator);
        }
        csv.writeToFile(misfitsCSV);
    }

    public static void writeCombinedFSS(File dir) throws IOException {
        BatchPlotGen.writeCombinedFSS(dir, null);
    }

    public static void writeCombinedFSS(File dir, List<String> nameGreps) throws IOException {
        String fName;
        if (nameGreps != null && !nameGreps.isEmpty()) {
            boolean buildMean = false;
            Object grepsStr = "";
            for (String nameGrep : nameGreps) {
                if (nameGrep.equals("BUILD_MEAN")) {
                    buildMean = true;
                    continue;
                }
                grepsStr = (String)grepsStr + "_" + nameGrep;
            }
            if (buildMean) {
                grepsStr = (String)grepsStr + "_MEAN";
            }
            fName = dir.getName() + (String)grepsStr + "_COMPOUND_SOL.zip";
        } else {
            fName = dir.getName() + "_COMPOUND_SOL.zip";
        }
        File compoundFile = new File(dir, fName);
        if (compoundFile.exists()) {
            System.out.println("Compound solution already exists: " + compoundFile.getName());
        } else {
            U3FileBasedFSSIterator it = U3FileBasedFSSIterator.forDirectory(dir, 1, nameGreps);
            if (it.getBranches().size() > 1) {
                U3CompoundFaultSystemSolution.toZipFile(compoundFile, it);
            } else {
                System.out.println("Skipping compound solution, only 1 unique branch!");
            }
        }
    }

    public static void handleDir(File dir) throws IOException, DocumentException, GMT_MapException {
        System.out.println("Handling directory: " + dir.getName());
        HashMap misfitsMap = Maps.newHashMap();
        boolean done = BatchPlotGen.handleDir(dir, misfitsMap, 1);
        System.out.println("DONE? " + done);
        if (!misfitsMap.isEmpty()) {
            BatchPlotGen.writeMisfitsCSV(dir, misfitsMap);
        }
        if (done) {
            BatchPlotGen.writeCombinedFSS(dir);
        }
    }

    public static boolean handleDir(File dir, Map<VariableLogicTreeBranch, Map<String, Double>> misfitsMap, int maxDepth) throws IOException, DocumentException, GMT_MapException {
        HashSet<String> pbsPrefixes = new HashSet<String>();
        HashSet<String> donePrefixes = new HashSet<String>();
        BatchPlotGen.handleDir(dir, misfitsMap, maxDepth, pbsPrefixes, donePrefixes);
        for (String prefix : pbsPrefixes) {
            if (donePrefixes.contains(prefix)) continue;
            return false;
        }
        return true;
    }

    public static void handleDir(File dir, Map<VariableLogicTreeBranch, Map<String, Double>> misfitsMap, int maxDepth, HashSet<String> pbsPrefixes, HashSet<String> donePrefixes) throws IOException, DocumentException, GMT_MapException {
        for (File file : dir.listFiles()) {
            File avgSolFile;
            String prefix;
            if (file.isDirectory()) {
                if (maxDepth <= 0) continue;
                BatchPlotGen.handleDir(file, misfitsMap, maxDepth - 1, pbsPrefixes, donePrefixes);
                continue;
            }
            String fileName = file.getName();
            if (fileName.endsWith(".pbs")) {
                prefix = fileName.substring(0, fileName.indexOf(".pbs"));
                pbsPrefixes.add(prefix);
                continue;
            }
            if (!fileName.endsWith("_sol.zip")) continue;
            prefix = fileName.substring(0, fileName.indexOf("_sol.zip"));
            donePrefixes.add(prefix);
            BatchPlotGen.handleSolutionFile(file, prefix, null, misfitsMap);
            if (!prefix.contains("_run")) continue;
            prefix = prefix.substring(0, prefix.indexOf("_run") + 1);
            File myDir = file.getParentFile().getName().startsWith(prefix) ? dir.getParentFile() : dir;
            int total = 0;
            int completed = 0;
            for (File testFile : myDir.listFiles()) {
                String testName = testFile.getName();
                if (!testName.startsWith(prefix) || !testName.endsWith(".pbs")) continue;
                ++total;
                File binFile = new File(myDir, (testName = testName.substring(0, testName.indexOf(".pbs"))) + ".bin");
                if (!binFile.exists() && !new File(new File(myDir, testName), testName + ".bin").exists()) continue;
                ++completed;
            }
            if (completed < total) {
                System.out.println("Not quite done with '" + prefix + "' (" + completed + "/" + total + ")");
                continue;
            }
            String meanPrefix = prefix + "mean";
            File meanSolDir = new File(myDir, meanPrefix);
            if (!meanSolDir.exists()) {
                meanSolDir.mkdir();
            }
            if ((avgSolFile = new File(meanSolDir, meanPrefix + "_sol.zip")).exists() && BatchPlotGen.doAvgPlotsExist(meanSolDir, meanPrefix)) {
                System.out.println("Skipping (mean sol already done): " + meanPrefix);
                continue;
            }
            InversionFaultSystemRupSet rupSet = U3FaultSystemIO.loadInvRupSet(file);
            U3AverageFaultSystemSolution avgSol = U3AverageFaultSystemSolution.fromDirectory(rupSet, myDir, prefix);
            if (!BatchPlotGen.doAvgPlotsExist(meanSolDir, meanPrefix)) {
                try {
                    BatchPlotGen.writeAvgSolPlots(avgSol, meanSolDir, meanPrefix);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            U3FaultSystemIO.writeSol(avgSol, avgSolFile);
            MatrixIO.doubleArrayToFile(avgSol.getRateForAllRups(), new File(meanSolDir, meanPrefix + ".bin"));
            BatchPlotGen.handleSolutionFile(avgSolFile, meanPrefix, avgSol, null);
        }
    }

    public static Map<String, Double> loadMisfitsFile(File misfitsFile) throws IOException {
        return BatchPlotGen.loadMisfitsFile(new FileInputStream(misfitsFile));
    }

    public static Map<String, Double> loadMisfitsFile(InputStream is) throws IOException {
        String line;
        InputStreamReader isr = new InputStreamReader(is);
        BufferedReader br = new BufferedReader(isr);
        HashMap misfits = Maps.newHashMap();
        while ((line = br.readLine()) != null) {
            if ((line = line.trim()).isEmpty()) continue;
            int ind = line.indexOf(":");
            String name = line.substring(0, ind);
            Double val = Double.parseDouble(line.substring(ind + 1).trim());
            misfits.put(name, val);
        }
        return misfits;
    }

    public static void writeMisfitsFile(Map<String, Double> misfits, File misfitsFile) throws IOException {
        FileWriter fw = new FileWriter(misfitsFile);
        for (String misfit : misfits.keySet()) {
            double val = misfits.get(misfit);
            fw.write(misfit + ": " + val + "\n");
        }
        fw.close();
    }

    public static void handleSolutionFile(File file, String prefix, InversionFaultSystemSolution sol, Map<VariableLogicTreeBranch, Map<String, Double>> misfitsMap) throws GMT_MapException, RuntimeException, IOException, DocumentException {
        File dir = file.getParentFile();
        if (misfitsMap != null) {
            if (sol == null) {
                sol = U3FaultSystemIO.loadInvSol(file);
            }
            VariableLogicTreeBranch branch = null;
            try {
                branch = VariableLogicTreeBranch.fromFileName(prefix);
            }
            catch (Exception e) {
                System.err.println("WARNING: Couldn't parse prefix into branch: " + prefix);
                e.printStackTrace();
            }
            if (branch != null) {
                File misfitsFile = new File(file.getAbsolutePath() + ".misfits");
                if (misfitsFile.exists()) {
                    misfitsMap.put(branch, BatchPlotGen.loadMisfitsFile(misfitsFile));
                } else {
                    try {
                        Map<String, Double> misfits = sol.getMisfits();
                        BatchPlotGen.writeMisfitsFile(misfits, misfitsFile);
                        misfitsMap.put(branch, misfits);
                    }
                    catch (Exception e) {
                        System.err.println("WARNING: Couldn't load InversionFaultSystemSolution Misfits for: " + prefix);
                        e.printStackTrace();
                    }
                }
            }
        }
        File testMapDoneFile = new File(dir, prefix + "_sect_pairs.png");
        boolean hasMapPlots = testMapDoneFile.exists();
        boolean hasMFDPlots = CommandLineInversionRunner.doMFDPlotsExist(dir, prefix);
        boolean hasJumpPlots = CommandLineInversionRunner.doJumpPlotsExist(dir, prefix);
        boolean hasPaleoPlots = CommandLineInversionRunner.doPaleoPlotsExist(dir, prefix);
        boolean hasSAFSegPlots = CommandLineInversionRunner.doSAFSegPlotsExist(dir, prefix);
        boolean hasPaleoCorrelationPlots = new File(dir, "paleo_correlation").exists();
        boolean hasParentMFDPlots = new File(dir, "parent_sect_mfds").exists();
        boolean hasPaleoFaultBasedPlots = new File(dir, "paleo_fault_based").exists();
        boolean hasSmoothnessPlots = CommandLineInversionRunner.doRupPairingSmoothnessPlotsExist(dir, prefix);
        if (hasMapPlots && hasMFDPlots && hasJumpPlots && hasJumpPlots && hasPaleoPlots && hasSAFSegPlots && hasPaleoCorrelationPlots && hasParentMFDPlots && hasPaleoFaultBasedPlots && hasSmoothnessPlots) {
            System.out.println("Skipping (already done): " + prefix);
            return;
        }
        System.out.println("Processing: " + prefix);
        if (sol == null) {
            sol = U3FaultSystemIO.loadInvSol(file);
        }
        if (!hasMapPlots) {
            BatchPlotGen.makeMapPlots(sol, dir, prefix);
        }
        if (!hasMFDPlots) {
            try {
                CommandLineInversionRunner.writeMFDPlots(sol, dir, prefix);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!hasJumpPlots) {
            try {
                DeformationModels dm = sol.getRupSet().getFaultModel().getFilterBasis();
                if (dm == null) {
                    dm = sol.getRupSet().getDeformationModel();
                }
                Map<IDPairing, Double> distsMap = new DeformationModelFetcher(sol.getRupSet().getFaultModel(), dm, UCERF3_DataUtils.DEFAULT_SCRATCH_DATA_DIR, 0.1).getSubSectionDistanceMap(UCERF3PlausibilityConfig.getDefault().getMaxJumpDist());
                CommandLineInversionRunner.writeJumpPlots(sol, distsMap, dir, prefix);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        ArrayList<U3PaleoRateConstraint> paleoRateConstraints = null;
        List<U3AveSlipConstraint> aveSlipConstraints = null;
        if (!hasPaleoPlots || !hasPaleoFaultBasedPlots) {
            paleoRateConstraints = CommandLineInversionRunner.getPaleoConstraints(sol.getRupSet().getFaultModel(), sol.getRupSet());
            aveSlipConstraints = U3AveSlipConstraint.load(sol.getRupSet().getFaultSectionDataList());
        }
        if (!hasPaleoPlots) {
            CommandLineInversionRunner.writePaleoPlots(paleoRateConstraints, aveSlipConstraints, sol, dir, prefix);
        }
        if (!hasSAFSegPlots) {
            try {
                CommandLineInversionRunner.writeSAFSegPlots(sol, dir, prefix);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!hasPaleoCorrelationPlots) {
            try {
                CommandLineInversionRunner.writePaleoCorrelationPlots(sol, new File(dir, "paleo_correlation"), UCERF3_PaleoProbabilityModel.load());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!hasParentMFDPlots) {
            try {
                CommandLineInversionRunner.writeParentSectionMFDPlots(sol, new File(dir, "parent_sect_mfds"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!hasPaleoFaultBasedPlots) {
            try {
                Map<String, List<Integer>> namedFaultsMap = sol.getRupSet().getFaultModel().getNamedFaultsMapAlt();
                CommandLineInversionRunner.writePaleoFaultPlots(paleoRateConstraints, aveSlipConstraints, namedFaultsMap, sol, new File(dir, "paleo_fault_based"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!hasSmoothnessPlots) {
            try {
                CommandLineInversionRunner.writeRupPairingSmoothnessPlot(sol, prefix, dir);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static boolean doAvgPlotsExist(File dir, String prefix) {
        return new File(dir, prefix + "_partic_rates_8.0+.png").exists() || new File(dir, prefix + "_rate_dist.png").exists();
    }

    public static void writeAvgSolPlots(U3AverageFaultSystemSolution avgSol, File dir, String prefix) throws GMT_MapException, RuntimeException, IOException, InterruptedException {
        CommandLineInversionRunner.writeParentSectionMFDPlots(avgSol, new File(dir, "parent_sect_mfds"));
        String noMeanPrefix = prefix.substring(0, prefix.indexOf("_mean"));
        File sol0NoMinsFile = null;
        File sol0RatesFile = null;
        File parentDir = dir.getParentFile();
        for (int i = 1; i < 5; ++i) {
            String myPrefix = noMeanPrefix + "_run";
            for (int j = 0; j < i; ++j) {
                myPrefix = myPrefix + "0";
            }
            File run0Dir = new File(parentDir, myPrefix);
            if (!run0Dir.exists()) continue;
            sol0NoMinsFile = new File(run0Dir, myPrefix + "_noMinRates.bin");
            sol0RatesFile = new File(run0Dir, myPrefix + ".bin");
            if (sol0NoMinsFile.exists() && sol0RatesFile.exists()) break;
        }
        if (sol0NoMinsFile.exists() && sol0RatesFile.exists()) {
            double[] sol0NoMins = MatrixIO.doubleArrayFromFile(sol0NoMinsFile);
            double[] sol0Rates = MatrixIO.doubleArrayFromFile(sol0RatesFile);
            double[] minRates = new double[sol0Rates.length];
            for (int r = 0; r < sol0Rates.length; ++r) {
                minRates[r] = sol0Rates[r] - sol0NoMins[r];
            }
            double[] rates = avgSol.getRateForAllRups();
            double[] ratesNoMin = new double[minRates.length];
            for (int r = 0; r < rates.length; ++r) {
                ratesNoMin[r] = rates[r] - minRates[r];
            }
            SimulatedAnnealing.writeRateVsRankPlot(dir, prefix + "_rate_dist", ratesNoMin, rates, new double[minRates.length]);
        }
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("USAGE: " + ClassUtils.getClassNameWithoutPackage(BatchPlotGen.class) + " <directory>");
            System.exit(2);
        }
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                BatchPlotGen.deleteLock();
            }
        });
        try {
            File dir = new File(args[0]);
            Preconditions.checkArgument((boolean)dir.exists(), (Object)(dir.getAbsolutePath() + " doesn't exist!"));
            lockFile = new File(dir, "__batch_plot_gen.lock");
            if (lockFile.exists()) {
                System.out.println("Directory locked: " + dir.getAbsolutePath());
                System.exit(0);
            }
            BatchPlotGen.createLock();
            BatchPlotGen.handleDir(dir);
        }
        catch (Exception e) {
            e.printStackTrace();
            BatchPlotGen.deleteLock();
            System.exit(1);
        }
        BatchPlotGen.deleteLock();
        System.exit(0);
    }

    private static void createLock() throws IOException {
        FileWriter fw = new FileWriter(lockFile);
        fw.write("batch plot gen lock!");
        fw.close();
    }

    private static void deleteLock() {
        if (lockFile != null && lockFile.exists()) {
            lockFile.delete();
        }
    }

    static {
        partic_mag_ranges.add(BatchPlotGen.toArray(6.0, 7.0));
        partic_mag_ranges.add(BatchPlotGen.toArray(7.0, 8.0));
        partic_mag_ranges.add(BatchPlotGen.toArray(8.0, 10.0));
        ucerf2SolutionCache = Maps.newHashMap();
    }
}

