/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.inversion;

import cern.colt.matrix.tdouble.DoubleMatrix2D;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import com.google.common.io.Files;
import edu.usc.kmilner.mpj.taskDispatch.MPJTaskCalculator;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.math3.stat.StatUtils;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.annotations.XYTextAnnotation;
import org.jfree.chart.plot.DatasetRenderingOrder;
import org.jfree.data.Range;
import org.opensha.commons.calc.FaultMomentCalc;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.geo.Region;
import org.opensha.commons.gui.plot.HeadlessGraphPanel;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.gui.plot.PlotSpec;
import org.opensha.commons.gui.plot.PlotSymbol;
import org.opensha.commons.util.ClassUtils;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.commons.util.IDPairing;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl.PaleoProbabilityModel;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl.RupRateSmoothingInversionConstraint;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.ConstraintRange;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.ThreadedSimulatedAnnealing;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.completion.AnnealingProgress;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.completion.CompletionCriteria;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.completion.ProgressTrackingCompletionCriteria;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import org.opensha.sha.magdist.SummedMagFreqDist;
import scratch.UCERF3.U3AverageFaultSystemSolution;
import scratch.UCERF3.U3SlipEnabledRupSet;
import scratch.UCERF3.U3SlipEnabledSolution;
import scratch.UCERF3.analysis.CompoundFSSPlots;
import scratch.UCERF3.analysis.FaultSpecificSegmentationPlotGen;
import scratch.UCERF3.analysis.FaultSystemRupSetCalc;
import scratch.UCERF3.enumTreeBranches.FaultModels;
import scratch.UCERF3.enumTreeBranches.InversionModels;
import scratch.UCERF3.enumTreeBranches.MomentRateFixes;
import scratch.UCERF3.inversion.InversionFaultSystemRupSet;
import scratch.UCERF3.inversion.InversionFaultSystemRupSetFactory;
import scratch.UCERF3.inversion.InversionFaultSystemSolution;
import scratch.UCERF3.inversion.UCERF3InversionConfiguration;
import scratch.UCERF3.inversion.UCERF3InversionInputGenerator;
import scratch.UCERF3.inversion.laughTest.UCERF3PlausibilityConfig;
import scratch.UCERF3.logicTree.U3LogicTreeBranch;
import scratch.UCERF3.utils.RELM_RegionUtils;
import scratch.UCERF3.utils.U3FaultSystemIO;
import scratch.UCERF3.utils.UCERF2_MFD_ConstraintFetcher;
import scratch.UCERF3.utils.UCERF2_Section_MFDs.UCERF2_Section_MFDsCalc;
import scratch.UCERF3.utils.aveSlip.U3AveSlipConstraint;
import scratch.UCERF3.utils.paleoRateConstraints.PaleoFitPlotter;
import scratch.UCERF3.utils.paleoRateConstraints.PaleoSiteCorrelationData;
import scratch.UCERF3.utils.paleoRateConstraints.U3PaleoRateConstraint;
import scratch.UCERF3.utils.paleoRateConstraints.UCERF2_PaleoProbabilityModel;
import scratch.UCERF3.utils.paleoRateConstraints.UCERF2_PaleoRateConstraintFetcher;
import scratch.UCERF3.utils.paleoRateConstraints.UCERF3_PaleoRateConstraintFetcher;
import scratch.kevin.ucerf3.RupSetDownsampler;

public class CommandLineInversionRunner {
    public static final String PALEO_FAULT_BASED_DIR_NAME = "paleo_fault_based";
    public static final String PALEO_CORRELATION_DIR_NAME = "paleo_correlation";
    public static final String PARENT_SECT_MFD_DIR_NAME = "parent_sect_mfds";

    protected static Options createOptions() {
        Options ops = ThreadedSimulatedAnnealing.createOptionsNoInputs();
        for (InversionOptions invOp : InversionOptions.values()) {
            Option op = new Option(invOp.shortArg, invOp.argName, invOp.hasOption, invOp.description);
            op.setRequired(false);
            ops.addOption(op);
        }
        Option rupSetOp = new Option("branch", "branch-prefix", true, "Prefix for file names.Should be able to parse logic tree branch from this");
        rupSetOp.setRequired(true);
        ops.addOption(rupSetOp);
        Option lightweightOp = new Option("light", "lightweight", false, "Only write out a bin file for the solution.Leave the rup set if the prefix indicates run 0");
        lightweightOp.setRequired(false);
        ops.addOption(lightweightOp);
        Option dirOp = new Option("dir", "directory", true, "Directory to store inputs");
        dirOp.setRequired(true);
        ops.addOption(dirOp);
        Option noPlotsOp = new Option("noplots", "no-plots", false, "Flag to disable any plots (but still write solution zip file)");
        noPlotsOp.setRequired(false);
        ops.addOption(noPlotsOp);
        return ops;
    }

    public static void printHelp(Options options, boolean mpj) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(ClassUtils.getClassNameWithoutPackage(CommandLineInversionRunner.class), options, true);
        if (mpj) {
            MPJTaskCalculator.abortAndExit((int)2);
        } else {
            System.exit(2);
        }
    }

    public static void main(String[] args) {
        CommandLineInversionRunner.run(args, false);
        System.out.println("DONE");
        System.exit(0);
    }

    public static void run(String[] args, boolean mpj) {
        Options options = CommandLineInversionRunner.createOptions();
        try {
            double val;
            GnuParser parser = new GnuParser();
            CommandLine cmd = parser.parse(options, args);
            boolean lightweight = cmd.hasOption("lightweight");
            boolean noPlots = cmd.hasOption("no-plots");
            File dir = new File(cmd.getOptionValue("directory"));
            if (!dir.exists()) {
                dir.mkdir();
            }
            String prefix = cmd.getOptionValue("branch-prefix");
            U3LogicTreeBranch branch = U3LogicTreeBranch.fromFileName(prefix);
            Preconditions.checkState((boolean)branch.isFullySpecified(), (Object)("Branch is not fully fleshed out! Prefix: " + prefix + ", branch: " + String.valueOf(branch)));
            File subDir = new File(dir, prefix);
            if (!subDir.exists()) {
                subDir.mkdir();
            }
            UCERF3PlausibilityConfig laughTest = cmd.hasOption(InversionOptions.UCERF3p2.argName) ? UCERF3PlausibilityConfig.getUCERF3p2Filter() : UCERF3PlausibilityConfig.getDefault();
            if (cmd.hasOption(InversionOptions.COULOMB.argName)) {
                val = Double.parseDouble(cmd.getOptionValue(InversionOptions.COULOMB.argName));
                laughTest.getCoulombFilter().setMinAverageProb(val);
                laughTest.getCoulombFilter().setMinIndividualProb(val);
            }
            if (cmd.hasOption(InversionOptions.COULOMB_EXCLUDE.argName)) {
                val = Double.parseDouble(cmd.getOptionValue(InversionOptions.COULOMB_EXCLUDE.argName));
                laughTest.getCoulombFilter().setMinimumStressExclusionCeiling(val);
            }
            String aseisArg = InversionOptions.DEFAULT_ASEISMICITY.argName;
            double defaultAseis = 0.1;
            if (cmd.hasOption(aseisArg)) {
                String aseisVal = cmd.getOptionValue(aseisArg);
                defaultAseis = Double.parseDouble(aseisVal);
            }
            System.out.println("Building RupSet");
            if (cmd.hasOption("remove-faults")) {
                HashSet<Integer> sectionsToIgnore = new HashSet<Integer>();
                sectionsToIgnore.add(13);
                sectionsToIgnore.add(97);
                sectionsToIgnore.add(172);
                sectionsToIgnore.add(104);
                laughTest.setParentSectsToIgnore(sectionsToIgnore);
            }
            InversionFaultSystemRupSet rupSet = InversionFaultSystemRupSetFactory.forBranch(laughTest, defaultAseis, branch);
            System.out.println("Num rups: " + rupSet.getNumRuptures());
            if (cmd.hasOption(InversionOptions.RUP_FILTER_FILE.argName)) {
                rupSet = CommandLineInversionRunner.getFilteredRupsOnly(rupSet, new File(cmd.getOptionValue(InversionOptions.RUP_FILTER_FILE.argName)));
                System.out.println("Num rups after filtering: " + rupSet.getNumRuptures());
            }
            if (cmd.hasOption(InversionOptions.RUP_DOWNSAMPLE_DM.argName)) {
                double dm = Double.parseDouble(cmd.getOptionValue(InversionOptions.RUP_DOWNSAMPLE_DM.argName));
                rupSet = CommandLineInversionRunner.getDownsampledRupSet(rupSet, dm);
                System.out.println("Num rups after filtering: " + rupSet.getNumRuptures());
            }
            if (cmd.hasOption(InversionOptions.U2_MAPPED_RUPS_ONLY.argName)) {
                rupSet = CommandLineInversionRunner.getUCERF2RupsOnly(rupSet);
                System.out.println("Num rups after UCERF2 mapping: " + rupSet.getNumRuptures());
            }
            Map<IDPairing, Double> distsMap = rupSet.getSubSectionDistances();
            double mfdEqualityConstraintWt = 10.0;
            double mfdInequalityConstraintWt = 1000.0;
            if (branch.getValue(MomentRateFixes.class).isRelaxMFD()) {
                mfdEqualityConstraintWt = 1.0;
                mfdInequalityConstraintWt = 1.0;
            }
            System.out.println("Building Inversion Configuration");
            UCERF3InversionConfiguration config = UCERF3InversionConfiguration.forModel(branch.getValue(InversionModels.class), rupSet, rupSet.getFaultModel(), rupSet.getInversionTargetMFDs(), mfdEqualityConstraintWt, mfdInequalityConstraintWt, cmd);
            ArrayList<U3PaleoRateConstraint> paleoRateConstraints = CommandLineInversionRunner.getPaleoConstraints(branch.getValue(FaultModels.class), rupSet);
            PaleoProbabilityModel paleoProbabilityModel = UCERF3InversionInputGenerator.loadDefaultPaleoProbabilityModel();
            List<U3AveSlipConstraint> aveSlipConstraints = U3AveSlipConstraint.load(rupSet.getFaultSectionDataList());
            if (cmd.hasOption(InversionOptions.AVE_SLIP_SCALE.argName)) {
                double scale = Double.parseDouble(cmd.getOptionValue(InversionOptions.AVE_SLIP_SCALE.argName));
                System.out.println("Scaling ave slip by: " + scale);
                ArrayList<U3AveSlipConstraint> newConstraints = new ArrayList<U3AveSlipConstraint>();
                for (U3AveSlipConstraint constr : aveSlipConstraints) {
                    newConstraints.add(new U3AveSlipConstraint(constr.getSubSectionIndex(), constr.getSubSectionName(), scale * constr.getWeightedMean(), scale * constr.getUpperUncertaintyBound(), scale * constr.getLowerUncertaintyBound(), constr.getSiteLocation()));
                }
                aveSlipConstraints = newConstraints;
            }
            if (cmd.hasOption(InversionOptions.A_PRIORI_CONST_FOR_ZERO_RATES.argName)) {
                System.out.println("Setting a prior constraint for zero rates");
                config.setAPrioriConstraintForZeroRates(true);
            }
            UCERF3InversionInputGenerator gen = new UCERF3InversionInputGenerator(rupSet, config, paleoRateConstraints, aveSlipConstraints, null, paleoProbabilityModel);
            System.out.println("Building Inversion Inputs");
            gen.generateInputs();
            System.out.println("Writing RupSet");
            config.updateRupSetInfoString(rupSet);
            Object info = rupSet.getInfoString();
            info = (String)info + "\n\n" + CommandLineInversionRunner.getPreInversionInfo(rupSet);
            File rupSetFile = new File(subDir, prefix + "_rupSet.zip");
            U3FaultSystemIO.writeRupSet(rupSet, rupSetFile);
            rupSet = null;
            System.gc();
            System.out.println("Column Compressing");
            gen.columnCompress();
            DoubleMatrix2D A = gen.getA();
            double[] d = gen.getD();
            double[] initialState = gen.getInitialSolution();
            if (cmd.hasOption(InversionOptions.INITIAL_ZERO.argName)) {
                initialState = new double[initialState.length];
            }
            if (cmd.hasOption(InversionOptions.INITIAL_RANDOM.argName)) {
                initialState = new double[initialState.length];
                double minExp = -6.0;
                double maxExp = -10.0;
                double deltaExp = maxExp - minExp;
                for (int r = 0; r < initialState.length; ++r) {
                    initialState[r] = Math.pow(10.0, Math.random() * deltaExp + minExp);
                }
            }
            DoubleMatrix2D A_ineq = gen.getA_ineq();
            double[] d_ineq = gen.getD_ineq();
            double[] minimumRuptureRates = gen.getWaterLevelRates();
            List<ConstraintRange> constraintRanges = gen.getConstraintRowRanges();
            if (cmd.hasOption(InversionOptions.SYNTHETIC.argName)) {
                throw new UnsupportedOperationException("No longer supported");
            }
            for (int i = 0; i < constraintRanges.size(); ++i) {
                System.out.println(i + ". " + String.valueOf(constraintRanges.get(i)));
            }
            gen = null;
            System.gc();
            System.out.println("Creating TSA");
            ThreadedSimulatedAnnealing tsa = ThreadedSimulatedAnnealing.parseOptions(cmd, A, d, initialState, A_ineq, d_ineq, constraintRanges);
            initialState = Arrays.copyOf(initialState, initialState.length);
            CompletionCriteria criteria = ThreadedSimulatedAnnealing.parseCompletionCriteria(cmd);
            if (!(criteria instanceof ProgressTrackingCompletionCriteria)) {
                File csvFile = new File(dir, prefix + ".csv");
                criteria = new ProgressTrackingCompletionCriteria(criteria, csvFile);
            }
            if (cmd.hasOption(InversionOptions.SERIAL.argName)) {
                ((ProgressTrackingCompletionCriteria)criteria).setIterationModulus(10000L);
                tsa.setSubCompletionCriteria(criteria);
                tsa.setNumThreads(1);
            }
            System.out.println("Starting Annealing");
            tsa.iterate(criteria);
            System.out.println("Annealing DONE");
            info = (String)info + "\n";
            info = (String)info + "\n****** Simulated Annealing Metadata ******";
            info = (String)info + "\n" + tsa.getMetadata(args, criteria);
            ProgressTrackingCompletionCriteria pComp = (ProgressTrackingCompletionCriteria)criteria;
            AnnealingProgress progress = pComp.getProgress();
            long numPerturbs = progress.getNumPerturbations(progress.size() - 1);
            int numRups = initialState.length;
            info = (String)info + "\nAvg Perturbs Per Rup: " + numPerturbs + "/" + numRups + " = " + (double)numPerturbs / (double)numRups;
            int rupsPerturbed = 0;
            double[] solution_no_min_rates = tsa.getBestSolution();
            int numAboveWaterlevel = 0;
            for (int i = 0; i < numRups; ++i) {
                if ((float)solution_no_min_rates[i] != (float)initialState[i]) {
                    ++rupsPerturbed;
                }
                if (!(solution_no_min_rates[i] > 0.0)) continue;
                ++numAboveWaterlevel;
            }
            info = (String)info + "\nNum rups actually perturbed: " + rupsPerturbed + "/" + numRups + " (" + (float)(100.0 * ((double)rupsPerturbed / (double)numRups)) + " %)";
            info = (String)info + "\nAvg Perturbs Per Perturbed Rup: " + numPerturbs + "/" + rupsPerturbed + " = " + (double)numPerturbs / (double)rupsPerturbed;
            info = (String)info + "\nNum rups above waterlevel: " + numAboveWaterlevel + "/" + numRups + " (" + (float)(100.0 * ((double)numAboveWaterlevel / (double)numRups)) + " %)";
            info = (String)info + "\n******************************************";
            System.out.println("Writing solution bin files");
            tsa.writeBestSolution(new File(subDir, prefix + ".bin"), minimumRuptureRates);
            if (!lightweight) {
                System.out.println("Loading RupSet");
                InversionFaultSystemRupSet loadedRupSet = U3FaultSystemIO.loadInvRupSet(rupSetFile);
                loadedRupSet.setInfoString((String)info);
                double[] rupRateSolution = tsa.getBestSolution();
                rupRateSolution = UCERF3InversionInputGenerator.adjustSolutionForWaterLevel(rupRateSolution, minimumRuptureRates);
                Map<ConstraintRange, Double> energies = tsa.getEnergies();
                HashMap<String, Double> energiesMap = null;
                if (energies != null) {
                    energiesMap = new HashMap<String, Double>();
                    for (ConstraintRange range : energies.keySet()) {
                        energiesMap.put(range.shortName, energies.get(range));
                    }
                }
                InversionFaultSystemSolution sol = new InversionFaultSystemSolution(loadedRupSet, rupRateSolution, config, energiesMap);
                File solutionFile = new File(subDir, prefix + "_sol.zip");
                info = (String)info + "\n\n****** Moment and Rupture Rate Metatdata ******";
                info = (String)info + "\nOriginal File Name: " + solutionFile.getName() + "\nNum Ruptures: " + loadedRupSet.getNumRuptures();
                int numNonZeros = 0;
                for (double rate : sol.getRateForAllRups()) {
                    if (rate == 0.0) continue;
                    ++numNonZeros;
                }
                float percent = (float)numNonZeros / (float)loadedRupSet.getNumRuptures() * 100.0f;
                info = (String)info + "\nNum Non-Zero Rups: " + numNonZeros + "/" + loadedRupSet.getNumRuptures() + " (" + percent + " %)";
                info = (String)info + "\nOrig (creep reduced) Fault Moment Rate: " + loadedRupSet.getTotalOrigMomentRate();
                double momRed = loadedRupSet.getTotalMomentRateReduction();
                info = (String)info + "\nMoment Reduction (for subseismogenic ruptures only): " + momRed;
                info = (String)info + "\nSubseismo Moment Reduction Fraction (relative to creep reduced): " + loadedRupSet.getTotalMomentRateReductionFraction();
                info = (String)info + "\nFault Target Supra Seis Moment Rate (subseismo and creep reduced): " + loadedRupSet.getTotalReducedMomentRate();
                double totalSolutionMoment = sol.getTotalFaultSolutionMomentRate();
                info = (String)info + "\nFault Solution Supra Seis Moment Rate: " + totalSolutionMoment;
                info = (String)info + "\nFault Target Sub Seis Moment Rate: " + loadedRupSet.getInversionTargetMFDs().getTotalOnFaultSubSeisMFD().getTotalMomentRate();
                info = (String)info + "\nFault Solution Sub Seis Moment Rate: " + sol.getFinalTotalSubSeismoOnFaultMFD().getTotalMomentRate();
                info = (String)info + "\nTruly Off Fault Target Moment Rate: " + loadedRupSet.getInversionTargetMFDs().getTrulyOffFaultMFD().getTotalMomentRate();
                info = (String)info + "\nTruly Off Fault Solution Moment Rate: " + sol.getFinalTrulyOffFaultMFD().getTotalMomentRate();
                try {
                    info = (String)info + "\nTotal Moment Rate From Off Fault MFD: " + sol.getFinalTotalGriddedSeisMFD().getTotalMomentRate();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    System.out.println("WARNING: InversionFaultSystemSolution could not be instantiated!");
                }
                double totalMultiplyNamedM7Rate = FaultSystemRupSetCalc.calcTotRateMultiplyNamedFaults(sol, 7.0, null);
                double totalMultiplyNamedPaleoVisibleRate = FaultSystemRupSetCalc.calcTotRateMultiplyNamedFaults(sol, 0.0, paleoProbabilityModel);
                double totalM7Rate = FaultSystemRupSetCalc.calcTotRateAboveMag(sol, 7.0, null);
                double totalPaleoVisibleRate = FaultSystemRupSetCalc.calcTotRateAboveMag(sol, 0.0, paleoProbabilityModel);
                info = (String)info + "\n\nTotal rupture rate (M7+): " + totalM7Rate;
                info = (String)info + "\nTotal multiply named rupture rate (M7+): " + totalMultiplyNamedM7Rate;
                info = (String)info + "\n% of M7+ rate that are multiply named: " + 100.0 * totalMultiplyNamedM7Rate / totalM7Rate + " %";
                info = (String)info + "\nTotal paleo visible rupture rate: " + totalPaleoVisibleRate;
                info = (String)info + "\nTotal multiply named paleo visible rupture rate: " + totalMultiplyNamedPaleoVisibleRate;
                info = (String)info + "\n% of paleo visible rate that are multiply named: " + 100.0 * totalMultiplyNamedPaleoVisibleRate / totalPaleoVisibleRate + " %";
                info = (String)info + "\n***********************************************";
                ArrayList<ParentMomentRecord> parentMoRates = CommandLineInversionRunner.getSectionMoments(sol);
                info = (String)info + "\n\n****** Largest Moment Rate Discrepancies ******";
                for (int i = 0; i < 10 && i < parentMoRates.size(); ++i) {
                    Iterator<ParentMomentRecord> p = parentMoRates.get(i);
                    info = (String)info + "\n" + ((ParentMomentRecord)((Object)p)).parentID + ". " + ((ParentMomentRecord)((Object)p)).name + "\ttarget: " + ((ParentMomentRecord)((Object)p)).targetMoment + "\tsolution: " + ((ParentMomentRecord)((Object)p)).solutionMoment + "\tdiff: " + ((ParentMomentRecord)((Object)p)).getDiff();
                }
                info = (String)info + "\n**********************************************";
                if (!noPlots) {
                    try {
                        List<? extends DiscretizedFunc> funcs = CommandLineInversionRunner.writeMFDPlots(sol, subDir, prefix);
                        if (!funcs.isEmpty()) {
                            info = (String)info + "\n\n****** MFD Cumulative M5 Rates ******";
                            for (DiscretizedFunc discretizedFunc : funcs) {
                                double cumulative = 0.0;
                                int i = discretizedFunc.size();
                                while (--i >= 0 && discretizedFunc.getX(i) >= 5.0) {
                                    cumulative += discretizedFunc.getY(i);
                                }
                                info = (String)info + "\n" + discretizedFunc.getName() + ":\t" + cumulative;
                            }
                            info = (String)info + "\n**********************************************";
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                sol.setInfoString((String)info);
                System.out.println("Writing solution");
                U3FaultSystemIO.writeSol(sol, solutionFile);
                if (!noPlots) {
                    CSVFile moRateCSV = new CSVFile(true);
                    moRateCSV.addLine(Lists.newArrayList((Object[])new String[]{"ID", "Name", "Target", "Solution", "Diff"}));
                    for (ParentMomentRecord parentMomentRecord : parentMoRates) {
                        moRateCSV.addLine(Lists.newArrayList((Object[])new String[]{"" + parentMomentRecord.parentID, parentMomentRecord.name, "" + parentMomentRecord.targetMoment, "" + parentMomentRecord.solutionMoment, "" + parentMomentRecord.getDiff()}));
                    }
                    moRateCSV.writeToFile(new File(subDir, prefix + "_sect_mo_rates.csv"));
                    System.out.println("Writing Plots");
                    tsa.writePlots(criteria, subDir, prefix, minimumRuptureRates);
                    try {
                        CommandLineInversionRunner.writeJumpPlots(sol, distsMap, subDir, prefix);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    try {
                        CommandLineInversionRunner.writePaleoPlots(paleoRateConstraints, aveSlipConstraints, sol, subDir, prefix);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    try {
                        CommandLineInversionRunner.writeSAFSegPlots(sol, subDir, prefix);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    try {
                        CommandLineInversionRunner.writeParentSectionMFDPlots(sol, new File(subDir, PARENT_SECT_MFD_DIR_NAME));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    try {
                        CommandLineInversionRunner.writePaleoCorrelationPlots(sol, new File(subDir, PALEO_CORRELATION_DIR_NAME), paleoProbabilityModel);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    try {
                        Map<String, List<Integer>> namedFaultsMap = rupSet.getFaultModel().getNamedFaultsMapAlt();
                        CommandLineInversionRunner.writePaleoFaultPlots(paleoRateConstraints, aveSlipConstraints, namedFaultsMap, sol, new File(subDir, PALEO_FAULT_BASED_DIR_NAME));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    try {
                        CommandLineInversionRunner.writeRupPairingSmoothnessPlot(sol, prefix, subDir);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            FileWriter fw = new FileWriter(new File(subDir, prefix + "_metadata.txt"));
            fw.write((String)info);
            fw.close();
            System.out.println("Deleting RupSet (no longer needed)");
            rupSetFile.delete();
        }
        catch (MissingOptionException e) {
            System.err.println(e.getMessage());
            CommandLineInversionRunner.printHelp(options, mpj);
        }
        catch (ParseException e) {
            System.err.println(e.getMessage());
            CommandLineInversionRunner.printHelp(options, mpj);
        }
        catch (Exception e) {
            if (mpj) {
                MPJTaskCalculator.abortAndExit((Throwable)e);
            }
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static String getPreInversionInfo(InversionFaultSystemRupSet rupSet) {
        String[] dataVals;
        String data = rupSet.getPreInversionAnalysisData(true);
        String[] dataLines = data.split("\n");
        String header = dataLines[0];
        data = dataLines[1];
        String[] headerVals = header.trim().split("\t");
        Preconditions.checkState((headerVals.length == (dataVals = data.trim().split("\t")).length ? 1 : 0) != 0);
        Object info = "****** Pre Inversion Analysis ******";
        for (int i = 0; i < headerVals.length; ++i) {
            info = (String)info + "\n" + headerVals[i] + ": " + dataVals[i];
        }
        info = (String)info + "\n***********************************************";
        return info;
    }

    public static void writeJumpPlots(FaultSystemSolution sol, Map<IDPairing, Double> distsMap, File dir, String prefix) throws IOException {
        UCERF2_PaleoProbabilityModel paleoProbModel = new UCERF2_PaleoProbabilityModel();
        CommandLineInversionRunner.writeJumpPlot(sol, distsMap, dir, prefix, 1.0, 7.0, null);
        CommandLineInversionRunner.writeJumpPlot(sol, distsMap, dir, prefix, 1.0, 0.0, paleoProbModel);
    }

    public static EvenlyDiscretizedFunc[] getJumpFuncs(FaultSystemSolution sol, Map<IDPairing, Double> distsMap, double jumpDist, double minMag, PaleoProbabilityModel paleoProbModel) {
        EvenlyDiscretizedFunc solFunc = new EvenlyDiscretizedFunc(0.0, 4, 1.0);
        EvenlyDiscretizedFunc rupSetFunc = new EvenlyDiscretizedFunc(0.0, 4, 1.0);
        int maxX = solFunc.size() - 1;
        FaultSystemRupSet rupSet = sol.getRupSet();
        for (int r = 0; r < rupSet.getNumRuptures(); ++r) {
            double mag = rupSet.getMagForRup(r);
            if (mag < minMag) continue;
            List<Integer> sects = rupSet.getSectionsIndicesForRup(r);
            int jumpsOverDist = 0;
            for (int i = 1; i < sects.size(); ++i) {
                double dist;
                int parent2;
                int sect1 = sects.get(i - 1);
                int sect2 = sects.get(i);
                int parent1 = rupSet.getFaultSectionData(sect1).getParentSectionId();
                if (parent1 == (parent2 = rupSet.getFaultSectionData(sect2).getParentSectionId()) || !((dist = distsMap.get(new IDPairing(sect1, sect2)).doubleValue()) > jumpDist)) continue;
                ++jumpsOverDist;
            }
            double rate = sol.getRateForRup(r);
            if (paleoProbModel != null) {
                rate *= paleoProbModel.getProbPaleoVisible(mag, 0.5);
            }
            if (jumpsOverDist > maxX) continue;
            solFunc.set(jumpsOverDist, solFunc.getY(jumpsOverDist) + rate);
            rupSetFunc.set(jumpsOverDist, rupSetFunc.getY(jumpsOverDist) + 1.0);
        }
        double totY = solFunc.calcSumOfY_Vals();
        double origRupSetTotY = rupSetFunc.calcSumOfY_Vals();
        for (int i = 0; i < rupSetFunc.size(); ++i) {
            double y = rupSetFunc.getY(i);
            double fract = y / origRupSetTotY;
            double newY = totY * fract;
            rupSetFunc.set(i, newY);
        }
        EvenlyDiscretizedFunc[] ret = new EvenlyDiscretizedFunc[]{solFunc, rupSetFunc};
        return ret;
    }

    public static void writeJumpPlot(FaultSystemSolution sol, Map<IDPairing, Double> distsMap, File dir, String prefix, double jumpDist, double minMag, PaleoProbabilityModel paleoProbModel) throws IOException {
        DiscretizedFunc[] funcsArray = CommandLineInversionRunner.getJumpFuncs(sol, distsMap, jumpDist, minMag, paleoProbModel);
        CommandLineInversionRunner.writeJumpPlot(dir, prefix, funcsArray, jumpDist, minMag, paleoProbModel != null);
    }

    public static void writeJumpPlot(File dir, String prefix, DiscretizedFunc[] funcsArray, double jumpDist, double minMag, boolean paleoProb) throws IOException {
        DiscretizedFunc[] solFuncs = new DiscretizedFunc[]{funcsArray[0]};
        DiscretizedFunc[] rupSetFuncs = new DiscretizedFunc[]{funcsArray[1]};
        CommandLineInversionRunner.writeJumpPlot(dir, prefix, solFuncs, rupSetFuncs, jumpDist, minMag, paleoProb);
    }

    public static void writeJumpPlot(File dir, String prefix, DiscretizedFunc[] solFuncs, DiscretizedFunc[] rupSetFuncs, double jumpDist, double minMag, boolean paleoProb) throws IOException {
        ArrayList funcs = Lists.newArrayList();
        ArrayList chars = Lists.newArrayList();
        funcs.add(solFuncs[0]);
        funcs.add(rupSetFuncs[0]);
        chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, PlotSymbol.CIRCLE, 5.0f, Color.BLACK));
        chars.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 1.0f, PlotSymbol.CIRCLE, 3.0f, Color.RED));
        for (int i = 1; i < solFuncs.length; ++i) {
            funcs.add(solFuncs[i]);
            funcs.add(rupSetFuncs[i]);
            chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, PlotSymbol.CIRCLE, 5.0f, Color.BLACK));
            chars.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 1.0f, PlotSymbol.CIRCLE, 3.0f, Color.RED));
        }
        Object title = "Inversion Fault Jumps";
        prefix = CommandLineInversionRunner.getJumpFilePrefix(prefix, minMag, paleoProb);
        if (minMag > 0.0) {
            title = (String)title + " Mag " + (float)minMag + "+";
        }
        if (paleoProb) {
            title = (String)title + " (Convolved w/ ProbPaleoVisible)";
        }
        HeadlessGraphPanel gp = new HeadlessGraphPanel();
        CommandLineInversionRunner.setFontSizes(gp);
        gp.drawGraphPanel("Number of Jumps > " + (float)jumpDist + " km", "Rate", funcs, chars, (String)title);
        File file = new File(dir, prefix);
        gp.getChartPanel().setSize(1000, 800);
        gp.saveAsPDF(file.getAbsolutePath() + ".pdf");
        gp.saveAsPNG(file.getAbsolutePath() + ".png");
        gp.saveAsTXT(file.getAbsolutePath() + ".txt");
    }

    private static String getJumpFilePrefix(String prefix, double minMag, boolean probPaleoVisible) {
        prefix = (String)prefix + "_jumps";
        if (minMag > 0.0) {
            prefix = (String)prefix + "_m" + (float)minMag + "+";
        }
        if (probPaleoVisible) {
            prefix = (String)prefix + "_prob_paleo";
        }
        return prefix;
    }

    public static boolean doJumpPlotsExist(File dir, String prefix) {
        return CommandLineInversionRunner.doesJumpPlotExist(dir, prefix, 0.0, true);
    }

    private static boolean doesJumpPlotExist(File dir, String prefix, double minMag, boolean probPaleoVisible) {
        return new File(dir, CommandLineInversionRunner.getJumpFilePrefix(prefix, minMag, probPaleoVisible) + ".png").exists();
    }

    public static List<? extends DiscretizedFunc> writeMFDPlots(InversionFaultSystemSolution invSol, File dir, String prefix) throws IOException {
        UCERF2_MFD_ConstraintFetcher ucerf2Fetch = new UCERF2_MFD_ConstraintFetcher();
        CommandLineInversionRunner.writeMFDPlot(invSol, dir, prefix, invSol.getRupSet().getInversionTargetMFDs().getTotalTargetGR_NoCal(), invSol.getRupSet().getInversionTargetMFDs().noCalTargetSupraMFD, RELM_RegionUtils.getNoCalGriddedRegionInstance(), ucerf2Fetch);
        CommandLineInversionRunner.writeMFDPlot(invSol, dir, prefix, invSol.getRupSet().getInversionTargetMFDs().getTotalTargetGR_SoCal(), invSol.getRupSet().getInversionTargetMFDs().soCalTargetSupraMFD, RELM_RegionUtils.getSoCalGriddedRegionInstance(), ucerf2Fetch);
        return CommandLineInversionRunner.writeMFDPlot(invSol, dir, prefix, invSol.getRupSet().getInversionTargetMFDs().getTotalRegionalMFD(), invSol.getRupSet().getInversionTargetMFDs().getTotalOnFaultSupraSeisMFD(), RELM_RegionUtils.getGriddedRegionInstance(), ucerf2Fetch);
    }

    public static List<? extends DiscretizedFunc> writeMFDPlot(InversionFaultSystemSolution invSol, File dir, String prefix, IncrementalMagFreqDist totalMFD, IncrementalMagFreqDist targetMFD, Region region, UCERF2_MFD_ConstraintFetcher ucerf2Fetch) throws IOException {
        PlotSpec spec = invSol.getMFDPlots(totalMFD, targetMFD, region, ucerf2Fetch);
        HeadlessGraphPanel gp = invSol.getHeadlessMFDPlot(spec, totalMFD);
        File file = new File(dir, CommandLineInversionRunner.getMFDPrefix(prefix, region));
        gp.getChartPanel().setSize(1000, 800);
        gp.saveAsPDF(file.getAbsolutePath() + ".pdf");
        gp.saveAsPNG(file.getAbsolutePath() + ".png");
        gp.saveAsTXT(file.getAbsolutePath() + ".txt");
        return spec.getPlotElems();
    }

    private static String getMFDPrefix(String prefix, Region region) {
        String regName = region.getName();
        if (regName == null || regName.isEmpty()) {
            regName = "Uknown";
        }
        regName = regName.replaceAll(" ", "_");
        return prefix + "_MFD_" + regName;
    }

    public static boolean doMFDPlotsExist(File dir, String prefix) {
        return new File(dir, CommandLineInversionRunner.getMFDPrefix(prefix, RELM_RegionUtils.getGriddedRegionInstance()) + ".png").exists();
    }

    public static ArrayList<U3PaleoRateConstraint> getPaleoConstraints(FaultModels fm, FaultSystemRupSet rupSet) throws IOException {
        if (fm == FaultModels.FM2_1) {
            return UCERF2_PaleoRateConstraintFetcher.getConstraints(rupSet.getFaultSectionDataList());
        }
        return UCERF3_PaleoRateConstraintFetcher.getConstraints(rupSet.getFaultSectionDataList());
    }

    public static void writePaleoPlots(ArrayList<U3PaleoRateConstraint> paleoRateConstraints, List<U3AveSlipConstraint> aveSlipConstraints, InversionFaultSystemSolution sol, File dir, String prefix) throws IOException {
        HeadlessGraphPanel gp = PaleoFitPlotter.getHeadlessSegRateComparison(paleoRateConstraints, aveSlipConstraints, sol, true);
        File file = new File(dir, prefix + "_paleo_fit");
        gp.getChartPanel().setSize(1000, 800);
        gp.saveAsPDF(file.getAbsolutePath() + ".pdf");
        gp.saveAsPNG(file.getAbsolutePath() + ".png");
        gp.saveAsTXT(file.getAbsolutePath() + ".txt");
    }

    public static boolean doPaleoPlotsExist(File dir, String prefix) {
        return new File(dir, prefix + "_paleo_fit.png").exists();
    }

    public static void writeSAFSegPlots(InversionFaultSystemSolution sol, File dir, String prefix) throws IOException {
        CommandLineInversionRunner.writeSAFSegPlots(sol, sol.getRupSet().getFaultModel(), dir, prefix);
    }

    public static void writeSAFSegPlots(FaultSystemSolution sol, FaultModels fm, File dir, String prefix) throws IOException {
        List<Integer> parentSects = FaultSpecificSegmentationPlotGen.getSAFParents(fm);
        CommandLineInversionRunner.writeSAFSegPlot(sol, dir, prefix, parentSects, 0.0, false);
        CommandLineInversionRunner.writeSAFSegPlot(sol, dir, prefix, parentSects, 7.0, false);
        CommandLineInversionRunner.writeSAFSegPlot(sol, dir, prefix, parentSects, 7.5, false);
    }

    public static void writeSAFSegPlot(FaultSystemSolution sol, File dir, String prefix, List<Integer> parentSects, double minMag, boolean endsOnly) throws IOException {
        HeadlessGraphPanel gp = FaultSpecificSegmentationPlotGen.getSegmentationHeadlessGP(parentSects, sol, minMag, endsOnly);
        prefix = CommandLineInversionRunner.getSAFSegPrefix(prefix, minMag, endsOnly);
        File file = new File(dir, prefix);
        gp.getChartPanel().setSize(1000, 800);
        gp.saveAsPDF(file.getAbsolutePath() + ".pdf");
        gp.saveAsPNG(file.getAbsolutePath() + ".png");
        gp.saveAsTXT(file.getAbsolutePath() + ".txt");
    }

    private static String getSAFSegPrefix(String prefix, double minMag, boolean endsOnly) {
        prefix = (String)prefix + "_saf_seg";
        if (minMag > 5.0) {
            prefix = (String)prefix + (float)minMag + "+";
        }
        return prefix;
    }

    public static boolean doSAFSegPlotsExist(File dir, String prefix) {
        return new File(dir, CommandLineInversionRunner.getSAFSegPrefix(prefix, 7.5, false) + ".png").exists();
    }

    public static ArrayList<ParentMomentRecord> getSectionMoments(U3SlipEnabledSolution sol) {
        HashMap map = Maps.newHashMap();
        U3SlipEnabledRupSet rupSet = sol.getRupSet();
        for (int sectIndex = 0; sectIndex < rupSet.getNumSections(); ++sectIndex) {
            FaultSection sect = rupSet.getFaultSectionData(sectIndex);
            int parent = sect.getParentSectionId();
            if (!map.containsKey(parent)) {
                String name = sect.getName();
                if (name.contains(", Subsection")) {
                    name = name.substring(0, name.indexOf(", Subsection"));
                }
                map.put(parent, new ParentMomentRecord(parent, name, 0.0, 0.0));
            }
            ParentMomentRecord rec = (ParentMomentRecord)map.get(parent);
            double targetMo = rupSet.getReducedMomentRate(sectIndex);
            double solSlip = sol.calcSlipRateForSect(sectIndex);
            double solMo = FaultMomentCalc.getMoment(rupSet.getAreaForSection(sectIndex), solSlip);
            if (!Double.isNaN(targetMo)) {
                rec.targetMoment += targetMo;
            }
            if (Double.isNaN(solMo)) continue;
            rec.solutionMoment += solMo;
        }
        ArrayList<ParentMomentRecord> recs = new ArrayList<ParentMomentRecord>(map.values());
        Collections.sort(recs);
        Collections.reverse(recs);
        return recs;
    }

    public static void writeParentSectionMFDPlots(FaultSystemSolution sol, File dir) throws IOException {
        File nuclCmlSubDir;
        File nuclIncrSubDir;
        File particCmlSubDir;
        File particIncrSubDir;
        HashMap parentSects = Maps.newHashMap();
        if (!dir.exists()) {
            dir.mkdir();
        }
        if (!(particIncrSubDir = new File(dir, "participation_incremental")).exists()) {
            particIncrSubDir.mkdir();
        }
        if (!(particCmlSubDir = new File(dir, "participation_cumulative")).exists()) {
            particCmlSubDir.mkdir();
        }
        if (!(nuclIncrSubDir = new File(dir, "nucleation_incremental")).exists()) {
            nuclIncrSubDir.mkdir();
        }
        if (!(nuclCmlSubDir = new File(dir, "nucleation_cumulative")).exists()) {
            nuclCmlSubDir.mkdir();
        }
        for (FaultSection faultSection : sol.getRupSet().getFaultSectionDataList()) {
            if (parentSects.containsKey(faultSection.getParentSectionId())) continue;
            parentSects.put(faultSection.getParentSectionId(), faultSection.getParentSectionName());
        }
        double minMag = 5.05;
        double maxMag = 9.05;
        int numMag = (int)((maxMag - minMag) / 0.1) + 1;
        CSVFile<String> sdomOverMeanIncrParticCSV = null;
        CSVFile<String> stdDevOverMeanCmlParticCSV = null;
        CSVFile<String> meanIncrParticCSV = null;
        CSVFile<String> meanCmlParticCSV = null;
        boolean isAVG = sol instanceof U3AverageFaultSystemSolution;
        Iterator iterator = parentSects.keySet().iterator();
        while (iterator.hasNext()) {
            ArrayList subPlusSupraSeismoParticCmlMFDs;
            ArrayList subPlusSupraSeismoParticMFDs;
            ArrayList subPlusSupraSeismoNuclCmlMFDs;
            ArrayList subPlusSupraSeismoNuclMFDs;
            ArrayList subSeismoCmlMFDs;
            ArrayList subSeismoMFDs;
            int parentSectionID = (Integer)iterator.next();
            String parentSectName = (String)parentSects.get(parentSectionID);
            ArrayList nuclMFDs = Lists.newArrayList();
            ArrayList partMFDs = Lists.newArrayList();
            SummedMagFreqDist nuclMFD = sol.calcNucleationMFD_forParentSect(parentSectionID, minMag, maxMag, numMag);
            nuclMFDs.add(nuclMFD);
            IncrementalMagFreqDist partMFD = sol.calcParticipationMFD_forParentSect(parentSectionID, minMag, maxMag, numMag);
            partMFDs.add(partMFD);
            ArrayList nuclCmlMFDs = Lists.newArrayList();
            nuclCmlMFDs.add(nuclMFD.getCumRateDistWithOffset());
            ArrayList partCmlMFDs = Lists.newArrayList();
            EvenlyDiscretizedFunc partCmlMFD = partMFD.getCumRateDistWithOffset();
            partCmlMFDs.add(partCmlMFD);
            if (isAVG) {
                int i;
                U3AverageFaultSystemSolution avgSol = (U3AverageFaultSystemSolution)sol;
                double[] sdom_over_means = CommandLineInversionRunner.calcAveSolMFDs(avgSol, true, false, true, partMFDs, parentSectionID, minMag, maxMag, numMag);
                CommandLineInversionRunner.calcAveSolMFDs(avgSol, false, false, false, nuclMFDs, parentSectionID, minMag, maxMag, numMag);
                double[] std_dev_over_means = CommandLineInversionRunner.calcAveSolMFDs(avgSol, true, true, false, partCmlMFDs, parentSectionID, minMag, maxMag, numMag);
                CommandLineInversionRunner.calcAveSolMFDs(avgSol, false, true, false, nuclCmlMFDs, parentSectionID, minMag, maxMag, numMag);
                if (sdomOverMeanIncrParticCSV == null) {
                    sdomOverMeanIncrParticCSV = new CSVFile<String>(true);
                    meanIncrParticCSV = new CSVFile<String>(true);
                    ArrayList header = Lists.newArrayList((Object[])new String[]{"Parent ID", "Parent Name"});
                    for (i = 0; i < numMag; ++i) {
                        header.add("" + (float)nuclMFD.getX(i));
                    }
                    sdomOverMeanIncrParticCSV.addLine(header);
                    meanIncrParticCSV.addLine(header);
                    stdDevOverMeanCmlParticCSV = new CSVFile<String>(true);
                    meanCmlParticCSV = new CSVFile<String>(true);
                    header = Lists.newArrayList((Object[])new String[]{"Parent ID", "Parent Name"});
                    for (i = 0; i < numMag; ++i) {
                        header.add("" + (float)partCmlMFD.getX(i));
                    }
                    stdDevOverMeanCmlParticCSV.addLine(header);
                    meanCmlParticCSV.addLine(header);
                }
                ArrayList line = Lists.newArrayList();
                line.add("" + parentSectionID);
                line.add(parentSectName);
                for (i = 0; i < numMag; ++i) {
                    line.add("" + sdom_over_means[i]);
                }
                sdomOverMeanIncrParticCSV.addLine(line);
                line = Lists.newArrayList();
                line.add("" + parentSectionID);
                line.add(parentSectName);
                for (i = 0; i < numMag; ++i) {
                    line.add("" + partMFD.getY(i));
                }
                meanIncrParticCSV.addLine(line);
                line = Lists.newArrayList();
                line.add("" + parentSectionID);
                line.add(parentSectName);
                for (i = 0; i < numMag; ++i) {
                    line.add("" + std_dev_over_means[i]);
                }
                stdDevOverMeanCmlParticCSV.addLine(line);
                line = Lists.newArrayList();
                line.add("" + parentSectionID);
                line.add(parentSectName);
                for (i = 0; i < numMag; ++i) {
                    line.add("" + partCmlMFD.getY(i));
                }
                meanCmlParticCSV.addLine(line);
            }
            ArrayList<IncrementalMagFreqDist> ucerf2NuclMFDs = UCERF2_Section_MFDsCalc.getMeanMinAndMaxMFD(parentSectionID, false, false);
            ArrayList<IncrementalMagFreqDist> ucerf2NuclCmlMFDs = UCERF2_Section_MFDsCalc.getMeanMinAndMaxMFD(parentSectionID, false, true);
            ArrayList<IncrementalMagFreqDist> ucerf2PartMFDs = UCERF2_Section_MFDsCalc.getMeanMinAndMaxMFD(parentSectionID, true, false);
            ArrayList<IncrementalMagFreqDist> ucerf2PartCmlMFDs = UCERF2_Section_MFDsCalc.getMeanMinAndMaxMFD(parentSectionID, true, true);
            if (sol instanceof InversionFaultSystemSolution) {
                InversionFaultSystemSolution invSol = (InversionFaultSystemSolution)sol;
                subSeismoMFDs = Lists.newArrayList();
                subSeismoCmlMFDs = Lists.newArrayList();
                SummedMagFreqDist subSeismoMFD = invSol.getFinalSubSeismoOnFaultMFDForParent(parentSectionID);
                subSeismoMFDs.add(subSeismoMFD);
                subSeismoCmlMFDs.add(subSeismoMFD.getCumRateDistWithOffset());
                SummedMagFreqDist subPlusSupraSeismoNuclMFD = new SummedMagFreqDist(subSeismoMFD.getMinX(), subSeismoMFD.size(), subSeismoMFD.getDelta());
                subPlusSupraSeismoNuclMFD.addIncrementalMagFreqDist(subSeismoMFD);
                subPlusSupraSeismoNuclMFD.addIncrementalMagFreqDist(CommandLineInversionRunner.resizeToDimensions(nuclMFD, subSeismoMFD.getMinX(), subSeismoMFD.size(), subSeismoMFD.getDelta()));
                EvenlyDiscretizedFunc subPlusSupraSeismoNuclCmlMFD = subPlusSupraSeismoNuclMFD.getCumRateDistWithOffset();
                subPlusSupraSeismoNuclMFDs = Lists.newArrayList();
                subPlusSupraSeismoNuclCmlMFDs = Lists.newArrayList();
                subPlusSupraSeismoNuclMFDs.add(subPlusSupraSeismoNuclMFD);
                subPlusSupraSeismoNuclCmlMFDs.add(subPlusSupraSeismoNuclCmlMFD);
                SummedMagFreqDist subPlusSupraSeismoParticMFD = new SummedMagFreqDist(subSeismoMFD.getMinX(), subSeismoMFD.size(), subSeismoMFD.getDelta());
                subPlusSupraSeismoParticMFD.addIncrementalMagFreqDist(subSeismoMFD);
                subPlusSupraSeismoParticMFD.addIncrementalMagFreqDist(CommandLineInversionRunner.resizeToDimensions(partMFD, subSeismoMFD.getMinX(), subSeismoMFD.size(), subSeismoMFD.getDelta()));
                EvenlyDiscretizedFunc subPlusSupraSeismoParticCmlMFD = subPlusSupraSeismoParticMFD.getCumRateDistWithOffset();
                subPlusSupraSeismoParticMFDs = Lists.newArrayList();
                subPlusSupraSeismoParticCmlMFDs = Lists.newArrayList();
                subPlusSupraSeismoParticMFDs.add(subPlusSupraSeismoParticMFD);
                subPlusSupraSeismoParticCmlMFDs.add(subPlusSupraSeismoParticCmlMFD);
            } else {
                subSeismoMFDs = null;
                subSeismoCmlMFDs = null;
                subPlusSupraSeismoNuclMFDs = null;
                subPlusSupraSeismoNuclCmlMFDs = null;
                subPlusSupraSeismoParticMFDs = null;
                subPlusSupraSeismoParticCmlMFDs = null;
            }
            CommandLineInversionRunner.writeParentSectMFDPlot(nuclIncrSubDir, nuclMFDs, subSeismoMFDs, subPlusSupraSeismoNuclMFDs, ucerf2NuclMFDs, isAVG, parentSectionID, parentSectName, true, false);
            CommandLineInversionRunner.writeParentSectMFDPlot(nuclCmlSubDir, nuclCmlMFDs, subSeismoCmlMFDs, subPlusSupraSeismoNuclCmlMFDs, ucerf2NuclCmlMFDs, isAVG, parentSectionID, parentSectName, true, true);
            CommandLineInversionRunner.writeParentSectMFDPlot(particIncrSubDir, partMFDs, subSeismoMFDs, subPlusSupraSeismoParticMFDs, ucerf2PartMFDs, isAVG, parentSectionID, parentSectName, false, false);
            CommandLineInversionRunner.writeParentSectMFDPlot(particCmlSubDir, partCmlMFDs, subSeismoCmlMFDs, subPlusSupraSeismoParticCmlMFDs, ucerf2PartCmlMFDs, isAVG, parentSectionID, parentSectName, false, true);
        }
        Comparator<String> csvCompare = new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        };
        if (sdomOverMeanIncrParticCSV != null) {
            sdomOverMeanIncrParticCSV.sort(1, 1, csvCompare);
            sdomOverMeanIncrParticCSV.writeToFile(new File(dir, "participation_sdom_over_means.csv"));
            meanIncrParticCSV.sort(1, 1, csvCompare);
            meanIncrParticCSV.writeToFile(new File(dir, "participation_means.csv"));
        }
        if (stdDevOverMeanCmlParticCSV != null) {
            stdDevOverMeanCmlParticCSV.sort(1, 1, csvCompare);
            stdDevOverMeanCmlParticCSV.writeToFile(new File(dir, "participation_cumulative_std_dev_over_means.csv"));
            meanCmlParticCSV.sort(1, 1, csvCompare);
            meanCmlParticCSV.writeToFile(new File(dir, "participation_cumulative_means.csv"));
        }
    }

    private static IncrementalMagFreqDist resizeToDimensions(IncrementalMagFreqDist mfd, double min, int num, double delta) {
        if (mfd.getMinX() == min && mfd.size() == num && mfd.getDelta() == delta) {
            return mfd;
        }
        IncrementalMagFreqDist resized = new IncrementalMagFreqDist(min, num, delta);
        for (int i = 0; i < mfd.size(); ++i) {
            if (!(mfd.getY(i) > 0.0)) continue;
            resized.set(mfd.get(i));
        }
        return resized;
    }

    private static double[] calcAveSolMFDs(U3AverageFaultSystemSolution avgSol, boolean participation, boolean cumulative, boolean ret_sdom, List<EvenlyDiscretizedFunc> mfds, int parentSectionID, double minMag, double maxMag, int numMag) {
        EvenlyDiscretizedFunc meanMFD = mfds.get(0);
        double[] means = new double[numMag];
        for (int i = 0; i < numMag; ++i) {
            means[i] = meanMFD.getY(i);
        }
        double[] sdom_over_means = new double[numMag];
        int numSols = avgSol.getNumSolutions();
        double[][] mfdVals = new double[numMag][numSols];
        int cnt = 0;
        for (FaultSystemSolution sol : avgSol) {
            IncrementalMagFreqDist mfd = participation ? sol.calcParticipationMFD_forParentSect(parentSectionID, minMag, maxMag, numMag) : sol.calcNucleationMFD_forParentSect(parentSectionID, minMag, maxMag, numMag);
            EvenlyDiscretizedFunc theMFD = cumulative ? mfd.getCumRateDistWithOffset() : mfd;
            for (int i = 0; i < numMag; ++i) {
                mfdVals[i][cnt] = theMFD.getY(i);
            }
            ++cnt;
        }
        minMag = meanMFD.getMinX();
        maxMag = meanMFD.getMaxX();
        IncrementalMagFreqDist meanPlusSDOM = new IncrementalMagFreqDist(minMag, maxMag, numMag);
        IncrementalMagFreqDist meanMinusSDOM = new IncrementalMagFreqDist(minMag, maxMag, numMag);
        IncrementalMagFreqDist meanPlusStdDev = new IncrementalMagFreqDist(minMag, maxMag, numMag);
        IncrementalMagFreqDist meanMinusStdDev = new IncrementalMagFreqDist(minMag, maxMag, numMag);
        IncrementalMagFreqDist minFunc = new IncrementalMagFreqDist(minMag, maxMag, numMag);
        IncrementalMagFreqDist maxFunc = new IncrementalMagFreqDist(minMag, maxMag, numMag);
        for (int i = 0; i < numMag; ++i) {
            double mean = means[i];
            if (mean == 0.0) continue;
            double stdDev = Math.sqrt(StatUtils.variance((double[])mfdVals[i], (double)mean));
            double sdom = stdDev / Math.sqrt(numSols);
            double min = StatUtils.min((double[])mfdVals[i]);
            double max = StatUtils.max((double[])mfdVals[i]);
            meanPlusSDOM.set(i, mean + sdom);
            meanMinusSDOM.set(i, mean - sdom);
            meanPlusStdDev.set(i, mean + stdDev);
            meanMinusStdDev.set(i, mean - stdDev);
            minFunc.set(i, min);
            maxFunc.set(i, max);
            sdom_over_means[i] = ret_sdom ? sdom / mean : stdDev / mean;
        }
        mfds.add(meanPlusSDOM);
        mfds.add(meanMinusSDOM);
        mfds.add(meanPlusStdDev);
        mfds.add(meanMinusStdDev);
        mfds.add(minFunc);
        mfds.add(maxFunc);
        return sdom_over_means;
    }

    private static DiscretizedFunc getRIFunc(EvenlyDiscretizedFunc cmlFunc, String name) {
        int i;
        ArbitrarilyDiscretizedFunc riCmlFunc = new ArbitrarilyDiscretizedFunc();
        riCmlFunc.setName(name);
        String info = cmlFunc.getInfo();
        Object newInfo = " ";
        if (info != null && info.length() > 1) {
            newInfo = null;
            for (String line : Splitter.on((String)"\n").split((CharSequence)info)) {
                if (!line.contains("RI")) continue;
                newInfo = newInfo == null ? "" : (String)newInfo + "\n";
                newInfo = (String)newInfo + line;
            }
            if (newInfo == null) {
                newInfo = " ";
            }
        }
        riCmlFunc.setInfo((String)newInfo);
        for (i = 0; i < cmlFunc.size(); ++i) {
            double y = cmlFunc.getY(i);
            if (!(y > 0.0)) continue;
            riCmlFunc.set(cmlFunc.getX(i), 1.0 / y);
        }
        if (riCmlFunc.size() == 0) {
            for (i = 0; i < cmlFunc.size(); ++i) {
                riCmlFunc.set(cmlFunc.getX(i), 0.0);
            }
        }
        return riCmlFunc;
    }

    public static void writeParentSectMFDPlot(File dir, List<? extends EvenlyDiscretizedFunc> supraSeismoMFDs, List<? extends EvenlyDiscretizedFunc> subSeismoMFDs, List<? extends EvenlyDiscretizedFunc> subPlusSupraSeismoMFDs, List<? extends EvenlyDiscretizedFunc> ucerf2MFDs, boolean avgColoring, int id, String name, boolean nucleation, boolean cumulative) throws IOException {
        Object yAxisLabel;
        double minX;
        EvenlyDiscretizedFunc mfd;
        HeadlessGraphPanel gp = new HeadlessGraphPanel();
        CommandLineInversionRunner.setFontSizes(gp);
        gp.setYLog(true);
        gp.setRenderingOrder(DatasetRenderingOrder.FORWARD);
        ArrayList funcs = Lists.newArrayList();
        ArrayList chars = Lists.newArrayList();
        if (supraSeismoMFDs.size() == 1 || avgColoring) {
            mfd = supraSeismoMFDs.get(0);
            mfd.setName("Incremental MFD");
            funcs.add(mfd);
            chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLUE));
            if (subSeismoMFDs != null) {
                funcs.add((DiscretizedFunc)subSeismoMFDs.get(0));
                chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 4.0f, Color.GRAY));
                funcs.add((DiscretizedFunc)subPlusSupraSeismoMFDs.get(0));
                chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 4.0f, Color.BLACK));
            }
            if (avgColoring) {
                funcs.add((DiscretizedFunc)supraSeismoMFDs.get(1));
                funcs.add((DiscretizedFunc)supraSeismoMFDs.get(2));
                PlotCurveCharacterstics pchar = new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, Color.BLUE);
                chars.add(pchar);
                chars.add(pchar);
                funcs.add((DiscretizedFunc)supraSeismoMFDs.get(3));
                funcs.add((DiscretizedFunc)supraSeismoMFDs.get(4));
                pchar = new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, Color.GREEN);
                chars.add(pchar);
                chars.add(pchar);
                funcs.add((DiscretizedFunc)supraSeismoMFDs.get(5));
                funcs.add((DiscretizedFunc)supraSeismoMFDs.get(6));
                pchar = new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, Color.GRAY);
                chars.add(pchar);
                chars.add(pchar);
            }
        } else {
            int numFractiles = supraSeismoMFDs.size() - 3;
            mfd = supraSeismoMFDs.get(supraSeismoMFDs.size() - 3);
            funcs.addAll(supraSeismoMFDs);
            chars.addAll(CompoundFSSPlots.getFractileChars(Color.BLUE, Color.MAGENTA, numFractiles));
            numFractiles = subSeismoMFDs.size() - 3;
            funcs.addAll(subSeismoMFDs);
            chars.addAll(CompoundFSSPlots.getFractileChars(Color.CYAN, Color.MAGENTA, numFractiles));
            funcs.addAll(subPlusSupraSeismoMFDs);
            chars.addAll(CompoundFSSPlots.getFractileChars(Color.BLACK, Color.MAGENTA, numFractiles));
        }
        if (ucerf2MFDs != null) {
            for (EvenlyDiscretizedFunc evenlyDiscretizedFunc : ucerf2MFDs) {
                evenlyDiscretizedFunc.setName("UCERF2 " + evenlyDiscretizedFunc.getName());
            }
            EvenlyDiscretizedFunc meanMFD = ucerf2MFDs.get(0);
            funcs.add(meanMFD);
            chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 4.0f, Color.RED));
            EvenlyDiscretizedFunc evenlyDiscretizedFunc = ucerf2MFDs.get(1);
            funcs.add(evenlyDiscretizedFunc);
            chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, Color.RED));
            EvenlyDiscretizedFunc maxMFD = ucerf2MFDs.get(2);
            funcs.add(maxMFD);
            chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, Color.RED));
        }
        if ((minX = mfd.getMinX()) < 5.0) {
            minX = 5.0;
        }
        gp.setUserBounds(minX, mfd.getMaxX(), 1.0E-10, 0.1);
        Object fname = name.replaceAll("\\W+", "_");
        if (cumulative) {
            fname = (String)fname + "_cumulative";
        }
        if (nucleation) {
            yAxisLabel = "Nucleation Rate";
            fname = (String)fname + "_nucleation";
        } else {
            yAxisLabel = "Participation Rate";
            fname = (String)fname + "_participation";
        }
        String title = name;
        yAxisLabel = (String)yAxisLabel + " (per yr)";
        gp.setRenderingOrder(DatasetRenderingOrder.REVERSE);
        gp.drawGraphPanel("Magnitude", (String)yAxisLabel, funcs, chars, title);
        File file = new File(dir, (String)fname);
        gp.getChartPanel().setSize(1000, 800);
        gp.saveAsPDF(file.getAbsolutePath() + ".pdf");
        gp.saveAsPNG(file.getAbsolutePath() + ".png");
        gp.saveAsTXT(file.getAbsolutePath() + ".txt");
        File smallDir = new File(dir.getParentFile(), "small_MFD_plots");
        if (!smallDir.exists()) {
            smallDir.mkdir();
        }
        file = new File(smallDir, (String)fname + "_small");
        gp.getChartPanel().setSize(500, 400);
        gp.saveAsPDF(file.getAbsolutePath() + ".pdf");
        gp.saveAsPNG(file.getAbsolutePath() + ".png");
        gp.getChartPanel().setSize(1000, 800);
    }

    public static void writePaleoCorrelationPlots(InversionFaultSystemSolution sol, File dir, PaleoProbabilityModel paleoProb) throws IOException {
        Map<String, Table<String, String, PaleoSiteCorrelationData>> tables = PaleoSiteCorrelationData.loadPaleoCorrelationData(sol);
        HashMap specMap = Maps.newHashMap();
        for (String faultName : tables.keySet()) {
            specMap.put(faultName, PaleoSiteCorrelationData.getCorrelationPlotSpec(faultName, tables.get(faultName), sol, paleoProb));
        }
        CommandLineInversionRunner.writePaleoCorrelationPlots(dir, specMap);
    }

    public static void writePaleoCorrelationPlots(File dir, Map<String, PlotSpec> specMap) throws IOException {
        if (!dir.exists()) {
            dir.mkdir();
        }
        for (String faultName : specMap.keySet()) {
            String fname = faultName.replaceAll("\\W+", "_");
            PlotSpec spec = specMap.get(faultName);
            double maxX = 0.0;
            for (DiscretizedFunc func : spec.getPlotFunctionsOnly()) {
                double myMaxX = func.getMaxX();
                if (!(myMaxX > maxX)) continue;
                maxX = myMaxX;
            }
            HeadlessGraphPanel gp = new HeadlessGraphPanel();
            CommandLineInversionRunner.setFontSizes(gp);
            gp.setUserBounds(0.0, maxX, -0.05, 1.05);
            gp.drawGraphPanel(spec.getXAxisLabel(), spec.getYAxisLabel(), spec.getPlotElems(), spec.getChars(), spec.getTitle());
            File file = new File(dir, fname);
            gp.getChartPanel().setSize(1000, 800);
            gp.saveAsPDF(file.getAbsolutePath() + ".pdf");
            gp.saveAsPNG(file.getAbsolutePath() + ".png");
            gp.saveAsTXT(file.getAbsolutePath() + ".txt");
        }
    }

    public static void writePaleoFaultPlots(List<U3PaleoRateConstraint> paleoRateConstraints, List<U3AveSlipConstraint> aveSlipConstraints, Map<String, List<Integer>> namedFaultsMap, U3SlipEnabledSolution sol, File dir) throws IOException {
        Map<String, PlotSpec[]> specs = PaleoFitPlotter.getFaultSpecificPaleoPlotSpec(paleoRateConstraints, aveSlipConstraints, namedFaultsMap, sol);
        CommandLineInversionRunner.writePaleoFaultPlots(specs, null, dir);
    }

    public static void writePaleoFaultPlots(Map<String, PlotSpec[]> specs, String prefix, File dir) throws IOException {
        String[] fname_adds = new String[]{"paleo_rate", "slip_rate", "ave_event_slip"};
        if (!dir.exists()) {
            dir.mkdir();
        }
        for (String faultName : specs.keySet()) {
            Object fname = faultName.replaceAll("\\W+", "_");
            if (prefix != null && !prefix.isEmpty()) {
                fname = prefix + "_" + (String)fname;
            }
            PlotSpec[] specArray = specs.get(faultName);
            double xMin = Double.POSITIVE_INFINITY;
            double xMax = Double.NEGATIVE_INFINITY;
            for (DiscretizedFunc func : specArray[2].getPlotFunctionsOnly()) {
                double myXMin = func.getMinX();
                double myXMax = func.getMaxX();
                if (myXMin < xMin) {
                    xMin = myXMin;
                }
                if (!(myXMax > xMax)) continue;
                xMax = myXMax;
            }
            Range xRange = null;
            Range slipYRange = null;
            Range paleoYRange = null;
            for (int i = 0; i < specArray.length; ++i) {
                String fname_add = fname_adds[i];
                PlotSpec spec = specArray[i];
                HeadlessGraphPanel gp = new HeadlessGraphPanel();
                CommandLineInversionRunner.setFontSizes(gp);
                gp.setBackgroundColor(Color.WHITE);
                if (i != 2) {
                    gp.setYLog(true);
                }
                if (xMax > 0.0) {
                    gp.setxAxisInverted(true);
                }
                ArrayList yValsList = Lists.newArrayList();
                ArrayList confYValsList = Lists.newArrayList();
                for (DiscretizedFunc func : spec.getPlotFunctionsOnly()) {
                    if (func.getName().contains("separator")) continue;
                    if (func.getName().contains("Confidence")) {
                        for (Point2D pt : func) {
                            confYValsList.add(pt.getY());
                        }
                    }
                    for (Point2D pt : func) {
                        yValsList.add(pt.getY());
                    }
                }
                Collections.sort(yValsList);
                Collections.sort(confYValsList);
                double yMax = (Double)yValsList.get(yValsList.size() - 1);
                double yMin = (Double)yValsList.get((int)((double)yValsList.size() * 0.005));
                if (confYValsList.size() > 0 && yMin > (Double)confYValsList.get(1)) {
                    yMin = (Double)confYValsList.get(1);
                }
                double origYMax = yMax;
                double origYMin = yMin;
                if (!gp.getYLog()) {
                    yMax += yMax * 0.1;
                    yMin -= yMin * 0.1;
                } else {
                    yMax = Math.log10(yMax);
                    yMin = Math.log10(yMin);
                    yMax += Math.abs(yMax * 0.1);
                    yMin -= Math.abs(yMin * 0.1);
                    yMax = Math.pow(10.0, yMax);
                    yMin = Math.pow(10.0, yMin);
                }
                System.out.println(faultName);
                System.out.println("Total Y Range: " + String.valueOf(yValsList.get(0)) + "=>" + String.valueOf(yValsList.get(yValsList.size() - 1)));
                System.out.println("Orig Y Range: " + origYMin + "=>" + origYMax);
                System.out.println("X Range: " + xMin + "=>" + xMax + ", Y Range: " + yMin + "=>" + yMax);
                Preconditions.checkState((yMax >= origYMax ? 1 : 0) != 0);
                Preconditions.checkState((yMin <= origYMin ? 1 : 0) != 0);
                gp.setUserBounds(xMin, xMax, yMin, yMax);
                if (spec.getPlotAnnotations() != null) {
                    ArrayList newAnnotations = Lists.newArrayList();
                    for (XYAnnotation a : spec.getPlotAnnotations()) {
                        if (a instanceof XYTextAnnotation) {
                            try {
                                XYTextAnnotation t = (XYTextAnnotation)((XYTextAnnotation)a).clone();
                                t.setY(yMax);
                                newAnnotations.add(t);
                            }
                            catch (CloneNotSupportedException e) {
                                ExceptionUtils.throwAsRuntimeException(e);
                            }
                        } else {
                            newAnnotations.add(a);
                        }
                        spec.setPlotAnnotations(newAnnotations);
                    }
                }
                gp.drawGraphPanel(spec);
                File file = new File(dir, (String)fname + "_" + fname_add);
                gp.getChartPanel().setSize(1000, 500);
                gp.saveAsPDF(file.getAbsolutePath() + ".pdf");
                gp.saveAsPNG(file.getAbsolutePath() + ".png");
                gp.saveAsTXT(file.getAbsolutePath() + ".txt");
                if (i == 0) {
                    xRange = new Range(xMin, xMax);
                    paleoYRange = new Range(yMin, yMax);
                    continue;
                }
                if (i != 1) continue;
                slipYRange = new Range(yMin, yMax);
            }
            PlotSpec slipSpec = specArray[1];
            PlotSpec paleoSpec = specArray[0];
            paleoSpec.setPlotAnnotations(null);
            ArrayList combinedSpecs = Lists.newArrayList((Object[])new PlotSpec[]{slipSpec, paleoSpec});
            ArrayList xRanges = Lists.newArrayList((Object[])new Range[]{xRange});
            ArrayList yRanges = Lists.newArrayList((Object[])new Range[]{slipYRange, paleoYRange});
            HeadlessGraphPanel gp = new HeadlessGraphPanel();
            CommandLineInversionRunner.setFontSizes(gp);
            gp.setBackgroundColor(Color.WHITE);
            if (xMax > 0.0) {
                gp.setxAxisInverted(true);
            }
            gp.drawGraphPanel((List<? extends PlotSpec>)combinedSpecs, false, true, (List<Range>)xRanges, (List<Range>)yRanges);
            File file = new File(dir, (String)fname + "_combined");
            gp.getChartPanel().setSize(1000, 800);
            gp.saveAsPDF(file.getAbsolutePath() + ".pdf");
            gp.saveAsPNG(file.getAbsolutePath() + ".png");
            gp.saveAsTXT(file.getAbsolutePath() + ".txt");
        }
    }

    public static void writeRupPairingSmoothnessPlot(FaultSystemSolution sol, String prefix, File dir) throws IOException {
        List<IDPairing> pairings = RupRateSmoothingInversionConstraint.getRupSmoothingPairings(sol.getRupSet());
        double[] diffs = new double[pairings.size()];
        double[] fracts = new double[pairings.size()];
        for (int i = 0; i < diffs.length; ++i) {
            IDPairing pair = pairings.get(i);
            double r1 = sol.getRateForRup(pair.getID1());
            double r2 = sol.getRateForRup(pair.getID2());
            double diff = Math.abs(r1 - r2);
            double meanRate = 0.5 * (r1 + r2);
            diffs[i] = diff;
            if (!(meanRate > 0.0)) continue;
            fracts[i] = diff / meanRate;
        }
        Arrays.sort(diffs);
        Arrays.sort(fracts);
        EvenlyDiscretizedFunc diffVsRankFunc = new EvenlyDiscretizedFunc(0.0, pairings.size(), 1.0);
        EvenlyDiscretizedFunc fractVsRankFunc = new EvenlyDiscretizedFunc(0.0, pairings.size(), 1.0);
        int index = 0;
        int i = diffs.length;
        while (--i >= 0) {
            diffVsRankFunc.set(index, diffs[i]);
            fractVsRankFunc.set(index++, fracts[i]);
        }
        ArrayList funcs = Lists.newArrayList();
        funcs.add(diffVsRankFunc);
        ArrayList chars = Lists.newArrayList();
        chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLACK));
        HeadlessGraphPanel gp = new HeadlessGraphPanel();
        CommandLineInversionRunner.setFontSizes(gp);
        gp.setBackgroundColor(Color.WHITE);
        gp.setYLog(true);
        gp.drawGraphPanel("Rank", "abs(rate1 - rate2)", funcs, chars, "Rupture Pairing Smoothness");
        File file = new File(dir, prefix + "_rup_smooth_pairings");
        gp.getChartPanel().setSize(1000, 800);
        gp.saveAsPNG(file.getAbsolutePath() + ".png");
        gp.saveAsPDF(file.getAbsolutePath() + ".pdf");
        funcs.clear();
        funcs.add(fractVsRankFunc);
        gp = new HeadlessGraphPanel();
        CommandLineInversionRunner.setFontSizes(gp);
        gp.setBackgroundColor(Color.WHITE);
        gp.setYLog(true);
        gp.drawGraphPanel("Rank", "abs(rate1 - rate2)/(mean rate)", funcs, chars, "Rupture Pairing Smoothness Fractions");
        file = new File(dir, prefix + "_rup_smooth_pairings_fract");
        gp.getChartPanel().setSize(1000, 800);
        gp.saveAsPNG(file.getAbsolutePath() + ".png");
        gp.saveAsPDF(file.getAbsolutePath() + ".pdf");
    }

    public static InversionFaultSystemRupSet getUCERF2RupsOnly(InversionFaultSystemRupSet rupSet) {
        ArrayList<double[]> ucerf2_magsAndRates = UCERF3InversionConfiguration.getUCERF2MagsAndrates(rupSet);
        int newNumRups = 0;
        for (double[] u2Vals : ucerf2_magsAndRates) {
            if (u2Vals == null) continue;
            ++newNumRups;
        }
        ArrayList sectionForRups = Lists.newArrayList();
        double[] mags = new double[newNumRups];
        double[] rakes = new double[newNumRups];
        double[] rupAreas = new double[newNumRups];
        double[] rupLengths = new double[newNumRups];
        double[] rupAveSlips = new double[newNumRups];
        int cnt = 0;
        for (int r = 0; r < ucerf2_magsAndRates.size(); ++r) {
            if (ucerf2_magsAndRates.get(r) == null) continue;
            sectionForRups.add(rupSet.getSectionsIndicesForRup(r));
            mags[cnt] = rupSet.getMagForRup(r);
            rakes[cnt] = rupSet.getAveRakeForRup(r);
            rupAreas[cnt] = rupSet.getAreaForRup(r);
            rupLengths[cnt] = rupSet.getLengthForRup(r);
            rupAveSlips[cnt] = rupSet.getAveSlipForRup(r);
            ++cnt;
        }
        FaultSystemRupSet subset = new FaultSystemRupSet(rupSet.getFaultSectionDataList(), sectionForRups, mags, rakes, rupAreas, rupLengths);
        subset.setInfoString(rupSet.getInfoString());
        return new InversionFaultSystemRupSet(subset, rupSet.getLogicTreeBranch(), rupSet.getOldPlausibilityConfiguration(), rupAveSlips, null, null, null);
    }

    public static InversionFaultSystemRupSet getFilteredRupsOnly(InversionFaultSystemRupSet rupSet, File file) throws IOException {
        Preconditions.checkArgument((boolean)file.exists());
        ArrayList rupIndexes = Lists.newArrayList();
        FileWriter mappingFW = new FileWriter(new File(file.getAbsolutePath() + ".mappings"));
        mappingFW.write("# OrigID\tMappedID\n");
        for (String line : Files.readLines((File)file, (Charset)Charset.defaultCharset())) {
            if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
            int rupIndex = Integer.parseInt(line);
            mappingFW.write(rupIndex + "\t" + rupIndexes.size() + "\n");
            rupIndexes.add(rupIndex);
        }
        mappingFW.close();
        ArrayList sectionForRups = Lists.newArrayList();
        double[] mags = new double[rupIndexes.size()];
        double[] rakes = new double[rupIndexes.size()];
        double[] rupAreas = new double[rupIndexes.size()];
        double[] rupLengths = new double[rupIndexes.size()];
        double[] rupAveSlips = new double[rupIndexes.size()];
        for (int i = 0; i < rupIndexes.size(); ++i) {
            int rupIndex = (Integer)rupIndexes.get(i);
            sectionForRups.add(rupSet.getSectionsIndicesForRup(rupIndex));
            mags[i] = rupSet.getMagForRup(rupIndex);
            rakes[i] = rupSet.getAveRakeForRup(rupIndex);
            rupAreas[i] = rupSet.getAreaForRup(rupIndex);
            rupLengths[i] = rupSet.getLengthForRup(rupIndex);
            rupAveSlips[i] = rupSet.getAveSlipForRup(rupIndex);
        }
        FaultSystemRupSet subset = new FaultSystemRupSet(rupSet.getFaultSectionDataList(), sectionForRups, mags, rakes, rupAreas, rupLengths);
        subset.setInfoString(rupSet.getInfoString());
        return new InversionFaultSystemRupSet(subset, rupSet.getLogicTreeBranch(), rupSet.getOldPlausibilityConfiguration(), rupAveSlips, null, null, null);
    }

    public static InversionFaultSystemRupSet getDownsampledRupSet(InversionFaultSystemRupSet rupSet, double dm) {
        List<Integer> rupIndexes = new RupSetDownsampler(rupSet, dm).getRuptures();
        ArrayList sectionForRups = Lists.newArrayList();
        double[] mags = new double[rupIndexes.size()];
        double[] rakes = new double[rupIndexes.size()];
        double[] rupAreas = new double[rupIndexes.size()];
        double[] rupLengths = new double[rupIndexes.size()];
        double[] rupAveSlips = new double[rupIndexes.size()];
        for (int i = 0; i < rupIndexes.size(); ++i) {
            int rupIndex = rupIndexes.get(i);
            sectionForRups.add(rupSet.getSectionsIndicesForRup(rupIndex));
            mags[i] = rupSet.getMagForRup(rupIndex);
            rakes[i] = rupSet.getAveRakeForRup(rupIndex);
            rupAreas[i] = rupSet.getAreaForRup(rupIndex);
            rupLengths[i] = rupSet.getLengthForRup(rupIndex);
            rupAveSlips[i] = rupSet.getAveSlipForRup(rupIndex);
        }
        FaultSystemRupSet subset = new FaultSystemRupSet(rupSet.getFaultSectionDataList(), sectionForRups, mags, rakes, rupAreas, rupLengths);
        subset.setInfoString(rupSet.getInfoString());
        return new InversionFaultSystemRupSet(subset, rupSet.getLogicTreeBranch(), rupSet.getOldPlausibilityConfiguration(), rupAveSlips, null, null, null);
    }

    public static boolean doRupPairingSmoothnessPlotsExist(File dir, String prefix) {
        return new File(dir, prefix + "_rup_smooth_pairings.png").exists();
    }

    public static void setFontSizes(HeadlessGraphPanel gp) {
        gp.setTickLabelFontSize(18);
        gp.setAxisLabelFontSize(20);
        gp.setPlotLabelFontSize(21);
        gp.setBackgroundColor(Color.WHITE);
    }

    public static enum InversionOptions {
        DEFAULT_ASEISMICITY("aseis", "default-aseis", "Aseis", true, "Default Aseismicity Value"),
        A_PRIORI_CONST_FOR_ZERO_RATES("apz", "a-priori-zero", "APrioriZero", false, "Flag to apply a priori constraint to zero rate ruptures"),
        A_PRIORI_CONST_WT("apwt", "a-priori-wt", "APrioriWt", true, "A priori constraint weight"),
        WATER_LEVEL_FRACT("wtlv", "waterlevel", "Waterlevel", true, "Waterlevel fraction"),
        PARKFIELD_WT("pkfld", "parkfield-wt", "Parkfield", true, "Parkfield constraint weight"),
        PALEO_WT("paleo", "paleo-wt", "Paleo", true, "Paleoconstraint weight"),
        AVE_SLIP_WT("aveslip", "ave-slip-wt", "AveSlip", true, "Ave slip weight"),
        MFD_WT("mfd", "mfd-wt", "MFDWt", true, "MFD constraint weight"),
        INITIAL_ZERO("zeros", "initial-zeros", "Zeros", false, "Force initial state to zeros"),
        INITIAL_GR("inigr", "initial-gr", "StartGR", false, "GR starting model"),
        INITIAL_RANDOM("random", "initial-random", "RandStart", false, "Force initial state to random distribution"),
        EVENT_SMOOTH_WT("eventsm", "event-smooth-wt", "EventSmoothWt", true, "Relative Event Rate Smoothness weight"),
        SECTION_NUCLEATION_MFD_WT("nuclwt", "sect-nucl-mfd-wt", "SectNuclMFDWt", true, "Relative section nucleation MFD constraint weight"),
        MFD_TRANSITION_MAG("mfdtrans", "mfd-trans-mag", "MFDTrans", true, "MFD transition magnitude"),
        MFD_SMOOTHNESS_WT("mfdsmooth", "mfd-smooth-wt", "Smooth", true, "MFD smoothness constraint weight"),
        PALEO_SECT_MFD_SMOOTH("paleomfdsmooth", "paleo-sect-mfd-smooth", "SmoothPaleoSect", true, "MFD smoothness constraint weight for peleo parent sects"),
        REMOVE_OUTLIER_FAULTS("removefaults", "remove-faults", "RemoveFaults", false, "Remove some outlier high slip faults."),
        SLIP_WT_NORM("slipwt", "slip-wt", "SlipWt", true, "Normalized slip rate constraint wt"),
        SLIP_WT_UNNORM("slipwtunnorm", "slip-wt-unnorm", "SlipWtUnNorm", true, "Unnormalized slip rate constraint wt"),
        SERIAL("serial", "force-serial", "Serial", false, "Force serial annealing"),
        SYNTHETIC("syn", "synthetic", "Synthetic", false, "Synthetic data from solution rates named syn.bin."),
        COULOMB("coulomb", "coulomb-threshold", "Coulomb", true, "Set coulomb filter threshold"),
        COULOMB_EXCLUDE("coulombex", "coulomb-exclude-threshold", "CoulombExclusion", true, "Set coulomb filter exclusion DCFF threshold"),
        UCERF3p2("u3p2", "ucerf3p2", "U3p2", false, "Flag for reverting to UCERF3.2 rup set/data"),
        RUP_SMOOTH_WT("rupsm", "rup-rate-smoothing-wt", "RupSmth", true, "Rupture rate smoothing constraint weight"),
        U2_MAPPED_RUPS_ONLY("u2rups", "u2-rups-only", "U2Rups", false, "UCERF2 Mappable Ruptures Only"),
        RUP_FILTER_FILE("rupfilter", "rup-filter-file", "FilteredRups", true, "ASCII file listing rupture indexes, one per line, to include in output solution"),
        RUP_DOWNSAMPLE_DM("dwn", "rup-downsample-dm", "Downsample", true, "Enable rup set downsampling with the given delta magnitude"),
        AVE_SLIP_SCALE("aveslip", "ave-slip-scale", "AveSlipScale", true, "Average slip constraint scalar");

        private String shortArg;
        private String argName;
        private String fileName;
        private String description;
        private boolean hasOption;

        private InversionOptions(String shortArg, String argName, String fileName, boolean hasOption, String description) {
            this.shortArg = shortArg;
            this.argName = argName;
            this.fileName = fileName;
            this.hasOption = hasOption;
            this.description = description;
        }

        public String getShortArg() {
            return this.shortArg;
        }

        public String getArgName() {
            return this.argName;
        }

        public String getCommandLineArgs() {
            return this.getCommandLineArgs(null);
        }

        public String getCommandLineArgs(double option) {
            return this.getCommandLineArgs("" + (float)option);
        }

        public String getCommandLineArgs(String option) {
            String args = "--" + this.argName;
            if (this.hasOption) {
                Preconditions.checkArgument((option != null && !option.isEmpty() ? 1 : 0) != 0);
                args = args + " " + option;
            }
            return args;
        }

        public String getFileName() {
            return this.getFileName(null);
        }

        public String getFileName(double option) {
            return this.getFileName("" + (float)option);
        }

        public String getFileName(String option) {
            if (this.hasOption) {
                File file;
                Preconditions.checkArgument((option != null && !option.isEmpty() ? 1 : 0) != 0);
                if (option.contains("/") && (option = (file = new File(option)).getName().replaceAll("_", "")).contains(".")) {
                    option = option.substring(0, option.indexOf("."));
                }
                return this.fileName + option;
            }
            return this.fileName;
        }

        public boolean hasOption() {
            return this.hasOption;
        }
    }

    public static class ParentMomentRecord
    implements Comparable<ParentMomentRecord> {
        public int parentID;
        public String name;
        public double targetMoment;
        public double solutionMoment;

        public ParentMomentRecord(int parentID, String name, double targetMoment, double solutionMoment) {
            this.parentID = parentID;
            this.name = name;
            this.targetMoment = targetMoment;
            this.solutionMoment = solutionMoment;
        }

        public double getDiff() {
            return this.targetMoment - this.solutionMoment;
        }

        @Override
        public int compareTo(ParentMomentRecord o) {
            return Double.compare(Math.abs(this.getDiff()), Math.abs(o.getDiff()));
        }
    }
}

