/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.inversion;

import cern.colt.matrix.tdouble.DoubleMatrix2D;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.opensha.commons.eq.MagUtils;
import org.opensha.commons.gui.plot.GraphWindow;
import org.opensha.commons.gui.plot.PlotSpec;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl.PaleoProbabilityModel;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.SerialSimulatedAnnealing;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.SimulatedAnnealing;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.ThreadedSimulatedAnnealing;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.completion.CompletionCriteria;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.completion.ProgressTrackingCompletionCriteria;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.completion.TimeCompletionCriteria;
import scratch.UCERF3.U3FaultSystemRupSet;
import scratch.UCERF3.enumTreeBranches.FaultModels;
import scratch.UCERF3.enumTreeBranches.InversionModels;
import scratch.UCERF3.inversion.CommandLineInversionRunner;
import scratch.UCERF3.inversion.InversionFaultSystemRupSet;
import scratch.UCERF3.inversion.InversionFaultSystemRupSetFactory;
import scratch.UCERF3.inversion.InversionFaultSystemSolution;
import scratch.UCERF3.inversion.UCERF3InversionConfiguration;
import scratch.UCERF3.inversion.UCERF3InversionInputGenerator;
import scratch.UCERF3.inversion.laughTest.UCERF3PlausibilityConfig;
import scratch.UCERF3.utils.U3FaultSystemIO;
import scratch.UCERF3.utils.UCERF3_DataUtils;
import scratch.UCERF3.utils.aveSlip.U3AveSlipConstraint;
import scratch.UCERF3.utils.paleoRateConstraints.PaleoFitPlotter;
import scratch.UCERF3.utils.paleoRateConstraints.U3PaleoRateConstraint;

public class RunInversion {
    protected static final boolean D = true;

    public static void main(String[] args) {
        SimulatedAnnealing sa;
        String fileName = "UCERF2-Test2";
        boolean writeMatrixZipFiles = false;
        boolean writeSolutionZipFile = true;
        InversionModels inversionModel = InversionModels.CHAR_CONSTRAINED;
        U3FaultSystemRupSet rupSet = null;
        double defaultAseis = 0.1;
        try {
            UCERF3PlausibilityConfig filter = UCERF3PlausibilityConfig.getDefault();
            rupSet = InversionFaultSystemRupSetFactory.forBranch(filter, defaultAseis, inversionModel, FaultModels.FM3_1);
        }
        catch (Exception e1) {
            e1.printStackTrace();
            System.exit(1);
        }
        System.out.println("Total Orig (creep reduced) Moment Rate = " + rupSet.getTotalOrigMomentRate());
        System.out.println("Total Final (creep & subseismogenic rup reduced) Moment Rate = " + rupSet.getTotalReducedMomentRate());
        UCERF3InversionConfiguration config = UCERF3InversionConfiguration.forModel(inversionModel, rupSet, ((InversionFaultSystemRupSet)rupSet).getFaultModel(), ((InversionFaultSystemRupSet)rupSet).getInversionTargetMFDs());
        config.updateRupSetInfoString(rupSet);
        File precomputedDataDir = UCERF3_DataUtils.DEFAULT_SCRATCH_DATA_DIR;
        ArrayList<U3PaleoRateConstraint> paleoRateConstraints = null;
        try {
            paleoRateConstraints = CommandLineInversionRunner.getPaleoConstraints(((InversionFaultSystemRupSet)rupSet).getFaultModel(), rupSet);
        }
        catch (IOException e1) {
            e1.printStackTrace();
            System.exit(1);
        }
        double[] improbabilityConstraint = null;
        PaleoProbabilityModel paleoProbabilityModel = null;
        try {
            paleoProbabilityModel = UCERF3InversionInputGenerator.loadDefaultPaleoProbabilityModel();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
        List<U3AveSlipConstraint> aveSlipConstraints = null;
        try {
            aveSlipConstraints = U3AveSlipConstraint.load(rupSet.getFaultSectionDataList());
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
        UCERF3InversionInputGenerator gen = new UCERF3InversionInputGenerator(rupSet, config, paleoRateConstraints, aveSlipConstraints, improbabilityConstraint, paleoProbabilityModel);
        gen.generateInputs();
        gen.columnCompress();
        DoubleMatrix2D A = gen.getA();
        double[] d = gen.getD();
        DoubleMatrix2D A_ineq = gen.getA_ineq();
        double[] d_ineq = gen.getD_ineq();
        double[] initial = gen.getInitialSolution();
        double[] minimumRuptureRates = gen.getWaterLevelRates();
        CompletionCriteria criteria = TimeCompletionCriteria.getInHours(1L);
        double relativeSmoothnessWt = config.getSmoothnessWt();
        boolean threading = true;
        if (threading) {
            criteria = new ProgressTrackingCompletionCriteria(criteria, 0.25);
            int numThreads = Runtime.getRuntime().availableProcessors();
            TimeCompletionCriteria subCompetionCriteria = TimeCompletionCriteria.getInSeconds(1L);
            ThreadedSimulatedAnnealing tsa = new ThreadedSimulatedAnnealing(A, d, initial, relativeSmoothnessWt, A_ineq, d_ineq, numThreads, subCompetionCriteria);
            tsa.setConstraintRanges(gen.getConstraintRowRanges());
            sa = tsa;
        } else {
            sa = new SerialSimulatedAnnealing(A, d, initial, relativeSmoothnessWt, A_ineq, d_ineq);
        }
        sa.iterate(criteria);
        double[] solution_raw = sa.getBestSolution();
        double[] solution_adjusted = gen.adjustSolutionForWaterLevel(solution_raw);
        Map<String, Double> energies = null;
        InversionFaultSystemSolution solution = new InversionFaultSystemSolution((InversionFaultSystemRupSet)rupSet, solution_adjusted, config, energies);
        if (writeSolutionZipFile) {
            try {
                U3FaultSystemIO.writeSol(solution, new File(precomputedDataDir, fileName + "_solution.zip"));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        double totalSolutionMoment = 0.0;
        for (int rup = 0; rup < rupSet.getNumRuptures(); ++rup) {
            totalSolutionMoment += solution.getRateForRup(rup) * MagUtils.magToMoment(rupSet.getMagForRup(rup));
        }
        System.out.println("Total moment of solution = " + totalSolutionMoment);
        System.out.print("\nMaking plots . . . ");
        long startTime = System.currentTimeMillis();
        solution.plotRuptureRates();
        solution.plotSlipRates();
        solution.plotPaleoObsAndPredPaleoEventRates(paleoRateConstraints, paleoProbabilityModel, (InversionFaultSystemRupSet)rupSet);
        solution.plotMFDs();
        Map<String, List<Integer>> namedFaultsMap = ((InversionFaultSystemRupSet)rupSet).getFaultModel().getNamedFaultsMapAlt();
        Map<String, PlotSpec[]> plotSpecs = PaleoFitPlotter.getFaultSpecificPaleoPlotSpec(paleoRateConstraints, aveSlipConstraints, namedFaultsMap, solution);
        PlotSpec plotSpec = plotSpecs.get("San Andreas")[2];
        GraphWindow gw = new GraphWindow(plotSpec);
        gw.getGraphWidget().getGraphPanel().setxAxisInverted(true);
        long runTime = System.currentTimeMillis() - startTime;
        System.out.println("Done after " + (double)runTime / 1000.0 + " seconds.");
    }
}

