/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.inversion;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.dom4j.DocumentException;
import org.opensha.commons.eq.MagUtils;
import org.opensha.commons.exceptions.GMT_MapException;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.faultSysSolution.modules.AveSlipModule;
import scratch.UCERF3.enumTreeBranches.DeformationModels;
import scratch.UCERF3.enumTreeBranches.FaultModels;
import scratch.UCERF3.enumTreeBranches.InversionModels;
import scratch.UCERF3.enumTreeBranches.ScalingRelationships;
import scratch.UCERF3.enumTreeBranches.SlipAlongRuptureModels;
import scratch.UCERF3.enumTreeBranches.SpatialSeisPDF;
import scratch.UCERF3.inversion.InversionFaultSystemRupSet;
import scratch.UCERF3.inversion.InversionFaultSystemRupSetFactory;
import scratch.UCERF3.inversion.UCERF3InversionConfiguration;
import scratch.UCERF3.inversion.laughTest.UCERF3PlausibilityConfig;
import scratch.UCERF3.logicTree.U3LogicTreeBranch;

public class UCERF2_ComparisonSolutionFetcher {
    private static Table<FaultModels, SlipAlongRuptureModels, FaultSystemSolution> cache = HashBasedTable.create();

    public static FaultSystemSolution getUCERF2Solution(FaultModels fm) {
        return UCERF2_ComparisonSolutionFetcher.getUCERF2Solution(fm, SlipAlongRuptureModels.TAPERED);
    }

    public static FaultSystemSolution getUCERF2Solution(FaultModels fm, SlipAlongRuptureModels slipModel) {
        FaultSystemSolution sol = (FaultSystemSolution)cache.get((Object)fm, (Object)slipModel);
        if (sol == null) {
            DeformationModels dm = fm == FaultModels.FM2_1 ? DeformationModels.UCERF2_ALL : DeformationModels.GEOLOGIC;
            InversionFaultSystemRupSet rupSet = InversionFaultSystemRupSetFactory.forBranch(UCERF3PlausibilityConfig.getDefault(), 0.0, fm, dm, ScalingRelationships.AVE_UCERF2, slipModel, InversionModels.CHAR_CONSTRAINED, SpatialSeisPDF.UCERF2);
            sol = UCERF2_ComparisonSolutionFetcher.getUCERF2Solution(rupSet);
            cache.put((Object)fm, (Object)slipModel, (Object)sol);
        }
        return sol;
    }

    public static FaultSystemSolution getUCERF2Solution(InversionFaultSystemRupSet rupSet) {
        return UCERF2_ComparisonSolutionFetcher.getUCERF2Solution(rupSet, rupSet.getModule(U3LogicTreeBranch.class).getValue(FaultModels.class), rupSet.getModule(AveSlipModule.class));
    }

    public static FaultSystemSolution getUCERF2Solution(FaultSystemRupSet rupSet, FaultModels fm, AveSlipModule aveSlipModule) {
        ArrayList<double[]> ucerf2_magsAndRates = UCERF3InversionConfiguration.getUCERF2MagsAndrates(rupSet, fm);
        double[] mags = new double[ucerf2_magsAndRates.size()];
        double[] rates = new double[ucerf2_magsAndRates.size()];
        double[] aveSlips = new double[rupSet.getNumRuptures()];
        double sumU2Rate = 0.0;
        double avgU2Mag = 0.0;
        for (int i = 0; i < ucerf2_magsAndRates.size(); ++i) {
            double[] ucerf2_vals = ucerf2_magsAndRates.get(i);
            if (ucerf2_vals == null) {
                mags[i] = rupSet.getMagForRup(i);
                rates[i] = 0.0;
                continue;
            }
            mags[i] = ucerf2_vals[0];
            rates[i] = ucerf2_vals[1];
            Preconditions.checkState((boolean)Double.isFinite(mags[i]), (String)"Bad U2 mag for r=%s: %s", (int)i, (Object)mags[i]);
            Preconditions.checkState((boolean)Double.isFinite(rates[i]), (String)"Bad U2 rate for r=%s: %s", (int)i, (Object)rates[i]);
            aveSlips[i] = aveSlipModule.getAveSlip(i) * MagUtils.magToMoment(mags[i]) / MagUtils.magToMoment(rupSet.getMagForRup(i));
            sumU2Rate += rates[i];
            avgU2Mag += rates[i] * mags[i];
        }
        System.out.println("UCERF2 sum rate: " + sumU2Rate + "\tavg mag: " + (avgU2Mag /= sumU2Rate));
        FaultSystemRupSet modRupSet = new FaultSystemRupSet(rupSet.getFaultSectionDataList(), rupSet.getSectionIndicesForAllRups(), mags, rupSet.getAveRakeForAllRups(), rupSet.getAreaForAllRups(), rupSet.getLengthForAllRups());
        return new FaultSystemSolution(modRupSet, rates);
    }

    public static void main(String[] args) throws GMT_MapException, RuntimeException, IOException, DocumentException {
        FaultModels fm = FaultModels.FM2_1;
        String prefix = "FM2_1_UCERF2_DsrTap_CharConst_COMPARE";
        File dir = new File("/tmp");
    }
}

