/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.inversion;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.opensha.commons.util.IDPairing;
import org.opensha.sha.faultSurface.FaultSection;
import scratch.UCERF3.inversion.OldSectionConnectionStrategy;
import scratch.UCERF3.inversion.coulomb.CoulombRates;

public class UCERF3SectionConnectionStrategy
implements OldSectionConnectionStrategy {
    private double maxJumpDist;
    private CoulombRates coulombRates;

    public UCERF3SectionConnectionStrategy(double maxJumpDist, CoulombRates coulombRates) {
        this.maxJumpDist = maxJumpDist;
        this.coulombRates = coulombRates;
    }

    @Override
    public List<List<Integer>> computeCloseSubSectionsListList(List<? extends FaultSection> faultSectionData, Map<IDPairing, Double> subSectionDistances) {
        return UCERF3SectionConnectionStrategy.computeCloseSubSectionsListList(faultSectionData, subSectionDistances, this.maxJumpDist, this.coulombRates);
    }

    public static List<List<Integer>> computeCloseSubSectionsListList(List<? extends FaultSection> faultSectionData, Map<IDPairing, Double> subSectionDistances, double maxJumpDist, CoulombRates coulombRates) {
        int i;
        ArrayList<List<Integer>> sectionConnectionsListList = new ArrayList<List<Integer>>();
        for (int i2 = 0; i2 < faultSectionData.size(); ++i2) {
            sectionConnectionsListList.add(new ArrayList());
        }
        ArrayList subSectionDataListList = new ArrayList();
        int lastID = -1;
        ArrayList<FaultSection> newList = new ArrayList<FaultSection>();
        for (i = 0; i < faultSectionData.size(); ++i) {
            FaultSection subSect = faultSectionData.get(i);
            int parentID = subSect.getParentSectionId();
            if (parentID != lastID || parentID == -1) {
                newList = new ArrayList();
                subSectionDataListList.add(newList);
                lastID = subSect.getParentSectionId();
            }
            newList.add(subSect);
        }
        for (i = 0; i < subSectionDataListList.size(); ++i) {
            ArrayList subSectList = (ArrayList)subSectionDataListList.get(i);
            int numSubSect = subSectList.size();
            for (int j = 0; j < numSubSect; ++j) {
                int sectIndex = ((FaultSection)subSectList.get(j)).getSectionId();
                List<Integer> sectionConnections = sectionConnectionsListList.get(sectIndex);
                if (j != 0) {
                    sectionConnections.add(((FaultSection)subSectList.get(j - 1)).getSectionId());
                }
                if (j == numSubSect - 1) continue;
                sectionConnections.add(((FaultSection)subSectList.get(j + 1)).getSectionId());
            }
        }
        for (i = 0; i < subSectionDataListList.size(); ++i) {
            ArrayList sect1_List = (ArrayList)subSectionDataListList.get(i);
            for (int j = i + 1; j < subSectionDataListList.size(); ++j) {
                ArrayList sect2_List = (ArrayList)subSectionDataListList.get(j);
                double minDist = Double.MAX_VALUE;
                int subSectIndex1 = -1;
                int subSectIndex2 = -1;
                for (int k = 0; k < sect1_List.size(); ++k) {
                    for (int l = 0; l < sect2_List.size(); ++l) {
                        double dist;
                        FaultSection data1 = (FaultSection)sect1_List.get(k);
                        FaultSection data2 = (FaultSection)sect2_List.get(l);
                        IDPairing ind = new IDPairing(data1.getSectionId(), data2.getSectionId());
                        if (!subSectionDistances.containsKey(ind) || !((dist = subSectionDistances.get(ind).doubleValue()) < minDist) && (float)dist != (float)minDist) continue;
                        if ((float)dist == (float)minDist) {
                            boolean prevValCoulomb = false;
                            boolean curValCoulomb = false;
                            if (coulombRates != null) {
                                prevValCoulomb = coulombRates.containsKey(new IDPairing(subSectIndex1, subSectIndex2));
                                curValCoulomb = coulombRates.containsKey(new IDPairing(data1.getSectionId(), data2.getSectionId()));
                            }
                            if (prevValCoulomb || !curValCoulomb) continue;
                        }
                        minDist = dist;
                        subSectIndex1 = data1.getSectionId();
                        subSectIndex2 = data2.getSectionId();
                    }
                }
                if (!(minDist < maxJumpDist)) continue;
                sectionConnectionsListList.get(subSectIndex1).add(subSectIndex2);
                sectionConnectionsListList.get(subSectIndex2).add(subSectIndex1);
            }
        }
        return sectionConnectionsListList;
    }
}

