/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.inversion.laughTest;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.opensha.commons.util.IDPairing;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityResult;
import org.opensha.sha.faultSurface.FaultSection;
import scratch.UCERF3.inversion.coulomb.CoulombRates;
import scratch.UCERF3.inversion.coulomb.CoulombRatesRecord;
import scratch.UCERF3.inversion.coulomb.CoulombRatesTester;
import scratch.UCERF3.inversion.laughTest.AbstractPlausibilityFilter;

public class CoulombFilter
extends AbstractPlausibilityFilter {
    private CoulombRates rates;
    private CoulombRatesTester tester;
    private boolean missingAsFail = false;
    private static final boolean D = false;

    public CoulombFilter(CoulombRates rates, CoulombRatesTester tester) {
        this.rates = rates;
        this.tester = tester;
    }

    @Override
    public PlausibilityResult applyLastSection(List<? extends FaultSection> rupture, List<IDPairing> pairings, List<Integer> junctionIndexes) {
        boolean pass;
        if (rupture.size() < 2 || this.isApplyJunctionsOnly() && junctionIndexes.isEmpty()) {
            return PlausibilityResult.PASS;
        }
        ArrayList forwardRates = Lists.newArrayList();
        ArrayList backwardRates = Lists.newArrayList();
        if (this.isApplyJunctionsOnly()) {
            Iterator<Comparable<Integer>> iterator = junctionIndexes.iterator();
            while (iterator.hasNext()) {
                int junctionIndex = (Integer)iterator.next();
                IDPairing pair = pairings.get(junctionIndex - 1);
                if (this.missingAsFail && this.rates.get(pair) == null) {
                    return PlausibilityResult.FAIL_HARD_STOP;
                }
                forwardRates.add((CoulombRatesRecord)this.rates.get(pair));
                Preconditions.checkNotNull((Object)((CoulombRatesRecord)this.rates.get(pair)), (String)"No coulomb for: %s, have %s pairings in total", (Object)pair, (int)this.rates.size());
                Preconditions.checkNotNull((Object)((CoulombRatesRecord)this.rates.get(pair.getReversed())), (String)"No coulomb for: %s, have %s pairings in total", (Object)pair.getReversed(), (int)this.rates.size());
                backwardRates.add(0, (CoulombRatesRecord)this.rates.get(pair.getReversed()));
            }
        } else {
            for (IDPairing pair : pairings) {
                if (this.missingAsFail && this.rates.get(pair) == null) {
                    return PlausibilityResult.FAIL_HARD_STOP;
                }
                forwardRates.add((CoulombRatesRecord)this.rates.get(pair));
                backwardRates.add(0, (CoulombRatesRecord)this.rates.get(pair.getReversed()));
            }
        }
        if (pass = this.tester.doesRupturePass(forwardRates, backwardRates)) {
            return PlausibilityResult.PASS;
        }
        return PlausibilityResult.FAIL_HARD_STOP;
    }

    @Override
    public boolean isApplyJunctionsOnly() {
        return this.tester.isApplyBranchesOnly();
    }

    @Override
    public String getName() {
        return "Coulomb Filter";
    }

    @Override
    public String getShortName() {
        return "Coulomb";
    }

    public void setMissingAsFail(boolean missingAsFail) {
        this.missingAsFail = missingAsFail;
    }
}

