/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.logicTree;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import scratch.UCERF3.enumTreeBranches.InversionModels;
import scratch.UCERF3.logicTree.TreeTrimmer;
import scratch.UCERF3.logicTree.U3LogicTreeBranch;
import scratch.UCERF3.logicTree.U3LogicTreeBranchNode;

public class ListBasedTreeTrimmer
implements TreeTrimmer {
    private static List<Class<? extends U3LogicTreeBranchNode<?>>> classes = U3LogicTreeBranch.getLogicTreeNodeClasses();
    private List<List<U3LogicTreeBranchNode<?>>> limitations;
    private boolean nonZeroWeight;

    public static ListBasedTreeTrimmer getNonZeroWeightsTrimmer() {
        ArrayList limitations = Lists.newArrayList();
        return new ListBasedTreeTrimmer(limitations, true);
    }

    public static ListBasedTreeTrimmer getDefaultPlusSpecifiedTrimmer(List<List<U3LogicTreeBranchNode<?>>> customLimitations) {
        ArrayList limitations = Lists.newArrayList();
        for (int i = 0; i < classes.size(); ++i) {
            Class<? extends U3LogicTreeBranchNode<?>> clazz = classes.get(i);
            List<Object> limits = null;
            if (customLimitations != null) {
                for (List<U3LogicTreeBranchNode<?>> customLimits : customLimitations) {
                    Class<U3LogicTreeBranchNode<?>> customClass;
                    if (customLimits == null || customLimits.isEmpty() || !(customClass = ListBasedTreeTrimmer.getClassForList(customLimits)).equals(clazz)) continue;
                    limits = customLimits;
                    break;
                }
            }
            if (limits == null) {
                limits = Lists.newArrayList();
                limits.add((U3LogicTreeBranchNode)U3LogicTreeBranch.DEFAULT.getValue(i));
            }
            limitations.add(limits);
        }
        return new ListBasedTreeTrimmer(limitations);
    }

    public ListBasedTreeTrimmer(List<List<U3LogicTreeBranchNode<?>>> limitationsList) {
        this(limitationsList, false);
    }

    public ListBasedTreeTrimmer(List<List<U3LogicTreeBranchNode<?>>> limitationsList, boolean nonZeroWeight) {
        this.init(limitationsList, nonZeroWeight);
    }

    public ListBasedTreeTrimmer(U3LogicTreeBranch defaultBranch, boolean nonZeroWeight) {
        ArrayList limitationsList = Lists.newArrayList();
        for (int i = 0; i < defaultBranch.size(); ++i) {
            U3LogicTreeBranchNode val = (U3LogicTreeBranchNode)defaultBranch.getValue(i);
            if (val == null) continue;
            ArrayList list = Lists.newArrayList();
            list.add(val);
            limitationsList.add(list);
        }
        this.init(limitationsList, nonZeroWeight);
    }

    private void init(List<List<U3LogicTreeBranchNode<?>>> limitationsList, boolean nonZeroWeight) {
        this.limitations = Lists.newArrayList();
        this.nonZeroWeight = nonZeroWeight;
        for (int i = 0; i < classes.size(); ++i) {
            this.limitations.add(null);
        }
        if (limitationsList != null) {
            for (List<U3LogicTreeBranchNode<?>> limits : limitationsList) {
                if (limits == null || limits.isEmpty()) continue;
                Class<U3LogicTreeBranchNode<?>> clazz = ListBasedTreeTrimmer.getClassForList(limits);
                int index = classes.indexOf(clazz);
                Preconditions.checkState((index >= 0 ? 1 : 0) != 0, (Object)("Could not location class in class list: " + String.valueOf(clazz)));
                this.limitations.set(index, limits);
            }
        }
        Preconditions.checkState((this.limitations.size() == classes.size() ? 1 : 0) != 0, (Object)"limitations list must be same size as number of classes");
    }

    private static Class<U3LogicTreeBranchNode<?>> getClassForList(List<U3LogicTreeBranchNode<?>> limits) {
        return U3LogicTreeBranch.getEnumEnclosingClass(limits.get(0).getClass());
    }

    @Override
    public boolean isTreeValid(U3LogicTreeBranch branch) {
        InversionModels im = branch.getValue(InversionModels.class);
        for (int i = 0; i < branch.size(); ++i) {
            U3LogicTreeBranchNode val = (U3LogicTreeBranchNode)branch.getValue(i);
            List<U3LogicTreeBranchNode<?>> myLimits = this.limitations.get(i);
            if (myLimits != null && !this.limitations.get(i).contains(val)) {
                return false;
            }
            if (!this.nonZeroWeight || !(val.getRelativeWeight(im) <= 0.0)) continue;
            return false;
        }
        return true;
    }
}

