/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.utils;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.dom4j.DocumentException;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.faultSurface.FaultSection;
import scratch.UCERF3.utils.UCERF3_DataUtils;
import scratch.UCERF3.utils.paleoRateConstraints.UCERF3_PaleoProbabilityModel;

public class LastEventData {
    public static final String SUB_DIR = "paleoRateData";
    public static final String FILE_NAME = "UCERF3_OpenIntervals_ver11.xls";
    private static final int[] SHEET_NUMS = new int[]{0, 1, 2};
    public static final int OPEN_INTERVAL_BASIS_YEAR = 2013;
    public static final GregorianCalendar OPEN_INTERVAL_BASIS = new GregorianCalendar(2013, 0, 0);
    private static final double MATCH_LOCATION_TOLERANCE = 1.0;
    private String sectName;
    private int parentSectID;
    private double lastOffset;
    private double openInterval;
    private GregorianCalendar eventDate;
    private Location startLoc;
    private Location endLoc;

    public static Map<Integer, List<LastEventData>> load() throws IOException {
        return LastEventData.load(UCERF3_DataUtils.locateResourceAsStream(SUB_DIR, FILE_NAME));
    }

    public static Map<Integer, List<LastEventData>> load(InputStream is) throws IOException {
        return LastEventData.load(is, SHEET_NUMS);
    }

    public static Map<Integer, List<LastEventData>> load(InputStream is, int[] sheets) throws IOException {
        POIFSFileSystem fs = new POIFSFileSystem(is);
        HSSFWorkbook wb = new HSSFWorkbook(fs);
        HashMap datas = Maps.newHashMap();
        for (int sheetNum : sheets) {
            HSSFSheet sheet = wb.getSheetAt(sheetNum);
            for (int rowIndex = 0; rowIndex <= sheet.getLastRowNum(); ++rowIndex) {
                HSSFCell intervalCell;
                HSSFRow row = sheet.getRow(rowIndex);
                if (row == null || (intervalCell = row.getCell(4)) == null || intervalCell.getCellType() != 0) continue;
                double interval = intervalCell.getNumericCellValue();
                String name = row.getCell(0).getStringCellValue();
                int parentID = (int)row.getCell(1).getNumericCellValue();
                Preconditions.checkState((parentID >= 0 ? 1 : 0) != 0);
                HSSFCell offsetCell = row.getCell(3);
                double offset = offsetCell == null || offsetCell.getCellType() != 0 ? Double.NaN : offsetCell.getNumericCellValue();
                HSSFCell locStartCell = row.getCell(6);
                if (locStartCell == null || locStartCell.getCellType() != 0) {
                    System.err.println("WARNING: no location for " + name + "...skipping!");
                    continue;
                }
                double startLat = row.getCell(6).getNumericCellValue();
                double startLon = row.getCell(7).getNumericCellValue();
                double endLat = row.getCell(8).getNumericCellValue();
                double endLon = row.getCell(9).getNumericCellValue();
                Location startLoc = new Location(startLat, startLon);
                Location endLoc = new Location(endLat, endLon);
                List parentList = (List)datas.get(parentID);
                if (parentList == null) {
                    parentList = Lists.newArrayList();
                    datas.put(parentID, parentList);
                }
                parentList.add(new LastEventData(name, parentID, offset, interval, startLoc, endLoc));
            }
        }
        return datas;
    }

    public static void filterDataAfterTime(Map<Integer, List<LastEventData>> datas, long timeMillis) {
        for (Integer parentID : new ArrayList<Integer>(datas.keySet())) {
            List<LastEventData> parentDatas = datas.get(parentID);
            if (parentDatas == null) continue;
            int i = parentDatas.size();
            while (--i >= 0) {
                LastEventData data = parentDatas.get(i);
                long dataTime = data.getDateOfLastEvent().getTimeInMillis();
                if (dataTime <= timeMillis) continue;
                long delta = dataTime - timeMillis;
                System.out.println("Removing last event data on s='" + data.getSectName() + "' with time=" + dataTime + " > " + timeMillis + " (delta=" + delta + ")");
                parentDatas.remove(i);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void populateSubSects(List<? extends FaultSection> sects, Map<Integer, List<LastEventData>> datas) {
        for (FaultSection faultSection : sects) {
            faultSection.setDateOfLastEvent(Long.MIN_VALUE);
        }
        int populated = 0;
        boolean bl = false;
        HashSet<LastEventData> usedDatas = new HashSet<LastEventData>();
        block1: for (FaultSection faultSection : sects) {
            int parentID = faultSection.getParentSectionId();
            List<LastEventData> parentDatas = datas.get(parentID);
            if (parentDatas == null) continue;
            for (LastEventData data : parentDatas) {
                if (!data.matchesLocation(faultSection, 1.0)) continue;
                if (usedDatas.contains(data)) {
                    void var3_6;
                    ++var3_6;
                }
                faultSection.setDateOfLastEvent(data.getDateOfLastEvent().getTimeInMillis());
                faultSection.setSlipInLastEvent(data.getLastOffset());
                ++populated;
                usedDatas.add(data);
                continue block1;
            }
        }
        int numDatas = 0;
        ArrayList arrayList = Lists.newArrayList();
        for (List<LastEventData> dataList : datas.values()) {
            numDatas += dataList.size();
            for (LastEventData data : dataList) {
                if (usedDatas.contains(data)) continue;
                arrayList.add(data.getSectName());
            }
        }
    }

    private static GregorianCalendar calcDate(double openInterval) {
        return LastEventData.calcDate(OPEN_INTERVAL_BASIS, openInterval);
    }

    public static GregorianCalendar calcDate(GregorianCalendar intervalBasis, double openInterval) {
        double fractYears;
        GregorianCalendar eventDate = (GregorianCalendar)intervalBasis.clone();
        int years = (int)openInterval;
        if (years > 0) {
            eventDate.add(1, -years);
        }
        if ((float)(fractYears = openInterval - Math.floor(openInterval)) == 0.0f) {
            return eventDate;
        }
        int days = (int)(fractYears * 365.0);
        if (days > 0) {
            eventDate.add(6, -days);
        }
        return eventDate;
    }

    public LastEventData(String sectName, int parentSectID, double lastOffset, double openInterval, Location startLoc, Location endLoc) {
        this(sectName, parentSectID, lastOffset, openInterval, LastEventData.calcDate(openInterval), startLoc, endLoc);
    }

    private LastEventData(String sectName, int parentSectID, double lastOffset, double openInterval, GregorianCalendar eventDate, Location startLoc, Location endLoc) {
        this.sectName = sectName;
        this.parentSectID = parentSectID;
        this.lastOffset = lastOffset;
        this.openInterval = openInterval;
        this.eventDate = eventDate;
        this.startLoc = startLoc;
        this.endLoc = endLoc;
    }

    public String getSectName() {
        return this.sectName;
    }

    public int getParentSectID() {
        return this.parentSectID;
    }

    public double getLastOffset() {
        return this.lastOffset;
    }

    public double getRefOpenInterval() {
        return this.openInterval;
    }

    public GregorianCalendar getDateOfLastEvent() {
        return this.eventDate;
    }

    public boolean matchesLocation(FaultSection sect, double toleranceKM) {
        Location sectStartLoc = sect.getFaultTrace().first();
        Location sectEndLoc = sect.getFaultTrace().last();
        if (LocationUtils.horzDistanceFast(sectStartLoc, this.startLoc) <= toleranceKM && LocationUtils.horzDistanceFast(sectEndLoc, this.endLoc) <= toleranceKM) {
            return true;
        }
        return LocationUtils.horzDistanceFast(sectStartLoc, this.endLoc) <= toleranceKM && LocationUtils.horzDistanceFast(sectEndLoc, this.startLoc) <= toleranceKM;
    }

    public static void writeOpenRecurrRatioTable(File file, FaultSystemSolution sol) throws IOException {
        LastEventData.writeOpenRecurrRatioTable(file, sol, SHEET_NUMS);
    }

    public static void writeOpenRecurrRatioTable(File file, FaultSystemSolution sol, int[] sheets) throws IOException {
        CSVFile<String> csv = new CSVFile<String>(true);
        csv.addLine("Parent Section Name", "Parent Section ID", "Sub Section ID", "Open Interval (years)", "Paleo Obs. RI", "OI/Paleo RI");
        Map<Integer, List<LastEventData>> datas = LastEventData.load(UCERF3_DataUtils.locateResourceAsStream(SUB_DIR, FILE_NAME), sheets);
        List<? extends FaultSection> fsd = sol.getRupSet().getFaultSectionDataList();
        HashMap fsdByParent = Maps.newHashMap();
        for (FaultSection faultSection : fsd) {
            Object parentSects = (List)fsdByParent.get(faultSection.getParentSectionId());
            if (parentSects == null) {
                parentSects = Lists.newArrayList();
                fsdByParent.put(faultSection.getParentSectionId(), parentSects);
            }
            parentSects.add(faultSection);
        }
        UCERF3_PaleoProbabilityModel paleoProbModel = UCERF3_PaleoProbabilityModel.load();
        HashMap hashMap = Maps.newHashMap();
        for (Integer parentID : datas.keySet()) {
            if (!fsdByParent.containsKey(parentID)) continue;
            hashMap.put(((FaultSection)((List)fsdByParent.get(parentID)).get(0)).getParentSectionName(), parentID);
        }
        ArrayList parentNames = Lists.newArrayList(hashMap.keySet());
        Collections.sort(parentNames);
        for (String parentName : parentNames) {
            Integer parentID = (Integer)hashMap.get(parentName);
            List<LastEventData> eventData = datas.get(parentID);
            List sects = (List)fsdByParent.get(parentID);
            block3: for (FaultSection sect : sects) {
                for (LastEventData data : eventData) {
                    if (!data.matchesLocation(sect, 1.0)) continue;
                    double paleoObsRate = sol.calcTotPaleoVisibleRateForSect(sect.getSectionId(), paleoProbModel);
                    double paleoRI = 1.0 / paleoObsRate;
                    double ratio = data.openInterval / paleoRI;
                    csv.addLine(parentName, "" + parentID, "" + sect.getSectionId(), "" + data.openInterval, "" + paleoRI, "" + ratio);
                    continue block3;
                }
            }
        }
        csv.writeToFile(file);
    }

    public static void main(String[] args) throws IOException, DocumentException {
        File solDir = new File(UCERF3_DataUtils.DEFAULT_SCRATCH_DATA_DIR, "InversionSolutions");
        FaultSystemSolution sol = FaultSystemSolution.load(new File(solDir, "2013_05_10-ucerf3p3-production-10runs_COMPOUND_SOL_FM3_1_MEAN_BRANCH_AVG_SOL.zip"));
        File csvFile = new File("/tmp/open_interval_ratios.csv");
        LastEventData.writeOpenRecurrRatioTable(csvFile, sol);
        Map<Integer, List<LastEventData>> datas = LastEventData.load();
        LastEventData.populateSubSects(sol.getRupSet().getFaultSectionDataList(), datas);
        LastEventData.populateSubSects(FaultSystemSolution.load(new File(solDir, "2013_05_10-ucerf3p3-production-10runs_COMPOUND_SOL_FM3_2_MEAN_BRANCH_AVG_SOL.zip")).getRupSet().getFaultSectionDataList(), datas);
    }
}

