/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.utils;

import com.google.common.base.Preconditions;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.List;
import org.dom4j.Element;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.geo.Region;
import org.opensha.commons.geo.RegionUtils;
import org.opensha.commons.metadata.XMLSaveable;
import org.opensha.refFaultParamDb.vo.FaultSectionPrefData;
import org.opensha.sha.faultSurface.StirlingGriddedSurface;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import scratch.UCERF3.utils.MFD_WeightedInversionConstraint;

@JsonAdapter(value=Adapter.class)
public class MFD_InversionConstraint
implements XMLSaveable {
    public static final String XML_METADATA_NAME = "MFD_InversionConstraint";
    IncrementalMagFreqDist mfd;
    Region region;

    public MFD_InversionConstraint(IncrementalMagFreqDist mfd, Region region) {
        this.mfd = mfd;
        this.region = region;
        if (region != mfd.getRegion()) {
            mfd = mfd.deepClone();
            mfd.setRegion(region);
        }
    }

    public MFD_InversionConstraint(IncrementalMagFreqDist mfd) {
        this.mfd = mfd;
        this.region = mfd.getRegion();
    }

    public void setMagFreqDist(IncrementalMagFreqDist mfd) {
        this.mfd = mfd;
    }

    public IncrementalMagFreqDist getMagFreqDist() {
        return this.mfd;
    }

    public void setRegion(Region region) {
        this.region = region;
    }

    public Region getRegion() {
        return this.region;
    }

    public double getFractionInRegion(List<FaultSectionPrefData> faultSectPrefDataList) {
        if (this.region == null) {
            return 1.0;
        }
        double numInside = 0.0;
        double totNum = 0.0;
        double gridSpacing = 1.0;
        for (FaultSectionPrefData data : faultSectPrefDataList) {
            StirlingGriddedSurface surf = data.getStirlingGriddedSurface(gridSpacing, false, true);
            double numPts = surf.size();
            totNum += numPts;
            numInside += numPts * RegionUtils.getFractionInside(this.region, surf.getEvenlyDiscritizedListOfLocsOnSurface());
            data.getSimpleFaultData(true);
        }
        return numInside / totNum;
    }

    @Override
    public Element toXMLMetadata(Element root) {
        Element el = root.addElement(XML_METADATA_NAME);
        if (this.region != null) {
            this.region.toXMLMetadata(el, "Region");
        }
        this.mfd.toXMLMetadata(el);
        return root;
    }

    public static MFD_InversionConstraint fromXMLMetadata(Element constrEl) {
        Element regionEl = constrEl.element("Region");
        Region region = regionEl == null ? null : Region.fromXMLMetadata(regionEl);
        Element mfdEl = constrEl.element("discretizedFunction");
        EvenlyDiscretizedFunc func = (EvenlyDiscretizedFunc)EvenlyDiscretizedFunc.fromXMLMetadata(mfdEl);
        IncrementalMagFreqDist mfd = new IncrementalMagFreqDist(func.getMinX(), func.size(), func.getDelta());
        for (int i = 0; i < func.size(); ++i) {
            mfd.set(i, func.getY(i));
        }
        return new MFD_InversionConstraint(mfd, region);
    }

    public static class Adapter
    extends TypeAdapter<MFD_InversionConstraint> {
        private TypeAdapter<IncrementalMagFreqDist> mfdAdapter = new IncrementalMagFreqDist.Adapter();
        private TypeAdapter<Region> regionAdapter = new Region.Adapter();
        private TypeAdapter<EvenlyDiscretizedFunc> weightsAdapter = new EvenlyDiscretizedFunc.Adapter();

        public void write(JsonWriter out, MFD_InversionConstraint value) throws IOException {
            out.beginObject();
            out.name("mfd");
            this.mfdAdapter.write(out, (Object)value.mfd);
            out.name("region");
            if (value.region == null) {
                out.nullValue();
            } else {
                Region region = new Region(value.region);
                this.regionAdapter.write(out, (Object)region);
            }
            if (value instanceof MFD_WeightedInversionConstraint) {
                out.name("weights");
                this.weightsAdapter.write(out, (Object)((MFD_WeightedInversionConstraint)value).weights);
            }
            out.endObject();
        }

        public MFD_InversionConstraint read(JsonReader in) throws IOException {
            in.beginObject();
            IncrementalMagFreqDist mfd = null;
            Region region = null;
            EvenlyDiscretizedFunc weights = null;
            block10: while (in.hasNext()) {
                switch (in.nextName()) {
                    case "mfd": {
                        mfd = (IncrementalMagFreqDist)this.mfdAdapter.read(in);
                        continue block10;
                    }
                    case "region": {
                        region = (Region)this.regionAdapter.read(in);
                        continue block10;
                    }
                    case "weights": {
                        weights = (EvenlyDiscretizedFunc)this.weightsAdapter.read(in);
                        continue block10;
                    }
                }
                in.skipValue();
            }
            Preconditions.checkNotNull(mfd, (Object)"MFD not specified");
            in.endObject();
            if (weights == null) {
                return new MFD_InversionConstraint(mfd, region);
            }
            return new MFD_WeightedInversionConstraint(mfd, region, weights);
        }
    }
}

