/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.utils;

import cern.colt.list.tdouble.DoubleArrayList;
import cern.colt.list.tint.IntArrayList;
import cern.colt.map.tdouble.AbstractLongDoubleMap;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.SparseCCDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.SparseCCMDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.SparseDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.SparseRCDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.SparseRCMDoubleMatrix2D;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import java.awt.geom.Point2D;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.data.function.LightFixedXFunc;

public class MatrixIO {
    public static void saveSparse(DoubleMatrix2D mat, File file) throws IOException {
        FileOutputStream out = new FileOutputStream(file);
        MatrixIO.saveSparse(mat, out);
        out.close();
    }

    public static void saveSparse(DoubleMatrix2D mat, OutputStream stream) throws IOException {
        Preconditions.checkNotNull((Object)mat, (Object)"array cannot be null!");
        Preconditions.checkArgument((mat.rows() > 0 && mat.columns() > 0 ? 1 : 0) != 0, (Object)"matrix can't be empty!");
        if (!(stream instanceof BufferedOutputStream)) {
            stream = new BufferedOutputStream(stream);
        }
        DataOutputStream out = new DataOutputStream(stream);
        out.writeInt(mat.rows());
        out.writeInt(mat.columns());
        if (mat instanceof SparseDoubleMatrix2D) {
            AbstractLongDoubleMap map = ((SparseDoubleMatrix2D)mat).elements();
            int nnz = mat.cardinality();
            long[] keys = map.keys().elements();
            double[] values = map.values().elements();
            out.writeInt(values.length);
            int columns = mat.columns();
            for (int i = 0; i < nnz; ++i) {
                int row = (int)(keys[i] / (long)columns);
                int column = (int)(keys[i] % (long)columns);
                out.writeInt(row);
                out.writeInt(column);
                out.writeDouble(values[i]);
            }
        } else {
            IntArrayList rowList = new IntArrayList();
            IntArrayList colList = new IntArrayList();
            DoubleArrayList valList = new DoubleArrayList();
            mat.getNonZeros(rowList, colList, valList);
            Preconditions.checkState((rowList.size() > 0 ? 1 : 0) != 0, (Object)"rowList is empty!");
            Preconditions.checkState((rowList.size() == colList.size() && colList.size() == valList.size() ? 1 : 0) != 0, (Object)"array sizes incorrect!");
            out.writeInt(valList.size());
            for (int i = 0; i < valList.size(); ++i) {
                int row = rowList.get(i);
                int col = colList.get(i);
                double val = valList.get(i);
                out.writeInt(row);
                out.writeInt(col);
                out.writeDouble(val);
            }
        }
        out.flush();
        stream.flush();
    }

    public static DoubleMatrix2D loadSparse(File file) throws IOException {
        return MatrixIO.loadSparse(file, null);
    }

    public static DoubleMatrix2D loadSparse(File file, Class<? extends DoubleMatrix2D> clazz) throws IOException {
        Preconditions.checkNotNull((Object)file, (Object)"File cannot be null!");
        Preconditions.checkArgument((boolean)file.exists(), (Object)"File doesn't exist!");
        return MatrixIO.loadSparse(new FileInputStream(file), clazz);
    }

    public static DoubleMatrix2D loadSparse(InputStream input) throws IOException {
        return MatrixIO.loadSparse(input, null);
    }

    public static DoubleMatrix2D loadSparse(InputStream input, Class<? extends DoubleMatrix2D> clazz) throws IOException {
        SparseCCDoubleMatrix2D mat;
        Preconditions.checkNotNull((Object)input, (Object)"Input stream cannot be null!");
        if (!(input instanceof BufferedInputStream)) {
            input = new BufferedInputStream(input);
        }
        DataInputStream in = new DataInputStream(input);
        int nRows = in.readInt();
        int nCols = in.readInt();
        int nVals = in.readInt();
        System.out.println("Mat size: " + nRows + "x" + nCols);
        System.out.println("Num non zero: " + nVals);
        Preconditions.checkState((nRows > 0 ? 1 : 0) != 0, (Object)"file contains no rows!");
        Preconditions.checkState((nCols > 0 ? 1 : 0) != 0, (Object)"file contains no columns!");
        int[] cols = new int[nVals];
        int[] rows = new int[nVals];
        double[] vals = new double[nVals];
        for (int i = 0; i < nVals; ++i) {
            rows[i] = in.readInt();
            cols[i] = in.readInt();
            vals[i] = in.readDouble();
            Preconditions.checkState((!Double.isNaN(vals[i]) ? 1 : 0) != 0, (Object)"no NaN's allowed!");
        }
        in.close();
        if (clazz == null || clazz.equals(SparseCCDoubleMatrix2D.class)) {
            mat = new SparseCCDoubleMatrix2D(nRows, nCols, rows, cols, vals, false, false, false);
        } else if (clazz.equals(SparseRCDoubleMatrix2D.class)) {
            mat = new SparseRCDoubleMatrix2D(nRows, nCols, rows, cols, vals, false, false, false);
        } else if (clazz.equals(SparseDoubleMatrix2D.class)) {
            mat = new SparseDoubleMatrix2D(nRows, nCols, rows, cols, vals);
        } else if (clazz.equals(SparseCCMDoubleMatrix2D.class)) {
            mat = new SparseCCMDoubleMatrix2D(nRows, nCols);
            for (int i = 0; i < nVals; ++i) {
                mat.set(rows[i], cols[i], vals[i]);
            }
        } else if (clazz.equals(SparseRCMDoubleMatrix2D.class)) {
            mat = new SparseRCMDoubleMatrix2D(nRows, nCols);
            for (int i = 0; i < nVals; ++i) {
                mat.set(rows[i], cols[i], vals[i]);
            }
        } else {
            throw new IllegalArgumentException("Unknown matrix type: " + String.valueOf(clazz));
        }
        return mat;
    }

    public static void doubleArrayToFile(double[] array, File file) throws IOException {
        FileOutputStream out = new FileOutputStream(file);
        MatrixIO.doubleArrayToStream(array, out);
        out.close();
    }

    public static void doubleArrayToStream(double[] array, OutputStream stream) throws IOException {
        Preconditions.checkNotNull((Object)array, (Object)"array cannot be null!");
        Preconditions.checkArgument((array.length > 0 ? 1 : 0) != 0, (Object)"array cannot be empty!");
        if (!(stream instanceof BufferedOutputStream)) {
            stream = new BufferedOutputStream(stream);
        }
        DataOutputStream out = new DataOutputStream(stream);
        for (double val : array) {
            out.writeDouble(val);
        }
        out.flush();
        stream.flush();
    }

    public static double[] doubleArrayFromFile(File file) throws IOException {
        Preconditions.checkNotNull((Object)file, (Object)"File cannot be null!");
        Preconditions.checkArgument((boolean)file.exists(), (Object)"File doesn't exist!");
        long len = file.length();
        return MatrixIO.doubleArrayFromInputStream(new FileInputStream(file), len);
    }

    public static double[] doubleArrayFromInputStream(InputStream is, long length) throws IOException {
        Preconditions.checkState((length > 0L ? 1 : 0) != 0, (Object)"file is empty!");
        Preconditions.checkState((length % 8L == 0L ? 1 : 0) != 0, (Object)"file size isn't evenly divisible by 8, thus not a sequence of double values.");
        Preconditions.checkNotNull((Object)is, (Object)"InputStream cannot be null!");
        if (!(is instanceof BufferedInputStream)) {
            is = new BufferedInputStream(is);
        }
        DataInputStream in = new DataInputStream(is);
        int size = (int)(length / 8L);
        double[] array = new double[size];
        for (int i = 0; i < size; ++i) {
            array[i] = in.readDouble();
        }
        in.close();
        return array;
    }

    public static void intArrayToFile(int[] array, File file) throws IOException {
        Preconditions.checkNotNull((Object)array, (Object)"array cannot be null!");
        Preconditions.checkArgument((array.length > 0 ? 1 : 0) != 0, (Object)"array cannot be empty!");
        DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
        for (int val : array) {
            out.writeInt(val);
        }
        out.close();
    }

    public static int[] intArrayFromFile(File file) throws IOException {
        Preconditions.checkNotNull((Object)file, (Object)"File cannot be null!");
        Preconditions.checkArgument((boolean)file.exists(), (Object)"File doesn't exist!");
        long len = file.length();
        return MatrixIO.intArrayFromInputStream(new FileInputStream(file), len);
    }

    public static int[] intArrayFromInputStream(InputStream is, long length) throws IOException {
        Preconditions.checkState((length > 0L ? 1 : 0) != 0, (Object)"file is empty!");
        Preconditions.checkState((length % 4L == 0L ? 1 : 0) != 0, (Object)"file size isn't evenly divisible by 4, thus not a sequence of int values.");
        Preconditions.checkNotNull((Object)is, (Object)"InputStream cannot be null!");
        if (!(is instanceof BufferedInputStream)) {
            is = new BufferedInputStream(is);
        }
        DataInputStream in = new DataInputStream(is);
        int size = (int)(length / 4L);
        int[] array = new int[size];
        for (int i = 0; i < size; ++i) {
            array[i] = in.readInt();
        }
        in.close();
        return array;
    }

    public static void doubleArraysListToFile(List<double[]> list, File file) throws IOException {
        Preconditions.checkNotNull(list, (Object)"list cannot be null!");
        Preconditions.checkArgument((!list.isEmpty() ? 1 : 0) != 0, (Object)"list cannot be empty!");
        DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
        out.writeInt(list.size());
        for (double[] array : list) {
            Preconditions.checkNotNull((Object)array, (Object)"array cannot be null!");
            out.writeInt(array.length);
            for (double val : array) {
                out.writeDouble(val);
            }
        }
        out.close();
    }

    public static List<double[]> doubleArraysListFromFile(File file) throws IOException {
        Preconditions.checkNotNull((Object)file, (Object)"File cannot be null!");
        Preconditions.checkArgument((boolean)file.exists(), (Object)"File doesn't exist!");
        long len = file.length();
        Preconditions.checkState((len > 0L ? 1 : 0) != 0, (Object)"file is empty!");
        Preconditions.checkState((len % 4L == 0L ? 1 : 0) != 0, (Object)"file size isn't evenly divisible by 4, thus not a sequence of double & integer values.");
        return MatrixIO.doubleArraysListFromInputStream(new FileInputStream(file));
    }

    public static List<double[]> doubleArraysListFromInputStream(InputStream is) throws IOException {
        DataInputStream in;
        int size;
        Preconditions.checkNotNull((Object)is, (Object)"InputStream cannot be null!");
        if (!(is instanceof BufferedInputStream)) {
            is = new BufferedInputStream(is);
        }
        Preconditions.checkState(((size = (in = new DataInputStream(is)).readInt()) > 0 ? 1 : 0) != 0, (Object)"Size must be > 0!");
        ArrayList<double[]> list = new ArrayList<double[]>(size);
        for (int i = 0; i < size; ++i) {
            int arraySize = in.readInt();
            double[] array = new double[arraySize];
            for (int j = 0; j < arraySize; ++j) {
                array[j] = in.readDouble();
            }
            list.add(array);
        }
        in.close();
        return list;
    }

    public static void floatArraysListToFile(List<float[]> list, File file) throws IOException {
        Preconditions.checkNotNull(list, (Object)"list cannot be null!");
        Preconditions.checkArgument((!list.isEmpty() ? 1 : 0) != 0, (Object)"list cannot be empty!");
        DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
        out.writeInt(list.size());
        for (float[] array : list) {
            Preconditions.checkNotNull((Object)array, (Object)"array cannot be null!");
            out.writeInt(array.length);
            for (float val : array) {
                out.writeFloat(val);
            }
        }
        out.close();
    }

    public static void floatListListToFile(List<? extends List<Float>> list, File file) throws IOException {
        Preconditions.checkNotNull(list, (Object)"list cannot be null!");
        Preconditions.checkArgument((!list.isEmpty() ? 1 : 0) != 0, (Object)"list cannot be empty!");
        DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
        out.writeInt(list.size());
        for (List<Float> list2 : list) {
            Preconditions.checkNotNull(list2, (Object)"array cannot be null!");
            out.writeInt(list2.size());
            for (float val : list2) {
                out.writeFloat(val);
            }
        }
        out.close();
    }

    public static List<float[]> floatArraysListFromFile(File file) throws IOException {
        Preconditions.checkNotNull((Object)file, (Object)"File cannot be null!");
        Preconditions.checkArgument((boolean)file.exists(), (Object)"File doesn't exist!");
        long len = file.length();
        Preconditions.checkState((len > 0L ? 1 : 0) != 0, (Object)"file is empty!");
        Preconditions.checkState((len % 4L == 0L ? 1 : 0) != 0, (Object)"file size isn't evenly divisible by 4, thus not a sequence of float & integer values.");
        return MatrixIO.floatArraysListFromInputStream(new FileInputStream(file));
    }

    public static List<float[]> floatArraysListFromInputStream(InputStream is) throws IOException {
        DataInputStream in;
        int size;
        Preconditions.checkNotNull((Object)is, (Object)"InputStream cannot be null!");
        if (!(is instanceof BufferedInputStream)) {
            is = new BufferedInputStream(is);
        }
        Preconditions.checkState(((size = (in = new DataInputStream(is)).readInt()) > 0 ? 1 : 0) != 0, (Object)"Size must be > 0!");
        ArrayList<float[]> list = new ArrayList<float[]>(size);
        for (int i = 0; i < size; ++i) {
            int arraySize = in.readInt();
            float[] array = new float[arraySize];
            for (int j = 0; j < arraySize; ++j) {
                array[j] = in.readFloat();
            }
            list.add(array);
        }
        in.close();
        return list;
    }

    public static void discFuncsToFile(DiscretizedFunc[] funcs, File file) throws IOException {
        ArrayList arrays = Lists.newArrayList();
        for (DiscretizedFunc func : funcs) {
            int num = func.size();
            double[] xVals = new double[num];
            double[] yVals = new double[num];
            for (int i = 0; i < num; ++i) {
                Point2D pt = func.get(i);
                xVals[i] = pt.getX();
                yVals[i] = pt.getY();
            }
            arrays.add(xVals);
            arrays.add(yVals);
        }
        MatrixIO.doubleArraysListToFile(arrays, file);
    }

    public static DiscretizedFunc[] discFuncsFromFile(File file) throws FileNotFoundException, IOException {
        Preconditions.checkNotNull((Object)file, (Object)"File cannot be null!");
        Preconditions.checkArgument((boolean)file.exists(), (Object)"File doesn't exist!");
        long len = file.length();
        Preconditions.checkState((len > 0L ? 1 : 0) != 0, (Object)"file is empty!");
        Preconditions.checkState((len % 4L == 0L ? 1 : 0) != 0, (Object)"file size isn't evenly divisible by 4, thus not a sequence of double & integer values.");
        return MatrixIO.discFuncsFromInputStream(new FileInputStream(file));
    }

    public static DiscretizedFunc[] discFuncsFromInputStream(InputStream is) throws IOException {
        List<double[]> arrays = MatrixIO.doubleArraysListFromInputStream(is);
        Preconditions.checkState((arrays.size() % 2 == 0 ? 1 : 0) != 0, (Object)"should be even number of arrays in file");
        DiscretizedFunc[] funcs = new DiscretizedFunc[arrays.size() / 2];
        for (int i = 0; i < arrays.size(); i += 2) {
            int ind = i / 2;
            funcs[ind] = new LightFixedXFunc(arrays.get(i), arrays.get(i + 1));
        }
        return funcs;
    }

    public static void intListListToFile(List<? extends List<Integer>> list, File file) throws IOException {
        Preconditions.checkNotNull(list, (Object)"list cannot be null!");
        Preconditions.checkArgument((!list.isEmpty() ? 1 : 0) != 0, (Object)"list cannot be empty!");
        DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
        out.writeInt(list.size());
        for (List<Integer> list2 : list) {
            Preconditions.checkNotNull(list2, (Object)"list cannot be null!");
            out.writeInt(list2.size());
            for (int val : list2) {
                out.writeInt(val);
            }
        }
        out.close();
    }

    public static List<List<Integer>> intListListFromFile(File file) throws IOException {
        Preconditions.checkNotNull((Object)file, (Object)"File cannot be null!");
        Preconditions.checkArgument((boolean)file.exists(), (Object)"File doesn't exist!");
        long len = file.length();
        Preconditions.checkState((len > 0L ? 1 : 0) != 0, (Object)"file is empty!");
        Preconditions.checkState((len % 4L == 0L ? 1 : 0) != 0, (Object)"file size isn't evenly divisible by 4, thus not a sequence of double & integer values.");
        return MatrixIO.intListListFromInputStream(new FileInputStream(file));
    }

    public static List<List<Integer>> intListListFromInputStream(InputStream is) throws IOException {
        DataInputStream in;
        int size;
        Preconditions.checkNotNull((Object)is, (Object)"InputStream cannot be null!");
        if (!(is instanceof BufferedInputStream)) {
            is = new BufferedInputStream(is);
        }
        Preconditions.checkState(((size = (in = new DataInputStream(is)).readInt()) > 0 ? 1 : 0) != 0, (Object)"Size must be > 0!");
        ArrayList<List<Integer>> list = new ArrayList<List<Integer>>();
        for (int i = 0; i < size; ++i) {
            int listSize = in.readInt();
            int[] intArray = new int[listSize];
            short[] shortArray = new short[listSize];
            boolean shortSafe = true;
            for (int j = 0; j < listSize; ++j) {
                int val = in.readInt();
                shortSafe = shortSafe && val < Short.MAX_VALUE;
                intArray[j] = val;
                shortArray[j] = (short)val;
            }
            if (shortSafe) {
                list.add(new ShortListWrapper(shortArray));
                continue;
            }
            list.add(Ints.asList((int[])intArray));
        }
        in.close();
        return list;
    }

    public static List<Integer> getMemoryEfficientIntArray(List<Integer> otherArray) {
        int listSize = otherArray.size();
        int[] intArray = new int[listSize];
        short[] shortArray = new short[listSize];
        boolean shortSafe = true;
        for (int j = 0; j < listSize; ++j) {
            int val = otherArray.get(j);
            shortSafe = shortSafe && (val >= 0 && val < Short.MAX_VALUE || val < 0 && -val < Short.MAX_VALUE);
            intArray[j] = val;
            shortArray[j] = (short)val;
        }
        if (shortSafe) {
            return new ShortListWrapper(shortArray);
        }
        return Ints.asList((int[])intArray);
    }

    public static void intArraysListToFile(List<int[]> list, File file) throws IOException {
        Preconditions.checkNotNull(list, (Object)"list cannot be null!");
        Preconditions.checkArgument((!list.isEmpty() ? 1 : 0) != 0, (Object)"list cannot be empty!");
        DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
        out.writeInt(list.size());
        for (int[] ints : list) {
            Preconditions.checkNotNull((Object)ints, (Object)"list cannot be null!");
            out.writeInt(ints.length);
            for (int val : ints) {
                out.writeInt(val);
            }
        }
        out.close();
    }

    public static List<int[]> intArraysListFromFile(File file) throws IOException {
        Preconditions.checkNotNull((Object)file, (Object)"File cannot be null!");
        Preconditions.checkArgument((boolean)file.exists(), (Object)"File doesn't exist!");
        long len = file.length();
        Preconditions.checkState((len > 0L ? 1 : 0) != 0, (Object)"file is empty!");
        Preconditions.checkState((len % 4L == 0L ? 1 : 0) != 0, (Object)"file size isn't evenly divisible by 4, thus not a sequence of double & integer values.");
        return MatrixIO.intArraysListFromInputStream(new FileInputStream(file));
    }

    public static List<int[]> intArraysListFromInputStream(InputStream is) throws IOException {
        DataInputStream in;
        int size;
        Preconditions.checkNotNull((Object)is, (Object)"InputStream cannot be null!");
        if (!(is instanceof BufferedInputStream)) {
            is = new BufferedInputStream(is);
        }
        Preconditions.checkState(((size = (in = new DataInputStream(is)).readInt()) > 0 ? 1 : 0) != 0, (Object)"Size must be > 0!");
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < size; ++i) {
            int listSize = in.readInt();
            int[] intArray = new int[listSize];
            for (int j = 0; j < listSize; ++j) {
                int val;
                intArray[j] = val = in.readInt();
            }
            list.add(intArray);
        }
        in.close();
        return list;
    }

    private static class ShortListWrapper
    extends AbstractList<Integer> {
        private short[] vals;

        public ShortListWrapper(short[] vals) {
            this.vals = vals;
        }

        @Override
        public Integer get(int index) {
            return this.vals[index];
        }

        @Override
        public int size() {
            return this.vals.length;
        }
    }
}

